# .NET Core 2.1.2

.NET Core 2.1.2 comprises:

* .NET Core Runtime 2.1.2 ([release notes](../2.1/2.1.2.md))
* .NET Core SDK 2.1.302

|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   | ASPNET Core Runtime |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: | :-----------------: |
| Windows | [32-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-x86.exe) / [64-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-x86.zip) / [64-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-win-x64.zip) | [32-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x86.exe) / [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x64.exe) | [32-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x86.zip) / [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x64.zip) |
| macOS   | [64-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-osx-x64.pkg)  | [64-bit](https://dotnetcli.blob.core.windows.net/dotnet/Sdk/2.1.302/dotnet-sdk-2.1.302-osx-x64.tar.gz)| [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-osx-x64.pkg)      | [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-osx-x64.tar.gz)   |
| Linux (for glibc based OS) | [See installations steps below](https://www.microsoft.com/net/download/linux)                         | [64-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-linux-x64.tar.gz)     | - | [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-x64.tar.gz) |  [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-linux-x64.tar.gz) |
| Linux ARM (for musl based OS, such as Alpine) | -             | [64-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-linux-musl-x64.tar.gz)     | - | [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-musl-x64.tar.gz) | [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-linux-musl-x64.tar.gz) |
| Linux ARM | -             | [32-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-linux-arm.tar.gz) / [64-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-linux-arm64.tar.gz)| - | [32-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-arm.tar.gz) / [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-arm64.tar.gz) | [32-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-linux-arm.tar.gz) |
| RHEL6 | -                 | [64-bit](https://download.microsoft.com/download/4/0/9/40920432-3302-47a8-b13c-bbc4848ad114/dotnet-sdk-2.1.302-rhel.6-x64.tar.gz)    | - | [64-bit](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-rhel.6-x64.tar.gz) |

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.2-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.302-sdk-sha.txt)

**Debug Symbols**

* [Runtime](https://download.microsoft.com/download/1/F/7/1F7755C5-934D-4638-B89F-1F4FFA5AFE89/coreclr-2.1.2-symbols.zip)
* [Shared Framework](https://download.microsoft.com/download/1/F/7/1F7755C5-934D-4638-B89F-1F4FFA5AFE89/corefx-2.1.2-symbols.zip)
* [Setup](https://download.microsoft.com/download/1/F/7/1F7755C5-934D-4638-B89F-1F4FFA5AFE89/core-setup-2.1.2-symbols.zip)
* [ASP.NET Core](https://download.microsoft.com/download/1/F/7/1F7755C5-934D-4638-B89F-1F4FFA5AFE89/aspnet-2.1.2-symbols.zip)

## Docker

Images for .NET Core 2.1.2 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).

## Installing .NET Core on Linux

Instructions for installing using your package manager can be found on the [dotnet-core](https://www.microsoft.com/net/download/linux) site.

## Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1.2` using your package manager.

## Server Hosting

If you are looking to host stand-alone apps on Servers, the following installers can be used on Windows and Linx systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.2-win.exe](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-hosting-2.1.2-win.exe)

This will install the ASP.NET Core Module for IIS

### Linux

On supported Linux systems, register the Microsoft Product feed as described above and install `aspnetcore-runtime-2.1` using your package manager. This will also install or update the .NET Core Runtime and other required packages.

### ASP.NET Core Runtime

The ASP.NET Core Runtime is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the ASP.NET Runtime separately, the following can be used.

* [aspnetcore-runtime-2.1.2-win-x64.exe](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x64.exe)
* [aspnetcore-runtime-2.1.2-win-x86.exe](https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x86.exe)

On Linux systems install `aspnetcore-runtime-2.1.2` using your package manager. This will install both the ASP.NET Core and .NET Core runtime components.
