# .NET Core Repos

There are many repos that make up .NET Core. To file an issue, make a PR, or engage on specific topics, it is best to engage with developers working on the right repo. A largely complete set of .NET Core repositories follows.

## .NET Core

* [dotnet/cli](https://github.com/dotnet/cli) - .NET Core CLI tools
* [dotnet/core-setup](https://github.com/dotnet/core-setup) - .NET Core Runtime Installers and application model
* [dotnet/corefx](https://github.com/dotnet/corefx) - .NET Core APIs
* [dotnet/coreclr](https://github.com/dotnet/coreclr) - .NET Core runtime
* [dotnet/docs](https://github.com/dotnet/docs) - .NET documentation
* [dotnet/sdk](https://github.com/dotnet/sdk) - .NET Core SDK (used by Visual Studio and CLI)
* [dotnet/dotnet-docker](https://github.com/dotnet/dotnet-docker) - .NET Core Docker images
* [dotnet/wpf](https://github.com/dotnet/wpf) - Windows Presentation Foundation
* [dotnet/winforms](https://github.com/dotnet/winforms) - Windows Forms

## .NET Standard

* [dotnet/standard](https://github.com/dotnet/standard) - .NET Standard definition

## Languages

* [dotnet/roslyn](https://github.com/dotnet/roslyn) - Roslyn and C#
* [dotnet/csharplang](https://github.com/dotnet/csharplang) - C# spec
* [dotnet/vblang](https://github.com/dotnet/vblang) - VB spec

## NuGet

* [nuget/home](https://github.com/nuget/home) - NuGet client

## ASP.NET Core

* [aspnet/home](https://github.com/aspnet/home) - ASP.NET Core framework
* [aspnet/Docs](https://github.com/aspnet/Docs) - ASP.NET and ASP.NET Core documentation

## WCF
* [dotnet/wcf](https://github.com/dotnet/wcf) - WCF

## .NET Framework
* [microsoft/dotnet](https://github.com/microsoft/dotnet) - catch-all repository for .NET (where most .NET Framework issues are filed)
* [microsoft/dotnet-framework-docker](https://github.com/microsoft/dotnet-framework-docker) - .NET Framework Docker images
