# .NET Core 1.x - Supported OS versions

The tables below provide OS version information supported by .NET Core 1.x.

* A '+' indicates the minimum supported version.
* Where possible, links to Distribution-owned lifecycle documentation is provided.

## Windows

OS                            | Version                        | Architectures| Notes
------------------------------|--------------------------------|--------------|-----
Windows Client                | 7 SP1+, 8.1                  | x64, x86       |
Windows 10 Client             | Version 1607+                 | x64, x86       |
Windows Server                | 2008 R2 SP1 - 2016*            | x64, x86     |

\* Supported by latest patch release of .NET Core 1.1

See the [Windows Lifecycle Fact Sheet](https://support.microsoft.com/en-us/help/13853/windows-lifecycle-fact-sheet) for details regarding each Windows release lifecycle.

## macOS

OS                            | Version                        | Architectures| Notes
------------------------------|--------------------------------|--------------|-----
Mac OS X                      | 10.11, 10.12*                  | x64          | [Apple Support Sitemap](https://support.apple.com/sitemap) <br> [Apple Security Updates](https://support.apple.com/en-us/HT201222)

\* Supported by latest patch release of .NET Core 1.0

## Linux

OS                            | Version                        | Architectures| Notes
------------------------------|--------------------------------|--------------|-----
Red Hat Enterprise Linux <br> CentOS <br> Oracle Linux | 7     | x64          | [Red Hat support policy](https://access.redhat.com/support/policy/updates/errata/) <br> [CentOS lifecycle](https://wiki.centos.org/FAQ/General#head-fe8a0be91ee3e7dea812e8694491e1dde5b75e6d) <br> [Oracle Linux lifecycle](http://www.oracle.com/us/support/library/elsp-lifetime-069338.pdf)
Fedora                        | 27, 28 (1.1)                   | x64          | [Fedora lifecycle](https://fedoraproject.org/wiki/End_of_life)
Debian                        | 8.2+                           | x64          | [Debian lifecycle](https://wiki.debian.org/DebianReleases)
Ubuntu <br> Linux Mint        | 16.04, 18.04 (1.1) <br> 17     | x64    | [Ubuntu lifecycle](https://wiki.ubuntu.com/Releases) <br> [Linux Mint end of life announcements](https://forums.linuxmint.com/search.php?keywords=%22end+of+life%22&terms=all&author=&sc=1&sf=titleonly&sr=posts&sk=t&sd=d&st=0&ch=300&t=0&submit=Search)
openSUSE                      | 42.3+ (1.1)                    | x64          | [OpenSUSE lifecycle](https://en.opensuse.org/Lifetime)

* \* Supported by the latest patch release of .NET Core 1.1
* **Bold numbers** indicate additions to this release.
* '+' indicates the minimum supported version.

## Out of support OS versions

Support for the following versions was ended by the distribution owners and are [not supported by .NET Core 1.x](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md).

OS         | Version  | End of Life
-----------|----------|-------------
Fedora     | 26       | [May 2018](https://fedoramagazine.org/fedora-26-end-life/)
Fedora     | 25       | [December 2017](https://fedoramagazine.org/fedora-25-end-life/)
Fedora     | 24       | [August 2017](https://fedoramagazine.org/fedora-24-eol/)
Fedora     | 23       | [December 20, 2016](https://lists.fedoraproject.org/archives/list/announce@lists.fedoraproject.org/thread/OHFCBTYXAO6NBH5BZZI3VIMIIL2ODFP5/)
openSUSE   | 13.2     | [January 18, 2017](https://lists.opensuse.org/opensuse-security-announce/2017-01/msg00033.html)
openSUSE   | 42.1     | [May 17, 2017](https://lists.opensuse.org/opensuse-security-announce/2017-05/msg00053.html)
Ubuntu     | 17.10    | [July 2018](https://lists.ubuntu.com/archives/ubuntu-announce/2018-July/000232.html)
Ubuntu     | 16.10    | [July 2017](https://lists.ubuntu.com/archives/ubuntu-announce/2017-July/000223.html)
Ubuntu     | 14.04    | [06/2019](https://wiki.ubuntu.com/Releases)