# System.Collections.Concurrent

``` diff
+namespace System.Collections.Concurrent {
+    public class BlockingCollection<T> : ICollection, IDisposable, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
+        public BlockingCollection();
+        public BlockingCollection(IProducerConsumerCollection<T> collection);
+        public BlockingCollection(IProducerConsumerCollection<T> collection, int boundedCapacity);
+        public BlockingCollection(int boundedCapacity);
+        public int BoundedCapacity { get; }
+        public int Count { get; }
+        public bool IsAddingCompleted { get; }
+        public bool IsCompleted { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public void Add(T item);
+        public void Add(T item, CancellationToken cancellationToken);
+        public static int AddToAny(BlockingCollection<T>[] collections, T item);
+        public static int AddToAny(BlockingCollection<T>[] collections, T item, CancellationToken cancellationToken);
+        public void CompleteAdding();
+        public void CopyTo(T[] array, int index);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public IEnumerable<T> GetConsumingEnumerable();
+        public IEnumerable<T> GetConsumingEnumerable(CancellationToken cancellationToken);
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public T Take();
+        public T Take(CancellationToken cancellationToken);
+        public static int TakeFromAny(BlockingCollection<T>[] collections, out T item);
+        public static int TakeFromAny(BlockingCollection<T>[] collections, out T item, CancellationToken cancellationToken);
+        public T[] ToArray();
+        public bool TryAdd(T item);
+        public bool TryAdd(T item, int millisecondsTimeout);
+        public bool TryAdd(T item, int millisecondsTimeout, CancellationToken cancellationToken);
+        public bool TryAdd(T item, TimeSpan timeout);
+        public static int TryAddToAny(BlockingCollection<T>[] collections, T item);
+        public static int TryAddToAny(BlockingCollection<T>[] collections, T item, int millisecondsTimeout);
+        public static int TryAddToAny(BlockingCollection<T>[] collections, T item, int millisecondsTimeout, CancellationToken cancellationToken);
+        public static int TryAddToAny(BlockingCollection<T>[] collections, T item, TimeSpan timeout);
+        public bool TryTake(out T item);
+        public bool TryTake(out T item, int millisecondsTimeout);
+        public bool TryTake(out T item, int millisecondsTimeout, CancellationToken cancellationToken);
+        public bool TryTake(out T item, TimeSpan timeout);
+        public static int TryTakeFromAny(BlockingCollection<T>[] collections, out T item);
+        public static int TryTakeFromAny(BlockingCollection<T>[] collections, out T item, int millisecondsTimeout);
+        public static int TryTakeFromAny(BlockingCollection<T>[] collections, out T item, int millisecondsTimeout, CancellationToken cancellationToken);
+        public static int TryTakeFromAny(BlockingCollection<T>[] collections, out T item, TimeSpan timeout);
+    }
+    public class ConcurrentBag<T> : ICollection, IEnumerable, IEnumerable<T>, IProducerConsumerCollection<T>, IReadOnlyCollection<T> {
+        public ConcurrentBag();
+        public ConcurrentBag(IEnumerable<T> collection);
+        public int Count { get; }
+        public bool IsEmpty { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public void Add(T item);
+        public void CopyTo(T[] array, int index);
+        public IEnumerator<T> GetEnumerator();
+        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryAdd(T item);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public T[] ToArray();
+        public bool TryPeek(out T result);
+        public bool TryTake(out T result);
+    }
+    public class ConcurrentDictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
+        public ConcurrentDictionary();
+        public ConcurrentDictionary(IEnumerable<KeyValuePair<TKey, TValue>> collection);
+        public ConcurrentDictionary(IEnumerable<KeyValuePair<TKey, TValue>> collection, IEqualityComparer<TKey> comparer);
+        public ConcurrentDictionary(IEqualityComparer<TKey> comparer);
+        public ConcurrentDictionary(int concurrencyLevel, IEnumerable<KeyValuePair<TKey, TValue>> collection, IEqualityComparer<TKey> comparer);
+        public ConcurrentDictionary(int concurrencyLevel, int capacity);
+        public ConcurrentDictionary(int concurrencyLevel, int capacity, IEqualityComparer<TKey> comparer);
+        public int Count { get; }
+        public bool IsEmpty { get; }
+        public ICollection<TKey> Keys { get; }
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
+        IEnumerable<TKey> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Keys { get; }
+        IEnumerable<TValue> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Values { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IDictionary.IsFixedSize { get; }
+        bool System.Collections.IDictionary.IsReadOnly { get; }
+        object System.Collections.IDictionary.this[object key] { get; set; }
+        ICollection System.Collections.IDictionary.Keys { get; }
+        ICollection System.Collections.IDictionary.Values { get; }
+        public TValue this[TKey key] { get; set; }
+        public ICollection<TValue> Values { get; }
+        public TValue AddOrUpdate(TKey key, Func<TKey, TValue> addValueFactory, Func<TKey, TValue, TValue> updateValueFactory);
+        public TValue AddOrUpdate(TKey key, TValue addValue, Func<TKey, TValue, TValue> updateValueFactory);
+        public void Clear();
+        public bool ContainsKey(TKey key);
+        public IEnumerator<KeyValuePair<TKey, TValue>> GetEnumerator();
+        public TValue GetOrAdd(TKey key, Func<TKey, TValue> valueFactory);
+        public TValue GetOrAdd(TKey key, TValue value);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Add(KeyValuePair<TKey, TValue> keyValuePair);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Contains(KeyValuePair<TKey, TValue> keyValuePair);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int index);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Remove(KeyValuePair<TKey, TValue> keyValuePair);
+        void System.Collections.Generic.IDictionary<TKey,TValue>.Add(TKey key, TValue value);
+        bool System.Collections.Generic.IDictionary<TKey,TValue>.Remove(TKey key);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        void System.Collections.IDictionary.Add(object key, object value);
+        bool System.Collections.IDictionary.Contains(object key);
+        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
+        void System.Collections.IDictionary.Remove(object key);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public KeyValuePair<TKey, TValue>[] ToArray();
+        public bool TryAdd(TKey key, TValue value);
+        public bool TryGetValue(TKey key, out TValue value);
+        public bool TryRemove(TKey key, out TValue value);
+        public bool TryUpdate(TKey key, TValue newValue, TValue comparisonValue);
+    }
+    public class ConcurrentQueue<T> : ICollection, IEnumerable, IEnumerable<T>, IProducerConsumerCollection<T>, IReadOnlyCollection<T> {
+        public ConcurrentQueue();
+        public ConcurrentQueue(IEnumerable<T> collection);
+        public int Count { get; }
+        public bool IsEmpty { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public void CopyTo(T[] array, int index);
+        public void Enqueue(T item);
+        public IEnumerator<T> GetEnumerator();
+        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryAdd(T item);
+        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryTake(out T item);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public T[] ToArray();
+        public bool TryDequeue(out T result);
+        public bool TryPeek(out T result);
+    }
+    public class ConcurrentStack<T> : ICollection, IEnumerable, IEnumerable<T>, IProducerConsumerCollection<T>, IReadOnlyCollection<T> {
+        public ConcurrentStack();
+        public ConcurrentStack(IEnumerable<T> collection);
+        public int Count { get; }
+        public bool IsEmpty { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public void Clear();
+        public void CopyTo(T[] array, int index);
+        public IEnumerator<T> GetEnumerator();
+        public void Push(T item);
+        public void PushRange(T[] items);
+        public void PushRange(T[] items, int startIndex, int count);
+        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryAdd(T item);
+        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryTake(out T item);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public T[] ToArray();
+        public bool TryPeek(out T result);
+        public bool TryPop(out T result);
+        public int TryPopRange(T[] items);
+        public int TryPopRange(T[] items, int startIndex, int count);
+    }
+    public enum EnumerablePartitionerOptions {
+        NoBuffering = 1,
+        None = 0,
+    }
+    public interface IProducerConsumerCollection<T> : ICollection, IEnumerable, IEnumerable<T> {
+        void CopyTo(T[] array, int index);
+        T[] ToArray();
+        bool TryAdd(T item);
+        bool TryTake(out T item);
+    }
+    public abstract class OrderablePartitioner<TSource> : Partitioner<TSource> {
+        protected OrderablePartitioner(bool keysOrderedInEachPartition, bool keysOrderedAcrossPartitions, bool keysNormalized);
+        public bool KeysNormalized { get; }
+        public bool KeysOrderedAcrossPartitions { get; }
+        public bool KeysOrderedInEachPartition { get; }
+        public override IEnumerable<TSource> GetDynamicPartitions();
+        public virtual IEnumerable<KeyValuePair<long, TSource>> GetOrderableDynamicPartitions();
+        public abstract IList<IEnumerator<KeyValuePair<long, TSource>>> GetOrderablePartitions(int partitionCount);
+        public override IList<IEnumerator<TSource>> GetPartitions(int partitionCount);
+    }
+    public static class Partitioner {
+        public static OrderablePartitioner<Tuple<int, int>> Create(int fromInclusive, int toExclusive);
+        public static OrderablePartitioner<Tuple<int, int>> Create(int fromInclusive, int toExclusive, int rangeSize);
+        public static OrderablePartitioner<Tuple<long, long>> Create(long fromInclusive, long toExclusive);
+        public static OrderablePartitioner<Tuple<long, long>> Create(long fromInclusive, long toExclusive, long rangeSize);
+        public static OrderablePartitioner<TSource> Create<TSource>(IEnumerable<TSource> source);
+        public static OrderablePartitioner<TSource> Create<TSource>(IEnumerable<TSource> source, EnumerablePartitionerOptions partitionerOptions);
+        public static OrderablePartitioner<TSource> Create<TSource>(IList<TSource> list, bool loadBalance);
+        public static OrderablePartitioner<TSource> Create<TSource>(TSource[] array, bool loadBalance);
+    }
+    public abstract class Partitioner<TSource> {
+        protected Partitioner();
+        public virtual bool SupportsDynamicPartitions { get; }
+        public virtual IEnumerable<TSource> GetDynamicPartitions();
+        public abstract IList<IEnumerator<TSource>> GetPartitions(int partitionCount);
+    }
+}
```

