# System.Diagnostics

``` diff
+namespace System.Diagnostics {
+    public class BooleanSwitch : Switch {
+        public BooleanSwitch(string displayName, string description);
+        public BooleanSwitch(string displayName, string description, string defaultSwitchValue);
+        public bool Enabled { get; set; }
+        protected override void OnValueChanged();
+    }
+    public sealed class ConditionalAttribute : Attribute {
+        public ConditionalAttribute(string conditionString);
+        public string ConditionString { get; }
+    }
+    public class DataReceivedEventArgs : EventArgs {
+        public string Data { get; }
+    }
+    public delegate void DataReceivedEventHandler(object sender, DataReceivedEventArgs e);
+    public static class Debug {
+        public static void Assert(bool condition);
+        public static void Assert(bool condition, string message);
+        public static void Assert(bool condition, string message, string detailMessage);
+        public static void Assert(bool condition, string message, string detailMessageFormat, params object[] args);
+        public static void Fail(string message);
+        public static void Fail(string message, string detailMessage);
+        public static void Write(object value);
+        public static void Write(object value, string category);
+        public static void Write(string message);
+        public static void Write(string message, string category);
+        public static void WriteIf(bool condition, object value);
+        public static void WriteIf(bool condition, object value, string category);
+        public static void WriteIf(bool condition, string message);
+        public static void WriteIf(bool condition, string message, string category);
+        public static void WriteLine(object value);
+        public static void WriteLine(object value, string category);
+        public static void WriteLine(string message);
+        public static void WriteLine(string format, params object[] args);
+        public static void WriteLine(string message, string category);
+        public static void WriteLineIf(bool condition, object value);
+        public static void WriteLineIf(bool condition, object value, string category);
+        public static void WriteLineIf(bool condition, string message);
+        public static void WriteLineIf(bool condition, string message, string category);
+    }
+    public sealed class DebuggableAttribute : Attribute {
+        public DebuggableAttribute(DebuggableAttribute.DebuggingModes modes);
+        public DebuggableAttribute(bool isJITTrackingEnabled, bool isJITOptimizerDisabled);
+        public enum DebuggingModes {
+            Default = 1,
+            DisableOptimizations = 256,
+            EnableEditAndContinue = 4,
+            IgnoreSymbolStoreSequencePoints = 2,
+            None = 0,
+        }
+    }
+    public sealed class Debugger {
+        public Debugger();
+        public static bool IsAttached { [MethodImpl(InternalCall)]get; }
+        public static void Break();
+        [MethodImpl(InternalCall)]public static bool IsLogging();
+        public static bool Launch();
+        [MethodImpl(InternalCall)]public static void Log(int level, string category, string message);
+        public static void NotifyOfCrossThreadDependency();
+    }
+    public sealed class DebuggerBrowsableAttribute : Attribute {
+        public DebuggerBrowsableAttribute(DebuggerBrowsableState state);
+        public DebuggerBrowsableState State { get; }
+    }
+    public enum DebuggerBrowsableState {
+        Collapsed = 2,
+        Never = 0,
+        RootHidden = 3,
+    }
+    public sealed class DebuggerDisplayAttribute : Attribute {
+        public DebuggerDisplayAttribute(string value);
+        public string Name { get; set; }
+        public Type Target { get; set; }
+        public string TargetTypeName { get; set; }
+        public string Type { get; set; }
+        public string Value { get; }
+    }
+    public sealed class DebuggerHiddenAttribute : Attribute {
+        public DebuggerHiddenAttribute();
+    }
+    public sealed class DebuggerNonUserCodeAttribute : Attribute {
+        public DebuggerNonUserCodeAttribute();
+    }
+    public sealed class DebuggerStepThroughAttribute : Attribute {
+        public DebuggerStepThroughAttribute();
+    }
+    public sealed class DebuggerTypeProxyAttribute : Attribute {
+        public DebuggerTypeProxyAttribute(string typeName);
+        public DebuggerTypeProxyAttribute(Type type);
+        public string ProxyTypeName { get; }
+        public Type Target { get; set; }
+        public string TargetTypeName { get; set; }
+    }
+    public class DefaultTraceListener : TraceListener {
+        public DefaultTraceListener();
+        public override void Fail(string message);
+        public override void Fail(string message, string detailMessage);
+        public override void Write(string message);
+        public override void WriteLine(string message);
+    }
+    public class DelimitedListTraceListener : TextWriterTraceListener {
+        public DelimitedListTraceListener(Stream stream);
+        public DelimitedListTraceListener(Stream stream, string name);
+        public DelimitedListTraceListener(TextWriter writer);
+        public DelimitedListTraceListener(TextWriter writer, string name);
+        public string Delimiter { get; set; }
+        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, object data);
+        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, params object[] data);
+        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string message);
+        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args);
+    }
+    public class DiagnosticListener : DiagnosticSource, IDisposable, IObservable<KeyValuePair<string, object>> {
+        public DiagnosticListener(string name);
+        public static IObservable<DiagnosticListener> AllListeners { get; }
+        public string Name { get; private set; }
+        public virtual void Dispose();
+        public override bool IsEnabled(string name);
+        public IDisposable Subscribe(IObserver<KeyValuePair<string, object>> observer);
+        public virtual IDisposable Subscribe(IObserver<KeyValuePair<string, object>> observer, Predicate<string> isEnabled);
+        public override string ToString();
+        public override void Write(string name, object value);
+    }
+    public abstract class DiagnosticSource {
+        protected DiagnosticSource();
+        public abstract bool IsEnabled(string name);
+        public abstract void Write(string name, object value);
+    }
+    public class EventTypeFilter : TraceFilter {
+        public EventTypeFilter(SourceLevels level);
+        public SourceLevels EventType { get; set; }
+        public override bool ShouldTrace(TraceEventCache cache, string source, TraceEventType eventType, int id, string formatOrMessage, object[] args, object data1, object[] data);
+    }
+    public sealed class FileVersionInfo {
+        public string Comments { get; }
+        public string CompanyName { get; }
+        public int FileBuildPart { get; }
+        public string FileDescription { get; }
+        public int FileMajorPart { get; }
+        public int FileMinorPart { get; }
+        public string FileName { get; }
+        public int FilePrivatePart { get; }
+        public string FileVersion { get; }
+        public string InternalName { get; }
+        public bool IsDebug { get; }
+        public bool IsPatched { get; }
+        public bool IsPreRelease { get; }
+        public bool IsPrivateBuild { get; }
+        public bool IsSpecialBuild { get; }
+        public string Language { get; }
+        public string LegalCopyright { get; }
+        public string LegalTrademarks { get; }
+        public string OriginalFilename { get; }
+        public string PrivateBuild { get; }
+        public int ProductBuildPart { get; }
+        public int ProductMajorPart { get; }
+        public int ProductMinorPart { get; }
+        public string ProductName { get; }
+        public int ProductPrivatePart { get; }
+        public string ProductVersion { get; }
+        public string SpecialBuild { get; }
+        public static FileVersionInfo GetVersionInfo(string fileName);
+        public override string ToString();
+    }
+    public class Process : IDisposable {
+        public Process();
+        public int BasePriority { get; }
+        public bool EnableRaisingEvents { get; set; }
+        public int ExitCode { get; }
+        public DateTime ExitTime { get; }
+        public bool HasExited { get; }
+        public int Id { get; }
+        public string MachineName { get; }
+        public ProcessModule MainModule { get; }
+        public IntPtr MaxWorkingSet { get; set; }
+        public IntPtr MinWorkingSet { get; set; }
+        public ProcessModuleCollection Modules { get; }
+        public long NonpagedSystemMemorySize64 { get; }
+        public long PagedMemorySize64 { get; }
+        public long PagedSystemMemorySize64 { get; }
+        public long PeakPagedMemorySize64 { get; }
+        public long PeakVirtualMemorySize64 { get; }
+        public long PeakWorkingSet64 { get; }
+        public bool PriorityBoostEnabled { get; set; }
+        public ProcessPriorityClass PriorityClass { get; set; }
+        public long PrivateMemorySize64 { get; }
+        public TimeSpan PrivilegedProcessorTime { get; }
+        public string ProcessName { get; }
+        public IntPtr ProcessorAffinity { get; set; }
+        public SafeProcessHandle SafeHandle { get; }
+        public int SessionId { get; }
+        public StreamReader StandardError { get; }
+        public StreamWriter StandardInput { get; }
+        public StreamReader StandardOutput { get; }
+        public ProcessStartInfo StartInfo { get; set; }
+        public DateTime StartTime { get; }
+        public ProcessThreadCollection Threads { get; }
+        public TimeSpan TotalProcessorTime { get; }
+        public TimeSpan UserProcessorTime { get; }
+        public long VirtualMemorySize64 { get; }
+        public long WorkingSet64 { get; }
+        public event DataReceivedEventHandler ErrorDataReceived;
+        public event EventHandler Exited;
+        public event DataReceivedEventHandler OutputDataReceived;
+        public void BeginErrorReadLine();
+        public void BeginOutputReadLine();
+        public void CancelErrorRead();
+        public void CancelOutputRead();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public static void EnterDebugMode();
+        public static Process GetCurrentProcess();
+        public static Process GetProcessById(int processId);
+        public static Process GetProcessById(int processId, string machineName);
+        public static Process[] GetProcesses();
+        public static Process[] GetProcesses(string machineName);
+        public static Process[] GetProcessesByName(string processName);
+        public static Process[] GetProcessesByName(string processName, string machineName);
+        public void Kill();
+        public static void LeaveDebugMode();
+        protected void OnExited();
+        public void Refresh();
+        public bool Start();
+        public static Process Start(ProcessStartInfo startInfo);
+        public static Process Start(string fileName);
+        public static Process Start(string fileName, string arguments);
+        public void WaitForExit();
+        public bool WaitForExit(int milliseconds);
+    }
+    public class ProcessModule {
+        public IntPtr BaseAddress { get; }
+        public IntPtr EntryPointAddress { get; }
+        public string FileName { get; }
+        public int ModuleMemorySize { get; }
+        public string ModuleName { get; }
+        public override string ToString();
+    }
+    public class ProcessModuleCollection : ICollection, IEnumerable {
+        protected ProcessModuleCollection();
+        public ProcessModuleCollection(ProcessModule[] processModules);
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public ProcessModule this[int index] { get; }
+        public bool Contains(ProcessModule module);
+        public void CopyTo(ProcessModule[] array, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(ProcessModule module);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+    }
+    public enum ProcessPriorityClass {
+        AboveNormal = 32768,
+        BelowNormal = 16384,
+        High = 128,
+        Idle = 64,
+        Normal = 32,
+        RealTime = 256,
+    }
+    public sealed class ProcessStartInfo {
+        public ProcessStartInfo();
+        public ProcessStartInfo(string fileName);
+        public ProcessStartInfo(string fileName, string arguments);
+        public string Arguments { get; set; }
+        public bool CreateNoWindow { get; set; }
+        public string Domain { get; set; }
+        public IDictionary<string, string> Environment { get; }
+        public string FileName { get; set; }
+        public bool LoadUserProfile { get; set; }
+        public string PasswordInClearText { get; set; }
+        public bool RedirectStandardError { get; set; }
+        public bool RedirectStandardInput { get; set; }
+        public bool RedirectStandardOutput { get; set; }
+        public Encoding StandardErrorEncoding { get; set; }
+        public Encoding StandardOutputEncoding { get; set; }
+        public string UserName { get; set; }
+        public bool UseShellExecute { get; set; }
+        public string WorkingDirectory { get; set; }
+    }
+    public class ProcessThread {
+        public int BasePriority { get; }
+        public int CurrentPriority { get; }
+        public int Id { get; }
+        public int IdealProcessor { set; }
+        public bool PriorityBoostEnabled { get; set; }
+        public ThreadPriorityLevel PriorityLevel { get; set; }
+        public TimeSpan PrivilegedProcessorTime { get; }
+        public IntPtr ProcessorAffinity { set; }
+        public IntPtr StartAddress { get; }
+        public DateTime StartTime { get; }
+        public ThreadState ThreadState { get; }
+        public TimeSpan TotalProcessorTime { get; }
+        public TimeSpan UserProcessorTime { get; }
+        public ThreadWaitReason WaitReason { get; }
+        public void ResetIdealProcessor();
+    }
+    public class ProcessThreadCollection : ICollection, IEnumerable {
+        protected ProcessThreadCollection();
+        public ProcessThreadCollection(ProcessThread[] processThreads);
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public ProcessThread this[int index] { get; }
+        public int Add(ProcessThread thread);
+        public bool Contains(ProcessThread thread);
+        public void CopyTo(ProcessThread[] array, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(ProcessThread thread);
+        public void Insert(int index, ProcessThread thread);
+        public void Remove(ProcessThread thread);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+    }
+    public class SourceFilter : TraceFilter {
+        public SourceFilter(string source);
+        public string Source { get; set; }
+        public override bool ShouldTrace(TraceEventCache cache, string source, TraceEventType eventType, int id, string formatOrMessage, object[] args, object data1, object[] data);
+    }
+    public enum SourceLevels {
+        All = -1,
+        Critical = 1,
+        Error = 3,
+        Information = 15,
+        Off = 0,
+        Verbose = 31,
+        Warning = 7,
+    }
+    public class SourceSwitch : Switch {
+        public SourceSwitch(string name);
+        public SourceSwitch(string displayName, string defaultSwitchValue);
+        public SourceLevels Level { get; set; }
+        protected override void OnValueChanged();
+        public bool ShouldTrace(TraceEventType eventType);
+    }
+    public class StackFrame {
+        public const int OFFSET_UNKNOWN = -1;
+        public StackFrame();
+        public StackFrame(bool fNeedFileInfo);
+        public StackFrame(int skipFrames);
+        public StackFrame(int skipFrames, bool fNeedFileInfo);
+        public StackFrame(string fileName, int lineNumber);
+        public StackFrame(string fileName, int lineNumber, int colNumber);
+        public virtual int GetFileColumnNumber();
+        public virtual int GetFileLineNumber();
+        public virtual string GetFileName();
+        public virtual int GetILOffset();
+        public virtual MethodBase GetMethod();
+        public virtual int GetNativeOffset();
+        public override string ToString();
+    }
+    public static class StackFrameExtensions {
+        public static IntPtr GetNativeImageBase(this StackFrame stackFrame);
+        public static IntPtr GetNativeIP(this StackFrame stackFrame);
+        public static bool HasILOffset(this StackFrame stackFrame);
+        public static bool HasMethod(this StackFrame stackFrame);
+        public static bool HasNativeImage(this StackFrame stackFrame);
+        public static bool HasSource(this StackFrame stackFrame);
+    }
+    public class StackTrace {
+        public const int METHODS_TO_SKIP = 0;
+        public StackTrace();
+        public StackTrace(bool fNeedFileInfo);
+        public StackTrace(StackFrame frame);
+        public StackTrace(Exception e);
+        public StackTrace(Exception e, bool fNeedFileInfo);
+        public StackTrace(Exception e, int skipFrames);
+        public StackTrace(Exception e, int skipFrames, bool fNeedFileInfo);
+        public StackTrace(int skipFrames);
+        public StackTrace(int skipFrames, bool fNeedFileInfo);
+        public StackTrace(Thread targetThread, bool needFileInfo);
+        public virtual int FrameCount { get; }
+        public virtual StackFrame GetFrame(int index);
+        public virtual StackFrame[] GetFrames();
+        public override string ToString();
+    }
+    public class Stopwatch {
+        public static readonly bool IsHighResolution;
+        public static readonly long Frequency;
+        public Stopwatch();
+        public TimeSpan Elapsed { get; }
+        public long ElapsedMilliseconds { get; }
+        public long ElapsedTicks { get; }
+        public bool IsRunning { get; }
+        public static long GetTimestamp();
+        public void Reset();
+        public void Restart();
+        public void Start();
+        public static Stopwatch StartNew();
+        public void Stop();
+    }
+    public abstract class Switch {
+        protected Switch(string displayName, string description);
+        protected Switch(string displayName, string description, string defaultSwitchValue);
+        public string Description { get; }
+        public string DisplayName { get; }
+        protected int SwitchSetting { get; set; }
+        protected string Value { get; set; }
+        protected virtual void OnSwitchSettingChanged();
+        protected virtual void OnValueChanged();
+    }
+    public class TextWriterTraceListener : TraceListener {
+        public TextWriterTraceListener();
+        public TextWriterTraceListener(Stream stream);
+        public TextWriterTraceListener(Stream stream, string name);
+        public TextWriterTraceListener(TextWriter writer);
+        public TextWriterTraceListener(TextWriter writer, string name);
+        public TextWriter Writer { get; set; }
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override void Write(string message);
+        public override void WriteLine(string message);
+    }
+    public enum ThreadPriorityLevel {
+        AboveNormal = 1,
+        BelowNormal = -1,
+        Highest = 2,
+        Idle = -15,
+        Lowest = -2,
+        Normal = 0,
+        TimeCritical = 15,
+    }
+    public enum ThreadState {
+        Initialized = 0,
+        Ready = 1,
+        Running = 2,
+        Standby = 3,
+        Terminated = 4,
+        Transition = 6,
+        Unknown = 7,
+        Wait = 5,
+    }
+    public enum ThreadWaitReason {
+        EventPairHigh = 7,
+        EventPairLow = 8,
+        ExecutionDelay = 4,
+        Executive = 0,
+        FreePage = 1,
+        LpcReceive = 9,
+        LpcReply = 10,
+        PageIn = 2,
+        PageOut = 12,
+        Suspended = 5,
+        SystemAllocation = 3,
+        Unknown = 13,
+        UserRequest = 6,
+        VirtualMemory = 11,
+    }
+    public sealed class Trace {
+        public static bool AutoFlush { get; set; }
+        public static int IndentLevel { get; set; }
+        public static int IndentSize { get; set; }
+        public static TraceListenerCollection Listeners { get; }
+        public static bool UseGlobalLock { get; set; }
+        public static void Assert(bool condition);
+        public static void Assert(bool condition, string message);
+        public static void Assert(bool condition, string message, string detailMessage);
+        public static void Close();
+        public static void Fail(string message);
+        public static void Fail(string message, string detailMessage);
+        public static void Flush();
+        public static void Indent();
+        public static void Refresh();
+        public static void TraceError(string message);
+        public static void TraceError(string format, params object[] args);
+        public static void TraceInformation(string message);
+        public static void TraceInformation(string format, params object[] args);
+        public static void TraceWarning(string message);
+        public static void TraceWarning(string format, params object[] args);
+        public static void Unindent();
+        public static void Write(object value);
+        public static void Write(object value, string category);
+        public static void Write(string message);
+        public static void Write(string message, string category);
+        public static void WriteIf(bool condition, object value);
+        public static void WriteIf(bool condition, object value, string category);
+        public static void WriteIf(bool condition, string message);
+        public static void WriteIf(bool condition, string message, string category);
+        public static void WriteLine(object value);
+        public static void WriteLine(object value, string category);
+        public static void WriteLine(string message);
+        public static void WriteLine(string message, string category);
+        public static void WriteLineIf(bool condition, object value);
+        public static void WriteLineIf(bool condition, object value, string category);
+        public static void WriteLineIf(bool condition, string message);
+        public static void WriteLineIf(bool condition, string message, string category);
+    }
+    public class TraceEventCache {
+        public TraceEventCache();
+        public DateTime DateTime { get; }
+        public int ProcessId { get; }
+        public string ThreadId { get; }
+        public long Timestamp { get; }
+    }
+    public enum TraceEventType {
+        Critical = 1,
+        Error = 2,
+        Information = 8,
+        Verbose = 16,
+        Warning = 4,
+    }
+    public abstract class TraceFilter {
+        protected TraceFilter();
+        public abstract bool ShouldTrace(TraceEventCache cache, string source, TraceEventType eventType, int id, string formatOrMessage, object[] args, object data1, object[] data);
+    }
+    public enum TraceLevel {
+        Error = 1,
+        Info = 3,
+        Off = 0,
+        Verbose = 4,
+        Warning = 2,
+    }
+    public abstract class TraceListener : IDisposable {
+        protected TraceListener();
+        protected TraceListener(string name);
+        public TraceFilter Filter { get; set; }
+        public int IndentLevel { get; set; }
+        public int IndentSize { get; set; }
+        public virtual bool IsThreadSafe { get; }
+        public virtual string Name { get; set; }
+        protected bool NeedIndent { get; set; }
+        public TraceOptions TraceOutputOptions { get; set; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual void Fail(string message);
+        public virtual void Fail(string message, string detailMessage);
+        public virtual void Flush();
+        public virtual void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, object data);
+        public virtual void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, params object[] data);
+        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id);
+        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string message);
+        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args);
+        public virtual void Write(object o);
+        public virtual void Write(object o, string category);
+        public abstract void Write(string message);
+        public virtual void Write(string message, string category);
+        protected virtual void WriteIndent();
+        public virtual void WriteLine(object o);
+        public virtual void WriteLine(object o, string category);
+        public abstract void WriteLine(string message);
+        public virtual void WriteLine(string message, string category);
+    }
+    public class TraceListenerCollection : ICollection, IEnumerable, IList {
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public TraceListener this[int i] { get; set; }
+        public TraceListener this[string name] { get; }
+        public int Add(TraceListener listener);
+        public void AddRange(TraceListener[] value);
+        public void AddRange(TraceListenerCollection value);
+        public void Clear();
+        public bool Contains(TraceListener listener);
+        public void CopyTo(TraceListener[] listeners, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(TraceListener listener);
+        public void Insert(int index, TraceListener listener);
+        public void Remove(TraceListener listener);
+        public void Remove(string name);
+        public void RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        int System.Collections.IList.Add(object value);
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+    }
+    public enum TraceOptions {
+        DateTime = 2,
+        None = 0,
+        ProcessId = 8,
+        ThreadId = 16,
+        Timestamp = 4,
+    }
+    public class TraceSource {
+        public TraceSource(string name);
+        public TraceSource(string name, SourceLevels defaultLevel);
+        public TraceListenerCollection Listeners { get; }
+        public string Name { get; }
+        public SourceSwitch Switch { get; set; }
+        public void Close();
+        public void Flush();
+        public void TraceData(TraceEventType eventType, int id, object data);
+        public void TraceData(TraceEventType eventType, int id, params object[] data);
+        public void TraceEvent(TraceEventType eventType, int id);
+        public void TraceEvent(TraceEventType eventType, int id, string message);
+        public void TraceEvent(TraceEventType eventType, int id, string format, params object[] args);
+        public void TraceInformation(string message);
+        public void TraceInformation(string format, params object[] args);
+    }
+    public class TraceSwitch : Switch {
+        public TraceSwitch(string displayName, string description);
+        public TraceSwitch(string displayName, string description, string defaultSwitchValue);
+        public TraceLevel Level { get; set; }
+        public bool TraceError { get; }
+        public bool TraceInfo { get; }
+        public bool TraceVerbose { get; }
+        public bool TraceWarning { get; }
+        protected override void OnSwitchSettingChanged();
+        protected override void OnValueChanged();
+    }
+}
```

