# System.IdentityModel.Selectors

``` diff
+namespace System.IdentityModel.Selectors {
+    public class KerberosSecurityTokenProvider : SecurityTokenProvider {
+        public KerberosSecurityTokenProvider(string servicePrincipalName);
+        public KerberosSecurityTokenProvider(string servicePrincipalName, TokenImpersonationLevel tokenImpersonationLevel);
+        public KerberosSecurityTokenProvider(string servicePrincipalName, TokenImpersonationLevel tokenImpersonationLevel, NetworkCredential networkCredential);
+        public NetworkCredential NetworkCredential { get; }
+        public string ServicePrincipalName { get; }
+        public TokenImpersonationLevel TokenImpersonationLevel { get; }
+        protected override Task<SecurityToken> GetTokenCoreAsync(CancellationToken cancellationToken);
+    }
+    public abstract class SecurityTokenAuthenticator {
+        protected SecurityTokenAuthenticator();
+        public bool CanValidateToken(SecurityToken token);
+        protected abstract bool CanValidateTokenCore(SecurityToken token);
+        public ReadOnlyCollection<IAuthorizationPolicy> ValidateToken(SecurityToken token);
+        protected abstract ReadOnlyCollection<IAuthorizationPolicy> ValidateTokenCore(SecurityToken token);
+    }
+    public abstract class SecurityTokenManager {
+        protected SecurityTokenManager();
+        public abstract SecurityTokenAuthenticator CreateSecurityTokenAuthenticator(SecurityTokenRequirement tokenRequirement, out SecurityTokenResolver outOfBandTokenResolver);
+        public abstract SecurityTokenProvider CreateSecurityTokenProvider(SecurityTokenRequirement tokenRequirement);
+        public abstract SecurityTokenSerializer CreateSecurityTokenSerializer(SecurityTokenVersion version);
+    }
+    public abstract class SecurityTokenProvider {
+        protected SecurityTokenProvider();
+        public virtual bool SupportsTokenCancellation { get; }
+        public virtual bool SupportsTokenRenewal { get; }
+        public Task CancelTokenAsync(CancellationToken cancellationToken, SecurityToken securityToken);
+        protected virtual Task CancelTokenCoreAsync(CancellationToken cancellationToken, SecurityToken token);
+        public Task<SecurityToken> GetTokenAsync(CancellationToken cancellationToken);
+        protected abstract Task<SecurityToken> GetTokenCoreAsync(CancellationToken cancellationToken);
+        public Task<SecurityToken> RenewTokenAsync(CancellationToken cancellationToken, SecurityToken tokenToBeRenewed);
+        protected virtual Task<SecurityToken> RenewTokenCoreAsync(CancellationToken cancellationToken, SecurityToken tokenToBeRenewed);
+    }
+    public class SecurityTokenRequirement {
+        public SecurityTokenRequirement();
+        public static string IsOptionalTokenProperty { get; }
+        public int KeySize { get; set; }
+        public static string KeySizeProperty { get; }
+        public SecurityKeyType KeyType { get; set; }
+        public static string KeyTypeProperty { get; }
+        public SecurityKeyUsage KeyUsage { get; set; }
+        public static string KeyUsageProperty { get; }
+        public static string PeerAuthenticationMode { get; }
+        public IDictionary<string, object> Properties { get; }
+        public bool RequireCryptographicToken { get; set; }
+        public static string RequireCryptographicTokenProperty { get; }
+        public string TokenType { get; set; }
+        public static string TokenTypeProperty { get; }
+        public TValue GetProperty<TValue>(string propertyName);
+        public bool TryGetProperty<TValue>(string propertyName, out TValue result);
+    }
+    public abstract class SecurityTokenResolver {
+        protected SecurityTokenResolver();
+    }
+    public abstract class SecurityTokenSerializer {
+        protected SecurityTokenSerializer();
+        public bool CanReadKeyIdentifier(XmlReader reader);
+        public bool CanReadKeyIdentifierClause(XmlReader reader);
+        protected abstract bool CanReadKeyIdentifierClauseCore(XmlReader reader);
+        protected abstract bool CanReadKeyIdentifierCore(XmlReader reader);
+        public bool CanReadToken(XmlReader reader);
+        protected abstract bool CanReadTokenCore(XmlReader reader);
+        public bool CanWriteKeyIdentifier(SecurityKeyIdentifier keyIdentifier);
+        public bool CanWriteKeyIdentifierClause(SecurityKeyIdentifierClause keyIdentifierClause);
+        protected abstract bool CanWriteKeyIdentifierClauseCore(SecurityKeyIdentifierClause keyIdentifierClause);
+        protected abstract bool CanWriteKeyIdentifierCore(SecurityKeyIdentifier keyIdentifier);
+        public bool CanWriteToken(SecurityToken token);
+        protected abstract bool CanWriteTokenCore(SecurityToken token);
+        public SecurityKeyIdentifier ReadKeyIdentifier(XmlReader reader);
+        public SecurityKeyIdentifierClause ReadKeyIdentifierClause(XmlReader reader);
+        protected abstract SecurityKeyIdentifierClause ReadKeyIdentifierClauseCore(XmlReader reader);
+        protected abstract SecurityKeyIdentifier ReadKeyIdentifierCore(XmlReader reader);
+        public SecurityToken ReadToken(XmlReader reader, SecurityTokenResolver tokenResolver);
+        protected abstract SecurityToken ReadTokenCore(XmlReader reader, SecurityTokenResolver tokenResolver);
+        public void WriteKeyIdentifier(XmlWriter writer, SecurityKeyIdentifier keyIdentifier);
+        public void WriteKeyIdentifierClause(XmlWriter writer, SecurityKeyIdentifierClause keyIdentifierClause);
+        protected abstract void WriteKeyIdentifierClauseCore(XmlWriter writer, SecurityKeyIdentifierClause keyIdentifierClause);
+        protected abstract void WriteKeyIdentifierCore(XmlWriter writer, SecurityKeyIdentifier keyIdentifier);
+        public void WriteToken(XmlWriter writer, SecurityToken token);
+        protected abstract void WriteTokenCore(XmlWriter writer, SecurityToken token);
+    }
+    public abstract class SecurityTokenVersion {
+        protected SecurityTokenVersion();
+        public abstract ReadOnlyCollection<string> GetSecuritySpecifications();
+    }
+    public class UserNameSecurityTokenProvider : SecurityTokenProvider {
+        public UserNameSecurityTokenProvider(string userName, string password);
+        protected override Task<SecurityToken> GetTokenCoreAsync(CancellationToken cancellationToken);
+    }
+    public class WindowsSecurityTokenAuthenticator : SecurityTokenAuthenticator {
+        public WindowsSecurityTokenAuthenticator();
+        public WindowsSecurityTokenAuthenticator(bool includeWindowsGroups);
+        protected override bool CanValidateTokenCore(SecurityToken token);
+        protected override ReadOnlyCollection<IAuthorizationPolicy> ValidateTokenCore(SecurityToken token);
+    }
+    public abstract class X509CertificateValidator {
+        protected X509CertificateValidator();
+        public static X509CertificateValidator ChainTrust { get; }
+        public static X509CertificateValidator None { get; }
+        public static X509CertificateValidator CreateChainTrustValidator(bool useMachineContext, X509ChainPolicy chainPolicy);
+        public abstract void Validate(X509Certificate2 certificate);
+    }
+    public class X509SecurityTokenAuthenticator : SecurityTokenAuthenticator {
+        public X509SecurityTokenAuthenticator();
+        public X509SecurityTokenAuthenticator(X509CertificateValidator validator);
+        public X509SecurityTokenAuthenticator(X509CertificateValidator validator, bool mapToWindows);
+        public X509SecurityTokenAuthenticator(X509CertificateValidator validator, bool mapToWindows, bool includeWindowsGroups);
+        protected override bool CanValidateTokenCore(SecurityToken token);
+        protected override ReadOnlyCollection<IAuthorizationPolicy> ValidateTokenCore(SecurityToken token);
+    }
+    public class X509SecurityTokenProvider : SecurityTokenProvider, IDisposable {
+        public X509SecurityTokenProvider(X509Certificate2 certificate);
+        public void Dispose();
+        protected override Task<SecurityToken> GetTokenCoreAsync(CancellationToken cancellationToken);
+    }
+}
```

