# System.Net

``` diff
+namespace System.Net {
+    public enum AuthenticationSchemes {
+        Anonymous = 32768,
+        Basic = 8,
+        Digest = 1,
+        IntegratedWindowsAuthentication = 6,
+        Negotiate = 2,
+        None = 0,
+        Ntlm = 4,
+    }
+    public sealed class Cookie {
+        public Cookie();
+        public Cookie(string name, string value);
+        public Cookie(string name, string value, string path);
+        public Cookie(string name, string value, string path, string domain);
+        public string Comment { get; set; }
+        public Uri CommentUri { get; set; }
+        public bool Discard { get; set; }
+        public string Domain { get; set; }
+        public bool Expired { get; set; }
+        public DateTime Expires { get; set; }
+        public bool HttpOnly { get; set; }
+        public string Name { get; set; }
+        public string Path { get; set; }
+        public string Port { get; set; }
+        public bool Secure { get; set; }
+        public DateTime TimeStamp { get; }
+        public string Value { get; set; }
+        public int Version { get; set; }
+        public override bool Equals(object comparand);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public class CookieCollection : ICollection, IEnumerable {
+        public CookieCollection();
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public Cookie this[string name] { get; }
+        public void Add(Cookie cookie);
+        public void Add(CookieCollection cookies);
+        public IEnumerator GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+    }
+    public class CookieContainer {
+        public const int DefaultCookieLengthLimit = 4096;
+        public const int DefaultCookieLimit = 300;
+        public const int DefaultPerDomainCookieLimit = 20;
+        public CookieContainer();
+        public int Capacity { get; set; }
+        public int Count { get; }
+        public int MaxCookieSize { get; set; }
+        public int PerDomainCapacity { get; set; }
+        public void Add(Uri uri, Cookie cookie);
+        public void Add(Uri uri, CookieCollection cookies);
+        public string GetCookieHeader(Uri uri);
+        public CookieCollection GetCookies(Uri uri);
+        public void SetCookies(Uri uri, string cookieHeader);
+    }
+    public class CookieException : FormatException {
+        public CookieException();
+    }
+    public class CredentialCache : ICredentials, ICredentialsByHost, IEnumerable {
+        public CredentialCache();
+        public static ICredentials DefaultCredentials { get; }
+        public static NetworkCredential DefaultNetworkCredentials { get; }
+        public void Add(string host, int port, string authenticationType, NetworkCredential credential);
+        public void Add(Uri uriPrefix, string authType, NetworkCredential cred);
+        public NetworkCredential GetCredential(string host, int port, string authenticationType);
+        public NetworkCredential GetCredential(Uri uriPrefix, string authType);
+        public IEnumerator GetEnumerator();
+        public void Remove(string host, int port, string authenticationType);
+        public void Remove(Uri uriPrefix, string authType);
+    }
+    public enum DecompressionMethods {
+        Deflate = 2,
+        GZip = 1,
+        None = 0,
+    }
+    public static class Dns {
+        public static Task<IPAddress[]> GetHostAddressesAsync(string hostNameOrAddress);
+        public static Task<IPHostEntry> GetHostEntryAsync(IPAddress address);
+        public static Task<IPHostEntry> GetHostEntryAsync(string hostNameOrAddress);
+        public static string GetHostName();
+    }
+    public class DnsEndPoint : EndPoint {
+        public DnsEndPoint(string host, int port);
+        public DnsEndPoint(string host, int port, AddressFamily addressFamily);
+        public override AddressFamily AddressFamily { get; }
+        public string Host { get; }
+        public int Port { get; }
+        public override bool Equals(object comparand);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public abstract class EndPoint {
+        protected EndPoint();
+        public virtual AddressFamily AddressFamily { get; }
+        public virtual EndPoint Create(SocketAddress socketAddress);
+        public virtual SocketAddress Serialize();
+    }
+    public enum HttpRequestHeader {
+        Accept = 20,
+        AcceptCharset = 21,
+        AcceptEncoding = 22,
+        AcceptLanguage = 23,
+        Allow = 10,
+        Authorization = 24,
+        CacheControl = 0,
+        Connection = 1,
+        ContentEncoding = 13,
+        ContentLanguage = 14,
+        ContentLength = 11,
+        ContentLocation = 15,
+        ContentMd5 = 16,
+        ContentRange = 17,
+        ContentType = 12,
+        Cookie = 25,
+        Date = 2,
+        Expect = 26,
+        Expires = 18,
+        From = 27,
+        Host = 28,
+        IfMatch = 29,
+        IfModifiedSince = 30,
+        IfNoneMatch = 31,
+        IfRange = 32,
+        IfUnmodifiedSince = 33,
+        KeepAlive = 3,
+        LastModified = 19,
+        MaxForwards = 34,
+        Pragma = 4,
+        ProxyAuthorization = 35,
+        Range = 37,
+        Referer = 36,
+        Te = 38,
+        Trailer = 5,
+        TransferEncoding = 6,
+        Translate = 39,
+        Upgrade = 7,
+        UserAgent = 40,
+        Via = 8,
+        Warning = 9,
+    }
+    public enum HttpResponseHeader {
+        AcceptRanges = 20,
+        Age = 21,
+        Allow = 10,
+        CacheControl = 0,
+        Connection = 1,
+        ContentEncoding = 13,
+        ContentLanguage = 14,
+        ContentLength = 11,
+        ContentLocation = 15,
+        ContentMd5 = 16,
+        ContentRange = 17,
+        ContentType = 12,
+        Date = 2,
+        ETag = 22,
+        Expires = 18,
+        KeepAlive = 3,
+        LastModified = 19,
+        Location = 23,
+        Pragma = 4,
+        ProxyAuthenticate = 24,
+        RetryAfter = 25,
+        Server = 26,
+        SetCookie = 27,
+        Trailer = 5,
+        TransferEncoding = 6,
+        Upgrade = 7,
+        Vary = 28,
+        Via = 8,
+        Warning = 9,
+        WwwAuthenticate = 29,
+    }
+    public enum HttpStatusCode {
+        Accepted = 202,
+        Ambiguous = 300,
+        BadGateway = 502,
+        BadRequest = 400,
+        Conflict = 409,
+        Continue = 100,
+        Created = 201,
+        ExpectationFailed = 417,
+        Forbidden = 403,
+        Found = 302,
+        GatewayTimeout = 504,
+        Gone = 410,
+        HttpVersionNotSupported = 505,
+        InternalServerError = 500,
+        LengthRequired = 411,
+        MethodNotAllowed = 405,
+        Moved = 301,
+        MovedPermanently = 301,
+        MultipleChoices = 300,
+        NoContent = 204,
+        NonAuthoritativeInformation = 203,
+        NotAcceptable = 406,
+        NotFound = 404,
+        NotImplemented = 501,
+        NotModified = 304,
+        OK = 200,
+        PartialContent = 206,
+        PaymentRequired = 402,
+        PreconditionFailed = 412,
+        ProxyAuthenticationRequired = 407,
+        Redirect = 302,
+        RedirectKeepVerb = 307,
+        RedirectMethod = 303,
+        RequestedRangeNotSatisfiable = 416,
+        RequestEntityTooLarge = 413,
+        RequestTimeout = 408,
+        RequestUriTooLong = 414,
+        ResetContent = 205,
+        SeeOther = 303,
+        ServiceUnavailable = 503,
+        SwitchingProtocols = 101,
+        TemporaryRedirect = 307,
+        Unauthorized = 401,
+        UnsupportedMediaType = 415,
+        Unused = 306,
+        UpgradeRequired = 426,
+        UseProxy = 305,
+    }
+    public class HttpWebRequest : WebRequest {
+        public string Accept { get; set; }
+        public virtual bool AllowReadStreamBuffering { get; set; }
+        public override string ContentType { get; set; }
+        public int ContinueTimeout { get; set; }
+        public virtual CookieContainer CookieContainer { get; set; }
+        public override ICredentials Credentials { get; set; }
+        public virtual bool HaveResponse { get; }
+        public override WebHeaderCollection Headers { get; set; }
+        public override string Method { get; set; }
+        public override Uri RequestUri { get; }
+        public virtual bool SupportsCookieContainer { get; }
+        public override bool UseDefaultCredentials { get; set; }
+        public override void Abort();
+        public override IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
+        public override IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
+        public override Stream EndGetRequestStream(IAsyncResult asyncResult);
+        public override WebResponse EndGetResponse(IAsyncResult asyncResult);
+    }
+    public class HttpWebResponse : WebResponse {
+        public override long ContentLength { get; }
+        public override string ContentType { get; }
+        public virtual CookieCollection Cookies { get; }
+        public override WebHeaderCollection Headers { get; }
+        public virtual string Method { get; }
+        public override Uri ResponseUri { get; }
+        public virtual HttpStatusCode StatusCode { get; }
+        public virtual string StatusDescription { get; }
+        public override bool SupportsHeaders { get; }
+        protected override void Dispose(bool disposing);
+        public override Stream GetResponseStream();
+    }
+    public interface ICredentials {
+        NetworkCredential GetCredential(Uri uri, string authType);
+    }
+    public interface ICredentialsByHost {
+        NetworkCredential GetCredential(string host, int port, string authenticationType);
+    }
+    public class IPAddress {
+        public static readonly IPAddress Any;
+        public static readonly IPAddress Broadcast;
+        public static readonly IPAddress IPv6Any;
+        public static readonly IPAddress IPv6Loopback;
+        public static readonly IPAddress IPv6None;
+        public static readonly IPAddress Loopback;
+        public static readonly IPAddress None;
+        public IPAddress(byte[] address);
+        public IPAddress(byte[] address, long scopeid);
+        public IPAddress(long newAddress);
+        public AddressFamily AddressFamily { get; }
+        public bool IsIPv4MappedToIPv6 { get; }
+        public bool IsIPv6LinkLocal { get; }
+        public bool IsIPv6Multicast { get; }
+        public bool IsIPv6SiteLocal { get; }
+        public bool IsIPv6Teredo { get; }
+        public long ScopeId { get; set; }
+        public override bool Equals(object comparand);
+        public byte[] GetAddressBytes();
+        public override int GetHashCode();
+        public static short HostToNetworkOrder(short host);
+        public static int HostToNetworkOrder(int host);
+        public static long HostToNetworkOrder(long host);
+        public static bool IsLoopback(IPAddress address);
+        public IPAddress MapToIPv4();
+        public IPAddress MapToIPv6();
+        public static short NetworkToHostOrder(short network);
+        public static int NetworkToHostOrder(int network);
+        public static long NetworkToHostOrder(long network);
+        public static IPAddress Parse(string ipString);
+        public override string ToString();
+        public static bool TryParse(string ipString, out IPAddress address);
+    }
+    public class IPEndPoint : EndPoint {
+        public const int MaxPort = 65535;
+        public const int MinPort = 0;
+        public IPEndPoint(long address, int port);
+        public IPEndPoint(IPAddress address, int port);
+        public IPAddress Address { get; set; }
+        public override AddressFamily AddressFamily { get; }
+        public int Port { get; set; }
+        public override EndPoint Create(SocketAddress socketAddress);
+        public override bool Equals(object comparand);
+        public override int GetHashCode();
+        public override SocketAddress Serialize();
+        public override string ToString();
+    }
+    public class IPHostEntry {
+        public IPHostEntry();
+        public IPAddress[] AddressList { get; set; }
+        public string[] Aliases { get; set; }
+        public string HostName { get; set; }
+    }
+    public interface IWebProxy {
+        ICredentials Credentials { get; set; }
+        Uri GetProxy(Uri destination);
+        bool IsBypassed(Uri host);
+    }
+    public interface IWebRequestCreate {
+        WebRequest Create(Uri uri);
+    }
+    public class NetworkCredential : ICredentials, ICredentialsByHost {
+        public NetworkCredential();
+        public NetworkCredential(string userName, string password);
+        public NetworkCredential(string userName, string password, string domain);
+        public string Domain { get; set; }
+        public string Password { get; set; }
+        public string UserName { get; set; }
+        public NetworkCredential GetCredential(string host, int port, string authenticationType);
+        public NetworkCredential GetCredential(Uri uri, string authType);
+    }
+    public class ProtocolViolationException : InvalidOperationException {
+        public ProtocolViolationException();
+        public ProtocolViolationException(string message);
+    }
+    public class SocketAddress {
+        public SocketAddress(AddressFamily family);
+        public SocketAddress(AddressFamily family, int size);
+        public AddressFamily Family { get; }
+        public int Size { get; }
+        public byte this[int offset] { get; set; }
+        public override bool Equals(object comparand);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public abstract class TransportContext {
+        protected TransportContext();
+        public abstract ChannelBinding GetChannelBinding(ChannelBindingKind kind);
+    }
+    public class WebException : InvalidOperationException {
+        public WebException();
+        public WebException(string message);
+        public WebException(string message, Exception innerException);
+        public WebException(string message, Exception innerException, WebExceptionStatus status, WebResponse response);
+        public WebException(string message, WebExceptionStatus status);
+        public WebResponse Response { get; }
+        public WebExceptionStatus Status { get; }
+    }
+    public enum WebExceptionStatus {
+        CacheEntryNotFound = 18,
+        ConnectFailure = 2,
+        ConnectionClosed = 8,
+        KeepAliveFailure = 12,
+        MessageLengthLimitExceeded = 17,
+        NameResolutionFailure = 1,
+        Pending = 13,
+        PipelineFailure = 5,
+        ProtocolError = 7,
+        ProxyNameResolutionFailure = 15,
+        ReceiveFailure = 3,
+        RequestCanceled = 6,
+        RequestProhibitedByCachePolicy = 19,
+        RequestProhibitedByProxy = 20,
+        SecureChannelFailure = 10,
+        SendFailure = 4,
+        ServerProtocolViolation = 11,
+        Success = 0,
+        Timeout = 14,
+        TrustFailure = 9,
+        UnknownError = 16,
+    }
+    public sealed class WebHeaderCollection : IEnumerable {
+        public WebHeaderCollection();
+        public string[] AllKeys { get; }
+        public int Count { get; }
+        public string this[HttpRequestHeader header] { get; set; }
+        public string this[HttpResponseHeader header] { get; set; }
+        public string this[string name] { get; set; }
+        public void Remove(string name);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public override string ToString();
+    }
+    public abstract class WebRequest {
+        protected WebRequest();
+        public abstract string ContentType { get; set; }
+        public virtual ICredentials Credentials { get; set; }
+        public static IWebProxy DefaultWebProxy { get; set; }
+        public abstract WebHeaderCollection Headers { get; set; }
+        public abstract string Method { get; set; }
+        public virtual IWebProxy Proxy { get; set; }
+        public abstract Uri RequestUri { get; }
+        public virtual bool UseDefaultCredentials { get; set; }
+        public abstract void Abort();
+        public abstract IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
+        public abstract IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
+        public static WebRequest Create(string requestUriString);
+        public static WebRequest Create(Uri requestUri);
+        public static HttpWebRequest CreateHttp(string requestUriString);
+        public static HttpWebRequest CreateHttp(Uri requestUri);
+        public abstract Stream EndGetRequestStream(IAsyncResult asyncResult);
+        public abstract WebResponse EndGetResponse(IAsyncResult asyncResult);
+        public virtual Task<Stream> GetRequestStreamAsync();
+        public virtual Task<WebResponse> GetResponseAsync();
+        public static bool RegisterPrefix(string prefix, IWebRequestCreate creator);
+    }
+    public abstract class WebResponse : IDisposable {
+        protected WebResponse();
+        public abstract long ContentLength { get; }
+        public abstract string ContentType { get; }
+        public virtual WebHeaderCollection Headers { get; }
+        public abstract Uri ResponseUri { get; }
+        public virtual bool SupportsHeaders { get; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract Stream GetResponseStream();
+    }
+    public static class WebUtility {
+        public static string HtmlDecode(string value);
+        public static string HtmlEncode(string value);
+        public static string UrlDecode(string encodedValue);
+        public static byte[] UrlDecodeToBytes(byte[] encodedValue, int offset, int count);
+        public static string UrlEncode(string value);
+        public static byte[] UrlEncodeToBytes(byte[] value, int offset, int count);
+    }
+}
```

