# System.Reflection.Emit

``` diff
+namespace System.Reflection.Emit {
+    public sealed class AssemblyBuilder : Assembly {
+        public override string CodeBase { get; }
+        public override IEnumerable<TypeInfo> DefinedTypes { get; }
+        public override MethodInfo EntryPoint { get; }
+        public override string FullName { get; }
+        public override string ImageRuntimeVersion { get; }
+        public override bool IsDynamic { get; }
+        public override string Location { get; }
+        public override Module ManifestModule { get; }
+        public override IEnumerable<Module> Modules { get; }
+        public static AssemblyBuilder DefineDynamicAssembly(AssemblyName name, AssemblyBuilderAccess access);
+        public static AssemblyBuilder DefineDynamicAssembly(AssemblyName name, AssemblyBuilderAccess access, IEnumerable<CustomAttributeBuilder> assemblyAttributes);
+        public ModuleBuilder DefineDynamicModule(string name);
+        [MethodImpl(NoInlining)]public ModuleBuilder DefineDynamicModule(string name, bool emitSymbolInfo);
+        public override bool Equals(object obj);
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public ModuleBuilder GetDynamicModule(string name);
+        public override Type[] GetExportedTypes();
+        public override int GetHashCode();
+        public override ManifestResourceInfo GetManifestResourceInfo(string resourceName);
+        public override string[] GetManifestResourceNames();
+        public override Stream GetManifestResourceStream(string name);
+        public override Stream GetManifestResourceStream(Type type, string name);
+        public override AssemblyName[] GetReferencedAssemblies();
+        public override Type GetType(string name, bool throwOnError, bool ignoreCase);
+        public override bool IsDefined(Type attributeType, bool inherit);
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+    }
+    public enum AssemblyBuilderAccess {
+        Run = 1,
+        RunAndCollect = 9,
+    }
+    public sealed class ConstructorBuilder : ConstructorInfo {
+        public override MethodAttributes Attributes { get; }
+        public override CallingConventions CallingConvention { get; }
+        public override Type DeclaringType { get; }
+        public bool InitLocals { get; set; }
+        public override RuntimeMethodHandle MethodHandle { get; }
+        public override MethodImplAttributes MethodImplementationFlags { get; }
+        public override Module Module { get; }
+        public override string Name { get; }
+        public override Type ReflectedType { get; }
+        public string Signature { get; }
+        public ParameterBuilder DefineParameter(int iSequence, ParameterAttributes attributes, string strParamName);
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public ILGenerator GetILGenerator();
+        public ILGenerator GetILGenerator(int streamSize);
+        public override MethodImplAttributes GetMethodImplementationFlags();
+        public Module GetModule();
+        public override ParameterInfo[] GetParameters();
+        public MethodToken GetToken();
+        public override object Invoke(object obj, BindingFlags invokeAttr, Binder binder, object[] parameters, CultureInfo culture);
+        public override object Invoke(BindingFlags invokeAttr, Binder binder, object[] parameters, CultureInfo culture);
+        public override bool IsDefined(Type attributeType, bool inherit);
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+        public void SetImplementationFlags(MethodImplAttributes attributes);
+        public override string ToString();
+    }
+    public class CustomAttributeBuilder {
+        public CustomAttributeBuilder(ConstructorInfo con, object[] constructorArgs);
+        public CustomAttributeBuilder(ConstructorInfo con, object[] constructorArgs, FieldInfo[] namedFields, object[] fieldValues);
+        public CustomAttributeBuilder(ConstructorInfo con, object[] constructorArgs, PropertyInfo[] namedProperties, object[] propertyValues);
+        public CustomAttributeBuilder(ConstructorInfo con, object[] constructorArgs, PropertyInfo[] namedProperties, object[] propertyValues, FieldInfo[] namedFields, object[] fieldValues);
+    }
+    public sealed class DynamicMethod : MethodInfo {
+        public DynamicMethod(string name, MethodAttributes attributes, CallingConventions callingConvention, Type returnType, Type[] parameterTypes, Module m, bool skipVisibility);
+        public DynamicMethod(string name, MethodAttributes attributes, CallingConventions callingConvention, Type returnType, Type[] parameterTypes, Type owner, bool skipVisibility);
+        public DynamicMethod(string name, Type returnType, Type[] parameterTypes);
+        public DynamicMethod(string name, Type returnType, Type[] parameterTypes, bool restrictedSkipVisibility);
+        public DynamicMethod(string name, Type returnType, Type[] parameterTypes, Module m);
+        public DynamicMethod(string name, Type returnType, Type[] parameterTypes, Module m, bool skipVisibility);
+        public DynamicMethod(string name, Type returnType, Type[] parameterTypes, Type owner);
+        public DynamicMethod(string name, Type returnType, Type[] parameterTypes, Type owner, bool skipVisibility);
+        public override MethodAttributes Attributes { get; }
+        public override CallingConventions CallingConvention { get; }
+        public override Type DeclaringType { get; }
+        public bool InitLocals { get; set; }
+        public override RuntimeMethodHandle MethodHandle { get; }
+        public override MethodImplAttributes MethodImplementationFlags { get; }
+        public override Module Module { get; }
+        public override string Name { get; }
+        public override Type ReflectedType { get; }
+        public override ParameterInfo ReturnParameter { get; }
+        public override Type ReturnType { get; }
+        public override ICustomAttributeProvider ReturnTypeCustomAttributes { get; }
+        public sealed override Delegate CreateDelegate(Type delegateType);
+        public sealed override Delegate CreateDelegate(Type delegateType, object target);
+        public ParameterBuilder DefineParameter(int position, ParameterAttributes attributes, string parameterName);
+        public override MethodInfo GetBaseDefinition();
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public ILGenerator GetILGenerator();
+        public ILGenerator GetILGenerator(int streamSize);
+        public override MethodImplAttributes GetMethodImplementationFlags();
+        public override ParameterInfo[] GetParameters();
+        public override object Invoke(object obj, BindingFlags invokeAttr, Binder binder, object[] parameters, CultureInfo culture);
+        public override bool IsDefined(Type attributeType, bool inherit);
+        public override string ToString();
+    }
+    public sealed class EnumBuilder : TypeInfo {
+        public override Assembly Assembly { get; }
+        public override string AssemblyQualifiedName { get; }
+        public override TypeAttributes Attributes { get; }
+        public override Type BaseType { get; }
+        public override bool ContainsGenericParameters { get; }
+        public override MethodBase DeclaringMethod { get; }
+        public override Type DeclaringType { get; }
+        public override string FullName { get; }
+        public override GenericParameterAttributes GenericParameterAttributes { get; }
+        public override int GenericParameterPosition { get; }
+        public override Type[] GenericTypeArguments { get; }
+        public override Guid GUID { get; }
+        public override bool IsConstructedGenericType { get; }
+        public override bool IsEnum { get; }
+        public override bool IsGenericParameter { get; }
+        public override bool IsGenericType { get; }
+        public override bool IsGenericTypeDefinition { get; }
+        public override bool IsSerializable { get; }
+        public override Module Module { get; }
+        public override string Name { get; }
+        public override string Namespace { get; }
+        public override Type ReflectedType { get; }
+        public override RuntimeTypeHandle TypeHandle { get; }
+        public TypeToken TypeToken { get; }
+        public FieldBuilder UnderlyingField { get; }
+        public override Type UnderlyingSystemType { get; }
+        public Type CreateType();
+        public TypeInfo CreateTypeInfo();
+        public FieldBuilder DefineLiteral(string literalName, object literalValue);
+        public override int GetArrayRank();
+        protected override TypeAttributes GetAttributeFlagsImpl();
+        protected override ConstructorInfo GetConstructorImpl(BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public override ConstructorInfo[] GetConstructors(BindingFlags bindingAttr);
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public override Type GetElementType();
+        public override Type GetEnumUnderlyingType();
+        public override EventInfo GetEvent(string name, BindingFlags bindingAttr);
+        public override EventInfo[] GetEvents();
+        public override EventInfo[] GetEvents(BindingFlags bindingAttr);
+        public override FieldInfo GetField(string name, BindingFlags bindingAttr);
+        public override FieldInfo[] GetFields(BindingFlags bindingAttr);
+        public override Type[] GetGenericParameterConstraints();
+        public override Type GetGenericTypeDefinition();
+        public override Type GetInterface(string name, bool ignoreCase);
+        public override InterfaceMapping GetInterfaceMap(Type interfaceType);
+        public override Type[] GetInterfaces();
+        public override MemberInfo[] GetMember(string name, MemberTypes type, BindingFlags bindingAttr);
+        public override MemberInfo[] GetMembers(BindingFlags bindingAttr);
+        protected override MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public override MethodInfo[] GetMethods(BindingFlags bindingAttr);
+        public override Type GetNestedType(string name, BindingFlags bindingAttr);
+        public override Type[] GetNestedTypes(BindingFlags bindingAttr);
+        public override PropertyInfo[] GetProperties(BindingFlags bindingAttr);
+        protected override PropertyInfo GetPropertyImpl(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        protected override bool HasElementTypeImpl();
+        public override object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] namedParameters);
+        protected override bool IsArrayImpl();
+        public override bool IsAssignableFrom(TypeInfo typeInfo);
+        protected override bool IsByRefImpl();
+        protected override bool IsCOMObjectImpl();
+        public override bool IsDefined(Type attributeType, bool inherit);
+        protected override bool IsPointerImpl();
+        protected override bool IsPrimitiveImpl();
+        protected override bool IsValueTypeImpl();
+        public override Type MakeArrayType();
+        public override Type MakeArrayType(int rank);
+        public override Type MakeByRefType();
+        public override Type MakeGenericType(params Type[] typeArguments);
+        public override Type MakePointerType();
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+    }
+    public sealed class EventBuilder {
+        public void AddOtherMethod(MethodBuilder mdBuilder);
+        public EventToken GetEventToken();
+        public void SetAddOnMethod(MethodBuilder mdBuilder);
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+        public void SetRaiseMethod(MethodBuilder mdBuilder);
+        public void SetRemoveOnMethod(MethodBuilder mdBuilder);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct EventToken {
+        public static readonly EventToken Empty;
+        public int Token { get; }
+        public override bool Equals(object obj);
+        public bool Equals(EventToken obj);
+        public override int GetHashCode();
+        public static bool operator ==(EventToken a, EventToken b);
+        public static bool operator !=(EventToken a, EventToken b);
+    }
+    public sealed class FieldBuilder : FieldInfo {
+        public override FieldAttributes Attributes { get; }
+        public override Type DeclaringType { get; }
+        public override RuntimeFieldHandle FieldHandle { get; }
+        public override Type FieldType { get; }
+        public override Module Module { get; }
+        public override string Name { get; }
+        public override Type ReflectedType { get; }
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public FieldToken GetToken();
+        public override object GetValue(object obj);
+        public override bool IsDefined(Type attributeType, bool inherit);
+        public void SetConstant(object defaultValue);
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+        public void SetOffset(int iOffset);
+        public override void SetValue(object obj, object val, BindingFlags invokeAttr, Binder binder, CultureInfo culture);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct FieldToken {
+        public static readonly FieldToken Empty;
+        public int Token { get; }
+        public override bool Equals(object obj);
+        public bool Equals(FieldToken obj);
+        public override int GetHashCode();
+        public static bool operator ==(FieldToken a, FieldToken b);
+        public static bool operator !=(FieldToken a, FieldToken b);
+    }
+    public enum FlowControl {
+        Branch = 0,
+        Break = 1,
+        Call = 2,
+        Cond_Branch = 3,
+        Meta = 4,
+        Next = 5,
+        Return = 7,
+        Throw = 8,
+    }
+    public sealed class GenericTypeParameterBuilder : TypeInfo {
+        public override Assembly Assembly { get; }
+        public override string AssemblyQualifiedName { get; }
+        public override TypeAttributes Attributes { get; }
+        public override Type BaseType { get; }
+        public override bool ContainsGenericParameters { get; }
+        public override MethodBase DeclaringMethod { get; }
+        public override Type DeclaringType { get; }
+        public override string FullName { get; }
+        public override GenericParameterAttributes GenericParameterAttributes { get; }
+        public override int GenericParameterPosition { get; }
+        public override Type[] GenericTypeArguments { get; }
+        public override Guid GUID { get; }
+        public override bool IsConstructedGenericType { get; }
+        public override bool IsEnum { get; }
+        public override bool IsGenericParameter { get; }
+        public override bool IsGenericType { get; }
+        public override bool IsGenericTypeDefinition { get; }
+        public override bool IsSerializable { get; }
+        public override Module Module { get; }
+        public override string Name { get; }
+        public override string Namespace { get; }
+        public override Type ReflectedType { get; }
+        public override RuntimeTypeHandle TypeHandle { get; }
+        public override Type UnderlyingSystemType { get; }
+        public override bool Equals(object o);
+        public override int GetArrayRank();
+        protected override TypeAttributes GetAttributeFlagsImpl();
+        protected override ConstructorInfo GetConstructorImpl(BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public override ConstructorInfo[] GetConstructors(BindingFlags bindingAttr);
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public override Type GetElementType();
+        public override EventInfo GetEvent(string name, BindingFlags bindingAttr);
+        public override EventInfo[] GetEvents();
+        public override EventInfo[] GetEvents(BindingFlags bindingAttr);
+        public override FieldInfo GetField(string name, BindingFlags bindingAttr);
+        public override FieldInfo[] GetFields(BindingFlags bindingAttr);
+        public override Type[] GetGenericArguments();
+        public override Type[] GetGenericParameterConstraints();
+        public override Type GetGenericTypeDefinition();
+        public override int GetHashCode();
+        public override Type GetInterface(string name, bool ignoreCase);
+        public override InterfaceMapping GetInterfaceMap(Type interfaceType);
+        public override Type[] GetInterfaces();
+        public override MemberInfo[] GetMember(string name, MemberTypes type, BindingFlags bindingAttr);
+        public override MemberInfo[] GetMembers(BindingFlags bindingAttr);
+        protected override MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public override MethodInfo[] GetMethods(BindingFlags bindingAttr);
+        public override Type GetNestedType(string name, BindingFlags bindingAttr);
+        public override Type[] GetNestedTypes(BindingFlags bindingAttr);
+        public override PropertyInfo[] GetProperties(BindingFlags bindingAttr);
+        protected override PropertyInfo GetPropertyImpl(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        protected override bool HasElementTypeImpl();
+        public override object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] namedParameters);
+        protected override bool IsArrayImpl();
+        public override bool IsAssignableFrom(TypeInfo typeInfo);
+        public override bool IsAssignableFrom(Type c);
+        protected override bool IsByRefImpl();
+        protected override bool IsCOMObjectImpl();
+        public override bool IsDefined(Type attributeType, bool inherit);
+        protected override bool IsPointerImpl();
+        protected override bool IsPrimitiveImpl();
+        public override bool IsSubclassOf(Type c);
+        protected override bool IsValueTypeImpl();
+        public override Type MakeArrayType();
+        public override Type MakeArrayType(int rank);
+        public override Type MakeByRefType();
+        public override Type MakeGenericType(params Type[] typeArguments);
+        public override Type MakePointerType();
+        public void SetBaseTypeConstraint(Type baseTypeConstraint);
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+        public void SetGenericParameterAttributes(GenericParameterAttributes genericParameterAttributes);
+        public void SetInterfaceConstraints(params Type[] interfaceConstraints);
+        public override string ToString();
+    }
+    public class ILGenerator {
+        public virtual int ILOffset { get; }
+        public virtual void BeginCatchBlock(Type exceptionType);
+        public virtual void BeginExceptFilterBlock();
+        public virtual Label BeginExceptionBlock();
+        public virtual void BeginFaultBlock();
+        public virtual void BeginFinallyBlock();
+        public virtual void BeginScope();
+        public virtual LocalBuilder DeclareLocal(Type localType);
+        public virtual LocalBuilder DeclareLocal(Type localType, bool pinned);
+        public virtual Label DefineLabel();
+        public virtual void Emit(OpCode opcode);
+        public virtual void Emit(OpCode opcode, byte arg);
+        public virtual void Emit(OpCode opcode, double arg);
+        public virtual void Emit(OpCode opcode, short arg);
+        public virtual void Emit(OpCode opcode, int arg);
+        public virtual void Emit(OpCode opcode, long arg);
+        public virtual void Emit(OpCode opcode, ConstructorInfo con);
+        public virtual void Emit(OpCode opcode, Label label);
+        public virtual void Emit(OpCode opcode, Label[] labels);
+        public virtual void Emit(OpCode opcode, LocalBuilder local);
+        public virtual void Emit(OpCode opcode, SignatureHelper signature);
+        public virtual void Emit(OpCode opcode, FieldInfo field);
+        public virtual void Emit(OpCode opcode, MethodInfo meth);
+        public void Emit(OpCode opcode, sbyte arg);
+        public virtual void Emit(OpCode opcode, float arg);
+        public virtual void Emit(OpCode opcode, string str);
+        public virtual void Emit(OpCode opcode, Type cls);
+        public virtual void EmitCall(OpCode opcode, MethodInfo methodInfo, Type[] optionalParameterTypes);
+        public virtual void EmitCalli(OpCode opcode, CallingConventions callingConvention, Type returnType, Type[] parameterTypes, Type[] optionalParameterTypes);
+        public virtual void EmitWriteLine(LocalBuilder localBuilder);
+        public virtual void EmitWriteLine(FieldInfo fld);
+        public virtual void EmitWriteLine(string value);
+        public virtual void EndExceptionBlock();
+        public virtual void EndScope();
+        public virtual void MarkLabel(Label loc);
+        public virtual void MarkSequencePoint(ISymbolDocumentWriter document, int startLine, int startColumn, int endLine, int endColumn);
+        public virtual void ThrowException(Type excType);
+        public virtual void UsingNamespace(string usingNamespace);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Label {
+        public override bool Equals(object obj);
+        public bool Equals(Label obj);
+        public override int GetHashCode();
+        public static bool operator ==(Label a, Label b);
+        public static bool operator !=(Label a, Label b);
+    }
+    public sealed class LocalBuilder : LocalVariableInfo {
+        public override bool IsPinned { get; }
+        public override int LocalIndex { get; }
+        public override Type LocalType { get; }
+        public void SetLocalSymInfo(string name);
+        public void SetLocalSymInfo(string name, int startOffset, int endOffset);
+    }
+    public sealed class MethodBuilder : MethodInfo {
+        public override MethodAttributes Attributes { get; }
+        public override CallingConventions CallingConvention { get; }
+        public override bool ContainsGenericParameters { get; }
+        public override Type DeclaringType { get; }
+        public bool InitLocals { get; set; }
+        public override bool IsGenericMethod { get; }
+        public override bool IsGenericMethodDefinition { get; }
+        public override RuntimeMethodHandle MethodHandle { get; }
+        public override MethodImplAttributes MethodImplementationFlags { get; }
+        public override Module Module { get; }
+        public override string Name { get; }
+        public override Type ReflectedType { get; }
+        public override ParameterInfo ReturnParameter { get; }
+        public override Type ReturnType { get; }
+        public override ICustomAttributeProvider ReturnTypeCustomAttributes { get; }
+        public string Signature { get; }
+        public GenericTypeParameterBuilder[] DefineGenericParameters(params string[] names);
+        public ParameterBuilder DefineParameter(int position, ParameterAttributes attributes, string strParamName);
+        public override bool Equals(object obj);
+        public override MethodInfo GetBaseDefinition();
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public override Type[] GetGenericArguments();
+        public override MethodInfo GetGenericMethodDefinition();
+        public override int GetHashCode();
+        public ILGenerator GetILGenerator();
+        public ILGenerator GetILGenerator(int size);
+        public override MethodImplAttributes GetMethodImplementationFlags();
+        public Module GetModule();
+        public override ParameterInfo[] GetParameters();
+        public MethodToken GetToken();
+        public override object Invoke(object obj, BindingFlags invokeAttr, Binder binder, object[] parameters, CultureInfo culture);
+        public override bool IsDefined(Type attributeType, bool inherit);
+        public override MethodInfo MakeGenericMethod(params Type[] typeArguments);
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+        public void SetImplementationFlags(MethodImplAttributes attributes);
+        public void SetParameters(params Type[] parameterTypes);
+        public void SetReturnType(Type returnType);
+        public void SetSignature(Type returnType, Type[] returnTypeRequiredCustomModifiers, Type[] returnTypeOptionalCustomModifiers, Type[] parameterTypes, Type[][] parameterTypeRequiredCustomModifiers, Type[][] parameterTypeOptionalCustomModifiers);
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodToken {
+        public static readonly MethodToken Empty;
+        public int Token { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MethodToken obj);
+        public override int GetHashCode();
+        public static bool operator ==(MethodToken a, MethodToken b);
+        public static bool operator !=(MethodToken a, MethodToken b);
+    }
+    public class ModuleBuilder : Module {
+        public override Assembly Assembly { get; }
+        public override string FullyQualifiedName { get; }
+        public override int MetadataToken { get; }
+        public override Guid ModuleVersionId { get; }
+        public override string Name { get; }
+        public override string ScopeName { get; }
+        public void CreateGlobalFunctions();
+        public ISymbolDocumentWriter DefineDocument(string url, Guid language, Guid languageVendor, Guid documentType);
+        public EnumBuilder DefineEnum(string name, TypeAttributes visibility, Type underlyingType);
+        public MethodBuilder DefineGlobalMethod(string name, MethodAttributes attributes, CallingConventions callingConvention, Type returnType, Type[] parameterTypes);
+        public MethodBuilder DefineGlobalMethod(string name, MethodAttributes attributes, CallingConventions callingConvention, Type returnType, Type[] requiredReturnTypeCustomModifiers, Type[] optionalReturnTypeCustomModifiers, Type[] parameterTypes, Type[][] requiredParameterTypeCustomModifiers, Type[][] optionalParameterTypeCustomModifiers);
+        public MethodBuilder DefineGlobalMethod(string name, MethodAttributes attributes, Type returnType, Type[] parameterTypes);
+        public FieldBuilder DefineInitializedData(string name, byte[] data, FieldAttributes attributes);
+        public TypeBuilder DefineType(string name);
+        public TypeBuilder DefineType(string name, TypeAttributes attr);
+        public TypeBuilder DefineType(string name, TypeAttributes attr, Type parent);
+        public TypeBuilder DefineType(string name, TypeAttributes attr, Type parent, int typesize);
+        public TypeBuilder DefineType(string name, TypeAttributes attr, Type parent, PackingSize packsize);
+        public TypeBuilder DefineType(string name, TypeAttributes attr, Type parent, PackingSize packingSize, int typesize);
+        public TypeBuilder DefineType(string name, TypeAttributes attr, Type parent, Type[] interfaces);
+        public FieldBuilder DefineUninitializedData(string name, int size, FieldAttributes attributes);
+        public override bool Equals(object obj);
+        public MethodInfo GetArrayMethod(Type arrayClass, string methodName, CallingConventions callingConvention, Type returnType, Type[] parameterTypes);
+        public MethodToken GetArrayMethodToken(Type arrayClass, string methodName, CallingConventions callingConvention, Type returnType, Type[] parameterTypes);
+        public MethodToken GetConstructorToken(ConstructorInfo con);
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public override FieldInfo GetField(string name, BindingFlags bindingAttr);
+        public override FieldInfo[] GetFields(BindingFlags bindingFlags);
+        public FieldToken GetFieldToken(FieldInfo field);
+        public override int GetHashCode();
+        protected override MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public override MethodInfo[] GetMethods(BindingFlags bindingFlags);
+        public MethodToken GetMethodToken(MethodInfo method);
+        public SignatureToken GetSignatureToken(byte[] sigBytes, int sigLength);
+        public SignatureToken GetSignatureToken(SignatureHelper sigHelper);
+        public StringToken GetStringConstant(string str);
+        public override Type GetType(string className);
+        public override Type GetType(string className, bool ignoreCase);
+        public override Type GetType(string className, bool throwOnError, bool ignoreCase);
+        public override Type[] GetTypes();
+        public TypeToken GetTypeToken(string name);
+        public TypeToken GetTypeToken(Type type);
+        public override bool IsDefined(Type attributeType, bool inherit);
+        public bool IsTransient();
+        public override FieldInfo ResolveField(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
+        public override MethodBase ResolveMethod(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
+        public override string ResolveString(int metadataToken);
+        public override Type ResolveType(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct OpCode {
+        public FlowControl FlowControl { get; }
+        public string Name { get; }
+        public OpCodeType OpCodeType { get; }
+        public OperandType OperandType { get; }
+        public int Size { get; }
+        public StackBehaviour StackBehaviourPop { get; }
+        public StackBehaviour StackBehaviourPush { get; }
+        public short Value { get; }
+        public override bool Equals(object obj);
+        public bool Equals(OpCode obj);
+        public override int GetHashCode();
+        public static bool operator ==(OpCode a, OpCode b);
+        public static bool operator !=(OpCode a, OpCode b);
+        public override string ToString();
+    }
+    public class OpCodes {
+        public static readonly OpCode Add;
+        public static readonly OpCode Add_Ovf;
+        public static readonly OpCode Add_Ovf_Un;
+        public static readonly OpCode And;
+        public static readonly OpCode Arglist;
+        public static readonly OpCode Beq;
+        public static readonly OpCode Beq_S;
+        public static readonly OpCode Bge;
+        public static readonly OpCode Bge_S;
+        public static readonly OpCode Bge_Un;
+        public static readonly OpCode Bge_Un_S;
+        public static readonly OpCode Bgt;
+        public static readonly OpCode Bgt_S;
+        public static readonly OpCode Bgt_Un;
+        public static readonly OpCode Bgt_Un_S;
+        public static readonly OpCode Ble;
+        public static readonly OpCode Ble_S;
+        public static readonly OpCode Ble_Un;
+        public static readonly OpCode Ble_Un_S;
+        public static readonly OpCode Blt;
+        public static readonly OpCode Blt_S;
+        public static readonly OpCode Blt_Un;
+        public static readonly OpCode Blt_Un_S;
+        public static readonly OpCode Bne_Un;
+        public static readonly OpCode Bne_Un_S;
+        public static readonly OpCode Box;
+        public static readonly OpCode Br;
+        public static readonly OpCode Br_S;
+        public static readonly OpCode Break;
+        public static readonly OpCode Brfalse;
+        public static readonly OpCode Brfalse_S;
+        public static readonly OpCode Brtrue;
+        public static readonly OpCode Brtrue_S;
+        public static readonly OpCode Call;
+        public static readonly OpCode Calli;
+        public static readonly OpCode Callvirt;
+        public static readonly OpCode Castclass;
+        public static readonly OpCode Ceq;
+        public static readonly OpCode Cgt;
+        public static readonly OpCode Cgt_Un;
+        public static readonly OpCode Ckfinite;
+        public static readonly OpCode Clt;
+        public static readonly OpCode Clt_Un;
+        public static readonly OpCode Constrained;
+        public static readonly OpCode Conv_I;
+        public static readonly OpCode Conv_I1;
+        public static readonly OpCode Conv_I2;
+        public static readonly OpCode Conv_I4;
+        public static readonly OpCode Conv_I8;
+        public static readonly OpCode Conv_Ovf_I;
+        public static readonly OpCode Conv_Ovf_I_Un;
+        public static readonly OpCode Conv_Ovf_I1;
+        public static readonly OpCode Conv_Ovf_I1_Un;
+        public static readonly OpCode Conv_Ovf_I2;
+        public static readonly OpCode Conv_Ovf_I2_Un;
+        public static readonly OpCode Conv_Ovf_I4;
+        public static readonly OpCode Conv_Ovf_I4_Un;
+        public static readonly OpCode Conv_Ovf_I8;
+        public static readonly OpCode Conv_Ovf_I8_Un;
+        public static readonly OpCode Conv_Ovf_U;
+        public static readonly OpCode Conv_Ovf_U_Un;
+        public static readonly OpCode Conv_Ovf_U1;
+        public static readonly OpCode Conv_Ovf_U1_Un;
+        public static readonly OpCode Conv_Ovf_U2;
+        public static readonly OpCode Conv_Ovf_U2_Un;
+        public static readonly OpCode Conv_Ovf_U4;
+        public static readonly OpCode Conv_Ovf_U4_Un;
+        public static readonly OpCode Conv_Ovf_U8;
+        public static readonly OpCode Conv_Ovf_U8_Un;
+        public static readonly OpCode Conv_R_Un;
+        public static readonly OpCode Conv_R4;
+        public static readonly OpCode Conv_R8;
+        public static readonly OpCode Conv_U;
+        public static readonly OpCode Conv_U1;
+        public static readonly OpCode Conv_U2;
+        public static readonly OpCode Conv_U4;
+        public static readonly OpCode Conv_U8;
+        public static readonly OpCode Cpblk;
+        public static readonly OpCode Cpobj;
+        public static readonly OpCode Div;
+        public static readonly OpCode Div_Un;
+        public static readonly OpCode Dup;
+        public static readonly OpCode Endfilter;
+        public static readonly OpCode Endfinally;
+        public static readonly OpCode Initblk;
+        public static readonly OpCode Initobj;
+        public static readonly OpCode Isinst;
+        public static readonly OpCode Jmp;
+        public static readonly OpCode Ldarg;
+        public static readonly OpCode Ldarg_0;
+        public static readonly OpCode Ldarg_1;
+        public static readonly OpCode Ldarg_2;
+        public static readonly OpCode Ldarg_3;
+        public static readonly OpCode Ldarg_S;
+        public static readonly OpCode Ldarga;
+        public static readonly OpCode Ldarga_S;
+        public static readonly OpCode Ldc_I4;
+        public static readonly OpCode Ldc_I4_0;
+        public static readonly OpCode Ldc_I4_1;
+        public static readonly OpCode Ldc_I4_2;
+        public static readonly OpCode Ldc_I4_3;
+        public static readonly OpCode Ldc_I4_4;
+        public static readonly OpCode Ldc_I4_5;
+        public static readonly OpCode Ldc_I4_6;
+        public static readonly OpCode Ldc_I4_7;
+        public static readonly OpCode Ldc_I4_8;
+        public static readonly OpCode Ldc_I4_M1;
+        public static readonly OpCode Ldc_I4_S;
+        public static readonly OpCode Ldc_I8;
+        public static readonly OpCode Ldc_R4;
+        public static readonly OpCode Ldc_R8;
+        public static readonly OpCode Ldelem;
+        public static readonly OpCode Ldelem_I;
+        public static readonly OpCode Ldelem_I1;
+        public static readonly OpCode Ldelem_I2;
+        public static readonly OpCode Ldelem_I4;
+        public static readonly OpCode Ldelem_I8;
+        public static readonly OpCode Ldelem_R4;
+        public static readonly OpCode Ldelem_R8;
+        public static readonly OpCode Ldelem_Ref;
+        public static readonly OpCode Ldelem_U1;
+        public static readonly OpCode Ldelem_U2;
+        public static readonly OpCode Ldelem_U4;
+        public static readonly OpCode Ldelema;
+        public static readonly OpCode Ldfld;
+        public static readonly OpCode Ldflda;
+        public static readonly OpCode Ldftn;
+        public static readonly OpCode Ldind_I;
+        public static readonly OpCode Ldind_I1;
+        public static readonly OpCode Ldind_I2;
+        public static readonly OpCode Ldind_I4;
+        public static readonly OpCode Ldind_I8;
+        public static readonly OpCode Ldind_R4;
+        public static readonly OpCode Ldind_R8;
+        public static readonly OpCode Ldind_Ref;
+        public static readonly OpCode Ldind_U1;
+        public static readonly OpCode Ldind_U2;
+        public static readonly OpCode Ldind_U4;
+        public static readonly OpCode Ldlen;
+        public static readonly OpCode Ldloc;
+        public static readonly OpCode Ldloc_0;
+        public static readonly OpCode Ldloc_1;
+        public static readonly OpCode Ldloc_2;
+        public static readonly OpCode Ldloc_3;
+        public static readonly OpCode Ldloc_S;
+        public static readonly OpCode Ldloca;
+        public static readonly OpCode Ldloca_S;
+        public static readonly OpCode Ldnull;
+        public static readonly OpCode Ldobj;
+        public static readonly OpCode Ldsfld;
+        public static readonly OpCode Ldsflda;
+        public static readonly OpCode Ldstr;
+        public static readonly OpCode Ldtoken;
+        public static readonly OpCode Ldvirtftn;
+        public static readonly OpCode Leave;
+        public static readonly OpCode Leave_S;
+        public static readonly OpCode Localloc;
+        public static readonly OpCode Mkrefany;
+        public static readonly OpCode Mul;
+        public static readonly OpCode Mul_Ovf;
+        public static readonly OpCode Mul_Ovf_Un;
+        public static readonly OpCode Neg;
+        public static readonly OpCode Newarr;
+        public static readonly OpCode Newobj;
+        public static readonly OpCode Nop;
+        public static readonly OpCode Not;
+        public static readonly OpCode Or;
+        public static readonly OpCode Pop;
+        public static readonly OpCode Prefix1;
+        public static readonly OpCode Prefix2;
+        public static readonly OpCode Prefix3;
+        public static readonly OpCode Prefix4;
+        public static readonly OpCode Prefix5;
+        public static readonly OpCode Prefix6;
+        public static readonly OpCode Prefix7;
+        public static readonly OpCode Prefixref;
+        public static readonly OpCode Readonly;
+        public static readonly OpCode Refanytype;
+        public static readonly OpCode Refanyval;
+        public static readonly OpCode Rem;
+        public static readonly OpCode Rem_Un;
+        public static readonly OpCode Ret;
+        public static readonly OpCode Rethrow;
+        public static readonly OpCode Shl;
+        public static readonly OpCode Shr;
+        public static readonly OpCode Shr_Un;
+        public static readonly OpCode Sizeof;
+        public static readonly OpCode Starg;
+        public static readonly OpCode Starg_S;
+        public static readonly OpCode Stelem;
+        public static readonly OpCode Stelem_I;
+        public static readonly OpCode Stelem_I1;
+        public static readonly OpCode Stelem_I2;
+        public static readonly OpCode Stelem_I4;
+        public static readonly OpCode Stelem_I8;
+        public static readonly OpCode Stelem_R4;
+        public static readonly OpCode Stelem_R8;
+        public static readonly OpCode Stelem_Ref;
+        public static readonly OpCode Stfld;
+        public static readonly OpCode Stind_I;
+        public static readonly OpCode Stind_I1;
+        public static readonly OpCode Stind_I2;
+        public static readonly OpCode Stind_I4;
+        public static readonly OpCode Stind_I8;
+        public static readonly OpCode Stind_R4;
+        public static readonly OpCode Stind_R8;
+        public static readonly OpCode Stind_Ref;
+        public static readonly OpCode Stloc;
+        public static readonly OpCode Stloc_0;
+        public static readonly OpCode Stloc_1;
+        public static readonly OpCode Stloc_2;
+        public static readonly OpCode Stloc_3;
+        public static readonly OpCode Stloc_S;
+        public static readonly OpCode Stobj;
+        public static readonly OpCode Stsfld;
+        public static readonly OpCode Sub;
+        public static readonly OpCode Sub_Ovf;
+        public static readonly OpCode Sub_Ovf_Un;
+        public static readonly OpCode Switch;
+        public static readonly OpCode Tailcall;
+        public static readonly OpCode Throw;
+        public static readonly OpCode Unaligned;
+        public static readonly OpCode Unbox;
+        public static readonly OpCode Unbox_Any;
+        public static readonly OpCode Volatile;
+        public static readonly OpCode Xor;
+        public static bool TakesSingleByteArgument(OpCode inst);
+    }
+    public enum OpCodeType {
+        Macro = 1,
+        Nternal = 2,
+        Objmodel = 3,
+        Prefix = 4,
+        Primitive = 5,
+    }
+    public enum OperandType {
+        InlineBrTarget = 0,
+        InlineField = 1,
+        InlineI = 2,
+        InlineI8 = 3,
+        InlineMethod = 4,
+        InlineNone = 5,
+        InlineR = 7,
+        InlineSig = 9,
+        InlineString = 10,
+        InlineSwitch = 11,
+        InlineTok = 12,
+        InlineType = 13,
+        InlineVar = 14,
+        ShortInlineBrTarget = 15,
+        ShortInlineI = 16,
+        ShortInlineR = 17,
+        ShortInlineVar = 18,
+    }
+    public enum PackingSize {
+        Size1 = 1,
+        Size128 = 128,
+        Size16 = 16,
+        Size2 = 2,
+        Size32 = 32,
+        Size4 = 4,
+        Size64 = 64,
+        Size8 = 8,
+        Unspecified = 0,
+    }
+    public class ParameterBuilder {
+        public virtual int Attributes { get; }
+        public bool IsIn { get; }
+        public bool IsOptional { get; }
+        public bool IsOut { get; }
+        public virtual string Name { get; }
+        public virtual int Position { get; }
+        public virtual ParameterToken GetToken();
+        public virtual void SetConstant(object defaultValue);
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ParameterToken {
+        public static readonly ParameterToken Empty;
+        public int Token { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ParameterToken obj);
+        public override int GetHashCode();
+        public static bool operator ==(ParameterToken a, ParameterToken b);
+        public static bool operator !=(ParameterToken a, ParameterToken b);
+    }
+    public enum PEFileKinds {
+        ConsoleApplication = 2,
+        Dll = 1,
+        WindowApplication = 3,
+    }
+    public sealed class PropertyBuilder : PropertyInfo {
+        public override PropertyAttributes Attributes { get; }
+        public override bool CanRead { get; }
+        public override bool CanWrite { get; }
+        public override Type DeclaringType { get; }
+        public override Module Module { get; }
+        public override string Name { get; }
+        public PropertyToken PropertyToken { get; }
+        public override Type PropertyType { get; }
+        public override Type ReflectedType { get; }
+        public void AddOtherMethod(MethodBuilder mdBuilder);
+        public override MethodInfo[] GetAccessors(bool nonPublic);
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public override MethodInfo GetGetMethod(bool nonPublic);
+        public override ParameterInfo[] GetIndexParameters();
+        public override MethodInfo GetSetMethod(bool nonPublic);
+        public override object GetValue(object obj, object[] index);
+        public override object GetValue(object obj, BindingFlags invokeAttr, Binder binder, object[] index, CultureInfo culture);
+        public override bool IsDefined(Type attributeType, bool inherit);
+        public void SetConstant(object defaultValue);
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+        public void SetGetMethod(MethodBuilder mdBuilder);
+        public void SetSetMethod(MethodBuilder mdBuilder);
+        public override void SetValue(object obj, object value, object[] index);
+        public override void SetValue(object obj, object value, BindingFlags invokeAttr, Binder binder, object[] index, CultureInfo culture);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct PropertyToken {
+        public static readonly PropertyToken Empty;
+        public int Token { get; }
+        public override bool Equals(object obj);
+        public bool Equals(PropertyToken obj);
+        public override int GetHashCode();
+        public static bool operator ==(PropertyToken a, PropertyToken b);
+        public static bool operator !=(PropertyToken a, PropertyToken b);
+    }
+    public sealed class SignatureHelper {
+        public void AddArgument(Type clsArgument);
+        public void AddArgument(Type argument, bool pinned);
+        public void AddArgument(Type argument, Type[] requiredCustomModifiers, Type[] optionalCustomModifiers);
+        public void AddArguments(Type[] arguments, Type[][] requiredCustomModifiers, Type[][] optionalCustomModifiers);
+        public void AddSentinel();
+        public override bool Equals(object obj);
+        public static SignatureHelper GetFieldSigHelper(Module mod);
+        public override int GetHashCode();
+        public static SignatureHelper GetLocalVarSigHelper();
+        public static SignatureHelper GetLocalVarSigHelper(Module mod);
+        public static SignatureHelper GetMethodSigHelper(CallingConventions callingConvention, Type returnType);
+        public static SignatureHelper GetMethodSigHelper(Module mod, CallingConventions callingConvention, Type returnType);
+        public static SignatureHelper GetMethodSigHelper(Module mod, CallingConvention unmanagedCallConv, Type returnType);
+        public static SignatureHelper GetMethodSigHelper(Module mod, Type returnType, Type[] parameterTypes);
+        public static SignatureHelper GetMethodSigHelper(CallingConvention unmanagedCallingConvention, Type returnType);
+        public static SignatureHelper GetPropertySigHelper(Module mod, CallingConventions callingConvention, Type returnType, Type[] requiredReturnTypeCustomModifiers, Type[] optionalReturnTypeCustomModifiers, Type[] parameterTypes, Type[][] requiredParameterTypeCustomModifiers, Type[][] optionalParameterTypeCustomModifiers);
+        public static SignatureHelper GetPropertySigHelper(Module mod, Type returnType, Type[] parameterTypes);
+        public static SignatureHelper GetPropertySigHelper(Module mod, Type returnType, Type[] requiredReturnTypeCustomModifiers, Type[] optionalReturnTypeCustomModifiers, Type[] parameterTypes, Type[][] requiredParameterTypeCustomModifiers, Type[][] optionalParameterTypeCustomModifiers);
+        public byte[] GetSignature();
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SignatureToken {
+        public static readonly SignatureToken Empty;
+        public int Token { get; }
+        public override bool Equals(object obj);
+        public bool Equals(SignatureToken obj);
+        public override int GetHashCode();
+        public static bool operator ==(SignatureToken a, SignatureToken b);
+        public static bool operator !=(SignatureToken a, SignatureToken b);
+    }
+    public enum StackBehaviour {
+        Pop0 = 0,
+        Pop1 = 1,
+        Pop1_pop1 = 2,
+        Popi = 3,
+        Popi_pop1 = 4,
+        Popi_popi = 5,
+        Popi_popi_popi = 7,
+        Popi_popi8 = 6,
+        Popi_popr4 = 8,
+        Popi_popr8 = 9,
+        Popref = 10,
+        Popref_pop1 = 11,
+        Popref_popi = 12,
+        Popref_popi_pop1 = 28,
+        Popref_popi_popi = 13,
+        Popref_popi_popi8 = 14,
+        Popref_popi_popr4 = 15,
+        Popref_popi_popr8 = 16,
+        Popref_popi_popref = 17,
+        Push0 = 18,
+        Push1 = 19,
+        Push1_push1 = 20,
+        Pushi = 21,
+        Pushi8 = 22,
+        Pushr4 = 23,
+        Pushr8 = 24,
+        Pushref = 25,
+        Varpop = 26,
+        Varpush = 27,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct StringToken {
+        public int Token { get; }
+        public override bool Equals(object obj);
+        public bool Equals(StringToken obj);
+        public override int GetHashCode();
+        public static bool operator ==(StringToken a, StringToken b);
+        public static bool operator !=(StringToken a, StringToken b);
+    }
+    public sealed class TypeBuilder : TypeInfo {
+        public const int UnspecifiedTypeSize = 0;
+        public override Assembly Assembly { get; }
+        public override string AssemblyQualifiedName { get; }
+        public override TypeAttributes Attributes { get; }
+        public override Type BaseType { get; }
+        public override bool ContainsGenericParameters { get; }
+        public override MethodBase DeclaringMethod { get; }
+        public override Type DeclaringType { get; }
+        public override string FullName { get; }
+        public override GenericParameterAttributes GenericParameterAttributes { get; }
+        public override int GenericParameterPosition { get; }
+        public override Type[] GenericTypeArguments { get; }
+        public override Guid GUID { get; }
+        public override bool IsConstructedGenericType { get; }
+        public override bool IsEnum { get; }
+        public override bool IsGenericParameter { get; }
+        public override bool IsGenericType { get; }
+        public override bool IsGenericTypeDefinition { get; }
+        public override bool IsSerializable { get; }
+        public override Module Module { get; }
+        public override string Name { get; }
+        public override string Namespace { get; }
+        public PackingSize PackingSize { get; }
+        public override Type ReflectedType { get; }
+        public int Size { get; }
+        public override RuntimeTypeHandle TypeHandle { get; }
+        public TypeToken TypeToken { get; }
+        public override Type UnderlyingSystemType { get; }
+        public void AddInterfaceImplementation(Type interfaceType);
+        public Type CreateType();
+        public TypeInfo CreateTypeInfo();
+        public ConstructorBuilder DefineConstructor(MethodAttributes attributes, CallingConventions callingConvention, Type[] parameterTypes);
+        public ConstructorBuilder DefineConstructor(MethodAttributes attributes, CallingConventions callingConvention, Type[] parameterTypes, Type[][] requiredCustomModifiers, Type[][] optionalCustomModifiers);
+        public ConstructorBuilder DefineDefaultConstructor(MethodAttributes attributes);
+        public EventBuilder DefineEvent(string name, EventAttributes attributes, Type eventtype);
+        public FieldBuilder DefineField(string fieldName, Type type, FieldAttributes attributes);
+        public FieldBuilder DefineField(string fieldName, Type type, Type[] requiredCustomModifiers, Type[] optionalCustomModifiers, FieldAttributes attributes);
+        public GenericTypeParameterBuilder[] DefineGenericParameters(params string[] names);
+        public FieldBuilder DefineInitializedData(string name, byte[] data, FieldAttributes attributes);
+        public MethodBuilder DefineMethod(string name, MethodAttributes attributes);
+        public MethodBuilder DefineMethod(string name, MethodAttributes attributes, CallingConventions callingConvention);
+        public MethodBuilder DefineMethod(string name, MethodAttributes attributes, CallingConventions callingConvention, Type returnType, Type[] parameterTypes);
+        public MethodBuilder DefineMethod(string name, MethodAttributes attributes, CallingConventions callingConvention, Type returnType, Type[] returnTypeRequiredCustomModifiers, Type[] returnTypeOptionalCustomModifiers, Type[] parameterTypes, Type[][] parameterTypeRequiredCustomModifiers, Type[][] parameterTypeOptionalCustomModifiers);
+        public MethodBuilder DefineMethod(string name, MethodAttributes attributes, Type returnType, Type[] parameterTypes);
+        public void DefineMethodOverride(MethodInfo methodInfoBody, MethodInfo methodInfoDeclaration);
+        public TypeBuilder DefineNestedType(string name);
+        public TypeBuilder DefineNestedType(string name, TypeAttributes attr);
+        public TypeBuilder DefineNestedType(string name, TypeAttributes attr, Type parent);
+        public TypeBuilder DefineNestedType(string name, TypeAttributes attr, Type parent, int typeSize);
+        public TypeBuilder DefineNestedType(string name, TypeAttributes attr, Type parent, PackingSize packSize);
+        public TypeBuilder DefineNestedType(string name, TypeAttributes attr, Type parent, PackingSize packSize, int typeSize);
+        public TypeBuilder DefineNestedType(string name, TypeAttributes attr, Type parent, Type[] interfaces);
+        public PropertyBuilder DefineProperty(string name, PropertyAttributes attributes, CallingConventions callingConvention, Type returnType, Type[] parameterTypes);
+        public PropertyBuilder DefineProperty(string name, PropertyAttributes attributes, CallingConventions callingConvention, Type returnType, Type[] returnTypeRequiredCustomModifiers, Type[] returnTypeOptionalCustomModifiers, Type[] parameterTypes, Type[][] parameterTypeRequiredCustomModifiers, Type[][] parameterTypeOptionalCustomModifiers);
+        public PropertyBuilder DefineProperty(string name, PropertyAttributes attributes, Type returnType, Type[] parameterTypes);
+        public PropertyBuilder DefineProperty(string name, PropertyAttributes attributes, Type returnType, Type[] returnTypeRequiredCustomModifiers, Type[] returnTypeOptionalCustomModifiers, Type[] parameterTypes, Type[][] parameterTypeRequiredCustomModifiers, Type[][] parameterTypeOptionalCustomModifiers);
+        public ConstructorBuilder DefineTypeInitializer();
+        public FieldBuilder DefineUninitializedData(string name, int size, FieldAttributes attributes);
+        public override int GetArrayRank();
+        protected override TypeAttributes GetAttributeFlagsImpl();
+        public static ConstructorInfo GetConstructor(Type type, ConstructorInfo constructor);
+        protected override ConstructorInfo GetConstructorImpl(BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public override ConstructorInfo[] GetConstructors(BindingFlags bindingAttr);
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public override Type GetElementType();
+        public override EventInfo GetEvent(string name, BindingFlags bindingAttr);
+        public override EventInfo[] GetEvents();
+        public override EventInfo[] GetEvents(BindingFlags bindingAttr);
+        public override FieldInfo GetField(string name, BindingFlags bindingAttr);
+        public static FieldInfo GetField(Type type, FieldInfo field);
+        public override FieldInfo[] GetFields(BindingFlags bindingAttr);
+        public override Type[] GetGenericArguments();
+        public override Type[] GetGenericParameterConstraints();
+        public override Type GetGenericTypeDefinition();
+        public override Type GetInterface(string name, bool ignoreCase);
+        public override InterfaceMapping GetInterfaceMap(Type interfaceType);
+        public override Type[] GetInterfaces();
+        public override MemberInfo[] GetMember(string name, MemberTypes type, BindingFlags bindingAttr);
+        public override MemberInfo[] GetMembers(BindingFlags bindingAttr);
+        public static MethodInfo GetMethod(Type type, MethodInfo method);
+        protected override MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public override MethodInfo[] GetMethods(BindingFlags bindingAttr);
+        public override Type GetNestedType(string name, BindingFlags bindingAttr);
+        public override Type[] GetNestedTypes(BindingFlags bindingAttr);
+        public override PropertyInfo[] GetProperties(BindingFlags bindingAttr);
+        protected override PropertyInfo GetPropertyImpl(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        protected override bool HasElementTypeImpl();
+        public override object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] namedParameters);
+        protected override bool IsArrayImpl();
+        public override bool IsAssignableFrom(TypeInfo typeInfo);
+        public override bool IsAssignableFrom(Type c);
+        protected override bool IsByRefImpl();
+        protected override bool IsCOMObjectImpl();
+        public bool IsCreated();
+        public override bool IsDefined(Type attributeType, bool inherit);
+        protected override bool IsPointerImpl();
+        protected override bool IsPrimitiveImpl();
+        public override bool IsSubclassOf(Type c);
+        public override Type MakeArrayType();
+        public override Type MakeArrayType(int rank);
+        public override Type MakeByRefType();
+        public override Type MakeGenericType(params Type[] typeArguments);
+        public override Type MakePointerType();
+        public void SetCustomAttribute(ConstructorInfo con, byte[] binaryAttribute);
+        public void SetCustomAttribute(CustomAttributeBuilder customBuilder);
+        public void SetParent(Type parent);
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeToken {
+        public static readonly TypeToken Empty;
+        public int Token { get; }
+        public override bool Equals(object obj);
+        public bool Equals(TypeToken obj);
+        public override int GetHashCode();
+        public static bool operator ==(TypeToken a, TypeToken b);
+        public static bool operator !=(TypeToken a, TypeToken b);
+    }
+}
```

