# System.Runtime

``` diff
+namespace System.Runtime {
+    public enum AsyncCompletionResult {
+        Completed = 1,
+        Queued = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct DefaultTaskSchedulerAwaiter : INotifyCompletion {
+        public static DefaultTaskSchedulerAwaiter Singleton;
+        public bool IsCompleted { get; }
+        public DefaultTaskSchedulerAwaiter GetAwaiter();
+        public void GetResult();
+        public void OnCompleted(Action continuation);
+    }
+    public static class Fx {
+        public static Fx.ExceptionHandler AsynchronousThreadExceptionHandler { get; set; }
+        public static byte[] AllocateByteArray(int size);
+        public static char[] AllocateCharArray(int size);
+        public static void Assert(bool condition, string description);
+        public static void Assert(string description);
+        public static void AssertAndFailFast(bool condition, string description);
+        [MethodImpl(NoInlining)]public static Exception AssertAndFailFast(string description);
+        public static void AssertAndThrow(bool condition, string description);
+        [MethodImpl(NoInlining)]public static Exception AssertAndThrow(string description);
+        public static void AssertAndThrowFatal(bool condition, string description);
+        [MethodImpl(NoInlining)]public static Exception AssertAndThrowFatal(string description);
+        public static Guid CreateGuid(string guidString);
+        public static bool IsFatal(Exception exception);
+        public static AsyncCallback ThunkCallback(AsyncCallback callback);
+        public static bool TryCreateGuid(string guidString, out Guid result);
+        public abstract class ExceptionHandler {
+            protected ExceptionHandler();
+            public abstract bool HandleException(Exception exception);
+        }
+        public static class Tag {
+            public sealed class BlockingAttribute : Attribute {
+                public BlockingAttribute();
+                public Type CancelDeclaringType { get; set; }
+                public string CancelMethod { get; set; }
+                public string Conditional { get; set; }
+            }
+            public enum BlocksUsing {
+                AsyncResult = 4,
+                AutoResetEvent = 3,
+                IAsyncResult = 5,
+                InputQueue = 7,
+                ManualResetEvent = 2,
+                MonitorEnter = 0,
+                MonitorWait = 1,
+                NonBlocking = 14,
+                Other = 13,
+                OtherFrameworkPrimitive = 11,
+                OtherInternalPrimitive = 10,
+                OtherInterop = 12,
+                PInvoke = 6,
+                PrivatePrimitive = 9,
+                ThreadNeutralSemaphore = 8,
+            }
+            public sealed class CacheAttribute : Attribute {
+                public CacheAttribute(Type elementType, Fx.Tag.CacheAttrition cacheAttrition);
+                public Fx.Tag.CacheAttrition CacheAttrition { get; }
+                public Type ElementType { get; }
+                public string Scope { get; set; }
+                public string SizeLimit { get; set; }
+                public string Timeout { get; set; }
+            }
+            public enum CacheAttrition {
+                ElementOnCallback = 3,
+                ElementOnGC = 2,
+                ElementOnTimer = 1,
+                FullPurgeOnEachAccess = 5,
+                FullPurgeOnTimer = 4,
+                None = 0,
+                PartialPurgeOnEachAccess = 7,
+                PartialPurgeOnTimer = 6,
+            }
+            public sealed class ExternalResourceAttribute : Attribute {
+                public ExternalResourceAttribute(Fx.Tag.Location location, string description);
+                public string Description { get; }
+                public Fx.Tag.Location Location { get; }
+            }
+            public sealed class FriendAccessAllowedAttribute : Attribute {
+                public FriendAccessAllowedAttribute(string assemblyName);
+                public string AssemblyName { get; set; }
+            }
+            public sealed class GuaranteeNonBlockingAttribute : Attribute {
+                public GuaranteeNonBlockingAttribute();
+            }
+            public sealed class InheritThrowsAttribute : Attribute {
+                public InheritThrowsAttribute();
+                public string From { get; set; }
+                public Type FromDeclaringType { get; set; }
+            }
+            public sealed class KnownXamlExternalAttribute : Attribute {
+                public KnownXamlExternalAttribute();
+            }
+            public enum Location {
+                InProcess = 0,
+                LocalOrRemoteSystem = 3,
+                LocalSystem = 2,
+                OutOfProcess = 1,
+                RemoteSystem = 4,
+            }
+            public sealed class NonThrowingAttribute : Attribute {
+                public NonThrowingAttribute();
+            }
+            public sealed class QueueAttribute : Attribute {
+                public QueueAttribute(Type elementType);
+                public Type ElementType { get; }
+                public bool EnqueueThrowsIfFull { get; set; }
+                public string Scope { get; set; }
+                public string SizeLimit { get; set; }
+                public bool StaleElementsRemovedImmediately { get; set; }
+            }
+            public sealed class SecurityNoteAttribute : Attribute {
+                public SecurityNoteAttribute();
+                public string Critical { get; set; }
+                public string Miscellaneous { get; set; }
+                public string Safe { get; set; }
+            }
+            public static class Strings
+            public enum SynchronizationKind {
+                FromFieldType = 5,
+                InterlockedNoSpin = 3,
+                InterlockedWithSpin = 4,
+                LockStatement = 0,
+                MonitorExplicit = 2,
+                MonitorWait = 1,
+            }
+            public sealed class SynchronizationObjectAttribute : Attribute {
+                public SynchronizationObjectAttribute();
+                public bool Blocking { get; set; }
+                public Fx.Tag.SynchronizationKind Kind { get; set; }
+                public string Scope { get; set; }
+            }
+            public sealed class SynchronizationPrimitiveAttribute : Attribute {
+                public SynchronizationPrimitiveAttribute(Fx.Tag.BlocksUsing blocksUsing);
+                public Fx.Tag.BlocksUsing BlocksUsing { get; }
+                public string ReleaseMethod { get; set; }
+                public bool Spins { get; set; }
+                public bool SupportsAsync { get; set; }
+            }
+            public enum ThrottleAction {
+                Pause = 1,
+                Reject = 0,
+            }
+            public sealed class ThrottleAttribute : Attribute {
+                public ThrottleAttribute(Fx.Tag.ThrottleAction throttleAction, Fx.Tag.ThrottleMetric throttleMetric, string limit);
+                public string Limit { get; }
+                public string Scope { get; set; }
+                public Fx.Tag.ThrottleAction ThrottleAction { get; }
+                public Fx.Tag.ThrottleMetric ThrottleMetric { get; }
+            }
+            public enum ThrottleMetric {
+                Count = 0,
+                Other = 2,
+                Rate = 1,
+            }
+            public static class Throws {
+                public sealed class TimeoutAttribute : Fx.Tag.ThrowsAttribute {
+                    public TimeoutAttribute();
+                    public TimeoutAttribute(string diagnosis);
+                }
+            }
+            public class ThrowsAttribute : Attribute {
+                public ThrowsAttribute(Type exceptionType, string diagnosis);
+                public string Diagnosis { get; }
+                public Type ExceptionType { get; }
+            }
+            public sealed class XamlVisibleAttribute : Attribute {
+                public XamlVisibleAttribute();
+                public XamlVisibleAttribute(bool visible);
+                public bool Visible { get; private set; }
+            }
+        }
+    }
+    public enum GCLargeObjectHeapCompactionMode {
+        CompactOnce = 2,
+        Default = 1,
+    }
+    public enum GCLatencyMode {
+        Batch = 0,
+        Interactive = 1,
+        LowLatency = 2,
+        NoGCRegion = 4,
+        SustainedLowLatency = 3,
+    }
+    public static class GCSettings {
+        public static bool IsServerGC { get; }
+        public static GCLargeObjectHeapCompactionMode LargeObjectHeapCompactionMode { get; set; }
+        public static GCLatencyMode LatencyMode { get; set; }
+    }
+    public class MruCache<TKey, TValue> where TKey : class where TValue : class {
+        public MruCache(int watermark);
+        public MruCache(int lowWatermark, int highWatermark);
+        public MruCache(int lowWatermark, int highWatermark, IEqualityComparer<TKey> comparer);
+        public int Count { get; }
+        public void Add(TKey key, TValue value);
+        public void Clear();
+        protected virtual void OnItemAgedOutOfCache(TValue item);
+        protected virtual void OnSingleItemRemoved(TValue item);
+        public bool Remove(TKey key);
+        public bool TryGetValue(TKey key, out TValue value);
+    }
+    public class OutWrapper<T> {
+        public OutWrapper();
+        public T Value { get; set; }
+        public static implicit operator T (OutWrapper<T> wrapper);
+    }
+    public static class TaskHelpers {
+        public static Action<object> OnAsyncCompletionCallback;
+        public static Task AsyncWait<TException>(this Task task);
+        public static Task<bool> AwaitWithTimeout(this Task task, TimeSpan timeout);
+        public static Task CompletedTask();
+        public static DefaultTaskSchedulerAwaiter EnsureDefaultTaskScheduler();
+        public static Task ToApm(this Task task, AsyncCallback callback, object state);
+        public static Task<TResult> ToApm<TResult>(this Task<TResult> task, AsyncCallback callback, object state);
+        public static void ToApmEnd(this IAsyncResult iar);
+        public static TResult ToApmEnd<TResult>(this IAsyncResult iar);
+        public static void Wait(this Task task, TimeSpan timeout, Action<Exception, TimeSpan, string> exceptionConverter, string operationType);
+        public static void WaitForCompletion(this Task task);
+        public static TResult WaitForCompletion<TResult>(this Task<TResult> task);
+        public static void WaitForCompletionNoSpin(this Task task);
+        public static bool WaitForCompletionNoSpin(this Task task, TimeSpan timeout);
+        public static TResult WaitForCompletionNoSpin<TResult>(this Task<TResult> task);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TimeoutHelper {
+        public static readonly TimeSpan MaxWait;
+        public TimeoutHelper(TimeSpan timeout);
+        public TimeSpan OriginalTimeout { get; }
+        public static DateTime Add(DateTime time, TimeSpan timeout);
+        public static TimeSpan Add(TimeSpan timeout1, TimeSpan timeout2);
+        public static TimeSpan Divide(TimeSpan timeout, int factor);
+        public TimeSpan ElapsedTime();
+        public static TimeSpan FromMilliseconds(int milliseconds);
+        public CancellationToken GetCancellationToken();
+        public Task<CancellationToken> GetCancellationTokenAsync();
+        public static bool IsTooLarge(TimeSpan timeout);
+        public static TimeSpan Min(TimeSpan val1, TimeSpan val2);
+        public TimeSpan RemainingTime();
+        public static DateTime Subtract(DateTime time, TimeSpan timeout);
+        public static void ThrowIfNegativeArgument(TimeSpan timeout);
+        public static void ThrowIfNegativeArgument(TimeSpan timeout, string argumentName);
+        public static void ThrowIfNonPositiveArgument(TimeSpan timeout);
+        public static void ThrowIfNonPositiveArgument(TimeSpan timeout, string argumentName);
+        public static int ToMilliseconds(TimeSpan timeout);
+        public static bool WaitOne(WaitHandle waitHandle, TimeSpan timeout);
+    }
+}
```

