# System.Security.Cryptography.X509Certificates

``` diff
+namespace System.Security.Cryptography.X509Certificates {
+    public static class ECDsaCertificateExtensions {
+        public static ECDsa GetECDsaPrivateKey(this X509Certificate2 certificate);
+        public static ECDsa GetECDsaPublicKey(this X509Certificate2 certificate);
+    }
+    public enum OpenFlags {
+        IncludeArchived = 8,
+        MaxAllowed = 2,
+        OpenExistingOnly = 4,
+        ReadOnly = 0,
+        ReadWrite = 1,
+    }
+    public sealed class PublicKey {
+        public PublicKey(Oid oid, AsnEncodedData parameters, AsnEncodedData keyValue);
+        public AsnEncodedData EncodedKeyValue { get; }
+        public AsnEncodedData EncodedParameters { get; }
+        public Oid Oid { get; }
+    }
+    public static class RSACertificateExtensions {
+        public static RSA GetRSAPrivateKey(this X509Certificate2 certificate);
+        public static RSA GetRSAPublicKey(this X509Certificate2 certificate);
+    }
+    public enum StoreLocation {
+        CurrentUser = 1,
+        LocalMachine = 2,
+    }
+    public enum StoreName {
+        AddressBook = 1,
+        AuthRoot = 2,
+        CertificateAuthority = 3,
+        Disallowed = 4,
+        My = 5,
+        Root = 6,
+        TrustedPeople = 7,
+        TrustedPublisher = 8,
+    }
+    public sealed class X500DistinguishedName : AsnEncodedData {
+        public X500DistinguishedName(byte[] encodedDistinguishedName);
+        public X500DistinguishedName(AsnEncodedData encodedDistinguishedName);
+        public X500DistinguishedName(X500DistinguishedName distinguishedName);
+        public X500DistinguishedName(string distinguishedName);
+        public X500DistinguishedName(string distinguishedName, X500DistinguishedNameFlags flag);
+        public string Name { get; }
+        public string Decode(X500DistinguishedNameFlags flag);
+        public override string Format(bool multiLine);
+    }
+    public enum X500DistinguishedNameFlags {
+        DoNotUsePlusSign = 32,
+        DoNotUseQuotes = 64,
+        ForceUTF8Encoding = 16384,
+        None = 0,
+        Reversed = 1,
+        UseCommas = 128,
+        UseNewLines = 256,
+        UseSemicolons = 16,
+        UseT61Encoding = 8192,
+        UseUTF8Encoding = 4096,
+    }
+    public sealed class X509BasicConstraintsExtension : X509Extension {
+        public X509BasicConstraintsExtension();
+        public X509BasicConstraintsExtension(bool certificateAuthority, bool hasPathLengthConstraint, int pathLengthConstraint, bool critical);
+        public X509BasicConstraintsExtension(AsnEncodedData encodedBasicConstraints, bool critical);
+        public bool CertificateAuthority { get; }
+        public bool HasPathLengthConstraint { get; }
+        public int PathLengthConstraint { get; }
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+    }
+    public class X509Certificate : IDisposable {
+        public X509Certificate();
+        public X509Certificate(byte[] data);
+        public X509Certificate(byte[] rawData, string password);
+        public X509Certificate(byte[] rawData, string password, X509KeyStorageFlags keyStorageFlags);
+        public X509Certificate(IntPtr handle);
+        public X509Certificate(string fileName);
+        public X509Certificate(string fileName, string password);
+        public X509Certificate(string fileName, string password, X509KeyStorageFlags keyStorageFlags);
+        public IntPtr Handle { get; }
+        public string Issuer { get; }
+        public string Subject { get; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public override bool Equals(object obj);
+        public virtual bool Equals(X509Certificate other);
+        public virtual byte[] Export(X509ContentType contentType);
+        public virtual byte[] Export(X509ContentType contentType, string password);
+        public virtual byte[] GetCertHash();
+        public virtual string GetFormat();
+        public override int GetHashCode();
+        public virtual string GetKeyAlgorithm();
+        public virtual byte[] GetKeyAlgorithmParameters();
+        public virtual string GetKeyAlgorithmParametersString();
+        public virtual byte[] GetPublicKey();
+        public virtual byte[] GetSerialNumber();
+        public override string ToString();
+        public virtual string ToString(bool fVerbose);
+    }
+    public class X509Certificate2 : X509Certificate {
+        public X509Certificate2();
+        public X509Certificate2(byte[] rawData);
+        public X509Certificate2(byte[] rawData, string password);
+        public X509Certificate2(byte[] rawData, string password, X509KeyStorageFlags keyStorageFlags);
+        public X509Certificate2(IntPtr handle);
+        public X509Certificate2(string fileName);
+        public X509Certificate2(string fileName, string password);
+        public X509Certificate2(string fileName, string password, X509KeyStorageFlags keyStorageFlags);
+        public bool Archived { get; set; }
+        public X509ExtensionCollection Extensions { get; }
+        public string FriendlyName { get; set; }
+        public bool HasPrivateKey { get; }
+        public X500DistinguishedName IssuerName { get; }
+        public DateTime NotAfter { get; }
+        public DateTime NotBefore { get; }
+        public PublicKey PublicKey { get; }
+        public byte[] RawData { get; }
+        public string SerialNumber { get; }
+        public Oid SignatureAlgorithm { get; }
+        public X500DistinguishedName SubjectName { get; }
+        public string Thumbprint { get; }
+        public int Version { get; }
+        public static X509ContentType GetCertContentType(byte[] rawData);
+        public static X509ContentType GetCertContentType(string fileName);
+        public string GetNameInfo(X509NameType nameType, bool forIssuer);
+        public override string ToString();
+        public override string ToString(bool verbose);
+    }
+    public class X509Certificate2Collection : X509CertificateCollection {
+        public X509Certificate2Collection();
+        public X509Certificate2Collection(X509Certificate2 certificate);
+        public X509Certificate2Collection(X509Certificate2[] certificates);
+        public X509Certificate2Collection(X509Certificate2Collection certificates);
+        public new X509Certificate2 this[int index] { get; set; }
+        public int Add(X509Certificate2 certificate);
+        public void AddRange(X509Certificate2[] certificates);
+        public void AddRange(X509Certificate2Collection certificates);
+        public bool Contains(X509Certificate2 certificate);
+        public byte[] Export(X509ContentType contentType);
+        public byte[] Export(X509ContentType contentType, string password);
+        public X509Certificate2Collection Find(X509FindType findType, object findValue, bool validOnly);
+        public new X509Certificate2Enumerator GetEnumerator();
+        public void Import(byte[] rawData);
+        public void Import(byte[] rawData, string password, X509KeyStorageFlags keyStorageFlags);
+        public void Import(string fileName);
+        public void Import(string fileName, string password, X509KeyStorageFlags keyStorageFlags);
+        public void Insert(int index, X509Certificate2 certificate);
+        public void Remove(X509Certificate2 certificate);
+        public void RemoveRange(X509Certificate2[] certificates);
+        public void RemoveRange(X509Certificate2Collection certificates);
+    }
+    public sealed class X509Certificate2Enumerator : IEnumerator {
+        public X509Certificate2 Current { get; }
+        object System.Collections.IEnumerator.Current { get; }
+        public bool MoveNext();
+        public void Reset();
+        bool System.Collections.IEnumerator.MoveNext();
+        void System.Collections.IEnumerator.Reset();
+    }
+    public class X509CertificateCollection : ICollection, IEnumerable, IList {
+        public X509CertificateCollection();
+        public X509CertificateCollection(X509Certificate[] value);
+        public X509CertificateCollection(X509CertificateCollection value);
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public X509Certificate this[int index] { get; set; }
+        public int Add(X509Certificate value);
+        public void AddRange(X509Certificate[] value);
+        public void AddRange(X509CertificateCollection value);
+        public void Clear();
+        public bool Contains(X509Certificate value);
+        public void CopyTo(X509Certificate[] array, int index);
+        public X509CertificateCollection.X509CertificateEnumerator GetEnumerator();
+        public override int GetHashCode();
+        public int IndexOf(X509Certificate value);
+        public void Insert(int index, X509Certificate value);
+        public void Remove(X509Certificate value);
+        public void RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        int System.Collections.IList.Add(object value);
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+        public class X509CertificateEnumerator : IEnumerator {
+            public X509CertificateEnumerator(X509CertificateCollection mappings);
+            public X509Certificate Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            public void Reset();
+            bool System.Collections.IEnumerator.MoveNext();
+            void System.Collections.IEnumerator.Reset();
+        }
+    }
+    public class X509Chain : IDisposable {
+        public X509Chain();
+        public X509ChainElementCollection ChainElements { get; }
+        public X509ChainPolicy ChainPolicy { get; set; }
+        public X509ChainStatus[] ChainStatus { get; }
+        public SafeX509ChainHandle SafeHandle { get; }
+        public bool Build(X509Certificate2 certificate);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+    }
+    public class X509ChainElement {
+        public X509Certificate2 Certificate { get; }
+        public X509ChainStatus[] ChainElementStatus { get; }
+        public string Information { get; }
+    }
+    public sealed class X509ChainElementCollection : ICollection, IEnumerable {
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public X509ChainElement this[int index] { get; }
+        public void CopyTo(X509ChainElement[] array, int index);
+        public X509ChainElementEnumerator GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public sealed class X509ChainElementEnumerator : IEnumerator {
+        public X509ChainElement Current { get; }
+        object System.Collections.IEnumerator.Current { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
+    public sealed class X509ChainPolicy {
+        public X509ChainPolicy();
+        public OidCollection ApplicationPolicy { get; }
+        public OidCollection CertificatePolicy { get; }
+        public X509Certificate2Collection ExtraStore { get; }
+        public X509RevocationFlag RevocationFlag { get; set; }
+        public X509RevocationMode RevocationMode { get; set; }
+        public TimeSpan UrlRetrievalTimeout { get; set; }
+        public X509VerificationFlags VerificationFlags { get; set; }
+        public DateTime VerificationTime { get; set; }
+        public void Reset();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct X509ChainStatus {
+        public X509ChainStatusFlags Status { get; set; }
+        public string StatusInformation { get; set; }
+    }
+    public enum X509ChainStatusFlags {
+        CtlNotSignatureValid = 262144,
+        CtlNotTimeValid = 131072,
+        CtlNotValidForUsage = 524288,
+        Cyclic = 128,
+        ExplicitDistrust = 67108864,
+        HasExcludedNameConstraint = 32768,
+        HasNotDefinedNameConstraint = 8192,
+        HasNotPermittedNameConstraint = 16384,
+        HasNotSupportedCriticalExtension = 134217728,
+        HasNotSupportedNameConstraint = 4096,
+        HasWeakSignature = 1048576,
+        InvalidBasicConstraints = 1024,
+        InvalidExtension = 256,
+        InvalidNameConstraints = 2048,
+        InvalidPolicyConstraints = 512,
+        NoError = 0,
+        NoIssuanceChainPolicy = 33554432,
+        NotSignatureValid = 8,
+        NotTimeNested = 2,
+        NotTimeValid = 1,
+        NotValidForUsage = 16,
+        OfflineRevocation = 16777216,
+        PartialChain = 65536,
+        RevocationStatusUnknown = 64,
+        Revoked = 4,
+        UntrustedRoot = 32,
+    }
+    public enum X509ContentType {
+        Authenticode = 6,
+        Cert = 1,
+        Pfx = 3,
+        Pkcs12 = 3,
+        Pkcs7 = 5,
+        SerializedCert = 2,
+        SerializedStore = 4,
+        Unknown = 0,
+    }
+    public sealed class X509EnhancedKeyUsageExtension : X509Extension {
+        public X509EnhancedKeyUsageExtension();
+        public X509EnhancedKeyUsageExtension(AsnEncodedData encodedEnhancedKeyUsages, bool critical);
+        public X509EnhancedKeyUsageExtension(OidCollection enhancedKeyUsages, bool critical);
+        public OidCollection EnhancedKeyUsages { get; }
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+    }
+    public class X509Extension : AsnEncodedData {
+        protected X509Extension();
+        public X509Extension(AsnEncodedData encodedExtension, bool critical);
+        public X509Extension(Oid oid, byte[] rawData, bool critical);
+        public X509Extension(string oid, byte[] rawData, bool critical);
+        public bool Critical { get; set; }
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+    }
+    public sealed class X509ExtensionCollection : ICollection, IEnumerable {
+        public X509ExtensionCollection();
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public X509Extension this[int index] { get; }
+        public X509Extension this[string oid] { get; }
+        public int Add(X509Extension extension);
+        public void CopyTo(X509Extension[] array, int index);
+        public X509ExtensionEnumerator GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public sealed class X509ExtensionEnumerator : IEnumerator {
+        public X509Extension Current { get; }
+        object System.Collections.IEnumerator.Current { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
+    public enum X509FindType {
+        FindByApplicationPolicy = 10,
+        FindByCertificatePolicy = 11,
+        FindByExtension = 12,
+        FindByIssuerDistinguishedName = 4,
+        FindByIssuerName = 3,
+        FindByKeyUsage = 13,
+        FindBySerialNumber = 5,
+        FindBySubjectDistinguishedName = 2,
+        FindBySubjectKeyIdentifier = 14,
+        FindBySubjectName = 1,
+        FindByTemplateName = 9,
+        FindByThumbprint = 0,
+        FindByTimeExpired = 8,
+        FindByTimeNotYetValid = 7,
+        FindByTimeValid = 6,
+    }
+    public enum X509KeyStorageFlags {
+        DefaultKeySet = 0,
+        Exportable = 4,
+        MachineKeySet = 2,
+        PersistKeySet = 16,
+        UserKeySet = 1,
+        UserProtected = 8,
+    }
+    public sealed class X509KeyUsageExtension : X509Extension {
+        public X509KeyUsageExtension();
+        public X509KeyUsageExtension(AsnEncodedData encodedKeyUsage, bool critical);
+        public X509KeyUsageExtension(X509KeyUsageFlags keyUsages, bool critical);
+        public X509KeyUsageFlags KeyUsages { get; }
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+    }
+    public enum X509KeyUsageFlags {
+        CrlSign = 2,
+        DataEncipherment = 16,
+        DecipherOnly = 32768,
+        DigitalSignature = 128,
+        EncipherOnly = 1,
+        KeyAgreement = 8,
+        KeyCertSign = 4,
+        KeyEncipherment = 32,
+        None = 0,
+        NonRepudiation = 64,
+    }
+    public enum X509NameType {
+        DnsFromAlternativeName = 4,
+        DnsName = 3,
+        EmailName = 1,
+        SimpleName = 0,
+        UpnName = 2,
+        UrlName = 5,
+    }
+    public enum X509RevocationFlag {
+        EndCertificateOnly = 0,
+        EntireChain = 1,
+        ExcludeRoot = 2,
+    }
+    public enum X509RevocationMode {
+        NoCheck = 0,
+        Offline = 2,
+        Online = 1,
+    }
+    public sealed class X509Store : IDisposable {
+        public X509Store();
+        public X509Store(StoreName storeName, StoreLocation storeLocation);
+        public X509Store(string storeName, StoreLocation storeLocation);
+        public X509Certificate2Collection Certificates { get; }
+        public StoreLocation Location { get; }
+        public string Name { get; }
+        public void Add(X509Certificate2 certificate);
+        public void Dispose();
+        public void Open(OpenFlags flags);
+        public void Remove(X509Certificate2 certificate);
+    }
+    public sealed class X509SubjectKeyIdentifierExtension : X509Extension {
+        public X509SubjectKeyIdentifierExtension();
+        public X509SubjectKeyIdentifierExtension(byte[] subjectKeyIdentifier, bool critical);
+        public X509SubjectKeyIdentifierExtension(AsnEncodedData encodedSubjectKeyIdentifier, bool critical);
+        public X509SubjectKeyIdentifierExtension(PublicKey key, bool critical);
+        public X509SubjectKeyIdentifierExtension(PublicKey key, X509SubjectKeyIdentifierHashAlgorithm algorithm, bool critical);
+        public X509SubjectKeyIdentifierExtension(string subjectKeyIdentifier, bool critical);
+        public string SubjectKeyIdentifier { get; }
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+    }
+    public enum X509SubjectKeyIdentifierHashAlgorithm {
+        CapiSha1 = 2,
+        Sha1 = 0,
+        ShortSha1 = 1,
+    }
+    public enum X509VerificationFlags {
+        AllFlags = 4095,
+        AllowUnknownCertificateAuthority = 16,
+        IgnoreCertificateAuthorityRevocationUnknown = 1024,
+        IgnoreCtlNotTimeValid = 2,
+        IgnoreCtlSignerRevocationUnknown = 512,
+        IgnoreEndRevocationUnknown = 256,
+        IgnoreInvalidBasicConstraints = 8,
+        IgnoreInvalidName = 64,
+        IgnoreInvalidPolicy = 128,
+        IgnoreNotTimeNested = 4,
+        IgnoreNotTimeValid = 1,
+        IgnoreRootRevocationUnknown = 2048,
+        IgnoreWrongUsage = 32,
+        NoFlag = 0,
+    }
+}
```

