# System.Security.Permissions

``` diff
+namespace System.Security.Permissions {
+    public abstract class CodeAccessSecurityAttribute : SecurityAttribute {
+        protected CodeAccessSecurityAttribute(SecurityAction action);
+    }
+    public enum SecurityAction {
+        Assert = 3,
+        Demand = 2,
+        Deny = 4,
+        InheritanceDemand = 7,
+        LinkDemand = 6,
+        PermitOnly = 5,
+        RequestMinimum = 8,
+        RequestOptional = 9,
+        RequestRefuse = 10,
+    }
+    public abstract class SecurityAttribute : Attribute {
+        protected SecurityAttribute(SecurityAction action);
+        public SecurityAction Action { get; set; }
+        public bool Unrestricted { get; set; }
+    }
+    public sealed class SecurityPermissionAttribute : CodeAccessSecurityAttribute {
+        public SecurityPermissionAttribute(SecurityAction action);
+        public bool ControlAppDomain { get; set; }
+        public bool ControlDomainPolicy { get; set; }
+        public bool ControlEvidence { get; set; }
+        public bool ControlPolicy { get; set; }
+        public bool ControlThread { get; set; }
+        public SecurityPermissionFlag Flags { get; set; }
+        public bool SkipVerification { get; set; }
+        public bool UnmanagedCode { get; set; }
+    }
+    public enum SecurityPermissionFlag {
+        AllFlags = 16383,
+        Assertion = 1,
+        BindingRedirects = 8192,
+        ControlAppDomain = 1024,
+        ControlDomainPolicy = 256,
+        ControlEvidence = 32,
+        ControlPolicy = 64,
+        ControlPrincipal = 512,
+        ControlThread = 16,
+        Execution = 8,
+        Infrastructure = 4096,
+        NoFlags = 0,
+        RemotingConfiguration = 2048,
+        SerializationFormatter = 128,
+        SkipVerification = 4,
+        UnmanagedCode = 2,
+    }
+}
```

