# System.ServiceModel.Security

``` diff
+namespace System.ServiceModel.Security {
+    public class Basic128SecurityAlgorithmSuite : SecurityAlgorithmSuite {
+        public Basic128SecurityAlgorithmSuite();
+        public override string DefaultAsymmetricKeyWrapAlgorithm { get; }
+        public override string DefaultAsymmetricSignatureAlgorithm { get; }
+        public override string DefaultCanonicalizationAlgorithm { get; }
+        public override string DefaultDigestAlgorithm { get; }
+        public override string DefaultEncryptionAlgorithm { get; }
+        public override int DefaultEncryptionKeyDerivationLength { get; }
+        public override int DefaultSignatureKeyDerivationLength { get; }
+        public override int DefaultSymmetricKeyLength { get; }
+        public override string DefaultSymmetricKeyWrapAlgorithm { get; }
+        public override string DefaultSymmetricSignatureAlgorithm { get; }
+        public override bool IsAsymmetricKeyLengthSupported(int length);
+        public override bool IsSymmetricKeyLengthSupported(int length);
+        public override string ToString();
+    }
+    public class Basic192SecurityAlgorithmSuite : SecurityAlgorithmSuite {
+        public Basic192SecurityAlgorithmSuite();
+        public override string DefaultAsymmetricKeyWrapAlgorithm { get; }
+        public override string DefaultAsymmetricSignatureAlgorithm { get; }
+        public override string DefaultCanonicalizationAlgorithm { get; }
+        public override string DefaultDigestAlgorithm { get; }
+        public override string DefaultEncryptionAlgorithm { get; }
+        public override int DefaultEncryptionKeyDerivationLength { get; }
+        public override int DefaultSignatureKeyDerivationLength { get; }
+        public override int DefaultSymmetricKeyLength { get; }
+        public override string DefaultSymmetricKeyWrapAlgorithm { get; }
+        public override string DefaultSymmetricSignatureAlgorithm { get; }
+        public override bool IsAsymmetricKeyLengthSupported(int length);
+        public override bool IsSymmetricKeyLengthSupported(int length);
+        public override string ToString();
+    }
+    public class Basic256SecurityAlgorithmSuite : SecurityAlgorithmSuite {
+        public Basic256SecurityAlgorithmSuite();
+        public override string DefaultAsymmetricKeyWrapAlgorithm { get; }
+        public override string DefaultAsymmetricSignatureAlgorithm { get; }
+        public override string DefaultCanonicalizationAlgorithm { get; }
+        public override string DefaultDigestAlgorithm { get; }
+        public override string DefaultEncryptionAlgorithm { get; }
+        public override int DefaultEncryptionKeyDerivationLength { get; }
+        public override int DefaultSignatureKeyDerivationLength { get; }
+        public override int DefaultSymmetricKeyLength { get; }
+        public override string DefaultSymmetricKeyWrapAlgorithm { get; }
+        public override string DefaultSymmetricSignatureAlgorithm { get; }
+        public override bool IsAsymmetricKeyLengthSupported(int length);
+        public override bool IsSymmetricKeyLengthSupported(int length);
+        public override string ToString();
+    }
+    public abstract class BasicSecurityProfileVersion {
+        public static BasicSecurityProfileVersion BasicSecurityProfile10 { get; }
+    }
+    public class ChannelProtectionRequirements {
+        public ChannelProtectionRequirements();
+        public ChannelProtectionRequirements(ChannelProtectionRequirements other);
+        public ScopedMessagePartSpecification IncomingEncryptionParts { get; }
+        public ScopedMessagePartSpecification IncomingSignatureParts { get; }
+        public bool IsReadOnly { get; }
+        public ScopedMessagePartSpecification OutgoingEncryptionParts { get; }
+        public ScopedMessagePartSpecification OutgoingSignatureParts { get; }
+        public void Add(ChannelProtectionRequirements protectionRequirements);
+        public void Add(ChannelProtectionRequirements protectionRequirements, bool channelScopeOnly);
+        public ChannelProtectionRequirements CreateInverse();
+        public void MakeReadOnly();
+    }
+    public sealed class HttpDigestClientCredential {
+        public NetworkCredential ClientCredential { get; set; }
+    }
+    public abstract class IdentityVerifier {
+        protected IdentityVerifier();
+        public abstract bool CheckAccess(EndpointIdentity identity, AuthorizationContext authContext);
+        public static IdentityVerifier CreateDefault();
+        public abstract bool TryGetIdentity(EndpointAddress reference, out EndpointIdentity identity);
+    }
+    public interface ISecuritySession : ISession {
+        EndpointIdentity RemoteIdentity { get; }
+    }
+    public class MessagePartSpecification {
+        public MessagePartSpecification();
+        public MessagePartSpecification(bool isBodyIncluded);
+        public MessagePartSpecification(bool isBodyIncluded, params XmlQualifiedName[] headerTypes);
+        public MessagePartSpecification(params XmlQualifiedName[] headerTypes);
+        public ICollection<XmlQualifiedName> HeaderTypes { get; }
+        public bool IsBodyIncluded { get; set; }
+        public bool IsReadOnly { get; }
+        public static MessagePartSpecification NoParts { get; }
+        public void Clear();
+        public void MakeReadOnly();
+        public void Union(MessagePartSpecification specification);
+    }
+    public enum MessageProtectionOrder {
+        EncryptBeforeSign = 2,
+        SignBeforeEncrypt = 0,
+        SignBeforeEncryptAndEncryptSignature = 1,
+    }
+    public class MessageSecurityException : CommunicationException {
+        public MessageSecurityException();
+        public MessageSecurityException(string message);
+        public MessageSecurityException(string message, Exception innerException);
+    }
+    public sealed class MessageSecurityTokenVersion : SecurityTokenVersion {
+        public bool EmitBspRequiredAttributes { get; }
+        public SecureConversationVersion SecureConversationVersion { get; }
+        public SecurityVersion SecurityVersion { get; }
+        public TrustVersion TrustVersion { get; }
+        public static MessageSecurityTokenVersion WSSecurity10WSTrust13WSSecureConversation13BasicSecurityProfile10 { get; }
+        public static MessageSecurityTokenVersion WSSecurity10WSTrustFebruary2005WSSecureConversationFebruary2005BasicSecurityProfile10 { get; }
+        public static MessageSecurityTokenVersion WSSecurity11WSTrust13WSSecureConversation13 { get; }
+        public static MessageSecurityTokenVersion WSSecurity11WSTrust13WSSecureConversation13BasicSecurityProfile10 { get; }
+        public static MessageSecurityTokenVersion WSSecurity11WSTrustFebruary2005WSSecureConversationFebruary2005 { get; }
+        public static MessageSecurityTokenVersion WSSecurity11WSTrustFebruary2005WSSecureConversationFebruary2005BasicSecurityProfile10 { get; }
+        public override ReadOnlyCollection<string> GetSecuritySpecifications();
+        public static MessageSecurityTokenVersion GetSecurityTokenVersion(SecurityVersion version, bool emitBspAttributes);
+        public override string ToString();
+    }
+    public abstract class NonceCache {
+        protected NonceCache();
+        public int CacheSize { get; set; }
+        public TimeSpan CachingTimeSpan { get; set; }
+        public abstract bool CheckNonce(byte[] nonce);
+        public abstract bool TryAddNonce(byte[] nonce);
+    }
+    public static class ProtectionLevelHelper {
+        public static int GetOrdinal(Nullable<ProtectionLevel> p);
+        public static bool IsDefined(ProtectionLevel value);
+        public static bool IsStronger(ProtectionLevel v1, ProtectionLevel v2);
+        public static bool IsStrongerOrEqual(ProtectionLevel v1, ProtectionLevel v2);
+        public static ProtectionLevel Max(ProtectionLevel v1, ProtectionLevel v2);
+        public static void Validate(ProtectionLevel value);
+    }
+    public class ScopedMessagePartSpecification {
+        public ScopedMessagePartSpecification();
+        public ScopedMessagePartSpecification(ScopedMessagePartSpecification other);
+        public ICollection<string> Actions { get; }
+        public MessagePartSpecification ChannelParts { get; }
+        public bool IsReadOnly { get; }
+        public void AddParts(MessagePartSpecification parts);
+        public void AddParts(MessagePartSpecification parts, string action);
+        public void MakeReadOnly();
+        public bool TryGetParts(string action, bool excludeChannelScope, out MessagePartSpecification parts);
+        public bool TryGetParts(string action, out MessagePartSpecification parts);
+    }
+    public abstract class SecureConversationVersion {
+        public static SecureConversationVersion Default { get; }
+        public XmlDictionaryString Namespace { get; }
+        public XmlDictionaryString Prefix { get; }
+        public static SecureConversationVersion WSSecureConversation13 { get; }
+        public static SecureConversationVersion WSSecureConversationFeb2005 { get; }
+    }
+    public class SecurityAccessDeniedException : CommunicationException {
+        public SecurityAccessDeniedException(string message);
+        public SecurityAccessDeniedException(string message, Exception innerException);
+    }
+    public abstract class SecurityAlgorithmSuite {
+        protected SecurityAlgorithmSuite();
+        public static SecurityAlgorithmSuite Basic128 { get; }
+        public static SecurityAlgorithmSuite Basic128Rsa15 { get; }
+        public static SecurityAlgorithmSuite Basic128Sha256 { get; }
+        public static SecurityAlgorithmSuite Basic128Sha256Rsa15 { get; }
+        public static SecurityAlgorithmSuite Basic192 { get; }
+        public static SecurityAlgorithmSuite Basic192Rsa15 { get; }
+        public static SecurityAlgorithmSuite Basic192Sha256 { get; }
+        public static SecurityAlgorithmSuite Basic192Sha256Rsa15 { get; }
+        public static SecurityAlgorithmSuite Basic256 { get; }
+        public static SecurityAlgorithmSuite Basic256Rsa15 { get; }
+        public static SecurityAlgorithmSuite Basic256Sha256 { get; }
+        public static SecurityAlgorithmSuite Basic256Sha256Rsa15 { get; }
+        public static SecurityAlgorithmSuite Default { get; }
+        public abstract string DefaultAsymmetricKeyWrapAlgorithm { get; }
+        public abstract string DefaultAsymmetricSignatureAlgorithm { get; }
+        public abstract string DefaultCanonicalizationAlgorithm { get; }
+        public abstract string DefaultDigestAlgorithm { get; }
+        public abstract string DefaultEncryptionAlgorithm { get; }
+        public abstract int DefaultEncryptionKeyDerivationLength { get; }
+        public abstract int DefaultSignatureKeyDerivationLength { get; }
+        public abstract int DefaultSymmetricKeyLength { get; }
+        public abstract string DefaultSymmetricKeyWrapAlgorithm { get; }
+        public abstract string DefaultSymmetricSignatureAlgorithm { get; }
+        public static SecurityAlgorithmSuite TripleDes { get; }
+        public static SecurityAlgorithmSuite TripleDesRsa15 { get; }
+        public static SecurityAlgorithmSuite TripleDesSha256 { get; }
+        public static SecurityAlgorithmSuite TripleDesSha256Rsa15 { get; }
+        public abstract bool IsAsymmetricKeyLengthSupported(int length);
+        public virtual bool IsAsymmetricKeyWrapAlgorithmSupported(string algorithm);
+        public virtual bool IsAsymmetricSignatureAlgorithmSupported(string algorithm);
+        public virtual bool IsCanonicalizationAlgorithmSupported(string algorithm);
+        public virtual bool IsDigestAlgorithmSupported(string algorithm);
+        public virtual bool IsEncryptionAlgorithmSupported(string algorithm);
+        public virtual bool IsEncryptionKeyDerivationAlgorithmSupported(string algorithm);
+        public virtual bool IsSignatureKeyDerivationAlgorithmSupported(string algorithm);
+        public abstract bool IsSymmetricKeyLengthSupported(int length);
+        public virtual bool IsSymmetricKeyWrapAlgorithmSupported(string algorithm);
+        public virtual bool IsSymmetricSignatureAlgorithmSupported(string algorithm);
+    }
+    public class SecurityContextKeyIdentifierClause : SecurityKeyIdentifierClause {
+        public SecurityContextKeyIdentifierClause(UniqueId contextId);
+        public SecurityContextKeyIdentifierClause(UniqueId contextId, UniqueId generation);
+        public SecurityContextKeyIdentifierClause(UniqueId contextId, UniqueId generation, byte[] derivationNonce, int derivationLength);
+        public UniqueId ContextId { get; }
+        public UniqueId Generation { get; }
+        public override bool Matches(SecurityKeyIdentifierClause keyIdentifierClause);
+        public bool Matches(UniqueId contextId, UniqueId generation);
+        public override string ToString();
+    }
+    public abstract class SecurityCredentialsManager {
+        protected SecurityCredentialsManager();
+        public abstract SecurityTokenManager CreateSecurityTokenManager();
+    }
+    public enum SecurityKeyEntropyMode {
+        ClientEntropy = 0,
+        CombinedEntropy = 2,
+        ServerEntropy = 1,
+    }
+    public class SecurityMessageProperty : IDisposable, IMessageProperty {
+        public SecurityMessageProperty();
+        public ReadOnlyCollection<IAuthorizationPolicy> ExternalAuthorizationPolicies { get; set; }
+        public bool HasIncomingSupportingTokens { get; }
+        public Collection<SupportingTokenSpecification> IncomingSupportingTokens { get; }
+        public SecurityTokenSpecification InitiatorToken { get; set; }
+        public Collection<SupportingTokenSpecification> OutgoingSupportingTokens { get; }
+        public SecurityTokenSpecification ProtectionToken { get; set; }
+        public SecurityTokenSpecification RecipientToken { get; set; }
+        public string SenderIdPrefix { get; set; }
+        public ServiceSecurityContext ServiceSecurityContext { get; set; }
+        public SecurityTokenSpecification TransportToken { get; set; }
+        public IMessageProperty CreateCopy();
+        public void Dispose();
+        public static SecurityMessageProperty GetOrCreate(Message message);
+    }
+    public class SecurityNegotiationException : CommunicationException {
+        public SecurityNegotiationException();
+        public SecurityNegotiationException(string message);
+        public SecurityNegotiationException(string message, Exception innerException);
+    }
+    public abstract class SecurityPolicyVersion {
+        public string Namespace { get; }
+        public string Prefix { get; }
+        public static SecurityPolicyVersion WSSecurityPolicy11 { get; }
+        public static SecurityPolicyVersion WSSecurityPolicy12 { get; }
+    }
+    public abstract class SecurityStateEncoder {
+        protected SecurityStateEncoder();
+        protected internal abstract byte[] DecodeSecurityState(byte[] data);
+        protected internal abstract byte[] EncodeSecurityState(byte[] data);
+    }
+    public enum SecurityTokenAttachmentMode {
+        Endorsing = 1,
+        Signed = 0,
+        SignedEncrypted = 3,
+        SignedEndorsing = 2,
+    }
+    public class SecurityTokenSpecification {
+        public SecurityTokenSpecification(SecurityToken token, ReadOnlyCollection<IAuthorizationPolicy> tokenPolicies);
+        public SecurityToken SecurityToken { get; }
+        public ReadOnlyCollection<IAuthorizationPolicy> SecurityTokenPolicies { get; }
+    }
+    public abstract class SecurityVersion {
+        public static SecurityVersion WSSecurity10 { get; }
+        public static SecurityVersion WSSecurity11 { get; }
+    }
+    public class SspiSecurityTokenProvider : SecurityTokenProvider {
+        public SspiSecurityTokenProvider(NetworkCredential credential, bool extractGroupsForWindowsAccounts, bool allowUnauthenticatedCallers);
+        public SspiSecurityTokenProvider(NetworkCredential credential, bool allowNtlm, TokenImpersonationLevel impersonationLevel);
+        protected override Task<SecurityToken> GetTokenCoreAsync(CancellationToken cancellationToken);
+    }
+    public class SupportingTokenSpecification : SecurityTokenSpecification {
+        public SupportingTokenSpecification(SecurityToken token, ReadOnlyCollection<IAuthorizationPolicy> tokenPolicies, SecurityTokenAttachmentMode attachmentMode);
+        public SupportingTokenSpecification(SecurityToken token, ReadOnlyCollection<IAuthorizationPolicy> tokenPolicies, SecurityTokenAttachmentMode attachmentMode, SecurityTokenParameters tokenParameters);
+        public SecurityTokenAttachmentMode SecurityTokenAttachmentMode { get; }
+    }
+    public class TripleDesSecurityAlgorithmSuite : SecurityAlgorithmSuite {
+        public TripleDesSecurityAlgorithmSuite();
+        public override string DefaultAsymmetricKeyWrapAlgorithm { get; }
+        public override string DefaultAsymmetricSignatureAlgorithm { get; }
+        public override string DefaultCanonicalizationAlgorithm { get; }
+        public override string DefaultDigestAlgorithm { get; }
+        public override string DefaultEncryptionAlgorithm { get; }
+        public override int DefaultEncryptionKeyDerivationLength { get; }
+        public override int DefaultSignatureKeyDerivationLength { get; }
+        public override int DefaultSymmetricKeyLength { get; }
+        public override string DefaultSymmetricKeyWrapAlgorithm { get; }
+        public override string DefaultSymmetricSignatureAlgorithm { get; }
+        public override bool IsAsymmetricKeyLengthSupported(int length);
+        public override bool IsSymmetricKeyLengthSupported(int length);
+        public override string ToString();
+    }
+    public abstract class TrustVersion {
+        public static TrustVersion Default { get; }
+        public XmlDictionaryString Namespace { get; }
+        public XmlDictionaryString Prefix { get; }
+        public static TrustVersion WSTrust13 { get; }
+        public static TrustVersion WSTrustFeb2005 { get; }
+    }
+    public sealed class UserNamePasswordClientCredential {
+        public string Password { get; set; }
+        public string UserName { get; set; }
+    }
+    public sealed class WindowsClientCredential {
+        public TokenImpersonationLevel AllowedImpersonationLevel { get; set; }
+        public bool AllowNtlm { get; set; }
+        public NetworkCredential ClientCredential { get; set; }
+    }
+    public class WSSecurityTokenSerializer : SecurityTokenSerializer {
+        public WSSecurityTokenSerializer();
+        public WSSecurityTokenSerializer(bool emitBspRequiredAttributes);
+        public WSSecurityTokenSerializer(SecurityVersion securityVersion);
+        public WSSecurityTokenSerializer(SecurityVersion securityVersion, bool emitBspRequiredAttributes);
+        public WSSecurityTokenSerializer(SecurityVersion securityVersion, bool emitBspRequiredAttributes, SamlSerializer samlSerializer);
+        public WSSecurityTokenSerializer(SecurityVersion securityVersion, bool emitBspRequiredAttributes, SamlSerializer samlSerializer, SecurityStateEncoder securityStateEncoder, IEnumerable<Type> knownTypes);
+        public WSSecurityTokenSerializer(SecurityVersion securityVersion, bool emitBspRequiredAttributes, SamlSerializer samlSerializer, SecurityStateEncoder securityStateEncoder, IEnumerable<Type> knownTypes, int maximumKeyDerivationOffset, int maximumKeyDerivationLabelLength, int maximumKeyDerivationNonceLength);
+        public WSSecurityTokenSerializer(SecurityVersion securityVersion, TrustVersion trustVersion, SecureConversationVersion secureConversationVersion, bool emitBspRequiredAttributes, SamlSerializer samlSerializer, SecurityStateEncoder securityStateEncoder, IEnumerable<Type> knownTypes);
+        public WSSecurityTokenSerializer(SecurityVersion securityVersion, TrustVersion trustVersion, SecureConversationVersion secureConversationVersion, bool emitBspRequiredAttributes, SamlSerializer samlSerializer, SecurityStateEncoder securityStateEncoder, IEnumerable<Type> knownTypes, int maximumKeyDerivationOffset, int maximumKeyDerivationLabelLength, int maximumKeyDerivationNonceLength);
+        public static WSSecurityTokenSerializer DefaultInstance { get; }
+        public bool EmitBspRequiredAttributes { get; }
+        public int MaximumKeyDerivationLabelLength { get; }
+        public int MaximumKeyDerivationNonceLength { get; }
+        public int MaximumKeyDerivationOffset { get; }
+        public SecurityVersion SecurityVersion { get; }
+        protected override bool CanReadKeyIdentifierClauseCore(XmlReader reader);
+        protected override bool CanReadKeyIdentifierCore(XmlReader reader);
+        protected override bool CanReadTokenCore(XmlReader reader);
+        protected override bool CanWriteKeyIdentifierClauseCore(SecurityKeyIdentifierClause keyIdentifierClause);
+        protected override bool CanWriteKeyIdentifierCore(SecurityKeyIdentifier keyIdentifier);
+        protected override bool CanWriteTokenCore(SecurityToken token);
+        public virtual SecurityKeyIdentifierClause CreateKeyIdentifierClauseFromTokenXml(XmlElement element, SecurityTokenReferenceStyle tokenReferenceStyle);
+        protected internal virtual string GetTokenTypeUri(Type tokenType);
+        protected override SecurityKeyIdentifierClause ReadKeyIdentifierClauseCore(XmlReader reader);
+        protected override SecurityKeyIdentifier ReadKeyIdentifierCore(XmlReader reader);
+        protected override SecurityToken ReadTokenCore(XmlReader reader, SecurityTokenResolver tokenResolver);
+        public virtual bool TryCreateKeyIdentifierClauseFromTokenXml(XmlElement element, SecurityTokenReferenceStyle tokenReferenceStyle, out SecurityKeyIdentifierClause securityKeyIdentifierClause);
+        protected override void WriteKeyIdentifierClauseCore(XmlWriter writer, SecurityKeyIdentifierClause keyIdentifierClause);
+        protected override void WriteKeyIdentifierCore(XmlWriter writer, SecurityKeyIdentifier keyIdentifier);
+        protected override void WriteTokenCore(XmlWriter writer, SecurityToken token);
+    }
+    public sealed class X509CertificateInitiatorClientCredential {
+        public X509Certificate2 Certificate { get; set; }
+        public void SetCertificate(StoreLocation storeLocation, StoreName storeName, X509FindType findType, object findValue);
+        public void SetCertificate(string subjectName, StoreLocation storeLocation, StoreName storeName);
+    }
+    public sealed class X509CertificateRecipientClientCredential {
+        public X509ServiceCertificateAuthentication Authentication { get; }
+        public X509Certificate2 DefaultCertificate { get; set; }
+        public Dictionary<Uri, X509Certificate2> ScopedCertificates { get; }
+        public X509ServiceCertificateAuthentication SslCertificateAuthentication { get; set; }
+        public void SetDefaultCertificate(StoreLocation storeLocation, StoreName storeName, X509FindType findType, object findValue);
+        public void SetDefaultCertificate(string subjectName, StoreLocation storeLocation, StoreName storeName);
+        public void SetScopedCertificate(StoreLocation storeLocation, StoreName storeName, X509FindType findType, object findValue, Uri targetService);
+        public void SetScopedCertificate(string subjectName, StoreLocation storeLocation, StoreName storeName, Uri targetService);
+    }
+    public enum X509CertificateValidationMode {
+        ChainTrust = 2,
+        Custom = 4,
+        None = 0,
+        PeerOrChainTrust = 3,
+        PeerTrust = 1,
+    }
+    public class X509ClientCertificateAuthentication {
+        public X509ClientCertificateAuthentication();
+    }
+    public sealed class X509ServiceCertificateAuthentication {
+        public X509ServiceCertificateAuthentication();
+        public X509CertificateValidationMode CertificateValidationMode { get; set; }
+        public X509CertificateValidator CustomCertificateValidator { get; set; }
+        public X509RevocationMode RevocationMode { get; set; }
+        public StoreLocation TrustedStoreLocation { get; set; }
+    }
+}
```

