# System.Xml

``` diff
+namespace System.Xml {
+    public enum ConformanceLevel {
+        Auto = 0,
+        Document = 2,
+        Fragment = 1,
+    }
+    public enum DtdProcessing {
+        Ignore = 1,
+        Prohibit = 0,
+    }
+    public interface IStreamProvider {
+        Stream GetStream();
+        void ReleaseStream(Stream stream);
+    }
+    public interface IXmlDictionary {
+        bool TryLookup(int key, out XmlDictionaryString result);
+        bool TryLookup(string value, out XmlDictionaryString result);
+        bool TryLookup(XmlDictionaryString value, out XmlDictionaryString result);
+    }
+    public interface IXmlLineInfo {
+        int LineNumber { get; }
+        int LinePosition { get; }
+        bool HasLineInfo();
+    }
+    public interface IXmlNamespaceResolver {
+        IDictionary<string, string> GetNamespacesInScope(XmlNamespaceScope scope);
+        string LookupNamespace(string prefix);
+        string LookupPrefix(string namespaceName);
+    }
+    public interface IXmlTextReaderInitializer {
+        void SetInput(byte[] buffer, int offset, int count, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+        void SetInput(Stream stream, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+    }
+    public enum NamespaceHandling {
+        Default = 0,
+        OmitDuplicates = 1,
+    }
+    public class NameTable : XmlNameTable {
+        public NameTable();
+        public override string Add(char[] key, int start, int len);
+        public override string Add(string key);
+        public override string Get(char[] key, int start, int len);
+        public override string Get(string value);
+    }
+    public enum NewLineHandling {
+        Entitize = 1,
+        None = 2,
+        Replace = 0,
+    }
+    public delegate void OnXmlDictionaryReaderClose(XmlDictionaryReader reader);
+    public enum ReadState {
+        Closed = 4,
+        EndOfFile = 3,
+        Error = 2,
+        Initial = 0,
+        Interactive = 1,
+    }
+    public class UniqueId {
+        public UniqueId();
+        public UniqueId(byte[] guid);
+        public UniqueId(byte[] guid, int offset);
+        public UniqueId(char[] chars, int offset, int count);
+        public UniqueId(Guid guid);
+        public UniqueId(string value);
+        public int CharArrayLength { get; }
+        public bool IsGuid { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(UniqueId id1, UniqueId id2);
+        public static bool operator !=(UniqueId id1, UniqueId id2);
+        public int ToCharArray(char[] chars, int offset);
+        public override string ToString();
+        public bool TryGetGuid(byte[] buffer, int offset);
+        public bool TryGetGuid(out Guid guid);
+    }
+    public enum WriteState {
+        Attribute = 3,
+        Closed = 5,
+        Content = 4,
+        Element = 2,
+        Error = 6,
+        Prolog = 1,
+        Start = 0,
+    }
+    public class XmlAttribute : XmlNode {
+        protected internal XmlAttribute(string prefix, string localName, string namespaceURI, XmlDocument doc);
+        public override string BaseURI { get; }
+        public override string InnerText { set; }
+        public override string InnerXml { set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override string NamespaceURI { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlDocument OwnerDocument { get; }
+        public virtual XmlElement OwnerElement { get; }
+        public override XmlNode ParentNode { get; }
+        public override string Prefix { get; set; }
+        public virtual bool Specified { get; }
+        public override string Value { get; set; }
+        public override XmlNode AppendChild(XmlNode newChild);
+        public override XmlNode CloneNode(bool deep);
+        public override XmlNode InsertAfter(XmlNode newChild, XmlNode refChild);
+        public override XmlNode InsertBefore(XmlNode newChild, XmlNode refChild);
+        public override XmlNode PrependChild(XmlNode newChild);
+        public override XmlNode RemoveChild(XmlNode oldChild);
+        public override XmlNode ReplaceChild(XmlNode newChild, XmlNode oldChild);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public sealed class XmlAttributeCollection : XmlNamedNodeMap, ICollection, IEnumerable {
+        int System.Collections.ICollection.Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        [System.Runtime.CompilerServices.IndexerName("ItemOf")]
+        public XmlAttribute this[int i] { get; }
+        [System.Runtime.CompilerServices.IndexerName("ItemOf")]
+        public XmlAttribute this[string localName, string namespaceURI] { get; }
+        [System.Runtime.CompilerServices.IndexerName("ItemOf")]
+        public XmlAttribute this[string name] { get; }
+        public XmlAttribute Append(XmlAttribute node);
+        public void CopyTo(XmlAttribute[] array, int index);
+        public XmlAttribute InsertAfter(XmlAttribute newNode, XmlAttribute refNode);
+        public XmlAttribute InsertBefore(XmlAttribute newNode, XmlAttribute refNode);
+        public XmlAttribute Prepend(XmlAttribute node);
+        public XmlAttribute Remove(XmlAttribute node);
+        public void RemoveAll();
+        public XmlAttribute RemoveAt(int i);
+        public override XmlNode SetNamedItem(XmlNode node);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+    }
+    public class XmlBinaryReaderSession : IXmlDictionary {
+        public XmlBinaryReaderSession();
+        public XmlDictionaryString Add(int id, string value);
+        public void Clear();
+        public bool TryLookup(int key, out XmlDictionaryString result);
+        public bool TryLookup(string value, out XmlDictionaryString result);
+        public bool TryLookup(XmlDictionaryString value, out XmlDictionaryString result);
+    }
+    public class XmlBinaryWriterSession {
+        public XmlBinaryWriterSession();
+        public void Reset();
+        public virtual bool TryAdd(XmlDictionaryString value, out int key);
+    }
+    public class XmlCDataSection : XmlCharacterData {
+        protected internal XmlCDataSection(string data, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode PreviousText { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public abstract class XmlCharacterData : XmlLinkedNode {
+        protected internal XmlCharacterData(string data, XmlDocument doc);
+        public virtual string Data { get; set; }
+        public virtual int Length { get; }
+        public override string Value { get; set; }
+        public virtual void AppendData(string strData);
+        public virtual void DeleteData(int offset, int count);
+        public virtual void InsertData(int offset, string strData);
+        public virtual void ReplaceData(int offset, int count, string strData);
+        public virtual string Substring(int offset, int count);
+    }
+    public class XmlComment : XmlCharacterData {
+        protected internal XmlComment(string comment, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public static class XmlConvert {
+        public static string DecodeName(string name);
+        public static string EncodeLocalName(string name);
+        public static string EncodeName(string name);
+        public static string EncodeNmToken(string name);
+        public static bool ToBoolean(string s);
+        public static byte ToByte(string s);
+        public static char ToChar(string s);
+        public static DateTime ToDateTime(string s, XmlDateTimeSerializationMode dateTimeOption);
+        public static DateTimeOffset ToDateTimeOffset(string s);
+        public static DateTimeOffset ToDateTimeOffset(string s, string format);
+        public static DateTimeOffset ToDateTimeOffset(string s, string[] formats);
+        public static Decimal ToDecimal(string s);
+        public static double ToDouble(string s);
+        public static Guid ToGuid(string s);
+        public static short ToInt16(string s);
+        public static int ToInt32(string s);
+        public static long ToInt64(string s);
+        public static sbyte ToSByte(string s);
+        public static float ToSingle(string s);
+        public static string ToString(bool value);
+        public static string ToString(byte value);
+        public static string ToString(char value);
+        public static string ToString(DateTime value, XmlDateTimeSerializationMode dateTimeOption);
+        public static string ToString(DateTimeOffset value);
+        public static string ToString(DateTimeOffset value, string format);
+        public static string ToString(Decimal value);
+        public static string ToString(double value);
+        public static string ToString(Guid value);
+        public static string ToString(short value);
+        public static string ToString(int value);
+        public static string ToString(long value);
+        public static string ToString(sbyte value);
+        public static string ToString(float value);
+        public static string ToString(TimeSpan value);
+        public static string ToString(ushort value);
+        public static string ToString(uint value);
+        public static string ToString(ulong value);
+        public static TimeSpan ToTimeSpan(string s);
+        public static ushort ToUInt16(string s);
+        public static uint ToUInt32(string s);
+        public static ulong ToUInt64(string s);
+        public static string VerifyName(string name);
+        public static string VerifyNCName(string name);
+        public static string VerifyNMTOKEN(string name);
+        public static string VerifyPublicId(string publicId);
+        public static string VerifyWhitespace(string content);
+        public static string VerifyXmlChars(string content);
+    }
+    public enum XmlDateTimeSerializationMode {
+        Local = 0,
+        RoundtripKind = 3,
+        Unspecified = 2,
+        Utc = 1,
+    }
+    public class XmlDeclaration : XmlLinkedNode {
+        protected internal XmlDeclaration(string version, string encoding, string standalone, XmlDocument doc);
+        public string Encoding { get; set; }
+        public override string InnerText { get; set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public string Standalone { get; set; }
+        public override string Value { get; set; }
+        public string Version { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlDictionary : IXmlDictionary {
+        public XmlDictionary();
+        public XmlDictionary(int capacity);
+        public static IXmlDictionary Empty { get; }
+        public virtual XmlDictionaryString Add(string value);
+        public virtual bool TryLookup(int key, out XmlDictionaryString result);
+        public virtual bool TryLookup(string value, out XmlDictionaryString result);
+        public virtual bool TryLookup(XmlDictionaryString value, out XmlDictionaryString result);
+    }
+    public abstract class XmlDictionaryReader : XmlReader {
+        protected XmlDictionaryReader();
+        public virtual bool CanCanonicalize { get; }
+        public virtual XmlDictionaryReaderQuotas Quotas { get; }
+        public virtual void Close();
+        public static XmlDictionaryReader CreateBinaryReader(byte[] buffer, int offset, int count, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateBinaryReader(byte[] buffer, int offset, int count, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas, XmlBinaryReaderSession session);
+        public static XmlDictionaryReader CreateBinaryReader(byte[] buffer, int offset, int count, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateBinaryReader(byte[] buffer, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateBinaryReader(Stream stream, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateBinaryReader(Stream stream, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas, XmlBinaryReaderSession session);
+        public static XmlDictionaryReader CreateBinaryReader(Stream stream, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateDictionaryReader(XmlReader reader);
+        public static XmlDictionaryReader CreateTextReader(byte[] buffer, int offset, int count, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateTextReader(byte[] buffer, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateTextReader(Stream stream, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+        public static XmlDictionaryReader CreateTextReader(Stream stream, XmlDictionaryReaderQuotas quotas);
+        public virtual void EndCanonicalization();
+        public virtual string GetAttribute(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual int IndexOfLocalName(string[] localNames, string namespaceUri);
+        public virtual int IndexOfLocalName(XmlDictionaryString[] localNames, XmlDictionaryString namespaceUri);
+        public virtual bool IsLocalName(string localName);
+        public virtual bool IsLocalName(XmlDictionaryString localName);
+        public virtual bool IsNamespaceUri(string namespaceUri);
+        public virtual bool IsNamespaceUri(XmlDictionaryString namespaceUri);
+        public virtual bool IsStartArray(out Type type);
+        public virtual bool IsStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        protected bool IsTextNode(XmlNodeType nodeType);
+        public virtual void MoveToStartElement();
+        public virtual void MoveToStartElement(string name);
+        public virtual void MoveToStartElement(string localName, string namespaceUri);
+        public virtual void MoveToStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual int ReadArray(string localName, string namespaceUri, bool[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, DateTime[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, Decimal[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, double[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, Guid[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, short[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, int[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, long[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, float[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, TimeSpan[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, bool[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, DateTime[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, Decimal[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, double[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, Guid[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, short[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, int[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, long[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, float[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, TimeSpan[] array, int offset, int count);
+        public virtual bool[] ReadBooleanArray(string localName, string namespaceUri);
+        public virtual bool[] ReadBooleanArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public override object ReadContentAs(Type type, IXmlNamespaceResolver namespaceResolver);
+        public virtual byte[] ReadContentAsBase64();
+        public virtual byte[] ReadContentAsBinHex();
+        protected byte[] ReadContentAsBinHex(int maxByteArrayContentLength);
+        public virtual int ReadContentAsChars(char[] chars, int offset, int count);
+        public override Decimal ReadContentAsDecimal();
+        public override float ReadContentAsFloat();
+        public virtual Guid ReadContentAsGuid();
+        public virtual void ReadContentAsQualifiedName(out string localName, out string namespaceUri);
+        public override string ReadContentAsString();
+        protected string ReadContentAsString(int maxStringContentLength);
+        public virtual string ReadContentAsString(string[] strings, out int index);
+        public virtual string ReadContentAsString(XmlDictionaryString[] strings, out int index);
+        public virtual TimeSpan ReadContentAsTimeSpan();
+        public virtual UniqueId ReadContentAsUniqueId();
+        public virtual DateTime[] ReadDateTimeArray(string localName, string namespaceUri);
+        public virtual DateTime[] ReadDateTimeArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual Decimal[] ReadDecimalArray(string localName, string namespaceUri);
+        public virtual Decimal[] ReadDecimalArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual double[] ReadDoubleArray(string localName, string namespaceUri);
+        public virtual double[] ReadDoubleArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual byte[] ReadElementContentAsBase64();
+        public virtual byte[] ReadElementContentAsBinHex();
+        public override bool ReadElementContentAsBoolean();
+        public virtual DateTime ReadElementContentAsDateTime();
+        public override Decimal ReadElementContentAsDecimal();
+        public override double ReadElementContentAsDouble();
+        public override float ReadElementContentAsFloat();
+        public virtual Guid ReadElementContentAsGuid();
+        public override int ReadElementContentAsInt();
+        public override long ReadElementContentAsLong();
+        public override string ReadElementContentAsString();
+        public virtual TimeSpan ReadElementContentAsTimeSpan();
+        public virtual UniqueId ReadElementContentAsUniqueId();
+        public virtual void ReadFullStartElement();
+        public virtual void ReadFullStartElement(string name);
+        public virtual void ReadFullStartElement(string localName, string namespaceUri);
+        public virtual void ReadFullStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual Guid[] ReadGuidArray(string localName, string namespaceUri);
+        public virtual Guid[] ReadGuidArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual short[] ReadInt16Array(string localName, string namespaceUri);
+        public virtual short[] ReadInt16Array(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual int[] ReadInt32Array(string localName, string namespaceUri);
+        public virtual int[] ReadInt32Array(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual long[] ReadInt64Array(string localName, string namespaceUri);
+        public virtual long[] ReadInt64Array(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual float[] ReadSingleArray(string localName, string namespaceUri);
+        public virtual float[] ReadSingleArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual void ReadStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual TimeSpan[] ReadTimeSpanArray(string localName, string namespaceUri);
+        public virtual TimeSpan[] ReadTimeSpanArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual int ReadValueAsBase64(byte[] buffer, int offset, int count);
+        public virtual void StartCanonicalization(Stream stream, bool includeComments, string[] inclusivePrefixes);
+        public virtual bool TryGetArrayLength(out int count);
+        public virtual bool TryGetBase64ContentLength(out int length);
+        public virtual bool TryGetLocalNameAsDictionaryString(out XmlDictionaryString localName);
+        public virtual bool TryGetNamespaceUriAsDictionaryString(out XmlDictionaryString namespaceUri);
+        public virtual bool TryGetValueAsDictionaryString(out XmlDictionaryString value);
+    }
+    public sealed class XmlDictionaryReaderQuotas {
+        public XmlDictionaryReaderQuotas();
+        public static XmlDictionaryReaderQuotas Max { get; }
+        public int MaxArrayLength { get; set; }
+        public int MaxBytesPerRead { get; set; }
+        public int MaxDepth { get; set; }
+        public int MaxNameTableCharCount { get; set; }
+        public int MaxStringContentLength { get; set; }
+        public XmlDictionaryReaderQuotaTypes ModifiedQuotas { get; }
+        public void CopyTo(XmlDictionaryReaderQuotas quotas);
+    }
+    public enum XmlDictionaryReaderQuotaTypes {
+        MaxArrayLength = 4,
+        MaxBytesPerRead = 8,
+        MaxDepth = 1,
+        MaxNameTableCharCount = 16,
+        MaxStringContentLength = 2,
+    }
+    public class XmlDictionaryString {
+        public XmlDictionaryString(IXmlDictionary dictionary, string value, int key);
+        public IXmlDictionary Dictionary { get; }
+        public static XmlDictionaryString Empty { get; }
+        public int Key { get; }
+        public string Value { get; }
+        public override string ToString();
+    }
+    public abstract class XmlDictionaryWriter : XmlWriter {
+        protected XmlDictionaryWriter();
+        public virtual bool CanCanonicalize { get; }
+        public virtual void Close();
+        public static XmlDictionaryWriter CreateBinaryWriter(Stream stream);
+        public static XmlDictionaryWriter CreateBinaryWriter(Stream stream, IXmlDictionary dictionary);
+        public static XmlDictionaryWriter CreateBinaryWriter(Stream stream, IXmlDictionary dictionary, XmlBinaryWriterSession session);
+        public static XmlDictionaryWriter CreateBinaryWriter(Stream stream, IXmlDictionary dictionary, XmlBinaryWriterSession session, bool ownsStream);
+        public static XmlDictionaryWriter CreateDictionaryWriter(XmlWriter writer);
+        public static XmlDictionaryWriter CreateTextWriter(Stream stream);
+        public static XmlDictionaryWriter CreateTextWriter(Stream stream, Encoding encoding);
+        public static XmlDictionaryWriter CreateTextWriter(Stream stream, Encoding encoding, bool ownsStream);
+        protected override void Dispose(bool disposing);
+        public virtual void EndCanonicalization();
+        public virtual void StartCanonicalization(Stream stream, bool includeComments, string[] inclusivePrefixes);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, bool[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, DateTime[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, Decimal[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, double[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, Guid[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, short[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, int[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, long[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, float[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, TimeSpan[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, bool[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, DateTime[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, Decimal[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, double[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, Guid[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, short[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, int[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, long[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, float[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, TimeSpan[] array, int offset, int count);
+        public void WriteAttributeString(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, string value);
+        public void WriteAttributeString(XmlDictionaryString localName, XmlDictionaryString namespaceUri, string value);
+        public void WriteElementString(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, string value);
+        public void WriteElementString(XmlDictionaryString localName, XmlDictionaryString namespaceUri, string value);
+        public virtual void WriteNode(XmlDictionaryReader reader, bool defattr);
+        public override void WriteNode(XmlReader reader, bool defattr);
+        public virtual void WriteQualifiedName(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual void WriteStartAttribute(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public void WriteStartAttribute(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual void WriteStartElement(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public void WriteStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual void WriteString(XmlDictionaryString value);
+        protected virtual void WriteTextNode(XmlDictionaryReader reader, bool isAttribute);
+        public virtual void WriteValue(Guid value);
+        public virtual void WriteValue(TimeSpan value);
+        public virtual void WriteValue(UniqueId value);
+        public virtual void WriteValue(XmlDictionaryString value);
+        public virtual void WriteXmlAttribute(string localName, string value);
+        public virtual void WriteXmlAttribute(XmlDictionaryString localName, XmlDictionaryString value);
+        public virtual void WriteXmlnsAttribute(string prefix, string namespaceUri);
+        public virtual void WriteXmlnsAttribute(string prefix, XmlDictionaryString namespaceUri);
+    }
+    public class XmlDocument : XmlNode {
+        public XmlDocument();
+        protected internal XmlDocument(XmlImplementation imp);
+        public XmlDocument(XmlNameTable nt);
+        public override string BaseURI { get; }
+        public XmlElement DocumentElement { get; }
+        public XmlImplementation Implementation { get; }
+        public override string InnerText { set; }
+        public override string InnerXml { get; set; }
+        public override bool IsReadOnly { get; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public XmlNameTable NameTable { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlDocument OwnerDocument { get; }
+        public override XmlNode ParentNode { get; }
+        public bool PreserveWhitespace { get; set; }
+        public event XmlNodeChangedEventHandler NodeChanged;
+        public event XmlNodeChangedEventHandler NodeChanging;
+        public event XmlNodeChangedEventHandler NodeInserted;
+        public event XmlNodeChangedEventHandler NodeInserting;
+        public event XmlNodeChangedEventHandler NodeRemoved;
+        public event XmlNodeChangedEventHandler NodeRemoving;
+        public override XmlNode CloneNode(bool deep);
+        public XmlAttribute CreateAttribute(string name);
+        public XmlAttribute CreateAttribute(string qualifiedName, string namespaceURI);
+        public virtual XmlAttribute CreateAttribute(string prefix, string localName, string namespaceURI);
+        public virtual XmlCDataSection CreateCDataSection(string data);
+        public virtual XmlComment CreateComment(string data);
+        public virtual XmlDocumentFragment CreateDocumentFragment();
+        public XmlElement CreateElement(string name);
+        public XmlElement CreateElement(string qualifiedName, string namespaceURI);
+        public virtual XmlElement CreateElement(string prefix, string localName, string namespaceURI);
+        public virtual XmlNode CreateNode(string nodeTypeString, string name, string namespaceURI);
+        public virtual XmlNode CreateNode(XmlNodeType type, string name, string namespaceURI);
+        public virtual XmlNode CreateNode(XmlNodeType type, string prefix, string name, string namespaceURI);
+        public virtual XmlProcessingInstruction CreateProcessingInstruction(string target, string data);
+        public virtual XmlSignificantWhitespace CreateSignificantWhitespace(string text);
+        public virtual XmlText CreateTextNode(string text);
+        public virtual XmlWhitespace CreateWhitespace(string text);
+        public virtual XmlDeclaration CreateXmlDeclaration(string version, string encoding, string standalone);
+        public virtual XmlNodeList GetElementsByTagName(string name);
+        public virtual XmlNodeList GetElementsByTagName(string localName, string namespaceURI);
+        public virtual XmlNode ImportNode(XmlNode node, bool deep);
+        public virtual void Load(Stream inStream);
+        public virtual void Load(TextReader txtReader);
+        public virtual void Load(XmlReader reader);
+        public virtual void LoadXml(string xml);
+        public virtual XmlNode ReadNode(XmlReader reader);
+        public virtual void Save(Stream outStream);
+        public virtual void Save(TextWriter writer);
+        public virtual void Save(XmlWriter w);
+        public override void WriteContentTo(XmlWriter xw);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlDocumentFragment : XmlNode {
+        protected internal XmlDocumentFragment(XmlDocument ownerDocument);
+        public override string InnerXml { get; set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlDocument OwnerDocument { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public static class XmlDocumentXPathExtensions {
+        public static XPathNavigator CreateNavigator(this XmlDocument document);
+        public static XPathNavigator CreateNavigator(this XmlDocument document, XmlNode node);
+        public static XPathNavigator CreateNavigator(this XmlNode node);
+        public static XmlNodeList SelectNodes(this XmlNode node, string xpath);
+        public static XmlNodeList SelectNodes(this XmlNode node, string xpath, XmlNamespaceManager nsmgr);
+        public static XmlNode SelectSingleNode(this XmlNode node, string xpath);
+        public static XmlNode SelectSingleNode(this XmlNode node, string xpath, XmlNamespaceManager nsmgr);
+        public static IXPathNavigable ToXPathNavigable(this XmlNode node);
+    }
+    public class XmlElement : XmlLinkedNode {
+        protected internal XmlElement(string prefix, string localName, string namespaceURI, XmlDocument doc);
+        public override XmlAttributeCollection Attributes { get; }
+        public virtual bool HasAttributes { get; }
+        public override string InnerText { get; set; }
+        public override string InnerXml { get; set; }
+        public bool IsEmpty { get; set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override string NamespaceURI { get; }
+        public override XmlNode NextSibling { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlDocument OwnerDocument { get; }
+        public override XmlNode ParentNode { get; }
+        public override string Prefix { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public virtual string GetAttribute(string name);
+        public virtual string GetAttribute(string localName, string namespaceURI);
+        public virtual XmlAttribute GetAttributeNode(string name);
+        public virtual XmlAttribute GetAttributeNode(string localName, string namespaceURI);
+        public virtual XmlNodeList GetElementsByTagName(string name);
+        public virtual XmlNodeList GetElementsByTagName(string localName, string namespaceURI);
+        public virtual bool HasAttribute(string name);
+        public virtual bool HasAttribute(string localName, string namespaceURI);
+        public override void RemoveAll();
+        public virtual void RemoveAllAttributes();
+        public virtual void RemoveAttribute(string name);
+        public virtual void RemoveAttribute(string localName, string namespaceURI);
+        public virtual XmlNode RemoveAttributeAt(int i);
+        public virtual XmlAttribute RemoveAttributeNode(string localName, string namespaceURI);
+        public virtual XmlAttribute RemoveAttributeNode(XmlAttribute oldAttr);
+        public virtual void SetAttribute(string name, string value);
+        public virtual string SetAttribute(string localName, string namespaceURI, string value);
+        public virtual XmlAttribute SetAttributeNode(string localName, string namespaceURI);
+        public virtual XmlAttribute SetAttributeNode(XmlAttribute newAttr);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlException : Exception {
+        public XmlException();
+        public XmlException(string message);
+        public XmlException(string message, Exception innerException);
+        public XmlException(string message, Exception innerException, int lineNumber, int linePosition);
+        public int LineNumber { get; }
+        public int LinePosition { get; }
+        public override string Message { get; }
+    }
+    public class XmlImplementation {
+        public XmlImplementation();
+        public XmlImplementation(XmlNameTable nt);
+        public virtual XmlDocument CreateDocument();
+        public bool HasFeature(string strFeature, string strVersion);
+    }
+    public abstract class XmlLinkedNode : XmlNode {
+        public override XmlNode NextSibling { get; }
+        public override XmlNode PreviousSibling { get; }
+    }
+    public class XmlNamedNodeMap : IEnumerable {
+        public virtual int Count { get; }
+        public virtual IEnumerator GetEnumerator();
+        public virtual XmlNode GetNamedItem(string name);
+        public virtual XmlNode GetNamedItem(string localName, string namespaceURI);
+        public virtual XmlNode Item(int index);
+        public virtual XmlNode RemoveNamedItem(string name);
+        public virtual XmlNode RemoveNamedItem(string localName, string namespaceURI);
+        public virtual XmlNode SetNamedItem(XmlNode node);
+    }
+    public class XmlNamespaceManager : IEnumerable, IXmlNamespaceResolver {
+        public XmlNamespaceManager(XmlNameTable nameTable);
+        public virtual string DefaultNamespace { get; }
+        public virtual XmlNameTable NameTable { get; }
+        public virtual void AddNamespace(string prefix, string uri);
+        public virtual IEnumerator GetEnumerator();
+        public virtual IDictionary<string, string> GetNamespacesInScope(XmlNamespaceScope scope);
+        public virtual bool HasNamespace(string prefix);
+        public virtual string LookupNamespace(string prefix);
+        public virtual string LookupPrefix(string uri);
+        public virtual bool PopScope();
+        public virtual void PushScope();
+        public virtual void RemoveNamespace(string prefix, string uri);
+    }
+    public enum XmlNamespaceScope {
+        All = 0,
+        ExcludeXml = 1,
+        Local = 2,
+    }
+    public abstract class XmlNameTable {
+        protected XmlNameTable();
+        public abstract string Add(char[] array, int offset, int length);
+        public abstract string Add(string array);
+        public abstract string Get(char[] array, int offset, int length);
+        public abstract string Get(string array);
+    }
+    public abstract class XmlNode : IEnumerable {
+        public virtual XmlAttributeCollection Attributes { get; }
+        public virtual string BaseURI { get; }
+        public virtual XmlNodeList ChildNodes { get; }
+        public virtual XmlNode FirstChild { get; }
+        public virtual bool HasChildNodes { get; }
+        public virtual string InnerText { get; set; }
+        public virtual string InnerXml { get; set; }
+        public virtual bool IsReadOnly { get; }
+        public virtual XmlNode LastChild { get; }
+        public abstract string LocalName { get; }
+        public abstract string Name { get; }
+        public virtual string NamespaceURI { get; }
+        public virtual XmlNode NextSibling { get; }
+        public abstract XmlNodeType NodeType { get; }
+        public virtual string OuterXml { get; }
+        public virtual XmlDocument OwnerDocument { get; }
+        public virtual XmlNode ParentNode { get; }
+        public virtual string Prefix { get; set; }
+        public virtual XmlNode PreviousSibling { get; }
+        public virtual XmlNode PreviousText { get; }
+        public virtual XmlElement this[string localname, string ns] { get; }
+        public virtual XmlElement this[string name] { get; }
+        public virtual string Value { get; set; }
+        public virtual XmlNode AppendChild(XmlNode newChild);
+        public abstract XmlNode CloneNode(bool deep);
+        public IEnumerator GetEnumerator();
+        public virtual string GetNamespaceOfPrefix(string prefix);
+        public virtual string GetPrefixOfNamespace(string namespaceURI);
+        public virtual XmlNode InsertAfter(XmlNode newChild, XmlNode refChild);
+        public virtual XmlNode InsertBefore(XmlNode newChild, XmlNode refChild);
+        public virtual void Normalize();
+        public virtual XmlNode PrependChild(XmlNode newChild);
+        public virtual void RemoveAll();
+        public virtual XmlNode RemoveChild(XmlNode oldChild);
+        public virtual XmlNode ReplaceChild(XmlNode newChild, XmlNode oldChild);
+        public virtual bool Supports(string feature, string version);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public abstract void WriteContentTo(XmlWriter w);
+        public abstract void WriteTo(XmlWriter w);
+    }
+    public enum XmlNodeChangedAction {
+        Change = 2,
+        Insert = 0,
+        Remove = 1,
+    }
+    public class XmlNodeChangedEventArgs : EventArgs {
+        public XmlNodeChangedEventArgs(XmlNode node, XmlNode oldParent, XmlNode newParent, string oldValue, string newValue, XmlNodeChangedAction action);
+        public XmlNodeChangedAction Action { get; }
+        public XmlNode NewParent { get; }
+        public string NewValue { get; }
+        public XmlNode Node { get; }
+        public XmlNode OldParent { get; }
+        public string OldValue { get; }
+    }
+    public delegate void XmlNodeChangedEventHandler(object sender, XmlNodeChangedEventArgs e);
+    public abstract class XmlNodeList : IDisposable, IEnumerable {
+        protected XmlNodeList();
+        public abstract int Count { get; }
+        [System.Runtime.CompilerServices.IndexerName("ItemOf")]
+        public virtual XmlNode this[int i] { get; }
+        public abstract IEnumerator GetEnumerator();
+        public abstract XmlNode Item(int index);
+        protected virtual void PrivateDisposeNodeList();
+        void System.IDisposable.Dispose();
+    }
+    public enum XmlNodeOrder {
+        After = 1,
+        Before = 0,
+        Same = 2,
+        Unknown = 3,
+    }
+    public enum XmlNodeType {
+        Attribute = 2,
+        CDATA = 4,
+        Comment = 8,
+        Document = 9,
+        DocumentFragment = 11,
+        DocumentType = 10,
+        Element = 1,
+        EndElement = 15,
+        EndEntity = 16,
+        Entity = 6,
+        EntityReference = 5,
+        None = 0,
+        Notation = 12,
+        ProcessingInstruction = 7,
+        SignificantWhitespace = 14,
+        Text = 3,
+        Whitespace = 13,
+        XmlDeclaration = 17,
+    }
+    public class XmlParserContext {
+        public XmlParserContext(XmlNameTable nt, XmlNamespaceManager nsMgr, string docTypeName, string pubId, string sysId, string internalSubset, string baseURI, string xmlLang, XmlSpace xmlSpace);
+        public XmlParserContext(XmlNameTable nt, XmlNamespaceManager nsMgr, string docTypeName, string pubId, string sysId, string internalSubset, string baseURI, string xmlLang, XmlSpace xmlSpace, Encoding enc);
+        public XmlParserContext(XmlNameTable nt, XmlNamespaceManager nsMgr, string xmlLang, XmlSpace xmlSpace);
+        public XmlParserContext(XmlNameTable nt, XmlNamespaceManager nsMgr, string xmlLang, XmlSpace xmlSpace, Encoding enc);
+        public string BaseURI { get; set; }
+        public string DocTypeName { get; set; }
+        public Encoding Encoding { get; set; }
+        public string InternalSubset { get; set; }
+        public XmlNamespaceManager NamespaceManager { get; set; }
+        public XmlNameTable NameTable { get; set; }
+        public string PublicId { get; set; }
+        public string SystemId { get; set; }
+        public string XmlLang { get; set; }
+        public XmlSpace XmlSpace { get; set; }
+    }
+    public class XmlProcessingInstruction : XmlLinkedNode {
+        protected internal XmlProcessingInstruction(string target, string data, XmlDocument doc);
+        public string Data { get; set; }
+        public override string InnerText { get; set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public string Target { get; }
+        public override string Value { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlQualifiedName {
+        public static readonly XmlQualifiedName Empty;
+        public XmlQualifiedName();
+        public XmlQualifiedName(string name);
+        public XmlQualifiedName(string name, string ns);
+        public bool IsEmpty { get; }
+        public string Name { get; }
+        public string Namespace { get; }
+        public override bool Equals(object other);
+        public override int GetHashCode();
+        public static bool operator ==(XmlQualifiedName a, XmlQualifiedName b);
+        public static bool operator !=(XmlQualifiedName a, XmlQualifiedName b);
+        public override string ToString();
+        public static string ToString(string name, string ns);
+    }
+    public abstract class XmlReader : IDisposable {
+        protected XmlReader();
+        public abstract int AttributeCount { get; }
+        public abstract string BaseURI { get; }
+        public virtual bool CanReadBinaryContent { get; }
+        public virtual bool CanReadValueChunk { get; }
+        public virtual bool CanResolveEntity { get; }
+        public abstract int Depth { get; }
+        public abstract bool EOF { get; }
+        public virtual bool HasAttributes { get; }
+        public virtual bool HasValue { get; }
+        public virtual bool IsDefault { get; }
+        public abstract bool IsEmptyElement { get; }
+        public abstract string LocalName { get; }
+        public virtual string Name { get; }
+        public abstract string NamespaceURI { get; }
+        public abstract XmlNameTable NameTable { get; }
+        public abstract XmlNodeType NodeType { get; }
+        public abstract string Prefix { get; }
+        public abstract ReadState ReadState { get; }
+        public virtual XmlReaderSettings Settings { get; }
+        public virtual string this[int i] { get; }
+        public virtual string this[string name, string namespaceURI] { get; }
+        public virtual string this[string name] { get; }
+        public abstract string Value { get; }
+        public virtual Type ValueType { get; }
+        public virtual string XmlLang { get; }
+        public virtual XmlSpace XmlSpace { get; }
+        public static XmlReader Create(Stream input);
+        public static XmlReader Create(Stream input, XmlReaderSettings settings);
+        public static XmlReader Create(Stream input, XmlReaderSettings settings, XmlParserContext inputContext);
+        public static XmlReader Create(TextReader input);
+        public static XmlReader Create(TextReader input, XmlReaderSettings settings);
+        public static XmlReader Create(TextReader input, XmlReaderSettings settings, XmlParserContext inputContext);
+        public static XmlReader Create(string inputUri);
+        public static XmlReader Create(string inputUri, XmlReaderSettings settings);
+        public static XmlReader Create(XmlReader reader, XmlReaderSettings settings);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract string GetAttribute(int i);
+        public abstract string GetAttribute(string name);
+        public abstract string GetAttribute(string name, string namespaceURI);
+        public virtual Task<string> GetValueAsync();
+        public static bool IsName(string str);
+        public static bool IsNameToken(string str);
+        public virtual bool IsStartElement();
+        public virtual bool IsStartElement(string name);
+        public virtual bool IsStartElement(string localname, string ns);
+        public abstract string LookupNamespace(string prefix);
+        public virtual void MoveToAttribute(int i);
+        public abstract bool MoveToAttribute(string name);
+        public abstract bool MoveToAttribute(string name, string ns);
+        public virtual XmlNodeType MoveToContent();
+        public virtual Task<XmlNodeType> MoveToContentAsync();
+        public abstract bool MoveToElement();
+        public abstract bool MoveToFirstAttribute();
+        public abstract bool MoveToNextAttribute();
+        public abstract bool Read();
+        public virtual Task<bool> ReadAsync();
+        public abstract bool ReadAttributeValue();
+        public virtual object ReadContentAs(Type returnType, IXmlNamespaceResolver namespaceResolver);
+        public virtual Task<object> ReadContentAsAsync(Type returnType, IXmlNamespaceResolver namespaceResolver);
+        public virtual int ReadContentAsBase64(byte[] buffer, int index, int count);
+        public virtual Task<int> ReadContentAsBase64Async(byte[] buffer, int index, int count);
+        public virtual int ReadContentAsBinHex(byte[] buffer, int index, int count);
+        public virtual Task<int> ReadContentAsBinHexAsync(byte[] buffer, int index, int count);
+        public virtual bool ReadContentAsBoolean();
+        public virtual DateTimeOffset ReadContentAsDateTimeOffset();
+        public virtual Decimal ReadContentAsDecimal();
+        public virtual double ReadContentAsDouble();
+        public virtual float ReadContentAsFloat();
+        public virtual int ReadContentAsInt();
+        public virtual long ReadContentAsLong();
+        public virtual object ReadContentAsObject();
+        public virtual Task<object> ReadContentAsObjectAsync();
+        public virtual string ReadContentAsString();
+        public virtual Task<string> ReadContentAsStringAsync();
+        public virtual object ReadElementContentAs(Type returnType, IXmlNamespaceResolver namespaceResolver);
+        public virtual object ReadElementContentAs(Type returnType, IXmlNamespaceResolver namespaceResolver, string localName, string namespaceURI);
+        public virtual Task<object> ReadElementContentAsAsync(Type returnType, IXmlNamespaceResolver namespaceResolver);
+        public virtual int ReadElementContentAsBase64(byte[] buffer, int index, int count);
+        public virtual Task<int> ReadElementContentAsBase64Async(byte[] buffer, int index, int count);
+        public virtual int ReadElementContentAsBinHex(byte[] buffer, int index, int count);
+        public virtual Task<int> ReadElementContentAsBinHexAsync(byte[] buffer, int index, int count);
+        public virtual bool ReadElementContentAsBoolean();
+        public virtual bool ReadElementContentAsBoolean(string localName, string namespaceURI);
+        public virtual Decimal ReadElementContentAsDecimal();
+        public virtual Decimal ReadElementContentAsDecimal(string localName, string namespaceURI);
+        public virtual double ReadElementContentAsDouble();
+        public virtual double ReadElementContentAsDouble(string localName, string namespaceURI);
+        public virtual float ReadElementContentAsFloat();
+        public virtual float ReadElementContentAsFloat(string localName, string namespaceURI);
+        public virtual int ReadElementContentAsInt();
+        public virtual int ReadElementContentAsInt(string localName, string namespaceURI);
+        public virtual long ReadElementContentAsLong();
+        public virtual long ReadElementContentAsLong(string localName, string namespaceURI);
+        public virtual object ReadElementContentAsObject();
+        public virtual object ReadElementContentAsObject(string localName, string namespaceURI);
+        public virtual Task<object> ReadElementContentAsObjectAsync();
+        public virtual string ReadElementContentAsString();
+        public virtual string ReadElementContentAsString(string localName, string namespaceURI);
+        public virtual Task<string> ReadElementContentAsStringAsync();
+        public virtual void ReadEndElement();
+        public virtual string ReadInnerXml();
+        public virtual Task<string> ReadInnerXmlAsync();
+        public virtual string ReadOuterXml();
+        public virtual Task<string> ReadOuterXmlAsync();
+        public virtual void ReadStartElement();
+        public virtual void ReadStartElement(string name);
+        public virtual void ReadStartElement(string localname, string ns);
+        public virtual XmlReader ReadSubtree();
+        public virtual bool ReadToDescendant(string name);
+        public virtual bool ReadToDescendant(string localName, string namespaceURI);
+        public virtual bool ReadToFollowing(string name);
+        public virtual bool ReadToFollowing(string localName, string namespaceURI);
+        public virtual bool ReadToNextSibling(string name);
+        public virtual bool ReadToNextSibling(string localName, string namespaceURI);
+        public virtual int ReadValueChunk(char[] buffer, int index, int count);
+        public virtual Task<int> ReadValueChunkAsync(char[] buffer, int index, int count);
+        public abstract void ResolveEntity();
+        public virtual void Skip();
+        public virtual Task SkipAsync();
+    }
+    public sealed class XmlReaderSettings {
+        public XmlReaderSettings();
+        public bool Async { get; set; }
+        public bool CheckCharacters { get; set; }
+        public bool CloseInput { get; set; }
+        public ConformanceLevel ConformanceLevel { get; set; }
+        public DtdProcessing DtdProcessing { get; set; }
+        public bool IgnoreComments { get; set; }
+        public bool IgnoreProcessingInstructions { get; set; }
+        public bool IgnoreWhitespace { get; set; }
+        public int LineNumberOffset { get; set; }
+        public int LinePositionOffset { get; set; }
+        public long MaxCharactersFromEntities { get; set; }
+        public long MaxCharactersInDocument { get; set; }
+        public XmlNameTable NameTable { get; set; }
+        public XmlReaderSettings Clone();
+        public void Reset();
+    }
+    public class XmlSignificantWhitespace : XmlCharacterData {
+        protected internal XmlSignificantWhitespace(string strData, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode PreviousText { get; }
+        public override string Value { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public enum XmlSpace {
+        Default = 1,
+        None = 0,
+        Preserve = 2,
+    }
+    public class XmlText : XmlCharacterData {
+        protected internal XmlText(string strData, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode PreviousText { get; }
+        public override string Value { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public virtual XmlText SplitText(int offset);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlWhitespace : XmlCharacterData {
+        protected internal XmlWhitespace(string strData, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode PreviousText { get; }
+        public override string Value { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public abstract class XmlWriter : IDisposable {
+        protected XmlWriter();
+        public virtual XmlWriterSettings Settings { get; }
+        public abstract WriteState WriteState { get; }
+        public virtual string XmlLang { get; }
+        public virtual XmlSpace XmlSpace { get; }
+        public static XmlWriter Create(Stream output);
+        public static XmlWriter Create(Stream output, XmlWriterSettings settings);
+        public static XmlWriter Create(TextWriter output);
+        public static XmlWriter Create(TextWriter output, XmlWriterSettings settings);
+        public static XmlWriter Create(StringBuilder output);
+        public static XmlWriter Create(StringBuilder output, XmlWriterSettings settings);
+        public static XmlWriter Create(XmlWriter output);
+        public static XmlWriter Create(XmlWriter output, XmlWriterSettings settings);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract void Flush();
+        public virtual Task FlushAsync();
+        public abstract string LookupPrefix(string ns);
+        public virtual void WriteAttributes(XmlReader reader, bool defattr);
+        public virtual Task WriteAttributesAsync(XmlReader reader, bool defattr);
+        public void WriteAttributeString(string localName, string value);
+        public void WriteAttributeString(string localName, string ns, string value);
+        public void WriteAttributeString(string prefix, string localName, string ns, string value);
+        public Task WriteAttributeStringAsync(string prefix, string localName, string ns, string value);
+        public abstract void WriteBase64(byte[] buffer, int index, int count);
+        public virtual Task WriteBase64Async(byte[] buffer, int index, int count);
+        public virtual void WriteBinHex(byte[] buffer, int index, int count);
+        public virtual Task WriteBinHexAsync(byte[] buffer, int index, int count);
+        public abstract void WriteCData(string text);
+        public virtual Task WriteCDataAsync(string text);
+        public abstract void WriteCharEntity(char ch);
+        public virtual Task WriteCharEntityAsync(char ch);
+        public abstract void WriteChars(char[] buffer, int index, int count);
+        public virtual Task WriteCharsAsync(char[] buffer, int index, int count);
+        public abstract void WriteComment(string text);
+        public virtual Task WriteCommentAsync(string text);
+        public abstract void WriteDocType(string name, string pubid, string sysid, string subset);
+        public virtual Task WriteDocTypeAsync(string name, string pubid, string sysid, string subset);
+        public void WriteElementString(string localName, string value);
+        public void WriteElementString(string localName, string ns, string value);
+        public void WriteElementString(string prefix, string localName, string ns, string value);
+        public Task WriteElementStringAsync(string prefix, string localName, string ns, string value);
+        public abstract void WriteEndAttribute();
+        protected internal virtual Task WriteEndAttributeAsync();
+        public abstract void WriteEndDocument();
+        public virtual Task WriteEndDocumentAsync();
+        public abstract void WriteEndElement();
+        public virtual Task WriteEndElementAsync();
+        public abstract void WriteEntityRef(string name);
+        public virtual Task WriteEntityRefAsync(string name);
+        public abstract void WriteFullEndElement();
+        public virtual Task WriteFullEndElementAsync();
+        public virtual void WriteName(string name);
+        public virtual Task WriteNameAsync(string name);
+        public virtual void WriteNmToken(string name);
+        public virtual Task WriteNmTokenAsync(string name);
+        public virtual void WriteNode(XmlReader reader, bool defattr);
+        public virtual Task WriteNodeAsync(XmlReader reader, bool defattr);
+        public abstract void WriteProcessingInstruction(string name, string text);
+        public virtual Task WriteProcessingInstructionAsync(string name, string text);
+        public virtual void WriteQualifiedName(string localName, string ns);
+        public virtual Task WriteQualifiedNameAsync(string localName, string ns);
+        public abstract void WriteRaw(char[] buffer, int index, int count);
+        public abstract void WriteRaw(string data);
+        public virtual Task WriteRawAsync(char[] buffer, int index, int count);
+        public virtual Task WriteRawAsync(string data);
+        public void WriteStartAttribute(string localName);
+        public void WriteStartAttribute(string localName, string ns);
+        public abstract void WriteStartAttribute(string prefix, string localName, string ns);
+        protected internal virtual Task WriteStartAttributeAsync(string prefix, string localName, string ns);
+        public abstract void WriteStartDocument();
+        public abstract void WriteStartDocument(bool standalone);
+        public virtual Task WriteStartDocumentAsync();
+        public virtual Task WriteStartDocumentAsync(bool standalone);
+        public void WriteStartElement(string localName);
+        public void WriteStartElement(string localName, string ns);
+        public abstract void WriteStartElement(string prefix, string localName, string ns);
+        public virtual Task WriteStartElementAsync(string prefix, string localName, string ns);
+        public abstract void WriteString(string text);
+        public virtual Task WriteStringAsync(string text);
+        public abstract void WriteSurrogateCharEntity(char lowChar, char highChar);
+        public virtual Task WriteSurrogateCharEntityAsync(char lowChar, char highChar);
+        public virtual void WriteValue(bool value);
+        public virtual void WriteValue(DateTimeOffset value);
+        public virtual void WriteValue(Decimal value);
+        public virtual void WriteValue(double value);
+        public virtual void WriteValue(int value);
+        public virtual void WriteValue(long value);
+        public virtual void WriteValue(object value);
+        public virtual void WriteValue(float value);
+        public virtual void WriteValue(string value);
+        public abstract void WriteWhitespace(string ws);
+        public virtual Task WriteWhitespaceAsync(string ws);
+    }
+    public sealed class XmlWriterSettings {
+        public XmlWriterSettings();
+        public bool Async { get; set; }
+        public bool CheckCharacters { get; set; }
+        public bool CloseOutput { get; set; }
+        public ConformanceLevel ConformanceLevel { get; set; }
+        public Encoding Encoding { get; set; }
+        public bool Indent { get; set; }
+        public string IndentChars { get; set; }
+        public NamespaceHandling NamespaceHandling { get; set; }
+        public string NewLineChars { get; set; }
+        public NewLineHandling NewLineHandling { get; set; }
+        public bool NewLineOnAttributes { get; set; }
+        public bool OmitXmlDeclaration { get; set; }
+        public bool WriteEndDocumentOnClose { get; set; }
+        public XmlWriterSettings Clone();
+        public void Reset();
+    }
+}
```

