# .NET Core March 2018 Update - March 13, 2018

Microsoft is releasing security advisories for .NET Core and ASP.NET Core. Issues addressed by this update are summarized in the [fixes](#notable-fixes-and-commits) section below. Details can be found in corresponding announcements in the [.NET Core](https://github.com/dotnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) and [ASP.NET Core](https://github.com/aspnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) repos.

.NET Core 1.0.10 and SDK 1.1.8 are available for download and usage in your environment.

* [Getting Started](https://www.microsoft.com/net/core/)
* [Downloads](https://github.com/dotnet/core/blob/master/release-notes/download-archives/1.0.10-download.md)

The .NET Core SDK 1.1.8 includes .NET Core 1.0.10 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 1.1.8, the following command will show that you're running version `1.1.8` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1341](https://github.com/dotnet/core/issues/1341) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 1.0.10 images.

## Azure AppServices

Deployment of this update to Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carfully staged across regions over a period of time. Deployment will begin in the West US 2 and North Central US regions with remaining regions following over a few days.

## Known Issues

### Using Linux package managers to update `dotnet-host.x86_64` breaks .NET Core

**Issue:** Running the package manager `update` command on Linux systems where .NET Core has been previously installed may offer an update for `dotnet-host.x86_64`. If the update is allowed to proceed, .NET Core could be in a broken state as only the dotnet host is updated.

**Resolution:** To install the update, either the Runtime or SDK must be explicitly installed. e.g. `sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.0.10`, if you only need the runtime or `sudo apt-get dotnet-dev-1.1.8`, to install both the SDK and Runtime.

We are working to improve our Linux packages to enable correct package manager update behavior. This work is being tracked in the following issues:

* [dotnet/core-setup/issues/3556](https://github.com/dotnet/core-setup/issues/3556)
* [dotnet/cli/issues/8209](https://github.com/dotnet/cli/issues/8209)

## Package and Binary updates

The following packages and binaries are updated by the March 2018 update:

* System.Private.Corelib
* Microsoft.NETCore.Runtime.CoreCLR
* Microsoft.NETCore.Jit

## Notable Fixes and Commits

### CVE-2018-0875 - .NET Core Denial of Service

Microsoft is aware of a security vulnerability in the public versions of .NET Core where a malicious file or web request could cause a denial of service (DoS) attack.  See the following announcement for details.

[CVE-2018-0875](https://github.com/dotnet/announcements/issues/62)

### Commits

#### CoreFX

#### CoreCLR

