# System.Runtime.CompilerServices

``` diff
 namespace System.Runtime.CompilerServices {
+    public sealed class AsyncMethodBuilderAttribute : Attribute {
+        public AsyncMethodBuilderAttribute(Type builderType);
+        public Type BuilderType { get; }
+    }
+    public struct AsyncValueTaskMethodBuilder<TResult> {
+        public ValueTask<TResult> Task { get; }
+        public void AwaitOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : INotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public void AwaitUnsafeOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : ICriticalNotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public static AsyncValueTaskMethodBuilder<TResult> Create();
+        public void SetException(Exception exception);
+        public void SetResult(TResult result);
+        public void SetStateMachine(IAsyncStateMachine stateMachine);
+        public void Start<TStateMachine>(ref TStateMachine stateMachine) where TStateMachine : IAsyncStateMachine;
+    }
     public sealed class TupleElementNamesAttribute : Attribute {
-        public TupleElementNamesAttribute();

     }
     public static class Unsafe {
+        public static ref T Add<T>(ref T source, int elementOffset);
+        public static bool AreSame<T>(ref T left, ref T right);
+        public static ref TTo As<TFrom, TTo>(ref TFrom source);
+        public static ref T Subtract<T>(ref T source, int elementOffset);
     }
 }
```

