# System.Net.Security

``` diff
 namespace System.Net.Security {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SslApplicationProtocol : IEquatable<SslApplicationProtocol> {
+        public static readonly SslApplicationProtocol Http11;
+        public static readonly SslApplicationProtocol Http2;
+        public SslApplicationProtocol(byte[] protocol);
+        public SslApplicationProtocol(string protocol);
+        public ReadOnlyMemory<byte> Protocol { get; }
+        public bool Equals(SslApplicationProtocol other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(SslApplicationProtocol left, SslApplicationProtocol right);
+        public static bool operator !=(SslApplicationProtocol left, SslApplicationProtocol right);
+        public override string ToString();
+    }
+    public class SslClientAuthenticationOptions {
+        public SslClientAuthenticationOptions();
+        public bool AllowRenegotiation { get; set; }
+        public List<SslApplicationProtocol> ApplicationProtocols { get; set; }
+        public X509RevocationMode CertificateRevocationCheckMode { get; set; }
+        public X509CertificateCollection ClientCertificates { get; set; }
+        public SslProtocols EnabledSslProtocols { get; set; }
+        public EncryptionPolicy EncryptionPolicy { get; set; }
+        public LocalCertificateSelectionCallback LocalCertificateSelectionCallback { get; set; }
+        public RemoteCertificateValidationCallback RemoteCertificateValidationCallback { get; set; }
+        public string TargetHost { get; set; }
+    }
+    public class SslServerAuthenticationOptions {
+        public SslServerAuthenticationOptions();
+        public bool AllowRenegotiation { get; set; }
+        public List<SslApplicationProtocol> ApplicationProtocols { get; set; }
+        public X509RevocationMode CertificateRevocationCheckMode { get; set; }
+        public bool ClientCertificateRequired { get; set; }
+        public SslProtocols EnabledSslProtocols { get; set; }
+        public EncryptionPolicy EncryptionPolicy { get; set; }
+        public RemoteCertificateValidationCallback RemoteCertificateValidationCallback { get; set; }
+        public X509Certificate ServerCertificate { get; set; }
+    }
     public class SslStream : AuthenticatedStream {
+        public SslApplicationProtocol NegotiatedApplicationProtocol { get; }
+        public Task AuthenticateAsClientAsync(SslClientAuthenticationOptions sslClientAuthenticationOptions, CancellationToken cancellationToken);
+        public Task AuthenticateAsServerAsync(SslServerAuthenticationOptions sslClientAuthenticationOptions, CancellationToken cancellationToken);
     }
 }
```

