# API Difference release-2.1-preview2 vs release-2.1-rc1

API listing follows standard diff formatting. Lines preceded by a '+' are
additions and a '-' indicates removal.

* [System](#system)
* [System.Buffers](#systembuffers)
* [System.Runtime.InteropServices](#systemruntimeinteropservices)

## System

``` diff
 namespace System {
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable {
-        public static Decimal Parse(ReadOnlySpan<char> s, NumberStyles style=(NumberStyles)(7), IFormatProvider provider=null);
+        public static Decimal Parse(ReadOnlySpan<char> s, NumberStyles style=(NumberStyles)(111), IFormatProvider provider=null);
     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable {
-        public static Double Parse(ReadOnlySpan<char> s, NumberStyles style=(NumberStyles)(7), IFormatProvider provider=null);
+        public static Double Parse(ReadOnlySpan<char> s, NumberStyles style=(NumberStyles)(231), IFormatProvider provider=null);
     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct Memory<T> {
-        public Memory(MemoryManager<T> manager, int start, int length);

-        public static Memory<T> CreateFromPinnedArray(T[] array, int start, int length);

     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct ReadOnlySpan<T> {
+        public ref T GetPinnableReference();
     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct SequencePosition : IEquatable<SequencePosition> {
-        public static bool operator ==(SequencePosition left, SequencePosition right);

-        public static bool operator !=(SequencePosition left, SequencePosition right);

     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable {
-        public static Single Parse(ReadOnlySpan<char> s, NumberStyles style=(NumberStyles)(7), IFormatProvider provider=null);
+        public static Single Parse(ReadOnlySpan<char> s, NumberStyles style=(NumberStyles)(231), IFormatProvider provider=null);
     }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct Span<T> {
+        public ref T GetPinnableReference();
     }
 }
```

## System.Buffers

``` diff
 namespace System.Buffers {
     public abstract class MemoryManager<T> : IDisposable, IMemoryOwner<T>, IPinnable {
-        public virtual int Length { get; }

+        protected Memory<T> CreateMemory(int length);
+        protected Memory<T> CreateMemory(int start, int length);
     }
 }
```

## System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public static class MemoryMarshal {
+        public static Memory<T> CreateFromPinnedArray<T>(T[] array, int start, int length);
     }
     public static class SequenceMarshal {
-        public static bool TryGetMemoryManager<T>(ReadOnlySequence<T> sequence, out MemoryManager<T> manager, out int start, out int length);

     }
 }
```

