# System.Numerics

``` diff
 namespace System.Numerics {
-    public struct BigInteger : IComparable, IComparable<BigInteger>, IEquatable<BigInteger>, IFormattable {
+    public readonly struct BigInteger : IComparable, IComparable<BigInteger>, IEquatable<BigInteger>, IFormattable {
+        public BigInteger(ReadOnlySpan<byte> value, bool isUnsigned = false, bool isBigEndian = false);
+        public int GetByteCount(bool isUnsigned = false);
+        public static BigInteger Parse(ReadOnlySpan<char> value, NumberStyles style = (NumberStyles)(7), IFormatProvider provider = null);
+        public byte[] ToByteArray(bool isUnsigned = false, bool isBigEndian = false);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> value, NumberStyles style, IFormatProvider provider, out BigInteger result);
+        public static bool TryParse(ReadOnlySpan<char> value, out BigInteger result);
+        public bool TryWriteBytes(Span<byte> destination, out int bytesWritten, bool isUnsigned = false, bool isBigEndian = false);
     }
     public struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct {
+        public Vector(Span<T> values);
     }
 }
```

