# .NET Core 2.2 Known Issues

This document lists known issues for **.NET Core 2.2** which may be encountered during usage.

## ASP.NET Core Module

**Note this has been resolved as of January 2019.**

An update to the ASP.NET Core Module (ANCM) has released for .NET Core 2.2, but is not yet available. This update adds support for hosting applications in the IIS worker process. The updated ANCM is expected to be deployed to Azure App Services later in December 2018. In the meantime, the following workaround, applied to the projects csproj file, can be applied which will cause ASP .NET Core 2.2 projects to use the existing ASP.NET Core Module.

Change this section ...

```
  <PropertyGroup>
    <TargetFramework>netcoreapp2.2</TargetFramework>
    <AspNetCoreHostingModel>InProcess</AspNetCoreHostingModel>
  </PropertyGroup>
```

to the following ...

``` 
  <PropertyGroup>
    <TargetFramework>netcoreapp2.2</TargetFramework>
    <AspNetCoreHostingModel>OutOfProcess</AspNetCoreHostingModel>
    <AspNetCoreModuleName>AspNetCoreModule</AspNetCoreModuleName>
  </PropertyGroup>
```

## .NET Core SDK 2.2.2nn and 2.1.6nn do not work with Visual Studio 2017

.NET Core SDK 2.2.2nn and 2.1.6nn do not work with Visual Studio 2017. For example, 2.2.203 and 2.1.603 cause failures in Visual Studio 2017. To work on projects in Visual Studio 2017, use .NET Core SDK 2.2.1nn and 2.1.5nn, such as 2.2.106 and 2.1.506. You can install any combination of these SDKs side by side.

You can find the SDKs on you machine using the following at a command prompt:

```bash
dotnet --list-sdks
```

### Visual Studio 2017 can't target .NET Core 2.2

If you receive the error message in Visual Studio 2017:

`The current .NET SDK does not support targeting .NET Core 2.2. Either target .NET Core 2.1 or lower, or use a version of the .NET SDK that supports .NET Core 2.2.`

If you downloaded the .NET Core SDK 2.2 between April 2 and April 12, 2019, the main [.NET downloads page](https://dotnet.microsoft.com/download/) included only 2.2.2nn. Starting April 12th, a new button marked "Compatible with Visual Studio 2017" is provided to target 2.2.1nn. If you downloaded 2.2 prior to this date, and you use Visual Studio 2017, install the compatible version.
