# System.Runtime.Intrinsics

``` diff
 namespace System.Runtime.Intrinsics {
     public static class Vector128 {
+        public static Vector128<U> As<T, U>(this Vector128<T> vector) where T : struct where U : struct;
+        public static Vector128<Byte> AsByte<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<Double> AsDouble<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<Int16> AsInt16<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<Int32> AsInt32<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<Int64> AsInt64<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<SByte> AsSByte<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<Single> AsSingle<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<UInt16> AsUInt16<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<UInt32> AsUInt32<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<UInt64> AsUInt64<T>(this Vector128<T> vector) where T : struct;
+        public static T GetElement<T>(this Vector128<T> vector, int index) where T : struct;
+        public static Vector64<T> GetLower<T>(this Vector128<T> vector) where T : struct;
+        public static Vector64<T> GetUpper<T>(this Vector128<T> vector) where T : struct;
+        public static T ToScalar<T>(this Vector128<T> vector) where T : struct;
+        public static Vector256<T> ToVector256<T>(this Vector128<T> vector) where T : struct;
+        public static Vector256<T> ToVector256Unsafe<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<T> WithElement<T>(this Vector128<T> vector, int index, T value) where T : struct;
+        public static Vector128<T> WithLower<T>(this Vector128<T> vector, Vector64<T> value) where T : struct;
+        public static Vector128<T> WithUpper<T>(this Vector128<T> vector, Vector64<T> value) where T : struct;
     }
     public readonly struct Vector128<T> : IEquatable<Vector128<T>>, IFormattable where T : struct {
-        public Vector128<U> As<U>() where U : struct;

-        public Vector128<Byte> AsByte();

-        public Vector128<Double> AsDouble();

-        public Vector128<Int16> AsInt16();

-        public Vector128<Int32> AsInt32();

-        public Vector128<Int64> AsInt64();

-        public Vector128<SByte> AsSByte();

-        public Vector128<Single> AsSingle();

-        public Vector128<UInt16> AsUInt16();

-        public Vector128<UInt32> AsUInt32();

-        public Vector128<UInt64> AsUInt64();

-        public T GetElement(int index);

-        public Vector64<T> GetLower();

-        public Vector64<T> GetUpper();

-        public T ToScalar();

-        public Vector256<T> ToVector256();

-        public Vector256<T> ToVector256Unsafe();

-        public Vector128<T> WithElement(int index, T value);

-        public Vector128<T> WithLower(Vector64<T> value);

-        public Vector128<T> WithUpper(Vector64<T> value);

     }
     public static class Vector256 {
+        public static Vector256<U> As<T, U>(this Vector256<T> vector) where T : struct where U : struct;
+        public static Vector256<Byte> AsByte<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<Double> AsDouble<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<Int16> AsInt16<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<Int32> AsInt32<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<Int64> AsInt64<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<SByte> AsSByte<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<Single> AsSingle<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<UInt16> AsUInt16<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<UInt32> AsUInt32<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<UInt64> AsUInt64<T>(this Vector256<T> vector) where T : struct;
+        public static T GetElement<T>(this Vector256<T> vector, int index) where T : struct;
+        public static Vector128<T> GetLower<T>(this Vector256<T> vector) where T : struct;
+        public static Vector128<T> GetUpper<T>(this Vector256<T> vector) where T : struct;
+        public static T ToScalar<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<T> WithElement<T>(this Vector256<T> vector, int index, T value) where T : struct;
+        public static Vector256<T> WithLower<T>(this Vector256<T> vector, Vector128<T> value) where T : struct;
+        public static Vector256<T> WithUpper<T>(this Vector256<T> vector, Vector128<T> value) where T : struct;
     }
     public readonly struct Vector256<T> : IEquatable<Vector256<T>>, IFormattable where T : struct {
-        public Vector256<U> As<U>() where U : struct;

-        public Vector256<Byte> AsByte();

-        public Vector256<Double> AsDouble();

-        public Vector256<Int16> AsInt16();

-        public Vector256<Int32> AsInt32();

-        public Vector256<Int64> AsInt64();

-        public Vector256<SByte> AsSByte();

-        public Vector256<Single> AsSingle();

-        public Vector256<UInt16> AsUInt16();

-        public Vector256<UInt32> AsUInt32();

-        public Vector256<UInt64> AsUInt64();

-        public T GetElement(int index);

-        public Vector128<T> GetLower();

-        public Vector128<T> GetUpper();

-        public T ToScalar();

-        public Vector256<T> WithElement(int index, T value);

-        public Vector256<T> WithLower(Vector128<T> value);

-        public Vector256<T> WithUpper(Vector128<T> value);

     }
     public static class Vector64 {
+        public static Vector64<U> As<T, U>(this Vector64<T> vector) where T : struct where U : struct;
+        public static Vector64<Byte> AsByte<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<Double> AsDouble<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<Int16> AsInt16<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<Int32> AsInt32<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<Int64> AsInt64<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<SByte> AsSByte<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<Single> AsSingle<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<UInt16> AsUInt16<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<UInt32> AsUInt32<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<UInt64> AsUInt64<T>(this Vector64<T> vector) where T : struct;
+        public static T GetElement<T>(this Vector64<T> vector, int index) where T : struct;
+        public static T ToScalar<T>(this Vector64<T> vector) where T : struct;
+        public static Vector128<T> ToVector128<T>(this Vector64<T> vector) where T : struct;
+        public static Vector128<T> ToVector128Unsafe<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<T> WithElement<T>(this Vector64<T> vector, int index, T value) where T : struct;
     }
     public readonly struct Vector64<T> : IEquatable<Vector64<T>>, IFormattable where T : struct {
-        public Vector64<U> As<U>() where U : struct;

-        public Vector64<Byte> AsByte();

-        public Vector64<Double> AsDouble();

-        public Vector64<Int16> AsInt16();

-        public Vector64<Int32> AsInt32();

-        public Vector64<Int64> AsInt64();

-        public Vector64<SByte> AsSByte();

-        public Vector64<Single> AsSingle();

-        public Vector64<UInt16> AsUInt16();

-        public Vector64<UInt32> AsUInt32();

-        public Vector64<UInt64> AsUInt64();

-        public T GetElement(int index);

-        public T ToScalar();

-        public Vector128<T> ToVector128();

-        public Vector128<T> ToVector128Unsafe();

-        public Vector64<T> WithElement(int index, T value);

     }
 }
```

