# System.IO.Pipelines

``` diff
 namespace System.IO.Pipelines {
     public class PipeOptions {
-        public PipeOptions(MemoryPool<byte> pool = null, PipeScheduler readerScheduler = null, PipeScheduler writerScheduler = null, long pauseWriterThreshold = (long)32768, long resumeWriterThreshold = (long)16384, int minimumSegmentSize = 2048, bool useSynchronizationContext = true);
+        public PipeOptions(MemoryPool<byte> pool = null, PipeScheduler readerScheduler = null, PipeScheduler writerScheduler = null, long pauseWriterThreshold = (long)65536, long resumeWriterThreshold = (long)32768, int minimumSegmentSize = 4096, bool useSynchronizationContext = true);
     }
     public abstract class PipeReader {
+        public static PipeReader Create(Stream stream, StreamPipeReaderOptions readerOptions = null);
     }
     public abstract class PipeWriter : IBufferWriter<byte> {
+        public static PipeWriter Create(Stream stream, StreamPipeWriterOptions writerOptions = null);
     }
+    public class StreamPipeReaderOptions {
+        public StreamPipeReaderOptions(MemoryPool<byte> pool = null, int bufferSize = 4096, int minimumReadSize = 1024);
+        public int BufferSize { get; }
+        public int MinimumReadSize { get; }
+        public MemoryPool<byte> Pool { get; }
+    }
+    public class StreamPipeWriterOptions {
+        public StreamPipeWriterOptions(MemoryPool<byte> pool = null, int minimumBufferSize = 4096);
+        public int MinimumBufferSize { get; }
+        public MemoryPool<byte> Pool { get; }
+    }
 }
```

