# System.Runtime.Intrinsics.X86

``` diff
 namespace System.Runtime.Intrinsics.X86 {
     public abstract class Avx2 : Avx {
+        public unsafe static Vector256<short> ConvertToVector256Int16(byte* address);
+        public static Vector256<short> ConvertToVector256Int16(Vector128<byte> value);
+        public unsafe static Vector256<short> ConvertToVector256Int16(sbyte* address);
+        public unsafe static Vector256<int> ConvertToVector256Int32(byte* address);
+        public unsafe static Vector256<int> ConvertToVector256Int32(short* address);
+        public static Vector256<int> ConvertToVector256Int32(Vector128<byte> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector128<ushort> value);
+        public unsafe static Vector256<int> ConvertToVector256Int32(sbyte* address);
+        public unsafe static Vector256<int> ConvertToVector256Int32(ushort* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(byte* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(short* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(int* address);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<byte> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<ushort> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<uint> value);
+        public unsafe static Vector256<long> ConvertToVector256Int64(sbyte* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(ushort* address);
+        public unsafe static Vector256<long> ConvertToVector256Int64(uint* address);
-        public static Vector256<ushort> ConvertToVector256UInt16(Vector128<byte> value);

-        public static Vector256<uint> ConvertToVector256UInt32(Vector128<byte> value);

-        public static Vector256<uint> ConvertToVector256UInt32(Vector128<ushort> value);

-        public static Vector256<ulong> ConvertToVector256UInt64(Vector128<byte> value);

-        public static Vector256<ulong> ConvertToVector256UInt64(Vector128<ushort> value);

-        public static Vector256<ulong> ConvertToVector256UInt64(Vector128<uint> value);

     }
     public enum FloatComparisonMode : byte {
-        EqualOrderedNonSignaling = (byte)0,

-        EqualOrderedSignaling = (byte)16,

-        EqualUnorderedNonSignaling = (byte)8,

-        EqualUnorderedSignaling = (byte)24,

-        FalseOrderedNonSignaling = (byte)11,

-        FalseOrderedSignaling = (byte)27,

-        GreaterThanOrderedNonSignaling = (byte)30,

-        GreaterThanOrderedSignaling = (byte)14,

-        GreaterThanOrEqualOrderedNonSignaling = (byte)29,

-        GreaterThanOrEqualOrderedSignaling = (byte)13,

-        LessThanOrderedNonSignaling = (byte)17,

-        LessThanOrderedSignaling = (byte)1,

-        LessThanOrEqualOrderedNonSignaling = (byte)18,

-        LessThanOrEqualOrderedSignaling = (byte)2,

-        NotEqualOrderedNonSignaling = (byte)12,

-        NotEqualOrderedSignaling = (byte)28,

-        NotEqualUnorderedNonSignaling = (byte)4,

-        NotEqualUnorderedSignaling = (byte)20,

-        NotGreaterThanOrEqualUnorderedNonSignaling = (byte)25,

-        NotGreaterThanOrEqualUnorderedSignaling = (byte)9,

-        NotGreaterThanUnorderedNonSignaling = (byte)26,

-        NotGreaterThanUnorderedSignaling = (byte)10,

-        NotLessThanOrEqualUnorderedNonSignaling = (byte)22,

-        NotLessThanOrEqualUnorderedSignaling = (byte)6,

-        NotLessThanUnorderedNonSignaling = (byte)21,

-        NotLessThanUnorderedSignaling = (byte)5,

+        OrderedEqualNonSignaling = (byte)0,
+        OrderedEqualSignaling = (byte)16,
+        OrderedFalseNonSignaling = (byte)11,
+        OrderedFalseSignaling = (byte)27,
+        OrderedGreaterThanNonSignaling = (byte)30,
+        OrderedGreaterThanOrEqualNonSignaling = (byte)29,
+        OrderedGreaterThanOrEqualSignaling = (byte)13,
+        OrderedGreaterThanSignaling = (byte)14,
+        OrderedLessThanNonSignaling = (byte)17,
+        OrderedLessThanOrEqualNonSignaling = (byte)18,
+        OrderedLessThanOrEqualSignaling = (byte)2,
+        OrderedLessThanSignaling = (byte)1,
+        OrderedNotEqualNonSignaling = (byte)12,
+        OrderedNotEqualSignaling = (byte)28,
-        TrueUnorderedNonSignaling = (byte)15,

-        TrueUnorderedSignaling = (byte)31,

+        UnorderedEqualNonSignaling = (byte)8,
+        UnorderedEqualSignaling = (byte)24,
+        UnorderedNotEqualNonSignaling = (byte)4,
+        UnorderedNotEqualSignaling = (byte)20,
+        UnorderedNotGreaterThanNonSignaling = (byte)26,
+        UnorderedNotGreaterThanOrEqualNonSignaling = (byte)25,
+        UnorderedNotGreaterThanOrEqualSignaling = (byte)9,
+        UnorderedNotGreaterThanSignaling = (byte)10,
+        UnorderedNotLessThanNonSignaling = (byte)21,
+        UnorderedNotLessThanOrEqualNonSignaling = (byte)22,
+        UnorderedNotLessThanOrEqualSignaling = (byte)6,
+        UnorderedNotLessThanSignaling = (byte)5,
+        UnorderedTrueNonSignaling = (byte)15,
+        UnorderedTrueSignaling = (byte)31,
     }
     public abstract class Sse {
-        public static bool CompareEqualOrderedScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareEqualScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareEqualUnorderedScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareGreaterThanOrderedScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareGreaterThanOrEqualOrderedScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareGreaterThanOrEqualScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareGreaterThanOrEqualUnorderedScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareGreaterThanScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareGreaterThanUnorderedScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareLessThanOrderedScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareLessThanOrEqualOrderedScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareLessThanOrEqualScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareLessThanOrEqualUnorderedScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareLessThanScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareLessThanUnorderedScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareNotEqualOrderedScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareNotEqualScalar(Vector128<float> left, Vector128<float> right);

-        public static bool CompareNotEqualUnorderedScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareNotGreaterThanOrEqualScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareNotGreaterThanScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareNotLessThanOrEqualScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareNotLessThanScalar(Vector128<float> left, Vector128<float> right);

-        public static Vector128<float> CompareOrderedScalar(Vector128<float> left, Vector128<float> right);

+        public static Vector128<float> CompareScalarEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarLessThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotLessThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarNotLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarOrdered(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedLessThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarOrderedNotEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareScalarUnordered(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedLessThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareScalarUnorderedNotEqual(Vector128<float> left, Vector128<float> right);
-        public static Vector128<float> CompareUnorderedScalar(Vector128<float> left, Vector128<float> right);

     }
     public abstract class Sse2 : Sse {
-        public static bool CompareEqualOrderedScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareEqualScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareEqualUnorderedScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareGreaterThanOrderedScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareGreaterThanOrEqualOrderedScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareGreaterThanOrEqualScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareGreaterThanOrEqualUnorderedScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareGreaterThanScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareGreaterThanUnorderedScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareLessThanOrderedScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareLessThanOrEqualOrderedScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareLessThanOrEqualScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareLessThanOrEqualUnorderedScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareLessThanScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareLessThanUnorderedScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareNotEqualOrderedScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareNotEqualScalar(Vector128<double> left, Vector128<double> right);

-        public static bool CompareNotEqualUnorderedScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareNotGreaterThanOrEqualScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareNotGreaterThanScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareNotLessThanOrEqualScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareNotLessThanScalar(Vector128<double> left, Vector128<double> right);

-        public static Vector128<double> CompareOrderedScalar(Vector128<double> left, Vector128<double> right);

+        public static Vector128<double> CompareScalarEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarLessThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotLessThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarNotLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarOrdered(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedLessThan(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarOrderedNotEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareScalarUnordered(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedLessThan(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareScalarUnorderedNotEqual(Vector128<double> left, Vector128<double> right);
-        public static Vector128<double> CompareUnorderedScalar(Vector128<double> left, Vector128<double> right);

-        public unsafe static void StoreLow(long* address, Vector128<long> source);

-        public unsafe static void StoreLow(ulong* address, Vector128<ulong> source);

+        public unsafe static void StoreScalar(long* address, Vector128<long> source);
+        public unsafe static void StoreScalar(ulong* address, Vector128<ulong> source);
     }
     public abstract class Sse41 : Ssse3 {
+        public unsafe static Vector128<short> ConvertToVector128Int16(byte* address);
+        public unsafe static Vector128<short> ConvertToVector128Int16(sbyte* address);
+        public unsafe static Vector128<int> ConvertToVector128Int32(byte* address);
+        public unsafe static Vector128<int> ConvertToVector128Int32(short* address);
+        public unsafe static Vector128<int> ConvertToVector128Int32(sbyte* address);
+        public unsafe static Vector128<int> ConvertToVector128Int32(ushort* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(byte* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(short* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(int* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(sbyte* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(ushort* address);
+        public unsafe static Vector128<long> ConvertToVector128Int64(uint* address);
     }
 }
```

