# System

``` diff
 namespace System {
-    public readonly struct Memory<T> {
+    public readonly struct Memory<T> : IEquatable<Memory<T>> {
-        public Memory<T> this[Range range] { get; }

-        public Memory<T> Slice(Index startIndex);

-        public Memory<T> Slice(Range range);

     }
     public static class MemoryExtensions {
+        public static Memory<char> Trim(this Memory<char> memory);
+        public static ReadOnlyMemory<char> Trim(this ReadOnlyMemory<char> memory);
+        public static Span<char> Trim(this Span<char> span);
+        public static Memory<T> Trim<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> Trim<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> memory, T trimElement) where T : IEquatable<T>;
+        public static Span<T> Trim<T>(this Span<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> Trim<T>(this Span<T> memory, T trimElement) where T : IEquatable<T>;
+        public static Memory<char> TrimEnd(this Memory<char> memory);
+        public static ReadOnlyMemory<char> TrimEnd(this ReadOnlyMemory<char> memory);
+        public static Span<char> TrimEnd(this Span<char> span);
+        public static Memory<T> TrimEnd<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> TrimEnd<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> memory, T trimElement) where T : IEquatable<T>;
+        public static Span<T> TrimEnd<T>(this Span<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> TrimEnd<T>(this Span<T> memory, T trimElement) where T : IEquatable<T>;
+        public static Memory<char> TrimStart(this Memory<char> memory);
+        public static ReadOnlyMemory<char> TrimStart(this ReadOnlyMemory<char> memory);
+        public static Span<char> TrimStart(this Span<char> span);
+        public static Memory<T> TrimStart<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> TrimStart<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> memory, T trimElement) where T : IEquatable<T>;
+        public static Span<T> TrimStart<T>(this Span<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> TrimStart<T>(this Span<T> memory, T trimElement) where T : IEquatable<T>;
     }
     public readonly struct Range : IEquatable<Range> {
-        public Range.OffsetAndLength GetOffsetAndLength(int length);

+        public ValueTuple<int, int> GetOffsetAndLength(int length);
-        public readonly struct OffsetAndLength {
 {
-            public OffsetAndLength(int offset, int length);

-            public int Length { get; }

-            public int Offset { get; }

-            public void Deconstruct(out int offset, out int length);

-        }
     }
-    public readonly struct ReadOnlyMemory<T> {
+    public readonly struct ReadOnlyMemory<T> : IEquatable<ReadOnlyMemory<T>> {
-        public ReadOnlyMemory<T> this[Range range] { get; }

-        public ReadOnlyMemory<T> Slice(Index startIndex);

-        public ReadOnlyMemory<T> Slice(Range range);

     }
     public readonly ref struct ReadOnlySpan<T> {
-        public ref readonly T this[Index index] { get; }

-        public ReadOnlySpan<T> this[Range range] { get; }

-        public ReadOnlySpan<T> Slice(Index startIndex);

-        public ReadOnlySpan<T> Slice(Range range);

     }
     public readonly ref struct Span<T> {
-        public ref T this[Index index] { get; }

-        public Span<T> this[Range range] { get; }

-        public Span<T> Slice(Index startIndex);

-        public Span<T> Slice(Range range);

     }
     public sealed class String : ICloneable, IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
-        [System.Runtime.CompilerServices.IndexerName("Chars")]
-        public char this[Index index] { get; }

-        [System.Runtime.CompilerServices.IndexerName("Chars")]
-        public string this[Range range] { get; }

+        public ref readonly char GetPinnableReference();
-        public String Substring(Index startIndex);

-        public String Substring(Range range);

     }
 }
```

