# .NET Core SDK 2.0.2 with .NET Core 2.0.0

This release updates only the .NET Core SDK to include work which was included in Visual Studio 15.4

* .NET Core SDK 2.0.2
* .NET Core Runtime 2.0.0 (previously released)

|                         | SDK Installer                                        | SDK Binaries                                        | Runtime Installer | Runtime Binaries |
| ----------------------- | :----------------------------------------------: | :----------------------------------------------:| :--: | :--: |
| Windows                 | [32-bit](https://download.microsoft.com/download/7/3/A/73A3E4DC-F019-47D1-9951-0453676E059B/dotnet-sdk-2.0.2-win-x86.exe) / [64-bit](https://download.microsoft.com/download/7/3/A/73A3E4DC-F019-47D1-9951-0453676E059B/dotnet-sdk-2.0.2-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/7/3/A/73A3E4DC-F019-47D1-9951-0453676E059B/dotnet-sdk-2.0.2-win-x86.zip) / [64-bit](https://download.microsoft.com/download/7/3/A/73A3E4DC-F019-47D1-9951-0453676E059B/dotnet-sdk-2.0.2-win-x64.zip) | [32-bit](https://download.microsoft.com/download/5/6/B/56BFEF92-9045-4414-970C-AB31E0FC07EC/dotnet-runtime-2.0.0-win-x86.exe) / [64-bit](https://download.microsoft.com/download/5/6/B/56BFEF92-9045-4414-970C-AB31E0FC07EC/dotnet-runtime-2.0.0-win-x64.exe) | [32-bit](https://download.microsoft.com/download/5/F/0/5F0362BD-7D0A-4A9D-9BF9-022C6B15B04D/dotnet-runtime-2.0.0-win-x86.zip) / [64-bit](https://download.microsoft.com/download/5/F/0/5F0362BD-7D0A-4A9D-9BF9-022C6B15B04D/dotnet-runtime-2.0.0-win-x64.zip) |
| macOS                   | [64-bit](https://download.microsoft.com/download/7/3/A/73A3E4DC-F019-47D1-9951-0453676E059B/dotnet-sdk-2.0.2-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/7/3/A/73A3E4DC-F019-47D1-9951-0453676E059B/dotnet-sdk-2.0.2-osx-x64.tar.gz)                          | [64-bit](https://download.microsoft.com/download/5/6/B/56BFEF92-9045-4414-970C-AB31E0FC07EC/dotnet-runtime-2.0.0-osx-x64.pkg) | [64-bit](https://download.microsoft.com/download/5/F/0/5F0362BD-7D0A-4A9D-9BF9-022C6B15B04D/dotnet-runtime-2.0.0-osx-x64.tar.gz) |
| Linux *                 | -                                                         | [64-bit](https://download.microsoft.com/download/7/3/A/73A3E4DC-F019-47D1-9951-0453676E059B/dotnet-sdk-2.0.2-linux-x64.tar.gz)                          | - | [64-bit](https://download.microsoft.com/download/5/F/0/5F0362BD-7D0A-4A9D-9BF9-022C6B15B04D/dotnet-runtime-2.0.0-linux-x64.tar.gz) |
| Ubuntu                  | See installations steps below | [64-bit](https://download.microsoft.com/download/7/3/A/73A3E4DC-F019-47D1-9951-0453676E059B/dotnet-sdk-2.0.2-linux-x64.tar.gz)                          | See installation steps below | [64-bit](https://download.microsoft.com/download/5/F/0/5F0362BD-7D0A-4A9D-9BF9-022C6B15B04D/dotnet-runtime-2.0.0-linux-x64.tar.gz) |

**Note:** The 'Linux' binary archives are new for the 2.0 release. This package contains binaries which are compatible with [Linux distros and versions supported by .NET Core](https://github.com/dotnet/core/blob/master/release-notes/2.0/2.0-supported-os.md).

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.0-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.2-sdk-sha.txt)

**Debug Symbols**
* [Shared Framework](https://download.microsoft.com/download/D/E/B/DEB55D32-4CC3-46B0-A241-1A5BF2BB533C/corefx-2.0-symbols.zip)
* [Runtime](https://download.microsoft.com/download/D/E/B/DEB55D32-4CC3-46B0-A241-1A5BF2BB533C/coreclr-2.0-symbols.zip)
* [Core-Setup](https://download.microsoft.com/download/D/E/B/DEB55D32-4CC3-46B0-A241-1A5BF2BB533C/core-setup-2.0-symbols.zip)

## Docker

Images for .NET Core 2.0.0 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).

## Installing .NET Core on Linux

### Uninstall any Preview versions

If you have .NET Core Previews installed, it will need to be removed before attempting to install .NET Core 2.0. This can be done by running a command such as the following.

`sudo apt remove dotnet-dev-2.0.0-preview2-006497`

### Ubuntu and Debian based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Ubuntu 17.04

```bash
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-ubuntu-zesty-prod zesty main" > /etc/apt/sources.list.d/dotnetdev.list'
```

#### Ubuntu 16.04 and Linux Mint 18

```bash
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-ubuntu-xenial-prod xenial main" > /etc/apt/sources.list.d/dotnetdev.list'
```

#### Ubuntu 14.04 and Linux Mint 17

```bash
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-ubuntu-trusty-prod trusty main" > /etc/apt/sources.list.d/dotnetdev.list'
```

#### Debian 9 (Stretch)

```bash
sudo apt-get install curl libunwind8 gettext apt-transport-https gnupg
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-debian-stretch-prod stretch main" > /etc/apt/sources.list.d/dotnetdev.list'
```

#### Debian 8 (Jessie)

```bash
sudo apt-get install curl libunwind8 gettext
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-debian-jessie-prod jessie main" > /etc/apt/sources.list.d/dotnetdev.list'
```

Then, update the package cache and install .NET Core

```bash
sudo apt-get update
sudo apt-get install dotnet-sdk-2.0.2
```

### RHEL and Fedora based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Fedora, CentOS, Oracle Linux

```bash
sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
sudo sh -c 'echo -e "[packages-microsoft-com-prod]\nname=packages-microsoft-com-prod \nbaseurl=https://packages.microsoft.com/yumrepos/microsoft-rhel7.3-prod\nenabled=1\ngpgcheck=1\ngpgkey=https://packages.microsoft.com/keys/microsoft.asc" > /etc/yum.repos.d/dotnetdev.repo'
sudo yum install libunwind libicu
```

#### SUSE Enterprise Linux and OpenSUSE

```bash
sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
sudo sh -c 'echo -e "[packages-microsoft-com-prod]\nname=packages-microsoft-com-prod \nbaseurl=https://packages.microsoft.com/yumrepos/microsoft-rhel7.3-prod\nenabled=1\ngpgcheck=1\ngpgkey=https://packages.microsoft.com/keys/microsoft.asc" > /etc/zypp/repos.d/dotnetdev.repo'
sudo zypper install libunwind libicu
```

Then, update the package cache and install .NET Core

#### Fedora, CentOS and Oracle Linux

```bash
sudo yum update
sudo yum install dotnet-sdk-2.0.2
```

#### SUSE Enterprise Linux and OpenSUSE

```bash
sudo zypper update
sudo zypper install dotnet-sdk-2.0.2
```

**Note:** When installing the SDK, SUSE and OpenSUSE may report that nothing provides libcurl. libcurl should already be installed on supported versions of both distros. Run zypper search libcurl to confirm. The error will present 2 'solutions'. Choose 'Solution 2' to continue installing .NET Core.

## Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`. This is a change from previous versions of .NET Core. Additional details can be seen in [.NET Core 2.0 Known Issues](https://github.com/dotnet/core/blob/master/release-notes/2.0/2.0.0-known-issues.md).

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## Server Hosting

### Windows
If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime. You can download the Windows (Server Hosting) installer and run the following command from an Administrator command prompt:

[DotNetCore.2.0.0-WindowsHosting.exe](https://download.microsoft.com/download/B/1/D/B1D7D5BF-3920-47AA-94BD-7A6E48822F18/DotNetCore.2.0.0-WindowsHosting.exe)

### Linux

On supported Linux systems, register the Microsoft Product feed as described above and install `dotnet-hosting-2.0.0` using your package manager. 

### ASP.NET Core Package Store

The Runtime Package Store is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the Runtime Package Store separately, the following can be used.

* [AspNetCore.2.0.0.RuntimePackageStore_x64.exe](https://download.microsoft.com/download/B/1/D/B1D7D5BF-3920-47AA-94BD-7A6E48822F18/AspNetCore.2.0.0.RuntimePackageStore_x64.exe)
* [AspNetCore.2.0.0.RuntimePackageStore_x86.exe](https://download.microsoft.com/download/B/1/D/B1D7D5BF-3920-47AA-94BD-7A6E48822F18/AspNetCore.2.0.0.RuntimePackageStore_x86.exe)
