# .NET Core 2.0.9

.NET Core 2.0.9 comprises:

* .NET Core Runtime 2.0.9 ([release notes](../2.0/2.0.9.md))
* .NET Core SDK 2.1.202

|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: |
| Windows | [32-bit](https://download.microsoft.com/download/f/c/1/fc16c864-b374-4668-83a2-f9f880928b2d/dotnet-sdk-2.1.202-win-x86.exe) / [64-bit](https://download.microsoft.com/download/f/c/1/fc16c864-b374-4668-83a2-f9f880928b2d/dotnet-sdk-2.1.202-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/f/c/1/fc16c864-b374-4668-83a2-f9f880928b2d/dotnet-sdk-2.1.202-win-x86.zip) / [64-bit](https://download.microsoft.com/download/f/c/1/fc16c864-b374-4668-83a2-f9f880928b2d/dotnet-sdk-2.1.202-win-x64.zip) | [32-bit](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/dotnet-runtime-2.0.9-win-x86.exe) / [64-bit](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/dotnet-runtime-2.0.9-win-x64.exe) | [32-bit](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/dotnet-runtime-2.0.9-win-x86.zip) / [64-bit](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/dotnet-runtime-2.0.9-win-x64.zip) |
| macOS   | [64-bit](https://download.microsoft.com/download/f/c/1/fc16c864-b374-4668-83a2-f9f880928b2d/dotnet-sdk-2.1.202-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/f/c/1/fc16c864-b374-4668-83a2-f9f880928b2d/dotnet-sdk-2.1.202-osx-x64.tar.gz)| [64-bit](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/dotnet-runtime-2.0.9-osx-x64.pkg)      | [64-bit](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/dotnet-runtime-2.0.9-osx-x64.tar.gz)   |
| Linux * | See installations steps below                         | [64-bit](https://download.microsoft.com/download/f/c/1/fc16c864-b374-4668-83a2-f9f880928b2d/dotnet-sdk-2.1.202-linux-x64.tar.gz)     | -                                                                  | [64-bit](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/dotnet-runtime-2.0.9-linux-x64.tar.gz) |

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.9-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.202-sdk-sha.txt)

**Debug Symbols**
* [Shared Framework](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/corefx-2.0-symbols.zip)
* [Runtime](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/coreclr-2.0-symbols.zip)

## Docker

Images for .NET Core 2.0.9 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).
## Installing .NET Core on Linux

### Uninstall any Preview versions

If you have .NET Core Previews installed, it will need to be removed before attempting to install .NET Core 2.0. This can be done by running a command such as the following.

`sudo apt remove dotnet-dev-2.0.0-preview2-006497`

Instructions for installing using your package manager can be found on the [dotnet-core](https://www.microsoft.com/net/download/linux) site.

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.0.9` using your package manager.

## Server Hosting

If you are looking to host stand-alone apps on Servers, the following installers can be used on Windows and Linx systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [DotNetCore.2.0.9-WindowsHosting.exe](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/DotNetCore.2.0.9-WindowsHosting.exe)

This will install the ASP.NET Core Module for IIS

### Linux

On supported Linux systems, register the Microsoft Product feed as described above and install `dotnet-hosting-2.0.9` using your package manager. This will also install the .NET Core Runtime and other required packages.

### ASP.NET Core Runtime Package Store

The Runtime Package Store is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the Runtime Package Store separately, the following can be used.

* [AspNetCore.2.0.9.RuntimePackageStore_x64.exe](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/AspNetCore.2.0.9.RuntimePackageStore_x64.exe)
* [AspNetCore.2.0.9.RuntimePackageStore_x86.exe](https://download.microsoft.com/download/3/a/3/3a3bda26-560d-4d8e-922e-6f6bc4553a84/AspNetCore.2.0.9.RuntimePackageStore_x86.exe)

On Linux systems install `aspnetcore-store-2.0.9` using your package manager. This will install both the ASP.NET Core and .NET Core runtime components.
