# Microsoft Team Onboarding

If you are new to Microsoft, you will need to onboard into various GitHub projects in order to get your work done.

## Join .NET teams in dotnet and Microsoft orgs

You first need to link your GitHub account so that you can use Microsoft's GitHub management tools.

* [Link your GitHub account](https://repos.opensource.microsoft.com/link)

There are two main teams to join to get access to Microsoft .NET-related projects.

* **dotnet org:** [Add yourself to the microsoft team](https://repos.opensource.microsoft.com/dotnet/teams/microsoft/join/)
* **Microsoft org:** [Add yourself to the dotnet team](https://repos.opensource.microsoft.com/Microsoft/teams/dotnet/join/)

The primary reason to join the orgs are the following: 

* Users will be able to @mention you on [.NET Core Repos](https://github.com/dotnet/core/blob/master/Documentation/core-repos.md)
* You will be able to access to private repos we maintain
* You will get write access to a subset of repos

## Configure your GitHub account as a Microsoft employee (recommended)

* Publicly associate yourself with dotnet and Microsoft orgs
    * For Microsoft, go to https://github.com/orgs/Microsoft/people
    * For dotnet, go to https://github.com/orgs/dotnet/people
    * Search for your GitHub handle in the list
    * Choose `Public` from the drop-down list of organization visibility
    * Note: Everyone will now see an org badge on your GH profile in the Organizations section
* Update your profile
    * Go to https://github.com/settings/profile
    * Match your **Name** on GitHub with full name in address book (so other employees can find you and contact you internally when needed)
    * Set `@Microsoft` as your **Company**
    * Upload your **picture**, ideally showing your face
        * Hint: You can grab your GAL picture from https://microsoft-my.sharepoint.com

## Install Microsoft open source tools (recommended)

The tools make it easier to use open source and participate in open source projects:

* [Browser Extension](https://docs.opensource.microsoft.com/tools/browser.html) -- Identifies Microsoft employees on GitHub.
* [VS Code Extension](https://docs.opensource.microsoft.com/tools/vscode.html) --  Provides information about known vulnerabilities.

The browser extension is recommended. The VS code extension is optional.

## Get write permissions to repos (optional)

Join teams to gain write access to repos:
 * Request team membership via https://repos.opensource.microsoft.com/teams
 * Find the right teams - e.g. `dotnet-coreclr`, `dotnet-corefx`, etc.
 * Ask someone if you don't know which team to join.
 * Select `Request to join this team` on the right side - it will send email request to maintainers of the team

## Service Accounts

Service accounts should also be linked. For more details, see [Service accounts for GitHub](https://docs.opensource.microsoft.com/github/service-accounts.html).


## Guidelines

* [Contributing to .NET Core](https://github.com/dotnet/coreclr/blob/master/Documentation/project-docs/contributing.md)
* [What you can expect from Maintainers](https://github.com/dotnet/core/blob/master/Documentation/contributing/maintainers.md)


## Tools

* [Corporate GitHub Chrome Extension](https://repos.opensource.microsoft.com/settings/security/tokens/extension)
* [CodeFlow Chrome Extension](https://chrome.google.com/webstore/detail/codeflow/aphnoipocoffpdafmiidfmaiadhilelm)


## Resources

* [.NET Core "Home Repo"](https://github.com/dotnet/core) (links to install daily builds)
* [Introduction to the Common Language Runtime (CLR)](https://github.com/dotnet/coreclr/blob/master/Documentation/botr/intro-to-clr.md)
* [The Book of the Runtime](https://github.com/dotnet/coreclr/blob/master/Documentation/botr/README.md)
* [CoreCLR Docs](https://github.com/dotnet/coreclr/tree/master/Documentation)
