# System.Runtime.InteropServices.ComTypes

``` diff
+namespace System.Runtime.InteropServices.ComTypes {
+    public enum ADVF {
+        ADVF_DATAONSTOP = 64,
+        ADVF_NODATA = 1,
+        ADVF_ONLYONCE = 4,
+        ADVF_PRIMEFIRST = 2,
+        ADVFCACHE_FORCEBUILTIN = 16,
+        ADVFCACHE_NOHANDLER = 8,
+        ADVFCACHE_ONSAVE = 32,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct BIND_OPTS {
+        public int cbStruct;
+        public int dwTickCountDeadline;
+        public int grfFlags;
+        public int grfMode;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Explicit)]
+    public struct BINDPTR {
+        [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
+        public IntPtr lpfuncdesc;
+        [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
+        public IntPtr lptcomp;
+        [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
+        public IntPtr lpvardesc;
+    }
+    public enum CALLCONV {
+        CC_CDECL = 1,
+        CC_MACPASCAL = 3,
+        CC_MAX = 9,
+        CC_MPWCDECL = 7,
+        CC_MPWPASCAL = 8,
+        CC_MSCPASCAL = 2,
+        CC_PASCAL = 2,
+        CC_RESERVED = 5,
+        CC_STDCALL = 4,
+        CC_SYSCALL = 6,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CONNECTDATA {
+        public int dwCookie;
+        public object pUnk;
+    }
+    public enum DATADIR {
+        DATADIR_GET = 1,
+        DATADIR_SET = 2,
+    }
+    public enum DESCKIND {
+        DESCKIND_FUNCDESC = 1,
+        DESCKIND_IMPLICITAPPOBJ = 4,
+        DESCKIND_MAX = 5,
+        DESCKIND_NONE = 0,
+        DESCKIND_TYPECOMP = 3,
+        DESCKIND_VARDESC = 2,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DISPPARAMS {
+        public int cArgs;
+        public int cNamedArgs;
+        public IntPtr rgdispidNamedArgs;
+        public IntPtr rgvarg;
+    }
+    public enum DVASPECT {
+        DVASPECT_CONTENT = 1,
+        DVASPECT_DOCPRINT = 8,
+        DVASPECT_ICON = 4,
+        DVASPECT_THUMBNAIL = 2,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ELEMDESC {
+        public ELEMDESC.DESCUNION desc;
+        public TYPEDESC tdesc;
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Explicit)]
+        public struct DESCUNION {
+            [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
+            public IDLDESC idldesc;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
+            public PARAMDESC paramdesc;
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct EXCEPINFO {
+        public short wCode;
+        public short wReserved;
+        public int dwHelpContext;
+        public int scode;
+        public IntPtr pfnDeferredFillIn;
+        public IntPtr pvReserved;
+        public string bstrDescription;
+        public string bstrHelpFile;
+        public string bstrSource;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct FILETIME {
+        public int dwHighDateTime;
+        public int dwLowDateTime;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct FORMATETC {
+        public short cfFormat;
+        public int lindex;
+        public IntPtr ptd;
+        public DVASPECT dwAspect;
+        public TYMED tymed;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct FUNCDESC {
+        public short cParams;
+        public short cParamsOpt;
+        public short cScodes;
+        public short oVft;
+        public short wFuncFlags;
+        public int memid;
+        public IntPtr lprgelemdescParam;
+        public IntPtr lprgscode;
+        public CALLCONV callconv;
+        public ELEMDESC elemdescFunc;
+        public FUNCKIND funckind;
+        public INVOKEKIND invkind;
+    }
+    public enum FUNCFLAGS : short {
+        FUNCFLAG_FBINDABLE = (short)4,
+        FUNCFLAG_FDEFAULTBIND = (short)32,
+        FUNCFLAG_FDEFAULTCOLLELEM = (short)256,
+        FUNCFLAG_FDISPLAYBIND = (short)16,
+        FUNCFLAG_FHIDDEN = (short)64,
+        FUNCFLAG_FIMMEDIATEBIND = (short)4096,
+        FUNCFLAG_FNONBROWSABLE = (short)1024,
+        FUNCFLAG_FREPLACEABLE = (short)2048,
+        FUNCFLAG_FREQUESTEDIT = (short)8,
+        FUNCFLAG_FRESTRICTED = (short)1,
+        FUNCFLAG_FSOURCE = (short)2,
+        FUNCFLAG_FUIDEFAULT = (short)512,
+        FUNCFLAG_FUSESGETLASTERROR = (short)128,
+    }
+    public enum FUNCKIND {
+        FUNC_DISPATCH = 4,
+        FUNC_NONVIRTUAL = 2,
+        FUNC_PUREVIRTUAL = 1,
+        FUNC_STATIC = 3,
+        FUNC_VIRTUAL = 0,
+    }
+    public interface IAdviseSink {
+        void OnClose();
+        void OnDataChange(ref FORMATETC format, ref STGMEDIUM stgmedium);
+        void OnRename(IMoniker moniker);
+        void OnSave();
+        void OnViewChange(int aspect, int index);
+    }
+    public interface IBindCtx {
+        void EnumObjectParam(out IEnumString ppenum);
+        void GetBindOptions(ref BIND_OPTS pbindopts);
+        void GetObjectParam(string pszKey, out object ppunk);
+        void GetRunningObjectTable(out IRunningObjectTable pprot);
+        void RegisterObjectBound(object punk);
+        void RegisterObjectParam(string pszKey, object punk);
+        void ReleaseBoundObjects();
+        void RevokeObjectBound(object punk);
+        int RevokeObjectParam(string pszKey);
+        void SetBindOptions(ref BIND_OPTS pbindopts);
+    }
+    public interface IConnectionPoint {
+        void Advise(object pUnkSink, out int pdwCookie);
+        void EnumConnections(out IEnumConnections ppEnum);
+        void GetConnectionInterface(out Guid pIID);
+        void GetConnectionPointContainer(out IConnectionPointContainer ppCPC);
+        void Unadvise(int dwCookie);
+    }
+    public interface IConnectionPointContainer {
+        void EnumConnectionPoints(out IEnumConnectionPoints ppEnum);
+        void FindConnectionPoint(ref Guid riid, out IConnectionPoint ppCP);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct IDLDESC {
+        public IntPtr dwReserved;
+        public IDLFLAG wIDLFlags;
+    }
+    public enum IDLFLAG : short {
+        IDLFLAG_FIN = (short)1,
+        IDLFLAG_FLCID = (short)4,
+        IDLFLAG_FOUT = (short)2,
+        IDLFLAG_FRETVAL = (short)8,
+        IDLFLAG_NONE = (short)0,
+    }
+    public interface IEnumConnectionPoints {
+        void Clone(out IEnumConnectionPoints ppenum);
+        int Next(int celt, IConnectionPoint[] rgelt, IntPtr pceltFetched);
+        void Reset();
+        int Skip(int celt);
+    }
+    public interface IEnumConnections {
+        void Clone(out IEnumConnections ppenum);
+        int Next(int celt, CONNECTDATA[] rgelt, IntPtr pceltFetched);
+        void Reset();
+        int Skip(int celt);
+    }
+    public interface IEnumFORMATETC {
+        void Clone(out IEnumFORMATETC newEnum);
+        int Next(int celt, FORMATETC[] rgelt, int[] pceltFetched);
+        int Reset();
+        int Skip(int celt);
+    }
+    public interface IEnumMoniker {
+        void Clone(out IEnumMoniker ppenum);
+        int Next(int celt, IMoniker[] rgelt, IntPtr pceltFetched);
+        void Reset();
+        int Skip(int celt);
+    }
+    public interface IEnumString {
+        void Clone(out IEnumString ppenum);
+        int Next(int celt, string[] rgelt, IntPtr pceltFetched);
+        void Reset();
+        int Skip(int celt);
+    }
+    public interface IEnumVARIANT {
+        IEnumVARIANT Clone();
+        int Next(int celt, object[] rgVar, IntPtr pceltFetched);
+        int Reset();
+        int Skip(int celt);
+    }
+    public interface IMoniker {
+        void BindToObject(IBindCtx pbc, IMoniker pmkToLeft, ref Guid riidResult, out object ppvResult);
+        void BindToStorage(IBindCtx pbc, IMoniker pmkToLeft, ref Guid riid, out object ppvObj);
+        void CommonPrefixWith(IMoniker pmkOther, out IMoniker ppmkPrefix);
+        void ComposeWith(IMoniker pmkRight, bool fOnlyIfNotGeneric, out IMoniker ppmkComposite);
+        void Enum(bool fForward, out IEnumMoniker ppenumMoniker);
+        void GetClassID(out Guid pClassID);
+        void GetDisplayName(IBindCtx pbc, IMoniker pmkToLeft, out string ppszDisplayName);
+        void GetSizeMax(out long pcbSize);
+        void GetTimeOfLastChange(IBindCtx pbc, IMoniker pmkToLeft, out FILETIME pFileTime);
+        void Hash(out int pdwHash);
+        void Inverse(out IMoniker ppmk);
+        int IsDirty();
+        int IsEqual(IMoniker pmkOtherMoniker);
+        int IsRunning(IBindCtx pbc, IMoniker pmkToLeft, IMoniker pmkNewlyRunning);
+        int IsSystemMoniker(out int pdwMksys);
+        void Load(IStream pStm);
+        void ParseDisplayName(IBindCtx pbc, IMoniker pmkToLeft, string pszDisplayName, out int pchEaten, out IMoniker ppmkOut);
+        void Reduce(IBindCtx pbc, int dwReduceHowFar, ref IMoniker ppmkToLeft, out IMoniker ppmkReduced);
+        void RelativePathTo(IMoniker pmkOther, out IMoniker ppmkRelPath);
+        void Save(IStream pStm, bool fClearDirty);
+    }
+    public enum IMPLTYPEFLAGS {
+        IMPLTYPEFLAG_FDEFAULT = 1,
+        IMPLTYPEFLAG_FDEFAULTVTABLE = 8,
+        IMPLTYPEFLAG_FRESTRICTED = 4,
+        IMPLTYPEFLAG_FSOURCE = 2,
+    }
+    public enum INVOKEKIND {
+        INVOKE_FUNC = 1,
+        INVOKE_PROPERTYGET = 2,
+        INVOKE_PROPERTYPUT = 4,
+        INVOKE_PROPERTYPUTREF = 8,
+    }
+    public interface IPersistFile {
+        void GetClassID(out Guid pClassID);
+        void GetCurFile(out string ppszFileName);
+        int IsDirty();
+        void Load(string pszFileName, int dwMode);
+        void Save(string pszFileName, bool fRemember);
+        void SaveCompleted(string pszFileName);
+    }
+    public interface IRunningObjectTable {
+        void EnumRunning(out IEnumMoniker ppenumMoniker);
+        int GetObject(IMoniker pmkObjectName, out object ppunkObject);
+        int GetTimeOfLastChange(IMoniker pmkObjectName, out FILETIME pfiletime);
+        int IsRunning(IMoniker pmkObjectName);
+        void NoteChangeTime(int dwRegister, ref FILETIME pfiletime);
+        int Register(int grfFlags, object punkObject, IMoniker pmkObjectName);
+        void Revoke(int dwRegister);
+    }
+    public interface IStream {
+        void Clone(out IStream ppstm);
+        void Commit(int grfCommitFlags);
+        void CopyTo(IStream pstm, long cb, IntPtr pcbRead, IntPtr pcbWritten);
+        void LockRegion(long libOffset, long cb, int dwLockType);
+        void Read(byte[] pv, int cb, IntPtr pcbRead);
+        void Revert();
+        void Seek(long dlibMove, int dwOrigin, IntPtr plibNewPosition);
+        void SetSize(long libNewSize);
+        void Stat(out STATSTG pstatstg, int grfStatFlag);
+        void UnlockRegion(long libOffset, long cb, int dwLockType);
+        void Write(byte[] pv, int cb, IntPtr pcbWritten);
+    }
+    public interface ITypeComp {
+        void Bind(string szName, int lHashVal, short wFlags, out ITypeInfo ppTInfo, out DESCKIND pDescKind, out BINDPTR pBindPtr);
+        void BindType(string szName, int lHashVal, out ITypeInfo ppTInfo, out ITypeComp ppTComp);
+    }
+    public interface ITypeInfo {
+        void AddressOfMember(int memid, INVOKEKIND invKind, out IntPtr ppv);
+        void CreateInstance(object pUnkOuter, ref Guid riid, out object ppvObj);
+        void GetContainingTypeLib(out ITypeLib ppTLB, out int pIndex);
+        void GetDllEntry(int memid, INVOKEKIND invKind, IntPtr pBstrDllName, IntPtr pBstrName, IntPtr pwOrdinal);
+        void GetDocumentation(int index, out string strName, out string strDocString, out int dwHelpContext, out string strHelpFile);
+        void GetFuncDesc(int index, out IntPtr ppFuncDesc);
+        void GetIDsOfNames(string[] rgszNames, int cNames, int[] pMemId);
+        void GetImplTypeFlags(int index, out IMPLTYPEFLAGS pImplTypeFlags);
+        void GetMops(int memid, out string pBstrMops);
+        void GetNames(int memid, string[] rgBstrNames, int cMaxNames, out int pcNames);
+        void GetRefTypeInfo(int hRef, out ITypeInfo ppTI);
+        void GetRefTypeOfImplType(int index, out int href);
+        void GetTypeAttr(out IntPtr ppTypeAttr);
+        void GetTypeComp(out ITypeComp ppTComp);
+        void GetVarDesc(int index, out IntPtr ppVarDesc);
+        void Invoke(object pvInstance, int memid, short wFlags, ref DISPPARAMS pDispParams, IntPtr pVarResult, IntPtr pExcepInfo, out int puArgErr);
+        void ReleaseFuncDesc(IntPtr pFuncDesc);
+        void ReleaseTypeAttr(IntPtr pTypeAttr);
+        void ReleaseVarDesc(IntPtr pVarDesc);
+    }
+    public interface ITypeInfo2 : ITypeInfo {
+        new void AddressOfMember(int memid, INVOKEKIND invKind, out IntPtr ppv);
+        new void CreateInstance(object pUnkOuter, ref Guid riid, out object ppvObj);
+        void GetAllCustData(IntPtr pCustData);
+        void GetAllFuncCustData(int index, IntPtr pCustData);
+        void GetAllImplTypeCustData(int index, IntPtr pCustData);
+        void GetAllParamCustData(int indexFunc, int indexParam, IntPtr pCustData);
+        void GetAllVarCustData(int index, IntPtr pCustData);
+        new void GetContainingTypeLib(out ITypeLib ppTLB, out int pIndex);
+        void GetCustData(ref Guid guid, out object pVarVal);
+        new void GetDllEntry(int memid, INVOKEKIND invKind, IntPtr pBstrDllName, IntPtr pBstrName, IntPtr pwOrdinal);
+        new void GetDocumentation(int index, out string strName, out string strDocString, out int dwHelpContext, out string strHelpFile);
+        void GetDocumentation2(int memid, out string pbstrHelpString, out int pdwHelpStringContext, out string pbstrHelpStringDll);
+        void GetFuncCustData(int index, ref Guid guid, out object pVarVal);
+        new void GetFuncDesc(int index, out IntPtr ppFuncDesc);
+        void GetFuncIndexOfMemId(int memid, INVOKEKIND invKind, out int pFuncIndex);
+        new void GetIDsOfNames(string[] rgszNames, int cNames, int[] pMemId);
+        void GetImplTypeCustData(int index, ref Guid guid, out object pVarVal);
+        new void GetImplTypeFlags(int index, out IMPLTYPEFLAGS pImplTypeFlags);
+        new void GetMops(int memid, out string pBstrMops);
+        new void GetNames(int memid, string[] rgBstrNames, int cMaxNames, out int pcNames);
+        void GetParamCustData(int indexFunc, int indexParam, ref Guid guid, out object pVarVal);
+        new void GetRefTypeInfo(int hRef, out ITypeInfo ppTI);
+        new void GetRefTypeOfImplType(int index, out int href);
+        new void GetTypeAttr(out IntPtr ppTypeAttr);
+        new void GetTypeComp(out ITypeComp ppTComp);
+        void GetTypeFlags(out int pTypeFlags);
+        void GetTypeKind(out TYPEKIND pTypeKind);
+        void GetVarCustData(int index, ref Guid guid, out object pVarVal);
+        new void GetVarDesc(int index, out IntPtr ppVarDesc);
+        void GetVarIndexOfMemId(int memid, out int pVarIndex);
+        new void Invoke(object pvInstance, int memid, short wFlags, ref DISPPARAMS pDispParams, IntPtr pVarResult, IntPtr pExcepInfo, out int puArgErr);
+        new void ReleaseFuncDesc(IntPtr pFuncDesc);
+        new void ReleaseTypeAttr(IntPtr pTypeAttr);
+        new void ReleaseVarDesc(IntPtr pVarDesc);
+    }
+    public interface ITypeLib {
+        void FindName(string szNameBuf, int lHashVal, ITypeInfo[] ppTInfo, int[] rgMemId, ref short pcFound);
+        void GetDocumentation(int index, out string strName, out string strDocString, out int dwHelpContext, out string strHelpFile);
+        void GetLibAttr(out IntPtr ppTLibAttr);
+        void GetTypeComp(out ITypeComp ppTComp);
+        void GetTypeInfo(int index, out ITypeInfo ppTI);
+        int GetTypeInfoCount();
+        void GetTypeInfoOfGuid(ref Guid guid, out ITypeInfo ppTInfo);
+        void GetTypeInfoType(int index, out TYPEKIND pTKind);
+        bool IsName(string szNameBuf, int lHashVal);
+        void ReleaseTLibAttr(IntPtr pTLibAttr);
+    }
+    public interface ITypeLib2 : ITypeLib {
+        new void FindName(string szNameBuf, int lHashVal, ITypeInfo[] ppTInfo, int[] rgMemId, ref short pcFound);
+        void GetAllCustData(IntPtr pCustData);
+        void GetCustData(ref Guid guid, out object pVarVal);
+        new void GetDocumentation(int index, out string strName, out string strDocString, out int dwHelpContext, out string strHelpFile);
+        void GetDocumentation2(int index, out string pbstrHelpString, out int pdwHelpStringContext, out string pbstrHelpStringDll);
+        new void GetLibAttr(out IntPtr ppTLibAttr);
+        void GetLibStatistics(IntPtr pcUniqueNames, out int pcchUniqueNames);
+        new void GetTypeComp(out ITypeComp ppTComp);
+        new void GetTypeInfo(int index, out ITypeInfo ppTI);
+        new int GetTypeInfoCount();
+        new void GetTypeInfoOfGuid(ref Guid guid, out ITypeInfo ppTInfo);
+        new void GetTypeInfoType(int index, out TYPEKIND pTKind);
+        new bool IsName(string szNameBuf, int lHashVal);
+        new void ReleaseTLibAttr(IntPtr pTLibAttr);
+    }
+    public enum LIBFLAGS : short {
+        LIBFLAG_FCONTROL = (short)2,
+        LIBFLAG_FHASDISKIMAGE = (short)8,
+        LIBFLAG_FHIDDEN = (short)4,
+        LIBFLAG_FRESTRICTED = (short)1,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct PARAMDESC {
+        public IntPtr lpVarValue;
+        public PARAMFLAG wParamFlags;
+    }
+    public enum PARAMFLAG : short {
+        PARAMFLAG_FHASCUSTDATA = (short)64,
+        PARAMFLAG_FHASDEFAULT = (short)32,
+        PARAMFLAG_FIN = (short)1,
+        PARAMFLAG_FLCID = (short)4,
+        PARAMFLAG_FOPT = (short)16,
+        PARAMFLAG_FOUT = (short)2,
+        PARAMFLAG_FRETVAL = (short)8,
+        PARAMFLAG_NONE = (short)0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct STATDATA {
+        public int connection;
+        public ADVF advf;
+        public FORMATETC formatetc;
+        public IAdviseSink advSink;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct STATSTG {
+        public Guid clsid;
+        public int grfLocksSupported;
+        public int grfMode;
+        public int grfStateBits;
+        public int reserved;
+        public int type;
+        public long cbSize;
+        public FILETIME atime;
+        public FILETIME ctime;
+        public FILETIME mtime;
+        public string pwcsName;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct STGMEDIUM {
+        public IntPtr unionmember;
+        public object pUnkForRelease;
+        public TYMED tymed;
+    }
+    public enum SYSKIND {
+        SYS_MAC = 2,
+        SYS_WIN16 = 0,
+        SYS_WIN32 = 1,
+        SYS_WIN64 = 3,
+    }
+    public enum TYMED {
+        TYMED_ENHMF = 64,
+        TYMED_FILE = 2,
+        TYMED_GDI = 16,
+        TYMED_HGLOBAL = 1,
+        TYMED_ISTORAGE = 8,
+        TYMED_ISTREAM = 4,
+        TYMED_MFPICT = 32,
+        TYMED_NULL = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TYPEATTR {
+        public Guid guid;
+        public short cbAlignment;
+        public short cbSizeVft;
+        public short cFuncs;
+        public short cImplTypes;
+        public short cVars;
+        public short wMajorVerNum;
+        public short wMinorVerNum;
+        public int cbSizeInstance;
+        public int dwReserved;
+        public int lcid;
+        public const int MEMBER_ID_NIL = -1;
+        public int memidConstructor;
+        public int memidDestructor;
+        public IntPtr lpstrSchema;
+        public IDLDESC idldescType;
+        public TYPEDESC tdescAlias;
+        public TYPEFLAGS wTypeFlags;
+        public TYPEKIND typekind;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TYPEDESC {
+        public short vt;
+        public IntPtr lpValue;
+    }
+    public enum TYPEFLAGS : short {
+        TYPEFLAG_FAGGREGATABLE = (short)1024,
+        TYPEFLAG_FAPPOBJECT = (short)1,
+        TYPEFLAG_FCANCREATE = (short)2,
+        TYPEFLAG_FCONTROL = (short)32,
+        TYPEFLAG_FDISPATCHABLE = (short)4096,
+        TYPEFLAG_FDUAL = (short)64,
+        TYPEFLAG_FHIDDEN = (short)16,
+        TYPEFLAG_FLICENSED = (short)4,
+        TYPEFLAG_FNONEXTENSIBLE = (short)128,
+        TYPEFLAG_FOLEAUTOMATION = (short)256,
+        TYPEFLAG_FPREDECLID = (short)8,
+        TYPEFLAG_FPROXY = (short)16384,
+        TYPEFLAG_FREPLACEABLE = (short)2048,
+        TYPEFLAG_FRESTRICTED = (short)512,
+        TYPEFLAG_FREVERSEBIND = (short)8192,
+    }
+    public enum TYPEKIND {
+        TKIND_ALIAS = 6,
+        TKIND_COCLASS = 5,
+        TKIND_DISPATCH = 4,
+        TKIND_ENUM = 0,
+        TKIND_INTERFACE = 3,
+        TKIND_MAX = 8,
+        TKIND_MODULE = 2,
+        TKIND_RECORD = 1,
+        TKIND_UNION = 7,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TYPELIBATTR {
+        public Guid guid;
+        public short wMajorVerNum;
+        public short wMinorVerNum;
+        public int lcid;
+        public LIBFLAGS wLibFlags;
+        public SYSKIND syskind;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct VARDESC {
+        public VARDESC.DESCUNION desc;
+        public short wVarFlags;
+        public int memid;
+        public ELEMDESC elemdescVar;
+        public VARKIND varkind;
+        public string lpstrSchema;
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Explicit)]
+        public struct DESCUNION {
+            [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
+            public int oInst;
+            [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
+            public IntPtr lpvarValue;
+        }
+    }
+    public enum VARFLAGS : short {
+        VARFLAG_FBINDABLE = (short)4,
+        VARFLAG_FDEFAULTBIND = (short)32,
+        VARFLAG_FDEFAULTCOLLELEM = (short)256,
+        VARFLAG_FDISPLAYBIND = (short)16,
+        VARFLAG_FHIDDEN = (short)64,
+        VARFLAG_FIMMEDIATEBIND = (short)4096,
+        VARFLAG_FNONBROWSABLE = (short)1024,
+        VARFLAG_FREADONLY = (short)1,
+        VARFLAG_FREPLACEABLE = (short)2048,
+        VARFLAG_FREQUESTEDIT = (short)8,
+        VARFLAG_FRESTRICTED = (short)128,
+        VARFLAG_FSOURCE = (short)2,
+        VARFLAG_FUIDEFAULT = (short)512,
+    }
+    public enum VARKIND {
+        VAR_CONST = 2,
+        VAR_DISPATCH = 3,
+        VAR_PERINSTANCE = 0,
+        VAR_STATIC = 1,
+    }
+}
```

