# System.Security.Authentication.ExtendedProtection

``` diff
+namespace System.Security.Authentication.ExtendedProtection {
+    public abstract class ChannelBinding : SafeHandle {
+        protected ChannelBinding();
+        protected ChannelBinding(bool ownsHandle);
+        public abstract int Size { get; }
+    }
+    public enum ChannelBindingKind {
+        Endpoint = 26,
+        Unique = 25,
+        Unknown = 0,
+    }
+    public class ExtendedProtectionPolicy {
+        public ExtendedProtectionPolicy(PolicyEnforcement policyEnforcement);
+        public ExtendedProtectionPolicy(PolicyEnforcement policyEnforcement, ChannelBinding customChannelBinding);
+        public ExtendedProtectionPolicy(PolicyEnforcement policyEnforcement, ProtectionScenario protectionScenario, ICollection customServiceNames);
+        public ExtendedProtectionPolicy(PolicyEnforcement policyEnforcement, ProtectionScenario protectionScenario, ServiceNameCollection customServiceNames);
+        public ChannelBinding CustomChannelBinding { get; }
+        public ServiceNameCollection CustomServiceNames { get; }
+        public static bool OSSupportsExtendedProtection { get; }
+        public PolicyEnforcement PolicyEnforcement { get; }
+        public ProtectionScenario ProtectionScenario { get; }
+        public override string ToString();
+    }
+    public enum PolicyEnforcement {
+        Always = 2,
+        Never = 0,
+        WhenSupported = 1,
+    }
+    public enum ProtectionScenario {
+        TransportSelected = 0,
+        TrustedProxy = 1,
+    }
+    public class ServiceNameCollection : ICollection, IEnumerable {
+        public ServiceNameCollection(ICollection items);
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public bool Contains(string searchServiceName);
+        public IEnumerator GetEnumerator();
+        public ServiceNameCollection Merge(IEnumerable serviceNames);
+        public ServiceNameCollection Merge(string serviceName);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+    }
+}
```

