# .NET Core January 2018 Update - January 9, 2018

Microsoft is releasing security advisories for .NET Core and ASP.NET Core. Issues addressed by this update are summarized in the [fixes](#fixes) section below. Details can be found in corresponding announcements in the [.NET Core](https://github.com/dotnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) and [ASP.NET Core](https://github.com/aspnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) repos.

.NET Core 1.0.9 and SDK 1.1.7 are available for download and usage in your environment.

* [Announcement](https://blogs.msdn.microsoft.com/)
* [Getting Started](https://www.microsoft.com/net/core/)
* [Downloads](https://github.com/dotnet/core/blob/master/release-notes/download-archives/2.0.5-download.md)

The .NET Core SDK 1.1.7 includes .NET Core 1.0.9 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 1.1.7, the following command will show that you're running version `1.1.7` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core](https://github.com/dotnet/core/issues/) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 1.0.9 images.

## Azure AppServices

Deployment of this update to Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carfully staged across regions over a period of time. Deployment will begin in the West US 2 and North Central US regions with remaining regions following over a few days.

## Package and Binary updates

The following packages and binaries are updated by the January 2018 update:

### System.Private.Corelib.dll

Microsoft.NETCore.App

### System.Private.ServiceModel

* System.ServiceModel.Primitives
* System.ServiceModel.Http
* System.ServiceModel.NetTcp
* System.ServiceModel.Security
* System.ServiceModel.Duplex

### System.Private.Xml.dll

* System.Xml.ReaderWriter
* System.Xml.XmlDocument
* System.Xml.XmlSerializer
* System.Xml.XPath
* System.Xml.XPath.XDocument

## Fixes

### CVE-2018-0786 - Security Feature Bypass in X509 Certificate Validation

Microsoft is aware of a security vulnerability in the public versions of .NET Core where an attacker could present a certificate that is marked invalid for a specific use, but a component uses it for that purpose. This action disregards the Enhanced Key Usage tagging.

The security update addresses the vulnerability by ensuring that .NET Core components completely validate certificates.

### CVE-2018-0764 - Denial of Service when parsing XML documents

Microsoft is aware of a Denial of Service vulnerability in all public versions of .NET core due to improper processing of XML documents. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET application. A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET core handles XML document processing.