# 1.1 Commits

`git log --no-merges --since release/1.1.0@{2016-05-20} --until release/1.1.0@{2016-11-09} --date=short --format="%h %s" --committer="dotnet-bot" --invert-grep`

## CoreCLR

- [`[43bab9a]`](https://github.com/dotnet/coreclr/commit/43bab9a) Remove email publishing calls The new server's email plugin version has different syntax and the email publishing doesn't work currently anyway.  Will be re-enabled at a future time
- [`[19647a3]`](https://github.com/dotnet/coreclr/commit/19647a3) Make dotnet/coreclr reference corresponding dotnet/corefx branch
- [`[858584f6]`](https://github.com/dotnet/coreclr/commit/858584f6) Cleanup unrequired Arm32 package reference
- [`[a8f253b]`](https://github.com/dotnet/coreclr/commit/a8f253b) Enable change for stabilization
- [`[19e5dd7]`](https://github.com/dotnet/coreclr/commit/19e5dd7) Move JIT perf tests to new infrastructure
- [`[dd0f452]`](https://github.com/dotnet/coreclr/commit/dd0f452) Update performance tests
- [`[6340f35]`](https://github.com/dotnet/coreclr/commit/6340f35) Move benchmarks to use netstandard1.4 instead of netcoreapp1.0 to fix desktop reflection issue
- [`[8d1d348]`](https://github.com/dotnet/coreclr/commit/8d1d348) Add CoreCLR perf test support to Jenkins
- [`[fa02660]`](https://github.com/dotnet/coreclr/commit/fa02660) Consume optimization data during release builds
- [`[6ad9f31]`](https://github.com/dotnet/coreclr/commit/6ad9f31) Add PGO GENPROFILE support to coreclr and clrjit
- [`[c3c71f9]`](https://github.com/dotnet/coreclr/commit/c3c71f9) Port b734fc58b2257593bb8fbb9ecd68654eff483b7c to release branch
- [`[26d4004]`](https://github.com/dotnet/coreclr/commit/26d4004) PR feedback for BinaryReader/Writer buffers
- [`[13ea22b]`](https://github.com/dotnet/coreclr/commit/13ea22b) Add some extra checks to BinaryReader/Writer buffers
- [`[12661af]`](https://github.com/dotnet/coreclr/commit/12661af) Fix passing struct with four floats in registers via reflection (#7716)
- [`[02aab73]`](https://github.com/dotnet/coreclr/commit/02aab73) Simplify versioning of packages.
- [`[1bd0ce6]`](https://github.com/dotnet/coreclr/commit/1bd0ce6) Disable CER code that is causing access violation
- [`[252a234]`](https://github.com/dotnet/coreclr/commit/252a234) Fix lowering's containment analysis.
- [`[af2b909]`](https://github.com/dotnet/coreclr/commit/af2b909) Fix System.Diagnostics.StackTrace version in stack trace helper code (#7383)
- [`[854d074]`](https://github.com/dotnet/coreclr/commit/854d074) Fix OS X build break with AppleClang 8.0.0 (#7292)
- [`[098eb21]`](https://github.com/dotnet/coreclr/commit/098eb21) Remove CoreCLR's dependency on the diasymreader.dll installed as part of the full .NET Framework on Desktop (#7342)
- [`[c47367d]`](https://github.com/dotnet/coreclr/commit/c47367d) Fix Unable to step through Visual Studio remote debugger with coreclr executables on Nano Server (#7317)
- [`[f314216]`](https://github.com/dotnet/coreclr/commit/f314216) Fix 8.3 UNC expansion
- [`[fce679e]`](https://github.com/dotnet/coreclr/commit/fce679e) Fix launch timing issue in dbgshim found in VS. (#7279) (#7281)
- [`[daa579a]`](https://github.com/dotnet/coreclr/commit/daa579a) Create long-named DAC and SOS DLLs for Windows.
- [`[6bc804a]`](https://github.com/dotnet/coreclr/commit/6bc804a) In release/1.1.0, use 1.1.0 buildinfo dependency (#7109)
- [`[8ed5aa4]`](https://github.com/dotnet/coreclr/commit/8ed5aa4) Fix arm64 build break in building packages
- [`[adbba76]`](https://github.com/dotnet/coreclr/commit/adbba76) Update PreRelease label for release/1.1.0 branch
- [`[88fbc55]`](https://github.com/dotnet/coreclr/commit/88fbc55) Exclude smallFrame.sh test for ARM (#7080)
- [`[ef5ceb0]`](https://github.com/dotnet/coreclr/commit/ef5ceb0) Correct the virtual overload of Stream.CopyTo (#7082)
- [`[19346e5]`](https://github.com/dotnet/coreclr/commit/19346e5) Task<T> Exceptions to ThrowHelper (#7076)
- [`[2142296]`](https://github.com/dotnet/coreclr/commit/2142296) Make Stream.CopyTo virtual (#7070)
- [`[0e1c7eb]`](https://github.com/dotnet/coreclr/commit/0e1c7eb) Array<T> exceptions to ThrowHelper (#7059)
- [`[365fab0]`](https://github.com/dotnet/coreclr/commit/365fab0) [Linux][LLDB][GDB/JIT] Add support for lldb 'breakpoint set' for jitted code (#6956)
- [`[527edfc]`](https://github.com/dotnet/coreclr/commit/527edfc) Move genIncRegBy() to codegenclassic.h (#7063)
- [`[b9402ad]`](https://github.com/dotnet/coreclr/commit/b9402ad) [ARM] Remove ARM_HAZARD_AVOIDANCE (#7019)
- [`[e70de80]`](https://github.com/dotnet/coreclr/commit/e70de80) Enable FEATURE_JIT_METHOD_PERF always (even when FEATURE_CORECLR is on). (#7028)
- [`[4aae240]`](https://github.com/dotnet/coreclr/commit/4aae240) Fix GTF_ flag collision
- [`[cea91c3]`](https://github.com/dotnet/coreclr/commit/cea91c3) Add proper support for custom installed llvm tool chain. (#7050)
- [`[237245c]`](https://github.com/dotnet/coreclr/commit/237245c) fix helpers' flag: ULDiv, ULMod can throw Div-by-zero exception (#7052)
- [`[a90f60e]`](https://github.com/dotnet/coreclr/commit/a90f60e) ArraySegment<T> exceptions to ThrowHelper (#7058)
- [`[fc4444c]`](https://github.com/dotnet/coreclr/commit/fc4444c) Exclude two more tests for ARM (#7062)
- [`[e6621d0]`](https://github.com/dotnet/coreclr/commit/e6621d0) Prevent build output contamination while building test overlay
- [`[0a3506e]`](https://github.com/dotnet/coreclr/commit/0a3506e) Allow mapping LCID and culture names mapping for neutral culture (#7049)
- [`[5c32341]`](https://github.com/dotnet/coreclr/commit/5c32341) Improve ThrowHelper (#7048)
- [`[1c5d30e]`](https://github.com/dotnet/coreclr/commit/1c5d30e) Implement FixupPrecode for Arm64
- [`[ee0ea25]`](https://github.com/dotnet/coreclr/commit/ee0ea25) More PR comments
- [`[db7a920]`](https://github.com/dotnet/coreclr/commit/db7a920) Reduce item format allocations in AppendFormat (#4702)
- [`[dc4a830]`](https://github.com/dotnet/coreclr/commit/dc4a830) Add help job
- [`[86b72d1]`](https://github.com/dotnet/coreclr/commit/86b72d1) Restore the change to gtNewBlkOpNode
- [`[882a634]`](https://github.com/dotnet/coreclr/commit/882a634) LTO build: fix perf regression from strict alias violation and incorrect inline assembly (#7018)
- [`[d4c2486]`](https://github.com/dotnet/coreclr/commit/d4c2486) Enabled FunctionEnter/FunctionLeave hooks on ARM (#6939)
- [`[e21aeaf]`](https://github.com/dotnet/coreclr/commit/e21aeaf) More PR Feedback
- [`[dc0bdc8]`](https://github.com/dotnet/coreclr/commit/dc0bdc8) Improve StringBuilder ctor(), ctor(int), and ToString() performance. Consistent changes in other functions. (#7029)
- [`[c9c61a7]`](https://github.com/dotnet/coreclr/commit/c9c61a7) Changing new perf.groovy triggers to be non-default
- [`[f71493a]`](https://github.com/dotnet/coreclr/commit/f71493a) Address PR Feedback
- [`[ad7ae78]`](https://github.com/dotnet/coreclr/commit/ad7ae78) Improve ToUpper/ToLower perf (#7026)
- [`[3b9140c]`](https://github.com/dotnet/coreclr/commit/3b9140c) Make Lazy initialization of TextInfo::m_IsAsciiCasingSameAsInvariant thread safe (#7021)
- [`[4d51ced]`](https://github.com/dotnet/coreclr/commit/4d51ced) Fix format.py
- [`[cbaf046]`](https://github.com/dotnet/coreclr/commit/cbaf046) 1st Class Struct Block Assignments
- [`[bcd4c0c]`](https://github.com/dotnet/coreclr/commit/bcd4c0c) Globalization update from CoreRT - part 2 (#7020)
- [`[a37ec7a]`](https://github.com/dotnet/coreclr/commit/a37ec7a) Revert "Avoid using 'which' for verifying prereqs"
- [`[d33c89d]`](https://github.com/dotnet/coreclr/commit/d33c89d) Pass /p:Platform to msbuild in runtest.cmd.
- [`[060e0c6]`](https://github.com/dotnet/coreclr/commit/060e0c6) GcInfo: Report Struct containing one GcPointer correctly
- [`[dff1a18]`](https://github.com/dotnet/coreclr/commit/dff1a18) Update Unix System.Globalization implementation from CoreRT (#7004)
- [`[c810a11]`](https://github.com/dotnet/coreclr/commit/c810a11) Stop groveling for project.json files when building every test.
- [`[9744854]`](https://github.com/dotnet/coreclr/commit/9744854) Fix funceval of a function returning 16 byte value type. (#6997)
- [`[b73fad3]`](https://github.com/dotnet/coreclr/commit/b73fad3) Avoid using 'which' for verifying prereqs (#6994)
- [`[fd5a96d]`](https://github.com/dotnet/coreclr/commit/fd5a96d) Fix #6893. (#6932)
- [`[5a3b667]`](https://github.com/dotnet/coreclr/commit/5a3b667) Fix the build break
- [`[f952733]`](https://github.com/dotnet/coreclr/commit/f952733) Do not run local var liveness before rationalize.
- [`[0b3c925]`](https://github.com/dotnet/coreclr/commit/0b3c925) Print an error, in DEBUG, if we fail to open the JitFuncInfoLogFile
- [`[f2c09cb]`](https://github.com/dotnet/coreclr/commit/f2c09cb) Clean up test issues files
- [`[66f4808]`](https://github.com/dotnet/coreclr/commit/66f4808) Update coding conventions
- [`[0e57377]`](https://github.com/dotnet/coreclr/commit/0e57377) Add some features help for arm target test
- [`[7774463]`](https://github.com/dotnet/coreclr/commit/7774463) Remove obsolete add/sub NYI
- [`[c06348f]`](https://github.com/dotnet/coreclr/commit/c06348f) Implement DecomposeShift
- [`[3cddcdd]`](https://github.com/dotnet/coreclr/commit/3cddcdd) Remove System.Reflection.AssemblyNameProxy and fix System.Reflection.Pointer constructor
- [`[6dd8f10]`](https://github.com/dotnet/coreclr/commit/6dd8f10) Fix the srcCount for an unused GT_LONG.
- [`[8e2696b]`](https://github.com/dotnet/coreclr/commit/8e2696b) Port String reorganization from CoreRT (#6985)
- [`[31ed010]`](https://github.com/dotnet/coreclr/commit/31ed010) GC update from CoreRT (#6984)
- [`[76b9822]`](https://github.com/dotnet/coreclr/commit/76b9822) Skipped letter in a word (#6991)
- [`[a4c2d83]`](https://github.com/dotnet/coreclr/commit/a4c2d83) Expose missing Global/Encoding APIs in coreclr and remove empty stubs
- [`[1974da8]`](https://github.com/dotnet/coreclr/commit/1974da8) Add openSUSE 42.1 build badge to README.md
- [`[cb24fe3]`](https://github.com/dotnet/coreclr/commit/cb24fe3) Create coreclr perf jobs for Linux.
- [`[3e8b696]`](https://github.com/dotnet/coreclr/commit/3e8b696) Reformat test issues files so they are more easily comparable
- [`[987559e]`](https://github.com/dotnet/coreclr/commit/987559e) Delete non-existing method
- [`[5e9582f]`](https://github.com/dotnet/coreclr/commit/5e9582f) More fixes.
- [`[d7c2f43]`](https://github.com/dotnet/coreclr/commit/d7c2f43) Fixed wrong env vars.
- [`[85e3157]`](https://github.com/dotnet/coreclr/commit/85e3157) Move TailcallVerifyWithPrefix test to "baseline x86" exclusion section
- [`[f4952b4]`](https://github.com/dotnet/coreclr/commit/f4952b4) Revises UMThunkStub unwindable in ARM/Linux (#6788)
- [`[4f60a81]`](https://github.com/dotnet/coreclr/commit/4f60a81) Monitor.TryEnter asm timeout != 0 before spin (#6951)
- [`[97dd6d2]`](https://github.com/dotnet/coreclr/commit/97dd6d2) added GC.GetAllocatedBytesForCurrentThread API
- [`[5f92d1a]`](https://github.com/dotnet/coreclr/commit/5f92d1a) Change dir to make sure the right project.json is used.
- [`[e3ed1aa]`](https://github.com/dotnet/coreclr/commit/e3ed1aa) Add debugging code to find where Microsoft.DotNet.xunit.performance.runner.cli.dll is deployed.
- [`[5aa92e8]`](https://github.com/dotnet/coreclr/commit/5aa92e8) Re-enable stringarr test
- [`[0ed1e51]`](https://github.com/dotnet/coreclr/commit/0ed1e51) Add steps to install xunit performance packages
- [`[5f0cd69]`](https://github.com/dotnet/coreclr/commit/5f0cd69) Add debugging code.
- [`[c040356]`](https://github.com/dotnet/coreclr/commit/c040356) Fix wrong dir, and add debugging code.
- [`[a52e4fd]`](https://github.com/dotnet/coreclr/commit/a52e4fd) Fixed wrong dir.
- [`[cd43ac9]`](https://github.com/dotnet/coreclr/commit/cd43ac9) Enable return address hijacking for arm64. And also fixes a bug in HijackFrame::GCScanRoots
- [`[01b20f7]`](https://github.com/dotnet/coreclr/commit/01b20f7) Re-enable test DevDiv_255263
- [`[9c7329e]`](https://github.com/dotnet/coreclr/commit/9c7329e) 1. Rename the script to the shell type. 2. Added a few lines for debugging.
- [`[ab61a94]`](https://github.com/dotnet/coreclr/commit/ab61a94) Fix file descriptor leak on PAL_IsDebuggerPresent (#6958)
- [`[255cb73]`](https://github.com/dotnet/coreclr/commit/255cb73) Cleanup/optimize some String.Compare overloads, part 2 (#6891)
- [`[5127eef]`](https://github.com/dotnet/coreclr/commit/5127eef) RyuJIT x86: Fix initblk with unrolled loop and constant fill
- [`[264160b]`](https://github.com/dotnet/coreclr/commit/264160b) Fix #4992
- [`[e371f87]`](https://github.com/dotnet/coreclr/commit/e371f87) Fix #6097
- [`[baa357d]`](https://github.com/dotnet/coreclr/commit/baa357d) Add missing link to crossgen doc in glossary
- [`[a90eae1]`](https://github.com/dotnet/coreclr/commit/a90eae1) Allow Fedora 24 to use MSBuild in build.sh
- [`[8ea7bc7]`](https://github.com/dotnet/coreclr/commit/8ea7bc7) Change RyuJIT/x86 GC encoder to handle LSRA flexibility
- [`[e200846]`](https://github.com/dotnet/coreclr/commit/e200846) Script to enable coreclr perf run on Linux.
- [`[f140b1d]`](https://github.com/dotnet/coreclr/commit/f140b1d) Add fedora24 native packages
- [`[eeeae1d]`](https://github.com/dotnet/coreclr/commit/eeeae1d) Enable stress jobs on x86 ryujit
- [`[e9d954b]`](https://github.com/dotnet/coreclr/commit/e9d954b) Fix DevDiv bug 255263
- [`[12f3274]`](https://github.com/dotnet/coreclr/commit/12f3274) fgOptimizeBranch loses bbFlags while duplicating the block #6886
- [`[74ac12b]`](https://github.com/dotnet/coreclr/commit/74ac12b) Implement the IEquatable interfaces on IntPtr and UIntPtr (#6921)
- [`[9caa82a]`](https://github.com/dotnet/coreclr/commit/9caa82a) Make GetHRForException to return e.HResult on non-Windows platforms (#6929)
- [`[aab8db1]`](https://github.com/dotnet/coreclr/commit/aab8db1) Incremental progress addressing #6676
- [`[c7868f2]`](https://github.com/dotnet/coreclr/commit/c7868f2) Move groovy logic to python script
- [`[76048c7]`](https://github.com/dotnet/coreclr/commit/76048c7) Avoid unnecessary indirection in char.ToString (#6903)
- [`[140a7da]`](https://github.com/dotnet/coreclr/commit/140a7da) Add pkgproj's for Ubuntu 16.10
- [`[ab0da4c]`](https://github.com/dotnet/coreclr/commit/ab0da4c) Add pkgproj's for openSUSE 42.1
- [`[ba2deb3]`](https://github.com/dotnet/coreclr/commit/ba2deb3) Revert "ARM-CI : Fix ARM Emulator vm runs out of space"
- [`[a0caf57]`](https://github.com/dotnet/coreclr/commit/a0caf57) ARM-CI : Fix ARM Emulator vm runs out of space (#6910)
- [`[3c6879b]`](https://github.com/dotnet/coreclr/commit/3c6879b) Enable Arm32 Test Build
- [`[24918bf]`](https://github.com/dotnet/coreclr/commit/24918bf) Improve perf of Encoding.GetEncoding(int) (#6907)
- [`[85f59a3]`](https://github.com/dotnet/coreclr/commit/85f59a3) Removed deleted projects, added new projects to solution
- [`[c086627]`](https://github.com/dotnet/coreclr/commit/c086627) Fixed folder names in solution
- [`[b004fab]`](https://github.com/dotnet/coreclr/commit/b004fab) Changes made automatically by Visual Studio
- [`[4f0fbd0]`](https://github.com/dotnet/coreclr/commit/4f0fbd0) Put back Open key signing on the SOS.NETCore assembly. (#6905)
- [`[cace8ca]`](https://github.com/dotnet/coreclr/commit/cace8ca) Add Formatting job
- [`[21c89ff]`](https://github.com/dotnet/coreclr/commit/21c89ff) SemaphoreSlim, fail faster for timeout 0
- [`[503f879]`](https://github.com/dotnet/coreclr/commit/503f879) Expose constructor with argument for safe handle types instead of constructor without argument
- [`[d76df4f]`](https://github.com/dotnet/coreclr/commit/d76df4f) Fix security annotation
- [`[d67f034]`](https://github.com/dotnet/coreclr/commit/d67f034) Cleanup/optimize many string.Compare overloads, part 1 (#6603)
- [`[ff31518]`](https://github.com/dotnet/coreclr/commit/ff31518) Remove idiv from ThreadPoolWorkQueue:Dequeue loop (#6781)
- [`[a12ba46]`](https://github.com/dotnet/coreclr/commit/a12ba46) GcInfo: Don't use slim header for struct-returns
- [`[df50db7]`](https://github.com/dotnet/coreclr/commit/df50db7) Better lazy initialization for Encoding static properties (#6890)
- [`[0da0052]`](https://github.com/dotnet/coreclr/commit/0da0052) Remove extra TypeForward from facade to fix ConfiguredTaskAwaiter (#6899)
- [`[2c38643]`](https://github.com/dotnet/coreclr/commit/2c38643) Fix #3554. (#6880)
- [`[a352d94]`](https://github.com/dotnet/coreclr/commit/a352d94) Add single separator String.Split overloads (#895)
- [`[7d53e9b]`](https://github.com/dotnet/coreclr/commit/7d53e9b) Update build to optionally configure with nmake
- [`[36cf341]`](https://github.com/dotnet/coreclr/commit/36cf341) Disabling test against issue 6553 (#6895)
- [`[7c6f1b7]`](https://github.com/dotnet/coreclr/commit/7c6f1b7) Allow Ubuntu 16.10 to use MSBuild (#6897)
- [`[4071333]`](https://github.com/dotnet/coreclr/commit/4071333) Handle multi-reg PUTARG_STK nodes. (#6870)
- [`[6b56950]`](https://github.com/dotnet/coreclr/commit/6b56950) Some minor changes.
- [`[afcff25]`](https://github.com/dotnet/coreclr/commit/afcff25) Fix full framework build
- [`[53ad9e1]`](https://github.com/dotnet/coreclr/commit/53ad9e1) Remove NYI for helper calls with long return types
- [`[ad7c799]`](https://github.com/dotnet/coreclr/commit/ad7c799) Initial commit to build Win32 Arm CoreCLR
- [`[cacf46f]`](https://github.com/dotnet/coreclr/commit/cacf46f) Module.Name: Avoid unnecessary char[] allocation (#6865)
- [`[d014a8f]`](https://github.com/dotnet/coreclr/commit/d014a8f) DateTimeFormat: Avoid intermediate char[] allocation (#6863)
- [`[bc2bcc0]`](https://github.com/dotnet/coreclr/commit/bc2bcc0) Allow to use clang 3.9 in build.sh (#6888)
- [`[71dd695]`](https://github.com/dotnet/coreclr/commit/71dd695)   Infra changes to unify the  tests to be built against a common project.json.    1. tests\src\Common\test_dependencies\project.json - To consume corefx and other nuget feeds
- [`[5537ed5]`](https://github.com/dotnet/coreclr/commit/5537ed5) Cosmetic changes, removing unnceseary files and entries in project files.     Unifying the way project referring mscorlib facade builds
- [`[ecf7775]`](https://github.com/dotnet/coreclr/commit/ecf7775) Disable downloading xplat binaries as we no longer need to build these packages in razzle. (#6871)
- [`[9fe631c]`](https://github.com/dotnet/coreclr/commit/9fe631c) Fix local var ref counts in IND/STOREIND decomposition
- [`[0d9a44f]`](https://github.com/dotnet/coreclr/commit/0d9a44f) Fix DecomposeStoreInd comments
- [`[ec1e4eb]`](https://github.com/dotnet/coreclr/commit/ec1e4eb) update tests.lst
- [`[0c9a68a]`](https://github.com/dotnet/coreclr/commit/0c9a68a) Moving baseservices tests to use uber project.json
- [`[5135435]`](https://github.com/dotnet/coreclr/commit/5135435) Bulk moving Tests to use uber project.json
- [`[3b8c433]`](https://github.com/dotnet/coreclr/commit/3b8c433) Moving GC tests to use uber project.json
- [`[1153e4c]`](https://github.com/dotnet/coreclr/commit/1153e4c) Enable more code under globalization for netcore This fix is to enable the code handling LCID for Windows in globalization namespace
- [`[d838802]`](https://github.com/dotnet/coreclr/commit/d838802) Add section on how to file security bugs
- [`[9b46970]`](https://github.com/dotnet/coreclr/commit/9b46970) Stop maintaining costs in fgSimpleLowering. (#6872)
- [`[49192f8]`](https://github.com/dotnet/coreclr/commit/49192f8) Reenable tests
- [`[8d46dc0]`](https://github.com/dotnet/coreclr/commit/8d46dc0) Disable node reuse
- [`[69ac976]`](https://github.com/dotnet/coreclr/commit/69ac976) Add missing .gitmirror file. (#6864)
- [`[518057d]`](https://github.com/dotnet/coreclr/commit/518057d) Adding System.TimeZone
- [`[b08d036]`](https://github.com/dotnet/coreclr/commit/b08d036) Fix the ninja build for FC23. (#6861)
- [`[ab703ce]`](https://github.com/dotnet/coreclr/commit/ab703ce) Stop maintaining cost estimates in the RyuJIT backend. (#6849)
- [`[a69d5a8]`](https://github.com/dotnet/coreclr/commit/a69d5a8) Fix ConfigureOnly option in build.sh
- [`[4212e7e]`](https://github.com/dotnet/coreclr/commit/4212e7e) Adding missing members on System Namespace (#6818)
- [`[c3fa47e]`](https://github.com/dotnet/coreclr/commit/c3fa47e) Conditionally disable C4702 "unreachable code" warnings
- [`[a1ee7b8]`](https://github.com/dotnet/coreclr/commit/a1ee7b8) Fix SOS build break from PR #6838. (#6845)
- [`[c940bc8]`](https://github.com/dotnet/coreclr/commit/c940bc8) Adding the missing string function to model.xml (#6694)
- [`[3ad3ea7]`](https://github.com/dotnet/coreclr/commit/3ad3ea7) Fix regex
- [`[f2324b6]`](https://github.com/dotnet/coreclr/commit/f2324b6) Fix superpmi arm64 build
- [`[5339543]`](https://github.com/dotnet/coreclr/commit/5339543) Use the "open" key for strong-name signing SOS.NETCore.dll.
- [`[ced16db]`](https://github.com/dotnet/coreclr/commit/ced16db) Reenable superpmi test for x86
- [`[caaca71]`](https://github.com/dotnet/coreclr/commit/caaca71) Remove fgDebugCheckLinear{Tree,NodeLinks}. (#6842)
- [`[5a63fd8]`](https://github.com/dotnet/coreclr/commit/5a63fd8) Use versions repo tooling from BuildTools.
- [`[cd62a87]`](https://github.com/dotnet/coreclr/commit/cd62a87) Added SuppressIldasmAttribute to mscorlib and model.xml
- [`[d39efa7]`](https://github.com/dotnet/coreclr/commit/d39efa7) Further optimizations for String.Join, String.Concat (#6800)
- [`[400dee4]`](https://github.com/dotnet/coreclr/commit/400dee4) [ARM/Linux] Fix HFA structs
- [`[204108f]`](https://github.com/dotnet/coreclr/commit/204108f) Disable SuperPMI unit test for x86 legacy backend
- [`[627f3a3]`](https://github.com/dotnet/coreclr/commit/627f3a3) SuperPMI: fix ARM build break
- [`[fb470cb]`](https://github.com/dotnet/coreclr/commit/fb470cb) Assert that any node with a non-zero dstCount produces a value. (#6827)
- [`[91cbbc1]`](https://github.com/dotnet/coreclr/commit/91cbbc1) Disable superpmi test for RyuJIT/x86
- [`[9c8beb2]`](https://github.com/dotnet/coreclr/commit/9c8beb2) Fix build break related to LogException requiring non-empty varargs arguments
- [`[fcb97ba]`](https://github.com/dotnet/coreclr/commit/fcb97ba) Fix ARM64 build breakage (#6819)
- [`[f9679ca]`](https://github.com/dotnet/coreclr/commit/f9679ca) Delete CanChangeType from model.xml
- [`[d6753d1]`](https://github.com/dotnet/coreclr/commit/d6753d1) Fix build breaks and warnings in internal build
- [`[22049de]`](https://github.com/dotnet/coreclr/commit/22049de) Fix casing of DaylightTime.cs
- [`[405f7d7]`](https://github.com/dotnet/coreclr/commit/405f7d7) Instead of checking in these python tools, pull them from Nuget package instead.
- [`[7589066]`](https://github.com/dotnet/coreclr/commit/7589066) Create SOS SymbolReader managed project and change SOS to use it. (#6783)
- [`[d85eb92]`](https://github.com/dotnet/coreclr/commit/d85eb92) Open source SuperPMI
- [`[52184be]`](https://github.com/dotnet/coreclr/commit/52184be) Don't inline methods that have tail-prefixed calls.
- [`[349add9]`](https://github.com/dotnet/coreclr/commit/349add9) Use getBootstrapPublishRid function to override __PUBLISH_RID while bringing up new platforms
- [`[31c58c7]`](https://github.com/dotnet/coreclr/commit/31c58c7) Support MSBuild on opensuse.42.1-x64
- [`[579e2d0]`](https://github.com/dotnet/coreclr/commit/579e2d0) Add a run for opensuse 42.1
- [`[e2f9a0f]`](https://github.com/dotnet/coreclr/commit/e2f9a0f) Automate the perf data collection for JIT CodeQuality benchmarks on Windows.
- [`[9748eea]`](https://github.com/dotnet/coreclr/commit/9748eea) Fix dstCount of GT_RETURNTRAP
- [`[1ca8b49]`](https://github.com/dotnet/coreclr/commit/1ca8b49) Fix Arm64 crossgen
- [`[9518103]`](https://github.com/dotnet/coreclr/commit/9518103) Using the public DaylightTime instead of the internal one in  corefx dir for Linux/OSX builds.
- [`[5907289]`](https://github.com/dotnet/coreclr/commit/5907289) Expose MulticastDelegate.GetObjectData method
- [`[d045a69]`](https://github.com/dotnet/coreclr/commit/d045a69) Remove properties which are now defined in buildtools
- [`[3dedd1a]`](https://github.com/dotnet/coreclr/commit/3dedd1a) Don't create dumpling list file unless there are actually dumps.
- [`[6830e52]`](https://github.com/dotnet/coreclr/commit/6830e52) Expose some types deriving from SafeHandle
- [`[6f65f80]`](https://github.com/dotnet/coreclr/commit/6f65f80) Update buildtools to 1.0.26-prerelease-00718-04
- [`[738f93e]`](https://github.com/dotnet/coreclr/commit/738f93e) Implement the proposed design for RyuJIT's LIR. (#6689)
- [`[84854a6]`](https://github.com/dotnet/coreclr/commit/84854a6) Added constructor to System.Version
- [`[00c85b3]`](https://github.com/dotnet/coreclr/commit/00c85b3) Expose missing members of System.Reflection in contract to prep for dotnet/corefx#1053 (#6614)
- [`[827ff19]`](https://github.com/dotnet/coreclr/commit/827ff19) Fix WeakReference in mscorlib ref assembly
- [`[60b9b8d]`](https://github.com/dotnet/coreclr/commit/60b9b8d) Print info from core dumps on OS X using LLDB.
- [`[cccff23]`](https://github.com/dotnet/coreclr/commit/cccff23) Preparatory changes for Blk Ops IR
- [`[fdbe4c2]`](https://github.com/dotnet/coreclr/commit/fdbe4c2) Expose some threading type members
- [`[c69eff4]`](https://github.com/dotnet/coreclr/commit/c69eff4) Enable additional functionality for OS X CI dumps.
- [`[97464a7]`](https://github.com/dotnet/coreclr/commit/97464a7) Remove TypeForwardedFrom attributes for System and System.Core
- [`[3871c8b]`](https://github.com/dotnet/coreclr/commit/3871c8b) Fix serialization of delegates without targets
- [`[f4fdd63]`](https://github.com/dotnet/coreclr/commit/f4fdd63) Fix serialization of several exception types
- [`[c6888ea]`](https://github.com/dotnet/coreclr/commit/c6888ea) An easy fix for #6760 (#6770)
- [`[473d6f1]`](https://github.com/dotnet/coreclr/commit/473d6f1) Due to comdat folding some fcalls are pointing to same code. This fix ensures that these fcall has a unique code address. (#6776)
- [`[3fc9f67]`](https://github.com/dotnet/coreclr/commit/3fc9f67) Restoring the Test Runtime libraries from a single project.json This will ensure the expected version to be present at the runtime
- [`[6ad3d45]`](https://github.com/dotnet/coreclr/commit/6ad3d45) Fix CRWLock ID generation overflow bug
- [`[3c44321]`](https://github.com/dotnet/coreclr/commit/3c44321) Disable tests that timeout for jit32
- [`[bfcd630]`](https://github.com/dotnet/coreclr/commit/bfcd630) Specify packages.builds by default in build-packages command
- [`[a641d3a]`](https://github.com/dotnet/coreclr/commit/a641d3a) Makes FCallMemcpy unwindable (#6753)
- [`[c037777]`](https://github.com/dotnet/coreclr/commit/c037777) Apply correct symbolic name _ARM_ instead of _TARGET_ARM_ (#6756)
- [`[a7bac8b]`](https://github.com/dotnet/coreclr/commit/a7bac8b) printing dumpling url at upload time.
- [`[b6be3a0]`](https://github.com/dotnet/coreclr/commit/b6be3a0) Fix build break from new alignments
- [`[62f246c]`](https://github.com/dotnet/coreclr/commit/62f246c) Adding new generics tests (#6709)
- [`[6e782a6]`](https://github.com/dotnet/coreclr/commit/6e782a6) Add deserialization ctors to mscorlib ref assembly
- [`[91de2ce]`](https://github.com/dotnet/coreclr/commit/91de2ce) Record expr location for opqaue value numbers
- [`[ca04119]`](https://github.com/dotnet/coreclr/commit/ca04119) Arm64 Sos fixes for !verify heap !u !u -gcinfo
- [`[607816f]`](https://github.com/dotnet/coreclr/commit/607816f) update GC shadow heap as part of writebarrier jit helper
- [`[ab1d328]`](https://github.com/dotnet/coreclr/commit/ab1d328) Fix issue https://github.com/dotnet/coreclr/issues/6600
- [`[4176fcc]`](https://github.com/dotnet/coreclr/commit/4176fcc) Add deserialization ctors to model.xml
- [`[a17c5b8]`](https://github.com/dotnet/coreclr/commit/a17c5b8) Port serialization implementation to Unix globalization types
- [`[1998458]`](https://github.com/dotnet/coreclr/commit/1998458) Ensure On* methods are not removed by BclRewriter
- [`[cca188e]`](https://github.com/dotnet/coreclr/commit/cca188e) Restore most serialization implementations in coreclr
- [`[c1d05a8]`](https://github.com/dotnet/coreclr/commit/c1d05a8) Fixup a few contracts
- [`[429b0fd]`](https://github.com/dotnet/coreclr/commit/429b0fd) Update version of S.R.Serialization.Primitives to version 4.1.1
- [`[69d0c32]`](https://github.com/dotnet/coreclr/commit/69d0c32) review fixes
- [`[13d4616]`](https://github.com/dotnet/coreclr/commit/13d4616) In intGCShadow() first reserve memory before committing. VirtualCommit does not accept NULL as input address
- [`[4e3108c]`](https://github.com/dotnet/coreclr/commit/4e3108c) Reformat the JIT sources.
- [`[828c4a1]`](https://github.com/dotnet/coreclr/commit/828c4a1) Massage the code a bit for jit-format w/ Clang 3.8.
- [`[0f44d30]`](https://github.com/dotnet/coreclr/commit/0f44d30) Revert #6686.
- [`[479485f]`](https://github.com/dotnet/coreclr/commit/479485f) Issue: If two threads try to load the same type it can cause clr to hang if the first thread to start the load happens to be a background thread. Background thread would create PendingTypeLoadEntry  and insert it into unresolvedClassHash. Second thread (having normal priority) would block on PendingTypeLoadEntry->m_crst waiting for the background thread to unblock it. After doing partial load of type background thread periodically checks if there are other threads waiting for type to get loaded. In this case it does find a thread waiting so it unblocks thread. However, background thread has not removed PendingTypeLoadEntry  from unresolvedClassHash. This causes the second thread to continue spinning and so not allowing background thread to get any processor cycles to remove PendingTypeLoadEntry  from unresolvedClassHash. This cause app to be seem like it has hung. It is possible that this may not repro on multi-proc machine where the background thread can get scheduled on another processor when second thread continues to spin on another processor.
- [`[7a28511]`](https://github.com/dotnet/coreclr/commit/7a28511) Fix exception filter getter for native frames (#6723)
- [`[a3ea82e]`](https://github.com/dotnet/coreclr/commit/a3ea82e) Fixing priority on tests (making tests P1) (#6706)
- [`[98f0f90]`](https://github.com/dotnet/coreclr/commit/98f0f90) More fixes for unreachable code warnings with older compiler
- [`[85f2c3f]`](https://github.com/dotnet/coreclr/commit/85f2c3f) Disable tests to get jit32 jobs green
- [`[6abfacb]`](https://github.com/dotnet/coreclr/commit/6abfacb) Enable FEATURE_STUBS_AS_IL for ARM/Linux (#6500)
- [`[6b42745]`](https://github.com/dotnet/coreclr/commit/6b42745) Fix unreachable code warnings with MSVC++ 18.10
- [`[3394c21]`](https://github.com/dotnet/coreclr/commit/3394c21) Fix region info test on Debian
- [`[7b44385]`](https://github.com/dotnet/coreclr/commit/7b44385) Update unix test instructions
- [`[596d42e]`](https://github.com/dotnet/coreclr/commit/596d42e) Fix linux test running documentation
- [`[e8e9c46]`](https://github.com/dotnet/coreclr/commit/e8e9c46) Add missing security annotation
- [`[36a2b90]`](https://github.com/dotnet/coreclr/commit/36a2b90) Reformat jit sources with clang-tidy and format
- [`[ab7d6a8]`](https://github.com/dotnet/coreclr/commit/ab7d6a8) Prepare jit source for clang-tidy
- [`[c52e05a]`](https://github.com/dotnet/coreclr/commit/c52e05a) ARM: disable stack unwinding using DWARF (#6700)
- [`[f9e5306]`](https://github.com/dotnet/coreclr/commit/f9e5306) Preserving ResolveCacheElem in X9
- [`[0d42fb7]`](https://github.com/dotnet/coreclr/commit/0d42fb7) Update Arm32 package version reference
- [`[cdc6819]`](https://github.com/dotnet/coreclr/commit/cdc6819) Automate the perf data collection for JIT CodeQuality benchmarks on Windows.
- [`[4750bcb]`](https://github.com/dotnet/coreclr/commit/4750bcb) Propagate known array lengths to more places
- [`[1fcecaf]`](https://github.com/dotnet/coreclr/commit/1fcecaf) ARM64: Fix for ARM64TODO
- [`[dec551a]`](https://github.com/dotnet/coreclr/commit/dec551a) Re-enable creating Tests_Native* log files
- [`[0958f8b]`](https://github.com/dotnet/coreclr/commit/0958f8b) Add StackCrawl reference marker to each of the Assembly.Load implementations.
- [`[9a0f6ec]`](https://github.com/dotnet/coreclr/commit/9a0f6ec) Fix unreachable code in flowgraph
- [`[571b963]`](https://github.com/dotnet/coreclr/commit/571b963) Improve Enum.ToString performance (#6645)
- [`[4ddc41e]`](https://github.com/dotnet/coreclr/commit/4ddc41e) Fix for VCR 190024210 and Win SDK 10.0.14393.0 (#6674)
- [`[a0597da]`](https://github.com/dotnet/coreclr/commit/a0597da) Fix MemoryBarrier
- [`[519dcde]`](https://github.com/dotnet/coreclr/commit/519dcde) Insert MemoryBarrier revert Comthreadpool
- [`[2e0332a]`](https://github.com/dotnet/coreclr/commit/2e0332a) PR feedback
- [`[0093a35]`](https://github.com/dotnet/coreclr/commit/0093a35) TypeSystem generics test cases (#6663)
- [`[cd0d600]`](https://github.com/dotnet/coreclr/commit/cd0d600) Align to reduce false sharing
- [`[b8220e4]`](https://github.com/dotnet/coreclr/commit/b8220e4) Adjust fences and add padding
- [`[a033207]`](https://github.com/dotnet/coreclr/commit/a033207) Reduce false sharing in ManagedPerAppDomainTPCount
- [`[2de9a69]`](https://github.com/dotnet/coreclr/commit/2de9a69) GetCleanCounts to Volatile read on x64
- [`[bfef881]`](https://github.com/dotnet/coreclr/commit/bfef881) WorkerThreadStart volatile read+cmpxchg loop
- [`[4ed1a0c]`](https://github.com/dotnet/coreclr/commit/4ed1a0c) Fix LoadFromAssemblyName to invoke fallback context (analogous to static assembly loads within the context)
- [`[37218ab]`](https://github.com/dotnet/coreclr/commit/37218ab) Update FieldSeq annotations in EarlyProp
- [`[6f645eb]`](https://github.com/dotnet/coreclr/commit/6f645eb) The call to LOG expects a pointer argument, but the actual argument was of class type 'ComCallWrapperPtr'. (#6665)
- [`[3c30aa1]`](https://github.com/dotnet/coreclr/commit/3c30aa1) Work towards objects stack allocation: moved allocation part of newobj-lowering into separate phase
- [`[3961c70]`](https://github.com/dotnet/coreclr/commit/3961c70) Disable few more transparency checks for .net core
- [`[10075dd]`](https://github.com/dotnet/coreclr/commit/10075dd) Fix compiler warnings
- [`[8605725]`](https://github.com/dotnet/coreclr/commit/8605725) Port CS#1596330 from netfxdev1 (bug#119959)
- [`[275aa1a]`](https://github.com/dotnet/coreclr/commit/275aa1a) Refresh mscorlib reference assembly based on what is in S.P.C (#6655)
- [`[6f65020]`](https://github.com/dotnet/coreclr/commit/6f65020) Update package versions to 1.1.0
- [`[21df26e]`](https://github.com/dotnet/coreclr/commit/21df26e) Modify "crossgen -createpdb" to skip loading clrjit.dll (#6607)
- [`[49b8766]`](https://github.com/dotnet/coreclr/commit/49b8766) Fix for missing symbol OnHijackTripThread
- [`[17ced7f]`](https://github.com/dotnet/coreclr/commit/17ced7f) Add Title (so that web searches work better) (#6654)
- [`[deb00ad]`](https://github.com/dotnet/coreclr/commit/deb00ad) Check PAL_VirtualUnwind failure during GC (#6598)
- [`[5976ffa]`](https://github.com/dotnet/coreclr/commit/5976ffa) Don't overwrite crossgen log in build.cmd script (#6639)
- [`[ab6bc52]`](https://github.com/dotnet/coreclr/commit/ab6bc52) Fix compile error (#6641)
- [`[32fe063]`](https://github.com/dotnet/coreclr/commit/32fe063) Decrease writes to local variables in Buffer.MemoryCopy (#6627)
- [`[021a224]`](https://github.com/dotnet/coreclr/commit/021a224) Fix #6517
- [`[8c034fb]`](https://github.com/dotnet/coreclr/commit/8c034fb) Inliner: add a few more observations
- [`[47eec64]`](https://github.com/dotnet/coreclr/commit/47eec64) Null check folding.
- [`[d302e64]`](https://github.com/dotnet/coreclr/commit/d302e64) Implement GcInfo v2 Ref #4379
- [`[0414d77]`](https://github.com/dotnet/coreclr/commit/0414d77) For helper method frame DAC doesn't read register pointers. So set them to NULL to not user "wrong" data.
- [`[cf73aa2]`](https://github.com/dotnet/coreclr/commit/cf73aa2) Remove GTF_REDINDEX_CHECK
- [`[e6b35d4]`](https://github.com/dotnet/coreclr/commit/e6b35d4) Fix typo/comments
- [`[a95820d]`](https://github.com/dotnet/coreclr/commit/a95820d) Fix invalid checks for CONTEXT_XSTATE (#6621)
- [`[1608c2c]`](https://github.com/dotnet/coreclr/commit/1608c2c) Fix Issue 6585: Add offset to struct field arg (#6616)
- [`[077a1ea]`](https://github.com/dotnet/coreclr/commit/077a1ea) Fix misleading comment in codegenlegacy.cpp
- [`[25b8225]`](https://github.com/dotnet/coreclr/commit/25b8225) disable pass/return struct(float, float) using register in 32bit architecture
- [`[ef7ce47]`](https://github.com/dotnet/coreclr/commit/ef7ce47) Clean up some SOS code.
- [`[7115ac4]`](https://github.com/dotnet/coreclr/commit/7115ac4) Cache failure to initialize SymbolReader logic in SOS.
- [`[6b19180]`](https://github.com/dotnet/coreclr/commit/6b19180) Followup work from codereview feedback
- [`[6fe08a8]`](https://github.com/dotnet/coreclr/commit/6fe08a8) Allow inlining when inlinee has `starg`
- [`[70c6851]`](https://github.com/dotnet/coreclr/commit/70c6851) Fix newly introduced typo in Documentation/README
- [`[c71a308]`](https://github.com/dotnet/coreclr/commit/c71a308) Fix warnings in interop tests and disable IsComObject(null) scenario as it is failing in non-Windows
- [`[693e50c]`](https://github.com/dotnet/coreclr/commit/693e50c) Fix link to all BotR chapters in table of contents
- [`[75cf5b7]`](https://github.com/dotnet/coreclr/commit/75cf5b7) Pull Request feedback
- [`[e03a2e3]`](https://github.com/dotnet/coreclr/commit/e03a2e3) Add a table of contents to the book of the runtime
- [`[010f42a]`](https://github.com/dotnet/coreclr/commit/010f42a) Adding support to the following generic dictionary entry slots for R2R: (#6291)
- [`[4008759]`](https://github.com/dotnet/coreclr/commit/4008759) Fix contract violation (violation caused by a copy/paste bug in PR 6200
- [`[85358db]`](https://github.com/dotnet/coreclr/commit/85358db) on fail: create local_dumplings.txt with the url of the uploaded core dump file if dumpling is enabled. After, concatenate all of the local_dumplings.txt in to $(PWD)/dumplings.txt
- [`[da5693e]`](https://github.com/dotnet/coreclr/commit/da5693e) Inliner: gather summary stats and dump to Jit CSV log
- [`[0bb191d]`](https://github.com/dotnet/coreclr/commit/0bb191d) Updating External dependencies to beta-24404-00 (#6601)
- [`[a3f63f8]`](https://github.com/dotnet/coreclr/commit/a3f63f8) Added additional comments to AppendFormatHelper to explain the parsing. (#1261)
- [`[e3c3330]`](https://github.com/dotnet/coreclr/commit/e3c3330) Add a throw/inline benchmark
- [`[e62cc0a]`](https://github.com/dotnet/coreclr/commit/e62cc0a) Do not inline methods that never return
- [`[693fff9]`](https://github.com/dotnet/coreclr/commit/693fff9) Adding Support for FieldDescSlot generic dictionary entries for R2R generic code. (#6200)
- [`[4c4ace1]`](https://github.com/dotnet/coreclr/commit/4c4ace1) Add more interop API into System.Runtime and update mscorlib.cs
- [`[7611127]`](https://github.com/dotnet/coreclr/commit/7611127) Fix for issue 5954 - Assert 'fieldSeq != FieldSeqStore::NotAField()'
- [`[b4c4b91]`](https://github.com/dotnet/coreclr/commit/b4c4b91) Revert "Automate the perf data collection for JIT CodeQuality benchmarks on Windows."
- [`[95a00b2]`](https://github.com/dotnet/coreclr/commit/95a00b2) Update documentation on how to build corefx (#6594)
- [`[ae7efdd]`](https://github.com/dotnet/coreclr/commit/ae7efdd) Automate the perf data collection for JIT CodeQuality benchmarks on Windows.
- [`[2336d41]`](https://github.com/dotnet/coreclr/commit/2336d41) Modify rebuild scenario.
- [`[dc2b355]`](https://github.com/dotnet/coreclr/commit/dc2b355) ARM64: Fix Build Test Break
- [`[84c9ed8]`](https://github.com/dotnet/coreclr/commit/84c9ed8) ARM64: Disable Two Tests
- [`[0504bf7]`](https://github.com/dotnet/coreclr/commit/0504bf7) Expose ThreadPool_UnfairSemaphoreSpinLimit config
- [`[bb8759e]`](https://github.com/dotnet/coreclr/commit/bb8759e) RC2 release used version 4.6.*. However RTM release started to use the default values of 1.0.* by mistake. Revert back to using 4.6 as major & minor version number
- [`[74b2752]`](https://github.com/dotnet/coreclr/commit/74b2752) Less Conservative GtObj
- [`[16c6584]`](https://github.com/dotnet/coreclr/commit/16c6584) Optimize bounds checks with correct assertion set
- [`[3de3ad5]`](https://github.com/dotnet/coreclr/commit/3de3ad5) Update cross-building.md
- [`[f327cbf]`](https://github.com/dotnet/coreclr/commit/f327cbf) Update windows-test-instructions.md
- [`[a0d8423]`](https://github.com/dotnet/coreclr/commit/a0d8423) Update unix-test-instructions.md
- [`[13d8d8f]`](https://github.com/dotnet/coreclr/commit/13d8d8f) Fix build warnings in Vector3Interop test
- [`[d503042]`](https://github.com/dotnet/coreclr/commit/d503042) Swallow exception in gc_heap::fire_etw_allocation_event (#6571)
- [`[03b0a5b]`](https://github.com/dotnet/coreclr/commit/03b0a5b) Update windows-instructions.md
- [`[cf4fb69]`](https://github.com/dotnet/coreclr/commit/cf4fb69) Use absolute paths for specifying projects to build.
- [`[044a6fa]`](https://github.com/dotnet/coreclr/commit/044a6fa) Change to allow WCF more explicit control over channels to mimic an existing manifest.
- [`[6773ee1]`](https://github.com/dotnet/coreclr/commit/6773ee1) Slightly increase throughput of string.Concat(object[]) (#6547)
- [`[5112b2a]`](https://github.com/dotnet/coreclr/commit/5112b2a) ARM64: Fix Build Break
- [`[3208afd]`](https://github.com/dotnet/coreclr/commit/3208afd) Change int return values to BOOL for coreclr delegates (#6551)
- [`[309e00d]`](https://github.com/dotnet/coreclr/commit/309e00d) Rename ZeroFreeMemoryUTF8 to ZeroFreeCoTaskMemUTF8 in ref (#6561)
- [`[22c9f9e]`](https://github.com/dotnet/coreclr/commit/22c9f9e) Documentation: Additional optimization levels for ARM/Linux (#6548)
- [`[8dea67f]`](https://github.com/dotnet/coreclr/commit/8dea67f) Change processing of args in build scripts to keep =.
- [`[b775f22]`](https://github.com/dotnet/coreclr/commit/b775f22) Add /m option for builds.
- [`[8ab671e]`](https://github.com/dotnet/coreclr/commit/8ab671e) Add function headers for new liveness methods.
- [`[41a1d0a]`](https://github.com/dotnet/coreclr/commit/41a1d0a) Replace the LSRA stack with a hash table.
- [`[cf8e79a]`](https://github.com/dotnet/coreclr/commit/cf8e79a) Add ExtraParameters to config.json to enable --.
- [`[bea4564]`](https://github.com/dotnet/coreclr/commit/bea4564) Fix errors in build scripts from run tool update.
- [`[4faa40e]`](https://github.com/dotnet/coreclr/commit/4faa40e) Initialize `doAgain`.
- [`[02ab8f9]`](https://github.com/dotnet/coreclr/commit/02ab8f9) Refactor fgComputeLife.
- [`[12fbe4b]`](https://github.com/dotnet/coreclr/commit/12fbe4b) Update linux-performance-tracing.md
- [`[bec4e1c]`](https://github.com/dotnet/coreclr/commit/bec4e1c) Apply run on recent changes in master.
- [`[9474660]`](https://github.com/dotnet/coreclr/commit/9474660) Respond to PR feedback.
- [`[57efa01]`](https://github.com/dotnet/coreclr/commit/57efa01) Remove clean option from arm script, which deletes the copied test bits in CI.
- [`[1b0c82f]`](https://github.com/dotnet/coreclr/commit/1b0c82f) Grant 777 for run.sh
- [`[f5afe9b]`](https://github.com/dotnet/coreclr/commit/f5afe9b) Use run tool in coreclr dev workflow.
- [`[5b7d8d9]`](https://github.com/dotnet/coreclr/commit/5b7d8d9) adds testhost package
- [`[ca240d9]`](https://github.com/dotnet/coreclr/commit/ca240d9) Fix a build break.
- [`[339823a]`](https://github.com/dotnet/coreclr/commit/339823a) Using full versions, update CoreFX dependencies to beta-24328-05.
- [`[a1fa8c1]`](https://github.com/dotnet/coreclr/commit/a1fa8c1) Massage code for clang-format
- [`[0d6291d]`](https://github.com/dotnet/coreclr/commit/0d6291d) Expose missing members of Array in contract to prep for dotnet/corefx#9998. (#6519)
- [`[e545b22]`](https://github.com/dotnet/coreclr/commit/e545b22) Remove CorUnix::InternalFree.
- [`[7371dea]`](https://github.com/dotnet/coreclr/commit/7371dea) Update how we pass parameters when building CoreFx (#6511)
- [`[002149c]`](https://github.com/dotnet/coreclr/commit/002149c) Also clear CONTEXT_XSTATE if fpregs aren't available.
- [`[1c7531b]`](https://github.com/dotnet/coreclr/commit/1c7531b) Add extended state to RtlRestoreContext
- [`[00190bb]`](https://github.com/dotnet/coreclr/commit/00190bb) Remove useless contract in EventListener
- [`[2eb7d0c]`](https://github.com/dotnet/coreclr/commit/2eb7d0c) Fxing the paths that are resolved relative to a network share
- [`[05b7cb4]`](https://github.com/dotnet/coreclr/commit/05b7cb4) Skip dummy null argument for string constructors under CoreRT ABI (#6498)
- [`[3d47402]`](https://github.com/dotnet/coreclr/commit/3d47402) Fix for build issue #807024, assemble debug helpers for ARM64.
- [`[2d2e766]`](https://github.com/dotnet/coreclr/commit/2d2e766) Enable RefEmitted assemblies to have Fallback LoadContext notion
- [`[f30a8de]`](https://github.com/dotnet/coreclr/commit/f30a8de) Fix a couple of paths related to exception codes. (#6497)
- [`[e4c3163]`](https://github.com/dotnet/coreclr/commit/e4c3163) Add in-memory logging for virtual memory operations.
- [`[ef0aa6a]`](https://github.com/dotnet/coreclr/commit/ef0aa6a) Add errno.h
- [`[37e7654]`](https://github.com/dotnet/coreclr/commit/37e7654) Rename PCMI->pLast and other cleanup of virtual memory code.
- [`[4c4d51c]`](https://github.com/dotnet/coreclr/commit/4c4d51c) Exposed List<T>.ConvertAll
- [`[2d944f9]`](https://github.com/dotnet/coreclr/commit/2d944f9) GC update from CoreRT (#6487)
- [`[856ae89]`](https://github.com/dotnet/coreclr/commit/856ae89) porting changes from .net native to CoreCLR
- [`[2ce817e]`](https://github.com/dotnet/coreclr/commit/2ce817e) Update CrossGen doc for "Unable to load Jit" error
- [`[77e01f5]`](https://github.com/dotnet/coreclr/commit/77e01f5) Do not propagate bad assertions from unreachable blocks
- [`[037cf33]`](https://github.com/dotnet/coreclr/commit/037cf33) Add IObjectReference to mscorlib ref assembly
- [`[a734248]`](https://github.com/dotnet/coreclr/commit/a734248) [SOS][ARM/Linux] Enable clru SOS command (#6477)
- [`[dcd9aae]`](https://github.com/dotnet/coreclr/commit/dcd9aae) Optimize the generic string.Join for length 1 collections (#6463)
- [`[1db5d5a]`](https://github.com/dotnet/coreclr/commit/1db5d5a) Expose SerializationInfo.UpdateValue for corefx
- [`[27e570d]`](https://github.com/dotnet/coreclr/commit/27e570d) Add flag to check re-entrancy of JIT notification
- [`[d03f77f]`](https://github.com/dotnet/coreclr/commit/d03f77f) Add IObjectReference to model.xml
- [`[feb33b9]`](https://github.com/dotnet/coreclr/commit/feb33b9) Enable multireg returns on Arm64
- [`[9d7584d]`](https://github.com/dotnet/coreclr/commit/9d7584d) Use the correct call to get properties, DeclaredProperties does not return properties for a base class
- [`[43e5f18]`](https://github.com/dotnet/coreclr/commit/43e5f18) Rewrite gtIsVtableAccess to avoid assert
- [`[c10b4bf]`](https://github.com/dotnet/coreclr/commit/c10b4bf) Add serialization primitives to mscorlib facade
- [`[7f106c5]`](https://github.com/dotnet/coreclr/commit/7f106c5) Harden stdout at startup
- [`[faa87f0]`](https://github.com/dotnet/coreclr/commit/faa87f0) Addressing arm64 build break due to old compiler
- [`[f1b3fc7]`](https://github.com/dotnet/coreclr/commit/f1b3fc7) Fix copy check condition for native interop test library. (#6468)
- [`[561b64d]`](https://github.com/dotnet/coreclr/commit/561b64d) Linux/ARM: Fix +3000 bus errors of unit-test in case of O2/O3 levels (#6379)
- [`[b881558]`](https://github.com/dotnet/coreclr/commit/b881558) Do not insert gcstress interrupt instruction at call to JIT_RareDisableHelper
- [`[00e3695]`](https://github.com/dotnet/coreclr/commit/00e3695) Arm64: Debugger
- [`[dae88fd]`](https://github.com/dotnet/coreclr/commit/dae88fd) Fix offset to VectorRegister in i386/asmconstants.h.
- [`[a577278]`](https://github.com/dotnet/coreclr/commit/a577278) Update BuildTools to 1.0.26-prerelease-00625-01
- [`[ab744a4]`](https://github.com/dotnet/coreclr/commit/ab744a4) [Documentation] Projects Use licences (#6442)
- [`[0fdb42a]`](https://github.com/dotnet/coreclr/commit/0fdb42a) Fix inlining of '__jit_debug_register_code' on ARM32 release build
- [`[cf9d60e]`](https://github.com/dotnet/coreclr/commit/cf9d60e) Fix up for grabs issues link in contributing workflow doc (#6437)
- [`[fe4ac43]`](https://github.com/dotnet/coreclr/commit/fe4ac43) RyuJIT/x86: implement tailcall via helper
- [`[59f169e]`](https://github.com/dotnet/coreclr/commit/59f169e) Fix #6125 (#6432)
- [`[087e750]`](https://github.com/dotnet/coreclr/commit/087e750) GC update from CoreRT (#6429)
- [`[ac01e27]`](https://github.com/dotnet/coreclr/commit/ac01e27) Add link to https://graphics.stanford.edu/~seander/bithacks.html#ZeroInWord (#6430)
- [`[6d74076]`](https://github.com/dotnet/coreclr/commit/6d74076) The call to printf expects a string argument, but the actual argument was of class type 'PathString'. (#6422)
- [`[f6494de]`](https://github.com/dotnet/coreclr/commit/f6494de) Update mscorlib facade to use the rewritten S.P.CoreLib
- [`[7b47c77]`](https://github.com/dotnet/coreclr/commit/7b47c77) GetGcInfo(): Add a missing contract declaration
- [`[999353c]`](https://github.com/dotnet/coreclr/commit/999353c) Exposing ISerializable implementation in System.DateTime
- [`[519d7d6]`](https://github.com/dotnet/coreclr/commit/519d7d6) Create CONTRIBUTING.md (#6386)
- [`[c567999]`](https://github.com/dotnet/coreclr/commit/c567999) Set hr to S_OK instead of returning S_OK
- [`[d3f5a70]`](https://github.com/dotnet/coreclr/commit/d3f5a70) ARM-CI : Check a device is already mounted while mounting a device. (#6377)
- [`[177d1d2]`](https://github.com/dotnet/coreclr/commit/177d1d2) Fix ildasm fail due missing GetInfoForMethod managed method
- [`[6919d9f]`](https://github.com/dotnet/coreclr/commit/6919d9f) Use LLVM headers for generation ELF and Dwarf files
- [`[c8f12d0]`](https://github.com/dotnet/coreclr/commit/c8f12d0) Change 'Extract' -> 'GetValue' to prevent memory leaks
- [`[2f99c8c]`](https://github.com/dotnet/coreclr/commit/2f99c8c) Use NewArrayHolder instead of raw pointers
- [`[1a0a5c8]`](https://github.com/dotnet/coreclr/commit/1a0a5c8) Fix indentation in cmake file
- [`[8bce159]`](https://github.com/dotnet/coreclr/commit/8bce159) Fix after review: * Remove unneeded whitespace changes * Extract code related with managed delegate to separate header * Remove unneded files and defines from cmake files
- [`[24066e1]`](https://github.com/dotnet/coreclr/commit/24066e1) Create coreclr delegate inside coreclr_initialize
- [`[d2fe1f2]`](https://github.com/dotnet/coreclr/commit/d2fe1f2) Add GDB JIT support for source line debug information.
- [`[6ffcfee]`](https://github.com/dotnet/coreclr/commit/6ffcfee) Fix build break when FEATURE_SERIALIZATION defined
- [`[f1b03b6]`](https://github.com/dotnet/coreclr/commit/f1b03b6) Jit: fix issues with optMethodFlags
- [`[9585fc2]`](https://github.com/dotnet/coreclr/commit/9585fc2) Save and restore ymm registers in signal handlers.
- [`[f740931]`](https://github.com/dotnet/coreclr/commit/f740931) Fix minor error in runtest help.
- [`[63dd009]`](https://github.com/dotnet/coreclr/commit/63dd009) Fix lexicographical compares of numeric values.
- [`[ece6cb3]`](https://github.com/dotnet/coreclr/commit/ece6cb3) Change verbatim  ELF.h and Dwarf.h LLVM headers to be able to build in CoreCLR + add license header (#6389)
- [`[da5b94e]`](https://github.com/dotnet/coreclr/commit/da5b94e) [SOS][Linux] Fix incorrect processing 'setclrpath' command with portable PDB reader (#6358)
- [`[3b5550f]`](https://github.com/dotnet/coreclr/commit/3b5550f) Refactor GC background thread creation (#6384)
- [`[bfe11c1]`](https://github.com/dotnet/coreclr/commit/bfe11c1) Add ELF.h and Dwarf.h from LLVM for gdbjit feature implementation. (#6383)
- [`[e95a6e8]`](https://github.com/dotnet/coreclr/commit/e95a6e8) ifdef out CodeAccessPermission demand used in SerializationInfo on CoreCLR
- [`[ecb2d02]`](https://github.com/dotnet/coreclr/commit/ecb2d02) ARM64: Reenable email notification
- [`[292d4ea]`](https://github.com/dotnet/coreclr/commit/292d4ea) Expose serialization primitives from System.Private.Corelib
- [`[d1697c6]`](https://github.com/dotnet/coreclr/commit/d1697c6) Remove DBG GcInfo encoder/decoder (#6374)
- [`[4ba6e74]`](https://github.com/dotnet/coreclr/commit/4ba6e74) Documentation: Add additional terminologies in the glossary.md (#6372)
- [`[7c218f9]`](https://github.com/dotnet/coreclr/commit/7c218f9) More verbose logging for arm32 umount
- [`[f915aeb]`](https://github.com/dotnet/coreclr/commit/f915aeb) GCInfo: Support versioning.
- [`[32a020e]`](https://github.com/dotnet/coreclr/commit/32a020e) Remove include of <utility> from seh.cpp (#6359)
- [`[8cdcdf1]`](https://github.com/dotnet/coreclr/commit/8cdcdf1) Fix is_blittable partial specializations (#6357)
- [`[45cff61]`](https://github.com/dotnet/coreclr/commit/45cff61) Fix bug: inlinee did not copy inlinee bbFlags to caller bbFlags.
- [`[e0d4def]`](https://github.com/dotnet/coreclr/commit/e0d4def) Add the proposal for embedded statement removal.
- [`[c4ac0d9]`](https://github.com/dotnet/coreclr/commit/c4ac0d9) More Struct-related Refactorings
- [`[c2a64e9]`](https://github.com/dotnet/coreclr/commit/c2a64e9) Move RegionNames out of #ifs
- [`[0a817e0]`](https://github.com/dotnet/coreclr/commit/0a817e0) Support for reg optional tree temps.
- [`[f6116a5]`](https://github.com/dotnet/coreclr/commit/f6116a5) Enable automatic updating of package versions in test project.json files
- [`[c110738]`](https://github.com/dotnet/coreclr/commit/c110738) Incorrect quoting around regex string Strings requiring inline replacement need double quotes
- [`[243e7c4]`](https://github.com/dotnet/coreclr/commit/243e7c4) Fix silent bad codegen in signed comparison
- [`[f3111f4]`](https://github.com/dotnet/coreclr/commit/f3111f4) Revert "Revert: Pull crash dump links"
- [`[b37e6fc]`](https://github.com/dotnet/coreclr/commit/b37e6fc) ARM64: Enable Function Fragment
- [`[03250d3]`](https://github.com/dotnet/coreclr/commit/03250d3) Make PAL_SEHException smaller (#6267)
- [`[6dca838]`](https://github.com/dotnet/coreclr/commit/6dca838) Fix if statement to ignore Ubuntu codename if BuildArch is arm-softfp
- [`[f331712]`](https://github.com/dotnet/coreclr/commit/f331712) Fix mistyped instruction in linux-instructions.md (#6332)
- [`[9d86bc6]`](https://github.com/dotnet/coreclr/commit/9d86bc6) Fix for CoreCLR 6269 - Trigger formal binding if domain-wide cache does not have entry for an assembly in custom load context. (#6335)
- [`[fcb84d7]`](https://github.com/dotnet/coreclr/commit/fcb84d7) Revert: Pull crash dump links
- [`[1ff9f6b]`](https://github.com/dotnet/coreclr/commit/1ff9f6b) Remove duplicate code from string.GetHashCode (#4696)
- [`[266108a]`](https://github.com/dotnet/coreclr/commit/266108a) Improve performance, drastically reduce misfires for new string(char*) on 64-bit (#6125)
- [`[719c34f]`](https://github.com/dotnet/coreclr/commit/719c34f) Better performance for string.CompareOrdinalHelper (#6119)
- [`[0e71867]`](https://github.com/dotnet/coreclr/commit/0e71867) Stop building targetingPack package on non-windows
- [`[d82f1b9]`](https://github.com/dotnet/coreclr/commit/d82f1b9) Re-enable two tests testing GC.GetGeneration(System.WeakReference) that has now been exposed
- [`[16d0757]`](https://github.com/dotnet/coreclr/commit/16d0757) Inliner: improve arg observations
- [`[7fc5cb7]`](https://github.com/dotnet/coreclr/commit/7fc5cb7) Pull crash dump links Pulls crash dump links from dumplings.txt in the workspace into the build report
- [`[f0a72f0]`](https://github.com/dotnet/coreclr/commit/f0a72f0) Make coreclr buildable on 32bit Windows 10. (#6316)
- [`[b306172]`](https://github.com/dotnet/coreclr/commit/b306172) Fix self-process identification for FreeBSD (#6314)
- [`[2206c1b]`](https://github.com/dotnet/coreclr/commit/2206c1b) Decompose GT_IND for x86
- [`[bbf1d3e]`](https://github.com/dotnet/coreclr/commit/bbf1d3e) Fix package build in build-packages.sh to use dotnet instead of corerun
- [`[88bebd8]`](https://github.com/dotnet/coreclr/commit/88bebd8) Fix libc path for macOS El Capitan (#6302)
- [`[4a13a02]`](https://github.com/dotnet/coreclr/commit/4a13a02) Add to model.xml several members we wish to expose in the FX (#6310)
- [`[e977438]`](https://github.com/dotnet/coreclr/commit/e977438) Add Lazy<T>(T value) constructor (#6304)
- [`[0105a94]`](https://github.com/dotnet/coreclr/commit/0105a94) ARM64: Temporarrily disable email notification
- [`[4ec1a49]`](https://github.com/dotnet/coreclr/commit/4ec1a49) Provide guidance for common build-failure scenario. (#6164)
- [`[3ec09b8]`](https://github.com/dotnet/coreclr/commit/3ec09b8) Add ICloneable back to several globalization types on Unix (#6307)
- [`[91eb031]`](https://github.com/dotnet/coreclr/commit/91eb031) Minimize buffer allocations in Stream.CopyTo for seekable streams (#4540)
- [`[5524e2b]`](https://github.com/dotnet/coreclr/commit/5524e2b) Revert "Less conservative gt obj"
- [`[bdfce9e]`](https://github.com/dotnet/coreclr/commit/bdfce9e) GC update from CoreRT (#6305)
- [`[1351cd9]`](https://github.com/dotnet/coreclr/commit/1351cd9) fix small typos
- [`[10af6af]`](https://github.com/dotnet/coreclr/commit/10af6af) Inliner: capture profit model estimate during replay
- [`[6d1cd7f]`](https://github.com/dotnet/coreclr/commit/6d1cd7f) Add VS Code local settings folder to gitignore
- [`[2b70df5]`](https://github.com/dotnet/coreclr/commit/2b70df5) Stop chmoding nonexistant corerun file in Tools dir
- [`[0ed4e67]`](https://github.com/dotnet/coreclr/commit/0ed4e67) ARM64: Cross-Target Jit
- [`[f063377]`](https://github.com/dotnet/coreclr/commit/f063377) Remove assert validating intrinsic expansion on mustExpand
- [`[68d5832]`](https://github.com/dotnet/coreclr/commit/68d5832) Remove unnecessary copies for stack struct argument except:
- [`[a23208e]`](https://github.com/dotnet/coreclr/commit/a23208e) Update to latest version of buildtools
- [`[7a516a2]`](https://github.com/dotnet/coreclr/commit/7a516a2) Clean up localloc implementation; improve AMD64 codegen for initialized locallocs
- [`[39fbf97]`](https://github.com/dotnet/coreclr/commit/39fbf97) The sort for CSE size optimization should be different from the execution optimization
- [`[11f6a0d]`](https://github.com/dotnet/coreclr/commit/11f6a0d) Introduce XOR swap to legacy codegen for ARM32
- [`[3c27708]`](https://github.com/dotnet/coreclr/commit/3c27708) docs: Add building coreclr for emulator
- [`[0a8cae7]`](https://github.com/dotnet/coreclr/commit/0a8cae7) Make StubHelpers::ProcessByrefValidationList NOTHROW (#6258)
- [`[fc728f2]`](https://github.com/dotnet/coreclr/commit/fc728f2) Add #if FEATURE_SERIALIZATION around non-functional [Serializable]
- [`[340f1b0]`](https://github.com/dotnet/coreclr/commit/340f1b0) Conditionally compile EnvironmentAugments.cs for coreclr
- [`[18ad6e5]`](https://github.com/dotnet/coreclr/commit/18ad6e5) Add EnvironmentAugments to coreclr
- [`[b68469c]`](https://github.com/dotnet/coreclr/commit/b68469c) Implement localloc for RyuJIT/x86
- [`[29aa1e0]`](https://github.com/dotnet/coreclr/commit/29aa1e0) Fix #4177: RyuJIT/x86 NYI related to lvaArgType()
- [`[921e962]`](https://github.com/dotnet/coreclr/commit/921e962) ARM64:Similar to arm, in order to preserve volatile semantics MemoryBarrier instructions needs to be inserted. Otherwise writes to memory locations can be re-ordered. For eg. In function leave_spin_lock() we set holding_thread to -1 and then set pSpinLock->lock to -1. Without memorybarrier it is possible for different threads to see pSpinLock->lock new value of -1 and old value of holding_thread. This causes assertion pSpinLock->holding_thread == (Thread*)-1 in function enter_spin_lock() to fire
- [`[c89c893]`](https://github.com/dotnet/coreclr/commit/c89c893) build the TargetingPack package as part of build-packages scripts
- [`[0730720]`](https://github.com/dotnet/coreclr/commit/0730720) Stop BclRewriter from trimming serializable metadata
- [`[c30ee38]`](https://github.com/dotnet/coreclr/commit/c30ee38) Remove RenameUpdatedVars.
- [`[ba66eea]`](https://github.com/dotnet/coreclr/commit/ba66eea) [ARM-softfp/Linux] Get precise type for pointer-size struct
- [`[6333489]`](https://github.com/dotnet/coreclr/commit/6333489) Add back some surface area to thinned corelib
- [`[25b38ff]`](https://github.com/dotnet/coreclr/commit/25b38ff) Arm64: remove gcstress_fail tag from certain tests in tests.lst
- [`[2de2e19]`](https://github.com/dotnet/coreclr/commit/2de2e19) Suppress Interactive Shell when running PS
- [`[969f1cd]`](https://github.com/dotnet/coreclr/commit/969f1cd) Add a comment at the use of RewriteTopLevelComma.
- [`[06ee8cd]`](https://github.com/dotnet/coreclr/commit/06ee8cd) Inliner: Update data collection by targeting a single inline
- [`[9f60b6c]`](https://github.com/dotnet/coreclr/commit/9f60b6c) Refactor top-level comma rewriting.
- [`[43c102e]`](https://github.com/dotnet/coreclr/commit/43c102e) Fixed race condition in setting dd_new_allocation
- [`[adb2188]`](https://github.com/dotnet/coreclr/commit/adb2188) active exception regression fix (#6117)
- [`[39703ca]`](https://github.com/dotnet/coreclr/commit/39703ca) Fix !PrintException (pe) -lines bug where line number/source info is not being displayed. (#6241)
- [`[3e9d463]`](https://github.com/dotnet/coreclr/commit/3e9d463) Expose missing members of Array to prep for dotnet/corefx#9998.  (#6230)
- [`[de4f885]`](https://github.com/dotnet/coreclr/commit/de4f885) ARM64: In GetDelegateTarget a portion of the _WIN64 code was under _TARGET_AMD64_ whereas at other places (like NDirectStubLinker::DoNDirect & InlinedCallFrame::HasFunction ) related code is under _WIN64. Make the code in GetDelegateTarget to be in sync with other functions and remove ifdef _TARGET_ADM64_. Without this change for arm64 InlinedCallFrame::m_datum stores unmanaged target pointer but StackWalker assumes it to be a NDirectMethodDesc and tries to dereference it and crashes.
- [`[3a89fda]`](https://github.com/dotnet/coreclr/commit/3a89fda) Fix exceptions in GC wave 2 (#6220)
- [`[cdb8a21]`](https://github.com/dotnet/coreclr/commit/cdb8a21) Implement GT_NEG decomposition
- [`[6530924]`](https://github.com/dotnet/coreclr/commit/6530924) Refactor and cleanup work for passing and returning struct types
- [`[d506aec]`](https://github.com/dotnet/coreclr/commit/d506aec) Remove dead code in Rationalize.
- [`[f5a6a10]`](https://github.com/dotnet/coreclr/commit/f5a6a10) Fix a misleading typo in comment
- [`[372b593]`](https://github.com/dotnet/coreclr/commit/372b593) Avoid repeated virtual method calls in List.Contains (#6212)
- [`[0e5227d]`](https://github.com/dotnet/coreclr/commit/0e5227d) Refactor RyuJIT/x86 long decomposition code
- [`[7e6a05e]`](https://github.com/dotnet/coreclr/commit/7e6a05e) Inliner: add depth check to ModelPolicy
- [`[ff2700a]`](https://github.com/dotnet/coreclr/commit/ff2700a) Inliner: updates to ModelPolicy
- [`[57b3450]`](https://github.com/dotnet/coreclr/commit/57b3450) Fix exceptions in GC (#6192)
- [`[0299f94]`](https://github.com/dotnet/coreclr/commit/0299f94) Add new scenario to code coverage job
- [`[ef6ad57]`](https://github.com/dotnet/coreclr/commit/ef6ad57) Fix SOS bpmd for windows
- [`[a8896b3]`](https://github.com/dotnet/coreclr/commit/a8896b3) Fix some typos in comments
- [`[587690d]`](https://github.com/dotnet/coreclr/commit/587690d) Fixing the build break/unsigned to signed warning. This checkin onbehalf of Tijoytk
- [`[aaef75a]`](https://github.com/dotnet/coreclr/commit/aaef75a) Optimize use of a reg-optional lclVar that is marked for both reload and spillAfter.
- [`[64ab292]`](https://github.com/dotnet/coreclr/commit/64ab292) Update contributor guidelines (#6183)
- [`[96b978c]`](https://github.com/dotnet/coreclr/commit/96b978c) ARM-CI: Add tests to CI script
- [`[38c683c]`](https://github.com/dotnet/coreclr/commit/38c683c) Resolve Python2.7 when executable is not called 'python'.
- [`[3c2ac22]`](https://github.com/dotnet/coreclr/commit/3c2ac22) Fix for #5877: pre-spill just the floating arguments
- [`[5cd4213]`](https://github.com/dotnet/coreclr/commit/5cd4213) Fix RyuJIT/x86 fgMorphMultiregStructArg NYI
- [`[8d51b63]`](https://github.com/dotnet/coreclr/commit/8d51b63) MarshalAs(UnManaged.ByValArray) overflow. For non-blittable embedded array in structs we ignored the SizeConst and wrote past the buffer when number of elementsin the arrayis greater than SizeConst.Fix is to truncate the array at SizeConst MarshalAs(UnManaged.ByValTStr) Very subtle case when the SizeConst == Number of bytes required to marshal , we write the null one past the buffer.This happens only on  machine with non-english (multi-byte) locale as default. Fix is to check the number of bytes required and truncate the correctly leaving space for the terminating null.
- [`[81003fb]`](https://github.com/dotnet/coreclr/commit/81003fb) ARM64: Enable Daily Job for GcStress0x3
- [`[a73353e]`](https://github.com/dotnet/coreclr/commit/a73353e) Avoid box allocation in Encoding.EncodingName (#6142)
- [`[00d943c]`](https://github.com/dotnet/coreclr/commit/00d943c) Revert sign.builds so that arm64 bins can be signed
- [`[cc23275]`](https://github.com/dotnet/coreclr/commit/cc23275) Code review feedback.
- [`[81fc669]`](https://github.com/dotnet/coreclr/commit/81fc669) ARM64: Test Update for GcStress0x3
- [`[ebbff97]`](https://github.com/dotnet/coreclr/commit/ebbff97) Avoid heap allocating in char.ConvertFromUtf32 (#6141)
- [`[de7eaa7]`](https://github.com/dotnet/coreclr/commit/de7eaa7) Convert SymbolType.m_format to be a string (#6133)
- [`[62482f5]`](https://github.com/dotnet/coreclr/commit/62482f5) Avoid box allocation in DateTimeFormat.FormatCustomized (#6147)
- [`[953d383]`](https://github.com/dotnet/coreclr/commit/953d383) Avoid box allocation in TypeBuilder.DefineDataHelper (#6148)
- [`[e6ca607]`](https://github.com/dotnet/coreclr/commit/e6ca607) Avoid box allocation in ActivityTracker (#6149)
- [`[245ea79]`](https://github.com/dotnet/coreclr/commit/245ea79) make all public properties of DebuggableAttribute visible outside mscorlib (#6153)
- [`[6d78d32]`](https://github.com/dotnet/coreclr/commit/6d78d32) Add testsRunningInsideARM.txt
- [`[179e304]`](https://github.com/dotnet/coreclr/commit/179e304) Specify StringComparison.Ordinal in System.Diagnostics.Tracing
- [`[14ae2d5]`](https://github.com/dotnet/coreclr/commit/14ae2d5) Do not clean tests folder when skiptests option is used along with clean
- [`[1eede1b]`](https://github.com/dotnet/coreclr/commit/1eede1b) Avoid string concat array allocation in ActivityTracker
- [`[74870fac]`](https://github.com/dotnet/coreclr/commit/74870fac) Fix incremental build problem for cross-components
- [`[17aebd8]`](https://github.com/dotnet/coreclr/commit/17aebd8) Fix incorrect RunBenchmarks help text
- [`[77f1603]`](https://github.com/dotnet/coreclr/commit/77f1603) Introduce GT_ADD_LO and GT_SUB_LO
- [`[ce4950e]`](https://github.com/dotnet/coreclr/commit/ce4950e) Fix syntax error in sign.builds
- [`[c1b65bd]`](https://github.com/dotnet/coreclr/commit/c1b65bd) Fix LLDB search order
- [`[f638167]`](https://github.com/dotnet/coreclr/commit/f638167) Named mutex: Use flock instead of pthread process-shared mutex in some more cases
- [`[0881ab8]`](https://github.com/dotnet/coreclr/commit/0881ab8) only use config on coreclr
- [`[467f06d]`](https://github.com/dotnet/coreclr/commit/467f06d) Remove TODO on throwing exception
- [`[12ea758]`](https://github.com/dotnet/coreclr/commit/12ea758) More Blk Op Refactoring
- [`[a64020c]`](https://github.com/dotnet/coreclr/commit/a64020c) Move the SecuritySafeCritical attributes to EncodingForwarder
- [`[a8cdb48]`](https://github.com/dotnet/coreclr/commit/a8cdb48) Better performance for MulticastDelegate.Equals (#6113)
- [`[ad40ed6]`](https://github.com/dotnet/coreclr/commit/ad40ed6) One of the flags MAP_SHARED or MAP_PRIVATE has to be specified. MAP_PRIVATE seems to fit here. (#6089)
- [`[a4192dc]`](https://github.com/dotnet/coreclr/commit/a4192dc) Add note on UTF8Encoding.GetByteCount to EncodingForwarder
- [`[4fd1bfe]`](https://github.com/dotnet/coreclr/commit/4fd1bfe) Fix CoreFX test failures
- [`[1f9cd67]`](https://github.com/dotnet/coreclr/commit/1f9cd67) [UTF8Encoding] Remove unncessary comments
- [`[e1818e6]`](https://github.com/dotnet/coreclr/commit/e1818e6) [UTF7Encoding] Remove unncessary comments
- [`[ad1ad35]`](https://github.com/dotnet/coreclr/commit/ad1ad35) [UTF32Encoding] Remove unncessary comments
- [`[f09b521]`](https://github.com/dotnet/coreclr/commit/f09b521) [UnicodeEncoding] Remove unncessary comments
- [`[95ff597]`](https://github.com/dotnet/coreclr/commit/95ff597) [EncodingNLS] Remove unncessary comments
- [`[77fa0fb]`](https://github.com/dotnet/coreclr/commit/77fa0fb) [ASCIIEncoding] Remove unncessary comments
- [`[372fcd3]`](https://github.com/dotnet/coreclr/commit/372fcd3) Use EncodingForwarder for GetString(byte[], int, int)
- [`[ab47c22]`](https://github.com/dotnet/coreclr/commit/ab47c22) Use EncodingForwarder for GetChars(byte*, int, char*, int)
- [`[860434d]`](https://github.com/dotnet/coreclr/commit/860434d) Use EncodingForwarder for GetChars(byte[], int, int, char[], int)
- [`[f83ecbe]`](https://github.com/dotnet/coreclr/commit/f83ecbe) Use EncodingForwarder for GetCharCount(byte*, int)
- [`[6de8ede]`](https://github.com/dotnet/coreclr/commit/6de8ede) Use EncodingForwarder for GetCharCount(byte[], int, int)
- [`[7c771b8]`](https://github.com/dotnet/coreclr/commit/7c771b8) Use EncodingForwarder for GetBytes(char*, int, byte*, int)
- [`[0889431]`](https://github.com/dotnet/coreclr/commit/0889431) Use EncodingForwarder for GetBytes(char[], int, int, byte[], int)
- [`[fa55fd7]`](https://github.com/dotnet/coreclr/commit/fa55fd7) Use EncodingForwarder for GetBytes(string, int, int, byte[], int)
- [`[56c687e]`](https://github.com/dotnet/coreclr/commit/56c687e) Use EncodingForwarder for GetByteCount(char*, int)
- [`[9668b5f]`](https://github.com/dotnet/coreclr/commit/9668b5f) Rename the chars parameter in a comment
- [`[e614790]`](https://github.com/dotnet/coreclr/commit/e614790) Use EncodingForwarder for GetByteCount(string)
- [`[ebfc3ce]`](https://github.com/dotnet/coreclr/commit/ebfc3ce) Use EncodingForwarder for GetByteCount(char[], int, int)
- [`[a1e785d]`](https://github.com/dotnet/coreclr/commit/a1e785d) Short-circuit on the count, not the array length, in common Encoding methods (#6108)
- [`[56c4258]`](https://github.com/dotnet/coreclr/commit/56c4258) Address div/mod CR feedback
- [`[d088712]`](https://github.com/dotnet/coreclr/commit/d088712) Added 2 configs for Server GC
- [`[0ce4dda]`](https://github.com/dotnet/coreclr/commit/0ce4dda) Less Conservative GtObj
- [`[6f8f215]`](https://github.com/dotnet/coreclr/commit/6f8f215) Allow uncontained GT_LONG nodes
- [`[29499d1]`](https://github.com/dotnet/coreclr/commit/29499d1) Improve the dump for inline return expressions
- [`[74db9d7]`](https://github.com/dotnet/coreclr/commit/74db9d7) Add information on x86 EH to CLR ABI
- [`[52d7750]`](https://github.com/dotnet/coreclr/commit/52d7750) Remove VIRTUALOwnedRegion.
- [`[d92b629]`](https://github.com/dotnet/coreclr/commit/d92b629) Consider spilled lcl var as contained memory operands for codegen purpose.
- [`[239856a]`](https://github.com/dotnet/coreclr/commit/239856a) RyuJIT/x86: add support for EH
- [`[30720bc]`](https://github.com/dotnet/coreclr/commit/30720bc) Fixed build breaks related to perf counter code on desktop. perf counters are only enabled on desktop.
- [`[e1946b9]`](https://github.com/dotnet/coreclr/commit/e1946b9) Revert Pinvoke ILStub calli signature for desktop clr
- [`[a4a3df7]`](https://github.com/dotnet/coreclr/commit/a4a3df7) do all coreclr copying BEFORE building
- [`[597e160]`](https://github.com/dotnet/coreclr/commit/597e160) FIX #6074 : cannot find exception handler on arm (#6088)
- [`[fa2ff58]`](https://github.com/dotnet/coreclr/commit/fa2ff58) GC ETW fixes. The code for getting data for ETW and perf counter was written by different folks and was very intertwined. For full CLR we always have both defined but for coreclr perf counters are not enabled so some things for ETW were just 0. Need to make sure when one is not defined the rest are still getting the data they need.
- [`[7487889]`](https://github.com/dotnet/coreclr/commit/7487889) Fix the hang in the debugger tests repo on OS X. (#6079)
- [`[aeb0d3b]`](https://github.com/dotnet/coreclr/commit/aeb0d3b) Upload CI dumps to dumpling.
- [`[1e14234]`](https://github.com/dotnet/coreclr/commit/1e14234) ARM64: Enable GCStress0x3 Private Job
- [`[b6199d2]`](https://github.com/dotnet/coreclr/commit/b6199d2) Use HTML publisher for code coverage reports in CI
- [`[73ec3f5]`](https://github.com/dotnet/coreclr/commit/73ec3f5) Inliner: make ModelPolicy available in release builds
- [`[a26d86b]`](https://github.com/dotnet/coreclr/commit/a26d86b) Remove GTF_DEAD.
- [`[a29cdf2]`](https://github.com/dotnet/coreclr/commit/a29cdf2) Remove misplaced call to genUnspillRegIfNeeded
- [`[60dcd3b]`](https://github.com/dotnet/coreclr/commit/60dcd3b) [SOS] [Linux] Initial support of reading source and line number by native offset (#6010)
- [`[24a53c5]`](https://github.com/dotnet/coreclr/commit/24a53c5) Fix undefined locals in desktop test builds. (#6073)
- [`[3793a92]`](https://github.com/dotnet/coreclr/commit/3793a92) Remove MMAP_DOESNOT_ALLOW_REMAP.
- [`[6ac3bee]`](https://github.com/dotnet/coreclr/commit/6ac3bee) Clean up ReserveVirtualMemory.
- [`[b49523e]`](https://github.com/dotnet/coreclr/commit/b49523e) ARM64: Set timeout per scenario
- [`[0806922]`](https://github.com/dotnet/coreclr/commit/0806922) Archive the right artifacts in coverage build
- [`[fc8205c]`](https://github.com/dotnet/coreclr/commit/fc8205c) Only sign non-arm64 binaries
- [`[1472efc]`](https://github.com/dotnet/coreclr/commit/1472efc) Split the lvIsMultiRegArgOrRet into two bits
- [`[b624185]`](https://github.com/dotnet/coreclr/commit/b624185) Disable tests that timeout under gcstress
- [`[6410ab9]`](https://github.com/dotnet/coreclr/commit/6410ab9) Have the jit capture the SuperPMI method index for use in correlating outputs from different runs.
- [`[6c41702]`](https://github.com/dotnet/coreclr/commit/6c41702) Fix building on desktop bug #234633. (#6045)
- [`[07e9b4d]`](https://github.com/dotnet/coreclr/commit/07e9b4d) ARM64: Enable a gcstress private job
- [`[899e9ef]`](https://github.com/dotnet/coreclr/commit/899e9ef) Relase build only for ilasm round trip tests in CI
- [`[13e41af]`](https://github.com/dotnet/coreclr/commit/13e41af) Remove unittests that contain undefined behaviour
- [`[2ef00fa]`](https://github.com/dotnet/coreclr/commit/2ef00fa) Display the build platform and architecture in the JitDump
- [`[3887b98]`](https://github.com/dotnet/coreclr/commit/3887b98) Archive coverage reports from the right place
- [`[bbb24f9]`](https://github.com/dotnet/coreclr/commit/bbb24f9) Fix path to BOTR GC section in gc.cpp (#6039)
- [`[ff5bebf]`](https://github.com/dotnet/coreclr/commit/ff5bebf) Fix platform logic in symbol stripping code.
- [`[bbb2189]`](https://github.com/dotnet/coreclr/commit/bbb2189) update arm64 tests.lst
- [`[d415a00]`](https://github.com/dotnet/coreclr/commit/d415a00) Address P/Invoke inlining code review feedback and cleanup
- [`[6d5ef67]`](https://github.com/dotnet/coreclr/commit/6d5ef67) Fix Pinvoke IL Stubs to emit correct return type in signature of calli instruction
- [`[ad4a583]`](https://github.com/dotnet/coreclr/commit/ad4a583) Do not enable the verbose Jit Dump during the inlining decision phase.
- [`[d27ce13]`](https://github.com/dotnet/coreclr/commit/d27ce13) Fix issue #5642
- [`[56ab756]`](https://github.com/dotnet/coreclr/commit/56ab756) Fix Windows context to Unix context translation on AMD64 (#6027)
- [`[d46d422]`](https://github.com/dotnet/coreclr/commit/d46d422) Build coreclr as part of flow job in coverage jobs
- [`[32e8325]`](https://github.com/dotnet/coreclr/commit/32e8325) Fix default optimization setting for System.Private.CoreLib
- [`[6983352]`](https://github.com/dotnet/coreclr/commit/6983352) Package native Arm64 crossgen as well.
- [`[95a5425]`](https://github.com/dotnet/coreclr/commit/95a5425) Fix 'unicode/uchar.h' file not found (#6009)
- [`[5acbced]`](https://github.com/dotnet/coreclr/commit/5acbced) Move intermediate file into intermediate dir (#5981)
- [`[2a6be7e]`](https://github.com/dotnet/coreclr/commit/2a6be7e) Remove one GCSimulator tests that takes way too long
- [`[e73cb10]`](https://github.com/dotnet/coreclr/commit/e73cb10) Address PR feedback.
- [`[1b35c0a]`](https://github.com/dotnet/coreclr/commit/1b35c0a) Fix three SIMD-related bugs.
- [`[4f847a8]`](https://github.com/dotnet/coreclr/commit/4f847a8) Add `GTF_DEBUG_NONE`.
- [`[0f43161]`](https://github.com/dotnet/coreclr/commit/0f43161) Rename files under src/mscorlib/corefx/System/Globalization to match CoreRT (#6005)
- [`[1a6fc45]`](https://github.com/dotnet/coreclr/commit/1a6fc45) ARM-CI: Improve readability of the ARM CI script
- [`[46de96c]`](https://github.com/dotnet/coreclr/commit/46de96c) Copy gtDebugFlags where necessary.
- [`[db472c4]`](https://github.com/dotnet/coreclr/commit/db472c4) Add parameter names to exception.
- [`[da1cfa3]`](https://github.com/dotnet/coreclr/commit/da1cfa3) Switch from literal parameter names to nameof
- [`[6ed517a]`](https://github.com/dotnet/coreclr/commit/6ed517a) Refactor debug-only GenTree flags.
- [`[9ff3d83]`](https://github.com/dotnet/coreclr/commit/9ff3d83) Change to Generate nuget packages for Windows Arm64 builds.
- [`[66f12f8]`](https://github.com/dotnet/coreclr/commit/66f12f8) Use libc.so as default libc name (#5990)
- [`[7f24c64]`](https://github.com/dotnet/coreclr/commit/7f24c64) Changes to ReturnTypeDesc support more than two return registers
- [`[81b2abb]`](https://github.com/dotnet/coreclr/commit/81b2abb) Fix for issue 5639
- [`[78ea6cd]`](https://github.com/dotnet/coreclr/commit/78ea6cd) Update supported profiler APIs
- [`[1ba04a0]`](https://github.com/dotnet/coreclr/commit/1ba04a0) ARM64: Fix Small Operation For optOptimizeBools
- [`[9a6a40d]`](https://github.com/dotnet/coreclr/commit/9a6a40d) Fix SBCG in value-numbering constant assertprop
- [`[496615c]`](https://github.com/dotnet/coreclr/commit/496615c) ARM64: Fix StackLimit
- [`[422f37e]`](https://github.com/dotnet/coreclr/commit/422f37e) Fix typo to apply mac build workaround only on OSX (#5988)
- [`[27e0e14]`](https://github.com/dotnet/coreclr/commit/27e0e14) Fix Issue #5542 (#5827)
- [`[99c0410]`](https://github.com/dotnet/coreclr/commit/99c0410) Use BIT64 define for 64-bit specific code. (#5987)
- [`[8393105]`](https://github.com/dotnet/coreclr/commit/8393105) Update CoreCLR & JIT package versions
- [`[bb40099]`](https://github.com/dotnet/coreclr/commit/bb40099) ARM-CI: Prevent creation of job for Checked configuration
- [`[b5ab114]`](https://github.com/dotnet/coreclr/commit/b5ab114) [SOS][Linux] Support of reading local variables from portable PDB (#5897)
- [`[7f4d9ea]`](https://github.com/dotnet/coreclr/commit/7f4d9ea) Undo accidental change
- [`[1082b25]`](https://github.com/dotnet/coreclr/commit/1082b25) Add missing contracts
- [`[3a4d5f8]`](https://github.com/dotnet/coreclr/commit/3a4d5f8) Seperate the ubuntu-arm build and emulator build
- [`[e0787c6]`](https://github.com/dotnet/coreclr/commit/e0787c6) Add braces to avoid operator priority confusion (#5964)
- [`[082a175]`](https://github.com/dotnet/coreclr/commit/082a175) Support for updating a nonStandard arg in-place the ArrayStack when it is modified by fgMorphTree
- [`[aeda72a]`](https://github.com/dotnet/coreclr/commit/aeda72a) Refactor TreeNodeInfoInit(): extract lots of functions
- [`[8dacb95]`](https://github.com/dotnet/coreclr/commit/8dacb95) Add AOT placeholder files to the JIT package.
- [`[46d9787]`](https://github.com/dotnet/coreclr/commit/46d9787) Fix GC profiling on arm-softfp (#5952)
- [`[93e0d1a]`](https://github.com/dotnet/coreclr/commit/93e0d1a) Move R2R JitStress jobs into the jitstress folder with the others.
- [`[9b8c43f]`](https://github.com/dotnet/coreclr/commit/9b8c43f) Fix build break in internal build
- [`[3417df6]`](https://github.com/dotnet/coreclr/commit/3417df6) Revert "ARM-CI: Prevent creation of job for Checked configuration"
- [`[8fd7bf0]`](https://github.com/dotnet/coreclr/commit/8fd7bf0) Make check-definitions compatible with Python 3.
- [`[3c7ecfe]`](https://github.com/dotnet/coreclr/commit/3c7ecfe) Enable RyuJIT/x86 PInvoke lowering
- [`[50dd30e]`](https://github.com/dotnet/coreclr/commit/50dd30e) Enable out-of-proc unwinding on ARM (#5946)
- [`[9ae38dd]`](https://github.com/dotnet/coreclr/commit/9ae38dd) Scripts: verify compiler definitions of native and managed (#4675)
- [`[4dcadad]`](https://github.com/dotnet/coreclr/commit/4dcadad) ARM-CI: Prevent creation of job for Checked configuration
- [`[0dbc3f6]`](https://github.com/dotnet/coreclr/commit/0dbc3f6) Build the GC as part of its own CMake target (#5932)
- [`[e86ea35]`](https://github.com/dotnet/coreclr/commit/e86ea35) ARM-CI: Make the Linux ARM emulator check automatic
- [`[8553814]`](https://github.com/dotnet/coreclr/commit/8553814) ARM-CI: Resolving typo in result path
- [`[0e87c6c]`](https://github.com/dotnet/coreclr/commit/0e87c6c) ARM-CI: Change result archiving from emulated to cross build
- [`[a16ef2f]`](https://github.com/dotnet/coreclr/commit/a16ef2f) Change the Arm64 fixed return buffer argument to be handled as a non-standard argument
- [`[faeb5bc]`](https://github.com/dotnet/coreclr/commit/faeb5bc) Pass --build-id=sha1 to linker explicitly
- [`[4e0cd4e]`](https://github.com/dotnet/coreclr/commit/4e0cd4e) Introduce the method fullIntArgRegMask()
- [`[550b9c5]`](https://github.com/dotnet/coreclr/commit/550b9c5) enable GCWhere on PAL and fixed a bug in 859307b where it's missing a function in Linux
- [`[f65ea62]`](https://github.com/dotnet/coreclr/commit/f65ea62) Fix test runner batch file to provide correct TPA path
- [`[56fa3e7]`](https://github.com/dotnet/coreclr/commit/56fa3e7) ARM-CI: Use CI cross build script in emulator
- [`[cacee58]`](https://github.com/dotnet/coreclr/commit/cacee58) Fix for Arm64 crossgen break
- [`[898080b]`](https://github.com/dotnet/coreclr/commit/898080b) Clean up PInvoke lowering
- [`[9237cec]`](https://github.com/dotnet/coreclr/commit/9237cec) Enable GT_CALL with long ret types for x86 RyuJIT
- [`[58c043d]`](https://github.com/dotnet/coreclr/commit/58c043d) Add regression test
- [`[d11bc58]`](https://github.com/dotnet/coreclr/commit/d11bc58) ARM64: Skip CompareExchangeTClass Test
- [`[374d74b]`](https://github.com/dotnet/coreclr/commit/374d74b) Fix syntax error in x86_jit32_issues.targets
- [`[f877851]`](https://github.com/dotnet/coreclr/commit/f877851) Run all tests under server GC
- [`[c95923e]`](https://github.com/dotnet/coreclr/commit/c95923e) [SOS] [Linux] Fix incorrect symbol loading from portable pdb (#5896)
- [`[f7c5984]`](https://github.com/dotnet/coreclr/commit/f7c5984) Generate symbols packages for Windows CoreCLR binaries. (#5902)
- [`[b193390]`](https://github.com/dotnet/coreclr/commit/b193390) Fix statement insertion point in GT_STORE_LCL_VAR decomposition
- [`[c925873]`](https://github.com/dotnet/coreclr/commit/c925873) Disable a test case till issue #5501 is fixed
- [`[babfca8]`](https://github.com/dotnet/coreclr/commit/babfca8) Optimize integer div/mod by const power of 2 in lowering
- [`[4286b40]`](https://github.com/dotnet/coreclr/commit/4286b40) Add tests for integer div/mod by const
- [`[7952dcf]`](https://github.com/dotnet/coreclr/commit/7952dcf) Clean up fgMorphArgs
- [`[cc85a5c]`](https://github.com/dotnet/coreclr/commit/cc85a5c) Add Code of Conduct details to README.md
- [`[5783a07]`](https://github.com/dotnet/coreclr/commit/5783a07) fix build break on ARM caused by f1889 (#5914)
- [`[3651e5f]`](https://github.com/dotnet/coreclr/commit/3651e5f) Cleanup hardware exception handling (#5916)
- [`[f1889a7]`](https://github.com/dotnet/coreclr/commit/f1889a7) Fix for Remorph of a call with nonstandard args
- [`[00bfc20]`](https://github.com/dotnet/coreclr/commit/00bfc20) Fixing build break on x86 and arm.
- [`[ce86b74]`](https://github.com/dotnet/coreclr/commit/ce86b74) added a note about the reason why we ignore failures from tests in the stress run infrastructure
- [`[361d469]`](https://github.com/dotnet/coreclr/commit/361d469) Move all JIT stress jobs into a sub directory on CI
- [`[3136907]`](https://github.com/dotnet/coreclr/commit/3136907) Archive entire obj directory
- [`[ce39651]`](https://github.com/dotnet/coreclr/commit/ce39651) Arm64:return buffer arg should be passed in x8
- [`[b9f5ae8]`](https://github.com/dotnet/coreclr/commit/b9f5ae8) Generic dictionary minor performance improvement and simplification for R2R (#5690)
- [`[95ff086]`](https://github.com/dotnet/coreclr/commit/95ff086) Obey GTF_REVERSE_OPS in fgWalkTreePost.
- [`[7f886f0]`](https://github.com/dotnet/coreclr/commit/7f886f0) Set b14364 as gcstress incompat
- [`[151e16c]`](https://github.com/dotnet/coreclr/commit/151e16c) Up the default timeout for GCStress
- [`[3ddcd85]`](https://github.com/dotnet/coreclr/commit/3ddcd85) Fix for generic unboxing stub with x8 return buffer argument
- [`[af7598e]`](https://github.com/dotnet/coreclr/commit/af7598e) Update Prerelease version to Beta and increment patch version.
- [`[6a4e02a]`](https://github.com/dotnet/coreclr/commit/6a4e02a) We need to have seg_mapping_table aligned on its natural alignement (ptr size). When it's not aligned, aside from the perf problem, we also have a functional problem when an address that's not on a heap segment is passed - we could read an intermediate value which would cause an AV. If the address is on a heap segment it means we are guaranteed to read a ptr size atomically. This only affects functions like IsHeapPointer which can be run when EE is not suspended.
- [`[ffac9c4]`](https://github.com/dotnet/coreclr/commit/ffac9c4) Enable building only native test components
- [`[972af95]`](https://github.com/dotnet/coreclr/commit/972af95) Initial changes to group JIT stress jobs into a sub directory on CI
- [`[27e1cdf]`](https://github.com/dotnet/coreclr/commit/27e1cdf) Fix race condition in Loader regression 523654 test
- [`[e42ea29]`](https://github.com/dotnet/coreclr/commit/e42ea29) Set coredump_filter to include shared library code.
- [`[f5f41ae]`](https://github.com/dotnet/coreclr/commit/f5f41ae) Update Linux tracing instructions for Docker containers.
- [`[dedf88f]`](https://github.com/dotnet/coreclr/commit/dedf88f) Switch to double-quotes for interpolated string
- [`[4a3ab68]`](https://github.com/dotnet/coreclr/commit/4a3ab68) Fix EventSource deserializing of byte[]s
- [`[60de14e]`](https://github.com/dotnet/coreclr/commit/60de14e) Added links to CoreCLR issues, small formatting fix
- [`[878cd5d]`](https://github.com/dotnet/coreclr/commit/878cd5d) Fix GC background thread start in OOM (#5840)
- [`[bc3533f]`](https://github.com/dotnet/coreclr/commit/bc3533f) Disable buffering on jitstdout.
- [`[780400f]`](https://github.com/dotnet/coreclr/commit/780400f) Decomposing 64-bit storeind instruction to 32-bit storeind instructions
- [`[4144d4c]`](https://github.com/dotnet/coreclr/commit/4144d4c) Fix source/line info in unhandled exceptions (#5874)
- [`[5546991]`](https://github.com/dotnet/coreclr/commit/5546991) Remove the corner cases from sscanf test (#5873)
- [`[734f981]`](https://github.com/dotnet/coreclr/commit/734f981) Update GC from CoreRT (#5859)
- [`[b1988c8]`](https://github.com/dotnet/coreclr/commit/b1988c8) JIT: standardize on bool for return type of GenTree OperIs methods
- [`[839e5ab]`](https://github.com/dotnet/coreclr/commit/839e5ab) Remove dead code in notifyexternals
- [`[1ad32ce]`](https://github.com/dotnet/coreclr/commit/1ad32ce) Enable core dump generation in CI test jobs
- [`[9a153fb]`](https://github.com/dotnet/coreclr/commit/9a153fb) ARM64: Fix GC hole for Multi-Reg Struct
- [`[b202782]`](https://github.com/dotnet/coreclr/commit/b202782) Add option to runtest.sh to enable limited dump generation.
- [`[0809be0]`](https://github.com/dotnet/coreclr/commit/0809be0) Fix for issue 5795
- [`[06f902a]`](https://github.com/dotnet/coreclr/commit/06f902a) JIT: Cleanup code in and around fgFindJumpTargets
- [`[8f606f3]`](https://github.com/dotnet/coreclr/commit/8f606f3) Fix full framework build break
- [`[4d0f26a]`](https://github.com/dotnet/coreclr/commit/4d0f26a) Changes to update TFS packages post 1.0
- [`[c335d79]`](https://github.com/dotnet/coreclr/commit/c335d79) Add missing check to allow assembly bound using the Resolving event to be used during static binding scenario
- [`[6ea3580]`](https://github.com/dotnet/coreclr/commit/6ea3580) Use LEAF_END_MARKED instead of LEAF_END for ARM64 debugbreak.S (#5850)
- [`[897fe09]`](https://github.com/dotnet/coreclr/commit/897fe09) Use Use LEAF_END_MARKED instead of LEAF_END for various functions (#5849)
- [`[1df2061]`](https://github.com/dotnet/coreclr/commit/1df2061) Use LEAF_END_MARKED instead of LEAF_END for DBG_DebugBreak (#5847)
- [`[173e56e]`](https://github.com/dotnet/coreclr/commit/173e56e) ARM-CI: Create mount path if not already present
- [`[32c9ea5]`](https://github.com/dotnet/coreclr/commit/32c9ea5) Fix arm64 build break
- [`[8964be3]`](https://github.com/dotnet/coreclr/commit/8964be3) Fix GC test batch script skip conditions that were behaving unexpectedly
- [`[9360831]`](https://github.com/dotnet/coreclr/commit/9360831) Disable GCStress=C periodic triggers for OSX
- [`[54dd349]`](https://github.com/dotnet/coreclr/commit/54dd349) Fix error when passing msbuild args to build.cmd/buildtest.cmd
- [`[d3371a4]`](https://github.com/dotnet/coreclr/commit/d3371a4) Mark Volatile methods with NonVersionable attribute (#5830)
- [`[bbf48b9]`](https://github.com/dotnet/coreclr/commit/bbf48b9) Fix some typos in setup-runtime-dependencies.cmd
- [`[49c2eec]`](https://github.com/dotnet/coreclr/commit/49c2eec) ARM64: Fix WriteBarrier
- [`[aaf5e7d]`](https://github.com/dotnet/coreclr/commit/aaf5e7d) Remove end labels from regular asm procs on Unix (#5777)
- [`[0aed7c9]`](https://github.com/dotnet/coreclr/commit/0aed7c9) Remove set -x from tests/setup-runtime-dependencies.sh.
- [`[987536a]`](https://github.com/dotnet/coreclr/commit/987536a) Fixes for two JIT helpers that should not use the x8 RetBuf argument on ARM64
- [`[e071b69]`](https://github.com/dotnet/coreclr/commit/e071b69) Update crossgen strings for coreclr coverage tests
- [`[1b34b72]`](https://github.com/dotnet/coreclr/commit/1b34b72) Inliner: simple performance tests
- [`[93a9d70]`](https://github.com/dotnet/coreclr/commit/93a9d70) Fix exception stacktrace when ulimit is hit OSX. (#5802)
- [`[f03d7f5]`](https://github.com/dotnet/coreclr/commit/f03d7f5) Remove AMD64 code from legacy code path
- [`[b3b183e]`](https://github.com/dotnet/coreclr/commit/b3b183e) Update SpecializeComparer for enums (#5805)
- [`[bc273bb]`](https://github.com/dotnet/coreclr/commit/bc273bb) Fix sos.DumpIL on LP64 systems with s/long/LONG/g (#5810)
- [`[845d348]`](https://github.com/dotnet/coreclr/commit/845d348) Remove useless gtSetFlags calls
- [`[d33d62e]`](https://github.com/dotnet/coreclr/commit/d33d62e) Modify CrossGen test script to work around cmd.exe bug
- [`[859307b]`](https://github.com/dotnet/coreclr/commit/859307b) Initial support of breakpoint setting by source file + line on Linux using portable pdb reader (#5688)
- [`[3b2ce83]`](https://github.com/dotnet/coreclr/commit/3b2ce83) [ARM64/Linux] Fix `error: index must be an integer in range.`
- [`[c8cbe2a]`](https://github.com/dotnet/coreclr/commit/c8cbe2a) Need to filter addresses not in the heap range in the NextObj verification function.
- [`[f1aeb18]`](https://github.com/dotnet/coreclr/commit/f1aeb18) My last fix of checking whether the runtime was suspended was incomplete. I needed to check at the 3 other places. Before the software write watch implementation, this check was in the write barrier code itself and was doing the right thing. So I am just using the same thing (ie, IsGCThread) to check whether the runtime is suspended.
- [`[9b01b5f]`](https://github.com/dotnet/coreclr/commit/9b01b5f) Fix full framework build break
- [`[8442c3e]`](https://github.com/dotnet/coreclr/commit/8442c3e) Remove unecessary coverage arg passed to coreclr test run
- [`[453b4e9]`](https://github.com/dotnet/coreclr/commit/453b4e9) Add missing inttypes header for musl-libc (#5729)
- [`[45c827a]`](https://github.com/dotnet/coreclr/commit/45c827a) Fix incorrect buffer limits in Module.FullyQualifiedName QCall (#5753)
- [`[ca511a4]`](https://github.com/dotnet/coreclr/commit/ca511a4) Remove extra quote from runtest arg in coverage job
- [`[c93aaa4]`](https://github.com/dotnet/coreclr/commit/c93aaa4) Fix bracket spacing in runtest script
- [`[8975060]`](https://github.com/dotnet/coreclr/commit/8975060) ARM64: Fix a GC hole for Indirect Branch
- [`[11a5971]`](https://github.com/dotnet/coreclr/commit/11a5971) Link libintl in case of Alpine (#5731)
- [`[c74d309]`](https://github.com/dotnet/coreclr/commit/c74d309) ARM-CI: Convert Linux ARM emulator CI check to cross build (fixes PR #5680)
- [`[7f7d827]`](https://github.com/dotnet/coreclr/commit/7f7d827) Refactor MethodTable::ContainsStackPtr (#5754)
- [`[a3676dd]`](https://github.com/dotnet/coreclr/commit/a3676dd) Fix PAL executable allocator locking (#5770)
- [`[bf7c58c]`](https://github.com/dotnet/coreclr/commit/bf7c58c) Revert "ARM-CI: Convert Linux ARM emulator CI check to cross build"
- [`[ea38b37]`](https://github.com/dotnet/coreclr/commit/ea38b37) Update coverage test to have correct configuration for coreFX tests
- [`[e31c326]`](https://github.com/dotnet/coreclr/commit/e31c326) Delete bad assert (#5757)
- [`[ac9b335]`](https://github.com/dotnet/coreclr/commit/ac9b335) Delete unnecessary cruft from internal mscorlib reference assembly (#5756)
- [`[f522b50]`](https://github.com/dotnet/coreclr/commit/f522b50) Pass --long-gc and --gcsimulator to long GC and GCSimulator CI jobs, respectively
- [`[616afb6]`](https://github.com/dotnet/coreclr/commit/616afb6) Keep mutex alive to avoid race condition in openmutexpos4 test
- [`[f6cd99c]`](https://github.com/dotnet/coreclr/commit/f6cd99c) Specialize Comparer<T> for enums to avoid boxing (#5503)
- [`[de69718]`](https://github.com/dotnet/coreclr/commit/de69718) Partial revert "Fix problem with virtual memory commit in OOM scenario on Linux (#5609)" (#5744)
- [`[63d9a2e]`](https://github.com/dotnet/coreclr/commit/63d9a2e) Undo StompWriteBarrierResize reordering (#5740)
- [`[af687f4]`](https://github.com/dotnet/coreclr/commit/af687f4) Add check for gnu/lib-names.h (#5727)
- [`[d85c856]`](https://github.com/dotnet/coreclr/commit/d85c856) Check for unavailable cache-size macro (#5728)
- [`[b0d17dc]`](https://github.com/dotnet/coreclr/commit/b0d17dc) Correct comment (#5738)
- [`[7261cf7]`](https://github.com/dotnet/coreclr/commit/7261cf7) Typedef __ptrace_request for musl-libc (#5730)
- [`[0eafec3]`](https://github.com/dotnet/coreclr/commit/0eafec3) Add check for sys/sysctl.h (#5726)
- [`[5938c8d]`](https://github.com/dotnet/coreclr/commit/5938c8d) Add Profiling APIs that fail on non-Windows OS
- [`[e266aff]`](https://github.com/dotnet/coreclr/commit/e266aff) Do not use fragile native image content when generating R2R images (#5715)
- [`[c265ae3]`](https://github.com/dotnet/coreclr/commit/c265ae3) Updates tryrun.cmake for ARM / ARM (softfp) (#5673)
- [`[59e0c0e]`](https://github.com/dotnet/coreclr/commit/59e0c0e) JapaneseCalendar: Use Registry.LocalMachine instead of RegistryKey.GetBaseKey(RegistryKey.HKEY_LOCAL_MACHINE) (#5725)
- [`[0af0ffb]`](https://github.com/dotnet/coreclr/commit/0af0ffb) Remove obsolete Registry.DynData field from System.Private.CoreLib (#5724)
- [`[8770667]`](https://github.com/dotnet/coreclr/commit/8770667) ARM-CI: Convert Linux ARM emulator CI check to cross build
- [`[9af15d3]`](https://github.com/dotnet/coreclr/commit/9af15d3) Remove non-generic Stack from System.Private.CoreLib (#5703)
- [`[91037ac]`](https://github.com/dotnet/coreclr/commit/91037ac) Fix rethrow of managed exception from native code (#5697)
- [`[237e9da]`](https://github.com/dotnet/coreclr/commit/237e9da) Fix for GC hole when using software write watch
- [`[0fa31cc]`](https://github.com/dotnet/coreclr/commit/0fa31cc) Default to latest behavior when a TFM is not specified
- [`[7352879]`](https://github.com/dotnet/coreclr/commit/7352879) Fixes AV in sos for arm64
- [`[6d198f8]`](https://github.com/dotnet/coreclr/commit/6d198f8) Modify Crypto benchmark so it uses a fixed random seed
- [`[e072217]`](https://github.com/dotnet/coreclr/commit/e072217) ARM64: Another Tests.lst Update for R2R
- [`[cd82273]`](https://github.com/dotnet/coreclr/commit/cd82273) Remove need for longgc and gcsimulator tests to have their own build
- [`[35d9ee0]`](https://github.com/dotnet/coreclr/commit/35d9ee0) ARM64: Update Tests.lst
- [`[9044c78]`](https://github.com/dotnet/coreclr/commit/9044c78) mscorlib/System.Private.CoreLib cleanup
- [`[220aa25]`](https://github.com/dotnet/coreclr/commit/220aa25) Inliner: observe block weight, update schema and data
- [`[79ec970]`](https://github.com/dotnet/coreclr/commit/79ec970) Update profiling-api-status.md
- [`[ee62e38]`](https://github.com/dotnet/coreclr/commit/ee62e38) Update profiling-api-status.md
- [`[c72236d]`](https://github.com/dotnet/coreclr/commit/c72236d) Update profiling-api-status.md
- [`[5f98c72]`](https://github.com/dotnet/coreclr/commit/5f98c72) Make Phase::Phase protected.
- [`[f913425]`](https://github.com/dotnet/coreclr/commit/f913425) ARM64: Test Update
- [`[4015020]`](https://github.com/dotnet/coreclr/commit/4015020) ARM64: Don't track LR as part of NV-Context
- [`[853d391]`](https://github.com/dotnet/coreclr/commit/853d391) Fix clang build
- [`[aed8709]`](https://github.com/dotnet/coreclr/commit/aed8709) Inliner: implement profitabily side of the ModelPolicy
- [`[1569011]`](https://github.com/dotnet/coreclr/commit/1569011) Code review cleanup items and moved some items into LEGACY_BACKEND ifdefs
- [`[61e1cd6]`](https://github.com/dotnet/coreclr/commit/61e1cd6) Add an option to log outcome of loading Ready to Run images
- [`[2ad87a8]`](https://github.com/dotnet/coreclr/commit/2ad87a8) ARM64: Enable R2R CI
- [`[8f6dce4]`](https://github.com/dotnet/coreclr/commit/8f6dce4) Make Phase::{Pre,Do,Post}Phase protected.
- [`[ef0cd3f]`](https://github.com/dotnet/coreclr/commit/ef0cd3f) Create profiling-api-status.md
- [`[f09ad3c]`](https://github.com/dotnet/coreclr/commit/f09ad3c) Cleanup Arm32 package references.
- [`[833b012]`](https://github.com/dotnet/coreclr/commit/833b012) Remove `fgSplitMethodTrees`.
- [`[e784d4d]`](https://github.com/dotnet/coreclr/commit/e784d4d) Fix WeakReference tests depending on JIT not extending lifetimes
- [`[a216fba]`](https://github.com/dotnet/coreclr/commit/a216fba) Remove JIT_FEATURE_SSA_SKIP_DEFS.
- [`[df79663]`](https://github.com/dotnet/coreclr/commit/df79663) Remove CoreFX-specific project.json update code and update summary comment.
- [`[70fd31d]`](https://github.com/dotnet/coreclr/commit/70fd31d) Port CoreFX version of UpdateDependencies.ps1.
- [`[1bb2e3e]`](https://github.com/dotnet/coreclr/commit/1bb2e3e) Add -DARM_SOFTFP inside compileoptions.cmake (#5630)
- [`[6287c78]`](https://github.com/dotnet/coreclr/commit/6287c78) ARM/Linux Regression Fix of Exception Handling (#5596)
- [`[37b728c]`](https://github.com/dotnet/coreclr/commit/37b728c) Fix build break in JIT CTP build
- [`[37a6331]`](https://github.com/dotnet/coreclr/commit/37a6331) Add win8-arm package for CoreCLR
- [`[70778cc]`](https://github.com/dotnet/coreclr/commit/70778cc) Allows the use of IsHFA only when FEATURE_HFA is enabled
- [`[227afb9]`](https://github.com/dotnet/coreclr/commit/227afb9) Fix problem with virtual memory commit in OOM scenario on Linux (#5609)
- [`[c0fa9c6]`](https://github.com/dotnet/coreclr/commit/c0fa9c6) Renable disabled arm64 R2R tests
- [`[267f410]`](https://github.com/dotnet/coreclr/commit/267f410) Update Debian build status badges/links to 8.4.
- [`[0d03c10]`](https://github.com/dotnet/coreclr/commit/0d03c10) Fix error in RemoveDuplicateAssemblies task for perf (#5605)
- [`[8ab40ac]`](https://github.com/dotnet/coreclr/commit/8ab40ac) Reduce memory leak for issue #1379
- [`[00ebb38]`](https://github.com/dotnet/coreclr/commit/00ebb38) Switch to CORINFO_HELP_NEW_MDARR_NONVARARG
- [`[c09881c]`](https://github.com/dotnet/coreclr/commit/c09881c) need to account for server GC threads calling grow
- [`[e599995]`](https://github.com/dotnet/coreclr/commit/e599995) Address CR feedback
- [`[8ae5a2a]`](https://github.com/dotnet/coreclr/commit/8ae5a2a) temporarily disable R2R tests for arm64
- [`[9c635bd]`](https://github.com/dotnet/coreclr/commit/9c635bd) Add support for multi-dimensional array initialization
- [`[5f9da1b]`](https://github.com/dotnet/coreclr/commit/5f9da1b) Fix a problem where stale old, closed ETW sessions might be turned on.
- [`[7a47353]`](https://github.com/dotnet/coreclr/commit/7a47353) Linux/ARM: Revert -O1 to -O3 for Linux/ARM Release Build. (#5598)
- [`[c413a60]`](https://github.com/dotnet/coreclr/commit/c413a60) Fixing perf runs on helix (#5102)
- [`[8e41205]`](https://github.com/dotnet/coreclr/commit/8e41205) software ww fix
- [`[68a832d]`](https://github.com/dotnet/coreclr/commit/68a832d) Fix build issue http://buildstatus/Issues/Issues.aspx?iid=802303
- [`[83831c5]`](https://github.com/dotnet/coreclr/commit/83831c5) Fix backwards compatibility bug: RC2 dbgshim debugging RTM runtime (#5593)
- [`[623c343]`](https://github.com/dotnet/coreclr/commit/623c343) ASP.NET 5 -> Core (#5591)
- [`[bcab0c1]`](https://github.com/dotnet/coreclr/commit/bcab0c1) Updates tryrun.cmake for ARM64 cross build (#5406)
- [`[05ed729]`](https://github.com/dotnet/coreclr/commit/05ed729) [ARM64/Linux] Disable not yet implemented features.
- [`[d72a475]`](https://github.com/dotnet/coreclr/commit/d72a475) Methods to check for integer constants and zero
- [`[c679c1a]`](https://github.com/dotnet/coreclr/commit/c679c1a) Fix confused uses of return value of InternalSleepEx.
- [`[b973553]`](https://github.com/dotnet/coreclr/commit/b973553) Mark KeepAliveRecur as GCStressIncompatible
- [`[8d9ebf6]`](https://github.com/dotnet/coreclr/commit/8d9ebf6) Strip debugging symbol table entries on OS X Release builds.
- [`[e7abaeb]`](https://github.com/dotnet/coreclr/commit/e7abaeb) ARM64: ABI - Support for using register x8 as the return buffer argument for structs
- [`[84b2acc]`](https://github.com/dotnet/coreclr/commit/84b2acc) ARM64: Support R2R Private Run in CI
- [`[96d3c3d]`](https://github.com/dotnet/coreclr/commit/96d3c3d) Fix project and release notes URL to 1.1.0
- [`[3dec80f]`](https://github.com/dotnet/coreclr/commit/3dec80f) Inliner: allow replay log to override force inlines
- [`[9afee7e]`](https://github.com/dotnet/coreclr/commit/9afee7e) Update VS dependency details (#5578)
- [`[dec8ccd]`](https://github.com/dotnet/coreclr/commit/dec8ccd) Disable two tests that rely on an API not exposed on coreclr
- [`[f226ce0]`](https://github.com/dotnet/coreclr/commit/f226ce0) Update buildtools to add Serviceable to nupkgs
- [`[c2c1299]`](https://github.com/dotnet/coreclr/commit/c2c1299) Update the way the type forwarders are build to make sure they are correctly included in the build
- [`[cb5db09]`](https://github.com/dotnet/coreclr/commit/cb5db09) Update Debian 8.2 to 8.4 to match coreFX
- [`[db2d129]`](https://github.com/dotnet/coreclr/commit/db2d129) Add back internal Array ctor
- [`[af8079a]`](https://github.com/dotnet/coreclr/commit/af8079a) Update first-class-structs.md
- [`[922cace]`](https://github.com/dotnet/coreclr/commit/922cace) Fix for issue 3146: dotnet build is slower on Linux than Windows (#5524)
- [`[8a8f26b]`](https://github.com/dotnet/coreclr/commit/8a8f26b) Use cached empty arrays for "".ToCharArray (#5504)
- [`[372edb8]`](https://github.com/dotnet/coreclr/commit/372edb8) Update GC from CoreRT (#5522)
- [`[0d5ef45]`](https://github.com/dotnet/coreclr/commit/0d5ef45) Delegate ABI Test (#5507)
- [`[1f80f46]`](https://github.com/dotnet/coreclr/commit/1f80f46) Update wrong newline behavior for callipinvoke tests (#5553)
- [`[964f889]`](https://github.com/dotnet/coreclr/commit/964f889) Disable HeapDump on Linux if FEATURE_EVENT_TRACE is not set (#5550)
- [`[f5d09cd]`](https://github.com/dotnet/coreclr/commit/f5d09cd) Fix GC references reporting in tailcalls with helpers on Windows (#5538)
- [`[2a1187d]`](https://github.com/dotnet/coreclr/commit/2a1187d) Use Ntdll!RtlZeroMemory instead of kernel32!RtlZeroMemory to support Nano Server
- [`[b1e8dc7]`](https://github.com/dotnet/coreclr/commit/b1e8dc7) Add config switch to selectively disable R2R images
- [`[be46c18]`](https://github.com/dotnet/coreclr/commit/be46c18) Factor out method to check for a lclVar update tree
- [`[b86bda4]`](https://github.com/dotnet/coreclr/commit/b86bda4) Remove MMAP_IGNORES_HINT.
- [`[aaddd31]`](https://github.com/dotnet/coreclr/commit/aaddd31) Introduce explicity typeforwards to internal types that are needed by WinRT
- [`[3a4711b]`](https://github.com/dotnet/coreclr/commit/3a4711b) Fixed issue #5391 "libsosplugin.so getting an RPATH of /usr/lib/llvm on RHEL" (#5482)
- [`[9c5c891]`](https://github.com/dotnet/coreclr/commit/9c5c891) Copy linux builds from the right place
- [`[20781b8]`](https://github.com/dotnet/coreclr/commit/20781b8) ARM64: R2R - Implement CreateDictionaryLookupHelper stub
- [`[ab0f3e5]`](https://github.com/dotnet/coreclr/commit/ab0f3e5) Add doc on how to building lldb for OS X. (#5520)
- [`[b446cb5]`](https://github.com/dotnet/coreclr/commit/b446cb5) Fix incorrect URL.
- [`[5632eaa]`](https://github.com/dotnet/coreclr/commit/5632eaa) Skip reloads and copies in `gcIsWriteBarrierCandidate`.
- [`[9c2588a]`](https://github.com/dotnet/coreclr/commit/9c2588a) Add performance tracing documentation for Windows and Linux.
- [`[988100d]`](https://github.com/dotnet/coreclr/commit/988100d) Remove Mono section from  OS X build docs (#5499)
- [`[d86a343]`](https://github.com/dotnet/coreclr/commit/d86a343) Remove the deprecated JIT packaging tools.
- [`[7e05794]`](https://github.com/dotnet/coreclr/commit/7e05794) Use top level PreReleaseLabel
- [`[f620099]`](https://github.com/dotnet/coreclr/commit/f620099) [ARM64/Linux] Fix 'error: 109 enumeration values not handled in switch' (#5493)
- [`[5e9a125]`](https://github.com/dotnet/coreclr/commit/5e9a125) Linux/ARM: Adding rpath for shared library of exception_handling.pal_sxs.test1 (#5328)
- [`[8b6d371]`](https://github.com/dotnet/coreclr/commit/8b6d371) Fix allocation failure handling (#5473)
- [`[ac82e4e]`](https://github.com/dotnet/coreclr/commit/ac82e4e) Fix for #5275 Delegate Invocation On ARM Soft FP (#5362)
- [`[ce99897]`](https://github.com/dotnet/coreclr/commit/ce99897) Update new struct versioning rule (#5429)
- [`[432c2ff]`](https://github.com/dotnet/coreclr/commit/432c2ff) Add more opcodes to x86 stack unwinder (#5491)
- [`[1fa75e7]`](https://github.com/dotnet/coreclr/commit/1fa75e7) Remove all usages of CONTRACTS_FULL from mscorlib (#5454)
- [`[6da0e82]`](https://github.com/dotnet/coreclr/commit/6da0e82) Fix encoding of gccover.cpp. (#5458)
- [`[c1c5081]`](https://github.com/dotnet/coreclr/commit/c1c5081) Added JIT_Stelem_Ref helper function for Linux (#5390)
- [`[7472134]`](https://github.com/dotnet/coreclr/commit/7472134) Use explicit calling convention for coredistools
- [`[2507807]`](https://github.com/dotnet/coreclr/commit/2507807) Fix for issue  #5467: [R2R] InvalidCastException in timer tests. (#5478)
- [`[0a4675b]`](https://github.com/dotnet/coreclr/commit/0a4675b) Limit exports on debugger modules. (#5442)
- [`[f555045]`](https://github.com/dotnet/coreclr/commit/f555045) Fix failing tests on Ubuntu R2R configuration (#5435)
- [`[5f45560]`](https://github.com/dotnet/coreclr/commit/5f45560) Fix desktop NGen break caused by CoreCLR change, and add a missing contract
- [`[9efea10]`](https://github.com/dotnet/coreclr/commit/9efea10) Properly handle uname -p output that contains spaces
- [`[eff95d6]`](https://github.com/dotnet/coreclr/commit/eff95d6) Fix readytorun tests asking for user input (#5459)
- [`[80835e8]`](https://github.com/dotnet/coreclr/commit/80835e8) Fix CFI annotation of AMD64 assembler helpers on Unix (#5446)
- [`[4e4cac8]`](https://github.com/dotnet/coreclr/commit/4e4cac8) Avoid calling prestub through wrong MethodDesc (#5439)
- [`[9804bd1]`](https://github.com/dotnet/coreclr/commit/9804bd1) Some types were only supposed to be present when FEATURE_COMINTEROP was set.
- [`[9efbb7a]`](https://github.com/dotnet/coreclr/commit/9efbb7a) Linux/ARM: Support -O3 optimization level in release build (#5396)
- [`[6f452d1]`](https://github.com/dotnet/coreclr/commit/6f452d1) ARM64/Linux: fix compile error 'cannot be narrowed to type int'
- [`[f7ff151]`](https://github.com/dotnet/coreclr/commit/f7ff151) Fix wrong filename for case sensitive filesystem.
- [`[385b282]`](https://github.com/dotnet/coreclr/commit/385b282) CoreDisTools Package: Make minor version generic
- [`[0cf1848]`](https://github.com/dotnet/coreclr/commit/0cf1848) Introduce additional types to the reference assembly for mscorlib and typeforwards for those type to the right assembly.
- [`[55cc215]`](https://github.com/dotnet/coreclr/commit/55cc215) Disabling NativeResourceCompile Target for Managed libraries
- [`[0aedd27]`](https://github.com/dotnet/coreclr/commit/0aedd27) Disable perf_codequality_math_functions
- [`[86ada24]`](https://github.com/dotnet/coreclr/commit/86ada24) Remove unnecessary dependencies from JIT tests causing R2R failures
- [`[abb000b]`](https://github.com/dotnet/coreclr/commit/abb000b) Fixing GUID_NULL. (#5415)
- [`[3d53df2]`](https://github.com/dotnet/coreclr/commit/3d53df2) Fixing an error in PAL_pow that caused it to return an incorrect value for a couple scenarios. (#5399)
- [`[1bdc6eb]`](https://github.com/dotnet/coreclr/commit/1bdc6eb) Fix Details for ILAsm/ILDasm/ClrJit Binaries
- [`[61b4e0c]`](https://github.com/dotnet/coreclr/commit/61b4e0c) Disable RVA statics tests outside Windows.
- [`[63b2e2f]`](https://github.com/dotnet/coreclr/commit/63b2e2f) Fix details for CoreCLR binary
- [`[c407544]`](https://github.com/dotnet/coreclr/commit/c407544) Enable FEATURE_HIJACK for ARM (#5404)
- [`[21751db]`](https://github.com/dotnet/coreclr/commit/21751db) Validate new object construction in Ready to Run (#5398)
- [`[ba2e4ad]`](https://github.com/dotnet/coreclr/commit/ba2e4ad) [ARM/Linux] Undefine FEATURE_HFA if softfp
- [`[404aa74]`](https://github.com/dotnet/coreclr/commit/404aa74) Include license files into the packages
- [`[75918f0]`](https://github.com/dotnet/coreclr/commit/75918f0) Add filtering logic to XplatEventLogger
- [`[4b7c2f4]`](https://github.com/dotnet/coreclr/commit/4b7c2f4) Add limit to number of generics methods to compile by CrossGen (#5383)
- [`[b450c17]`](https://github.com/dotnet/coreclr/commit/b450c17) Added additional fix for ARM32 in lvHfaSlots
- [`[08786f2]`](https://github.com/dotnet/coreclr/commit/08786f2) Improvements to System.Math InternalCall code. (#4847)
- [`[3a97871]`](https://github.com/dotnet/coreclr/commit/3a97871) JIT_TailCall helper has an implicit assumption that all tail call arguments live
- [`[5b97541]`](https://github.com/dotnet/coreclr/commit/5b97541) Import `new` multi-dimmensional array using the non-vararg helper (#5313)
- [`[6b81f22]`](https://github.com/dotnet/coreclr/commit/6b81f22) Run fgMorphCopyBlock for newly inserted assignment
- [`[bd9712d]`](https://github.com/dotnet/coreclr/commit/bd9712d) GCStress: Fix a race-condition
- [`[9729128]`](https://github.com/dotnet/coreclr/commit/9729128) Publish pkg/symbolpkg folders within Release/Debug folders
- [`[c34a2c8]`](https://github.com/dotnet/coreclr/commit/c34a2c8) Proposed fix for HFA args on ARM32
- [`[bf8d72f]`](https://github.com/dotnet/coreclr/commit/bf8d72f) Remove some lexical-CSE-related code.
- [`[4f97571]`](https://github.com/dotnet/coreclr/commit/4f97571) Speed up CreateComparer in Comparer/EqualityComparer (#5315)
- [`[c1cf383]`](https://github.com/dotnet/coreclr/commit/c1cf383) Fix for issue 5343: Assert Failure: !"Cannot take the address of an uninstantiated generic method." (#5347)
- [`[762babf]`](https://github.com/dotnet/coreclr/commit/762babf) Publish packages into folders named for their configuration
- [`[2232566]`](https://github.com/dotnet/coreclr/commit/2232566) Squashed commit of the following:
- [`[bee6da4]`](https://github.com/dotnet/coreclr/commit/bee6da4) ARM64: eh11_large exclusion
- [`[27e4328]`](https://github.com/dotnet/coreclr/commit/27e4328) Add new document on how to setup/view JIT dumps
- [`[ed28854]`](https://github.com/dotnet/coreclr/commit/ed28854) Remove duplicate avoid in comments from a few files (#5363)
- [`[39425de]`](https://github.com/dotnet/coreclr/commit/39425de) Add more Ready-to-Run generics tests (#5190)
- [`[4c474ea]`](https://github.com/dotnet/coreclr/commit/4c474ea) Add named mutex stress tests
- [`[bf6e190]`](https://github.com/dotnet/coreclr/commit/bf6e190) Fix handle leak when creating or opening named mutex fails
- [`[594b424]`](https://github.com/dotnet/coreclr/commit/594b424) ARM/Linux: Fix Exception Handler PAL Test Fail (#5360)
- [`[959025a]`](https://github.com/dotnet/coreclr/commit/959025a) Comment typo fix: removed double word (#5359)
- [`[a027256]`](https://github.com/dotnet/coreclr/commit/a027256) Fix JIT PInvoke Check Failure on Linux/ARM (#5322)
- [`[a936914]`](https://github.com/dotnet/coreclr/commit/a936914) [ARM/Linux] Fix arm-softfp calling convention
- [`[4abde70]`](https://github.com/dotnet/coreclr/commit/4abde70) Add options to 'runtest.sh'
- [`[b4ea056]`](https://github.com/dotnet/coreclr/commit/b4ea056) Inliner: enable inlining of methods with cpblk
- [`[1231f3f]`](https://github.com/dotnet/coreclr/commit/1231f3f) Refactoring Arguments passed to runtest.cmd
- [`[df1de79]`](https://github.com/dotnet/coreclr/commit/df1de79) Mark two tests as always optimized and exclude two others from x86/JIT32.
- [`[b79ea9b]`](https://github.com/dotnet/coreclr/commit/b79ea9b) Fix for issue 5241: [RTM] Interop\ICastable\Castable\Castable.cmd CONTRACT VIOLATION by ReadyToRunInfo::TryLookupTypeTokenFromName (#5296)
- [`[992129e]`](https://github.com/dotnet/coreclr/commit/992129e) Support building on all supported distros
- [`[321330e]`](https://github.com/dotnet/coreclr/commit/321330e) Move gtComputeFPlvls next to gtSetEvalOrder.
- [`[010b599]`](https://github.com/dotnet/coreclr/commit/010b599) Rename fg{FPstLvlRedo,ComputeFPlvls} to gt*.
- [`[e25dfba]`](https://github.com/dotnet/coreclr/commit/e25dfba) ARM64: Fix JIT_MemSet
- [`[d2d543b]`](https://github.com/dotnet/coreclr/commit/d2d543b) Disable a large number of GC tests from running under GCStress
- [`[5a35fda]`](https://github.com/dotnet/coreclr/commit/5a35fda) Remove LONG_MATH_REGPARAM from the JIT.
- [`[19a88d8]`](https://github.com/dotnet/coreclr/commit/19a88d8) Port String.IndexOf(char) and LastIndexOf(char) from CoreRT (#5327)
- [`[dd15b12]`](https://github.com/dotnet/coreclr/commit/dd15b12) Update Windows instructions (#5312)
- [`[8868f88]`](https://github.com/dotnet/coreclr/commit/8868f88) Update tryrun.cmake for arm-softfp (#5323)
- [`[42b01fd]`](https://github.com/dotnet/coreclr/commit/42b01fd) Updates tryrun.cmake for ARM cross build (#5317)
- [`[376b1fc]`](https://github.com/dotnet/coreclr/commit/376b1fc) Enable 'System.Private.CoreLib.dll' build on cross build mode (#5320)
- [`[9931123]`](https://github.com/dotnet/coreclr/commit/9931123) Fix: if errorlevel 0 is almost always true (#5308)
- [`[462bd12]`](https://github.com/dotnet/coreclr/commit/462bd12) Avoid unnecessary ContingentProperties allocations
- [`[48064b6]`](https://github.com/dotnet/coreclr/commit/48064b6) Make m_contingentProperties non-volatile
- [`[eae354b]`](https://github.com/dotnet/coreclr/commit/eae354b) Move Task's m_parent to ContingentProperties
- [`[352df35]`](https://github.com/dotnet/coreclr/commit/352df35) Fix ucol_setMaxVariable detection for Gentoo Linux (#5309)
- [`[41912e3]`](https://github.com/dotnet/coreclr/commit/41912e3) Don't use libstdc++ wrappers for stdlib.h (#5304)
- [`[664286a]`](https://github.com/dotnet/coreclr/commit/664286a) ARM: Remove workaround no more required
- [`[9458840]`](https://github.com/dotnet/coreclr/commit/9458840) ARM/THUMB PC Least Bit Set for Range Check
- [`[e3b44b0]`](https://github.com/dotnet/coreclr/commit/e3b44b0) Fix RHEL 7 Build
- [`[80b1180]`](https://github.com/dotnet/coreclr/commit/80b1180) Ensure Ready-to-Run module is activated in generics dictionary lookup (#5288)
- [`[599c127]`](https://github.com/dotnet/coreclr/commit/599c127) Remove the dnvm-based installation instructions from the docs (#5271)
- [`[7947874]`](https://github.com/dotnet/coreclr/commit/7947874) Second attempt to properly modify environment for stress test modes
- [`[5ac6af9]`](https://github.com/dotnet/coreclr/commit/5ac6af9) Fix the named semaphore leak on OSX (and Linux) (#5269)
- [`[b156152]`](https://github.com/dotnet/coreclr/commit/b156152) Fix Assert Error "Unexpected size when returning struct by value" on arm-softfp
- [`[38640b4]`](https://github.com/dotnet/coreclr/commit/38640b4) Documentation: Adding flag descriptions of unit test scripts
- [`[91ec3b8]`](https://github.com/dotnet/coreclr/commit/91ec3b8) Fix a build break due to PR #5101
- [`[95f4e6c]`](https://github.com/dotnet/coreclr/commit/95f4e6c) Avoid using register x8 as it will be used as the RetBuf argument in the future
- [`[28fe0dc]`](https://github.com/dotnet/coreclr/commit/28fe0dc) Excluding Weak-GCReferences tests from GC stress runs (#5289)
- [`[e1b5578]`](https://github.com/dotnet/coreclr/commit/e1b5578) Adding commit hash to all built binaries.
- [`[c004a43]`](https://github.com/dotnet/coreclr/commit/c004a43) Introduce a central packages.builds file that controls building the nuget packages.
- [`[c0d6ce3]`](https://github.com/dotnet/coreclr/commit/c0d6ce3) Fix environment settings for Unix JIT stress scenarios
- [`[20f7d04]`](https://github.com/dotnet/coreclr/commit/20f7d04) Fix GCStress 0xC on Unix (#5276)
- [`[4105759]`](https://github.com/dotnet/coreclr/commit/4105759) Use JitFuncInfoLogFile to check if SIMD intrinsics are recognized.
- [`[7c94b20]`](https://github.com/dotnet/coreclr/commit/7c94b20) Remove another redundant call to gtSetEvalOrder.
- [`[58e2c72]`](https://github.com/dotnet/coreclr/commit/58e2c72) Fix System.Diagnostics.StackTrace symbol issue (#5265)
- [`[29333fa]`](https://github.com/dotnet/coreclr/commit/29333fa) Fix sos ClrStack print of GC frames for ARM/Linux (#5178)
- [`[200ab60]`](https://github.com/dotnet/coreclr/commit/200ab60) Fix debuggertests failures OSX. (#5267)
- [`[b07c9c9]`](https://github.com/dotnet/coreclr/commit/b07c9c9) Fix for clrstack after bpmd (#5051)
- [`[4fd217d]`](https://github.com/dotnet/coreclr/commit/4fd217d) Fix generic non-virtual method call in Ready-to-Run images
- [`[38880b7]`](https://github.com/dotnet/coreclr/commit/38880b7) ARM64: Fix Liveness update for Division By Zero
- [`[4f5dc5c]`](https://github.com/dotnet/coreclr/commit/4f5dc5c) Proposed fix for #5264
- [`[ba385ce]`](https://github.com/dotnet/coreclr/commit/ba385ce) Add Fedora, OpenSuse and Ubuntu 16.04 packages
- [`[42e6d1a]`](https://github.com/dotnet/coreclr/commit/42e6d1a) EventSource Events that use complex types do not get logged (silently ignored)
- [`[d79118c]`](https://github.com/dotnet/coreclr/commit/d79118c) Add noexcept to some non-throwing new overloads.
- [`[a97eacb]`](https://github.com/dotnet/coreclr/commit/a97eacb) Fxing the case of COMPlus_GCStress Removing Build dependency for GC Stress
- [`[8aeb642]`](https://github.com/dotnet/coreclr/commit/8aeb642) Remove a redundant recursive call to `gtSetEvalOrder`.
- [`[a755577]`](https://github.com/dotnet/coreclr/commit/a755577) Recognize Vector<T> constructors for small ints
- [`[0588c3c]`](https://github.com/dotnet/coreclr/commit/0588c3c) Add fedora23 badges to Readme.
- [`[6825093]`](https://github.com/dotnet/coreclr/commit/6825093) Disable failing test to enable corefx runs.
- [`[a453d31]`](https://github.com/dotnet/coreclr/commit/a453d31) ARM64: A few Test List Update
- [`[de8f2d8]`](https://github.com/dotnet/coreclr/commit/de8f2d8) Skip archiving windows test data
- [`[2fab93a]`](https://github.com/dotnet/coreclr/commit/2fab93a) Add retry logic when downloading the CLI from Azure blob storage.
- [`[6dcc70e]`](https://github.com/dotnet/coreclr/commit/6dcc70e) Don't do r2r-jitstress jobs for non Checked configurations.
- [`[4f45805]`](https://github.com/dotnet/coreclr/commit/4f45805) Support CoreLib build for arm-softfp
- [`[68b7bfa]`](https://github.com/dotnet/coreclr/commit/68b7bfa) Typo Fix: from preemtive GC to preemptive GC (#5237)
- [`[3351bfc]`](https://github.com/dotnet/coreclr/commit/3351bfc) Linux/ARM: Regression fix in release build since "UNW_ARM_UNWIND_METHOD=6" (#5126)
- [`[c971a45]`](https://github.com/dotnet/coreclr/commit/c971a45) ARM-CI: fixing umount bug
- [`[b2efe59]`](https://github.com/dotnet/coreclr/commit/b2efe59) Enable HFA support for passing arguments on ARM64    Fixes #4946 ARM64: ABI - Passing HFA struct arguments in floating point registers    We are now passing 24 additional HFA tests and have one test regression
- [`[a48a63f]`](https://github.com/dotnet/coreclr/commit/a48a63f) Inliner: enable minimal xml mode
- [`[be9d889]`](https://github.com/dotnet/coreclr/commit/be9d889) Inliner: use offset in xml replay
- [`[78b7810]`](https://github.com/dotnet/coreclr/commit/78b7810) JIT: Track IL offset of all calls
- [`[ae88d1d]`](https://github.com/dotnet/coreclr/commit/ae88d1d) arm32 build fix.
- [`[57c5bd3]`](https://github.com/dotnet/coreclr/commit/57c5bd3) WinMD Adapter should only lookup mscorlib in WinMD references
- [`[ac9238e]`](https://github.com/dotnet/coreclr/commit/ac9238e) Increase the timeout of long GC tests
- [`[18fb747]`](https://github.com/dotnet/coreclr/commit/18fb747) Remove CORECLR_CONCURRENT_GC from Unix coreruncommon.
- [`[bcda7c5]`](https://github.com/dotnet/coreclr/commit/bcda7c5) Be more explict when picking up libs from CoreFx
- [`[935accb]`](https://github.com/dotnet/coreclr/commit/935accb) Add missing quote in new runtest.cmd arg
- [`[3ea0ad0]`](https://github.com/dotnet/coreclr/commit/3ea0ad0) Limit the exports of libclrjit.{so,dylib}.
- [`[38fa1f9]`](https://github.com/dotnet/coreclr/commit/38fa1f9) Upgrade Linux build to use Unicode 8.0
- [`[e15606e]`](https://github.com/dotnet/coreclr/commit/e15606e) Explicitly check CLRConfig value to determine whether concurrent GC was forced.
- [`[780a7da]`](https://github.com/dotnet/coreclr/commit/780a7da) Include System.Private.CoreLib in the targeting pack next to the mscorlib facade.
- [`[2ce2407]`](https://github.com/dotnet/coreclr/commit/2ce2407) Restore the package version to 1.0.2 for the ILAsm/ILDAsm packages.
- [`[4c19845]`](https://github.com/dotnet/coreclr/commit/4c19845) Restore the package version to 1.0.2 for the CoreCLR package
- [`[6fb5ce9]`](https://github.com/dotnet/coreclr/commit/6fb5ce9) Enable FEATURE_MULTIREG_RET for x86 RyuJIT
- [`[f668a73]`](https://github.com/dotnet/coreclr/commit/f668a73) Fix shm directory creation for named mutexes
- [`[046085a]`](https://github.com/dotnet/coreclr/commit/046085a) arm-softfp: make toolchain.cmake consistent among different arm archs (#5210)
- [`[148abd1]`](https://github.com/dotnet/coreclr/commit/148abd1) ARM-CI: added a fix to mount Linux ARM emulator rootfs during each build
- [`[a19e82f]`](https://github.com/dotnet/coreclr/commit/a19e82f) Update runtests.sh to accommodate a change in CoreFX that broke creation of CoreOverlay on Unix platforms
- [`[bcc8495]`](https://github.com/dotnet/coreclr/commit/bcc8495) [ARM/Linux] Fix incorrect return marshaling in PInvoke stub (#5010)
- [`[31031a3]`](https://github.com/dotnet/coreclr/commit/31031a3) Support the CORE_LIBRARIES environment variable on Unix (#5112)
- [`[a22c755]`](https://github.com/dotnet/coreclr/commit/a22c755) Fix Guid's GetHashCode to work better (not ignore parts of it) (#5191)
- [`[bdd7edf]`](https://github.com/dotnet/coreclr/commit/bdd7edf) Improve vtbl matching loop in DacGetVtNameW. (#5179)
- [`[1cfb4f3]`](https://github.com/dotnet/coreclr/commit/1cfb4f3) Fix filter funclet handling during stack walk on Unix (#5183)
- [`[d3cba55]`](https://github.com/dotnet/coreclr/commit/d3cba55) Added jit related R2R jobs.
- [`[33e975a]`](https://github.com/dotnet/coreclr/commit/33e975a) Add PowerShell script to update latest package version info in Versions repo
- [`[2cd2e6f]`](https://github.com/dotnet/coreclr/commit/2cd2e6f) Inliner: integrate data into inline Xml
- [`[ac81aaf]`](https://github.com/dotnet/coreclr/commit/ac81aaf) Exclude varags tests for JIT32
- [`[877352f]`](https://github.com/dotnet/coreclr/commit/877352f) ILAsm/ILDAsm Package
- [`[a99abc5]`](https://github.com/dotnet/coreclr/commit/a99abc5) Add R2R JitStress, JitStressRegs, JITMinOpts and ForceRelocs jobs to CI.
- [`[4f330fd]`](https://github.com/dotnet/coreclr/commit/4f330fd) Linux/ARM: Add execution time of ./tests/runtest.sh
- [`[d75cfc2]`](https://github.com/dotnet/coreclr/commit/d75cfc2) Update sync.cmd to download Azure Blobs. Also change publish.proj to publish packages into symbol/pkg directories
- [`[f60d720]`](https://github.com/dotnet/coreclr/commit/f60d720) Fix intermittent test failure in paltest_namedmutex_test1
- [`[37d2c7b]`](https://github.com/dotnet/coreclr/commit/37d2c7b) Change Unix HW exception unwinding to not to go through signal trampoline (#5140)
- [`[438383f]`](https://github.com/dotnet/coreclr/commit/438383f) Add missing #ifdef FEATURE_ICASTABLE
- [`[b72128b]`](https://github.com/dotnet/coreclr/commit/b72128b) Update tests to build against rc3-24117-00 (#5154)
- [`[df10d7a]`](https://github.com/dotnet/coreclr/commit/df10d7a) Expose ResolveEventHandler and ResolveEventArgs in the mscorlib facade so that our test host still function.
- [`[2a0d3b8]`](https://github.com/dotnet/coreclr/commit/2a0d3b8) ARM64: Test Binary Update (afa7fe5486fc90fec7df52bd134b789c568c8b45)
- [`[3376767]`](https://github.com/dotnet/coreclr/commit/3376767) Update pre-release tags to RC4
- [`[2f47e97]`](https://github.com/dotnet/coreclr/commit/2f47e97) Remove InitializeDefaultContext from AssemblyLoadContext
- [`[efa0c0e]`](https://github.com/dotnet/coreclr/commit/efa0c0e) Enable overriding of TPA assemblies
- [`[27484e2]`](https://github.com/dotnet/coreclr/commit/27484e2) Inliner: locks for xml read/write access
- [`[7105b18]`](https://github.com/dotnet/coreclr/commit/7105b18) Fix broken RHEL debug build link
- [`[a6933d6]`](https://github.com/dotnet/coreclr/commit/a6933d6) Remove ryujit_x86_no_fallback_issues.targets

## CoreFX

- [`[88d34c8]`](https://github.com/dotnet/corefx/commit/88d34c8) Fix back-tick mark
- [`[4d1af96]`](https://github.com/dotnet/corefx/commit/4d1af96) Fix SslStream.WriteAsync with 0-byte write (#13384)
- [`[66ce16a]`](https://github.com/dotnet/corefx/commit/66ce16a) Special-case Fedora 24 in a Globalization test case
- [`[397d986]`](https://github.com/dotnet/corefx/commit/397d986) Disable X509Store_FiltersDuplicateOnLoad on CI jobs with NTFS drives
- [`[ddd5e57]`](https://github.com/dotnet/corefx/commit/ddd5e57) Consider Ubuntu 16.10 as unreliable for X509Certificates outerloop CI tests.
- [`[b231765]`](https://github.com/dotnet/corefx/commit/b231765) Add test special-casing for Ubuntu 16.10
- [`[0ff960b]`](https://github.com/dotnet/corefx/commit/0ff960b) Add support for running CI tests on three new distros
- [`[3a1db6a]`](https://github.com/dotnet/corefx/commit/3a1db6a) Disable test input causing Corelib assertion
- [`[1f89ccb]`](https://github.com/dotnet/corefx/commit/1f89ccb) Fix RID for runtime.native.System.IO.Compression
- [`[2c66a97]`](https://github.com/dotnet/corefx/commit/2c66a97) Update BuildToolsVersion to 1.0.26-prerelease-00927-04
- [`[e2a2174]`](https://github.com/dotnet/corefx/commit/e2a2174) Block zero-byte calls to encrypt for Unix SslStream
- [`[718b614]`](https://github.com/dotnet/corefx/commit/718b614) Mark CoreFx packages as stable
- [`[79039fb]`](https://github.com/dotnet/corefx/commit/79039fb) Change the cryptography shims to use direct package dependencies (#13060)
- [`[a33bb11]`](https://github.com/dotnet/corefx/commit/a33bb11) Moving the dependency to dependencies.props
- [`[dfa90dd]`](https://github.com/dotnet/corefx/commit/dfa90dd) Include ns1.1 dummy impl for RuntimeInformation
- [`[1befbb9]`](https://github.com/dotnet/corefx/commit/1befbb9) Adding the servicing pre-release tag to SNI packaging. Adding the version of SNI identified as the stable version
- [`[60d1b3d]`](https://github.com/dotnet/corefx/commit/60d1b3d) Fix handling of flock in FileStream on Unix
- [`[3482979]`](https://github.com/dotnet/corefx/commit/3482979) Adds ActiveIssue attribute to GetResponseAsync_ResourceNotFound_ThrowsWebException.
- [`[7ddc57a]`](https://github.com/dotnet/corefx/commit/7ddc57a) Fixed JsonDataContract.GetGeneratedReadWriteDelegates. (#12906)
- [`[110fdf3]`](https://github.com/dotnet/corefx/commit/110fdf3) Fixed Reflection on XmlConvert Not Working in Net Native. (#12907)
- [`[0210c36]`](https://github.com/dotnet/corefx/commit/0210c36) Add downlevel ValueTuple configuration
- [`[16210da]`](https://github.com/dotnet/corefx/commit/16210da) Mandatory http response status should be 100..1000 (#12938)
- [`[1bf8191]`](https://github.com/dotnet/corefx/commit/1bf8191) Fix ValueTask behavior as async return type
- [`[bd2edb2]`](https://github.com/dotnet/corefx/commit/bd2edb2) Net standard docs (#12244)
- [`[e7d55c8]`](https://github.com/dotnet/corefx/commit/e7d55c8) Fix parsing of procfs stat files when comm name contains spaces
- [`[69ebf34]`](https://github.com/dotnet/corefx/commit/69ebf34) Make derived types of SymmetricAlgorithm use field assignment in ctors.
- [`[68b75e3]`](https://github.com/dotnet/corefx/commit/68b75e3) Lower peak memory usage in BigInteger tests
- [`[7af2072]`](https://github.com/dotnet/corefx/commit/7af2072) Remove unnecessary comparison in SequencePointCollection
- [`[9e31274]`](https://github.com/dotnet/corefx/commit/9e31274) Fixes a couple of tests - keep MetadataReaderProvider alive (#12432)
- [`[7704592]`](https://github.com/dotnet/corefx/commit/7704592) Respond to PR feedback
- [`[2501e76]`](https://github.com/dotnet/corefx/commit/2501e76) Clean up type provider interface factoring
- [`[28acba2]`](https://github.com/dotnet/corefx/commit/28acba2) Rename GenericInstance to GenericInstantiation throughout
- [`[ba0a2d6]`](https://github.com/dotnet/corefx/commit/ba0a2d6) Add generic context to signature decoder
- [`[b1de2af]`](https://github.com/dotnet/corefx/commit/b1de2af) Replace SkipBytes and SeekOffset with Offset setter (#12375)
- [`[ddba30b]`](https://github.com/dotnet/corefx/commit/ddba30b) Implements PE checksum and signing validation (#12321)
- [`[48b8423]`](https://github.com/dotnet/corefx/commit/48b8423) Implements BlobReader.IndexOf(byte) (#12308)
- [`[acdfab6]`](https://github.com/dotnet/corefx/commit/acdfab6) Use constants instead of literal numbers (#11547)
- [`[a217068]`](https://github.com/dotnet/corefx/commit/a217068) Update PE-COFF.md
- [`[34d92f9]`](https://github.com/dotnet/corefx/commit/34d92f9) Update PE-COFF.md
- [`[8dfccb4]`](https://github.com/dotnet/corefx/commit/8dfccb4) Remove the CreateManyConcurrent test
- [`[54cefff]`](https://github.com/dotnet/corefx/commit/54cefff) Use rooted path for symlink creation in IO tests
- [`[0c03bce]`](https://github.com/dotnet/corefx/commit/0c03bce) Revert "Build Linq.Expression tests against live Regex"
- [`[f63813e]`](https://github.com/dotnet/corefx/commit/f63813e) Update the package baseline to 1.1
- [`[bf82f1f]`](https://github.com/dotnet/corefx/commit/bf82f1f) Clean up SNI project
- [`[4f75416]`](https://github.com/dotnet/corefx/commit/4f75416) Don't include non-corefx packages in index
- [`[7074f25]`](https://github.com/dotnet/corefx/commit/7074f25) Stamp packageIndex with Pre-release
- [`[20a26ee]`](https://github.com/dotnet/corefx/commit/20a26ee) Update version of MS.NETCore.Platforms and Targets
- [`[386cb95]`](https://github.com/dotnet/corefx/commit/386cb95) Add baseline for native Crypto packages
- [`[5b0a604]`](https://github.com/dotnet/corefx/commit/5b0a604) Fix file-clashes in test archiving
- [`[796b985]`](https://github.com/dotnet/corefx/commit/796b985) Override ArchiveTestBuild from buildtools
- [`[8cc6509]`](https://github.com/dotnet/corefx/commit/8cc6509) Update BuildToolsVersion.txt
- [`[50a474b]`](https://github.com/dotnet/corefx/commit/50a474b) OpenSSL does not need to rebuild for Windows
- [`[1647fb0]`](https://github.com/dotnet/corefx/commit/1647fb0) Update BuildTools to 1.0.26-prerelease-00819-01
- [`[179607b]`](https://github.com/dotnet/corefx/commit/179607b) Redistribute reference dlls
- [`[514433f]`](https://github.com/dotnet/corefx/commit/514433f) XPath.XmlDocument should target desktop
- [`[d09954c]`](https://github.com/dotnet/corefx/commit/d09954c) Update BuildTools to 00808-01. Fixes package downgrade warning in tool-runtime project.json
- [`[432d053]`](https://github.com/dotnet/corefx/commit/432d053) Upgrade CLI, buildtools for RTM shared framework (#11387)
- [`[740d508]`](https://github.com/dotnet/corefx/commit/740d508) Handle network interfaces which report their speed as '-1'.
- [`[4af853d]`](https://github.com/dotnet/corefx/commit/4af853d) Disable test on *Nix
- [`[194f728]`](https://github.com/dotnet/corefx/commit/194f728) Make async continuations run on different thread to avoid deadlock
- [`[58f1109]`](https://github.com/dotnet/corefx/commit/58f1109) Fix UNC path normalization
- [`[f635540]`](https://github.com/dotnet/corefx/commit/f635540) Fix WinHttpHandler when connecting thru authenticating proxy
- [`[d5377b4]`](https://github.com/dotnet/corefx/commit/d5377b4) Use CommonCrypto CSPRNG for GetTempFileName on macOS
- [`[8a99fac]`](https://github.com/dotnet/corefx/commit/8a99fac) Fix WinHttpHandler to deal with nonstandard HTTP auth responses
- [`[4f192af]`](https://github.com/dotnet/corefx/commit/4f192af) Build Linq.Expression tests against live Regex
- [`[b01a16f]`](https://github.com/dotnet/corefx/commit/b01a16f) Avoid unnecessary clearing in CopyToAsync
- [`[6b799df]`](https://github.com/dotnet/corefx/commit/6b799df) Make 1.1 API netcoreapp1.1-specific
- [`[3fe9860]`](https://github.com/dotnet/corefx/commit/3fe9860) Support text.Mapping being SpecialMapping when using ReflectionBased Serializer (#11752)
- [`[2487d0f]`](https://github.com/dotnet/corefx/commit/2487d0f) Update CoreClr, CoreFx to preview1-24517-01, preview1-24517-04, respectively (#11659)
- [`[333a0c1]`](https://github.com/dotnet/corefx/commit/333a0c1) Use exact versions of 1.0.0 RTM runtimes from TFS. (#11814)
- [`[c35abaa]`](https://github.com/dotnet/corefx/commit/c35abaa) Make SqlClient support win10-arm64 using master runtime package.
- [`[babf9b0]`](https://github.com/dotnet/corefx/commit/babf9b0) Fix leak of WinHttpRequestState objects during HTTP resends
- [`[61c1dd5]`](https://github.com/dotnet/corefx/commit/61c1dd5) Use ArrayPool in CopyToAsync in several System.IO streams
- [`[9f4a7a8]`](https://github.com/dotnet/corefx/commit/9f4a7a8) Add tests for FileStream.CopyToAsync
- [`[c830dc2]`](https://github.com/dotnet/corefx/commit/c830dc2) Use ArrayPool in FileStream.CopyToAsync
- [`[775331b]`](https://github.com/dotnet/corefx/commit/775331b) Address PR feedback
- [`[5de6cce]`](https://github.com/dotnet/corefx/commit/5de6cce) Optimize overlapped I/O FileStream.CopyToAsync implementation on Windows
- [`[761702d]`](https://github.com/dotnet/corefx/commit/761702d) Downgrade projectk-tfs package to release/1.0.0 (#11562)
- [`[7c2b65a]`](https://github.com/dotnet/corefx/commit/7c2b65a) Rename AsyncBuilderAttribute to AsyncMethodBuilderAttribute
- [`[3813e7f]`](https://github.com/dotnet/corefx/commit/3813e7f) Make AsyncBuilderAttribute public
- [`[df91b64]`](https://github.com/dotnet/corefx/commit/df91b64) Update corefx to preview1-24508-03.
- [`[9194d96]`](https://github.com/dotnet/corefx/commit/9194d96) Update build-info dependencies for 1.1.0.
- [`[5f01d27]`](https://github.com/dotnet/corefx/commit/5f01d27) Updating package prerelease to preview1
- [`[1b23e89]`](https://github.com/dotnet/corefx/commit/1b23e89) Remove unnecessarily Volatile.Reads in EnsureStoreOpened
- [`[32cd5f9]`](https://github.com/dotnet/corefx/commit/32cd5f9) Add test coverage for issue#10598 (#11240)
- [`[24d6876]`](https://github.com/dotnet/corefx/commit/24d6876) Add tests for Guid.Parse (#11448)
- [`[80e15a0]`](https://github.com/dotnet/corefx/commit/80e15a0) Some perf improvements for ExpressionStringBuilder
- [`[d84318a]`](https://github.com/dotnet/corefx/commit/d84318a) Adding tests for ExpressionStringBuilder
- [`[3e6c50a]`](https://github.com/dotnet/corefx/commit/3e6c50a) Fix potential null ref in ReflectionXmlSerializationReader
- [`[39e2eee]`](https://github.com/dotnet/corefx/commit/39e2eee) Fix two minor collections issues
- [`[c20918f]`](https://github.com/dotnet/corefx/commit/c20918f) Fix a few minor issues in System.Security
- [`[ef5dff6]`](https://github.com/dotnet/corefx/commit/ef5dff6) Remove some dead code in WindowsIdentity
- [`[b1421bc]`](https://github.com/dotnet/corefx/commit/b1421bc) Fix minor precedence error in SafeCloseSocket
- [`[6a6ccd3]`](https://github.com/dotnet/corefx/commit/6a6ccd3) Address PR feedbac
- [`[22d4747]`](https://github.com/dotnet/corefx/commit/22d4747) Use new PEReader API to open Portable PDB (#11197)
- [`[5309106]`](https://github.com/dotnet/corefx/commit/5309106) Conditional compilation of MethodBuilder support in LambdaCompiler
- [`[ef41d0b]`](https://github.com/dotnet/corefx/commit/ef41d0b) Using TypeCode for Ldind and Stind emit.
- [`[e8d9dac]`](https://github.com/dotnet/corefx/commit/e8d9dac) Make MetadataReader.UTF8Decoder public (#11354)
- [`[8970dd0]`](https://github.com/dotnet/corefx/commit/8970dd0) Making Expression<TDelegate> constructor internal again
- [`[40b544d]`](https://github.com/dotnet/corefx/commit/40b544d) Removing some unncessary allocations in LambdaCompiler
- [`[d6300dc]`](https://github.com/dotnet/corefx/commit/d6300dc) Remove unreachable throw statement
- [`[1c68612]`](https://github.com/dotnet/corefx/commit/1c68612) Remove Options from common types for TPL Dataflow
- [`[f48eb34]`](https://github.com/dotnet/corefx/commit/f48eb34) Fix WinHttpHandler for Basic auth with default credentials
- [`[4faf779]`](https://github.com/dotnet/corefx/commit/4faf779) Disable some failing globalization tests on Unix
- [`[30852f2]`](https://github.com/dotnet/corefx/commit/30852f2) Update POR for handling stable dependencies in our repo.
- [`[49e6188]`](https://github.com/dotnet/corefx/commit/49e6188) Fix CookieContainer dead code masquerading as a race condition
- [`[8681013]`](https://github.com/dotnet/corefx/commit/8681013) Add a help job to corefx
- [`[26453da]`](https://github.com/dotnet/corefx/commit/26453da) update to 1.0.26-prerelease-00802-01
- [`[ef89154]`](https://github.com/dotnet/corefx/commit/ef89154) Remove unshipped assembly versions
- [`[7a15e76]`](https://github.com/dotnet/corefx/commit/7a15e76) Update package description for System.Linq.Expressions
- [`[0a86d80]`](https://github.com/dotnet/corefx/commit/0a86d80) Change DateTime Used in New Tests to UTC kind.
- [`[bf3d25c]`](https://github.com/dotnet/corefx/commit/bf3d25c) Uses uint.MaxValue for 32-bit arch
- [`[9f456d6]`](https://github.com/dotnet/corefx/commit/9f456d6) Addess more PR feedback.
- [`[546cbb0]`](https://github.com/dotnet/corefx/commit/546cbb0) Enable Reflection Method on Net Native.
- [`[43c2d84]`](https://github.com/dotnet/corefx/commit/43c2d84) Address Comments for PR #10594.
- [`[dddce86]`](https://github.com/dotnet/corefx/commit/dddce86) Add GitHub Issue Info in Comments.
- [`[98ae097]`](https://github.com/dotnet/corefx/commit/98ae097) Enable XmlSerializer to De-serialize via Reflection.
- [`[5d98be2]`](https://github.com/dotnet/corefx/commit/5d98be2) Enable XmlSerializer to Serialize via Reflection.
- [`[5d71d30]`](https://github.com/dotnet/corefx/commit/5d71d30) Update package baseline.
- [`[9242897]`](https://github.com/dotnet/corefx/commit/9242897) Fixed a bug with PreserveObjectReferences=true. (#11104)
- [`[c827a45]`](https://github.com/dotnet/corefx/commit/c827a45) Move some flaky FSW tests to Outerloop
- [`[63a8683]`](https://github.com/dotnet/corefx/commit/63a8683) Fix version of nupkgs under pkg
- [`[c605cbd]`](https://github.com/dotnet/corefx/commit/c605cbd) Confirm MaxCapacity in Ctor() and Ctor(int)
- [`[defbb8a]`](https://github.com/dotnet/corefx/commit/defbb8a) Disable most networking tests for default CI runs
- [`[f7acbd6]`](https://github.com/dotnet/corefx/commit/f7acbd6) fix #11309 in WebSockets by throwing when the underlying connection is closed
- [`[d004c03]`](https://github.com/dotnet/corefx/commit/d004c03) Delete stale/erroneous comment
- [`[180166b]`](https://github.com/dotnet/corefx/commit/180166b) Update consumes-api.md
- [`[8e23697]`](https://github.com/dotnet/corefx/commit/8e23697) Consumes API design doc
- [`[a9768d7]`](https://github.com/dotnet/corefx/commit/a9768d7) PR feedback for Deflate64
- [`[a627315]`](https://github.com/dotnet/corefx/commit/a627315) Avoid array cloning in Path.Get*Chars
- [`[b22bb95]`](https://github.com/dotnet/corefx/commit/b22bb95) Add Deflate64 support to ZipArchive
- [`[3037a5f]`](https://github.com/dotnet/corefx/commit/3037a5f) Clean up the managed deflater
- [`[0a86407]`](https://github.com/dotnet/corefx/commit/0a86407) Add back Managed Deflate implementation
- [`[f332ea1]`](https://github.com/dotnet/corefx/commit/f332ea1) Removing obselute comments in code
- [`[68e9e5c]`](https://github.com/dotnet/corefx/commit/68e9e5c) Changing some runtime checks into asserts in ILGen.
- [`[60fb524]`](https://github.com/dotnet/corefx/commit/60fb524) Remove dead assert in Enumerable.Union
- [`[52335d0]`](https://github.com/dotnet/corefx/commit/52335d0) Simplifying FindProperty and FindMethod.
- [`[345276c]`](https://github.com/dotnet/corefx/commit/345276c) Remove unnecessry null check in DomainNameHelper
- [`[7f1119d]`](https://github.com/dotnet/corefx/commit/7f1119d) Adding some nameof uses, improving exceptions with indexes, and centralizing formatting of paramName and index.
- [`[f5e1650]`](https://github.com/dotnet/corefx/commit/f5e1650) Update buildtools version.
- [`[04d3174]`](https://github.com/dotnet/corefx/commit/04d3174) Remove unnecessary usings.
- [`[db0437b]`](https://github.com/dotnet/corefx/commit/db0437b) Change specialized collections tests to match current implementation.
- [`[370f88f]`](https://github.com/dotnet/corefx/commit/370f88f) Fix ListDictionary.Copy implementation in .NETCore to match Desktop.
- [`[e6a59c5]`](https://github.com/dotnet/corefx/commit/e6a59c5) Fix NodeKeyValueCollection.CopyTo implementation in .NETCore to match Desktop.
- [`[2dc272b]`](https://github.com/dotnet/corefx/commit/2dc272b) Respond to PR feedback.
- [`[193dbf7]`](https://github.com/dotnet/corefx/commit/193dbf7) Update xunit.netcore.extensions version.
- [`[7faaac4]`](https://github.com/dotnet/corefx/commit/7faaac4) Fix picking the correct platform tests for net46 runs.
- [`[e4fcf25]`](https://github.com/dotnet/corefx/commit/e4fcf25) Skip Debug tests on Desktop.
- [`[a273149]`](https://github.com/dotnet/corefx/commit/a273149) CodePages: Remove unnecessary use of unsafe
- [`[5d6658b]`](https://github.com/dotnet/corefx/commit/5d6658b) Harden Unix GetAllNetworkInterfaces against some error conditions.
- [`[fe736e7]`](https://github.com/dotnet/corefx/commit/fe736e7) Remove UWP meta-package reference and replace with latest contents from the package's dependencies Expand Microsoft.NetCore into its dependencies (except those already expressed above)
- [`[568b066]`](https://github.com/dotnet/corefx/commit/568b066) Use GetDeclaredMethod for cloning
- [`[704fab3]`](https://github.com/dotnet/corefx/commit/704fab3) More test coverage for nullable Comparers
- [`[2f6f9c3]`](https://github.com/dotnet/corefx/commit/2f6f9c3) Respond to PR feedback
- [`[d371832]`](https://github.com/dotnet/corefx/commit/d371832) Add some tests for Comparer<T>
- [`[b39ba74]`](https://github.com/dotnet/corefx/commit/b39ba74) Make PathInternal.HasIllegalCharacters implementation faster on Windows
- [`[59e41af]`](https://github.com/dotnet/corefx/commit/59e41af) Fix System.Runtime.Test for 32bit architecture (#11245)
- [`[f36087f]`](https://github.com/dotnet/corefx/commit/f36087f) fix coreclr issue #7005
- [`[fd80aea]`](https://github.com/dotnet/corefx/commit/fd80aea) Update buildtools to 1.0.26-prerelease-00730-03
- [`[2c1f067]`](https://github.com/dotnet/corefx/commit/2c1f067) Remove use of PackageDestination
- [`[73b7651]`](https://github.com/dotnet/corefx/commit/73b7651) Add test for Marshal.GetHRForException (#11168)
- [`[c3042ed]`](https://github.com/dotnet/corefx/commit/c3042ed) Remove PackageTargetFramework usage
- [`[591a120]`](https://github.com/dotnet/corefx/commit/591a120) Fix some finalizes that occur in the X509 tests due to tests not calling Dispose
- [`[8da44cf]`](https://github.com/dotnet/corefx/commit/8da44cf) Don't dispose the system certs store before making a system trust decision
- [`[d5bc38a]`](https://github.com/dotnet/corefx/commit/d5bc38a) Add a test to check for a root cert being findable under validOnly
- [`[1b637ea]`](https://github.com/dotnet/corefx/commit/1b637ea) Changing Dequeue method commend to reflect method behaviour. Dequeue throws InvalidOperationException when queue is empty
- [`[7c6d12b]`](https://github.com/dotnet/corefx/commit/7c6d12b) Verify static NETNative targeting pack version, 1.0.1-beta-24430-00.
- [`[8dcf948]`](https://github.com/dotnet/corefx/commit/8dcf948) Target compatible NuGet moniker
- [`[6298927]`](https://github.com/dotnet/corefx/commit/6298927) Remove dead code in XmlSerializationReaderILGen
- [`[1a92281]`](https://github.com/dotnet/corefx/commit/1a92281) Fix ProcessThread.TestStartTimeProperty flakiness
- [`[e676fea]`](https://github.com/dotnet/corefx/commit/e676fea) Change expected parameter name from count -> length for CompareOrdinal
- [`[256c15e]`](https://github.com/dotnet/corefx/commit/256c15e) Typo in EmailAddressAttribute comment: "if" instead of "is"
- [`[14de3a4]`](https://github.com/dotnet/corefx/commit/14de3a4) Fix misleading message in SafeDeleteContext assert
- [`[9e2fd18]`](https://github.com/dotnet/corefx/commit/9e2fd18) Remove unnecessary duplicate expression in assert
- [`[3e1c10e]`](https://github.com/dotnet/corefx/commit/3e1c10e) Remove dead code in Interop.LSAStructs.cs
- [`[d9b6b51]`](https://github.com/dotnet/corefx/commit/d9b6b51) Fix EventHandlerList indexer
- [`[e07f45d]`](https://github.com/dotnet/corefx/commit/e07f45d) Avoid losing precision in Process.StartTime on OSX
- [`[79bd427]`](https://github.com/dotnet/corefx/commit/79bd427) Docs: Add /p:OSGroup to performance testing parameters
- [`[ede4278]`](https://github.com/dotnet/corefx/commit/ede4278) DeflateStream: Allow inflation without input
- [`[e2f5a3c]`](https://github.com/dotnet/corefx/commit/e2f5a3c) Resolve aliased device names in SystemNative_EnumerateInterfaceAddresses.
- [`[dad4ae1]`](https://github.com/dotnet/corefx/commit/dad4ae1) Implements GetBlobReader for StringHandle (#11214)
- [`[1f91319]`](https://github.com/dotnet/corefx/commit/1f91319) ARM-CI:Enable automatic checks of PRs again
- [`[17d2098]`](https://github.com/dotnet/corefx/commit/17d2098) Reduce compiled size of HttpKnownHeaderNames.TryGetHeaderName
- [`[3e0888e]`](https://github.com/dotnet/corefx/commit/3e0888e) Remove use of the modulo operator in Queue.Enumerator (#11101)
- [`[214bc4e]`](https://github.com/dotnet/corefx/commit/214bc4e) Add init-tools output to standard output (#11201)
- [`[0ed37cf]`](https://github.com/dotnet/corefx/commit/0ed37cf) Fix missing System.Private.Uri dependencies
- [`[e74f271]`](https://github.com/dotnet/corefx/commit/e74f271) Flattening ValueTuple test folder and update following mscorlib (#11150)
- [`[14f5473]`](https://github.com/dotnet/corefx/commit/14f5473) Address PR feedback
- [`[1979d8f]`](https://github.com/dotnet/corefx/commit/1979d8f) Remove UpdateInvalidPackageVersions from Run command, fix doc.
- [`[14c8ddd]`](https://github.com/dotnet/corefx/commit/14c8ddd) Enhance LoopbackServer to return received data
- [`[83368ed]`](https://github.com/dotnet/corefx/commit/83368ed) Add native pkgprojs for Fedora 24
- [`[099a264]`](https://github.com/dotnet/corefx/commit/099a264) Adding support for emitting nullable constants
- [`[51761e5]`](https://github.com/dotnet/corefx/commit/51761e5) MetadataReaderProvider should only reuse MetadataReader created with the same arguments (#11167)
- [`[37d5d9d]`](https://github.com/dotnet/corefx/commit/37d5d9d) Fix assert in pal_symmetric.cpp
- [`[3c9bba6]`](https://github.com/dotnet/corefx/commit/3c9bba6) Fix FVI handling of AssemblyInformationalVersionAttribute
- [`[edd9d30]`](https://github.com/dotnet/corefx/commit/edd9d30) Fix ImmutableArray.Builder.Sort(Comparer) to pass correct bounds
- [`[6f3cc3a]`](https://github.com/dotnet/corefx/commit/6f3cc3a) Add internal AsyncBuilderAttribute to ValueTask
- [`[f0f4fd7]`](https://github.com/dotnet/corefx/commit/f0f4fd7) Disable failing ServerAsyncAuthenticate test on macOS
- [`[726f62a]`](https://github.com/dotnet/corefx/commit/726f62a) update bt version to 1.0.26-prerelease-00725-02
- [`[429dfa4]`](https://github.com/dotnet/corefx/commit/429dfa4) Fix WinHttpHandler uri escaping for HTTP requests
- [`[6445e82]`](https://github.com/dotnet/corefx/commit/6445e82) Enable init-tools option to suppress non-error output from the console output (#11059)
- [`[075db2f]`](https://github.com/dotnet/corefx/commit/075db2f) Fix a couple of typos in PortablePdb-Metadata.md
- [`[c8336a7]`](https://github.com/dotnet/corefx/commit/c8336a7) Add native pkgprojs for Ubuntu 16.10
- [`[5a1d55a]`](https://github.com/dotnet/corefx/commit/5a1d55a) Add native pkgprojs for openSUSE 42.1
- [`[847df52]`](https://github.com/dotnet/corefx/commit/847df52) De-duplicate certificates when reading from a Unix X509 store
- [`[0743d94]`](https://github.com/dotnet/corefx/commit/0743d94) Implements PEReader.TryOpenAssociatedPortablePdb (#11031)
- [`[bdc37d4]`](https://github.com/dotnet/corefx/commit/bdc37d4) Add missing #include
- [`[b4cefcb]`](https://github.com/dotnet/corefx/commit/b4cefcb) Normalize ccStatus out parameter name.
- [`[d03650d]`](https://github.com/dotnet/corefx/commit/d03650d) PR feedback
- [`[363c45c]`](https://github.com/dotnet/corefx/commit/363c45c) Correct parameter name.
- [`[256c835]`](https://github.com/dotnet/corefx/commit/256c835) Reducing code duplication
- [`[703eccc]`](https://github.com/dotnet/corefx/commit/703eccc) Add Set in the property. (#11102)
- [`[ec8080d]`](https://github.com/dotnet/corefx/commit/ec8080d) Prevent crash when Openssl's PKCS12_parse function fails.
- [`[3359ff2]`](https://github.com/dotnet/corefx/commit/3359ff2) Allow Ubuntu 16.10 to initialize tools
- [`[f42fd10]`](https://github.com/dotnet/corefx/commit/f42fd10) Use -Werror in configure.cmake
- [`[31d9022]`](https://github.com/dotnet/corefx/commit/31d9022) Addressing feedback and updating versions
- [`[9413087]`](https://github.com/dotnet/corefx/commit/9413087) Implement 3DES and AES with CommonCrypto
- [`[529f028]`](https://github.com/dotnet/corefx/commit/529f028) Tests using a cleared environment for RemoteInvoke copy over LD_LIBRARY_PATH
- [`[4593773]`](https://github.com/dotnet/corefx/commit/4593773) Fix DefaultWebProxy_VerifyDefaults_Success test
- [`[6b86f1d]`](https://github.com/dotnet/corefx/commit/6b86f1d) Adding the SqlClient Stress Test framework. Providers can hook into this framework and provide their tests
- [`[e69b6d5]`](https://github.com/dotnet/corefx/commit/e69b6d5) Disable NoSocketsReuseUnicastPortSupport tests
- [`[e0465ab]`](https://github.com/dotnet/corefx/commit/e0465ab) Update buildtools to 1.0.26-prerelease-00723-03
- [`[eed4ee1]`](https://github.com/dotnet/corefx/commit/eed4ee1) Use PackageVersion instead of Version for pkgproj
- [`[9cd6cbc]`](https://github.com/dotnet/corefx/commit/9cd6cbc) Provide a package index for CoreFx
- [`[32a2212]`](https://github.com/dotnet/corefx/commit/32a2212) Fix assembly version of Unsafe
- [`[765ea59]`](https://github.com/dotnet/corefx/commit/765ea59) Clean up redundant AssemblyVersion properties
- [`[564fe49]`](https://github.com/dotnet/corefx/commit/564fe49) Rebaseline native dependencies to latest
- [`[f3a3ceb]`](https://github.com/dotnet/corefx/commit/f3a3ceb) Increment non-standard versioned packages
- [`[589f5a1]`](https://github.com/dotnet/corefx/commit/589f5a1) Central nupkg versioning & library assm versioning
- [`[3b45360]`](https://github.com/dotnet/corefx/commit/3b45360) Change the check range for BaseAddress and EntryPointAddress
- [`[c3a3681]`](https://github.com/dotnet/corefx/commit/c3a3681) Allow to use clang 3.9 in build-native.sh
- [`[1d04509]`](https://github.com/dotnet/corefx/commit/1d04509) On Linux, we were reporting the starting *stack* address for a thread via ProcessThread.StartAddress.  This property is supposed to return the *code* address of the start of the thread.  We have no way of getting that info on Linux, so we'll just report it as IntPtr.Zero, as we already do on OSX (and apparently sometimes on Windows).
- [`[a949151]`](https://github.com/dotnet/corefx/commit/a949151) Add boundary condition tests for the inputs to HashAlgorithm.ComputeHash
- [`[68a93df]`](https://github.com/dotnet/corefx/commit/68a93df) Small clarification to avoid any confusion
- [`[13d8332]`](https://github.com/dotnet/corefx/commit/13d8332) Add section on how to file security bugs
- [`[17bb1fc]`](https://github.com/dotnet/corefx/commit/17bb1fc) delete MsBuildParameters (#11066)
- [`[bc34228]`](https://github.com/dotnet/corefx/commit/bc34228) Add comment about ignoring poll failures
- [`[86d6f43]`](https://github.com/dotnet/corefx/commit/86d6f43) Fix for Issue#10155 & #10217 (#10598)
- [`[4f782d7]`](https://github.com/dotnet/corefx/commit/4f782d7) Add empty input tests for the SHA algorithms.
- [`[ae9e966]`](https://github.com/dotnet/corefx/commit/ae9e966) Implement digest and HMAC on CommonCrypto
- [`[cf883f7]`](https://github.com/dotnet/corefx/commit/cf883f7) Fix FindOidInfo to pass correct arg to PtrToStructure
- [`[e622857]`](https://github.com/dotnet/corefx/commit/e622857) Update build tools version to have a new "tools" structure for config.json file (#10864)
- [`[9217230]`](https://github.com/dotnet/corefx/commit/9217230) Add extra poll() call to work around issue in curl_multi_wait prior to version 7.32.0.
- [`[58c0adf]`](https://github.com/dotnet/corefx/commit/58c0adf) Add msbuild.log to archived outerloop jobs. Add msbuild.log archival even if build has failed.
- [`[4c7915d]`](https://github.com/dotnet/corefx/commit/4c7915d) Replace == with Equals for CultureInfo.
- [`[63d1ae0]`](https://github.com/dotnet/corefx/commit/63d1ae0) Annotate ValueTuple types as Auto layout
- [`[2192f6a]`](https://github.com/dotnet/corefx/commit/2192f6a) Address PR feedback from https://github.com/dotnet/corefx/pull/10542
- [`[ec115c5]`](https://github.com/dotnet/corefx/commit/ec115c5) Cleanup Max and MinLengthAttribute tests (#11024)
- [`[06184bc]`](https://github.com/dotnet/corefx/commit/06184bc) Cleanup System.Reflection.TypeExtensions.MemberInfo tests
- [`[6601504]`](https://github.com/dotnet/corefx/commit/6601504) Add tests for Char and Bool enums (as welll as other types) (#11015)
- [`[4b1a9f6]`](https://github.com/dotnet/corefx/commit/4b1a9f6) Glibc readdir_r() deprecated use readdir() (#10795)
- [`[273543f]`](https://github.com/dotnet/corefx/commit/273543f) Fix incorrect AssemblyName in System.Net.Primitives/PerformanceTests
- [`[8a18d94]`](https://github.com/dotnet/corefx/commit/8a18d94) Use TempFile
- [`[3f1154b]`](https://github.com/dotnet/corefx/commit/3f1154b) Added test for RegionInfo.NativeName (#10193)
- [`[0a8fd72]`](https://github.com/dotnet/corefx/commit/0a8fd72) Improve code coverage of System.Linq.Expressions.IndexExpression (#10634)
- [`[2b0c871]`](https://github.com/dotnet/corefx/commit/2b0c871) Cleanup System.Reflection.TypeExtensions.FieldInfo tests
- [`[eaa9608]`](https://github.com/dotnet/corefx/commit/eaa9608) Initial prototyping of produces api for corefx repo (#11003)
- [`[3ce9e22]`](https://github.com/dotnet/corefx/commit/3ce9e22) Address PR feedback
- [`[d9837d1]`](https://github.com/dotnet/corefx/commit/d9837d1) Improve test coverage for some string.Compare overloads (#10571)
- [`[ae53ab9]`](https://github.com/dotnet/corefx/commit/ae53ab9) Skip failing process test on Windows Nano. (#10979)
- [`[c91aa58]`](https://github.com/dotnet/corefx/commit/c91aa58) Add tests for invalid inputs to Expression.New (#10952)
- [`[3f76ba2]`](https://github.com/dotnet/corefx/commit/3f76ba2) Cleanup and add some CreditCardAttribute tests (#10993)
- [`[258b51d]`](https://github.com/dotnet/corefx/commit/258b51d) Add some tests for invalid inputs to MemberAccess expressions (#10940)
- [`[6f6f34d]`](https://github.com/dotnet/corefx/commit/6f6f34d) Further tests for String.Concat and String.Join (#10966)
- [`[3cf6999]`](https://github.com/dotnet/corefx/commit/3cf6999) Cleanup EnumDataTypeAttribute tests
- [`[0c1e3fb]`](https://github.com/dotnet/corefx/commit/0c1e3fb) Add and cleanup tests for DataTypeAttribute
- [`[bd497d6]`](https://github.com/dotnet/corefx/commit/bd497d6) RegistryKey: Flesh out tests
- [`[811e3b6]`](https://github.com/dotnet/corefx/commit/811e3b6) Add and cleanup CustomValidationAttribute tests
- [`[822a0e9]`](https://github.com/dotnet/corefx/commit/822a0e9) Update BuildToolsVersion.txt
- [`[502f2b1]`](https://github.com/dotnet/corefx/commit/502f2b1) Add some CompareAttributeTests
- [`[3f5d234]`](https://github.com/dotnet/corefx/commit/3f5d234) Cleanup AssociationAttributeTests
- [`[a32e549]`](https://github.com/dotnet/corefx/commit/a32e549) Add reference to issue #10989
- [`[3cd7bb1]`](https://github.com/dotnet/corefx/commit/3cd7bb1) Close streams when exceptions thrown in Dispose
- [`[8f26165]`](https://github.com/dotnet/corefx/commit/8f26165) RegistryKey.OpenSubKey should remove multiple/trailing slashes
- [`[09226d4]`](https://github.com/dotnet/corefx/commit/09226d4) WinHttpHandler: Avoid repeated Version allocations
- [`[16246fd]`](https://github.com/dotnet/corefx/commit/16246fd) Add HTTP/2 support to WinHttpHandler
- [`[471b638]`](https://github.com/dotnet/corefx/commit/471b638) Include diagnostic info to debug failure in CI.
- [`[44f12c1]`](https://github.com/dotnet/corefx/commit/44f12c1) Update BuildTools version to consume Roslyn compiler toolset update
- [`[58d30421]`](https://github.com/dotnet/corefx/commit/58d30421) Add missing license headers
- [`[8dbc732]`](https://github.com/dotnet/corefx/commit/8dbc732) Add fastpath for restore
- [`[e507775]`](https://github.com/dotnet/corefx/commit/e507775) Add back OS based import condition
- [`[5655325]`](https://github.com/dotnet/corefx/commit/5655325) Remove common properties from corefx, they have been added to buildtools
- [`[8dd079c]`](https://github.com/dotnet/corefx/commit/8dd079c) Cleanup System.Reflection.TypeExtensions.ConstructorInfo tests
- [`[c51f773]`](https://github.com/dotnet/corefx/commit/c51f773) Adding the Stress Test execution engine
- [`[d524416]`](https://github.com/dotnet/corefx/commit/d524416) Move System.Diagnostics.Debug.SymbolReader to coreclr repo.
- [`[1fd6dad]`](https://github.com/dotnet/corefx/commit/1fd6dad) Throw specific error messages for unsupported zip
- [`[cfbaa48]`](https://github.com/dotnet/corefx/commit/cfbaa48) Fix three failed DateTime array tests.
- [`[0de0f82]`](https://github.com/dotnet/corefx/commit/0de0f82) Revises TestAsyncHalfCharacterAtATime test (#10810)
- [`[32f3a12]`](https://github.com/dotnet/corefx/commit/32f3a12) Add tests for DebugInfoExpression and SymbolDocumentInfo in System.Linq.Expressions
- [`[45172b7]`](https://github.com/dotnet/corefx/commit/45172b7) Produce System.Security.Cryptography.Native.OpenSsl library and package
- [`[70c7642]`](https://github.com/dotnet/corefx/commit/70c7642) Cleanup Expression.Coalesce tests
- [`[0cc560e]`](https://github.com/dotnet/corefx/commit/0cc560e) Add some tests for Expression.Coalesce
- [`[424be5c]`](https://github.com/dotnet/corefx/commit/424be5c) Fix order of Assert.Equal args
- [`[e1d6989]`](https://github.com/dotnet/corefx/commit/e1d6989) Fix WebSocketException.SetErrorCodeOnError
- [`[cea2b84]`](https://github.com/dotnet/corefx/commit/cea2b84) Add full-version package dependency verification.
- [`[ce6561a]`](https://github.com/dotnet/corefx/commit/ce6561a) Fix bug in property System.Console.ConsolePal.Windows.WIndowTop
- [`[a118b9a]`](https://github.com/dotnet/corefx/commit/a118b9a) Revving xunit perf packages to fix perf test runs (#10869)
- [`[9130f83]`](https://github.com/dotnet/corefx/commit/9130f83) Fix for issue https://github.com/dotnet/wcf/issues/1340 (DataContract special-handling of KeyValuePair generic type): data contracts for the adapter and the original type do not get the same StableName (contract name)
- [`[6c81f5e]`](https://github.com/dotnet/corefx/commit/6c81f5e) Enable reading loaded PE file using a stream (#10863)
- [`[0afdb77]`](https://github.com/dotnet/corefx/commit/0afdb77) Make UriBuilder.Fragment setter idempotent
- [`[47405e8]`](https://github.com/dotnet/corefx/commit/47405e8) Address PR feedback
- [`[9894e0a]`](https://github.com/dotnet/corefx/commit/9894e0a) Address PR feedback
- [`[309a889]`](https://github.com/dotnet/corefx/commit/309a889) Enable per-commit arm64 build and test runs
- [`[1951413]`](https://github.com/dotnet/corefx/commit/1951413) Remove ValidationSuppression.txt files
- [`[1ec6349]`](https://github.com/dotnet/corefx/commit/1ec6349) Change condition for UseSharedCompilation
- [`[6975c68]`](https://github.com/dotnet/corefx/commit/6975c68) Cross compile System.Net.Http for Desktop
- [`[ad98f21]`](https://github.com/dotnet/corefx/commit/ad98f21) Disable three failing JSON serialization tests
- [`[4bec898]`](https://github.com/dotnet/corefx/commit/4bec898) Check for invariant culture before matching regex.
- [`[916f37b]`](https://github.com/dotnet/corefx/commit/916f37b) change nodoReuse to nodeReuse (#10803)
- [`[f2f264f]`](https://github.com/dotnet/corefx/commit/f2f264f) Implements support for reading loaded PE files (#10768)
- [`[7cc3f8e]`](https://github.com/dotnet/corefx/commit/7cc3f8e) Fix some typos on config.json (#10655)
- [`[7394233]`](https://github.com/dotnet/corefx/commit/7394233) Update BuildTools to 1.0.26-prerelease-00715-01
- [`[c4d34a7]`](https://github.com/dotnet/corefx/commit/c4d34a7) Fixed rebasing errors.
- [`[a71825e]`](https://github.com/dotnet/corefx/commit/a71825e) Addressed Code Review Feedback for #9797.
- [`[dae038a]`](https://github.com/dotnet/corefx/commit/dae038a) Add Support for DataMember.EmitDefaultValue.
- [`[654fd7d]`](https://github.com/dotnet/corefx/commit/654fd7d) Refactor ReflectionXml(Json)FormatWriter.
- [`[35ba9cd]`](https://github.com/dotnet/corefx/commit/35ba9cd) Enable RBS for DCJS on NetNative.
- [`[27c5a50]`](https://github.com/dotnet/corefx/commit/27c5a50) Added new tests for DCJS.
- [`[16c7a07]`](https://github.com/dotnet/corefx/commit/16c7a07) Refactor ReflectionReader.
- [`[5cef5f7]`](https://github.com/dotnet/corefx/commit/5cef5f7) Enabled Reflection Based Serialization for DCJS.
- [`[683e8c3]`](https://github.com/dotnet/corefx/commit/683e8c3) Enabled Reflection Based De-serialization for DCJS.
- [`[dedf1e5]`](https://github.com/dotnet/corefx/commit/dedf1e5) Renaming in AccessorBuilder.
- [`[f206ef0]`](https://github.com/dotnet/corefx/commit/f206ef0) Optimized Perf of Using PrimitiveDataContract.GetPrimitiveDataContract.
- [`[cc4675e]`](https://github.com/dotnet/corefx/commit/cc4675e) Added a perf test for type with fields.
- [`[ab24e4d]`](https://github.com/dotnet/corefx/commit/ab24e4d) Improved ReflectionWriteCollection's Performance.
- [`[d526c7f]`](https://github.com/dotnet/corefx/commit/d526c7f) Perf Improvements on ReflectionGetMemberValue().
- [`[7345f28]`](https://github.com/dotnet/corefx/commit/7345f28) Removed unnecessary global vairables from ReflectionXmlFormatWriter.
- [`[b4c8418]`](https://github.com/dotnet/corefx/commit/b4c8418) Improved ReflectionTryWritePrimitive for collections.
- [`[1ed4c68]`](https://github.com/dotnet/corefx/commit/1ed4c68) Addressed feedback for PR #9547.
- [`[b396177]`](https://github.com/dotnet/corefx/commit/b396177) Added Tests for Struct with Properties.
- [`[2d47226]`](https://github.com/dotnet/corefx/commit/2d47226) Improved ReflectionSetMemberValue for Value Types.
- [`[4452535]`](https://github.com/dotnet/corefx/commit/4452535) Refactor ReflectionSetMemberValue.
- [`[3657bd5]`](https://github.com/dotnet/corefx/commit/3657bd5) Refactor the Code.
- [`[fe80661]`](https://github.com/dotnet/corefx/commit/fe80661) Added perf optimization for De-Serializing KeyValue type.
- [`[8ea1cbd]`](https://github.com/dotnet/corefx/commit/8ea1cbd) Performance Improvements on De-Serialization.
- [`[5d60755]`](https://github.com/dotnet/corefx/commit/5d60755) Add Perf Tests for Varied Collections of SimpleType.
- [`[7a28d17]`](https://github.com/dotnet/corefx/commit/7a28d17) Add regression test for 6600
- [`[e27e464]`](https://github.com/dotnet/corefx/commit/e27e464) Addressed Feedback for PR #9333.
- [`[a50224e]`](https://github.com/dotnet/corefx/commit/a50224e) Fixed DCS_CustomType in Net Native.
- [`[244c074]`](https://github.com/dotnet/corefx/commit/244c074) Changed rd.xml to Keep Metadata for KeyValuePairAdapter.
- [`[7d85e0f]`](https://github.com/dotnet/corefx/commit/7d85e0f) Fixed a bug with Serializing Nullable types.
- [`[eb86ebd]`](https://github.com/dotnet/corefx/commit/eb86ebd) Fixed an issue with GenericCollection de-serialization.
- [`[c2e5734]`](https://github.com/dotnet/corefx/commit/c2e5734) Fixing regression of DateTime test in CodeGenOnly mode.
- [`[ed2e402]`](https://github.com/dotnet/corefx/commit/ed2e402) Fixed issue with CreateXmlSerializableDelegate in Net Native.
- [`[d9566fe]`](https://github.com/dotnet/corefx/commit/d9566fe) Made changes based on feedback for PR #8742.
- [`[98927b9]`](https://github.com/dotnet/corefx/commit/98927b9) Fixed DCS_ExceptionObject.
- [`[8e35f16]`](https://github.com/dotnet/corefx/commit/8e35f16) Fixed DCS_MyDataContractResolver.
- [`[b8fe0b5]`](https://github.com/dotnet/corefx/commit/b8fe0b5) Fixed DCS_DuplicatedKeyXmlQualifiedName.
- [`[2561e27]`](https://github.com/dotnet/corefx/commit/2561e27) Fixed DCS_TypeWithCommonTypeProperties.
- [`[18deb8c]`](https://github.com/dotnet/corefx/commit/18deb8c) Fixed DCS_SystemVersion.
- [`[9d2bd5b]`](https://github.com/dotnet/corefx/commit/9d2bd5b) Fixed DCS_TypeWithUriTypeProperty.
- [`[eb43895]`](https://github.com/dotnet/corefx/commit/eb43895) Implemented ReflectionReadGetOnlyCollection.
- [`[f3bb43e]`](https://github.com/dotnet/corefx/commit/f3bb43e) Fixed 2 Tests.
- [`[2371117]`](https://github.com/dotnet/corefx/commit/2371117) Fixed 3 failed tests.
- [`[cf83e48]`](https://github.com/dotnet/corefx/commit/cf83e48) Fixed 3 failed tests.
- [`[1481b5b]`](https://github.com/dotnet/corefx/commit/1481b5b) Fixed 9 failed tests.
- [`[002de2b]`](https://github.com/dotnet/corefx/commit/002de2b) Fixed 3 Tests.
- [`[e42e428]`](https://github.com/dotnet/corefx/commit/e42e428) Fixed DCS_DictionaryMembers.
- [`[32ead9a]`](https://github.com/dotnet/corefx/commit/32ead9a) Fixed DCS_DictionaryGenericMembers.
- [`[33aa801]`](https://github.com/dotnet/corefx/commit/33aa801) Fixing regression of KeyValuePair test in CodeGenOnly mode.
- [`[63213e9]`](https://github.com/dotnet/corefx/commit/63213e9) Fixed issues in NetNative.
- [`[7c8b390]`](https://github.com/dotnet/corefx/commit/7c8b390) Setting ReflectionAsBackup as default.
- [`[4890b4e]`](https://github.com/dotnet/corefx/commit/4890b4e) 1. Updating for .NET Native; 2. Adding SerializationOption.
- [`[a01854c]`](https://github.com/dotnet/corefx/commit/a01854c) ReflectionBasedDCS: Fix 5 test failures, MemberInfo, DateTimeOffset, KeyValuePair
- [`[eadc19d]`](https://github.com/dotnet/corefx/commit/eadc19d) Update tests with ActiveIssue
- [`[b2c7fcf]`](https://github.com/dotnet/corefx/commit/b2c7fcf) Fix 2 test failures
- [`[a627e19]`](https://github.com/dotnet/corefx/commit/a627e19) Data contract serialization based on reflection without involving code gen.
- [`[652c818]`](https://github.com/dotnet/corefx/commit/652c818) Fix XML comments in ManagedWebSocket
- [`[7472f96]`](https://github.com/dotnet/corefx/commit/7472f96) Disable TryGetAddrInfo_HostName_TryGetNameInfo test on Unix
- [`[ca0b35c]`](https://github.com/dotnet/corefx/commit/ca0b35c) HttpClient: Use string.Concat over string.Format
- [`[49e569b]`](https://github.com/dotnet/corefx/commit/49e569b) Update CoreClr, CoreFx to beta-24413-03, beta-24413-01, respectively (#10753)
- [`[d194c64]`](https://github.com/dotnet/corefx/commit/d194c64) Add options for running selected tests
- [`[6c90f64]`](https://github.com/dotnet/corefx/commit/6c90f64) Update CoreClr, CoreFx, External to beta-24412-03, beta-24412-02, beta-24412-00, respectively (#10735)
- [`[f0674d8]`](https://github.com/dotnet/corefx/commit/f0674d8) Use the CommonCrypto CSPRNG on macOS
- [`[f7d2ae7]`](https://github.com/dotnet/corefx/commit/f7d2ae7) Remove the warning from the test execution.
- [`[19c1a45]`](https://github.com/dotnet/corefx/commit/19c1a45) Revert to older S.R.Serialization.Primitives references
- [`[d9586e6]`](https://github.com/dotnet/corefx/commit/d9586e6) Revert "Add StreamingContext public APIs back to contract"
- [`[69978e4]`](https://github.com/dotnet/corefx/commit/69978e4) Renable DefaultContext test
- [`[5211084]`](https://github.com/dotnet/corefx/commit/5211084) Fix LoadFromAssemblyName usage to account for DefaultContext binding.
- [`[fdf45b6]`](https://github.com/dotnet/corefx/commit/fdf45b6) Correcting the typename as expected by ApiCompat
- [`[01e8ebb]`](https://github.com/dotnet/corefx/commit/01e8ebb) Update BuildToolsVersion.txt
- [`[76710cb]`](https://github.com/dotnet/corefx/commit/76710cb) Missed UnManagedType.LPUTF8Str in last commit.
- [`[b5fb00c]`](https://github.com/dotnet/corefx/commit/b5fb00c) Disable Default Context Test
- [`[34e417a]`](https://github.com/dotnet/corefx/commit/34e417a) Add compilation and invoking an expression
- [`[556d166]`](https://github.com/dotnet/corefx/commit/556d166) Fix minor bug in `clean.sh`
- [`[51b25b3]`](https://github.com/dotnet/corefx/commit/51b25b3) Add size checks for packet size parsed out in ConsumePreloginHandshake
- [`[0cb5905]`](https://github.com/dotnet/corefx/commit/0cb5905) Include test-runtime project.json in test archives.
- [`[4c4c949]`](https://github.com/dotnet/corefx/commit/4c4c949) Fix test build break with Roslyn compiler update to 2.0.0-beta3
- [`[ec85de2]`](https://github.com/dotnet/corefx/commit/ec85de2) Workaround for possible crossgen bug (#10682)
- [`[14f98b5]`](https://github.com/dotnet/corefx/commit/14f98b5) Fix the conditional for building System.Security.Cryptography.Native.Apple
- [`[d6e9726]`](https://github.com/dotnet/corefx/commit/d6e9726) Enable daily builds for arm64
- [`[8a333d6]`](https://github.com/dotnet/corefx/commit/8a333d6) Seed System.Security.Cryptography.Native.Apple.dylib and package
- [`[000a780]`](https://github.com/dotnet/corefx/commit/000a780) Increase Enum Test Coverage (#10669)
- [`[80d9013]`](https://github.com/dotnet/corefx/commit/80d9013) Fixed incorrect x64 #import for ol.7.0 RID
- [`[be7ba88]`](https://github.com/dotnet/corefx/commit/be7ba88) Use versions repo tooling from BuildTools.
- [`[89fa6ee]`](https://github.com/dotnet/corefx/commit/89fa6ee) Review Serialize signatures (#10637)
- [`[3849c6a]`](https://github.com/dotnet/corefx/commit/3849c6a) Fix processing misaligned floats and doubles in System.Reflection.Metadata (#10638)
- [`[9aa4fc8]`](https://github.com/dotnet/corefx/commit/9aa4fc8) Reorder Assert parameters
- [`[a2d7053]`](https://github.com/dotnet/corefx/commit/a2d7053) HttpClient: Remove internal dead code
- [`[bcc0579]`](https://github.com/dotnet/corefx/commit/bcc0579) HttpClient: Faster whitespace detection
- [`[dbbeb7a]`](https://github.com/dotnet/corefx/commit/dbbeb7a) Improve code coverage for System.Linq.Expressions.CoalesceConversionBinaryExpression #1198
- [`[3a946e2]`](https://github.com/dotnet/corefx/commit/3a946e2) Cleanup System.Reflection.TypeExtensions.EventInfo tests
- [`[951a499]`](https://github.com/dotnet/corefx/commit/951a499) Test to validate loading of static assembly from a RefEmitted assembly.
- [`[6b06af6]`](https://github.com/dotnet/corefx/commit/6b06af6) Remove dependency on System.ValueTuple (#10616)
- [`[983dcf4]`](https://github.com/dotnet/corefx/commit/983dcf4) Use 2.0.0-beta3 roslyn compilers
- [`[baf01ce]`](https://github.com/dotnet/corefx/commit/baf01ce) Fix a Bug with Serializing Types with Non-Public Default Ctor.
- [`[45e9778]`](https://github.com/dotnet/corefx/commit/45e9778) Clean up restore warnings
- [`[df86cae]`](https://github.com/dotnet/corefx/commit/df86cae) Update Buildtools to 704-03 and partially remove warnings related to conflicts
- [`[4b62c0b]`](https://github.com/dotnet/corefx/commit/4b62c0b) Reducing array allocations in expression interpreter.
- [`[6925728]`](https://github.com/dotnet/corefx/commit/6925728) Updating CoreClr dependencies to beta-24403-05
- [`[0a3c434]`](https://github.com/dotnet/corefx/commit/0a3c434) Implements StackTrace support for Embedded Portable PDB (#10559)
- [`[8415c4d]`](https://github.com/dotnet/corefx/commit/8415c4d) Update to PPDB spec for change in embedded source blob format
- [`[ce63328]`](https://github.com/dotnet/corefx/commit/ce63328) Update build tools to 1.0.26-prerelease-00704-01
- [`[edc7b70]`](https://github.com/dotnet/corefx/commit/edc7b70) add parameter --numproc
- [`[966d960]`](https://github.com/dotnet/corefx/commit/966d960) add defaults and options to pass parameters to the script
- [`[f5c2908]`](https://github.com/dotnet/corefx/commit/f5c2908) support running src/native/build-native.cmd
- [`[5fcc1d7]`](https://github.com/dotnet/corefx/commit/5fcc1d7) Add unsafe operations for ref returns and locals (#10540)
- [`[8ba5dbe]`](https://github.com/dotnet/corefx/commit/8ba5dbe) Cleanup System.Reflection.Assembly tests
- [`[03c7153]`](https://github.com/dotnet/corefx/commit/03c7153) Add some tests to System.Reflection.Emit
- [`[7b26e49]`](https://github.com/dotnet/corefx/commit/7b26e49) Undeprecate Marshal APIs that were deprecated in favor of T version
- [`[0547760]`](https://github.com/dotnet/corefx/commit/0547760) Support metadata from certificates with no Algorithm.Parameters values
- [`[b39944b]`](https://github.com/dotnet/corefx/commit/b39944b) fixing issue 10535 (#10536)
- [`[cca213b]`](https://github.com/dotnet/corefx/commit/cca213b) Prepare for picking up package harvesting tools
- [`[2674f14]`](https://github.com/dotnet/corefx/commit/2674f14) Add ARM64 private jobs to Jenkins.
- [`[3f64d33]`](https://github.com/dotnet/corefx/commit/3f64d33) Enabling multi metric support for perf tests (#10529)
- [`[f520d02]`](https://github.com/dotnet/corefx/commit/f520d02) pr feedback
- [`[493c551]`](https://github.com/dotnet/corefx/commit/493c551) Fix ResolveSequencePoint return type (#10145)
- [`[1f3499c]`](https://github.com/dotnet/corefx/commit/1f3499c) set __CrossBuild in src/Native/build-native.sh automatically
- [`[59d7bfb]`](https://github.com/dotnet/corefx/commit/59d7bfb) set __Crossbuild in src/Native/build-native.sh automatically
- [`[868e4b9]`](https://github.com/dotnet/corefx/commit/868e4b9) set __Crossbuild in src/Native/build-native.sh automatically
- [`[0f67eec]`](https://github.com/dotnet/corefx/commit/0f67eec) set crossbuild
- [`[053d8f7]`](https://github.com/dotnet/corefx/commit/053d8f7) Publicize some BlobReader helpers add ReadBytes to existing array (#10184)
- [`[7a22b93]`](https://github.com/dotnet/corefx/commit/7a22b93) Renaming ZeroFreeMemoryUTF8 to ZeroFreeCoTaskMemUTF8
- [`[521334b]`](https://github.com/dotnet/corefx/commit/521334b) change to non-windows
- [`[db07856]`](https://github.com/dotnet/corefx/commit/db07856) Allow netcoreapp1.1 as a valid TestTFM
- [`[491a375]`](https://github.com/dotnet/corefx/commit/491a375) Add SourceLink CDI spec
- [`[1c7a1e0]`](https://github.com/dotnet/corefx/commit/1c7a1e0) fixes for ManagedWebSocket server mode
- [`[bb56ba4]`](https://github.com/dotnet/corefx/commit/bb56ba4) update documentation
- [`[c9d2243]`](https://github.com/dotnet/corefx/commit/c9d2243) Add `--sequential` option to `run-test.sh` (#9863)
- [`[c2dcb9f]`](https://github.com/dotnet/corefx/commit/c2dcb9f) ARM-CI : Check a device is already mounted while mounting a device.
- [`[6228073]`](https://github.com/dotnet/corefx/commit/6228073) Using IArgumentProvider in more places to avoid allocation of collections.
- [`[6037d74]`](https://github.com/dotnet/corefx/commit/6037d74) Fixing write-back behavior for mutable structs in lambda compiler.
- [`[9b04bcb]`](https://github.com/dotnet/corefx/commit/9b04bcb) Clean up method body encoding APIs (#10386)
- [`[445337e]`](https://github.com/dotnet/corefx/commit/445337e) Update build tools version (#10436)
- [`[864924f]`](https://github.com/dotnet/corefx/commit/864924f) Clean up SymbolReader project
- [`[f788f8d]`](https://github.com/dotnet/corefx/commit/f788f8d) Fix typos in build.sh
- [`[ef687c3]`](https://github.com/dotnet/corefx/commit/ef687c3) Use package reports to produce flat layouts of different targets
- [`[bd37ac4]`](https://github.com/dotnet/corefx/commit/bd37ac4) Modify variable ROOTFS_DIR to call both build-native and build-managed (#10407)
- [`[93232c9]`](https://github.com/dotnet/corefx/commit/93232c9) Update BuildTools 628-02
- [`[5a8db83]`](https://github.com/dotnet/corefx/commit/5a8db83) Add missing feed to NuGet.Config under src/
- [`[eff89c9]`](https://github.com/dotnet/corefx/commit/eff89c9) Change capital letters in ConfigurationGroup settings (#10401)
- [`[88ab486]`](https://github.com/dotnet/corefx/commit/88ab486) Fix arithmetic overflow exception
- [`[593c745]`](https://github.com/dotnet/corefx/commit/593c745) Fix the flags passed to getnameinfo We were trying to pass NI_NAMEREQD to getnameinfo so that it would fail if the address could not be resolved.  However, the PAL->Native translation was backward, resulting in the wrong flags getting passed.
- [`[7e2bd07]`](https://github.com/dotnet/corefx/commit/7e2bd07) Changing dev workflow scripts to use the Run Command Tool (#10231)
- [`[230f183]`](https://github.com/dotnet/corefx/commit/230f183) Use tuples in APIs that return multiple values instead of out parameters (#9505)
- [`[c64f892]`](https://github.com/dotnet/corefx/commit/c64f892) Fix lineup version
- [`[8261670]`](https://github.com/dotnet/corefx/commit/8261670) Add ARM64 to Windows Native build
- [`[ae8a5bd]`](https://github.com/dotnet/corefx/commit/ae8a5bd) ARM-CI : Add logging for getting the reason of unmounting issue.
- [`[b465208]`](https://github.com/dotnet/corefx/commit/b465208) Change documentation to unify windows and non-windows instructions and reflect the usage of run.exe
- [`[a4ff8a4]`](https://github.com/dotnet/corefx/commit/a4ff8a4) Throw InvalidProgram on static field list/member bind in interpreter
- [`[3584238]`](https://github.com/dotnet/corefx/commit/3584238) Throw InvalidProgram on static property list/member bind in interpreter
- [`[e70c71c]`](https://github.com/dotnet/corefx/commit/e70c71c) Allow bind to static field in interpreter.
- [`[f319ff4]`](https://github.com/dotnet/corefx/commit/f319ff4) Throw InvalidProgram on static property bind in interpreter.
- [`[76048d1]`](https://github.com/dotnet/corefx/commit/76048d1) Throw NotSupportedException for binding to constant fields in interpreter.
- [`[6755d93]`](https://github.com/dotnet/corefx/commit/6755d93) Update tests wrt issue 5963.
- [`[7ed55c8]`](https://github.com/dotnet/corefx/commit/7ed55c8) porting recent CoreCLR changes to .Net Native
- [`[c61127f]`](https://github.com/dotnet/corefx/commit/c61127f) Add osx.10.12 ("macOS Sierra") to RID graph.
- [`[cb217c0]`](https://github.com/dotnet/corefx/commit/cb217c0) Add four new Linux RIDs.
- [`[0c351ce]`](https://github.com/dotnet/corefx/commit/0c351ce) Order validation (#10316)
- [`[d4fa469]`](https://github.com/dotnet/corefx/commit/d4fa469) We shipped assembly file version 4.6.x up until the end of rc3.  Vers… (#10306)
- [`[0f0f142]`](https://github.com/dotnet/corefx/commit/0f0f142) Fix merge conflicts and package version mismatches
- [`[2a7dcbb]`](https://github.com/dotnet/corefx/commit/2a7dcbb) Fixing NameResolution initialization for Windows. Fixing the ParallelTestExecution script.
- [`[5aaec0e]`](https://github.com/dotnet/corefx/commit/5aaec0e) Remove AssemblyVersionTransition property
- [`[f26f358]`](https://github.com/dotnet/corefx/commit/f26f358) Consolidate depproj for S.Runtime.InteropServices
- [`[3a84f11]`](https://github.com/dotnet/corefx/commit/3a84f11) Test Update on ListInitExpression.
- [`[76fbb89]`](https://github.com/dotnet/corefx/commit/76fbb89) Test TypeAs expression is always not lifted.
- [`[ef1c29e]`](https://github.com/dotnet/corefx/commit/ef1c29e) Test optimised path for TypeEqual on constant null expressions.
- [`[cdc84c2]`](https://github.com/dotnet/corefx/commit/cdc84c2) Updating External dependencies to beta-24326-00, CoreFX to 24326-03
- [`[f7efb4c]`](https://github.com/dotnet/corefx/commit/f7efb4c) Prohibit address types from Convert/ConvertChecked expressions.
- [`[24725b6]`](https://github.com/dotnet/corefx/commit/24725b6) Prohibit open generic or address types on Expression.Catch
- [`[b65097b]`](https://github.com/dotnet/corefx/commit/b65097b) Fix a couple of small spelling mistakes
- [`[516328f]`](https://github.com/dotnet/corefx/commit/516328f) Change ActiveIssue to PlatformSpecific for closed issue #5832. (#10308)
- [`[9a2305d]`](https://github.com/dotnet/corefx/commit/9a2305d) Remove TODO comment from Socket ArgumentValidation tests (#10307)
- [`[c052356]`](https://github.com/dotnet/corefx/commit/c052356) Remove duplicate addresses from the result returned from getaddrinfo. (#10302)
- [`[055eb75]`](https://github.com/dotnet/corefx/commit/055eb75) Fix failure in MulticastInterface_Set_AnyInterface_Succeeds (#10303)
- [`[cc14f58]`](https://github.com/dotnet/corefx/commit/cc14f58) Cleanup some System.Reflection.Emit.ILGeneration tests (#9752)
- [`[55d5f94]`](https://github.com/dotnet/corefx/commit/55d5f94) Update master build tools to 625-01
- [`[67de226]`](https://github.com/dotnet/corefx/commit/67de226) Prohibit open generic or address types on Goto etc.
- [`[8dd94af]`](https://github.com/dotnet/corefx/commit/8dd94af) Updating CoreClr and CoreFX dependencies to beta-24325-02
- [`[9100c4b]`](https://github.com/dotnet/corefx/commit/9100c4b) Updating CoreFx dependencies to beta-24324-02, External to 24234-00
- [`[f31e84e]`](https://github.com/dotnet/corefx/commit/f31e84e) Add a test for the string constructor accepting an odd-addressed char*
- [`[6765e7b]`](https://github.com/dotnet/corefx/commit/6765e7b) Misc small Portable PDB changes (#10252)
- [`[81c3309]`](https://github.com/dotnet/corefx/commit/81c3309) Updating External dependencies to beta-24322-00, CoreFX to 24322-03
- [`[ec26857]`](https://github.com/dotnet/corefx/commit/ec26857) Remove two Sockets tests (#10224)
- [`[42422af]`](https://github.com/dotnet/corefx/commit/42422af) Implements support for Embedded Portable PDB (#10199)
- [`[309b2d2]`](https://github.com/dotnet/corefx/commit/309b2d2) Fix AsyncValueTaskMethodBuilder.Start behavior with ExecutionContext
- [`[0458fc9]`](https://github.com/dotnet/corefx/commit/0458fc9) Add AsyncValueTaskMethodBuilder in support of Roslyn feature
- [`[7ab8200]`](https://github.com/dotnet/corefx/commit/7ab8200) Updating BuildTools to fix Official build break
- [`[b7ee87e]`](https://github.com/dotnet/corefx/commit/b7ee87e) Fix crash on ARM due to incorrect marshalling ULONG64 to int
- [`[5f4008c]`](https://github.com/dotnet/corefx/commit/5f4008c) Disable two failing ValueTuple tests
- [`[35d3201]`](https://github.com/dotnet/corefx/commit/35d3201) Disable a bunch of failing ECCurve tests on Unix
- [`[265720a]`](https://github.com/dotnet/corefx/commit/265720a) Fix tests for CoreCLR 6269
- [`[9704a95]`](https://github.com/dotnet/corefx/commit/9704a95) Updating CoreClr dependencies to beta-24321-01
- [`[c912d26]`](https://github.com/dotnet/corefx/commit/c912d26) Moving Perf tests to their own csprojs (#10192)
- [`[6e7a5c2]`](https://github.com/dotnet/corefx/commit/6e7a5c2) Disable automatic package restore in VS
- [`[82e45aa]`](https://github.com/dotnet/corefx/commit/82e45aa) Disable outerloop runs on Windows 10
- [`[2b53fcd]`](https://github.com/dotnet/corefx/commit/2b53fcd) Updating BuildTools to get fix for Build Pipeline
- [`[5770a29]`](https://github.com/dotnet/corefx/commit/5770a29) Fix to ignore codename (arm-softfp)
- [`[c8c5adb]`](https://github.com/dotnet/corefx/commit/c8c5adb) Refactor ManagedWebSocket out of ClientWebSocket
- [`[73d65d1]`](https://github.com/dotnet/corefx/commit/73d65d1) Move ManagedWebSocket out from being an inner class
- [`[9eb7fdd]`](https://github.com/dotnet/corefx/commit/9eb7fdd) Enable masking on server-side
- [`[9946035]`](https://github.com/dotnet/corefx/commit/9946035) Move Send/Receive/Close/CloseOutputAsync argument validation into PAL
- [`[72394d6]`](https://github.com/dotnet/corefx/commit/72394d6) Change dispose logic of certificates in OpenSslX509ChainProcessor
- [`[aedc936]`](https://github.com/dotnet/corefx/commit/aedc936) Rename ManagedClientWebSocket to ManagedWebSocket
- [`[8c760a6]`](https://github.com/dotnet/corefx/commit/8c760a6) Add CLSCompliant(false) and remove stale tests
- [`[0773679]`](https://github.com/dotnet/corefx/commit/0773679) ARM-CI : Disabled automatic checks for resolving the unmounting error
- [`[3b09f98]`](https://github.com/dotnet/corefx/commit/3b09f98) Port Stream.CopyTo changes from CoreCLR
- [`[5cdf19c]`](https://github.com/dotnet/corefx/commit/5cdf19c) Update BuildToolsVersion
- [`[35b93e0]`](https://github.com/dotnet/corefx/commit/35b93e0) Fix Stopwatch test
- [`[8c82ca5]`](https://github.com/dotnet/corefx/commit/8c82ca5) Make flaky Stopwatch test more reliable
- [`[1994ac4]`](https://github.com/dotnet/corefx/commit/1994ac4) Fix FileStream.Flush on Unix when wrapping non-synchronizable descriptors
- [`[b729fff]`](https://github.com/dotnet/corefx/commit/b729fff) Fix two WebSocket issues on Unix
- [`[9f8da78]`](https://github.com/dotnet/corefx/commit/9f8da78) Cleans up TupleElementNamesAttribute
- [`[e5ebae2]`](https://github.com/dotnet/corefx/commit/e5ebae2) Update BuildTools to 615-07
- [`[1637422]`](https://github.com/dotnet/corefx/commit/1637422) Update Buildtools to version 615-01
- [`[4fe6945]`](https://github.com/dotnet/corefx/commit/4fe6945) Allow TupleElementNamesAttribute on events
- [`[b004564]`](https://github.com/dotnet/corefx/commit/b004564) Remove automatic curl Expect header if the request was explicitly set to not have one (#10052)
- [`[0dc395f]`](https://github.com/dotnet/corefx/commit/0dc395f) Update Builtools to 614-01
- [`[eccbe59]`](https://github.com/dotnet/corefx/commit/eccbe59) Add more rigorous testing for Stream.CopyTo (#9929)
- [`[6681e3c]`](https://github.com/dotnet/corefx/commit/6681e3c) Add delegate and MethodInfo invoke special case tests for optional parameters and args handling.
- [`[9853da4]`](https://github.com/dotnet/corefx/commit/9853da4) Fix serialization primitives version number in project.jsons
- [`[be3a0f7]`](https://github.com/dotnet/corefx/commit/be3a0f7) Updating External dependencies to beta-24314-00, CoreFX to 24314-02
- [`[11356d5]`](https://github.com/dotnet/corefx/commit/11356d5) Clean up and Format System.Collections
- [`[6885fa4]`](https://github.com/dotnet/corefx/commit/6885fa4) docs: Added documentation for building for Linux Emulator
- [`[8c62c72]`](https://github.com/dotnet/corefx/commit/8c62c72) Add Support For Xamarin and Mono for WCF Facades.
- [`[cb0becb]`](https://github.com/dotnet/corefx/commit/cb0becb) Adding server code. Fixing IIS application deployment.
- [`[8bd27ad]`](https://github.com/dotnet/corefx/commit/8bd27ad) Update portable pdb spec for embedded source (#10017)
- [`[af17a7a]`](https://github.com/dotnet/corefx/commit/af17a7a) Avoid wrapping async I/O in synchronous methods in the HTTP tests, as this can lead to ThreadPool starvation, causing tests to run longer (waiting for the ThreadPool to inject enough threads) and possibly to time out.
- [`[17c7db6]`](https://github.com/dotnet/corefx/commit/17c7db6) Set default FilterToTestTFM to be netcoreapp1.0 in CoreFx
- [`[e816952]`](https://github.com/dotnet/corefx/commit/e816952) Add StreamingContext public APIs back to contract
- [`[8633938]`](https://github.com/dotnet/corefx/commit/8633938) Add tests for Delegate.DynamicInvoke with default parameters
- [`[0b12bec]`](https://github.com/dotnet/corefx/commit/0b12bec) Update BuildTools to 613-01
- [`[579d542]`](https://github.com/dotnet/corefx/commit/579d542) Fixing Field intialization for Arm64
- [`[3debb53]`](https://github.com/dotnet/corefx/commit/3debb53) Add support for Ecc
- [`[0320a85]`](https://github.com/dotnet/corefx/commit/0320a85) Update BuildToolsVersion to 00612-01
- [`[e586f1b]`](https://github.com/dotnet/corefx/commit/e586f1b) Validate Xamarin frameworks
- [`[d93ce94]`](https://github.com/dotnet/corefx/commit/d93ce94) Add tests for MethodInfo.Invoke with default parameters
- [`[92b7f0b]`](https://github.com/dotnet/corefx/commit/92b7f0b) Xml Type with 2D Array property tests Add two tests to cover the scenario for serialization/deserialization for the object of the type with 2D array property This is to cover the test hole for this issue: dotnet/wcf#1274
- [`[65592cc]`](https://github.com/dotnet/corefx/commit/65592cc) Specify --no-cache on restore
- [`[ed5916a]`](https://github.com/dotnet/corefx/commit/ed5916a) Add System.Diagnostics.Debug.SymbolReader assembly.
- [`[2df67e0]`](https://github.com/dotnet/corefx/commit/2df67e0) Port List changes from dotnet/coreclr#6212 (#9987)
- [`[997dd70]`](https://github.com/dotnet/corefx/commit/997dd70) Windows.UI.Color: Simplify Equals
- [`[8f5eac5]`](https://github.com/dotnet/corefx/commit/8f5eac5) Add CryptoNative_X509UpRef
- [`[9540732]`](https://github.com/dotnet/corefx/commit/9540732) Enable arm testing in PRs.
- [`[285ad69]`](https://github.com/dotnet/corefx/commit/285ad69) Check for RunTest.cmd before running test on Nano.
- [`[81fb70e]`](https://github.com/dotnet/corefx/commit/81fb70e) Enabling perf tests' execution using universal runner (#9916)
- [`[04b54e7]`](https://github.com/dotnet/corefx/commit/04b54e7) Remove Mac OS minor version number from package filtering.
- [`[e3e7ca7]`](https://github.com/dotnet/corefx/commit/e3e7ca7) Improve behavior of TcpClient Dispose concurrent with ConnectAsync
- [`[02ea17c]`](https://github.com/dotnet/corefx/commit/02ea17c) Ensure Unix SslStream sends intermediate CA certs when required. (#9814)
- [`[4a3cbc9]`](https://github.com/dotnet/corefx/commit/4a3cbc9) Skip running arm jobs in PR.
- [`[12cf3c4]`](https://github.com/dotnet/corefx/commit/12cf3c4) Fix caching in RuntimeInformation.
- [`[9affe80]`](https://github.com/dotnet/corefx/commit/9affe80) Updating CoreFx dependencies to beta-24310-04
- [`[74df1e6]`](https://github.com/dotnet/corefx/commit/74df1e6) Updating External dependencies to beta-24310-00
- [`[99dd849]`](https://github.com/dotnet/corefx/commit/99dd849) Make Queue.Enumerator.Current inlineable by the JIT
- [`[603c29e]`](https://github.com/dotnet/corefx/commit/603c29e) Make Stack<T>.Enumerator.Current inlineable by the JIT (#9942)
- [`[6574a3f]`](https://github.com/dotnet/corefx/commit/6574a3f) Direct readers to the docs for .NET Standard (#9707)
- [`[ec7b9e8]`](https://github.com/dotnet/corefx/commit/ec7b9e8) Fix handling of errors from Process.Start
- [`[75594f0]`](https://github.com/dotnet/corefx/commit/75594f0) ARM-CI: Change Linux ARM Emulator job setup
- [`[19773a2]`](https://github.com/dotnet/corefx/commit/19773a2) ARM-CI: Enable build of managed components
- [`[38f381e]`](https://github.com/dotnet/corefx/commit/38f381e) Test TcpClient.ExclusiveAddressUse only on Windows
- [`[f0331c0]`](https://github.com/dotnet/corefx/commit/f0331c0) Make sure TcpClient properties do not throw when the underlying Socket is null
- [`[1962d3f]`](https://github.com/dotnet/corefx/commit/1962d3f) Avoid repeated char[] allocations in CheckForColonInFirstPathSegment
- [`[8881947]`](https://github.com/dotnet/corefx/commit/8881947) Respond to PR feedback.
- [`[35cdee4]`](https://github.com/dotnet/corefx/commit/35cdee4) Add TestTFMs for filtering to builds files
- [`[a8bfaf8]`](https://github.com/dotnet/corefx/commit/a8bfaf8) Return fileversion for FrameworkDescription.
- [`[82790a9]`](https://github.com/dotnet/corefx/commit/82790a9) Fix undefined ENODATA on FreeBSD.
- [`[03ac51a]`](https://github.com/dotnet/corefx/commit/03ac51a) Define _BSD_SOURCE macro for getline on FreeBSD
- [`[3f03940]`](https://github.com/dotnet/corefx/commit/3f03940) Dispose temporary Socket
- [`[4e94c92]`](https://github.com/dotnet/corefx/commit/4e94c92) Make sure TcpClient.ExclusiveAddressUse throws on Unix
- [`[37241de]`](https://github.com/dotnet/corefx/commit/37241de) Fix ValueTaskTests deadlocking on a single core machine
- [`[c825630]`](https://github.com/dotnet/corefx/commit/c825630) Add UWP platform and TestILC 1.4 dependencies to test-runtime to support .NET Native compilation
- [`[b5e214e]`](https://github.com/dotnet/corefx/commit/b5e214e) ARM-CI: Add CI checks for Linux ARM Emulator
- [`[e0ce0fd]`](https://github.com/dotnet/corefx/commit/e0ce0fd) Fix HttpWebResponse.ContentType when response has invalid headers
- [`[fd9432a]`](https://github.com/dotnet/corefx/commit/fd9432a) Updating External dependencies to beta-24306-00 (#9858)
- [`[8723a1c]`](https://github.com/dotnet/corefx/commit/8723a1c) Remove unused static field from Uri
- [`[860d28c]`](https://github.com/dotnet/corefx/commit/860d28c) Add more test coverage for dotnet/coreclr#6119 (#9844)
- [`[d2e379b]`](https://github.com/dotnet/corefx/commit/d2e379b) Add some more test coverage for the new string(char*) impl
- [`[bcb337c]`](https://github.com/dotnet/corefx/commit/bcb337c) Update wordings for diagnostics tools dependencies comments.
- [`[a52a72e]`](https://github.com/dotnet/corefx/commit/a52a72e) Fail init-tools atomically
- [`[f0fc81d]`](https://github.com/dotnet/corefx/commit/f0fc81d) Add some ReadOnlyDictionary tests (#9829)
- [`[7b2d47d]`](https://github.com/dotnet/corefx/commit/7b2d47d) Avoid a boxing allocation in UriBuilder.ToString
- [`[3e82a57]`](https://github.com/dotnet/corefx/commit/3e82a57) Fix facade-code-coverage.bat for System.Private.CoreLib changes (#9831)
- [`[b90532b]`](https://github.com/dotnet/corefx/commit/b90532b) Tweak PR contribution docs
- [`[a2f7b55]`](https://github.com/dotnet/corefx/commit/a2f7b55) Add docs for PR (feedback) (#9827)
- [`[40a0c3d]`](https://github.com/dotnet/corefx/commit/40a0c3d) Add path tests
- [`[dabfcbd]`](https://github.com/dotnet/corefx/commit/dabfcbd) Remove random data from System.Reflection.Emit tests
- [`[1a5b7a5]`](https://github.com/dotnet/corefx/commit/1a5b7a5) Cleanup TypeBuilder tests
- [`[16536c8]`](https://github.com/dotnet/corefx/commit/16536c8) Fix version numbers causing restore failures
- [`[36f1ec9]`](https://github.com/dotnet/corefx/commit/36f1ec9) Add some more tests for PropertyBuilder.Name
- [`[9f38e42]`](https://github.com/dotnet/corefx/commit/9f38e42) Updating CoreFx dependencies to beta-24303-02
- [`[30bfa3e]`](https://github.com/dotnet/corefx/commit/30bfa3e) Remove some random data from System.Reflection.Emit.Tests
- [`[1de20c9]`](https://github.com/dotnet/corefx/commit/1de20c9) Escape Messages of InnerExceptions in DataContractSerializer
- [`[b5cfc77]`](https://github.com/dotnet/corefx/commit/b5cfc77) Respond to PR feedback
- [`[d33bf45]`](https://github.com/dotnet/corefx/commit/d33bf45) Add ImmutableArray IList and IList<T> tests
- [`[0283a72]`](https://github.com/dotnet/corefx/commit/0283a72) Cleanup System.Reflection.Emit.Lightweight tests
- [`[3e714b8]`](https://github.com/dotnet/corefx/commit/3e714b8) Support filtering to TestTFM
- [`[2932668]`](https://github.com/dotnet/corefx/commit/2932668) port System.Native to be g++ compatible (#9791)
- [`[de76ec9]`](https://github.com/dotnet/corefx/commit/de76ec9) Update TestData version
- [`[f784073]`](https://github.com/dotnet/corefx/commit/f784073) Add Compression binary compat tests
- [`[0c80ffa]`](https://github.com/dotnet/corefx/commit/0c80ffa) Use string.Replace for UriBuilder.set_Path
- [`[4f00693]`](https://github.com/dotnet/corefx/commit/4f00693) Refactor ValueTuple hashing logic, update hashing algorithm
- [`[37fb7cf]`](https://github.com/dotnet/corefx/commit/37fb7cf) Revert System.Private.DataContractSerialization pkgproj reference to csproj reference
- [`[b2d61e7]`](https://github.com/dotnet/corefx/commit/b2d61e7) Increment versions post servicing
- [`[79a7c57]`](https://github.com/dotnet/corefx/commit/79a7c57) Add instructions for targeting .NET Core with MSBuild projects (#9403)
- [`[9cd4b3c]`](https://github.com/dotnet/corefx/commit/9cd4b3c) arm: resolve objcopy version to be used
- [`[dd6e920]`](https://github.com/dotnet/corefx/commit/dd6e920) Additional guard against missing network files.
- [`[a947049]`](https://github.com/dotnet/corefx/commit/a947049) Guard file reads in /sys/class/net/<iface> directories
- [`[cc0354c]`](https://github.com/dotnet/corefx/commit/cc0354c) Set KeySizeValue instead of doing gymnastics in LegalKeySizes.
- [`[a09e463]`](https://github.com/dotnet/corefx/commit/a09e463) Add locks to WinRT Console Color functions
- [`[5256d80]`](https://github.com/dotnet/corefx/commit/5256d80) Update Sys.IO.Compression tests to inherit ZipFileTestBase
- [`[d2927a8]`](https://github.com/dotnet/corefx/commit/d2927a8) Cleanup ZipFile tests using temp files
- [`[1629cd1]`](https://github.com/dotnet/corefx/commit/1629cd1) Add Retain to OSX FileSystemWatcher runloop
- [`[ba6e849]`](https://github.com/dotnet/corefx/commit/ba6e849) Add CharSet.Unicode to USER_INFO_1
- [`[1738570]`](https://github.com/dotnet/corefx/commit/1738570) Fix Console.In.Peek and friends
- [`[f4c2b04]`](https://github.com/dotnet/corefx/commit/f4c2b04) Update BuildTools 1.0.26-prerelease-00530-02
- [`[eb59abe]`](https://github.com/dotnet/corefx/commit/eb59abe) Make UWP Console Color operations not throw
- [`[13e0370]`](https://github.com/dotnet/corefx/commit/13e0370) Add NugetTargetMoniker to test projects and update remaining project references to pkgproj
- [`[5d4c642]`](https://github.com/dotnet/corefx/commit/5d4c642) Update S.D.StackTrace dependencies to use redist versions of dependencies
- [`[6d84c1d]`](https://github.com/dotnet/corefx/commit/6d84c1d) Expand CanCreateSymlinks test
- [`[062ba1c]`](https://github.com/dotnet/corefx/commit/062ba1c) Allow Socket.Connect{Async} to be used with a string-based IPAddress
- [`[c4181be]`](https://github.com/dotnet/corefx/commit/c4181be) Routing all BeginConnect calls through UnsafeBeginConnect to allow connectionless protocols to bind to the remote endpoint.
- [`[5da5eaa]`](https://github.com/dotnet/corefx/commit/5da5eaa) Redist old build of System.Private.Uri
- [`[b90d787]`](https://github.com/dotnet/corefx/commit/b90d787) Implements MetadataBuilder.GetOrAddDocumentName (#9716)
- [`[c354b2d]`](https://github.com/dotnet/corefx/commit/c354b2d) Adding multi-machine scripts and unifying configuration.
- [`[ca53c31]`](https://github.com/dotnet/corefx/commit/ca53c31) Enabled connecntivity to connect SQL Server by instance name
- [`[803d77a]`](https://github.com/dotnet/corefx/commit/803d77a) Remove uses of ThrowsAny in System.Collections test helpers
- [`[e640352]`](https://github.com/dotnet/corefx/commit/e640352) Updating CoreFx dependencies to beta-24228-03, CoreCLR to beta-24228-02
- [`[097f48b]`](https://github.com/dotnet/corefx/commit/097f48b) Add instructions for running code coverage with locally built mscorlib
- [`[341ba95]`](https://github.com/dotnet/corefx/commit/341ba95) Updating CoreFx dependencies to beta-24228-01
- [`[8aee428]`](https://github.com/dotnet/corefx/commit/8aee428) Updating CoreClr dependencies to beta-24227-03
- [`[d735e4f]`](https://github.com/dotnet/corefx/commit/d735e4f) Updating CoreFx dependencies to beta-24227-04
- [`[757da86]`](https://github.com/dotnet/corefx/commit/757da86) Use the default LazyThreadSafetyMode in RSAOpenSsl.ImportParameters
- [`[af402f2]`](https://github.com/dotnet/corefx/commit/af402f2) Add SqlClient Read retry logic when receiving undersized packets during prelogin
- [`[02e59e6]`](https://github.com/dotnet/corefx/commit/02e59e6) Add a meta-package for System.Composition
- [`[e132992]`](https://github.com/dotnet/corefx/commit/e132992) Add pkgprojs for System.Composition.* libraries
- [`[5a63116]`](https://github.com/dotnet/corefx/commit/5a63116) Update dependencies
- [`[983a4e5]`](https://github.com/dotnet/corefx/commit/983a4e5) Make tests match corefx behavior.
- [`[b948f02]`](https://github.com/dotnet/corefx/commit/b948f02) Updating CoreFx dependencies to beta-24227-01
- [`[af36606]`](https://github.com/dotnet/corefx/commit/af36606) Updating CoreFx dependencies to beta-24226-04
- [`[65d4697]`](https://github.com/dotnet/corefx/commit/65d4697) Cleanup PropertyBuilder tests
- [`[0b02286]`](https://github.com/dotnet/corefx/commit/0b02286) Cleanup ModuleBuilder tests
- [`[fcad7f8]`](https://github.com/dotnet/corefx/commit/fcad7f8) Cleanup MethodBuilder tests
- [`[d11b109]`](https://github.com/dotnet/corefx/commit/d11b109) Cleanup GenericTypeParameterBuilder tests
- [`[d02b1ee]`](https://github.com/dotnet/corefx/commit/d02b1ee) Cleanup FieldBuilder tests
- [`[cad072b]`](https://github.com/dotnet/corefx/commit/cad072b) Cleanup EventBuilder tests
- [`[69a7e21]`](https://github.com/dotnet/corefx/commit/69a7e21) Cleanup some System.Reflection.Emit tests (#9520)
- [`[10ae0d6]`](https://github.com/dotnet/corefx/commit/10ae0d6) Update depencies, corefx to 226-02 and coreclr to 226-01
- [`[f61cc53]`](https://github.com/dotnet/corefx/commit/f61cc53) Updating CoreFx dependencies to beta-24225-03
- [`[bdef9ca]`](https://github.com/dotnet/corefx/commit/bdef9ca) Update CoreCLR package to 1.0.4
- [`[d03adda]`](https://github.com/dotnet/corefx/commit/d03adda) Refactor metadata serializers (#9588)
- [`[1136c7d]`](https://github.com/dotnet/corefx/commit/1136c7d) Add tests for DefaultContext fallback resolution
- [`[d438a14]`](https://github.com/dotnet/corefx/commit/d438a14) Fix merge conflicts
- [`[bd54472]`](https://github.com/dotnet/corefx/commit/bd54472) Updating CoreClr dependencies to beta-24224-02
- [`[b49e51d]`](https://github.com/dotnet/corefx/commit/b49e51d) Update buildtools to 524-01
- [`[a0f02a0]`](https://github.com/dotnet/corefx/commit/a0f02a0) Fix typos in NormalizeString P/Invoke signature
- [`[650cb26]`](https://github.com/dotnet/corefx/commit/650cb26) Fix HttpRequestMessage reuse handling in HttpClientHandler on Unix
- [`[3e3f24d]`](https://github.com/dotnet/corefx/commit/3e3f24d) Setting xunit package version from CoreFX (#9642)
- [`[8cf7207]`](https://github.com/dotnet/corefx/commit/8cf7207) Allow override of __DOTNET_PKG used for Tools init
- [`[5306ee1]`](https://github.com/dotnet/corefx/commit/5306ee1) Minor fixes (removed needless \r, added assert, comments)
- [`[3ba84a8]`](https://github.com/dotnet/corefx/commit/3ba84a8) Address PR feedback
- [`[e36e8ca]`](https://github.com/dotnet/corefx/commit/e36e8ca) Introduct a mini-PAL into Microsoft.Win32.Registry
- [`[04c8661]`](https://github.com/dotnet/corefx/commit/04c8661) Add test to validate binding using Resolving event using static binding
- [`[02891b9]`](https://github.com/dotnet/corefx/commit/02891b9) Update Microsoft.Private.PackageBaseline to 1.0.1
- [`[aaca694]`](https://github.com/dotnet/corefx/commit/aaca694) Add keywords for two common event specficiations (asp.NET and SQL command).
- [`[5657fdb]`](https://github.com/dotnet/corefx/commit/5657fdb) Fix logic with setting response body receive timeout
- [`[e8f650d]`](https://github.com/dotnet/corefx/commit/e8f650d) Make DispatchProxy declares Property/EventInfos of the interface.
- [`[386b4d5]`](https://github.com/dotnet/corefx/commit/386b4d5) Updating External dependencies to beta-24223-00
- [`[9eb1e7d]`](https://github.com/dotnet/corefx/commit/9eb1e7d) Replace source projects with depprojs
- [`[0963237]`](https://github.com/dotnet/corefx/commit/0963237) Update dependenices in InteropServices to 4.2.0
- [`[935018d]`](https://github.com/dotnet/corefx/commit/935018d) Update FxCop and Framework Design Guidelines links
- [`[8ba82df]`](https://github.com/dotnet/corefx/commit/8ba82df) Fix reference to CoreCLR packages
- [`[d7b1407]`](https://github.com/dotnet/corefx/commit/d7b1407) Updating CoreClr dependencies to beta-24222-02
- [`[8007289]`](https://github.com/dotnet/corefx/commit/8007289) Move Dataflow ETW test into its own process
- [`[72efebe]`](https://github.com/dotnet/corefx/commit/72efebe) Pass --build-id=sha1 to linker explicitly
- [`[43c7f54]`](https://github.com/dotnet/corefx/commit/43c7f54) Address PR feedback, and additional cleanup
- [`[bd7e9b5]`](https://github.com/dotnet/corefx/commit/bd7e9b5) Fix SafeSslHandle<->SafeBioHandle lifetime management
- [`[3faa056]`](https://github.com/dotnet/corefx/commit/3faa056) Improve performance of DateTime serialization
- [`[162f06b]`](https://github.com/dotnet/corefx/commit/162f06b) Add DateTime performance test
- [`[0392a60]`](https://github.com/dotnet/corefx/commit/0392a60) update EventSource tests to dispose EventListeners
- [`[9ce507c]`](https://github.com/dotnet/corefx/commit/9ce507c) Update S.T.RegularExpressions to version 4.2.0
- [`[1ba2d17]`](https://github.com/dotnet/corefx/commit/1ba2d17) Updating contracts for new UTF8 string marshalling APIs
- [`[d341f82]`](https://github.com/dotnet/corefx/commit/d341f82) Add RID for Windows Arm64
- [`[4647e0d]`](https://github.com/dotnet/corefx/commit/4647e0d) Add code of conduct information to README.md (#9579)
- [`[eac061d]`](https://github.com/dotnet/corefx/commit/eac061d) Add `makeargs <args>` option to passing extra options to `make`
- [`[f16267c]`](https://github.com/dotnet/corefx/commit/f16267c) Add usernotfound code to check on netuserdel.
- [`[2193666]`](https://github.com/dotnet/corefx/commit/2193666) Disable SocketOptionNameTest.MulticastInterface_Set_AnyInterface_Succeeds on Fedora 23, while we investigate why this test has been failing. (#9580)
- [`[1454617]`](https://github.com/dotnet/corefx/commit/1454617) Update BuildTools to version 1.0.26-prerelease-00521-01
- [`[91260ea]`](https://github.com/dotnet/corefx/commit/91260ea) Update references to Microsoft.DotNet.BuildTools.TestSuite to a version that understands uap10.0, add version validation rule for same.
- [`[b21352a]`](https://github.com/dotnet/corefx/commit/b21352a) Respond to PR feedback.
- [`[107ee39]`](https://github.com/dotnet/corefx/commit/107ee39) Delete now dead code
- [`[028b580]`](https://github.com/dotnet/corefx/commit/028b580) Handle more bad protocol cases
- [`[f1a6ea4]`](https://github.com/dotnet/corefx/commit/f1a6ea4) Capture exception from send method into returned task
- [`[ef8fd9e]`](https://github.com/dotnet/corefx/commit/ef8fd9e) Small refactorings/fixes in WebSockets managed client
- [`[daa30fc]`](https://github.com/dotnet/corefx/commit/daa30fc) Mark another ActiveIssue
- [`[542d85e]`](https://github.com/dotnet/corefx/commit/542d85e) Separate diagnostics tests into their own class
- [`[4dff47a]`](https://github.com/dotnet/corefx/commit/4dff47a) Add remote executor support for an async method
- [`[316370a]`](https://github.com/dotnet/corefx/commit/316370a) Allow the HTTP2 protocol test to pass with untrusted chains on Debian.
- [`[0029217]`](https://github.com/dotnet/corefx/commit/0029217) MetadataBuilder tests, API polish, docs
- [`[d6b3393]`](https://github.com/dotnet/corefx/commit/d6b3393) Fix reference assembly non-stable refs
- [`[73e6c55]`](https://github.com/dotnet/corefx/commit/73e6c55) Fix product binary non-stable refs
- [`[26bd974]`](https://github.com/dotnet/corefx/commit/26bd974) Ensure we reference the latest Lineup package.
- [`[4cdb8dc]`](https://github.com/dotnet/corefx/commit/4cdb8dc) Tweak HTTP client certificates test and add ActiveIssue
- [`[13512b7]`](https://github.com/dotnet/corefx/commit/13512b7) Add retry to GetConnectedWebSocket
- [`[6bdd3ac]`](https://github.com/dotnet/corefx/commit/6bdd3ac) Seal the remaining X509 Unix PAL types
- [`[86aa3ca]`](https://github.com/dotnet/corefx/commit/86aa3ca) Split new PAL types into new files
- [`[c191cfc]`](https://github.com/dotnet/corefx/commit/c191cfc) Split IStorePal into IStorePal, IExportPal, ILoaderPal
- [`[28c54cb]`](https://github.com/dotnet/corefx/commit/28c54cb) Make System.Linq.Expressions share Common ReferenceEqualityComparer
- [`[130c9d2]`](https://github.com/dotnet/corefx/commit/130c9d2) Clean up unnecessary finalization in building Unix X509Chains
- [`[cce156a]`](https://github.com/dotnet/corefx/commit/cce156a) Add ReferenceEqualityComparer to Common
- [`[9257f10]`](https://github.com/dotnet/corefx/commit/9257f10) Several managed WebSockets tweaks
- [`[9a12086]`](https://github.com/dotnet/corefx/commit/9a12086) Add support to statically link (#8982)
- [`[0a24687]`](https://github.com/dotnet/corefx/commit/0a24687) Convert CredentialCache perf tests to xunit.performance (#9527)
- [`[02ff405]`](https://github.com/dotnet/corefx/commit/02ff405) Add package authoring for 4.2.0.0 Regex contract.
- [`[35ee6b6]`](https://github.com/dotnet/corefx/commit/35ee6b6) Update CoreFx packages  to beta-24217-04
- [`[4dd13d1]`](https://github.com/dotnet/corefx/commit/4dd13d1) Replace manual conn string checking in ManualTests with custom Fact attributes that skip the tests instead.
- [`[c173052]`](https://github.com/dotnet/corefx/commit/c173052) - Split System.Net.Sockets.Tests.DualMode into multiple classes, to allow more tests to run in parallel. (#9511)
- [`[fdfa445]`](https://github.com/dotnet/corefx/commit/fdfa445) Add generic test conn string checking to SqlClient Named Pipes tests.
- [`[0c0c685]`](https://github.com/dotnet/corefx/commit/0c0c685) Remove now unnecessary [OuterLoop] from test
- [`[061af52]`](https://github.com/dotnet/corefx/commit/061af52) Remove process exit when failing ManualTests connection string setup.
- [`[3851728]`](https://github.com/dotnet/corefx/commit/3851728) Reduce S.R.InteropServices outerloop test time from ~100s to ~0.2s
- [`[2bf09aa]`](https://github.com/dotnet/corefx/commit/2bf09aa) Update BuildTools version to 1.0.26-prerelease-00517-04
- [`[2cacdbd]`](https://github.com/dotnet/corefx/commit/2cacdbd) Update ref for Regex Group Name property
- [`[cee1351]`](https://github.com/dotnet/corefx/commit/cee1351) Reduce System.Runtime.Numerics outerloop test time from ~180s to ~90s
- [`[ae51602]`](https://github.com/dotnet/corefx/commit/ae51602) Make regex group fields readonly.
- [`[9a2bbb9]`](https://github.com/dotnet/corefx/commit/9a2bbb9) Regex group should provide a Name property.
- [`[bcbeb8b]`](https://github.com/dotnet/corefx/commit/bcbeb8b) Comments to remind developers not to break VS debugger dependencies
- [`[0926d40]`](https://github.com/dotnet/corefx/commit/0926d40) Reduce LINQ outerloop test execution time from 2 minutes to 1.5 seconds
- [`[fabde8d]`](https://github.com/dotnet/corefx/commit/fabde8d) Clean up SafeX509Handles finalized by Find(validOnly=true)
- [`[9d5ff2d]`](https://github.com/dotnet/corefx/commit/9d5ff2d) Fix finalized invalid handles on PFX read failure.
- [`[944ee3a]`](https://github.com/dotnet/corefx/commit/944ee3a) Fix finalized invalid handle on TryReadX509Der failure path
- [`[67d802c]`](https://github.com/dotnet/corefx/commit/67d802c) Remove SafeX509Handle finalizations coming out of the test project
- [`[9d2e851]`](https://github.com/dotnet/corefx/commit/9d2e851) Fix typo
- [`[b8b0cbc]`](https://github.com/dotnet/corefx/commit/b8b0cbc) Use DateTimeKind.Utc for constructing DateTimeOffset
- [`[e4c1fed]`](https://github.com/dotnet/corefx/commit/e4c1fed) Reduce FileSystem outerloop test time
- [`[2a75aef]`](https://github.com/dotnet/corefx/commit/2a75aef) Reduce PLINQ tests outerloop from ~250s to ~85s
- [`[869c71a]`](https://github.com/dotnet/corefx/commit/869c71a) Add more encoder tests and polish APIs
- [`[96fd6fd]`](https://github.com/dotnet/corefx/commit/96fd6fd) Additional information about deprecated monikers (#8767)
- [`[31ffe45]`](https://github.com/dotnet/corefx/commit/31ffe45) Make X509 CollectionsTests run without modifying system state
- [`[c8572c7]`](https://github.com/dotnet/corefx/commit/c8572c7) Bump TFS dependencies and prime packages
- [`[fe2f2b3]`](https://github.com/dotnet/corefx/commit/fe2f2b3) Expand Bit array tests (#9461)
- [`[ce09068]`](https://github.com/dotnet/corefx/commit/ce09068) Fix octal IP address string parsing on OSX (#9477)
- [`[212783d]`](https://github.com/dotnet/corefx/commit/212783d) Fix MulticastInterface_Set_ValidIndex_Success failures on non-Windows platforms. (#9471)
- [`[d412bbf]`](https://github.com/dotnet/corefx/commit/d412bbf) Update BuildTools to 1.0.26-prerelease-00517-01
- [`[177e983]`](https://github.com/dotnet/corefx/commit/177e983) Fix tests that were missing pkgproj references
- [`[7cf5bb6]`](https://github.com/dotnet/corefx/commit/7cf5bb6) Build product assemblies against stable packages
- [`[92a4117]`](https://github.com/dotnet/corefx/commit/92a4117) Bump versions across corefx and move to beta
- [`[80b0d7a]`](https://github.com/dotnet/corefx/commit/80b0d7a) Ensuring some fields that Visual Studio debugger needs to access will stay there
- [`[a6f8d2f]`](https://github.com/dotnet/corefx/commit/a6f8d2f) Reduce System.Threading.Tasks.Tests from ~140s to ~10s
- [`[8b4aba6]`](https://github.com/dotnet/corefx/commit/8b4aba6) Update BuildTools version to 1.0.26-prerelease-00516-05
- [`[1099ace]`](https://github.com/dotnet/corefx/commit/1099ace) Fix internal BuildBreak caused by updating buildtools.
- [`[b448211]`](https://github.com/dotnet/corefx/commit/b448211) Fixing DevWorkflow Scripts given that corerun is not present in the tool runtime anymore (#9469)
- [`[c6da03a]`](https://github.com/dotnet/corefx/commit/c6da03a) Reduce System.Threading.Tests from ~650s to ~8s
- [`[11b687a]`](https://github.com/dotnet/corefx/commit/11b687a) Adding windows phone 8
- [`[4285ffa]`](https://github.com/dotnet/corefx/commit/4285ffa) Reduce System.Threading.Tasks.Parallel.Tests from ~200s to ~6s
- [`[868e579]`](https://github.com/dotnet/corefx/commit/868e579) Ensure we build Microsoft.Private.PackageBaseline
- [`[fbb2b6d]`](https://github.com/dotnet/corefx/commit/fbb2b6d) Cleanup some System.Linq tests (#8817)
- [`[d593a25]`](https://github.com/dotnet/corefx/commit/d593a25) Rename DDDataTypes test to DDDataTypesTest to explicitly show that it's a test class.
- [`[dc47374]`](https://github.com/dotnet/corefx/commit/dc47374) Convert MultipleResultsTest class to a non-static class, since it has non-constant global variables.
- [`[79ff80a]`](https://github.com/dotnet/corefx/commit/79ff80a) Refactor SqlClient ManualTests to fetch connection strings from environment variables, rather than an XML file. This change also allows ManualTests to be built and run automatically, but no actual tests will be run if the connection strings aren't present.
- [`[cd2541b]`](https://github.com/dotnet/corefx/commit/cd2541b) Fixing NegotiateStream Windows Interop. Adding NTLM and Kerberos remote tests.
- [`[e62f6ba]`](https://github.com/dotnet/corefx/commit/e62f6ba) Updating BuildTools to use sharedRuntime
- [`[48ab6ce]`](https://github.com/dotnet/corefx/commit/48ab6ce) Flow HttpClient timeouts and cancellation to the response stream
- [`[fd6a8fc]`](https://github.com/dotnet/corefx/commit/fd6a8fc) Mark tests that require elevation
- [`[87b3934]`](https://github.com/dotnet/corefx/commit/87b3934) Import dotnet5.1 instead of 5.2
- [`[099bc04]`](https://github.com/dotnet/corefx/commit/099bc04) Including buildtools as a source and update perf versions
- [`[b484145]`](https://github.com/dotnet/corefx/commit/b484145) Update CoreFX tests to compile against a minimum of netstandard1.3 and add supports clauses for tests
- [`[e93aa38]`](https://github.com/dotnet/corefx/commit/e93aa38) Lowering framework dependency to netstandard1.0
- [`[f928a57]`](https://github.com/dotnet/corefx/commit/f928a57) Fix System.Diagnostics.Debug.SymbolReader\src\project.json expected version of Microsoft.TargetingPack.Private.NETNative and Microsoft.TargetingPack.Private.CoreCLR
- [`[6b4402c]`](https://github.com/dotnet/corefx/commit/6b4402c) Fix several DateTimeOffset tests in various timezones
- [`[2e59fab]`](https://github.com/dotnet/corefx/commit/2e59fab) Ensure correct exception is thrown in several situations
- [`[5c5c349]`](https://github.com/dotnet/corefx/commit/5c5c349) Address PR feedback
- [`[270a831]`](https://github.com/dotnet/corefx/commit/270a831) Fix stream disposal causing test failures
- [`[4e3f738]`](https://github.com/dotnet/corefx/commit/4e3f738) Delete unused resources in Strings.resx
- [`[88b5e73]`](https://github.com/dotnet/corefx/commit/88b5e73) Make WebSocketReceiveResult's fields readonly
- [`[7961871]`](https://github.com/dotnet/corefx/commit/7961871) Use nameof in ClientWebSocket
- [`[c241cc4]`](https://github.com/dotnet/corefx/commit/c241cc4) Inline EnsureBufferContainsHeaderAsync into ReceiveAsyncPrivate
- [`[0f21c07]`](https://github.com/dotnet/corefx/commit/0f21c07) Remove base class from ManagedWebSocket
- [`[3e795b0]`](https://github.com/dotnet/corefx/commit/3e795b0) Optimize SendFrameAsync to minimize allocations
- [`[7a2acc7]`](https://github.com/dotnet/corefx/commit/7a2acc7) Use custom network stream in managed WebSockets on Unix
- [`[f1caf0a]`](https://github.com/dotnet/corefx/commit/f1caf0a) Move classes to their own files
- [`[2a0819b]`](https://github.com/dotnet/corefx/commit/2a0819b) Reduce running time of WebSocket.Client tests
- [`[b1d20b4]`](https://github.com/dotnet/corefx/commit/b1d20b4) Override HttpContent.CreateContentReadStreamAsync in MultipartContent
- [`[8539c5c]`](https://github.com/dotnet/corefx/commit/8539c5c) Updating CoreFx dependencies to rc4-24215-01
- [`[ab02479]`](https://github.com/dotnet/corefx/commit/ab02479) Add test for #9357
- [`[d5dcad1]`](https://github.com/dotnet/corefx/commit/d5dcad1) Update CoreFX and External Dependencies to 24214-02 and 24214-00
- [`[5bd91b9]`](https://github.com/dotnet/corefx/commit/5bd91b9) Fix SymbolReader after review.
- [`[13f0b1a]`](https://github.com/dotnet/corefx/commit/13f0b1a) Fixed a Bug with Using PreserveObjectReferences with IsReference=true Type.
- [`[7fefc29]`](https://github.com/dotnet/corefx/commit/7fefc29) Update windows-instructions.md
- [`[10e64eb]`](https://github.com/dotnet/corefx/commit/10e64eb) Fix build break
- [`[1cfd37f]`](https://github.com/dotnet/corefx/commit/1cfd37f) OidInfo.cs Interop guidelines (part 2)
- [`[ae1fef3]`](https://github.com/dotnet/corefx/commit/ae1fef3) Address PR feedback
- [`[77b5065]`](https://github.com/dotnet/corefx/commit/77b5065) Update versions in test project.json files to prevent downgrading.  Should eventually also have build-time validation for this.
- [`[156e777]`](https://github.com/dotnet/corefx/commit/156e777) OidInfo.cs interop guidelines (part 1)
- [`[fde89bd]`](https://github.com/dotnet/corefx/commit/fde89bd) Avoid send/receive delegate allocations with SocketAsyncEventArgs on Unix
- [`[05b4792]`](https://github.com/dotnet/corefx/commit/05b4792) Updating CoreFx dependencies to rc4-24213-02
- [`[e64eeba]`](https://github.com/dotnet/corefx/commit/e64eeba) Updating CoreClr dependencies to rc4-24213-02
- [`[7e90d80]`](https://github.com/dotnet/corefx/commit/7e90d80) Updating CoreClr dependencies to rc4-24212-01
- [`[b2ae3de]`](https://github.com/dotnet/corefx/commit/b2ae3de) Updating CoreFx dependencies to rc4-24212-03
- [`[8f9895e]`](https://github.com/dotnet/corefx/commit/8f9895e) Update buildtools to 00512-01
- [`[2f5f58a]`](https://github.com/dotnet/corefx/commit/2f5f58a) Add CredentialCache perf tests
- [`[35531db]`](https://github.com/dotnet/corefx/commit/35531db) Remove WithAbortAsync
- [`[3a5a02e]`](https://github.com/dotnet/corefx/commit/3a5a02e) Remove an unnecessary CancellationToken registration
- [`[c96eee1]`](https://github.com/dotnet/corefx/commit/c96eee1) Change how message headers are read
- [`[f10e413]`](https://github.com/dotnet/corefx/commit/f10e413) Improve WebSocket receive perf with receive buffer
- [`[b726c18]`](https://github.com/dotnet/corefx/commit/b726c18) Initial System.Net.WebSockets.Client implementation on Unix
- [`[cc61ac3]`](https://github.com/dotnet/corefx/commit/cc61ac3) Updating CoreClr dependencies to rc4-24211-02
- [`[40e45e1]`](https://github.com/dotnet/corefx/commit/40e45e1) Removed duplicate "name" in package description
- [`[3473c3d]`](https://github.com/dotnet/corefx/commit/3473c3d) Updating CoreFx dependencies to rc4-24210-04
- [`[99b7b5a]`](https://github.com/dotnet/corefx/commit/99b7b5a) Fix hanging System.Net.Http test
- [`[44871fe]`](https://github.com/dotnet/corefx/commit/44871fe) Disable native build when updating dependencies.
- [`[a2b0041]`](https://github.com/dotnet/corefx/commit/a2b0041) Updating CoreClr dependencies to rc4-24210-02
- [`[fd49745]`](https://github.com/dotnet/corefx/commit/fd49745) Disable X509FilesystemTests on Fedora23
- [`[8bf48ee]`](https://github.com/dotnet/corefx/commit/8bf48ee) Run OSX outerloop runs elevated.
- [`[13bb83a]`](https://github.com/dotnet/corefx/commit/13bb83a) Implement missing data access members on MetadataReader, PEMemoryBlock
- [`[ead9a46]`](https://github.com/dotnet/corefx/commit/ead9a46) Mark X509Store_AddAfterDispose as OuterLoop
- [`[12a9975]`](https://github.com/dotnet/corefx/commit/12a9975) Add a few tests for UDP Socket.Connect{Async}
- [`[2465a77]`](https://github.com/dotnet/corefx/commit/2465a77) Add win8 and wpa81 support to RuntimeInformation
- [`[a97d15f]`](https://github.com/dotnet/corefx/commit/a97d15f) Add another test
- [`[889ed44]`](https://github.com/dotnet/corefx/commit/889ed44) Port Pipes AccessControl to CoreFX
- [`[b5c2302]`](https://github.com/dotnet/corefx/commit/b5c2302) Port PipeSecurity from TFS
- [`[e63f2c0]`](https://github.com/dotnet/corefx/commit/e63f2c0) Updating External dependencies to rc4-24209-00
- [`[dd7cddf]`](https://github.com/dotnet/corefx/commit/dd7cddf) Use .builds for command line building instead of .sln
- [`[74cd3d6]`](https://github.com/dotnet/corefx/commit/74cd3d6) Change how request content is read in libcurl
- [`[e37db19]`](https://github.com/dotnet/corefx/commit/e37db19) Ignore standard error when querying openssl
- [`[f61d8e4]`](https://github.com/dotnet/corefx/commit/f61d8e4) Fix deflate_quick strategy
- [`[c0e2848]`](https://github.com/dotnet/corefx/commit/c0e2848) Fix OpenSslCipher.OpenKey check for valid SafeHandle
- [`[a94b5ae]`](https://github.com/dotnet/corefx/commit/a94b5ae) Add bounds checking in case fizzle_matches() tries to read too far back
- [`[f4a777e]`](https://github.com/dotnet/corefx/commit/f4a777e) Removes size validation in TryGetDirectoryOffset, adds tests
- [`[66071ea]`](https://github.com/dotnet/corefx/commit/66071ea) Add supports clauses for new/old platforms
- [`[f8870a7]`](https://github.com/dotnet/corefx/commit/f8870a7) Update PlatformNotSupportedException message for Socket.Connect on Unix
- [`[ffe1b9d]`](https://github.com/dotnet/corefx/commit/ffe1b9d) Address PR feedback
- [`[9883a10]`](https://github.com/dotnet/corefx/commit/9883a10) Update comment about netcore50 MaxResponseHeadersLength property
- [`[21c27cd]`](https://github.com/dotnet/corefx/commit/21c27cd) Add System.Diagnostics.Debug.SymbolReader assembly.
- [`[aeed0be]`](https://github.com/dotnet/corefx/commit/aeed0be) Add clang3.8 to build.sh option
- [`[953a407]`](https://github.com/dotnet/corefx/commit/953a407) Add more test cases
- [`[bc3775f]`](https://github.com/dotnet/corefx/commit/bc3775f) Allow ResolutionScope to be nil
- [`[0eab3ef]`](https://github.com/dotnet/corefx/commit/0eab3ef) CodedIndex cleanup and tests
- [`[b9d2905]`](https://github.com/dotnet/corefx/commit/b9d2905) Update buildtools to add Serviceable to nupkgs
- [`[e635352]`](https://github.com/dotnet/corefx/commit/e635352) Remove a few more asserts
- [`[4070ceb]`](https://github.com/dotnet/corefx/commit/4070ceb) Fix a doc comment bug in Expression.VisitChildren
- [`[25d4dbf]`](https://github.com/dotnet/corefx/commit/25d4dbf) Remove keepallprojectreferences
- [`[4b2af11]`](https://github.com/dotnet/corefx/commit/4b2af11) Fix dependency conflict warnings
- [`[88df89b]`](https://github.com/dotnet/corefx/commit/88df89b) Partition M.TP.Private.CoreCLR to come from CoreCLR and not External
- [`[2406d44]`](https://github.com/dotnet/corefx/commit/2406d44) Update M.TP.Private.CoreCLR version to 1.0.1
- [`[76c3542]`](https://github.com/dotnet/corefx/commit/76c3542) Updating External dependencies to rc4-24207-00
- [`[888a01c]`](https://github.com/dotnet/corefx/commit/888a01c) Allow whitespace after HTTP response header name
- [`[9294512]`](https://github.com/dotnet/corefx/commit/9294512) Updating CoreClr dependencies to rc4-24207-02
- [`[f3049c6]`](https://github.com/dotnet/corefx/commit/f3049c6) Handle a ctrl-c interrupt on test runner
- [`[ec9c0f2]`](https://github.com/dotnet/corefx/commit/ec9c0f2) BT update for classifying NETCore.Jit deps as CoreRun deps (#9199)
- [`[a78f569]`](https://github.com/dotnet/corefx/commit/a78f569) Remove two asserts from SystemNative_ForkAndExecProcess
- [`[df20dd4]`](https://github.com/dotnet/corefx/commit/df20dd4) Fix some CI definitions
- [`[2571a34]`](https://github.com/dotnet/corefx/commit/2571a34) Disabling multiple-connect tests failing tests on Unix.
- [`[51ab6a0]`](https://github.com/dotnet/corefx/commit/51ab6a0) Fixed misleading comment about tail index of Queue. (#9169)
- [`[6771d38]`](https://github.com/dotnet/corefx/commit/6771d38) Always use Release version of TestNativeService.
- [`[06adf3e]`](https://github.com/dotnet/corefx/commit/06adf3e) Add extra logging for TickCount test
- [`[11d47f6]`](https://github.com/dotnet/corefx/commit/11d47f6) Fix Filesystem tests failing from path changes
- [`[887a291]`](https://github.com/dotnet/corefx/commit/887a291) Add support to get intellisense files in our packages
- [`[456cf97]`](https://github.com/dotnet/corefx/commit/456cf97) Addressed Feedback for PR #9125.
- [`[da8cd90]`](https://github.com/dotnet/corefx/commit/da8cd90) Remove unused Cookie Comparer class
- [`[afe7f4f]`](https://github.com/dotnet/corefx/commit/afe7f4f) Update all invalid package versions caused by the change compression and sqlclient
- [`[4add061]`](https://github.com/dotnet/corefx/commit/4add061) Remove System.IO.Compression and System.Data.SqlClient from the External dependencies
- [`[64ce90b]`](https://github.com/dotnet/corefx/commit/64ce90b) Make the internal CookieComparer class static
- [`[98a3081]`](https://github.com/dotnet/corefx/commit/98a3081) update project management section
- [`[9745abb]`](https://github.com/dotnet/corefx/commit/9745abb) Stop cross building other Linux distros
- [`[ee09a07]`](https://github.com/dotnet/corefx/commit/ee09a07) Updates for accuracy
- [`[3290b3d]`](https://github.com/dotnet/corefx/commit/3290b3d) Fix package ID for x64 sni package dependency
- [`[ef6b349]`](https://github.com/dotnet/corefx/commit/ef6b349) Revert "Flow HttpClient timeouts and cancellation to the response stream"
- [`[d1e345f]`](https://github.com/dotnet/corefx/commit/d1e345f) Fixing async connect for connectionless protocols. Fixing and enabling perf/stress tests.
- [`[4a59a91]`](https://github.com/dotnet/corefx/commit/4a59a91) Dictionary.ValueCollection.Enumerator is faster than Dictionary.Enumerator
- [`[10267e0]`](https://github.com/dotnet/corefx/commit/10267e0) Fixed a Bug in Exception Deserialization.
- [`[1a4cf33]`](https://github.com/dotnet/corefx/commit/1a4cf33) Prefer x64 when platform=AnyCPU for native test service.
- [`[4b24659]`](https://github.com/dotnet/corefx/commit/4b24659) Compiler ServiceProcess native service as 64bit to run on Windows Nano.
- [`[0b8dfc5]`](https://github.com/dotnet/corefx/commit/0b8dfc5) Fix crash in HttpClient on Unix when using client certificates
- [`[d6cc753]`](https://github.com/dotnet/corefx/commit/d6cc753) Remove no longer needed baseline file
- [`[9be38b2]`](https://github.com/dotnet/corefx/commit/9be38b2) Fixing Native Non-Windows version info issues in Official builds (#9096)
- [`[b7d8eb4]`](https://github.com/dotnet/corefx/commit/b7d8eb4) Fix dependency in SqlClient package.
- [`[726b254]`](https://github.com/dotnet/corefx/commit/726b254) Fix Compression perf casing error
- [`[ef77613]`](https://github.com/dotnet/corefx/commit/ef77613) Fix HttpClientMiniStressTests tests
- [`[6379263]`](https://github.com/dotnet/corefx/commit/6379263) Address PR feedback
- [`[a42293c]`](https://github.com/dotnet/corefx/commit/a42293c) Updating CoreClr dependencies to rc4-24203-02
- [`[483aa5a]`](https://github.com/dotnet/corefx/commit/483aa5a) Add some HttpClientHandler client certificate tests
- [`[d0ae14f]`](https://github.com/dotnet/corefx/commit/d0ae14f) Make UWP clrcompression package aot specific
- [`[dc4ce75]`](https://github.com/dotnet/corefx/commit/dc4ce75) Update buildtools to pick up code coverage workaround
- [`[cc8b48c]`](https://github.com/dotnet/corefx/commit/cc8b48c) Flow HttpClient timeouts and cancellation to the response stream
- [`[d4bc86d]`](https://github.com/dotnet/corefx/commit/d4bc86d) Address PR feedback
- [`[f354cff]`](https://github.com/dotnet/corefx/commit/f354cff) Fix for corefx issue #9060 visibility fix for EventSourceIndex method
- [`[329de5e]`](https://github.com/dotnet/corefx/commit/329de5e) Fixes for the official build.
- [`[c417072]`](https://github.com/dotnet/corefx/commit/c417072) Move System.Linq.Expressions and System.Linq contracts to be supported from net463
- [`[3dd150b]`](https://github.com/dotnet/corefx/commit/3dd150b) Move RegularExpressions contract to be supported from net463.
- [`[44172a4]`](https://github.com/dotnet/corefx/commit/44172a4) Removing `[ActiveIssue(9053)]` from `Math.Pow` tests.
- [`[a5a8ec2]`](https://github.com/dotnet/corefx/commit/a5a8ec2) Adding some more System.Math tests to cover areas where other platforms may differ from windows.
- [`[6ee65e3]`](https://github.com/dotnet/corefx/commit/6ee65e3) Remove usage of Enum.HasFlag
- [`[3bcb70c]`](https://github.com/dotnet/corefx/commit/3bcb70c) Adding some System.Math tests to cover areas where other platforms may differ from windows.
- [`[bbb2a5d]`](https://github.com/dotnet/corefx/commit/bbb2a5d) Avoid allocations in SqlClient's use of CancellationToken.Register
- [`[ac242e8]`](https://github.com/dotnet/corefx/commit/ac242e8) Retain HOME when launching new processes
- [`[c4a50af]`](https://github.com/dotnet/corefx/commit/c4a50af) Use Debian 8.4 for inner and outerloop runs
- [`[f4b4055]`](https://github.com/dotnet/corefx/commit/f4b4055) Disable Pow test failing with recent coreclr change
- [`[bdbc879]`](https://github.com/dotnet/corefx/commit/bdbc879) Remove unnecessary assembly-level CLSCompliant attributes
- [`[aae3ead]`](https://github.com/dotnet/corefx/commit/aae3ead) Avoid box allocations when enumerating IDictionary
- [`[13a785c]`](https://github.com/dotnet/corefx/commit/13a785c) Replace tabs with spaces in netci.groovy
- [`[fad598b]`](https://github.com/dotnet/corefx/commit/fad598b) Exclude some packages from being published.
- [`[98317b3]`](https://github.com/dotnet/corefx/commit/98317b3) Minor cleanup
- [`[dc8f55a]`](https://github.com/dotnet/corefx/commit/dc8f55a) Reduce CredentialKey allocations
- [`[6b3f24f]`](https://github.com/dotnet/corefx/commit/6b3f24f) Reduce CredentialHostKey allocations
- [`[b73e987]`](https://github.com/dotnet/corefx/commit/b73e987) Avoid the array allocation/copying in CredentialCache's enumerator
- [`[dcd2236]`](https://github.com/dotnet/corefx/commit/dcd2236) Lazily allocate dictionaries in System.Net.CredentialCache
- [`[cfcafa3]`](https://github.com/dotnet/corefx/commit/cfcafa3) Include the ArgumentException param name when host is empty
- [`[a87bd22]`](https://github.com/dotnet/corefx/commit/a87bd22) Add CredentialCache tests
- [`[4c955b5]`](https://github.com/dotnet/corefx/commit/4c955b5) Fixing typo
- [`[14d3b0e]`](https://github.com/dotnet/corefx/commit/14d3b0e) Switch to Microsoft.NETCore.Runtime.CoreCLR package.
- [`[4ddf773]`](https://github.com/dotnet/corefx/commit/4ddf773) Remove debian.8.2 and centos.7.1 rids
- [`[37d139d]`](https://github.com/dotnet/corefx/commit/37d139d) Update the framework from netstandard1.5 to netstandard1.6 to clean up build warnings.
- [`[7ce67d4]`](https://github.com/dotnet/corefx/commit/7ce67d4) Upgrade CoreFX version to rc4-24201-04 from the build pipeline.
- [`[73a89cb]`](https://github.com/dotnet/corefx/commit/73a89cb) Disabling dotnet installation on non-unix build machines (#9032)
- [`[d8a923f]`](https://github.com/dotnet/corefx/commit/d8a923f) Fix several IO tests and remove some stale ActiveIssue
- [`[f835dc7]`](https://github.com/dotnet/corefx/commit/f835dc7) Upgrade non-CoreFX dependencies to rc4-24201-00 from TFS.
- [`[8569f55]`](https://github.com/dotnet/corefx/commit/8569f55) Adding EditorBrowsable attribute and changing method to ToTuple
- [`[fb209e1]`](https://github.com/dotnet/corefx/commit/fb209e1) Split external dependencies to version properties and modify the update script.
- [`[7bd18d6]`](https://github.com/dotnet/corefx/commit/7bd18d6) Fix CurlHandler handling of redirects (#8946)
- [`[9c0eaa1]`](https://github.com/dotnet/corefx/commit/9c0eaa1) Add several HttpClientHandler tests related to content
- [`[0b6519f]`](https://github.com/dotnet/corefx/commit/0b6519f) If we don't expect UDP packets to be received, don't send redundant packets.  On OSX, if a UDP packet is actively rejected, a subsequent send on the same socket can result in a "connection refused" error.  This change avoids that error for the cases where we're intentionally sending packets that might be rejected. (#9002)
- [`[d02e47e]`](https://github.com/dotnet/corefx/commit/d02e47e) Use correct openSUSE RID
- [`[465aa55]`](https://github.com/dotnet/corefx/commit/465aa55) Fixing PerformanceTests command line build.
- [`[2586d23]`](https://github.com/dotnet/corefx/commit/2586d23) Switch test-runtime to NETStandard.Library
- [`[4d8e484]`](https://github.com/dotnet/corefx/commit/4d8e484) Adding image example for PerfView collection.
- [`[d04bb6c]`](https://github.com/dotnet/corefx/commit/d04bb6c) Changed Close() logic for diagnostics to check for a non-Closed connection instead of an Open connection
- [`[07679be]`](https://github.com/dotnet/corefx/commit/07679be) Fix WinHttpHandler unit tests
- [`[1102053]`](https://github.com/dotnet/corefx/commit/1102053) Allow writing an ASCII ZipArchive
- [`[a8b4814]`](https://github.com/dotnet/corefx/commit/a8b4814) Fixing perf linux tests and revving xunit perf versions (#8862)
- [`[7307337]`](https://github.com/dotnet/corefx/commit/7307337) Fix build-packages.sh script so it works for Fedora and OpenSUSE.
- [`[a94db66]`](https://github.com/dotnet/corefx/commit/a94db66) Update README.md to fix a few links (#8993)
- [`[18a32a4]`](https://github.com/dotnet/corefx/commit/18a32a4) Add rel-notes and project URL to nupkgs
- [`[8a9402b]`](https://github.com/dotnet/corefx/commit/8a9402b) Remove innerloop dependencies on www.ssllabs.com
- [`[1c8c3c3]`](https://github.com/dotnet/corefx/commit/1c8c3c3) Increase the min supported version of the Zip spec
- [`[5fd5a99]`](https://github.com/dotnet/corefx/commit/5fd5a99) Update build tools to pick up fixes for the official build.
- [`[3528e91]`](https://github.com/dotnet/corefx/commit/3528e91) Adding ToRefTuple 1 through 20
- [`[f88d27b]`](https://github.com/dotnet/corefx/commit/f88d27b) Adding ToValueTuple from 1 through 20
- [`[c17833d]`](https://github.com/dotnet/corefx/commit/c17833d) Address PR feedback
- [`[1204054]`](https://github.com/dotnet/corefx/commit/1204054) Add a few more collection and stack tests (#8876)
- [`[fd5c20f]`](https://github.com/dotnet/corefx/commit/fd5c20f) Remove duplicate resources from System.ComponentModel.TypeConverter
- [`[c239fe8]`](https://github.com/dotnet/corefx/commit/c239fe8) Dispose some X509 resources more aggressively
- [`[dbf5496]`](https://github.com/dotnet/corefx/commit/dbf5496) Update StackTrace project.json with new Metadata version number
- [`[bca935c]`](https://github.com/dotnet/corefx/commit/bca935c) Adding ToValue 1 through 20
- [`[1503738]`](https://github.com/dotnet/corefx/commit/1503738) Adding deconstruct for 1 through 20
- [`[f779c21]`](https://github.com/dotnet/corefx/commit/f779c21) Add Fedora 23 badges
- [`[c376cfc]`](https://github.com/dotnet/corefx/commit/c376cfc) Get tests passing on Fedora 23
- [`[449330a]`](https://github.com/dotnet/corefx/commit/449330a) Fixed executing msbuild on solutions
- [`[f049e6a]`](https://github.com/dotnet/corefx/commit/f049e6a) Address PR feedback
- [`[21744ae]`](https://github.com/dotnet/corefx/commit/21744ae) Fix XML comments for System.IO.Compression.ZipFile
- [`[ceba0e5]`](https://github.com/dotnet/corefx/commit/ceba0e5) Fix client certificates-related crash
- [`[528de4e]`](https://github.com/dotnet/corefx/commit/528de4e) Add a few more parameter names to System.Linq.Expressions exceptions
- [`[8bea542]`](https://github.com/dotnet/corefx/commit/8bea542) Update build tools to pick up fixes for the official build.
- [`[6bddd0d]`](https://github.com/dotnet/corefx/commit/6bddd0d) Fix Environment.StackTrace throwing BadImageFormatException.
- [`[608ce0d]`](https://github.com/dotnet/corefx/commit/608ce0d) Dispose of request HttpContent after buffering response
- [`[4a69a1e]`](https://github.com/dotnet/corefx/commit/4a69a1e) Enable previously disabled Unicode Categories tests
- [`[cc821db]`](https://github.com/dotnet/corefx/commit/cc821db) ValueTuple: adding Deconstruct and interop methods for System.Tuple
- [`[6b0b2c2]`](https://github.com/dotnet/corefx/commit/6b0b2c2) Implement Console support for netcore50
- [`[a9df42d]`](https://github.com/dotnet/corefx/commit/a9df42d) Make Platforms/Targets pkgs work w/packages.config
- [`[3e3ab10]`](https://github.com/dotnet/corefx/commit/3e3ab10) Support building on all supported distros
- [`[48da580]`](https://github.com/dotnet/corefx/commit/48da580) Improve tracing in CurlHandler
- [`[704f56d]`](https://github.com/dotnet/corefx/commit/704f56d) Fix ValueTask<T>.ToString behavior with null results
- [`[3355f6f]`](https://github.com/dotnet/corefx/commit/3355f6f) Update NETStandard.Library reference to 1.6
- [`[eecacdc]`](https://github.com/dotnet/corefx/commit/eecacdc) Remove implicit casts from ValueTask<T>
- [`[66ed6f0]`](https://github.com/dotnet/corefx/commit/66ed6f0) Reenable ALC test
- [`[fdd2ded]`](https://github.com/dotnet/corefx/commit/fdd2ded) Update BuildTools version
- [`[d04f336]`](https://github.com/dotnet/corefx/commit/d04f336) Disable API Compat on Unix
- [`[1d8bac5]`](https://github.com/dotnet/corefx/commit/1d8bac5) Remove some dead code
- [`[02f4087]`](https://github.com/dotnet/corefx/commit/02f4087) Write msbuild.[wrn|err] logs on Unix
- [`[2172894]`](https://github.com/dotnet/corefx/commit/2172894) Remove broken BUILDTOOLS_OVERRIDE_RUNTIME support
- [`[b401b5b]`](https://github.com/dotnet/corefx/commit/b401b5b) Disable test for issue 8896
- [`[c6fba62]`](https://github.com/dotnet/corefx/commit/c6fba62) RowConfigReader: Only match keys if they start a line, with no preceding whitespace.
- [`[9594c3d]`](https://github.com/dotnet/corefx/commit/9594c3d) Console Title test should run in separate process.
- [`[f57a72e]`](https://github.com/dotnet/corefx/commit/f57a72e) Handle some degenerate formatting cases better in RowConfigReader
- [`[eeb9ab2]`](https://github.com/dotnet/corefx/commit/eeb9ab2) Fix possible memory leaks in WinHttpRequestState
- [`[23c4908]`](https://github.com/dotnet/corefx/commit/23c4908) Build release native components on release build.
- [`[ad44e51]`](https://github.com/dotnet/corefx/commit/ad44e51) Add basic coverage of RowConfigReader into Common test project
- [`[22a9c7e]`](https://github.com/dotnet/corefx/commit/22a9c7e) Allow files to not end in newline in RowConfigReader
- [`[3c8b7d9]`](https://github.com/dotnet/corefx/commit/3c8b7d9) Add System.Linq.Expressions to NETStandard.Library
- [`[9c5f892]`](https://github.com/dotnet/corefx/commit/9c5f892) Update NETStandard.Library to 1.6
- [`[58f6804]`](https://github.com/dotnet/corefx/commit/58f6804) Bump S.R.Metadata to v1.4
- [`[9857e37]`](https://github.com/dotnet/corefx/commit/9857e37) Optimise multiple Append and Prepend calls.
- [`[db8169f]`](https://github.com/dotnet/corefx/commit/db8169f) Resize grouping elements when necessary within ToArray/List.
- [`[597e2310]`](https://github.com/dotnet/corefx/commit/597e2310) Return false from TryGetFuncType/TryGetActionType on all failures.
- [`[ea1c042]`](https://github.com/dotnet/corefx/commit/ea1c042) Allow pointer-types in delegates with low arity.
- [`[bca4ea4]`](https://github.com/dotnet/corefx/commit/bca4ea4) Add tests for delegate-creation methods in Linq.Expressions
- [`[072d14f]`](https://github.com/dotnet/corefx/commit/072d14f) Add ArrayList IList tests
- [`[3ce0367]`](https://github.com/dotnet/corefx/commit/3ce0367) Add additonal runtimes
- [`[b350c59]`](https://github.com/dotnet/corefx/commit/b350c59) Temporary disable some Char tests
- [`[efe0116]`](https://github.com/dotnet/corefx/commit/efe0116) Avoid BadImageFormatException from Env.StackTrace
- [`[9f4d58c]`](https://github.com/dotnet/corefx/commit/9f4d58c) Restructure IP address parsing tests (#8700)
- [`[3678ac9]`](https://github.com/dotnet/corefx/commit/3678ac9) Fix packages references that incremented minor
- [`[8573d15]`](https://github.com/dotnet/corefx/commit/8573d15) Remove Interop.PInvoke workaround
- [`[d89464d]`](https://github.com/dotnet/corefx/commit/d89464d) Add lineup to projects targeting netcore50
- [`[9cd447d]`](https://github.com/dotnet/corefx/commit/9cd447d) Updating CoreFX dependencies to rc4-24125-00
- [`[c2e686a]`](https://github.com/dotnet/corefx/commit/c2e686a) Update char * to IntPtr for consistency This is suggested by Stephentoub in code review comment
- [`[3cfafdf]`](https://github.com/dotnet/corefx/commit/3cfafdf) Add retry logic when downloading the CLI from Azure blob storage.
- [`[69bc870]`](https://github.com/dotnet/corefx/commit/69bc870) Place netstandard1.0 lib documentation file under ref folder for System.Numerics.Vectors
- [`[a970874]`](https://github.com/dotnet/corefx/commit/a970874) Back out change made in 0eb598b in favor of a different solution.
- [`[3a2d45c]`](https://github.com/dotnet/corefx/commit/3a2d45c) Implement static portable Create methods for ECDsa (#8823)
- [`[0ef6bff]`](https://github.com/dotnet/corefx/commit/0ef6bff) Add ARM softfp cross build support (#8678)
- [`[ec9c656]`](https://github.com/dotnet/corefx/commit/ec9c656) Remove string constants partial duplication
- [`[86bbe93]`](https://github.com/dotnet/corefx/commit/86bbe93) Remove Guid HashCode tests
- [`[5ba471a]`](https://github.com/dotnet/corefx/commit/5ba471a) Update BuildTools to 00425-03
- [`[263c907]`](https://github.com/dotnet/corefx/commit/263c907) Clean up references to DNXCore50.
- [`[7ba4d29]`](https://github.com/dotnet/corefx/commit/7ba4d29) Update tests to use NETCoreApp1.0 moniker
- [`[7469641]`](https://github.com/dotnet/corefx/commit/7469641) Rename the baseline file for ApiCompat to specify net463.
- [`[114cf22]`](https://github.com/dotnet/corefx/commit/114cf22) Adding versioning.md which contains documentation on how versioning is calculated. (#8734)
- [`[41f9406]`](https://github.com/dotnet/corefx/commit/41f9406) Fixing integration error within Http tests.
- [`[91f1698]`](https://github.com/dotnet/corefx/commit/91f1698) Use SchSendAuxRecord in SslStream on Windows.
- [`[5f5af10]`](https://github.com/dotnet/corefx/commit/5f5af10) Remove redundant code from Stack<T>.Contains
- [`[b0b96be]`](https://github.com/dotnet/corefx/commit/b0b96be) Add file with package versions for external packages
- [`[6fe44da]`](https://github.com/dotnet/corefx/commit/6fe44da) Add check to ensure test user deteled.
- [`[0eb598b]`](https://github.com/dotnet/corefx/commit/0eb598b) Move tests that don't specify a target group their own directory.
- [`[1cf83a4]`](https://github.com/dotnet/corefx/commit/1cf83a4) Add back System.Runtime forwards for GCHandle (#8816)
- [`[b0d7d79]`](https://github.com/dotnet/corefx/commit/b0d7d79) Check for NULL before deciding on returning default value
- [`[8cafc29]`](https://github.com/dotnet/corefx/commit/8cafc29) Undefine *Group properties in Interop project ref
- [`[dfeb2a6]`](https://github.com/dotnet/corefx/commit/dfeb2a6) Add ping path for ArchLinux
- [`[7ebaa5a]`](https://github.com/dotnet/corefx/commit/7ebaa5a) Add test for File.ReadLines enumerator disposal
- [`[e93c7c5]`](https://github.com/dotnet/corefx/commit/e93c7c5) Temporarily compile System.Net.Security against Interop ref
- [`[1a8aa38]`](https://github.com/dotnet/corefx/commit/1a8aa38) Fix nuspecs: remove native xplat symbols and check for symbol files before including them.
- [`[f9594b5]`](https://github.com/dotnet/corefx/commit/f9594b5) Update buildtools to version 424-01
- [`[9219717]`](https://github.com/dotnet/corefx/commit/9219717) Fix issue 8783:Interop.mincore.IdnToAscii/IdnToUnicode fails on UWP
- [`[4bd4668]`](https://github.com/dotnet/corefx/commit/4bd4668) Document that APIs may throw IOException
- [`[6d54990]`](https://github.com/dotnet/corefx/commit/6d54990) Include framework references for all .NET Framework facades.
- [`[2f7bb4e]`](https://github.com/dotnet/corefx/commit/2f7bb4e) Update README.md
- [`[b272b83]`](https://github.com/dotnet/corefx/commit/b272b83) Fixed some spelling mistakes.
- [`[ddbb5ea]`](https://github.com/dotnet/corefx/commit/ddbb5ea) Fix dangling Stream in ReadLinesIterator
- [`[233936e]`](https://github.com/dotnet/corefx/commit/233936e) Address PR feedback
- [`[b0cf8bd]`](https://github.com/dotnet/corefx/commit/b0cf8bd) Check if process has started, before checking for exit.
- [`[44d33c4]`](https://github.com/dotnet/corefx/commit/44d33c4) Avoid using tmp subdirectories in Pipes and MMF on Unix
- [`[903523e]`](https://github.com/dotnet/corefx/commit/903523e) Update Buildtools.
- [`[d8c10e0]`](https://github.com/dotnet/corefx/commit/d8c10e0) Enable all tests for System.Numerics.Vectors
- [`[133c71f]`](https://github.com/dotnet/corefx/commit/133c71f) Added additional conditional requirements for diagnostics
- [`[d39cc2f]`](https://github.com/dotnet/corefx/commit/d39cc2f) Fix some named mutex tests
- [`[67b0f94]`](https://github.com/dotnet/corefx/commit/67b0f94) Update NETStandardApp docs to NETCoreApp
- [`[484d3b5]`](https://github.com/dotnet/corefx/commit/484d3b5) Fix various build warnings
- [`[98184f2]`](https://github.com/dotnet/corefx/commit/98184f2) Fix unix failures
- [`[bce28a6]`](https://github.com/dotnet/corefx/commit/bce28a6) Enable GetEra and GetDayOfWeek negative tests in Globalization.Calendars tests
- [`[63531f6]`](https://github.com/dotnet/corefx/commit/63531f6) Fix System.Runtime tests on non EN cultures
- [`[9130bb9]`](https://github.com/dotnet/corefx/commit/9130bb9) Update NETStandard docs for 1.6
- [`[1f8b58a]`](https://github.com/dotnet/corefx/commit/1f8b58a) Address PR feedback
- [`[81ce219]`](https://github.com/dotnet/corefx/commit/81ce219) More clean-up from the removal of System.Runtime.InteropServices.PInvoke.
- [`[474adf7]`](https://github.com/dotnet/corefx/commit/474adf7) Disable warning 1685 (aka multiple predefine types) because some versions of csc are picker then others about whether or not they give this warning (which turns into errors and build breaks).
- [`[697bd95]`](https://github.com/dotnet/corefx/commit/697bd95) Revert "Fix some named mutex tests"
- [`[7474015]`](https://github.com/dotnet/corefx/commit/7474015) Revert "Add FormatterServices.GetUninitializedObject, partial for #8133" (#8741)
- [`[dc9f15e]`](https://github.com/dotnet/corefx/commit/dc9f15e) Remove the KeepAllProjectReferences tag from S.S.C.OpenSsl tests
- [`[834201a]`](https://github.com/dotnet/corefx/commit/834201a) Change X509Certificates test runtime to netcoreapp1.0
- [`[ebb71ce]`](https://github.com/dotnet/corefx/commit/ebb71ce) Bump the Unix TargetFramework to 1.6 for OpenSsl-consuming packages
- [`[c3f1346]`](https://github.com/dotnet/corefx/commit/c3f1346) Update S.S.C.OpenSsl contract
- [`[5be1354]`](https://github.com/dotnet/corefx/commit/5be1354) Update pre-release tags to RC4
- [`[1b61b69]`](https://github.com/dotnet/corefx/commit/1b61b69) Remove the System.Runtime.InteropServices.PInvoke contract (#8626)
- [`[8ea5263]`](https://github.com/dotnet/corefx/commit/8ea5263) Coreclr branch should be a folderized name
- [`[c063408]`](https://github.com/dotnet/corefx/commit/c063408) Remove AssemblyLoadContext.InitializeDefaultContext method (#8730)
- [`[d95030e]`](https://github.com/dotnet/corefx/commit/d95030e) Disable test library (openssl) from projectreference -> package dependency conversion (#8722)
- [`[7dc31ab]`](https://github.com/dotnet/corefx/commit/7dc31ab) Remove dead code from System.Net.CredentialCache
- [`[9cf59be]`](https://github.com/dotnet/corefx/commit/9cf59be) Rename Windows Nano to Windows Nano 2016.

## WCF

- [`[674312d]`](https://github.com/dotnet/wcf/commit/674312d) http://dotnet-ci.cloudapp.net -> https://ci.dot.net
- [`[af8143f]`](https://github.com/dotnet/wcf/commit/af8143f) Remove extra BOM at beginning of file.
- [`[c8e8d80]`](https://github.com/dotnet/wcf/commit/c8e8d80) Update ps1 script with needed changes.
- [`[823c6f4]`](https://github.com/dotnet/wcf/commit/823c6f4) Reference dependencies of common test projects
- [`[edea7e7]`](https://github.com/dotnet/wcf/commit/edea7e7) Update all test project.jsons to avoid downgrades
- [`[20bb03d]`](https://github.com/dotnet/wcf/commit/20bb03d) Move WCF to stable
- [`[dbf3d18]`](https://github.com/dotnet/wcf/commit/dbf3d18) Update CoreFx to preview1-24628-02, CoreCLR to 20161028.01
- [`[9063136]`](https://github.com/dotnet/wcf/commit/9063136) Port to release/1.1.0 custom channel fix
- [`[faf73d0]`](https://github.com/dotnet/wcf/commit/faf73d0) Updating CoreFx dependency to version preview1-24530-04
- [`[e47219d]`](https://github.com/dotnet/wcf/commit/e47219d) Update index for 4.3.0 packages
- [`[92729ef]`](https://github.com/dotnet/wcf/commit/92729ef) Update to use CoreFx preview1 packages.
- [`[131cb68]`](https://github.com/dotnet/wcf/commit/131cb68) Update pre release label to preview1
- [`[44466e6]`](https://github.com/dotnet/wcf/commit/44466e6) Original commit messages in master were: Fix UpnEndpointIdentity on UWP
- [`[164c682]`](https://github.com/dotnet/wcf/commit/164c682) Add WCF channel keywords to ETW events
- [`[65ba96e]`](https://github.com/dotnet/wcf/commit/65ba96e) Port to release/1.1.0 fix to issue #1544
- [`[beb4644]`](https://github.com/dotnet/wcf/commit/beb4644) Fix typo in netci.groovy to correct outerloop servers
- [`[87ce201]`](https://github.com/dotnet/wcf/commit/87ce201) Update netci.groovy for new branches for outerloop
- [`[7e69cb2]`](https://github.com/dotnet/wcf/commit/7e69cb2) Port CoreFx PR #10868 Full-version package dependency verification.
- [`[0a31f58]`](https://github.com/dotnet/wcf/commit/0a31f58) Update code coverage job
- [`[d9cc0d1]`](https://github.com/dotnet/wcf/commit/d9cc0d1) Update buildtools and CoreFx pkg dependency versions.
- [`[a2ac64c]`](https://github.com/dotnet/wcf/commit/a2ac64c) Miscellaneous test property fixes
- [`[4040b67]`](https://github.com/dotnet/wcf/commit/4040b67) Add push triggers for outerloops
- [`[a26844e]`](https://github.com/dotnet/wcf/commit/a26844e) Reenable test disabled by #1347
- [`[2309f4b]`](https://github.com/dotnet/wcf/commit/2309f4b) Update PRService to deal with issues at merge
- [`[ca6b358]`](https://github.com/dotnet/wcf/commit/ca6b358) Removing IssueAttribute as test is working fine
- [`[83869bf]`](https://github.com/dotnet/wcf/commit/83869bf) Final set of changes to complete the port of CoreFx PR 10231
- [`[4c76ca6]`](https://github.com/dotnet/wcf/commit/4c76ca6) Switch to using packageIndex instead of lists
- [`[0735159]`](https://github.com/dotnet/wcf/commit/0735159) Update all project.json with newer versions.
- [`[a26fcf0]`](https://github.com/dotnet/wcf/commit/a26fcf0) Synced all shared scripts to CoreFx latest changes.
- [`[4852d19]`](https://github.com/dotnet/wcf/commit/4852d19) Updating files touched by Mariana in CoreFx PR #10231
- [`[cf43182]`](https://github.com/dotnet/wcf/commit/cf43182) Update IIS Server setup scripts to unlock authentication methods
- [`[4b0bb6e]`](https://github.com/dotnet/wcf/commit/4b0bb6e) Add badges for selfhosted Windows NT outerloops
- [`[d226ed7]`](https://github.com/dotnet/wcf/commit/d226ed7) Update readme.md badges to show all CI builds
- [`[3c9c997]`](https://github.com/dotnet/wcf/commit/3c9c997) Update certificate generation documentation
- [`[d717172]`](https://github.com/dotnet/wcf/commit/d717172) Add msbuild.log to archived outerloop jobs
- [`[a4f7831]`](https://github.com/dotnet/wcf/commit/a4f7831) Add a help job to wcf repo
- [`[e677fd1]`](https://github.com/dotnet/wcf/commit/e677fd1) Add Net.Tcp duplex streamed test using authentication
- [`[1c01db2]`](https://github.com/dotnet/wcf/commit/1c01db2) Replace ReadAheadWrappingStream with BufferedReadStream and make it http only
- [`[fb0636b]`](https://github.com/dotnet/wcf/commit/fb0636b) Add helpers to schedule task completions on our own thread pool
- [`[fc21efc]`](https://github.com/dotnet/wcf/commit/fc21efc) Activate test case, reason for being skipped no longer reproes.
- [`[0e0f015]`](https://github.com/dotnet/wcf/commit/0e0f015) Fix null-ref exception when doing get request
- [`[4e54a8a]`](https://github.com/dotnet/wcf/commit/4e54a8a) Extend CertificateGenerator cert expiration to 90 days
- [`[7eab53e]`](https://github.com/dotnet/wcf/commit/7eab53e) Add script for refreshing server certificates
- [`[69f4c95]`](https://github.com/dotnet/wcf/commit/69f4c95) Add script for scheduled self-hosted service restart
- [`[e43fc4e]`](https://github.com/dotnet/wcf/commit/e43fc4e) Add section on how to file security bugs
- [`[7e11933]`](https://github.com/dotnet/wcf/commit/7e11933) Cleanup SelfHost code to make service endpoint creation easier
- [`[e6a3c77]`](https://github.com/dotnet/wcf/commit/e6a3c77) Disable NetTcp duplex callback test that fails in CI and Helix
- [`[bfffc05]`](https://github.com/dotnet/wcf/commit/bfffc05) Fix reporting for ETW traces in testing
- [`[cdd91da]`](https://github.com/dotnet/wcf/commit/cdd91da) Depend on current version of System.NetSecurity
- [`[b280aff]`](https://github.com/dotnet/wcf/commit/b280aff) Redirect InstallRootCertificate.sh c_rehash output
- [`[059b2b8]`](https://github.com/dotnet/wcf/commit/059b2b8) Convert cURL cert errors to SecurityNegotiationExceptions
- [`[4e3edd9]`](https://github.com/dotnet/wcf/commit/4e3edd9) Enable HttpsTests for platforms that support it
- [`[629cf4b]`](https://github.com/dotnet/wcf/commit/629cf4b) Move X509Certificate package forward in test-runtime
- [`[168bcf2]`](https://github.com/dotnet/wcf/commit/168bcf2) Assert was presuming there would always be a client cert which isn't the case.
- [`[2e10ed0]`](https://github.com/dotnet/wcf/commit/2e10ed0) Fix project solution files
- [`[870dde4]`](https://github.com/dotnet/wcf/commit/870dde4) Convert FactAttributes to WcfFactAttribute in missed files
- [`[d96c97d]`](https://github.com/dotnet/wcf/commit/d96c97d) Adding test which requires endpoint identity parsing to work
- [`[a4d6584]`](https://github.com/dotnet/wcf/commit/a4d6584) Fixes deserializing of endpoint identity from message header
- [`[d693760]`](https://github.com/dotnet/wcf/commit/d693760) Omit empty ETW "Begin" and "End" messages if no events to report
- [`[7ba43bd]`](https://github.com/dotnet/wcf/commit/7ba43bd) Adds IssueAttribute for NET Native inadvertantly omitted
- [`[9a54163]`](https://github.com/dotnet/wcf/commit/9a54163) Enhance OSID detection when running under NET Native
- [`[da38628]`](https://github.com/dotnet/wcf/commit/da38628) Fix UWP issue #1450 and re-enable tests disabled for it.
- [`[f0eb9d6]`](https://github.com/dotnet/wcf/commit/f0eb9d6) Reactivate unit tests disabled by issue #1449
- [`[7821e05]`](https://github.com/dotnet/wcf/commit/7821e05) Emit WCF ETW events whenever a test fail
- [`[6790c15]`](https://github.com/dotnet/wcf/commit/6790c15) Remove the custom rd.xml's initially required for UWP
- [`[2096a85]`](https://github.com/dotnet/wcf/commit/2096a85) Merge with #1455 and #1451 to allow running in UWP
- [`[433697a]`](https://github.com/dotnet/wcf/commit/433697a) Change some NetTcp unit tests to check PlatformNotSupportedException
- [`[2838ad9]`](https://github.com/dotnet/wcf/commit/2838ad9) Change unit tests to use WcfFact
- [`[4bb6c25]`](https://github.com/dotnet/wcf/commit/4bb6c25) Merge with PR #1455
- [`[3ec2d73]`](https://github.com/dotnet/wcf/commit/3ec2d73) Move to xunit 2.2.0-prerelease to get UWP testing to work
- [`[730fd78]`](https://github.com/dotnet/wcf/commit/730fd78) Testing xunit for uwp (#1455)
- [`[85722d4]`](https://github.com/dotnet/wcf/commit/85722d4) Remove call to sudo when chmodding in certtest.props
- [`[918d39e]`](https://github.com/dotnet/wcf/commit/918d39e) Remove Issue(1398) from tests requiring cert+OSX
- [`[589f8ae]`](https://github.com/dotnet/wcf/commit/589f8ae) Add IncludeTestsWithIssues TestProperty
- [`[946b73b]`](https://github.com/dotnet/wcf/commit/946b73b) Update project.json to take in X509Certificate fix
- [`[d9663fd]`](https://github.com/dotnet/wcf/commit/d9663fd) Add /p:Peer_Certificate_Installed=true to CI build
- [`[0241f42]`](https://github.com/dotnet/wcf/commit/0241f42) Add support to use existing repo for IIS hosted WCF test service setup
- [`[20d9795]`](https://github.com/dotnet/wcf/commit/20d9795) Update netci.groovy to enforce certificate tests in CI
- [`[4f40671]`](https://github.com/dotnet/wcf/commit/4f40671) Modify InstallRootCertificate.sh to support OpenSUSE
- [`[3ba8445]`](https://github.com/dotnet/wcf/commit/3ba8445) Use IssueAttribute to disable WebSockets tests on Win7
- [`[4a4ea07]`](https://github.com/dotnet/wcf/commit/4a4ea07) Fix WcfTheory discoverer to use theory data
- [`[ee92774]`](https://github.com/dotnet/wcf/commit/ee92774) Add execution permission to the cert installation file
- [`[c898c77]`](https://github.com/dotnet/wcf/commit/c898c77) Add better checks for detecting detached HEAD in PRService (#1406)
- [`[630cac7]`](https://github.com/dotnet/wcf/commit/630cac7) Add ActiveIssue back to Tof conditional code
- [`[3262f96]`](https://github.com/dotnet/wcf/commit/3262f96) Replace Fact, ConditionalFact and ActiveIssue
- [`[015ad3a]`](https://github.com/dotnet/wcf/commit/015ad3a) Fix exception thrown in .Net native when a certificate has been revoked
- [`[17e5f76]`](https://github.com/dotnet/wcf/commit/17e5f76) Make WS tests concurrent safe
- [`[e64e51a]`](https://github.com/dotnet/wcf/commit/e64e51a) Update WCF packages to beta-24329-01
- [`[64a2582]`](https://github.com/dotnet/wcf/commit/64a2582) Add more OSID enum values for Windows
- [`[f190852]`](https://github.com/dotnet/wcf/commit/f190852) Improve detection of Windows OS
- [`[38ebc5f]`](https://github.com/dotnet/wcf/commit/38ebc5f) Change to use Content copy installRootCertificate
- [`[c1a263f]`](https://github.com/dotnet/wcf/commit/c1a263f) Temporarily put back project.json files to unblock VSO
- [`[38bf8f3]`](https://github.com/dotnet/wcf/commit/38bf8f3) Revert "This change will not merge"
- [`[a47b560]`](https://github.com/dotnet/wcf/commit/a47b560) Call installation script only needed and exclude OSX cert tests
- [`[d52970f]`](https://github.com/dotnet/wcf/commit/d52970f) Exclude tests need A libcurl built with OpenSSL is required
- [`[df0113c]`](https://github.com/dotnet/wcf/commit/df0113c) Use /tmp folder instead of ~/tmp
- [`[78d0303]`](https://github.com/dotnet/wcf/commit/78d0303) This change will not merge
- [`[e7d9824]`](https://github.com/dotnet/wcf/commit/e7d9824) Enable cert installation
- [`[fc627e6]`](https://github.com/dotnet/wcf/commit/fc627e6) Use one single master json file for all scenario test projects.
- [`[6258983]`](https://github.com/dotnet/wcf/commit/6258983) Add new [WcfFact] and [WcfTheory] attributes to generalize ConditionalFact
- [`[6206ff5]`](https://github.com/dotnet/wcf/commit/6206ff5) Add new platforms for CI testing
- [`[c96877a]`](https://github.com/dotnet/wcf/commit/c96877a) Enable basic auth tests with domainless custom authenticator
- [`[c44f927]`](https://github.com/dotnet/wcf/commit/c44f927) Add TestNugetRuntimeId to TestProperties
- [`[60f8ddb]`](https://github.com/dotnet/wcf/commit/60f8ddb) Use WebSockets ppkg version supported on unix and enable tests
- [`[cff543a]`](https://github.com/dotnet/wcf/commit/cff543a) Clean-up MessageInterceptor test.
- [`[46dfd1b]`](https://github.com/dotnet/wcf/commit/46dfd1b) Update shared scripts and pre-release pkg versions.
- [`[1caf5e0]`](https://github.com/dotnet/wcf/commit/1caf5e0) Modify TestHost.svc utility class
- [`[19f55c6]`](https://github.com/dotnet/wcf/commit/19f55c6) Modify InstallRootCertificate.sh to output results of cURL
- [`[801b314]`](https://github.com/dotnet/wcf/commit/801b314) Change CertificateGenerator certificate issuer name
- [`[76b0055]`](https://github.com/dotnet/wcf/commit/76b0055) Fixup InstallRotCertificate.sh hitting old endpoint
- [`[36a018c]`](https://github.com/dotnet/wcf/commit/36a018c) Rename PeerOrChainTrust endpoint to ChainTrust to clarify purpose.
- [`[00c4201]`](https://github.com/dotnet/wcf/commit/00c4201) Update Scenario test projects with .pkgproj references.
- [`[2419e83]`](https://github.com/dotnet/wcf/commit/2419e83) Improve PeerTrust scenario tests
- [`[505b870]`](https://github.com/dotnet/wcf/commit/505b870) Update the Facade test projects to use .pkgproj references.
- [`[000610b]`](https://github.com/dotnet/wcf/commit/000610b) Updating to latest build tools version.
- [`[d7117ba]`](https://github.com/dotnet/wcf/commit/d7117ba) Update BuildTools to version 00615-07
- [`[229d11a]`](https://github.com/dotnet/wcf/commit/229d11a) Move tests to pre-release test files.
- [`[df6eb3a]`](https://github.com/dotnet/wcf/commit/df6eb3a) Move PeerTrust tests into pre-release test files.
- [`[6f9c3f1]`](https://github.com/dotnet/wcf/commit/6f9c3f1) Rename scenario test files to reflect most recent released version of S.P.SM
- [`[afd6f41]`](https://github.com/dotnet/wcf/commit/afd6f41) Adding default value for FilterToTestTFM property now being used in VSO runs.
- [`[1d49321]`](https://github.com/dotnet/wcf/commit/1d49321) Fixup InstallRootCertificate.sh to hit new endpoint
- [`[38b5173]`](https://github.com/dotnet/wcf/commit/38b5173) Add Support For Xamarin and Mono for WCF Facades.
- [`[cf9ef23]`](https://github.com/dotnet/wcf/commit/cf9ef23) Latest CoreFx changes to various shared scripts.
- [`[5f6c6fc]`](https://github.com/dotnet/wcf/commit/5f6c6fc) Fixes infrastructure issue with acquiring peer trust certificate
- [`[9ad140c]`](https://github.com/dotnet/wcf/commit/9ad140c) Update to version 24308-02
- [`[6397957]`](https://github.com/dotnet/wcf/commit/6397957) Change UtilTestWebServiceHost to TestHostWebServiceHost
- [`[d3b93d7]`](https://github.com/dotnet/wcf/commit/d3b93d7) Modify test clients to point to new REST endpoint
- [`[73a5f31]`](https://github.com/dotnet/wcf/commit/73a5f31) Rename Util class to TestHost
- [`[2b77c49]`](https://github.com/dotnet/wcf/commit/2b77c49) Remove TestRootCertificateInstaller
- [`[5c36d8a]`](https://github.com/dotnet/wcf/commit/5c36d8a) Change test certificate acquisition to REST endpoint
- [`[4d9c446]`](https://github.com/dotnet/wcf/commit/4d9c446) Add explicit WCF dependencies to test-runtime project.json
- [`[915159a]`](https://github.com/dotnet/wcf/commit/915159a) Fix issue with ProducerConsumerStream/MessageContent not completing after entire request has been sent
- [`[f5adad6]`](https://github.com/dotnet/wcf/commit/f5adad6) Update main SLN for new infrastructure test project location
- [`[8cf608c]`](https://github.com/dotnet/wcf/commit/8cf608c) Enable X509CertificateValidationMode PeerTrust
- [`[841b1bd]`](https://github.com/dotnet/wcf/commit/841b1bd) Updating to buildtools version 530-02 and additional changes.
- [`[77d5f50]`](https://github.com/dotnet/wcf/commit/77d5f50) Fixing invalid comments in project.json files.
- [`[30b9746]`](https://github.com/dotnet/wcf/commit/30b9746) Updating sh files per corefx PR #9469
- [`[3ea4ed2]`](https://github.com/dotnet/wcf/commit/3ea4ed2) Port of CoreFx PR #9129
- [`[dec0bf6]`](https://github.com/dotnet/wcf/commit/dec0bf6) Removing tests of infrastructure code.
- [`[2db4348]`](https://github.com/dotnet/wcf/commit/2db4348) Fix Digest authentication test that should not run on NET Native
- [`[be94267]`](https://github.com/dotnet/wcf/commit/be94267) Modify digest authenticator to accept realm\\username or realm\username username
- [`[16358f6]`](https://github.com/dotnet/wcf/commit/16358f6) Branchify repo CI queues (#1338)
- [`[b141f1a]`](https://github.com/dotnet/wcf/commit/b141f1a) Update feature table * Update known issue link to the WCF release note. * Simplify SPN and UPN columns. The detail has been added to the acutal issue.
- [`[f1b5ed3]`](https://github.com/dotnet/wcf/commit/f1b5ed3) Don't wrap all exceptions in SSLStreamSecurityUpgradeProvider
- [`[5d3fd98]`](https://github.com/dotnet/wcf/commit/5d3fd98) Updating to WCF package version beta-24229-01
- [`[fa9d0dc]`](https://github.com/dotnet/wcf/commit/fa9d0dc) Updated all wcf packages references to Beta-24228-04
- [`[f64114d]`](https://github.com/dotnet/wcf/commit/f64114d) Fix MessageInterceptor test
- [`[ab17582]`](https://github.com/dotnet/wcf/commit/ab17582) Fix issue where custom channels' OnOpen and OnClose were not called.
- [`[81b6eba]`](https://github.com/dotnet/wcf/commit/81b6eba) Removing HELIX condition for ServiceModel project reference.
- [`[1708156]`](https://github.com/dotnet/wcf/commit/1708156) Auto-trigger outerloop CI builds upon PR
- [`[a4b5326]`](https://github.com/dotnet/wcf/commit/a4b5326) Add condition to proj ref of S.P.SM
- [`[10019d6]`](https://github.com/dotnet/wcf/commit/10019d6) Re-enable digest no-domain tests on windows
- [`[32288b3]`](https://github.com/dotnet/wcf/commit/32288b3) Update documentation of WCF package versions for .NET core 1.0
- [`[025c772]`](https://github.com/dotnet/wcf/commit/025c772) Json file was missing the new runtimes and causing VSO failure.
- [`[00c2e88]`](https://github.com/dotnet/wcf/commit/00c2e88) Removing leftover reference to "Bridge" in TestRootCertificateInstaller
- [`[22d89bc]`](https://github.com/dotnet/wcf/commit/22d89bc) RTM release feature table
- [`[13cd57e]`](https://github.com/dotnet/wcf/commit/13cd57e) Change certificate installer scripts' corerun location
- [`[fe31565]`](https://github.com/dotnet/wcf/commit/fe31565) Move TestRootCertificateInstaller to tools directory
- [`[2643256]`](https://github.com/dotnet/wcf/commit/2643256) Rename BridgeCertificateIntsaller to TestRootCertificateInstaller
- [`[ef0206e]`](https://github.com/dotnet/wcf/commit/ef0206e) Remove setting of RuntimeIdGraphDefinitionFile
- [`[f6c23c3]`](https://github.com/dotnet/wcf/commit/f6c23c3) Prepare to update packages to latest
- [`[3616277]`](https://github.com/dotnet/wcf/commit/3616277) Update packages to latest.
- [`[e0c2793]`](https://github.com/dotnet/wcf/commit/e0c2793) Add code of conduct to README.md
- [`[f006d07]`](https://github.com/dotnet/wcf/commit/f006d07) Port core fx p rs to shared scripts june21 (#1318)
- [`[03baf04]`](https://github.com/dotnet/wcf/commit/03baf04) Automate certificate install for OSX, other *nixes
- [`[7d5a628]`](https://github.com/dotnet/wcf/commit/7d5a628) Enable test as issue 1248 is fixed
- [`[cfc1f06]`](https://github.com/dotnet/wcf/commit/cfc1f06) Porting corefx PR #9447
- [`[f537642]`](https://github.com/dotnet/wcf/commit/f537642) Porting corefx PR #9183 and #8997
- [`[be07293]`](https://github.com/dotnet/wcf/commit/be07293) Merge pull request #9365
- [`[48ebf78]`](https://github.com/dotnet/wcf/commit/48ebf78) Porting corefx PR #8397
- [`[d80faac]`](https://github.com/dotnet/wcf/commit/d80faac) Also replace ActiveIssue 1295 and 1297 with new ConditionalFact
- [`[30afa6a]`](https://github.com/dotnet/wcf/commit/30afa6a) Remove ActiveIssue(1223) to re-enable tests that failed in CI
- [`[34e0b74]`](https://github.com/dotnet/wcf/commit/34e0b74) Make certificate ConditionalFacts allow explicit overrides
- [`[ddce265]`](https://github.com/dotnet/wcf/commit/ddce265) Build product assemblies against stable packages
- [`[c950b01]`](https://github.com/dotnet/wcf/commit/c950b01) Bump versions across WCF and move to beta
- [`[75cc429]`](https://github.com/dotnet/wcf/commit/75cc429) Adding PS script needed to publish packages via VSO pipeline.
- [`[e3af9e1]`](https://github.com/dotnet/wcf/commit/e3af9e1) Switch WCF away from Microsoft.NETCore.Console and transitiviely Microsoft.NETCore.ConsoleHost.
- [`[20d7088]`](https://github.com/dotnet/wcf/commit/20d7088) Disable TCP Negotiate tests using explicit credentials
- [`[7189726]`](https://github.com/dotnet/wcf/commit/7189726) Moving test case into correct location.
- [`[fe1c77a]`](https://github.com/dotnet/wcf/commit/fe1c77a) Replace ActiveIssue 851 and 1265 with ConditionalFact
- [`[19ec550]`](https://github.com/dotnet/wcf/commit/19ec550) Update PRService to be robust when fetching new branches
- [`[510f669]`](https://github.com/dotnet/wcf/commit/510f669) Fixing issues related to full xunit not being supported in ToF.
- [`[18ae7d7]`](https://github.com/dotnet/wcf/commit/18ae7d7) Update project.json files to support additional runtimes.
- [`[b87bb90]`](https://github.com/dotnet/wcf/commit/b87bb90) Unlock the IIS config section to allow sslFlags to be overriden
- [`[85c8ef7]`](https://github.com/dotnet/wcf/commit/85c8ef7) Changes needed to move WCF from TFS to VSO build pipeline.
- [`[f6bc1e8]`](https://github.com/dotnet/wcf/commit/f6bc1e8) Full sync of dir.props to the corefx version.
- [`[46701de]`](https://github.com/dotnet/wcf/commit/46701de) Updating to package version rc3-24206
- [`[651c622]`](https://github.com/dotnet/wcf/commit/651c622) Update buildtools to add Serviceable to nupkgs (#1267)
- [`[a2fe46c]`](https://github.com/dotnet/wcf/commit/a2fe46c) Reactivate tests for Certificate Revocation
- [`[834dd67]`](https://github.com/dotnet/wcf/commit/834dd67) Fix Clean build of pkgproj without restore
- [`[c5118f3]`](https://github.com/dotnet/wcf/commit/c5118f3) Fix package baseline
- [`[80d8a58]`](https://github.com/dotnet/wcf/commit/80d8a58) Disable event channel usage
- [`[ebd9c10]`](https://github.com/dotnet/wcf/commit/ebd9c10) Enable self-host startup script to run as Local System conditionally
- [`[3f93c6c]`](https://github.com/dotnet/wcf/commit/3f93c6c) Wait until message has been sent before completing HttpClient.SendAsync
- [`[9d8d532]`](https://github.com/dotnet/wcf/commit/9d8d532) Exclude scenario tests if not building for OuterLoop
- [`[1fd17d5]`](https://github.com/dotnet/wcf/commit/1fd17d5) Lengthen the ping wait time for starting self-host server
- [`[6dbb900]`](https://github.com/dotnet/wcf/commit/6dbb900) Fix async duplex issue that uses wrong OperationContext
- [`[c8b9490]`](https://github.com/dotnet/wcf/commit/c8b9490) Create security subfolders in IIS host server
- [`[4ff5d1c]`](https://github.com/dotnet/wcf/commit/4ff5d1c) Adding tests for validating certificates with PeerTrust on https.
- [`[a881eb4]`](https://github.com/dotnet/wcf/commit/a881eb4) Update tests marked with ActiveIssue #592 to #945
- [`[931230a]`](https://github.com/dotnet/wcf/commit/931230a) Fix permissions on sync.sh to make it executable
- [`[79e995e]`](https://github.com/dotnet/wcf/commit/79e995e) Update certificate installer script for new test service
- [`[1b363d8]`](https://github.com/dotnet/wcf/commit/1b363d8) Enable client certificates and server certificate validation using HttpClientHandler
- [`[6018ab5]`](https://github.com/dotnet/wcf/commit/6018ab5) Port PR dotnet/corefx#8565
- [`[6c23da6]`](https://github.com/dotnet/wcf/commit/6c23da6) Update package versions to rc3-24117-00
- [`[527ebab]`](https://github.com/dotnet/wcf/commit/527ebab) Update buildtools to version 1.0.25-prerelease-00424-01
- [`[d6172fe]`](https://github.com/dotnet/wcf/commit/d6172fe) Automatically include framework references for net45 configurations.
- [`[6b905d5]`](https://github.com/dotnet/wcf/commit/6b905d5) Add conditional fact for the two new tests need root cert
- [`[b794676]`](https://github.com/dotnet/wcf/commit/b794676) Add retry logic when downloading the CLI from Azure blob storage.
- [`[8e9d713]`](https://github.com/dotnet/wcf/commit/8e9d713) Add the support of RTM branch to the CI
- [`[34f56dc]`](https://github.com/dotnet/wcf/commit/34f56dc) Make flakey outerloop test more stable
- [`[a9da7f4]`](https://github.com/dotnet/wcf/commit/a9da7f4) Update to build tools version 00420-01
- [`[7aca419]`](https://github.com/dotnet/wcf/commit/7aca419) Port PR dotnet/corefx#8590
- [`[07aa307]`](https://github.com/dotnet/wcf/commit/07aa307) Port PR dotnet/corefx#8508
- [`[61701a8]`](https://github.com/dotnet/wcf/commit/61701a8) Port PR dotnet/corefx#8656
- [`[8f7ccb0]`](https://github.com/dotnet/wcf/commit/8f7ccb0) Port PR dotnet/corefx#8401
- [`[d7cc69a]`](https://github.com/dotnet/wcf/commit/d7cc69a) Port dotnet/corefx #8707
- [`[be5e91b]`](https://github.com/dotnet/wcf/commit/be5e91b) Verify WebSockets are actually used when not using a callback.
- [`[a103c24]`](https://github.com/dotnet/wcf/commit/a103c24) Update dev guide doc
- [`[6ecb0a7]`](https://github.com/dotnet/wcf/commit/6ecb0a7) Update pre-release tags to RC4
- [`[a69e494]`](https://github.com/dotnet/wcf/commit/a69e494) Add scenario testing guide

## CLI

- [`[31b342d]`](https://github.com/dotnet/cli/commit/31b342d) Making another dummy commit to force a build.
- [`[af9463c]`](https://github.com/dotnet/cli/commit/af9463c) Making another simple change to a document to force a build with a new version.
- [`[86f11ab]`](https://github.com/dotnet/cli/commit/86f11ab) Forcing a new commit and a new build to pick up the latest sharedfx packages.
- [`[24a4626]`](https://github.com/dotnet/cli/commit/24a4626) Updating the branding by removing preview1 from the shared framework.
- [`[58056fb]`](https://github.com/dotnet/cli/commit/58056fb) Updating the shared framework
- [`[07fc6be]`](https://github.com/dotnet/cli/commit/07fc6be) Fix Windows-specific test path
- [`[afeeb48]`](https://github.com/dotnet/cli/commit/afeeb48) Test fixes for netcoreapp1.1
- [`[00176ce]`](https://github.com/dotnet/cli/commit/00176ce) Update dependency versions and add fedora.24-x64 rid
- [`[5cfb147]`](https://github.com/dotnet/cli/commit/5cfb147) Add build configuration pieces for Fedora 24
- [`[3753fb9]`](https://github.com/dotnet/cli/commit/3753fb9) Another version fix. Adding preview2-1 to the versions.
- [`[57dcce0]`](https://github.com/dotnet/cli/commit/57dcce0) Another attempt at fixing the version numbers.
- [`[1ac207c]`](https://github.com/dotnet/cli/commit/1ac207c) Changing the version of IntenalAbstractions and DependencyModel to 1.0.0-preview2-1-*
- [`[238d03c]`](https://github.com/dotnet/cli/commit/238d03c) Updating the suffix for the repo to preview2-1 and updating some package versions that were clashing with preview2 packages.
- [`[12d12f9]`](https://github.com/dotnet/cli/commit/12d12f9) Applying @brthor perf improvement to GetTypeBuildExclusionList.
- [`[2a8d874]`](https://github.com/dotnet/cli/commit/2a8d874) Setting System.Text.Encoding.CodePages to 4.0.1, since that's the version in the shared framework.
- [`[46a298d]`](https://github.com/dotnet/cli/commit/46a298d) Updating dependencies through update_dependencies tool.
- [`[df3e3c2]`](https://github.com/dotnet/cli/commit/df3e3c2) Updating the shared framework version to 1.1.0-preview1-001100-00
- [`[5a63a3a]`](https://github.com/dotnet/cli/commit/5a63a3a) Updating branding for preview2.1
- [`[19ae7b9]`](https://github.com/dotnet/cli/commit/19ae7b9) Fix the projects versions to be preview2-1.
- [`[914a095]`](https://github.com/dotnet/cli/commit/914a095) Add ubuntu.16.10 and opensuse42.1 to netci.groovy (#4335)
- [`[10cacd1]`](https://github.com/dotnet/cli/commit/10cacd1) [rel/1.0.0-preview2.1] Add support for building and testing on new RIDs (#4329)
- [`[3b205e8]`](https://github.com/dotnet/cli/commit/3b205e8) Update 1.0.0-preview2.1 branch to the 1.1 shared framework (#4319)
- [`[0a6d23d]`](https://github.com/dotnet/cli/commit/0a6d23d) Updating the branding in one other file that I missed before.
- [`[81edbae]`](https://github.com/dotnet/cli/commit/81edbae) Updating branding to preview2.1
- [`[ae5f699]`](https://github.com/dotnet/cli/commit/ae5f699) Updating CoreClr, CoreSetup to servicing-24603-01, servicing-004528-00 respectively
- [`[f065a29]`](https://github.com/dotnet/cli/commit/f065a29) Rename IsCurrentRuntimeSupported() to SupportsCurrentRuntime().
- [`[283bf71]`](https://github.com/dotnet/cli/commit/283bf71) Changing the rules on when to use the CLI's BuildRid.
- [`[ce6c296]`](https://github.com/dotnet/cli/commit/ce6c296) Adding "BuildRid" to the CLI as a fallback RID to use when inferring which RID to use when building, running, and publishing self-contained applications.
- [`[71440a7]`](https://github.com/dotnet/cli/commit/71440a7) Fix the VC Redist links in the installer.
- [`[5e173f3]`](https://github.com/dotnet/cli/commit/5e173f3) Update versions of EF and scaffolding tools
- [`[6bd5bfc]`](https://github.com/dotnet/cli/commit/6bd5bfc) Update Kestrel to 1.0.1
- [`[6a1b41f]`](https://github.com/dotnet/cli/commit/6a1b41f) Update version of routing to 1.0.1
- [`[07b581f]`](https://github.com/dotnet/cli/commit/07b581f) Add missing comma to F# lib project.json
- [`[9646db0]`](https://github.com/dotnet/cli/commit/9646db0) Update cshtml wildcard in publishOptions
- [`[5d8aede]`](https://github.com/dotnet/cli/commit/5d8aede) Don't print arguments in F# console app
- [`[0c10baa]`](https://github.com/dotnet/cli/commit/0c10baa) Update F# dotnet-new templates for Preview 2 (Enrico Sada rebase)
- [`[01caa0f]`](https://github.com/dotnet/cli/commit/01caa0f) Update MVC version to 1.0.1
- [`[8fcfc2a]`](https://github.com/dotnet/cli/commit/8fcfc2a) Upgrade Corefx and coreclr references
- [`[1e9d529]`](https://github.com/dotnet/cli/commit/1e9d529) fix typo in dotnet-install file
- [`[574a3c8]`](https://github.com/dotnet/cli/commit/574a3c8) Remove the VS2012 CRT dependency from docs (#3632)
- [`[0708fe0]`](https://github.com/dotnet/cli/commit/0708fe0) Fix README to use hostfxr download links (#3622)
- [`[0ac44a4]`](https://github.com/dotnet/cli/commit/0ac44a4) Fix Oracle Linux version in README.md
- [`[db7f687]`](https://github.com/dotnet/cli/commit/db7f687) Use NugetCache Sentinel for Telemetry setting.
- [`[15a5c34]`](https://github.com/dotnet/cli/commit/15a5c34) Add Serviceable assembly attribute and nuspec attributes for all shipping CLI assemblies.
- [`[6b54ae0]`](https://github.com/dotnet/cli/commit/6b54ae0) Trim platfrom libraries from deps fiels
- [`[658083d]`](https://github.com/dotnet/cli/commit/658083d) [DO NOT MERGE] Update known-issues.md (#3559)
- [`[eab2494]`](https://github.com/dotnet/cli/commit/eab2494) Remove showing firsttime eula for non verbs.
- [`[bc61034]`](https://github.com/dotnet/cli/commit/bc61034) Fix eula.rtf formatting
- [`[0cd5afb]`](https://github.com/dotnet/cli/commit/0cd5afb) Updating DiaSymReader to 1.0.8
- [`[638e4c7]`](https://github.com/dotnet/cli/commit/638e4c7) Fix HostFXR in dotnet-dev package
- [`[8dd2479]`](https://github.com/dotnet/cli/commit/8dd2479) Check if project.json exists before creating new project in the same dir (#3543)
- [`[b37ddf7]`](https://github.com/dotnet/cli/commit/b37ddf7) mark InternalAbstractions and DependencyModel Stable
- [`[482a337]`](https://github.com/dotnet/cli/commit/482a337) add deb deps to ubuntu 16 dockerfile
- [`[871d25a]`](https://github.com/dotnet/cli/commit/871d25a) Add LZMA to THIRD-PARTY-NOTICES + (c) header
- [`[e0444d5]`](https://github.com/dotnet/cli/commit/e0444d5) Temporarily disable dotnet-compile-fsc
- [`[4da4f95]`](https://github.com/dotnet/cli/commit/4da4f95) Update documentation (#3549)
- [`[9e97d04]`](https://github.com/dotnet/cli/commit/9e97d04) dotnet-compile-fsc bump to latest
- [`[277b2e7]`](https://github.com/dotnet/cli/commit/277b2e7) re-enable first time experience for the first-time experience tests
- [`[f75ee87]`](https://github.com/dotnet/cli/commit/f75ee87) Enable ubuntu16 deb creation and publishing
- [`[2663d03]`](https://github.com/dotnet/cli/commit/2663d03) Fix cherrypick error
- [`[9b1415d]`](https://github.com/dotnet/cli/commit/9b1415d) Update FSharp Test Assets to preview2
- [`[b81ef0f]`](https://github.com/dotnet/cli/commit/b81ef0f) Fix .deb package name to include versions
- [`[263b80e]`](https://github.com/dotnet/cli/commit/263b80e) Add HostFXR to UpdateDependencies
- [`[a8f05f2]`](https://github.com/dotnet/cli/commit/a8f05f2) Remove the hostfxr debian target
- [`[716ff73]`](https://github.com/dotnet/cli/commit/716ff73) Fix target chaining into hostfxr
- [`[469406d]`](https://github.com/dotnet/cli/commit/469406d) Fix description of hostfxr
- [`[0f640a3]`](https://github.com/dotnet/cli/commit/0f640a3) download fxr installer file, use it in pkg targets
- [`[e3c53c1]`](https://github.com/dotnet/cli/commit/e3c53c1) Bring Host FXR MSI
- [`[635c333]`](https://github.com/dotnet/cli/commit/635c333) Update to Json.NET 9.0.1
- [`[a4cef6d]`](https://github.com/dotnet/cli/commit/a4cef6d) Updating NuGet to beta2-1484
- [`[1a9b16a]`](https://github.com/dotnet/cli/commit/1a9b16a) Adding dotnet-core feed to the NuGet.config since that has the stable versions of the .NET runtime.
- [`[f25f047]`](https://github.com/dotnet/cli/commit/f25f047) Updating CoreFX, CoreCLR, Roslyn, CoreSetup to stable versions.
- [`[dfe99ca]`](https://github.com/dotnet/cli/commit/dfe99ca) Port https://github.com/dotnet/core-setup/pull/159 to CLI
- [`[96caa64]`](https://github.com/dotnet/cli/commit/96caa64) Adding Oracle Linux and Linux Mint to the titles
- [`[5790182]`](https://github.com/dotnet/cli/commit/5790182) Remove File.Copy optimization during expansion
- [`[0390599]`](https://github.com/dotnet/cli/commit/0390599) Moving Ubuntu 16.04 to be next to Ubuntu 14.04
- [`[e575c1e]`](https://github.com/dotnet/cli/commit/e575c1e) Update README.md
- [`[42e890d]`](https://github.com/dotnet/cli/commit/42e890d) reenable deb
- [`[3c5e51a]`](https://github.com/dotnet/cli/commit/3c5e51a) System.Private.CoreLib.dll IL binary is getting crossgen'd mistakenly.
- [`[c1c7ca0]`](https://github.com/dotnet/cli/commit/c1c7ca0) Update NuGet to 3.5.0-beta2-1480
- [`[79bbfaf]`](https://github.com/dotnet/cli/commit/79bbfaf) Fix the project.json for C# library and add tests (#3507)
- [`[99c3242]`](https://github.com/dotnet/cli/commit/99c3242) Update Microsoft.DiaSymReader to 1.0.8-rc2-60610-01
- [`[2aa3dd0]`](https://github.com/dotnet/cli/commit/2aa3dd0) Updating CoreFx, CoreClr, Roslyn, CoreSetup to rc3-24210-10, rc3-24210-10, beta1-20160610-04, rc3-3004459-00 respectively
- [`[686e09d]`](https://github.com/dotnet/cli/commit/686e09d) Removed the CompileCliSdkAndGenerateNuGetPackagesArchive method from CompileTargets and replaced with CompileCliSDk. Also used stage1 to generate the archive for stage2.
- [`[d8c590e]`](https://github.com/dotnet/cli/commit/d8c590e) When creating the handle to the in progress sentinel, it was failing because the nuget cache folder did not exist yet. Which translated to us understanding that a first time experience was already running. Now, before creating the handle, we check if the nuget folder exists, if it doesn't, we create it, instead of waiting for nuget to do that during restore.
- [`[762a259]`](https://github.com/dotnet/cli/commit/762a259) fix #3469 by correcting overflow and enabling tests (#3471)
- [`[2b427bf]`](https://github.com/dotnet/cli/commit/2b427bf) Add copyright headers and cleanup
- [`[105e5ab]`](https://github.com/dotnet/cli/commit/105e5ab) Introducing a in progress sentinel that gets verified before running the first time experience. If we can get a handle for this sentinel, we proceed with the first time run, otherwise, it means there is a first time experience running already, in which case we continue running dotnet normally, even though the final (real) sentinel is not present yet. This prevents multiple dotnet commands from running the first time experience in parallel and prevents us from running into parallel nuget restores.
- [`[ed7e583]`](https://github.com/dotnet/cli/commit/ed7e583) Addressing code review comments and adding a DOTNET_SKIP_FIRST_TIME_EXPERIENCE env variable to have a way to turn off the feature.
- [`[4d631cc]`](https://github.com/dotnet/cli/commit/4d631cc) Update dest path & fix race reporting progress
- [`[bcadd6f]`](https://github.com/dotnet/cli/commit/bcadd6f) Fixing identation and spaces in a few files.
- [`[f27330a]`](https://github.com/dotnet/cli/commit/f27330a) Revert "move all version suffixes to preview3 and rc4"
- [`[69f43be]`](https://github.com/dotnet/cli/commit/69f43be) Adding the code to extract the archive in the first use of dotnet an d added the first time use welcome text as well as some E2E tests.
- [`[5f220a1]`](https://github.com/dotnet/cli/commit/5f220a1) Generating the archive in the sdk folder of stage2.
- [`[4c5f097]`](https://github.com/dotnet/cli/commit/4c5f097) Adding the configurer to dotnet.
- [`[461c26b]`](https://github.com/dotnet/cli/commit/461c26b) Adding a create method to the sentinel and invoking it from the Primer when appropriate.
- [`[ac2e214]`](https://github.com/dotnet/cli/commit/ac2e214) Adding a separate abstraction for the NuGet sentinel.
- [`[8db7c1c]`](https://github.com/dotnet/cli/commit/8db7c1c) Add dotnet-archive application
- [`[4949ced]`](https://github.com/dotnet/cli/commit/4949ced) Fix progress for decompression
- [`[e34d988]`](https://github.com/dotnet/cli/commit/e34d988) Clean up usings
- [`[40bf179]`](https://github.com/dotnet/cli/commit/40bf179) Add IndexedArchive
- [`[e8a65dd]`](https://github.com/dotnet/cli/commit/e8a65dd) Port LZMA SDK to .NETStandard1.0 as library
- [`[1cfdb41]`](https://github.com/dotnet/cli/commit/1cfdb41) Initial commit of LZMA SDK
- [`[32962a1]`](https://github.com/dotnet/cli/commit/32962a1) move all version suffixes to preview3 and rc4
- [`[84f6302]`](https://github.com/dotnet/cli/commit/84f6302) Almost all of the code to prime the NuGet cache from the archive.
- [`[19c905d]`](https://github.com/dotnet/cli/commit/19c905d) fix reg key in cli msi
- [`[4293d05]`](https://github.com/dotnet/cli/commit/4293d05) Porting @svick's fix to change a hard-coded URL to a redirect link.
- [`[7b51f28]`](https://github.com/dotnet/cli/commit/7b51f28) Updating CoreFx, CoreClr, CoreSetup to rc3-24210-06, rc3-24210-01, rc3-3004449-00 respectively
- [`[013fa1b]`](https://github.com/dotnet/cli/commit/013fa1b) Removing the nuspec schema change used for adding the serviceable tag.
- [`[dc8f59e]`](https://github.com/dotnet/cli/commit/dc8f59e) Fix the VersionRepoUpdater to handle symbols.nupkg files correctly.
- [`[ef4a8e8]`](https://github.com/dotnet/cli/commit/ef4a8e8) Updating CoreSetup to rc3-004443-00.
- [`[cd9bcd4]`](https://github.com/dotnet/cli/commit/cd9bcd4) Updating CoreFx, CoreClr, CoreSetup to rc3-24209-08, rc3-24208-04, rc3-3004442-00 respectively
- [`[1dc6b0e]`](https://github.com/dotnet/cli/commit/1dc6b0e) Make the nuget cache local to the repo (#3370)
- [`[abcaa59]`](https://github.com/dotnet/cli/commit/abcaa59) Publish symbol.nupkg files to myget.
- [`[1d44105]`](https://github.com/dotnet/cli/commit/1d44105) [Fixes #3421] Made dotnet new templates generate portable pdbs
- [`[6ad3836]`](https://github.com/dotnet/cli/commit/6ad3836) update product monikers to rc2
- [`[4b1735b]`](https://github.com/dotnet/cli/commit/4b1735b) Fixing F# template project.json
- [`[85e4ed2]`](https://github.com/dotnet/cli/commit/85e4ed2) Responding to PR feedback
- [`[c066ef1]`](https://github.com/dotnet/cli/commit/c066ef1) Add C# Lib and xunittest templates
- [`[9a9864b]`](https://github.com/dotnet/cli/commit/9a9864b) Update NuGet Version to 3.5.0-beta2-1451
- [`[f43aad7]`](https://github.com/dotnet/cli/commit/f43aad7) Updating CoreFx, CoreClr, Roslyn, CoreSetup, DiaSymReader to rc3-24208-04, rc3-24208-04, beta1-20160608-03, rc3-004425, rc2-60608-04 respectively
- [`[a2d4f6f]`](https://github.com/dotnet/cli/commit/a2d4f6f) Remove use of Microsoft.Extensions.PlatformAbstractions
- [`[0eb24de]`](https://github.com/dotnet/cli/commit/0eb24de) CLI dotnet/versions build info files should be separated between the branches.
- [`[4a88cff]`](https://github.com/dotnet/cli/commit/4a88cff) [Fixes #3255] Added a web template to dotnet new
- [`[71d39a4]`](https://github.com/dotnet/cli/commit/71d39a4) Update Microsoft.DiaSymReader.Native to 1.4.0-rc2
- [`[d2f1fa0]`](https://github.com/dotnet/cli/commit/d2f1fa0) Updating CoreFx, CoreClr, CoreSetup to rc3-24207-03, rc3-24207-03, rc3-004415 respectively.
- [`[82ef030]`](https://github.com/dotnet/cli/commit/82ef030) Crossgen now requires a Jit package to be specified.
- [`[748516b]`](https://github.com/dotnet/cli/commit/748516b) Add CoreClr dependency to CLI's update-dependencies.
- [`[cdf4407]`](https://github.com/dotnet/cli/commit/cdf4407) Bumping JSON.NET to 9.0.1
- [`[dc5fbc1]`](https://github.com/dotnet/cli/commit/dc5fbc1) Adding basic cycle detection in the dependency walker
- [`[334b079]`](https://github.com/dotnet/cli/commit/334b079) Updating CoreSetup, Roslyn, DiaSymReader to rc3-004408, beta1-20160606-02, 1.0.8-rc2-60606-01 respectively.
- [`[dd51836]`](https://github.com/dotnet/cli/commit/dd51836) fix #2289 by integrating EF's version of project load context (#3402)
- [`[5378f5a]`](https://github.com/dotnet/cli/commit/5378f5a) update nuget to 3.5.0-beta2-1392
- [`[d3b9354]`](https://github.com/dotnet/cli/commit/d3b9354) Fixing schema version number, tweaking a string, and making test call pass a bool instead of a string to enable serviceable.
- [`[391675c]`](https://github.com/dotnet/cli/commit/391675c) Changing schema version to 8 to match NuGet internal value and adding a pack test for the --serviceable option.
- [`[8099e6b]`](https://github.com/dotnet/cli/commit/8099e6b) Adding support for --serviceable option to pack command which puts <serviceable>true</serviceable> into the output nuspec
- [`[42938f1]`](https://github.com/dotnet/cli/commit/42938f1) Updating CoreSetup to rc3-004406
- [`[f347888]`](https://github.com/dotnet/cli/commit/f347888) Pass env into ExecCore
- [`[d76807d]`](https://github.com/dotnet/cli/commit/d76807d) Change 'got' to 'received' for dep conflicts
- [`[354b1d3]`](https://github.com/dotnet/cli/commit/354b1d3) Updating CoreFx, CoreSetup to rc3-24206-00, rc3-004404 respectively
- [`[7adf70d]`](https://github.com/dotnet/cli/commit/7adf70d) Expand timeout setting for project model server
- [`[3e77d1a]`](https://github.com/dotnet/cli/commit/3e77d1a) Moving TestAsset project from netstandard1.5 to 1.6.
- [`[ea8ae8d]`](https://github.com/dotnet/cli/commit/ea8ae8d) Updating CoreFx, CoreSetup to rc3-24204-00, rc3-004400 respectively
- [`[4f95bc0]`](https://github.com/dotnet/cli/commit/4f95bc0) Update CoreSetup to rc3-004397
- [`[9ffe91f]`](https://github.com/dotnet/cli/commit/9ffe91f) Move dependency from Microsoft.NETCore.Runtime to Microsoft.NETCore.Runtime.CoreCLR.
- [`[d4d9653]`](https://github.com/dotnet/cli/commit/d4d9653) Port @ellismg's debian docker file fix to CLI.
- [`[8162f89]`](https://github.com/dotnet/cli/commit/8162f89) Fixing PortableAppWithRuntimeTargetsIsPublishedCorrectly now that libuv is contained in the Shared Framework.
- [`[f16f2e6]`](https://github.com/dotnet/cli/commit/f16f2e6) Updating CoreFx, CoreSetup, Roslyn to rc3-24201-00, rc3-004391, beta1-20160602-01
- [`[5e6ae9c]`](https://github.com/dotnet/cli/commit/5e6ae9c) Add Roslyn as a dependency in update-dependencies.
- [`[c622deb]`](https://github.com/dotnet/cli/commit/c622deb) Removed publish logic that triggered dotnet-preview Docker builds. This logic has been moved to Maestro.
- [`[4557f2a]`](https://github.com/dotnet/cli/commit/4557f2a) update help message
- [`[bb034b3]`](https://github.com/dotnet/cli/commit/bb034b3) Also updating the ubuntu16.04 dockerfile to remove the llvm dependencies
- [`[cc6c22c]`](https://github.com/dotnet/cli/commit/cc6c22c) Fix an error in the fedora23 dockerfile where we added findutils after the && when invoking dnf. That caused findutils to be invoked instead of installed.
- [`[351255d]`](https://github.com/dotnet/cli/commit/351255d) Updating CoreSetup to rc3-004373
- [`[74a9594]`](https://github.com/dotnet/cli/commit/74a9594) Small fixes to update-dependencies.
- [`[64508f0]`](https://github.com/dotnet/cli/commit/64508f0) fixes #2408 stop using corehost to activate projectdependencycommands
- [`[06047ee]`](https://github.com/dotnet/cli/commit/06047ee) Update only the ubuntu.14.04 dockerfile from https://github.com/dotnet/core-setup/pull/58
- [`[c6718df]`](https://github.com/dotnet/cli/commit/c6718df) remove clang-3.5 as a dependency of the deb package
- [`[30b9c89]`](https://github.com/dotnet/cli/commit/30b9c89) fixes #3119
- [`[5f791ff]`](https://github.com/dotnet/cli/commit/5f791ff) We need to prevent downloading deb packages on Ubuntu16.04 since we don't have them there yet. This is a hack and the right fix would be to not use a enum with the BuildPlatform, but something that allowed us to express the platform and the version of the platform.
- [`[aa7cbeb]`](https://github.com/dotnet/cli/commit/aa7cbeb) update netci.groovy to use ubuntu.14.04
- [`[1ed7304]`](https://github.com/dotnet/cli/commit/1ed7304) Fix the location of sharedfx + sharedhost pkgs downloaded from core-setup for the sdk pkg build
- [`[f15a324]`](https://github.com/dotnet/cli/commit/f15a324) Fixing the name of openSUSE for Jenkins.
- [`[5c1f20b]`](https://github.com/dotnet/cli/commit/5c1f20b) Adding the new OSes RIDs to a couple of test projects that were missed before.
- [`[7652335]`](https://github.com/dotnet/cli/commit/7652335) Addressing code review comments and adding opensuse 13.2
- [`[5174fc0]`](https://github.com/dotnet/cli/commit/5174fc0) Fix syntax error in _common.sh
- [`[29bd8be]`](https://github.com/dotnet/cli/commit/29bd8be) Remove some rids from cross plublish tests
- [`[45dc82e]`](https://github.com/dotnet/cli/commit/45dc82e) Remove some dead code
- [`[20f9811]`](https://github.com/dotnet/cli/commit/20f9811) Fix versioned BuildPlatforms logic
- [`[2155a41]`](https://github.com/dotnet/cli/commit/2155a41) Generate correct badges filenames
- [`[a80dcbe]`](https://github.com/dotnet/cli/commit/a80dcbe) Adding fedora 23 and ubuntu 16.04 to the Update-dependencies project.
- [`[636ffac]`](https://github.com/dotnet/cli/commit/636ffac) Undoing documentation changes to include ubuntu16.04. Will add it back once we have VSO builds running happily and producing binaries for it.
- [`[b524fd0]`](https://github.com/dotnet/cli/commit/b524fd0) Undoing documentation changes to include ubuntu16.04. Will add it back once we have VSO builds running happily and producing binaries for it.
- [`[baf9826]`](https://github.com/dotnet/cli/commit/baf9826) Fixing a missing $ for a string formatting
- [`[ca326cb]`](https://github.com/dotnet/cli/commit/ca326cb) Removing dotnet-core from the NuGet.Config and add --disable-parallel to RestoreTestPackages. It was causing issues when reading global.json in Ubuntu and Fedora
- [`[3e9a3d2]`](https://github.com/dotnet/cli/commit/3e9a3d2) Fix syntax error
- [`[6ccc40e]`](https://github.com/dotnet/cli/commit/6ccc40e) Use different moniker for the new distros
- [`[7963018]`](https://github.com/dotnet/cli/commit/7963018) Small changes that I noticed when diffing the files
- [`[e634fed]`](https://github.com/dotnet/cli/commit/e634fed) Adding Fedora 23
- [`[84d1b60]`](https://github.com/dotnet/cli/commit/84d1b60) Adding docker files, modifying scripts and code to handle ubuntu 16.04
- [`[2fb8656]`](https://github.com/dotnet/cli/commit/2fb8656) Removed ASP.NET RC1 section from README (#3261)
- [`[657c03b]`](https://github.com/dotnet/cli/commit/657c03b) Updating CoreFx, CoreSetup to rc3-24131-00, rc3-004363 respectively
- [`[32b6204]`](https://github.com/dotnet/cli/commit/32b6204) Re-enable tests disabled for crossgen enabling
- [`[d50068a]`](https://github.com/dotnet/cli/commit/d50068a) Updating CoreFx, CoreSetup to rc3-24128-00, rc3-004338 respectively
- [`[fad7477]`](https://github.com/dotnet/cli/commit/fad7477) Microsoft.NETCore.App no longer supports netstandard
- [`[5ac3954]`](https://github.com/dotnet/cli/commit/5ac3954) Fix Building from source links in README
- [`[8c7e478]`](https://github.com/dotnet/cli/commit/8c7e478) Fix typo in help for dotnet build
- [`[4a8501e]`](https://github.com/dotnet/cli/commit/4a8501e) Update IncrementalManager.cs
- [`[a087de2]`](https://github.com/dotnet/cli/commit/a087de2) Updating CoreFx, CoreSetup to rc3-24127-01, rc3-004336 respectively
- [`[f314727]`](https://github.com/dotnet/cli/commit/f314727) Sync build_projects/shared-build-targets-utils with Core-Setup
- [`[2a84c13]`](https://github.com/dotnet/cli/commit/2a84c13) add -SharedRuntime switch support
- [`[80820a6]`](https://github.com/dotnet/cli/commit/80820a6) Updating CoreFx, CoreSetup to rc3-24127-00, rc3-004324 respectively
- [`[d5b1ee1]`](https://github.com/dotnet/cli/commit/d5b1ee1) Add version suffix to build cache to ensure incremental builds are reset when it changes (#3246)
- [`[63a786b]`](https://github.com/dotnet/cli/commit/63a786b) Disable tests for crossgen re-enable.
- [`[ef76efa]`](https://github.com/dotnet/cli/commit/ef76efa) Updating CoreFx, CoreSetup to rc3-24126-01, rc3-004322 respectively
- [`[5d0aefe]`](https://github.com/dotnet/cli/commit/5d0aefe) Clean up from the move to RC3 packages. Removed the dotnet-core dependency on NuGet.Config now that we have RC3 packages in the cli-deps feed. Re-enabled crossgen for windows now that we added JITPath to the crossgen call.
- [`[18e3892]`](https://github.com/dotnet/cli/commit/18e3892) Move the Microsoft.NETCore.App dependency under the Framework
- [`[928283d]`](https://github.com/dotnet/cli/commit/928283d) Filter build dependencies from fullclr embedded deps file
- [`[08a3ffe]`](https://github.com/dotnet/cli/commit/08a3ffe) Move to netstandard1.6
- [`[7909c6a]`](https://github.com/dotnet/cli/commit/7909c6a) Stop downloading core setup dependencies in every build, when we already have them.
- [`[409ccb2]`](https://github.com/dotnet/cli/commit/409ccb2) Add WorkingDirectory to output when a command fails for easier debugging.
- [`[369ec93]`](https://github.com/dotnet/cli/commit/369ec93) Update Roslyn to beta1-20160525-03.
- [`[cc178d4]`](https://github.com/dotnet/cli/commit/cc178d4) Update CoreFx, SharedFx to rc3-24126-00, rc3-004312
- [`[6638109]`](https://github.com/dotnet/cli/commit/6638109) stop nuking latest binaries
- [`[70ed305]`](https://github.com/dotnet/cli/commit/70ed305) Update dotnet-new project.json templates
- [`[06ec7dd]`](https://github.com/dotnet/cli/commit/06ec7dd) Add core-setup to update-dependencies.
- [`[14e90f4]`](https://github.com/dotnet/cli/commit/14e90f4) Fix mono/net403 framework assembly references (#3129)
- [`[e9e4427]`](https://github.com/dotnet/cli/commit/e9e4427) Update core-setup dependency versions (#3231)
- [`[b303afb]`](https://github.com/dotnet/cli/commit/b303afb) Remove optimizationdata subdirectory from optimizationdata path (#3242)
- [`[bbd5f75]`](https://github.com/dotnet/cli/commit/bbd5f75) Fix build failure in PublishTargets.
- [`[a7fccf8]`](https://github.com/dotnet/cli/commit/a7fccf8) Fix update-dependencies.ps1 and build scripts to no longer use `restore --infer-runtimes`.
- [`[ee7372c]`](https://github.com/dotnet/cli/commit/ee7372c) Move update-dependencies under build_projects.
- [`[c97648e]`](https://github.com/dotnet/cli/commit/c97648e) Add support to update-dependencies to not update the dependencies in a folder.
- [`[6fe3f86]`](https://github.com/dotnet/cli/commit/6fe3f86) Fix update-dependencies to read all package versions from Latest_Packages.txt.
- [`[5359e16]`](https://github.com/dotnet/cli/commit/5359e16) Re-enable tests
- [`[aa01110]`](https://github.com/dotnet/cli/commit/aa01110) Remove The host build, consume the host build from core-setup
- [`[651e8c2]`](https://github.com/dotnet/cli/commit/651e8c2) perf tests: add fallback feed to dotnet restore (#3160)
- [`[763be30]`](https://github.com/dotnet/cli/commit/763be30) Update known-issues.md (#3240)
- [`[8ffba3c]`](https://github.com/dotnet/cli/commit/8ffba3c) Set DOTNET_CLI_TELEMETRY_PROFILE for CLI Repo builds (#3228)
- [`[8422fcb]`](https://github.com/dotnet/cli/commit/8422fcb) Specify KB information in the prerequisites (#3227)
- [`[785cab3]`](https://github.com/dotnet/cli/commit/785cab3) Reduce nuget output
- [`[2a870ee]`](https://github.com/dotnet/cli/commit/2a870ee) Remove updating dotnet/versions repo with the latest shared framework version.  This is breaking the build, and it should be done in core-setup instead.
- [`[f9d2661]`](https://github.com/dotnet/cli/commit/f9d2661) Add NUGET and GITHUB environment variables to the dockerrun.sh file.
- [`[e47f407]`](https://github.com/dotnet/cli/commit/e47f407) Disable Kestrel.Tests until we can get an ASP.NET RC3 build.
- [`[3953a85]`](https://github.com/dotnet/cli/commit/3953a85) Add test for standalone resource dependency
- [`[05e1d95]`](https://github.com/dotnet/cli/commit/05e1d95) Fix resources break
- [`[c037cf3]`](https://github.com/dotnet/cli/commit/c037cf3) Revert "Merge pull request #3191 from schellap/deps-clean"
- [`[d7a8860]`](https://github.com/dotnet/cli/commit/d7a8860) Exclude System.Private.CoreLib from crossgen
- [`[78bea7d]`](https://github.com/dotnet/cli/commit/78bea7d) Adding JITPath parameter to crossgen
- [`[a9e12e0]`](https://github.com/dotnet/cli/commit/a9e12e0) Updating core packages to rc3-24123-01
- [`[f1d781a]`](https://github.com/dotnet/cli/commit/f1d781a) Fixing a couple of dependency versions for the update-tool and dotnet
- [`[3abae8b]`](https://github.com/dotnet/cli/commit/3abae8b) Revert "HACK: Make the TestAssetsManager create shorter paths for test assets."
- [`[0d555af]`](https://github.com/dotnet/cli/commit/0d555af) HACK: Make the TestAssetsManager create shorter paths for test assets.
- [`[0c463c2]`](https://github.com/dotnet/cli/commit/0c463c2) Remove '--infer-runtimes' option for 'dotnet restore' when restoring TestAssets.
- [`[a2ef88c]`](https://github.com/dotnet/cli/commit/a2ef88c) Upgrade the "dotnet-test-xunit" version to "1.0.0-rc2-192208-24"
- [`[73b2c31]`](https://github.com/dotnet/cli/commit/73b2c31) Add explicit reference to 'System.Text.RegularExpressions' to 'dotnet' project.json
- [`[baf2823]`](https://github.com/dotnet/cli/commit/baf2823) Address PR feedback.
- [`[d2188cd]`](https://github.com/dotnet/cli/commit/d2188cd) Move the CLI corefx dependencies from RC2 to RC3 - rc3-24113-00.
- [`[cbc4f58]`](https://github.com/dotnet/cli/commit/cbc4f58) change optimization data path
- [`[e934859]`](https://github.com/dotnet/cli/commit/e934859) Eliminate response waiting period (#3142)
- [`[5a77b03]`](https://github.com/dotnet/cli/commit/5a77b03) add path to the front of the variable instead of the back
- [`[79a0726]`](https://github.com/dotnet/cli/commit/79a0726) Fix dependency context merge and msbuildproject resolution
- [`[410b5c0]`](https://github.com/dotnet/cli/commit/410b5c0) Pin stage0 versions to 1.0.0-preview2-002818
- [`[dafda03]`](https://github.com/dotnet/cli/commit/dafda03) Revert "Merge pull request #3020 from schellap/deps-clean"
- [`[dd07f0f]`](https://github.com/dotnet/cli/commit/dd07f0f) Strict deps resolution else fail fast
- [`[78e34c6]`](https://github.com/dotnet/cli/commit/78e34c6) Move PullNupkgFilesFromBlob into FinalizeBuild.
- [`[54ab5b8]`](https://github.com/dotnet/cli/commit/54ab5b8) Create supported-os-matrix.md (#1923)
- [`[9155fbf]`](https://github.com/dotnet/cli/commit/9155fbf) Update known-issues.md (#3148)
- [`[78a70f0]`](https://github.com/dotnet/cli/commit/78a70f0) Remove duplicated install scripts.