# .NET Core 2.1 Known Issues and Resolutions

## .NET Core 2.1.1

#### Installing on SLES 12 SP3 reports `krb5-mini` dependency is missing ([core-setup/4262](https://github.com/dotnet/core-setup/issues/4262))

``` bash
> sudo zypper install dotnet-sdk-2.1
Refreshing service 'cloud_update'.
Loading repository data...
Reading installed packages...
Resolving package dependencies...
 
Problem: nothing provides krb5-mini needed by dotnet-runtime-deps-2.1-2.1.1-1.x86_64
Solution 1: do not install dotnet-sdk-2.1-2.1.301-1.x86_64
Solution 2: break dotnet-runtime-deps-2.1-2.1.1-1.x86_64 by ignoring some of its dependencies
 
Choose from above solutions by number or cancel [1/2/c] (c):
```

krb5 is generally installed by default. This can be confirmed with the following. 

``` bash
> zypper search krb5
Loading repository data...
Reading installed packages...
 
S  | Name            | Summary                                        | Type
---+-----------------+------------------------------------------------+--------
i  | krb5            | MIT Kerberos5 Implementation--Libraries        | package
i+ | krb5-client     | MIT Kerberos5 implementation - client programs | package
i  | libndr-krb5pac0 | NDR marshallers for the KRB5 PAC formats       | package
```

If it is not installed, run `zypper install krb5-client`, then install dotnet core. When presented with the missing dependency prompt, choose 'Solution 2' to continue with the installation.


#### MSBuild @(PackageDefinitions) items are not computed without an explicit target dependency ([sdk/2342](https://github.com/dotnet/sdk/issues/2342))

These items are very expensive to compute and dramatic performance improvement for incremental builds in .NET Core SDK 2.1.300 and above was achieved by removing the dependency from the Build target to the RunResolvePackageDependencies target that performs this compuation. Custom build logic that still depends on these items therefore needs to add a target dependency on RunResolvePackageDependencies.


## Previous known issues fixed in this release

[[Fixed]](https://github.com/aspnet/Universe/pull/1218) - [aspnet/1220](https://github.com/aspnet/Universe/issues/1220)

Offline restore is broken in .NET Core SDK 2.1.301.

[[Fixed]](https://github.com/dotnet/coreclr/pull/17975) - [coreclr/17931](https://github.com/dotnet/coreclr/issues/17931) and [dotnet-docker/561](https://github.com/dotnet/dotnet-docker/issues/561)

Using Alpine docker image from system w/ SELinux execheap enforcement triggers segfault.

This issue will be fixed in the first update for 2.1.

[[Fixed]](https://github.com/dotnet/cli/pull/9313) - [cli/9289](https://github.com/dotnet/cli/issues/9289)

Using `dotnet install` or `dotnet uninstall` to manage Global Tools sometimes results in an `access denied` error. This occurs because another process, like an indexer, has not released a handle on the Global Tools files.

*Workaround* 

**Global Tools created with .NET Core SDK 2.1.300 Preview 1 are not compatible with later versions.**

Also: Ensure that global.json does not pin to .NET Core SDK 2.1.300 Preview 1 on either for a  directory where you are developing global tools or a directory from which you are installing global tools.

*Workaround* - Manually remove these tools.

## .NET Core 2.1.0 RC1

## Runtime

[core-setup/4149](https://github.com/dotnet/core-setup/issues/4149)

On Unix, if $TMPDIR is set to a nonexistent or non writeable location, your app will log "Failed to initialize CoreCLR, HRESULT: 0x80004005" to the console and fail to start.

*Workaround* - Clear $TMPDIR or set to a valid location.

[coreclr/17931](https://github.com/dotnet/coreclr/issues/17931) and [dotnet-docker/561](https://github.com/dotnet/dotnet-docker/issues/561)

Using Alpine docker image from system w/ SELinux execheap enforcement triggers segfault.

This issue will be fixed in the first update for 2.1.

## Global Tools

[cli/9289](https://github.com/dotnet/cli/issues/9289)

Using `dotnet install` or `dotnet uninstall` to manage Global Tools sometimes results in an `access denied` error. This occurs because another process, like an indexer, has not released a handle on the Global Tools files.

*Workaround* 

**Global Tools created with .NET Core SDK 2.1.300 Preview 1 are not compatible with later versions.**

Also: Ensure that global.json does not pin to .NET Core SDK 2.1.300 Preview 1 on either for a  directory where you are developing global tools or a directory from which you are installing global tools.

*Workaround* - Manually remove these tools.

**Global Tools must target .NET Core Runtime 2.1 or higher** ([cli/9073](https://github.com/dotnet/cli/issues/9073))

*Workaround* - Upgrade to target .NET Core Runtime 2.1

**Global tools install succeeds on Mac and Linux but fails to run**

[cli/9319](https://github.com/dotnet/cli/issues/9319)

Installing a Global Tool using --tool-path with a relative path on Mac and Linux will succeed,  but execution of the tool fails with error “The application to execute does not exist”. 

This occurs because the relative path is calculated incorrectly.

*Workaround* - Specify the full path for the  --tool-path option. For example
 
- `dotnet tool install dotnetsay --tool-path /home/build/tools`
 
or use `pwd utility`

- `dotnet tool install dotnetsay --tool-path $(pwd)/tools`


## .NET Core 2.1.0 Preview 1

This document lists known issues for *.NET Core 2.1 Preview 1* which may be encountered during usage.

## SDK

Nightly builds of the .NET Core SDK with  version numbers starting with 2.2.0-preview or 15.5.0-preview will prevent Preview 1 from being used.

**Workaround** - Manually uninstall the nightly build. See https://github.com/dotnet/announcements/issues/57

The dotnet install tool fails if a feed can't be reached, even if the package is available in the offline cache. For example, this might happen when the machine is offline.

**Workaround** - Temporarily edit your NuGet.Config and remove unreachable feeds there.

The dotnet pack command fails to pack .NET Core tools that contain project to project references. See https://github.com/dotnet/sdk/issues/1998

**Workaround** - None

## Runtime

Code that was using Lazy<T, Tmetadata> and working in 2.0.0 may produce this error when upgrading to 2.1:

> Error	CS0012	The type 'Lazy<,>' is defined in an assembly that is not referenced. You must add a reference to assembly 'System.ComponentModel.Composition, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089'.

This is because this was previously satisfied by a type forward in the assembly System.ComponentModel.Composition. This assembly has now been populated with a port of MEF and in the process was pulled out of the core netcoreapp package.

Add a package reference to https://www.nuget.org/packages/Microsoft.Windows.Compatibility

https://github.com/dotnet/corefx/issues/27299

## Visual Studio

If you install .NET Core 2.1 Preview 1 on a machine with Visual Studio 2017 version 15.5.6 or lower, then ASP.NET Core 2.0 is not available in dropdown when creating new web applications

Apply VS update 15.5.7 to make ASP.NET Core 2.0 show up in the web project creation dialog again 
