# .NET Core 2.1 RC 1 Known Issues

This document lists known issues for **.NET Core 2.1 RC 1** which may be encountered during usage.

## Runtime

[core-setup/4149](https://github.com/dotnet/core-setup/issues/4149)

On Unix, if $TMPDIR is set to a nonexistent or non writeable location, your app will log "Failed to initialize CoreCLR, HRESULT: 0x80004005" to the console and fail to start.

*Workaround* - Clear $TMPDIR or set to a valid location.

[coreclr/17931](https://github.com/dotnet/coreclr/issues/17931) and [dotnet-docker/561](https://github.com/dotnet/dotnet-docker/issues/561)

Using Alpine docker image from system w/ SELinux execheap enforcement triggers segfault.

This issue will be fixed in the first update for 2.1.

## Global Tools

[cli/9289](https://github.com/dotnet/cli/issues/9289)

Using `dotnet install` or `dotnet uninstall` to manage Global Tools sometimes results in an `access denied` error. This occurs because another process, like an indexer, has not released a handle on the Global Tools files.

*Workaround* 

**Global Tools created with .NET Core SDK 2.1.300 Preview 1 are not compatible with later versions.**

Also: Ensure that global.json does not pin to .NET Core SDK 2.1.300 Preview 1 on either for a  directory where you are developing global tools or a directory from which you are installing global tools.

*Workaround* - Manually remove these tools.

**Global Tools must target .NET Core Runtime 2.1 or higher** ([cli/9073](https://github.com/dotnet/cli/issues/9073))

*Workaround* - Upgrade to target .NET Core Runtime 2.1

**Global tools install succeeds on Mac and Linux but fails to run**

[cli/9319](https://github.com/dotnet/cli/issues/9319)

Installing a Global Tool using --tool-path with a relative path on Mac and Linux will succeed,  but execution of the tool fails with error “The application to execute does not exist”. 

This occurs because the relative path is calculated incorrectly.

*Workaround* - Specify the full path for the  --tool-path option. For example
 
- `dotnet tool install dotnetsay --tool-path /home/build/tools`
 
or use `pwd utility`

- `dotnet tool install dotnetsay --tool-path $(pwd)/tools`


