# Commits to .NET Core 2.1.3 and .NET Core SDK 2.1.401

This is a somewhat curated list of commits across the .NET Core 2.1.3 development cycle. Working on automation to scrub out the uninteresting listings but there is still a bit of noise. Will be working to make that process better in future releases.

* [CoreCLR](#coreclr)
* [CoreFX](#corefx)
* [ASP.NET Core](#asp.net-core)

## CoreCLR

* [`[c1c7291]`](https://github.com/dotnet/coreclr/commit/c1c7291) Skip old time zones adjustments with offsets higher than 14h (#18305) (#18874)
* [`[0a04fd0]`](https://github.com/dotnet/coreclr/commit/0a04fd0) Port the fix for Issue 17969 to Rel/2.1
* [`[aa00dad]`](https://github.com/dotnet/coreclr/commit/aa00dad) JIT: Fix bug in finally cloning caused by unsound callfinally reordering
* [`[373b10e]`](https://github.com/dotnet/coreclr/commit/373b10e) Fix SpanHelpers.ClearWithoutReferences alignment detection (#18222)
* [`[2b283f3]`](https://github.com/dotnet/coreclr/commit/2b283f3) Optimize Array.Clear using SpanHelpers (#18101)
* [`[1cebf4d]`](https://github.com/dotnet/coreclr/commit/1cebf4d) Allow ILCodeVersion to fallback to default IL (#18502)(#18602)(#18448)
* [`[5b4773e]`](https://github.com/dotnet/coreclr/commit/5b4773e) AssemblyName parsing with unicode/emoji crashes (#18309)
* [`[d644d8a]`](https://github.com/dotnet/coreclr/commit/d644d8a) Fix handling of generating relative path to parent (#18460)
* [`[1352638]`](https://github.com/dotnet/coreclr/commit/1352638) mach_absolute_time as the primary clock source on macOS (corefx#30391) (#18505) (#18526)

## CoreFX

* [`[6c6b536]`](https://github.com/dotnet/corefx/commit/6c6b536) Update runtime IDs for new RHEL/OL/Fedora releases
* [`[754664c]`](https://github.com/dotnet/corefx/commit/754664c) Default generateversionsource to true (#31197)
* [`[8f34b49]`](https://github.com/dotnet/corefx/commit/8f34b49) Fix handle double-free in recently added WindowsIdentity test (#30731) (#30977)
* [`[ffa1879]`](https://github.com/dotnet/corefx/commit/ffa1879) Add Tizen 5.0 RID for NETCoreApp (#30888)
* [`[87b79bd]`](https://github.com/dotnet/corefx/commit/87b79bd) Fix compilation for deprecated API on macOS Mojave preview (#30716) (#30744)
* [`[8f71a67]`](https://github.com/dotnet/corefx/commit/8f71a67) Add missing RIDs for Tizen (#30640)
* [`[28506b2]`](https://github.com/dotnet/corefx/commit/28506b2) fix dereferencing uninitialized byte array in case recv() fails (#30312) (#30676)
* [`[59b1d9a]`](https://github.com/dotnet/corefx/commit/59b1d9a) Port 'Delay console CPR timer once protocol has worked' to 2.1 (#30789)
* [`[a844c92]`](https://github.com/dotnet/corefx/commit/a844c92) Port 'Delay console CPR timer once protocol has worked' to 2.1 (#30759)
* [`[fd29f78]`](https://github.com/dotnet/corefx/commit/fd29f78) Make directory enumeration consistent (#29908) (#30002)
* [`[dbf45ed]`](https://github.com/dotnet/corefx/commit/dbf45ed) [release/2.1] Port Microsoft.Windows.Compatibility.Shims fix (#30522)
* [`[f4457ef]`](https://github.com/dotnet/corefx/commit/f4457ef) Fix SignedCms handling of negative certificate serial numbers. (#30381)
* [`[be49d38]`](https://github.com/dotnet/corefx/commit/be49d38) Fix WinHttpHandler when using authenticating proxies (#30212)
* [`[09be1e9]`](https://github.com/dotnet/corefx/commit/09be1e9) Fix SocketsHttpHandler for Windows auth proxy CONNECT tunneling (#30478) (#30516)
* [`[6fb3c06]`](https://github.com/dotnet/corefx/commit/6fb3c06) Fix Expect: 100-continue handling when no request content (#30102) (#30112)
* [`[d1dafb3]`](https://github.com/dotnet/corefx/commit/d1dafb3) Make the Linux TLS hostname comparison be case-insensitive (#30553)
* [`[ee567f3]`](https://github.com/dotnet/corefx/commit/ee567f3) Clarify output size handling (#30534)
* [`[4e6ec97]`](https://github.com/dotnet/corefx/commit/4e6ec97) Ensure X509Chain can succeed when the end cert has an empty subject (#30427)
* [`[6ac8b2a]`](https://github.com/dotnet/corefx/commit/6ac8b2a) [release/2.1] Duplicate the access token passed to WindowsIdentity.RunImpersonated (#30346) (#30379)
* [`[cf7e0a0]`](https://github.com/dotnet/corefx/commit/cf7e0a0) Fix creating subdirectories under directories with trailing separators (#30293)
* [`[5ae4912]`](https://github.com/dotnet/corefx/commit/5ae4912) Skip certificates we can't read when populating machine store. (#29973) (#30155)
* [`[1e02c55]`](https://github.com/dotnet/corefx/commit/1e02c55) Fix BrotliStream decoding buffer handling (#30058) (#30066)
* [`[97c6116]`](https://github.com/dotnet/corefx/commit/97c6116) Ensure SocketsHttpHandler sends known verbs uppercased (#30149) (#30370)
* [`[8258357]`](https://github.com/dotnet/corefx/commit/8258357) mach_absolute_time as the primary clock source on macOS (#30459)
* [`[c6f4eb6]`](https://github.com/dotnet/corefx/commit/c6f4eb6) Fix WebSocket server split header parsing with large payload (#30402) (#30407)
* [`[501d570]`](https://github.com/dotnet/corefx/commit/501d570) Ensure we restore System.Reflection.TypeExtensions/4.4.0
* [`[f37cdb7]`](https://github.com/dotnet/corefx/commit/f37cdb7) Version System.Reflection.TypeExtensions package and build it
* [`[1f5beec]`](https://github.com/dotnet/corefx/commit/1f5beec) SignedCms: Improve NetFx compat for SignedCms wrapping EnvelopedCms
* [`[767d4aa]`](https://github.com/dotnet/corefx/commit/767d4aa) Fix EnvelopedCms incompatibilities between Unix and Windows
* [`[3700c5b]`](https://github.com/dotnet/corefx/commit/3700c5b) Update to a xUnit Performance Api that has a bigger Etw buffer size. … (#30328)
* [`[6b38470]`](https://github.com/dotnet/corefx/commit/6b38470) Use _SC_NPROCESSORS_CONF instead of _SC_NPROCESSORS_ONLN in Unix_ProcessorCountTest on ARM/ARM64 (#30132)

## ASP.NET Core

* [aspnet/Caching#396](https://github.com/aspnet/Caching/issues/396) Update StackExchange.Redis.StrongName
* [aspnet/EntityFrameworkCore#12107](https://github.com/aspnet/EntityFrameworkCore/issues/12107) Migrations: multiple references to the same owned type carries into subsequent migrations
* [aspnet/EntityFrameworkCore#12180](https://github.com/aspnet/EntityFrameworkCore/issues/12180) Invalid column name: orderby uses a column alias that does not exist
* [aspnet/EntityFrameworkCore#12203](https://github.com/aspnet/EntityFrameworkCore/issues/12203) 2.1.0 can't do Value Conversions on complex IEnumerable types like JObject (newtonsoft)
* [aspnet/EntityFrameworkCore#12214](https://github.com/aspnet/EntityFrameworkCore/issues/12214) In-Memory concurrency check is not doing a sequence check when using a byte array type
* [aspnet/EntityFrameworkCore#12227](https://github.com/aspnet/EntityFrameworkCore/issues/12227) InvalidOperationException while adding or retrieving object graph
* [aspnet/EntityFrameworkCore#12280](https://github.com/aspnet/EntityFrameworkCore/issues/12280) Projection query throws InvalidCastException trying to convert Int32 to Boolean
* [aspnet/EntityFrameworkCore#12290](https://github.com/aspnet/EntityFrameworkCore/issues/12290) Value Conversion of custom struct type throws exception if it doesn't implement == and != operators
* [aspnet/EntityFrameworkCore#12314](https://github.com/aspnet/EntityFrameworkCore/issues/12314) SumAsync throw Exception when used over float?
* [aspnet/EntityFrameworkCore#12351](https://github.com/aspnet/EntityFrameworkCore/issues/12351) Incorrect SQL generated for Count over Group By
* [aspnet/EntityFrameworkCore#12412](https://github.com/aspnet/EntityFrameworkCore/issues/12412) Null checking in anonymous projection throws InvalidOperationException
* [aspnet/EntityFrameworkCore#12557](https://github.com/aspnet/EntityFrameworkCore/issues/12557) InvalidCastException when casting to/from enum in query
* [aspnet/Home#3286](https://github.com/aspnet/Home/issues/3286) the ASP.NET Core runtime installer does not delete files on uninstall
* [aspnet/Identity#1866](https://github.com/aspnet/Identity/issues/1866) ActivePage declarations missing on scaffolded Identity UI
* [aspnet/KestrelHttpServer#2636](https://github.com/aspnet/KestrelHttpServer/issues/2636) Consistently handle connection aborts
* [aspnet/KestrelHttpServer#2638](https://github.com/aspnet/KestrelHttpServer/issues/2638) MemoryPoolBlock.Dispose can throw and ODE during server shutdown leading to an error log from the Socket Transport
* [aspnet/Mvc#7875](https://github.com/aspnet/Mvc/issues/7875) ProducesResponseType doesn't infer the type from ActionResult<T>
* [aspnet/Mvc#7959](https://github.com/aspnet/Mvc/issues/7959) Conventional routing with custom templates not working when you have area attributes
* [aspnet/Mvc#7968](https://github.com/aspnet/Mvc/issues/7968) Validation occurs against declared type rather than real type
* [aspnet/Mvc#7969](https://github.com/aspnet/Mvc/issues/7969) Razor runtime compilation produces errors if running on a shared runtime that's rolled forward
* [aspnet/Mvc#7970](https://github.com/aspnet/Mvc/issues/7970) BindingSource for IEnumerable<IFormFile> ApiController parameters on is incorrectly inferred as FromBody
* [aspnet/Razor#2384](https://github.com/aspnet/Razor/issues/2384) Copy-pasting an item in a Razor Class Library project adds junk to the project file
* [aspnet/Razor#2406](https://github.com/aspnet/Razor/issues/2406) -Having whitespace in username makes Razor builds slower
* [aspnet/Razor#2407](https://github.com/aspnet/Razor/issues/2407) Razor compilation gives error CS2017: Cannot specify /main if building a module or library
* [aspnet/Security#1788](https://github.com/aspnet/Security/issues/1788) Role/claim changes in identity aren't persisted into the auth cookie
* [aspnet/Security#1809](https://github.com/aspnet/Security/issues/1809) SaveTokens + GetTokenAsync does not work for JwtBearer
* [aspnet/SignalR#2561](https://github.com/aspnet/SignalR/issues/2561) Update AddSignalRCore to respect user registered services
* [aspnet/Templating#565](https://github.com/aspnet/Templating/issues/565) ResponseCache attribute on RazorPages Error handler method should be moved to model
* [dotnet/core#1655](https://github.com/dotnet/core/issues/1655) Hosting Bundle installer removes RC version of 2.1.0, breaking all RC apps
