# .NET Core 2.1 RC 1 Known Issues

<<<<<<< HEAD
This document lists known issues for *.NET Core 2.1 RC 1* which may be encountered during usage.
=======
This document lists known issues for **.NET Core 2.1 RC 1** which may be encountered during usage.
>>>>>>> b6442508bd96d57adb989bb028059239295bf52f

## CoreFX

### System.IO

([corefx/29368](https://github.com/dotnet/corefx/issues/29368))

Recursive enumeration of file/directory strings has an extra separator for subdirectories when passed an original path with a trailing separator. (Directory.EnumerateFiles/GetFiles/EnumerateDirectories/GetDirectories/EnumerateFileSystemEntries/GetFileSystemEntries with the SearchOption.AllDirectories option)

*Workaround* - Trim the trailing separator on the path argument or call Path.GetFullPath() on the result.

([corefx/29095](https://github.com/dotnet/corefx/issues/29095))

Directories are not recognized as directories when enumerating on some Unix distributions. If the file system returns a type of DT_UNKNOWN .NET will always assume it is a file.

*Workaround* None.

** System.Security** ([corefx/29345](https://github.com/dotnet/corefx/issues/29345))

EnvelopedCms.Decode on Linux and macOS cannot read files produced by Bouncy Castle

*Workaround* - Convert the file from an indefinite length encoding to a definite length encoding.  For example, load the file on Windows and write it back by calling EnvelopedCms.Encode().

### Global Tools

**Global Tools targeting Preview or RC will not "roll-forward" to RTM**

Global Tools are framework-dependent applications and subject to the same .NET Core runtime selection behavior as other applications. A key behavior is that preview releases do not roll-forward to a final (AKA "RTM") release in the absence of a preview release being installed on a given machine. Tool writers that publish tools for a preview need to publish releases for later previews and the final release in order for those tools to work for their users.

*Workaround* When .NET Core SDK is released (RTM), authors need to rebuild and re-publish their tools with the released RTM SDK.

**Global Tools created with .NET Core SDK 2.1.300 Preview 1 are not compatible with later versions.**

Also: Ensure that global.json does not pin to .NET Core SDK 2.1.300 Preview 1 on either for a  directory where you are developing global tools or a directory from which you are installing global tools.

*Workaround* - Manually remove these tools.

**Global Tool shim fails if .NET Core is not installed in default location** ([cli/9114](https://github.com/dotnet/cli/issues/9114))

*Workaround* - Set %DOTNET_ROOT% to point to your .NET Core installation

**Global Tools must target .NET Core Runtime 2.1 or higher** ([cli/9073](https://github.com/dotnet/cli/issues/9073))

*Workaround* - Upgrade to target .NET Core Runtime 2.1

### Installing on Linux using the installers installs the latest available dotnet-host package

There is an issue with dotnet-host 2.1.0-preview2-26406-04-1 which introduces a dependency incompatibility. [core-setup/issues/2128](https://github.com/dotnet/core-setup/issues/4007). This is only a problem when installing a previous version of .NET Core on a clean machine. For example, if you installed dotnet-runtime-2.0.6, the RC 1 host will be installed but not the rest of RC 1.

We have temporarily removed the RC 1 installers from the Linux package feeds until this is fully resolved.

**Workaround** - If you have gotten into this state, downgrade the dotnet-host pacakge to an older version.

```bash
sudo apt install dotnet-host=2.0.6-1
```