# System.Buffers.Text

``` diff
+namespace System.Buffers.Text {
+    public static class Base64 {
+        public static OperationStatus DecodeFromUtf8(ReadOnlySpan<byte> utf8, Span<byte> bytes, out int consumed, out int written, bool isFinalBlock=true);
+        public static OperationStatus DecodeFromUtf8InPlace(Span<byte> buffer, out int written);
+        public static OperationStatus EncodeToUtf8(ReadOnlySpan<byte> bytes, Span<byte> utf8, out int consumed, out int written, bool isFinalBlock=true);
+        public static OperationStatus EncodeToUtf8InPlace(Span<byte> buffer, int dataLength, out int written);
+        public static int GetMaxDecodedFromUtf8Length(int length);
+        public static int GetMaxEncodedToUtf8Length(int length);
+    }
+    public static class Utf8Formatter {
+        public static bool TryFormat(bool value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(byte value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(DateTime value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(DateTimeOffset value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(decimal value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(double value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(Guid value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(short value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(int value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(long value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(sbyte value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(float value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(TimeSpan value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(ushort value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(uint value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+        public static bool TryFormat(ulong value, Span<byte> buffer, out int bytesWritten, StandardFormat format=default(StandardFormat));
+    }
+    public static class Utf8Parser {
+        public static bool TryParse(ReadOnlySpan<byte> text, out bool value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out byte value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out DateTime value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out DateTimeOffset value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out decimal value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out double value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out Guid value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out short value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out int value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out long value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out sbyte value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out float value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out TimeSpan value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out ushort value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out uint value, out int bytesConsumed, char standardFormat='\0');
+        public static bool TryParse(ReadOnlySpan<byte> text, out ulong value, out int bytesConsumed, char standardFormat='\0');
+    }
+}
```

