# .NET Core 2.2.1 Update - January 08, 2019

.NET Core 2.2.1 is available for [download](2.2.1-download.md) and usage in your environment. This release includes .NET Core 2.2.1, ASP.NET Core 2.2.1 and .NET Core SDK 2.2.103.

**Note:** The 2.2 SDK was re-released on 1/16/2019 to address an issue ([dotnet/source-build#942](https://github.com/dotnet/source-build/issues/942)) where developers targetting the 2.1 Runtime (LTS) will not get the latest release when building self-contained applications.

* [Downloads](#downloads)
* [Changes in this release](#changes-in-221)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)
* [Known Issues](../2.1-known-issues.md)

We've created an issue at [dotnet/core #2210](https://github.com/dotnet/core/issues/2210) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

### Azure AppServices

* .NET Core 2.2.1 is being deployed to Azure App Services and the deployment is expected to complete in a couple of days.

## .NET Core Lifecycle News

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

The following OS versions have changed support status since our last release:

* Fedora 27 reached [end of life](https://fedoramagazine.org/fedora-27-end-of-life/) on November 30, 2018 and is no longer supported by .NET Core.
* Fedora 29 was released [October 30, 2018](https://fedoramagazine.org/announcing-fedora-29/) and is supported by NET Core 2.2.

## Changes in 2.2.1

.NET Core 2.2.1 release carries both security and non-security fixes. In addition to the listed vulnerabilites (see CVEs below) support for new Japanese calendar era and running in a sandbox on Mac has been added along with a few other reliability fixes. 

All fixes of note can be seen in the [2.2.1 commits](2.2.1-commits.md) list.

* ### [CVE-2019-0545: .NET Core Information Disclosure Vulnerability](https://github.com/dotnet/Announcements/issues/94)

    The security update addresses the vulnerability by enforcing Cross-origin Resource Sharing (CORS) configuration to prevent its bypass in .NET Core 2.1 and 2.2. An attacker who successfully exploited the vulnerability could retrieve content, that is normally restricted, from a web application.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    Microsoft.NETCore.App (System.Net.Http) | 2.2.0 | 2.2.1

* ### [CVE-2019-0548: ASP.NET Core Denial Of Service Vulnerability](https://github.com/aspnet/Announcements/issues/335)
    
    This security vulnerability exists in ASP.NET Core 1.0, 1.1, 2.1 and 2.2. If an application is hosted on Internet Information Server (IIS) a remote unauthenticated attacker can use a specially crafted request to cause a Denial of Service.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    AspNetCoreModule (ANCM) | Prior to 12.2.18346.0 | >=12.2.18346.0

* ### [CVE-2019-0564: ASP.NET Core Denial Of Service Vulnerability](https://github.com/aspnet/Announcements/issues/334)
    
    This security vulnerability exists when ASP.NET Core 2.1 and 2.2 improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication.

    A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the .NET Core application.

    **Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    Microsoft.AspNetCore.WebSockets | 2.2.0<br/>2.1.0, 2.1.1 | 2.2.1<br/>2.1.7
    Microsoft.AspNetCore.Server.Kestrel.Core | 2.1.0, 2.1.1, 2.1.2, 2.1.3 | 2.1.7
    System.Net.WebSockets.WebSocketProtocol  | 4.5.0, 4.5.1, 4.5.2 | 4.5.3
    Microsoft.NETCore.App | 2.2.0<br/>2.1.0, 2.1.1, 2.1.2, 2.1.3, 2.1.4, 2.1.5, 2.1.6 | 2.2.1 <br/> 2.1.7
    Microsoft.AspNetCore.App | 2.2.0<br/>2.1.0, 2.1.1, 2.1.2, 2.1.3, 2.1.4, 2.1.5, 2.1.6 | 2.2.1 <br/> 2.1.7
    Microsoft.AspNetCore.All  | 2.2.0<br/>2.1.0, 2.1.1, 2.1.2, 2.1.3, 2.1.4, 2.1.5, 2.1.6 | 2.2.1 <br/> 2.1.7

## Packages updated in this release:

Package name | Version 
------------ | ------------------- 
dotnet-aspnet-codegenerator | 2.2.1
dotnet-ef | 2.2.1
Microsoft.AspNetCore.All | 2.2.1
Microsoft.AspNetCore.App | 2.2.1
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 2.2.1
Microsoft.AspNetCore.Server.IIS | 2.2.1
Microsoft.AspNetCore.Server.IISIntegration | 2.2.1
Microsoft.AspNetCore.Server.Kestrel.Transport.Sockets | 2.2.1
Microsoft.AspNetCore.WebSockets | 2.2.1
Microsoft.Data.Sqlite | 2.2.1
Microsoft.Data.Sqlite.Core | 2.2.1
Microsoft.DotNet.Web.Client.ItemTemplates | 2.2.1
Microsoft.DotNet.Web.ItemTemplates | 2.2.1
Microsoft.DotNet.Web.ProjectTemplates.2.2 | 2.2.1
Microsoft.DotNet.Web.Spa.ProjectTemplates | 2.2.1
Microsoft.EntityFrameworkCore | 2.2.1
Microsoft.EntityFrameworkCore.Abstractions | 2.2.1
Microsoft.EntityFrameworkCore.Analyzers | 2.2.1
Microsoft.EntityFrameworkCore.Design | 2.2.1
Microsoft.EntityFrameworkCore.InMemory | 2.2.1
Microsoft.EntityFrameworkCore.Proxies | 2.2.1
Microsoft.EntityFrameworkCore.Relational | 2.2.1
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 2.2.1
Microsoft.EntityFrameworkCore.Specification.Tests | 2.2.1
Microsoft.EntityFrameworkCore.Sqlite | 2.2.1
Microsoft.EntityFrameworkCore.Sqlite.Core | 2.2.1
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 2.2.1
Microsoft.EntityFrameworkCore.SqlServer | 2.2.1
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 2.2.1
Microsoft.EntityFrameworkCore.Tools | 2.2.1
Microsoft.NETCore.App | 2.2.1
Microsoft.NETCore.DotNetAppHost | 2.2.1
Microsoft.NETCore.DotNetHost | 2.2.1
Microsoft.NETCore.DotNetHostPolicy | 2.2.1
Microsoft.NETCore.DotNetHostResolver | 2.2.1
Microsoft.VisualStudio.Web.CodeGeneration | 2.2.1
Microsoft.VisualStudio.Web.CodeGeneration.Contracts | 2.2.1
Microsoft.VisualStudio.Web.CodeGeneration.Core | 2.2.1
Microsoft.VisualStudio.Web.CodeGeneration.Design | 2.2.1
Microsoft.VisualStudio.Web.CodeGeneration.EntityFrameworkCore | 2.2.1
Microsoft.VisualStudio.Web.CodeGeneration.Templating | 2.2.1
Microsoft.VisualStudio.Web.CodeGeneration.Utils | 2.2.1
Microsoft.VisualStudio.Web.CodeGenerators.Mvc | 2.2.1
runtime.linux-arm.Microsoft.NETCore.App | 2.2.1
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 2.2.1
runtime.linux-arm64.Microsoft.NETCore.App | 2.2.1
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 2.2.1
runtime.linux-musl-x64.Microsoft.NETCore.App | 2.2.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 2.2.1
runtime.linux-x64.Microsoft.NETCore.App | 2.2.1
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 2.2.1
runtime.osx-x64.Microsoft.NETCore.App | 2.2.1
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 2.2.1
runtime.rhel.6-x64.Microsoft.NETCore.App | 2.2.1
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 2.2.1
runtime.win-arm.Microsoft.NETCore.App | 2.2.1
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.win-arm.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 2.2.1
runtime.win-arm64.Microsoft.NETCore.App | 2.2.1
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 2.2.1
runtime.win-x64.Microsoft.NETCore.App | 2.2.1
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.win-x64.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 2.2.1
runtime.win-x86.Microsoft.NETCore.App | 2.2.1
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 2.2.1
runtime.win-x86.Microsoft.NETCore.DotNetHost | 2.2.1
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 2.2.1
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 2.2.1
System.Net.WebSockets.WebSocketProtocol | 4.5.3


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.1/2.2.1/2.2.1.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e64d0771-52f3-444c-b174-8be5923ca6da/e0d7f36a0017162f5ff7a81b919ef434/dotnet-runtime-2.2.1-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4feaf401-6e35-4866-a603-f78f20e1443f/f7cbd190d92aeb555a39696f3aec3400/dotnet-runtime-2.2.1-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb167dc0-1026-4d98-af20-d33c57af72df/42c5573c53c12243cd5e9d9951bbaaaa/dotnet-runtime-2.2.1-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/372f18c3-f642-4b73-8255-40a87430a9bb/dd0b412220dc49868b0ba1c58252b6d0/dotnet-runtime-2.2.1-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/80a93bfc-dd53-474b-94f4-1dea02dec70c/eab2c0d078899ad0d8f8a15bf84a7f63/dotnet-runtime-2.2.1-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a524eeaa-dff9-4874-8753-50c46621ba52/30a95c310b7fd4e801417f58f9fb4562/dotnet-runtime-2.2.1-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5805c10f-aac5-44d5-a169-c0b06862ed8b/7d6c12a91d7f06c0e6ece4640afa8a6b/dotnet-runtime-2.2.1-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/e321754c-1fec-4b9a-9b1b-51c0cf925d69/c1d3d28e286f6293db59ab6d9d221349/dotnet-runtime-2.2.1-win-arm.zip
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/85ebea2c-5c65-40ab-9d28-751367a2e309/815568fcb183b1ebb84155891882ba1c/dotnet-runtime-2.2.1-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/14105500-66ac-40f9-85da-044e9486d3bf/8a1b8c318b50bbb96af2290c690225da/dotnet-runtime-2.2.1-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/16ccdfd9-b366-4a0c-9b56-a750ea66fd58/b2248c6bed9481c71cad09ed88ae92a0/dotnet-runtime-2.2.1-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8ed0a562-8a0c-404d-9ecd-9101c4666c62/0d0731978fd0470fb52c7e9188e3beff/dotnet-runtime-2.2.1-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0319d1d8-88ca-4521-a060-1729ac2fe185/6cd6fadcbed713ff9f64191097920315/dotnet-runtime-2.2.1-win-x86.zip
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9d049226-1f28-4d3d-a4ff-314e56b223c5/f67ab05a3d70b2bff46ff25e2b3acd2a/aspnetcore-runtime-2.2.1-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0dc12b72-f5b1-47b7-952c-bba5de6842f8/58dae827466e128dd5d0538c62d1ff49/aspnetcore-runtime-2.2.1-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/53cace8f-2907-487e-84d7-bc7a7ba5de05/326704ffa2ef9d4dcd0db2f1da996ebb/aspnetcore-runtime-2.2.1-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1c9f6fa-9ca2-4cfe-9b2d-1b042aeb8525/b4496a1ffff763b9431f44a3cc49664e/aspnetcore-runtime-2.2.1-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/2d01d672-6299-4104-890e-6c4915b568db/611719bbd750d0a23255ff5c25b649e4/aspnetcore-runtime-2.2.1-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0b39ab55-0f9c-4a1e-8f10-fba99193b466/4091102efbe65e582e9b1a4648c65589/aspnetcore-runtime-2.2.1-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/226f3292-21d8-4c04-adbe-51b8cdd69dca/1e0425c21a5351a5e256dcc4c99ea076/aspnetcore-runtime-2.2.1-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/27f88a3d-289e-486b-99f8-2fbe31c6d4a8/82725b35c8cb2053b1ed64d9a5978d91/aspnetcore-runtime-2.2.1-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4876c767-a2f6-41e9-bf56-2845c92a7c59/ae31a708abdc548c7463000b3f3bbf5c/aspnetcore-runtime-2.2.1-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5ee633f2-bf6d-49bd-8fb6-80c861c36d54/caa93641707e1fd5b8273ada22009246/dotnet-hosting-2.2.1-win.exe

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1de01e2e-aa87-4535-af42-8a8a9b4df215/a2fc245f1c26130a2ec22bbf5d0cb3e6/dotnet-sdk-2.2.103-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d9e60c5f-af85-4a9e-99ab-26d0cbbd70b7/5fde0e1f8ce2217494e325c9bc09fc0e/dotnet-sdk-2.2.103-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd7cfa87-3318-4180-9494-14049ac06b3d/f37da2572e2e13ca835f95e34e5328e5/dotnet-sdk-2.2.103-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/296e116b-30d7-4e1c-8238-ec8c7c4c7b79/43d6cd35d95e38675d472c56a24c3bd0/dotnet-sdk-2.2.103-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7510db8c-1acb-42d0-9fdd-5d6f74e1d23c/ff6b732ab489dc1b3e3b566fa5f71080/dotnet-sdk-2.2.103-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7315b6a5-b535-4349-892a-7ec82b573724/f44f5f852f0ef4364cff9d00035a3987/dotnet-sdk-2.2.103-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b5eb4aa1-f103-45b9-b33e-0c611b601e7b/b825115f3af9a9ebcacfeb41f87b507d/dotnet-sdk-2.2.103-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/71014edb-b8c9-4ab4-aa6a-d2edee2fd1c4/b8c236bc0586031d038539b254f660cf/dotnet-sdk-2.2.103-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c509efa5-f867-48e0-a231-625849a192a5/55dff1e29ba23a8b8e08c10d243c854e/dotnet-sdk-2.2.103-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c332d70f-6582-4471-96af-4b0c17a616ad/5f3043d4bc506bf91cb89fa90462bb58/dotnet-sdk-2.2.103-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a47b3710-f1c9-41ea-a826-23923a3344e8/608c60965f54fc20048a4b6840e513f1/dotnet-sdk-2.2.103-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f2c86d9c-0e92-40a5-ae12-6b597db814ff/41e297c11b972e135a6afe20db27acd4/dotnet-sdk-2.2.103-win-x86.zip

[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/5054e671-e4e5-485f-bb21-c21db96e4c32/5a3d985edb2aa4d636a70abf2f008f74/aspnet-2.2.1-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/c1345252-2b65-463c-a242-387584319029/bd273fbf195ef073d65f521b3c23bc5b/cli-2.2.1-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/7181f15d-9b79-4433-bd78-70920d0a4285/400dde7650fdb910b5fe5323caac5600/core-setup-2.2.1-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0a6b8b1b-99ea-47d3-b469-e20e7de24d2e/3414feb5b173ded0cbe20de2f3d1e61b/coreclr-2.2.1-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/45660124-8e10-4871-a2b4-003ae46b3928/c93c49381fabe993ee95666d842bb91f/corefx-2.2.1-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/fb7eaa7a-7bf9-481e-a30b-ce8d87d9710c/ceacf3a172301d0ad64f5f4199327379/sdk-symbols-2.2.1-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.1-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.503-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/2019/01/
