# .NET Core 2.2.0-preview2

.NET Core 2.2.0-preview2 comprises:

* .NET Core Runtime 2.2.0-preview2-26905-02
* ASP.NET Core 2.2.0-preview2-35157
* .NET Core SDK 2.2.100-preview2-009404

See the [Release Notes](https://github.com/dotnet/core/blob/master/release-notes/2.2/preview/2.2.0-preview2.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][sdk-win-x86.exe] \| [x64][sdk-win-x64.exe] | [x86][sdk-win-x86] \| [x64][sdk-win-x64] | [x86][runtime-win-x86.exe] \| [x64][runtime-win-x64.exe] | [x86][runtime-win-x86] \| [x64][runtime-win-x64] | [x86][asp-runtime-win-x86.exe] \| [x64][asp-runtime-win-x64.exe] <br> [Hosting Bundle][hosting-win-x64.exe]<sup>2</sup> |
| macOS     | [x64][sdk-mac-x64.pkg]  | [x64][sdk-mac-x64]     | [x64][runtime-mac-x64.pkg] | [x64][runtime-mac-x64] | [x64][asp-runtime-mac-x64]<sup>1</sup> |
| Linux     | [See installations steps below][linux-install]   | [x64][sdk-linux-x64] \| [ARM][sdk-linux-arm-x32] \| [ARM64][sdk-linux-arm-x64] \| [x64 Alpine][sdk-linux-musl-x64] | - | [x64][runtime-linux-x64] \| [ARM][runtime-linux-arm-x32] \| [ARM64][runtime-linux-arm-x64] \| [x64 Alpine][runtime-linux-musl-x64] | [x64][asp-runtime-linux-x64]<sup>1</sup>  \| [ARM32][asp-runtime-linux-arm-x86]<sup>1</sup> \| [x64 Alpine][asp-runtime-linux-musl-x64]<sup>1</sup> |
| RHEL6     | -                                                | [x64][sdk-rhel.6-x64]                    | -                                                        | [x64][runtime-rhel.6-x64] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][symbols-coreclr] \| [Shared Framework][symbols-corefx] \| [Setup][symbols-core-setup] | - | [ASP.NET Core][symbols-aspnetcore] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

The 2.2 Previews will only be available as tar.gz archives for Linux. Package manager installers will be available on the production feeds for final release. Review [Linux System Prerequisites for .NET Core](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) to ensure your system is ready for .NET Core.

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

[dlc-runtime]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B
[dlc-sdk]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.2/2.2.0-preview2-26905-02/2.2.0-preview2-26905-02.md

[runtime-linux-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-linux-x64.tar.gz
[runtime-linux-arm-x32]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-linux-arm.tar.gz
[runtime-linux-musl-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-linux-musl-x64.tar.gz
[runtime-linux-arm-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-linux-arm64.tar.gz
[runtime-rhel.6-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-rhel.6-x64.tar.gz
[runtime-mac-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-osx-x64.tar.gz
[runtime-mac-x64.pkg]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-osx-x64.pkg
[runtime-win-x86]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-win-x86.zip
[runtime-win-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-win-x64.zip
[runtime-win-x86.exe]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-win-x86.exe
[runtime-win-x64.exe]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-runtime-2.2.0-preview2-26905-02-win-x64.exe

[sdk-linux-x64]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-linux-x64.tar.gz
[sdk-linux-arm-x32]:  https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-linux-arm.tar.gz
[sdk-linux-arm-x64]:  https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-linux-arm64.tar.gz
[sdk-linux-musl-x64]:  https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-linux-musl-x64.tar.gz
[sdk-mac-x64]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-osx-x64.tar.gz
[sdk-mac-x64.pkg]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-osx-x64.pkg
[sdk-mac-x64.pkg-gs]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-osx-gs-x64.pkg
[sdk-win-x86]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-win-x86.zip
[sdk-win-x64]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-win-x64.zip
[sdk-win-x86.exe]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-win-x86.exe
[sdk-win-x86.exe-gs]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-win-gs-x86.exe
[sdk-win-x64.exe]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-win-x64.exe
[sdk-win-x64.exe-gs]: https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-win-gs-x64.exe
[sdk-rhel.6-x64]:  https://download.microsoft.com/download/D/5/9/D593CD8F-04E7-425D-962C-86FF4C90B1DA/dotnet-sdk-2.2.100-preview2-009404-rhel.6-x64.tar.gz

[hosting-win-x64.exe]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/dotnet-hosting-2.2.0-preview2-35157-win.exe
[asp-runtime-linux-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-runtime-2.2.0-preview2-35157-linux-x64.tar.gz
[asp-runtime-linux-arm-x86]:  https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-runtime-2.2.0-preview2-35157-linux-arm.tar.gz
[asp-runtime-linux-musl-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-runtime-2.2.0-preview2-35157-linux-musl-x64.tar.gz
[asp-runtime-mac-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-runtime-2.2.0-preview2-35157-osx-x64.tar.gz
[asp-runtime-win-x64.exe]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-runtime-2.2.0-preview2-35157-win-x64.exe
[asp-runtime-win-x86.exe]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-runtime-2.2.0-preview2-35157-win-x86.exe
[asp-runtime-win-x86]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-runtime-2.2.0-preview2-35157-win-x86.zip
[asp-runtime-win-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-runtime-2.2.0-preview2-35157-win-x64.zip
[asp-store-linux-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-store-2.2.0-preview2-35157-linux-x64.tar.gz
[asp-store-mac-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnetcore-store-2.2.0-preview2-35157-osx-x64.tar.gz
[asp-store-win-x64]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/AspNetCore.2.2.0-preview2-35157.RuntimePackageStore_x64.exe
[asp-store-win-x86]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/AspNetCore.2.2.0-preview2-35157.RuntimePackageStore_x86.exe

[symbols-aspnetcore]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/aspnet-2.2.0-preview2-symbols.zip
[symbols-coreclr]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/coreclr-2.2.0-preview2-symbols.zip
[symbols-corefx]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/corefx-2.2.0-preview2-symbols.zip
[symbols-core-setup]: https://download.microsoft.com/download/5/B/A/5BA1012E-5112-45C2-8369-152B49A6AA3B/core-setup-2.2.0-preview2-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.0-preview2-26905-02-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.100-preview2-009404-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/2018/09/11/net-core-sep-2018-update/
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md
