# System.IO

``` diff
 namespace System.IO {
     public class BinaryWriter : IDisposable {
+        public virtual ValueTask DisposeAsync();
     }
     public sealed class BufferedStream : Stream {
+        public override ValueTask DisposeAsync();
     }
     public static class File {
+        public static void Move(string sourceFileName, string destFileName, bool overwrite);
     }
     public sealed class FileInfo : FileSystemInfo {
+        public void MoveTo(string destFileName, bool overwrite);
     }
     public class FileStream : Stream {
+        public override ValueTask DisposeAsync();
+        public override int Read(Span<byte> buffer);
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override void Write(ReadOnlySpan<byte> buffer);
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class FileSystemInfo : MarshalByRefObject, ISerializable {
+        public override string ToString();
     }
     public class FileSystemWatcher : Component, ISupportInitialize {
+        public Collection<string> Filters { get; }
     }
     public static class Path {
+        public static string Join(string path1, string path2);
+        public static string Join(string path1, string path2, string path3);
     }
     public abstract class Stream : MarshalByRefObject, IDisposable {
+        public virtual ValueTask DisposeAsync();
     }
     public class StreamWriter : TextWriter {
+        public override ValueTask DisposeAsync();
     }
     public abstract class TextWriter : MarshalByRefObject, IDisposable {
+        public virtual ValueTask DisposeAsync();
+        public virtual void Write(StringBuilder value);
+        public virtual Task WriteAsync(StringBuilder value, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual void WriteLine(StringBuilder value);
+        public virtual Task WriteLineAsync(StringBuilder value, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class UnmanagedMemoryStream : Stream {
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

