<?php

use Phinx\Seed\AbstractSeed;

class CountriesSeeder extends AbstractSeed
{
    /**
     * Run Method.
     *
     * Write your database seeder using this method.
     *
     * More information on writing seeders is available here:
     * http://docs.phinx.org/en/latest/seeding.html
     */
    public function run()
    {

        $data = array(
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Afghanistan',
                'iso2' => 'AF',
                'iso3' => 'AFG',
                'continent' => 'AS',
                'currency' => 'AFN',
                'currencyname' => 'Afghani',
                'phone' => 93,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fa-AF,ps,uz-AF,tk',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Aland Islands',
                'iso2' => 'AX',
                'iso3' => 'ALA',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => '+358-18',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'sv-AX',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Albania',
                'iso2' => 'AL',
                'iso3' => 'ALB',
                'continent' => 'EU',
                'currency' => 'ALL',
                'currencyname' => 'Lek',
                'phone' => 355,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'sq,el',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Algeria',
                'iso2' => 'DZ',
                'iso3' => 'DZA',
                'continent' => 'AF',
                'currency' => 'DZD',
                'currencyname' => 'Dinar',
                'phone' => 213,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ar-DZ',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'American Samoa',
                'iso2' => 'AS',
                'iso3' => 'ASM',
                'continent' => 'OC',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => '+1-684',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-AS,sm,to',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Andorra',
                'iso2' => 'AD',
                'iso3' => 'AND',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 376,
                'postalcodeformat' => 'AD###',
                'postalcoderegex' => '^(?:AD)*(d{3})$',
                'languages' => 'ca',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Angola',
                'iso2' => 'AO',
                'iso3' => 'AGO',
                'continent' => 'AF',
                'currency' => 'AOA',
                'currencyname' => 'Kwanza',
                'phone' => 244,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'pt-AO',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Anguilla',
                'iso2' => 'AI',
                'iso3' => 'AIA',
                'continent' => 'NA',
                'currency' => 'XCD',
                'currencyname' => 'Dollar',
                'phone' => '+1-264',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-AI',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Antarctica',
                'iso2' => 'AQ',
                'iso3' => 'ATA',
                'continent' => 'AN',
                'currency' => '',
                'currencyname' => '',
                'phone' => '',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => '',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Antigua and Barbuda',
                'iso2' => 'AG',
                'iso3' => 'ATG',
                'continent' => 'NA',
                'currency' => 'XCD',
                'currencyname' => 'Dollar',
                'phone' => '+1-268',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-AG',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Argentina',
                'iso2' => 'AR',
                'iso3' => 'ARG',
                'continent' => 'SA',
                'currency' => 'ARS',
                'currencyname' => 'Peso',
                'phone' => 54,
                'postalcodeformat' => '@####@@@',
                'postalcoderegex' => '^([A-Z]d{4}[A-Z]{3})',
                'languages' => 'es-AR,en,it,de,fr,gn',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Armenia',
                'iso2' => 'AM',
                'iso3' => 'ARM',
                'continent' => 'AS',
                'currency' => 'AMD',
                'currencyname' => 'Dram',
                'phone' => 374,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'hy',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Aruba',
                'iso2' => 'AW',
                'iso3' => 'ABW',
                'continent' => 'NA',
                'currency' => 'AWG',
                'currencyname' => 'Guilder',
                'phone' => 297,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'nl-AW,es,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Australia',
                'iso2' => 'AU',
                'iso3' => 'AUS',
                'continent' => 'OC',
                'currency' => 'AUD',
                'currencyname' => 'Dollar',
                'phone' => 61,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'en-AU',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Austria',
                'iso2' => 'AT',
                'iso3' => 'AUT',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 43,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'de-AT,hr,hu,sl',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Azerbaijan',
                'iso2' => 'AZ',
                'iso3' => 'AZE',
                'continent' => 'AS',
                'currency' => 'AZN',
                'currencyname' => 'Manat',
                'phone' => 994,
                'postalcodeformat' => 'AZ ####',
                'postalcoderegex' => '^(?:AZ)*(d{4})$',
                'languages' => 'az,ru,hy',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bahamas',
                'iso2' => 'BS',
                'iso3' => 'BHS',
                'continent' => 'NA',
                'currency' => 'BSD',
                'currencyname' => 'Dollar',
                'phone' => '+1-242',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-BS',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bahrain',
                'iso2' => 'BH',
                'iso3' => 'BHR',
                'continent' => 'AS',
                'currency' => 'BHD',
                'currencyname' => 'Dinar',
                'phone' => 973,
                'postalcodeformat' => '####|###',
                'postalcoderegex' => '^(d{3}d?)$',
                'languages' => 'ar-BH,en,fa,ur',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bangladesh',
                'iso2' => 'BD',
                'iso3' => 'BGD',
                'continent' => 'AS',
                'currency' => 'BDT',
                'currencyname' => 'Taka',
                'phone' => 880,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'bn-BD,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Barbados',
                'iso2' => 'BB',
                'iso3' => 'BRB',
                'continent' => 'NA',
                'currency' => 'BBD',
                'currencyname' => 'Dollar',
                'phone' => '+1-246',
                'postalcodeformat' => 'BB#####',
                'postalcoderegex' => '^(?:BB)*(d{5})$',
                'languages' => 'en-BB',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Belarus',
                'iso2' => 'BY',
                'iso3' => 'BLR',
                'continent' => 'EU',
                'currency' => 'BYR',
                'currencyname' => 'Ruble',
                'phone' => 375,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'be,ru',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Belgium',
                'iso2' => 'BE',
                'iso3' => 'BEL',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 32,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'nl-BE,fr-BE,de-BE',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Belize',
                'iso2' => 'BZ',
                'iso3' => 'BLZ',
                'continent' => 'NA',
                'currency' => 'BZD',
                'currencyname' => 'Dollar',
                'phone' => 501,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-BZ,es',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Benin',
                'iso2' => 'BJ',
                'iso3' => 'BEN',
                'continent' => 'AF',
                'currency' => 'XOF',
                'currencyname' => 'Franc',
                'phone' => 229,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-BJ',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bermuda',
                'iso2' => 'BM',
                'iso3' => 'BMU',
                'continent' => 'NA',
                'currency' => 'BMD',
                'currencyname' => 'Dollar',
                'phone' => '+1-441',
                'postalcodeformat' => '@@ ##',
                'postalcoderegex' => '^([A-Z]{2}d{2})$',
                'languages' => 'en-BM,pt',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bhutan',
                'iso2' => 'BT',
                'iso3' => 'BTN',
                'continent' => 'AS',
                'currency' => 'BTN',
                'currencyname' => 'Ngultrum',
                'phone' => 975,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'dz',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bolivia',
                'iso2' => 'BO',
                'iso3' => 'BOL',
                'continent' => 'SA',
                'currency' => 'BOB',
                'currencyname' => 'Boliviano',
                'phone' => 591,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'es-BO,qu,ay',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bonaire, Saint Eustatius and Saba ',
                'iso2' => 'BQ',
                'iso3' => 'BES',
                'continent' => 'NA',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 599,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'nl,pap,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bosnia and Herzegovina',
                'iso2' => 'BA',
                'iso3' => 'BIH',
                'continent' => 'EU',
                'currency' => 'BAM',
                'currencyname' => 'Marka',
                'phone' => 387,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'bs,hr-BA,sr-BA',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Botswana',
                'iso2' => 'BW',
                'iso3' => 'BWA',
                'continent' => 'AF',
                'currency' => 'BWP',
                'currencyname' => 'Pula',
                'phone' => 267,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-BW,tn-BW',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bouvet Island',
                'iso2' => 'BV',
                'iso3' => 'BVT',
                'continent' => 'AN',
                'currency' => 'NOK',
                'currencyname' => 'Krone',
                'phone' => '',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => '',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Brazil',
                'iso2' => 'BR',
                'iso3' => 'BRA',
                'continent' => 'SA',
                'currency' => 'BRL',
                'currencyname' => 'Real',
                'phone' => 55,
                'postalcodeformat' => '#####-###',
                'postalcoderegex' => '^(d{8})$',
                'languages' => 'pt-BR,es,en,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'British Indian Ocean Territory',
                'iso2' => 'IO',
                'iso3' => 'IOT',
                'continent' => 'AS',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 246,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-IO',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'British Virgin Islands',
                'iso2' => 'VG',
                'iso3' => 'VGB',
                'continent' => 'NA',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => '+1-284',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-VG',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Brunei',
                'iso2' => 'BN',
                'iso3' => 'BRN',
                'continent' => 'AS',
                'currency' => 'BND',
                'currencyname' => 'Dollar',
                'phone' => 673,
                'postalcodeformat' => '@@####',
                'postalcoderegex' => '^([A-Z]{2}d{4})$',
                'languages' => 'ms-BN,en-BN',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Bulgaria',
                'iso2' => 'BG',
                'iso3' => 'BGR',
                'continent' => 'EU',
                'currency' => 'BGN',
                'currencyname' => 'Lev',
                'phone' => 359,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'bg,tr-BG',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Burkina Faso',
                'iso2' => 'BF',
                'iso3' => 'BFA',
                'continent' => 'AF',
                'currency' => 'XOF',
                'currencyname' => 'Franc',
                'phone' => 226,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-BF',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Burundi',
                'iso2' => 'BI',
                'iso3' => 'BDI',
                'continent' => 'AF',
                'currency' => 'BIF',
                'currencyname' => 'Franc',
                'phone' => 257,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-BI,rn',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Cambodia',
                'iso2' => 'KH',
                'iso3' => 'KHM',
                'continent' => 'AS',
                'currency' => 'KHR',
                'currencyname' => 'Riels',
                'phone' => 855,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'km,fr,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Cameroon',
                'iso2' => 'CM',
                'iso3' => 'CMR',
                'continent' => 'AF',
                'currency' => 'XAF',
                'currencyname' => 'Franc',
                'phone' => 237,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-CM,fr-CM',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Canada',
                'iso2' => 'CA',
                'iso3' => 'CAN',
                'continent' => 'NA',
                'currency' => 'CAD',
                'currencyname' => 'Dollar',
                'phone' => 1,
                'postalcodeformat' => '@#@ #@#',
                'postalcoderegex' => '^([a-zA-Z]d[a-zA-Z]d',
                'languages' => 'en-CA,fr-CA,iu',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Cape Verde',
                'iso2' => 'CV',
                'iso3' => 'CPV',
                'continent' => 'AF',
                'currency' => 'CVE',
                'currencyname' => 'Escudo',
                'phone' => 238,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'pt-CV',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Cayman Islands',
                'iso2' => 'KY',
                'iso3' => 'CYM',
                'continent' => 'NA',
                'currency' => 'KYD',
                'currencyname' => 'Dollar',
                'phone' => '+1-345',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-KY',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Central African Republic',
                'iso2' => 'CF',
                'iso3' => 'CAF',
                'continent' => 'AF',
                'currency' => 'XAF',
                'currencyname' => 'Franc',
                'phone' => 236,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-CF,sg,ln,kg',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Chad',
                'iso2' => 'TD',
                'iso3' => 'TCD',
                'continent' => 'AF',
                'currency' => 'XAF',
                'currencyname' => 'Franc',
                'phone' => 235,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-TD,ar-TD,sre',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Chile',
                'iso2' => 'CL',
                'iso3' => 'CHL',
                'continent' => 'SA',
                'currency' => 'CLP',
                'currencyname' => 'Peso',
                'phone' => 56,
                'postalcodeformat' => '#######',
                'postalcoderegex' => '^(d{7})$',
                'languages' => 'es-CL',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'China',
                'iso2' => 'CN',
                'iso3' => 'CHN',
                'continent' => 'AS',
                'currency' => 'CNY',
                'currencyname' => 'Yuan Renminbi',
                'phone' => 86,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'zh-CN,yue,wuu,dta,ug,za',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Christmas Island',
                'iso2' => 'CX',
                'iso3' => 'CXR',
                'continent' => 'AS',
                'currency' => 'AUD',
                'currencyname' => 'Dollar',
                'phone' => 61,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'en,zh,ms-CC',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Cocos Islands',
                'iso2' => 'CC',
                'iso3' => 'CCK',
                'continent' => 'AS',
                'currency' => 'AUD',
                'currencyname' => 'Dollar',
                'phone' => 61,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ms-CC,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Colombia',
                'iso2' => 'CO',
                'iso3' => 'COL',
                'continent' => 'SA',
                'currency' => 'COP',
                'currencyname' => 'Peso',
                'phone' => 57,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'es-CO',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Comoros',
                'iso2' => 'KM',
                'iso3' => 'COM',
                'continent' => 'AF',
                'currency' => 'KMF',
                'currencyname' => 'Franc',
                'phone' => 269,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ar,fr-KM',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Cook Islands',
                'iso2' => 'CK',
                'iso3' => 'COK',
                'continent' => 'OC',
                'currency' => 'NZD',
                'currencyname' => 'Dollar',
                'phone' => 682,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-CK,mi',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Costa Rica',
                'iso2' => 'CR',
                'iso3' => 'CRI',
                'continent' => 'NA',
                'currency' => 'CRC',
                'currencyname' => 'Colon',
                'phone' => 506,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'es-CR,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Croatia',
                'iso2' => 'HR',
                'iso3' => 'HRV',
                'continent' => 'EU',
                'currency' => 'HRK',
                'currencyname' => 'Kuna',
                'phone' => 385,
                'postalcodeformat' => 'HR-#####',
                'postalcoderegex' => '^(?:HR)*(d{5})$',
                'languages' => 'hr-HR,sr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Cuba',
                'iso2' => 'CU',
                'iso3' => 'CUB',
                'continent' => 'NA',
                'currency' => 'CUP',
                'currencyname' => 'Peso',
                'phone' => 53,
                'postalcodeformat' => 'CP #####',
                'postalcoderegex' => '^(?:CP)*(d{5})$',
                'languages' => 'es-CU',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Curacao',
                'iso2' => 'CW',
                'iso3' => 'CUW',
                'continent' => 'NA',
                'currency' => 'ANG',
                'currencyname' => 'Guilder',
                'phone' => 599,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'nl,pap',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Cyprus',
                'iso2' => 'CY',
                'iso3' => 'CYP',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 357,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'el-CY,tr-CY,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Czech Republic',
                'iso2' => 'CZ',
                'iso3' => 'CZE',
                'continent' => 'EU',
                'currency' => 'CZK',
                'currencyname' => 'Koruna',
                'phone' => 420,
                'postalcodeformat' => '### ##',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'cs,sk',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Democratic Republic of the Congo',
                'iso2' => 'CD',
                'iso3' => 'COD',
                'continent' => 'AF',
                'currency' => 'CDF',
                'currencyname' => 'Franc',
                'phone' => 243,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-CD,ln,kg',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Denmark',
                'iso2' => 'DK',
                'iso3' => 'DNK',
                'continent' => 'EU',
                'currency' => 'DKK',
                'currencyname' => 'Krone',
                'phone' => 45,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'da-DK,en,fo,de-DK',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Djibouti',
                'iso2' => 'DJ',
                'iso3' => 'DJI',
                'continent' => 'AF',
                'currency' => 'DJF',
                'currencyname' => 'Franc',
                'phone' => 253,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-DJ,ar,so-DJ,aa',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Dominica',
                'iso2' => 'DM',
                'iso3' => 'DMA',
                'continent' => 'NA',
                'currency' => 'XCD',
                'currencyname' => 'Dollar',
                'phone' => '+1-767',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-DM',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Dominican Republic',
                'iso2' => 'DO',
                'iso3' => 'DOM',
                'continent' => 'NA',
                'currency' => 'DOP',
                'currencyname' => 'Peso',
                'phone' => '+1-809 and',
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'es-DO',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'East Timor',
                'iso2' => 'TL',
                'iso3' => 'TLS',
                'continent' => 'OC',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 670,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'tet,pt-TL,id,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Ecuador',
                'iso2' => 'EC',
                'iso3' => 'ECU',
                'continent' => 'SA',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 593,
                'postalcodeformat' => '@####@',
                'postalcoderegex' => '^([a-zA-Z]d{4}[a-zA-',
                'languages' => 'es-EC',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Egypt',
                'iso2' => 'EG',
                'iso3' => 'EGY',
                'continent' => 'AF',
                'currency' => 'EGP',
                'currencyname' => 'Pound',
                'phone' => 20,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ar-EG,en,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'El Salvador',
                'iso2' => 'SV',
                'iso3' => 'SLV',
                'continent' => 'NA',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 503,
                'postalcodeformat' => 'CP ####',
                'postalcoderegex' => '^(?:CP)*(d{4})$',
                'languages' => 'es-SV',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Equatorial Guinea',
                'iso2' => 'GQ',
                'iso3' => 'GNQ',
                'continent' => 'AF',
                'currency' => 'XAF',
                'currencyname' => 'Franc',
                'phone' => 240,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'es-GQ,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Eritrea',
                'iso2' => 'ER',
                'iso3' => 'ERI',
                'continent' => 'AF',
                'currency' => 'ERN',
                'currencyname' => 'Nakfa',
                'phone' => 291,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'aa-ER,ar,tig,kun,ti-ER',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Estonia',
                'iso2' => 'EE',
                'iso3' => 'EST',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 372,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'et,ru',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Ethiopia',
                'iso2' => 'ET',
                'iso3' => 'ETH',
                'continent' => 'AF',
                'currency' => 'ETB',
                'currencyname' => 'Birr',
                'phone' => 251,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'am,en-ET,om-ET,ti-ET,so-ET,sid',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Falkland Islands',
                'iso2' => 'FK',
                'iso3' => 'FLK',
                'continent' => 'SA',
                'currency' => 'FKP',
                'currencyname' => 'Pound',
                'phone' => 500,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-FK',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Faroe Islands',
                'iso2' => 'FO',
                'iso3' => 'FRO',
                'continent' => 'EU',
                'currency' => 'DKK',
                'currencyname' => 'Krone',
                'phone' => 298,
                'postalcodeformat' => 'FO-###',
                'postalcoderegex' => '^(?:FO)*(d{3})$',
                'languages' => 'fo,da-FO',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Fiji',
                'iso2' => 'FJ',
                'iso3' => 'FJI',
                'continent' => 'OC',
                'currency' => 'FJD',
                'currencyname' => 'Dollar',
                'phone' => 679,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-FJ,fj',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Finland',
                'iso2' => 'FI',
                'iso3' => 'FIN',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 358,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(?:FI)*(d{5})$',
                'languages' => 'fi-FI,sv-FI,smn',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'France',
                'iso2' => 'FR',
                'iso3' => 'FRA',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 33,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'fr-FR,frp,br,co,ca,eu,oc',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'French Guiana',
                'iso2' => 'GF',
                'iso3' => 'GUF',
                'continent' => 'SA',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 594,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^((97)|(98)3d{2})$',
                'languages' => 'fr-GF',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'French Polynesia',
                'iso2' => 'PF',
                'iso3' => 'PYF',
                'continent' => 'OC',
                'currency' => 'XPF',
                'currencyname' => 'Franc',
                'phone' => 689,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^((97)|(98)7d{2})$',
                'languages' => 'fr-PF,ty',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'French Southern Territories',
                'iso2' => 'TF',
                'iso3' => 'ATF',
                'continent' => 'AN',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => '',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Gabon',
                'iso2' => 'GA',
                'iso3' => 'GAB',
                'continent' => 'AF',
                'currency' => 'XAF',
                'currencyname' => 'Franc',
                'phone' => 241,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-GA',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Gambia',
                'iso2' => 'GM',
                'iso3' => 'GMB',
                'continent' => 'AF',
                'currency' => 'GMD',
                'currencyname' => 'Dalasi',
                'phone' => 220,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-GM,mnk,wof,wo,ff',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Georgia',
                'iso2' => 'GE',
                'iso3' => 'GEO',
                'continent' => 'AS',
                'currency' => 'GEL',
                'currencyname' => 'Lari',
                'phone' => 995,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'ka,ru,hy,az',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Germany',
                'iso2' => 'DE',
                'iso3' => 'DEU',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 49,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'de',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Ghana',
                'iso2' => 'GH',
                'iso3' => 'GHA',
                'continent' => 'AF',
                'currency' => 'GHS',
                'currencyname' => 'Cedi',
                'phone' => 233,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-GH,ak,ee,tw',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Gibraltar',
                'iso2' => 'GI',
                'iso3' => 'GIB',
                'continent' => 'EU',
                'currency' => 'GIP',
                'currencyname' => 'Pound',
                'phone' => 350,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-GI,es,it,pt',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Greece',
                'iso2' => 'GR',
                'iso3' => 'GRC',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 30,
                'postalcodeformat' => '### ##',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'el-GR,en,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Greenland',
                'iso2' => 'GL',
                'iso3' => 'GRL',
                'continent' => 'NA',
                'currency' => 'DKK',
                'currencyname' => 'Krone',
                'phone' => 299,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'kl,da-GL,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Grenada',
                'iso2' => 'GD',
                'iso3' => 'GRD',
                'continent' => 'NA',
                'currency' => 'XCD',
                'currencyname' => 'Dollar',
                'phone' => '+1-473',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-GD',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Guadeloupe',
                'iso2' => 'GP',
                'iso3' => 'GLP',
                'continent' => 'NA',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 590,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^((97)|(98)d{3})$',
                'languages' => 'fr-GP',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Guam',
                'iso2' => 'GU',
                'iso3' => 'GUM',
                'continent' => 'OC',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => '+1-671',
                'postalcodeformat' => '969##',
                'postalcoderegex' => '^(969d{2})$',
                'languages' => 'en-GU,ch-GU',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Guatemala',
                'iso2' => 'GT',
                'iso3' => 'GTM',
                'continent' => 'NA',
                'currency' => 'GTQ',
                'currencyname' => 'Quetzal',
                'phone' => 502,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'es-GT',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Guernsey',
                'iso2' => 'GG',
                'iso3' => 'GGY',
                'continent' => 'EU',
                'currency' => 'GBP',
                'currencyname' => 'Pound',
                'phone' => '+44-1481',
                'postalcodeformat' => '@# #@@|@## #@@|@@# #',
                'postalcoderegex' => '^(([A-Z]d{2}[A-Z]{2}',
                'languages' => 'en,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Guinea',
                'iso2' => 'GN',
                'iso3' => 'GIN',
                'continent' => 'AF',
                'currency' => 'GNF',
                'currencyname' => 'Franc',
                'phone' => 224,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-GN',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Guinea-Bissau',
                'iso2' => 'GW',
                'iso3' => 'GNB',
                'continent' => 'AF',
                'currency' => 'XOF',
                'currencyname' => 'Franc',
                'phone' => 245,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'pt-GW,pov',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Guyana',
                'iso2' => 'GY',
                'iso3' => 'GUY',
                'continent' => 'SA',
                'currency' => 'GYD',
                'currencyname' => 'Dollar',
                'phone' => 592,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-GY',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Haiti',
                'iso2' => 'HT',
                'iso3' => 'HTI',
                'continent' => 'NA',
                'currency' => 'HTG',
                'currencyname' => 'Gourde',
                'phone' => 509,
                'postalcodeformat' => 'HT####',
                'postalcoderegex' => '^(?:HT)*(d{4})$',
                'languages' => 'ht,fr-HT',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Heard Island and McDonald Islands',
                'iso2' => 'HM',
                'iso3' => 'HMD',
                'continent' => 'AN',
                'currency' => 'AUD',
                'currencyname' => 'Dollar',
                'phone' => '',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => '',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Honduras',
                'iso2' => 'HN',
                'iso3' => 'HND',
                'continent' => 'NA',
                'currency' => 'HNL',
                'currencyname' => 'Lempira',
                'phone' => 504,
                'postalcodeformat' => '@@####',
                'postalcoderegex' => '^([A-Z]{2}d{4})$',
                'languages' => 'es-HN',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Hong Kong',
                'iso2' => 'HK',
                'iso3' => 'HKG',
                'continent' => 'AS',
                'currency' => 'HKD',
                'currencyname' => 'Dollar',
                'phone' => 852,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'zh-HK,yue,zh,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Hungary',
                'iso2' => 'HU',
                'iso3' => 'HUN',
                'continent' => 'EU',
                'currency' => 'HUF',
                'currencyname' => 'Forint',
                'phone' => 36,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'hu-HU',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Iceland',
                'iso2' => 'IS',
                'iso3' => 'ISL',
                'continent' => 'EU',
                'currency' => 'ISK',
                'currencyname' => 'Krona',
                'phone' => 354,
                'postalcodeformat' => '###',
                'postalcoderegex' => '^(d{3})$',
                'languages' => 'is,en,de,da,sv,no',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'India',
                'iso2' => 'IN',
                'iso3' => 'IND',
                'continent' => 'AS',
                'currency' => 'INR',
                'currencyname' => 'Rupee',
                'phone' => '+91',
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'en-IN,hi,bn,te,mr,ta,ur,gu,kn,ml,or,pa,as,bh,sat,ks,ne,sd,kok,doi,mni,sit,sa,fr,lus,inc',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Indonesia',
                'iso2' => 'ID',
                'iso3' => 'IDN',
                'continent' => 'AS',
                'currency' => 'IDR',
                'currencyname' => 'Rupiah',
                'phone' => 62,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'id,en,nl,jv',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Iran',
                'iso2' => 'IR',
                'iso3' => 'IRN',
                'continent' => 'AS',
                'currency' => 'IRR',
                'currencyname' => 'Rial',
                'phone' => 98,
                'postalcodeformat' => '##########',
                'postalcoderegex' => '^(d{10})$',
                'languages' => 'fa-IR,ku',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Iraq',
                'iso2' => 'IQ',
                'iso3' => 'IRQ',
                'continent' => 'AS',
                'currency' => 'IQD',
                'currencyname' => 'Dinar',
                'phone' => 964,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ar-IQ,ku,hy',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Ireland',
                'iso2' => 'IE',
                'iso3' => 'IRL',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 353,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-IE,ga-IE',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Mexico',
                'iso2' => 'MX',
                'iso3' => 'MEX',
                'continent' => 'NA',
                'currency' => 'MXN',
                'currencyname' => 'Peso',
                'phone' => 52,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'es-MX',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Isle of Man',
                'iso2' => 'IM',
                'iso3' => 'IMN',
                'continent' => 'EU',
                'currency' => 'GBP',
                'currencyname' => 'Pound',
                'phone' => '+44-1624',
                'postalcodeformat' => '@# #@@|@## #@@|@@# #',
                'postalcoderegex' => '^(([A-Z]d{2}[A-Z]{2}',
                'languages' => 'en,gv',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Israel',
                'iso2' => 'IL',
                'iso3' => 'ISR',
                'continent' => 'AS',
                'currency' => 'ILS',
                'currencyname' => 'Shekel',
                'phone' => 972,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'he,ar-IL,en-IL,',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Italy',
                'iso2' => 'IT',
                'iso3' => 'ITA',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 39,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'it-IT,de-IT,fr-IT,sc,ca,co,sl',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Ivory Coast',
                'iso2' => 'CI',
                'iso3' => 'CIV',
                'continent' => 'AF',
                'currency' => 'XOF',
                'currencyname' => 'Franc',
                'phone' => 225,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-CI',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Jamaica',
                'iso2' => 'JM',
                'iso3' => 'JAM',
                'continent' => 'NA',
                'currency' => 'JMD',
                'currencyname' => 'Dollar',
                'phone' => '+1-876',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-JM',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Japan',
                'iso2' => 'JP',
                'iso3' => 'JPN',
                'continent' => 'AS',
                'currency' => 'JPY',
                'currencyname' => 'Yen',
                'phone' => 81,
                'postalcodeformat' => '###-####',
                'postalcoderegex' => '^(d{7})$',
                'languages' => 'ja',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Jersey',
                'iso2' => 'JE',
                'iso3' => 'JEY',
                'continent' => 'EU',
                'currency' => 'GBP',
                'currencyname' => 'Pound',
                'phone' => '+44-1534',
                'postalcodeformat' => '@# #@@|@## #@@|@@# #',
                'postalcoderegex' => '^(([A-Z]d{2}[A-Z]{2}',
                'languages' => 'en,pt',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Jordan',
                'iso2' => 'JO',
                'iso3' => 'JOR',
                'continent' => 'AS',
                'currency' => 'JOD',
                'currencyname' => 'Dinar',
                'phone' => 962,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ar-JO,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Kazakhstan',
                'iso2' => 'KZ',
                'iso3' => 'KAZ',
                'continent' => 'AS',
                'currency' => 'KZT',
                'currencyname' => 'Tenge',
                'phone' => 7,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'kk,ru',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Kenya',
                'iso2' => 'KE',
                'iso3' => 'KEN',
                'continent' => 'AF',
                'currency' => 'KES',
                'currencyname' => 'Shilling',
                'phone' => 254,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'en-KE,sw-KE',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Kiribati',
                'iso2' => 'KI',
                'iso3' => 'KIR',
                'continent' => 'OC',
                'currency' => 'AUD',
                'currencyname' => 'Dollar',
                'phone' => 686,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-KI,gil',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Kosovo',
                'iso2' => 'XK',
                'iso3' => 'XKX',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => '',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'sq,sr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Kuwait',
                'iso2' => 'KW',
                'iso3' => 'KWT',
                'continent' => 'AS',
                'currency' => 'KWD',
                'currencyname' => 'Dinar',
                'phone' => 965,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ar-KW,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Kyrgyzstan',
                'iso2' => 'KG',
                'iso3' => 'KGZ',
                'continent' => 'AS',
                'currency' => 'KGS',
                'currencyname' => 'Som',
                'phone' => 996,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'ky,uz,ru',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Laos',
                'iso2' => 'LA',
                'iso3' => 'LAO',
                'continent' => 'AS',
                'currency' => 'LAK',
                'currencyname' => 'Kip',
                'phone' => 856,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'lo,fr,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Latvia',
                'iso2' => 'LV',
                'iso3' => 'LVA',
                'continent' => 'EU',
                'currency' => 'LVL',
                'currencyname' => 'Lat',
                'phone' => 371,
                'postalcodeformat' => 'LV-####',
                'postalcoderegex' => '^(?:LV)*(d{4})$',
                'languages' => 'lv,ru,lt',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Lebanon',
                'iso2' => 'LB',
                'iso3' => 'LBN',
                'continent' => 'AS',
                'currency' => 'LBP',
                'currencyname' => 'Pound',
                'phone' => 961,
                'postalcodeformat' => '#### ####|####',
                'postalcoderegex' => '^(d{4}(d{4})?)$',
                'languages' => 'ar-LB,fr-LB,en,hy',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Lesotho',
                'iso2' => 'LS',
                'iso3' => 'LSO',
                'continent' => 'AF',
                'currency' => 'LSL',
                'currencyname' => 'Loti',
                'phone' => 266,
                'postalcodeformat' => '###',
                'postalcoderegex' => '^(d{3})$',
                'languages' => 'en-LS,st,zu,xh',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Liberia',
                'iso2' => 'LR',
                'iso3' => 'LBR',
                'continent' => 'AF',
                'currency' => 'LRD',
                'currencyname' => 'Dollar',
                'phone' => 231,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'en-LR',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Libya',
                'iso2' => 'LY',
                'iso3' => 'LBY',
                'continent' => 'AF',
                'currency' => 'LYD',
                'currencyname' => 'Dinar',
                'phone' => 218,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ar-LY,it,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Liechtenstein',
                'iso2' => 'LI',
                'iso3' => 'LIE',
                'continent' => 'EU',
                'currency' => 'CHF',
                'currencyname' => 'Franc',
                'phone' => 423,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'de-LI',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Lithuania',
                'iso2' => 'LT',
                'iso3' => 'LTU',
                'continent' => 'EU',
                'currency' => 'LTL',
                'currencyname' => 'Litas',
                'phone' => 370,
                'postalcodeformat' => 'LT-#####',
                'postalcoderegex' => '^(?:LT)*(d{5})$',
                'languages' => 'lt,ru,pl',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Luxembourg',
                'iso2' => 'LU',
                'iso3' => 'LUX',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 352,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'lb,de-LU,fr-LU',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Macao',
                'iso2' => 'MO',
                'iso3' => 'MAC',
                'continent' => 'AS',
                'currency' => 'MOP',
                'currencyname' => 'Pataca',
                'phone' => 853,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'zh,zh-MO,pt',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Macedonia',
                'iso2' => 'MK',
                'iso3' => 'MKD',
                'continent' => 'EU',
                'currency' => 'MKD',
                'currencyname' => 'Denar',
                'phone' => 389,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'mk,sq,tr,rmm,sr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Madagascar',
                'iso2' => 'MG',
                'iso3' => 'MDG',
                'continent' => 'AF',
                'currency' => 'MGA',
                'currencyname' => 'Ariary',
                'phone' => 261,
                'postalcodeformat' => '###',
                'postalcoderegex' => '^(d{3})$',
                'languages' => 'fr-MG,mg',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Malawi',
                'iso2' => 'MW',
                'iso3' => 'MWI',
                'continent' => 'AF',
                'currency' => 'MWK',
                'currencyname' => 'Kwacha',
                'phone' => 265,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ny,yao,tum,swk',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Malaysia',
                'iso2' => 'MY',
                'iso3' => 'MYS',
                'continent' => 'AS',
                'currency' => 'MYR',
                'currencyname' => 'Ringgit',
                'phone' => 60,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ms-MY,en,zh,ta,te,ml,pa,th',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Maldives',
                'iso2' => 'MV',
                'iso3' => 'MDV',
                'continent' => 'AS',
                'currency' => 'MVR',
                'currencyname' => 'Rufiyaa',
                'phone' => 960,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'dv,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Mali',
                'iso2' => 'ML',
                'iso3' => 'MLI',
                'continent' => 'AF',
                'currency' => 'XOF',
                'currencyname' => 'Franc',
                'phone' => 223,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-ML,bm',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Malta',
                'iso2' => 'MT',
                'iso3' => 'MLT',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 356,
                'postalcodeformat' => '@@@ ###|@@@ ##',
                'postalcoderegex' => '^([A-Z]{3}d{2}d?)$',
                'languages' => 'mt,en-MT',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Marshall Islands',
                'iso2' => 'MH',
                'iso3' => 'MHL',
                'continent' => 'OC',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 692,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'mh,en-MH',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Martinique',
                'iso2' => 'MQ',
                'iso3' => 'MTQ',
                'continent' => 'NA',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 596,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'fr-MQ',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Mauritania',
                'iso2' => 'MR',
                'iso3' => 'MRT',
                'continent' => 'AF',
                'currency' => 'MRO',
                'currencyname' => 'Ouguiya',
                'phone' => 222,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ar-MR,fuc,snk,fr,mey,wo',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Mauritius',
                'iso2' => 'MU',
                'iso3' => 'MUS',
                'continent' => 'AF',
                'currency' => 'MUR',
                'currencyname' => 'Rupee',
                'phone' => 230,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-MU,bho,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Mayotte',
                'iso2' => 'YT',
                'iso3' => 'MYT',
                'continent' => 'AF',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 262,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'fr-YT',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Micronesia',
                'iso2' => 'FM',
                'iso3' => 'FSM',
                'continent' => 'OC',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 691,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'en-FM,chk,pon,yap,kos,uli,woe,nkr,kpg',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Moldova',
                'iso2' => 'MD',
                'iso3' => 'MDA',
                'continent' => 'EU',
                'currency' => 'MDL',
                'currencyname' => 'Leu',
                'phone' => 373,
                'postalcodeformat' => 'MD-####',
                'postalcoderegex' => '^(?:MD)*(d{4})$',
                'languages' => 'ro,ru,gag,tr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Monaco',
                'iso2' => 'MC',
                'iso3' => 'MCO',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 377,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'fr-MC,en,it',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Mongolia',
                'iso2' => 'MN',
                'iso3' => 'MNG',
                'continent' => 'AS',
                'currency' => 'MNT',
                'currencyname' => 'Tugrik',
                'phone' => 976,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'mn,ru',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Montenegro',
                'iso2' => 'ME',
                'iso3' => 'MNE',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 382,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'sr,hu,bs,sq,hr,rom',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Montserrat',
                'iso2' => 'MS',
                'iso3' => 'MSR',
                'continent' => 'NA',
                'currency' => 'XCD',
                'currencyname' => 'Dollar',
                'phone' => '+1-664',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-MS',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Morocco',
                'iso2' => 'MA',
                'iso3' => 'MAR',
                'continent' => 'AF',
                'currency' => 'MAD',
                'currencyname' => 'Dirham',
                'phone' => 212,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ar-MA,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Mozambique',
                'iso2' => 'MZ',
                'iso3' => 'MOZ',
                'continent' => 'AF',
                'currency' => 'MZN',
                'currencyname' => 'Metical',
                'phone' => 258,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'pt-MZ,vmw',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Myanmar',
                'iso2' => 'MM',
                'iso3' => 'MMR',
                'continent' => 'AS',
                'currency' => 'MMK',
                'currencyname' => 'Kyat',
                'phone' => 95,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'my',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Namibia',
                'iso2' => 'NA',
                'iso3' => 'NAM',
                'continent' => 'AF',
                'currency' => 'NAD',
                'currencyname' => 'Dollar',
                'phone' => 264,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-NA,af,de,hz,naq',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Nauru',
                'iso2' => 'NR',
                'iso3' => 'NRU',
                'continent' => 'OC',
                'currency' => 'AUD',
                'currencyname' => 'Dollar',
                'phone' => 674,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'na,en-NR',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Nepal',
                'iso2' => 'NP',
                'iso3' => 'NPL',
                'continent' => 'AS',
                'currency' => 'NPR',
                'currencyname' => 'Rupee',
                'phone' => 977,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ne,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Netherlands',
                'iso2' => 'NL',
                'iso3' => 'NLD',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 31,
                'postalcodeformat' => '#### @@',
                'postalcoderegex' => '^(d{4}[A-Z]{2})$',
                'languages' => 'nl-NL,fy-NL',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Netherlands Antilles',
                'iso2' => 'AN',
                'iso3' => 'ANT',
                'continent' => 'NA',
                'currency' => 'ANG',
                'currencyname' => 'Guilder',
                'phone' => 599,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'nl-AN,en,es',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'New Caledonia',
                'iso2' => 'NC',
                'iso3' => 'NCL',
                'continent' => 'OC',
                'currency' => 'XPF',
                'currencyname' => 'Franc',
                'phone' => 687,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'fr-NC',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'New Zealand',
                'iso2' => 'NZ',
                'iso3' => 'NZL',
                'continent' => 'OC',
                'currency' => 'NZD',
                'currencyname' => 'Dollar',
                'phone' => 64,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'en-NZ,mi',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Nicaragua',
                'iso2' => 'NI',
                'iso3' => 'NIC',
                'continent' => 'NA',
                'currency' => 'NIO',
                'currencyname' => 'Cordoba',
                'phone' => 505,
                'postalcodeformat' => '###-###-#',
                'postalcoderegex' => '^(d{7})$',
                'languages' => 'es-NI,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Niger',
                'iso2' => 'NE',
                'iso3' => 'NER',
                'continent' => 'AF',
                'currency' => 'XOF',
                'currencyname' => 'Franc',
                'phone' => 227,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'fr-NE,ha,kr,dje',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Nigeria',
                'iso2' => 'NG',
                'iso3' => 'NGA',
                'continent' => 'AF',
                'currency' => 'NGN',
                'currencyname' => 'Naira',
                'phone' => 234,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'en-NG,ha,yo,ig,ff',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Niue',
                'iso2' => 'NU',
                'iso3' => 'NIU',
                'continent' => 'OC',
                'currency' => 'NZD',
                'currencyname' => 'Dollar',
                'phone' => 683,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'niu,en-NU',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Norfolk Island',
                'iso2' => 'NF',
                'iso3' => 'NFK',
                'continent' => 'OC',
                'currency' => 'AUD',
                'currencyname' => 'Dollar',
                'phone' => 672,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-NF',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'North Korea',
                'iso2' => 'KP',
                'iso3' => 'PRK',
                'continent' => 'AS',
                'currency' => 'KPW',
                'currencyname' => 'Won',
                'phone' => 850,
                'postalcodeformat' => '###-###',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'ko-KP',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Northern Mariana Islands',
                'iso2' => 'MP',
                'iso3' => 'MNP',
                'continent' => 'OC',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => '+1-670',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fil,tl,zh,ch-MP,en-MP',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Norway',
                'iso2' => 'NO',
                'iso3' => 'NOR',
                'continent' => 'EU',
                'currency' => 'NOK',
                'currencyname' => 'Krone',
                'phone' => 47,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'no,nb,nn,se,fi',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Oman',
                'iso2' => 'OM',
                'iso3' => 'OMN',
                'continent' => 'AS',
                'currency' => 'OMR',
                'currencyname' => 'Rial',
                'phone' => 968,
                'postalcodeformat' => '###',
                'postalcoderegex' => '^(d{3})$',
                'languages' => 'ar-OM,en,bal,ur',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Pakistan',
                'iso2' => 'PK',
                'iso3' => 'PAK',
                'continent' => 'AS',
                'currency' => 'PKR',
                'currencyname' => 'Rupee',
                'phone' => 92,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ur-PK,en-PK,pa,sd,ps,brh',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Palau',
                'iso2' => 'PW',
                'iso3' => 'PLW',
                'continent' => 'OC',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 680,
                'postalcodeformat' => 96940,
                'postalcoderegex' => '^(96940)$',
                'languages' => 'pau,sov,en-PW,tox,ja,fil,zh',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Palestinian Territory',
                'iso2' => 'PS',
                'iso3' => 'PSE',
                'continent' => 'AS',
                'currency' => 'ILS',
                'currencyname' => 'Shekel',
                'phone' => 970,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ar-PS',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Panama',
                'iso2' => 'PA',
                'iso3' => 'PAN',
                'continent' => 'NA',
                'currency' => 'PAB',
                'currencyname' => 'Balboa',
                'phone' => 507,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'es-PA,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Papua New Guinea',
                'iso2' => 'PG',
                'iso3' => 'PNG',
                'continent' => 'OC',
                'currency' => 'PGK',
                'currencyname' => 'Kina',
                'phone' => 675,
                'postalcodeformat' => '###',
                'postalcoderegex' => '^(d{3})$',
                'languages' => 'en-PG,ho,meu,tpi',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Paraguay',
                'iso2' => 'PY',
                'iso3' => 'PRY',
                'continent' => 'SA',
                'currency' => 'PYG',
                'currencyname' => 'Guarani',
                'phone' => 595,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'es-PY,gn',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Peru',
                'iso2' => 'PE',
                'iso3' => 'PER',
                'continent' => 'SA',
                'currency' => 'PEN',
                'currencyname' => 'Sol',
                'phone' => 51,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'es-PE,qu,ay',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Philippines',
                'iso2' => 'PH',
                'iso3' => 'PHL',
                'continent' => 'AS',
                'currency' => 'PHP',
                'currencyname' => 'Peso',
                'phone' => 63,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'tl,en-PH,fil',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Pitcairn',
                'iso2' => 'PN',
                'iso3' => 'PCN',
                'continent' => 'OC',
                'currency' => 'NZD',
                'currencyname' => 'Dollar',
                'phone' => 870,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-PN',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Poland',
                'iso2' => 'PL',
                'iso3' => 'POL',
                'continent' => 'EU',
                'currency' => 'PLN',
                'currencyname' => 'Zloty',
                'phone' => 48,
                'postalcodeformat' => '##-###',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'pl',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Portugal',
                'iso2' => 'PT',
                'iso3' => 'PRT',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 351,
                'postalcodeformat' => '####-###',
                'postalcoderegex' => '^(d{7})$',
                'languages' => 'pt-PT,mwl',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Puerto Rico',
                'iso2' => 'PR',
                'iso3' => 'PRI',
                'continent' => 'NA',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => '+1-787 and',
                'postalcodeformat' => '#####-####',
                'postalcoderegex' => '^(d{9})$',
                'languages' => 'en-PR,es-PR',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Qatar',
                'iso2' => 'QA',
                'iso3' => 'QAT',
                'continent' => 'AS',
                'currency' => 'QAR',
                'currencyname' => 'Rial',
                'phone' => 974,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ar-QA,es',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Republic of the Congo',
                'iso2' => 'CG',
                'iso3' => 'COG',
                'continent' => 'AF',
                'currency' => 'XAF',
                'currencyname' => 'Franc',
                'phone' => 242,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-CG,kg,ln-CG',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Reunion',
                'iso2' => 'RE',
                'iso3' => 'REU',
                'continent' => 'AF',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 262,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^((97)|(98)(4|7|8)d{',
                'languages' => 'fr-RE',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Romania',
                'iso2' => 'RO',
                'iso3' => 'ROU',
                'continent' => 'EU',
                'currency' => 'RON',
                'currencyname' => 'Leu',
                'phone' => 40,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'ro,hu,rom',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Russia',
                'iso2' => 'RU',
                'iso3' => 'RUS',
                'continent' => 'EU',
                'currency' => 'RUB',
                'currencyname' => 'Ruble',
                'phone' => 7,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'ru,tt,xal,cau,ady,kv,ce,tyv,cv,udm,tut,mns,bua,myv,mdf,chm,ba,inh,tut,kbd,krc,ava,sah,nog',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Rwanda',
                'iso2' => 'RW',
                'iso3' => 'RWA',
                'continent' => 'AF',
                'currency' => 'RWF',
                'currencyname' => 'Franc',
                'phone' => 250,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'rw,en-RW,fr-RW,sw',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Saint Barthelemy',
                'iso2' => 'BL',
                'iso3' => 'BLM',
                'continent' => 'NA',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 590,
                'postalcodeformat' => '### ###',
                'postalcoderegex' => '',
                'languages' => 'fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Saint Helena',
                'iso2' => 'SH',
                'iso3' => 'SHN',
                'continent' => 'AF',
                'currency' => 'SHP',
                'currencyname' => 'Pound',
                'phone' => 290,
                'postalcodeformat' => 'STHL 1ZZ',
                'postalcoderegex' => '^(STHL1ZZ)$',
                'languages' => 'en-SH',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Saint Kitts and Nevis',
                'iso2' => 'KN',
                'iso3' => 'KNA',
                'continent' => 'NA',
                'currency' => 'XCD',
                'currencyname' => 'Dollar',
                'phone' => '+1-869',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-KN',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Saint Lucia',
                'iso2' => 'LC',
                'iso3' => 'LCA',
                'continent' => 'NA',
                'currency' => 'XCD',
                'currencyname' => 'Dollar',
                'phone' => '+1-758',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-LC',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Saint Martin',
                'iso2' => 'MF',
                'iso3' => 'MAF',
                'continent' => 'NA',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 590,
                'postalcodeformat' => '### ###',
                'postalcoderegex' => '',
                'languages' => 'fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Saint Pierre and Miquelon',
                'iso2' => 'PM',
                'iso3' => 'SPM',
                'continent' => 'NA',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 508,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(97500)$',
                'languages' => 'fr-PM',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Saint Vincent and the Grenadines',
                'iso2' => 'VC',
                'iso3' => 'VCT',
                'continent' => 'NA',
                'currency' => 'XCD',
                'currencyname' => 'Dollar',
                'phone' => '+1-784',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-VC,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Samoa',
                'iso2' => 'WS',
                'iso3' => 'WSM',
                'continent' => 'OC',
                'currency' => 'WST',
                'currencyname' => 'Tala',
                'phone' => 685,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'sm,en-WS',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'San Marino',
                'iso2' => 'SM',
                'iso3' => 'SMR',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 378,
                'postalcodeformat' => '4789#',
                'postalcoderegex' => '^(4789d)$',
                'languages' => 'it-SM',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Sao Tome and Principe',
                'iso2' => 'ST',
                'iso3' => 'STP',
                'continent' => 'AF',
                'currency' => 'STD',
                'currencyname' => 'Dobra',
                'phone' => 239,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'pt-ST',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Saudi Arabia',
                'iso2' => 'SA',
                'iso3' => 'SAU',
                'continent' => 'AS',
                'currency' => 'SAR',
                'currencyname' => 'Rial',
                'phone' => 966,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ar-SA',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Senegal',
                'iso2' => 'SN',
                'iso3' => 'SEN',
                'continent' => 'AF',
                'currency' => 'XOF',
                'currencyname' => 'Franc',
                'phone' => 221,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'fr-SN,wo,fuc,mnk',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Serbia',
                'iso2' => 'RS',
                'iso3' => 'SRB',
                'continent' => 'EU',
                'currency' => 'RSD',
                'currencyname' => 'Dinar',
                'phone' => 381,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'sr,hu,bs,rom',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Serbia and Montenegro',
                'iso2' => 'CS',
                'iso3' => 'SCG',
                'continent' => 'EU',
                'currency' => 'RSD',
                'currencyname' => 'Dinar',
                'phone' => 381,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'cu,hu,sq,sr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Seychelles',
                'iso2' => 'SC',
                'iso3' => 'SYC',
                'continent' => 'AF',
                'currency' => 'SCR',
                'currencyname' => 'Rupee',
                'phone' => 248,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-SC,fr-SC',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Sierra Leone',
                'iso2' => 'SL',
                'iso3' => 'SLE',
                'continent' => 'AF',
                'currency' => 'SLL',
                'currencyname' => 'Leone',
                'phone' => 232,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-SL,men,tem',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Singapore',
                'iso2' => 'SG',
                'iso3' => 'SGP',
                'continent' => 'AS',
                'currency' => 'SGD',
                'currencyname' => 'Dollar',
                'phone' => 65,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'cmn,en-SG,ms-SG,ta-SG,zh-SG',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Sint Maarten',
                'iso2' => 'SX',
                'iso3' => 'SXM',
                'continent' => 'NA',
                'currency' => 'ANG',
                'currencyname' => 'Guilder',
                'phone' => 599,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'nl,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Slovakia',
                'iso2' => 'SK',
                'iso3' => 'SVK',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 421,
                'postalcodeformat' => '###  ##',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'sk,hu',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Slovenia',
                'iso2' => 'SI',
                'iso3' => 'SVN',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 386,
                'postalcodeformat' => 'SI- ####',
                'postalcoderegex' => '^(?:SI)*(d{4})$',
                'languages' => 'sl,sh',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Solomon Islands',
                'iso2' => 'SB',
                'iso3' => 'SLB',
                'continent' => 'OC',
                'currency' => 'SBD',
                'currencyname' => 'Dollar',
                'phone' => 677,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-SB,tpi',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Somalia',
                'iso2' => 'SO',
                'iso3' => 'SOM',
                'continent' => 'AF',
                'currency' => 'SOS',
                'currencyname' => 'Shilling',
                'phone' => 252,
                'postalcodeformat' => '@@  #####',
                'postalcoderegex' => '^([A-Z]{2}d{5})$',
                'languages' => 'so-SO,ar-SO,it,en-SO',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'South Africa',
                'iso2' => 'ZA',
                'iso3' => 'ZAF',
                'continent' => 'AF',
                'currency' => 'ZAR',
                'currencyname' => 'Rand',
                'phone' => 27,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'zu,xh,af,nso,en-ZA,tn,st,ts,ss,ve,nr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'South Georgia and the South Sandwich Islands',
                'iso2' => 'GS',
                'iso3' => 'SGS',
                'continent' => 'AN',
                'currency' => 'GBP',
                'currencyname' => 'Pound',
                'phone' => '',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'South Korea',
                'iso2' => 'KR',
                'iso3' => 'KOR',
                'continent' => 'AS',
                'currency' => 'KRW',
                'currencyname' => 'Won',
                'phone' => 82,
                'postalcodeformat' => 'SEOUL ###-###',
                'postalcoderegex' => '^(?:SEOUL)*(d{6})$',
                'languages' => 'ko-KR,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'South Sudan',
                'iso2' => 'SS',
                'iso3' => 'SSD',
                'continent' => 'AF',
                'currency' => 'SSP',
                'currencyname' => 'Pound',
                'phone' => 211,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Spain',
                'iso2' => 'ES',
                'iso3' => 'ESP',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 34,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'es-ES,ca,gl,eu,oc',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Sri Lanka',
                'iso2' => 'LK',
                'iso3' => 'LKA',
                'continent' => 'AS',
                'currency' => 'LKR',
                'currencyname' => 'Rupee',
                'phone' => 94,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'si,ta,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Sudan',
                'iso2' => 'SD',
                'iso3' => 'SDN',
                'continent' => 'AF',
                'currency' => 'SDG',
                'currencyname' => 'Pound',
                'phone' => 249,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'ar-SD,en,fia',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Suriname',
                'iso2' => 'SR',
                'iso3' => 'SUR',
                'continent' => 'SA',
                'currency' => 'SRD',
                'currencyname' => 'Dollar',
                'phone' => 597,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'nl-SR,en,srn,hns,jv',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Svalbard and Jan Mayen',
                'iso2' => 'SJ',
                'iso3' => 'SJM',
                'continent' => 'EU',
                'currency' => 'NOK',
                'currencyname' => 'Krone',
                'phone' => 47,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'no,ru',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Swaziland',
                'iso2' => 'SZ',
                'iso3' => 'SWZ',
                'continent' => 'AF',
                'currency' => 'SZL',
                'currencyname' => 'Lilangeni',
                'phone' => 268,
                'postalcodeformat' => '@###',
                'postalcoderegex' => '^([A-Z]d{3})$',
                'languages' => 'en-SZ,ss-SZ',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Sweden',
                'iso2' => 'SE',
                'iso3' => 'SWE',
                'continent' => 'EU',
                'currency' => 'SEK',
                'currencyname' => 'Krona',
                'phone' => 46,
                'postalcodeformat' => 'SE-### ##',
                'postalcoderegex' => '^(?:SE)*(d{5})$',
                'languages' => 'sv-SE,se,sma,fi-SE',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Switzerland',
                'iso2' => 'CH',
                'iso3' => 'CHE',
                'continent' => 'EU',
                'currency' => 'CHF',
                'currencyname' => 'Franc',
                'phone' => 41,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'de-CH,fr-CH,it-CH,rm',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Syria',
                'iso2' => 'SY',
                'iso3' => 'SYR',
                'continent' => 'AS',
                'currency' => 'SYP',
                'currencyname' => 'Pound',
                'phone' => 963,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ar-SY,ku,hy,arc,fr,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Taiwan',
                'iso2' => 'TW',
                'iso3' => 'TWN',
                'continent' => 'AS',
                'currency' => 'TWD',
                'currencyname' => 'Dollar',
                'phone' => 886,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'zh-TW,zh,nan,hak',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Tajikistan',
                'iso2' => 'TJ',
                'iso3' => 'TJK',
                'continent' => 'AS',
                'currency' => 'TJS',
                'currencyname' => 'Somoni',
                'phone' => 992,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'tg,ru',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Tanzania',
                'iso2' => 'TZ',
                'iso3' => 'TZA',
                'continent' => 'AF',
                'currency' => 'TZS',
                'currencyname' => 'Shilling',
                'phone' => 255,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'sw-TZ,en,ar',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Thailand',
                'iso2' => 'TH',
                'iso3' => 'THA',
                'continent' => 'AS',
                'currency' => 'THB',
                'currencyname' => 'Baht',
                'phone' => 66,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'th,en',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Togo',
                'iso2' => 'TG',
                'iso3' => 'TGO',
                'continent' => 'AF',
                'currency' => 'XOF',
                'currencyname' => 'Franc',
                'phone' => 228,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'fr-TG,ee,hna,kbp,dag,ha',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Tokelau',
                'iso2' => 'TK',
                'iso3' => 'TKL',
                'continent' => 'OC',
                'currency' => 'NZD',
                'currencyname' => 'Dollar',
                'phone' => 690,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'tkl,en-TK',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Tonga',
                'iso2' => 'TO',
                'iso3' => 'TON',
                'continent' => 'OC',
                'currency' => 'TOP',
                'currencyname' => 'Paanga',
                'phone' => 676,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'to,en-TO',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Trinidad and Tobago',
                'iso2' => 'TT',
                'iso3' => 'TTO',
                'continent' => 'NA',
                'currency' => 'TTD',
                'currencyname' => 'Dollar',
                'phone' => '+1-868',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-TT,hns,fr,es,zh',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Tunisia',
                'iso2' => 'TN',
                'iso3' => 'TUN',
                'continent' => 'AF',
                'currency' => 'TND',
                'currencyname' => 'Dinar',
                'phone' => 216,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'ar-TN,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Turkey',
                'iso2' => 'TR',
                'iso3' => 'TUR',
                'continent' => 'AS',
                'currency' => 'TRY',
                'currencyname' => 'Lira',
                'phone' => 90,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'tr-TR,ku,diq,az,av',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Turkmenistan',
                'iso2' => 'TM',
                'iso3' => 'TKM',
                'continent' => 'AS',
                'currency' => 'TMT',
                'currencyname' => 'Manat',
                'phone' => 993,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'tk,ru,uz',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Turks and Caicos Islands',
                'iso2' => 'TC',
                'iso3' => 'TCA',
                'continent' => 'NA',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => '+1-649',
                'postalcodeformat' => 'TKCA 1ZZ',
                'postalcoderegex' => '^(TKCA 1ZZ)$',
                'languages' => 'en-TC',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Tuvalu',
                'iso2' => 'TV',
                'iso3' => 'TUV',
                'continent' => 'OC',
                'currency' => 'AUD',
                'currencyname' => 'Dollar',
                'phone' => 688,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'tvl,en,sm,gil',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'U.S. Virgin Islands',
                'iso2' => 'VI',
                'iso3' => 'VIR',
                'continent' => 'NA',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => '+1-340',
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-VI',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Uganda',
                'iso2' => 'UG',
                'iso3' => 'UGA',
                'continent' => 'AF',
                'currency' => 'UGX',
                'currencyname' => 'Shilling',
                'phone' => 256,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-UG,lg,sw,ar',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Ukraine',
                'iso2' => 'UA',
                'iso3' => 'UKR',
                'continent' => 'EU',
                'currency' => 'UAH',
                'currencyname' => 'Hryvnia',
                'phone' => 380,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'uk,ru-UA,rom,pl,hu',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'United Arab Emirates',
                'iso2' => 'AE',
                'iso3' => 'ARE',
                'continent' => 'AS',
                'currency' => 'AED',
                'currencyname' => 'Dirham',
                'phone' => 971,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ar-AE,fa,en,hi,ur',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'United Kingdom',
                'iso2' => 'GB',
                'iso3' => 'GBR',
                'continent' => 'EU',
                'currency' => 'GBP',
                'currencyname' => 'Pound',
                'phone' => 44,
                'postalcodeformat' => '@# #@@|@## #@@|@@# #',
                'postalcoderegex' => '^(([A-Z]d{2}[A-Z]{2}',
                'languages' => 'en-GB,cy-GB,gd',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'United States',
                'iso2' => 'US',
                'iso3' => 'USA',
                'continent' => 'NA',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 1,
                'postalcodeformat' => '#####-####',
                'postalcoderegex' => '^(d{9})$',
                'languages' => 'en-US,es-US,haw,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'United States Minor Outlying Islands',
                'iso2' => 'UM',
                'iso3' => 'UMI',
                'continent' => 'OC',
                'currency' => 'USD',
                'currencyname' => 'Dollar',
                'phone' => 1,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-UM',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Uruguay',
                'iso2' => 'UY',
                'iso3' => 'URY',
                'continent' => 'SA',
                'currency' => 'UYU',
                'currencyname' => 'Peso',
                'phone' => 598,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'es-UY',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Uzbekistan',
                'iso2' => 'UZ',
                'iso3' => 'UZB',
                'continent' => 'AS',
                'currency' => 'UZS',
                'currencyname' => 'Som',
                'phone' => 998,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'uz,ru,tg',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Vanuatu',
                'iso2' => 'VU',
                'iso3' => 'VUT',
                'continent' => 'OC',
                'currency' => 'VUV',
                'currencyname' => 'Vatu',
                'phone' => 678,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'bi,en-VU,fr-VU',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Vatican',
                'iso2' => 'VA',
                'iso3' => 'VAT',
                'continent' => 'EU',
                'currency' => 'EUR',
                'currencyname' => 'Euro',
                'phone' => 379,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'la,it,fr',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Venezuela',
                'iso2' => 'VE',
                'iso3' => 'VEN',
                'continent' => 'SA',
                'currency' => 'VEF',
                'currencyname' => 'Bolivar',
                'phone' => 58,
                'postalcodeformat' => '####',
                'postalcoderegex' => '^(d{4})$',
                'languages' => 'es-VE',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Vietnam',
                'iso2' => 'VN',
                'iso3' => 'VNM',
                'continent' => 'AS',
                'currency' => 'VND',
                'currencyname' => 'Dong',
                'phone' => 84,
                'postalcodeformat' => '######',
                'postalcoderegex' => '^(d{6})$',
                'languages' => 'vi,en,fr,zh,km',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Wallis and Futuna',
                'iso2' => 'WF',
                'iso3' => 'WLF',
                'continent' => 'OC',
                'currency' => 'XPF',
                'currencyname' => 'Franc',
                'phone' => 681,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(986d{2})$',
                'languages' => 'wls,fud,fr-WF',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Western Sahara',
                'iso2' => 'EH',
                'iso3' => 'ESH',
                'continent' => 'AF',
                'currency' => 'MAD',
                'currencyname' => 'Dirham',
                'phone' => 212,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ar,mey',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Yemen',
                'iso2' => 'YE',
                'iso3' => 'YEM',
                'continent' => 'AS',
                'currency' => 'YER',
                'currencyname' => 'Rial',
                'phone' => 967,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'ar-YE',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Zambia',
                'iso2' => 'ZM',
                'iso3' => 'ZMB',
                'continent' => 'AF',
                'currency' => 'ZMK',
                'currencyname' => 'Kwacha',
                'phone' => 260,
                'postalcodeformat' => '#####',
                'postalcoderegex' => '^(d{5})$',
                'languages' => 'en-ZM,bem,loz,lun,lue,ny,toi',
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s') ,
                'updated_at' => date('Y-m-d H:i:s') ,
                'name' => 'Zimbabwe',
                'iso2' => 'ZW',
                'iso3' => 'ZWE',
                'continent' => 'AF',
                'currency' => 'ZWL',
                'currencyname' => 'Dollar',
                'phone' => 263,
                'postalcodeformat' => '',
                'postalcoderegex' => '',
                'languages' => 'en-ZW,sn,nr,nd',
            ) ,
        );
        $posts = $this->table('countries');
        $posts->insert($data)
              ->save();
    }
}
