<?php

use Phinx\Seed\AbstractSeed;

class SettingsSeeder extends AbstractSeed
{
    /**
     * Run Method.
     *
     * Write your database seeder using this method.
     *
     * More information on writing seeders is available here:
     * http://docs.phinx.org/en/latest/seeding.html
     */
    public function run()
    {

        $data = array(
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SITE_FROM_EMAIL',
                'value' => 'productdemo.admin@gmail.com',
                'description' => "You can change this email address so that 'From' email will be changed in all email communication.",
                'type' => 'text',
                'label' => 'From Email Address',
                'display_order' => 1,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SUPPORT_EMAIL',
                'value' => 'productdemo.admin@gmail.com',
                'description' => 'Support email',
                'type' => 'text',
                'label' => 'Support Email Address',
                'display_order' => 4,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_IS_WELCOME_MAIL_AFTER_REGISTER',
                'value' => 0,
                'description' => 'On enabling this feature, users will receive a welcome mail after registration.',
                'type' => 'checkbox',
                'label' => 'Enable Sending Welcome Mail After Registration',
                'display_order' => 6,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_USING_TO_LOGIN',
                'value' => 'username',
                'description' => 'You can select the option from the drop-downs to login into the site',
                'type' => 'select',
                'label' => 'Login Handle',
                'display_order' => 1,
                'options' => 'username, email',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 0,
                'name' => 'SITE_DOMAIN_SECRET_HASH',
                'value' => 'a29ffa33-98ef-4ff4-aaa5-4b0cc39da068',
                'description' => 'Zazpay Domain Secret Hash',
                'type' => 'text',
                'label' => 'Zazpay Domain Secret hash',
                'display_order' => 0,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 0,
                'name' => 'SITE_IS_WEBSITE_CREATED',
                'value' => 1,
                'description' => 'Zazpay website account created',
                'type' => 'checkbox',
                'label' => 'Zazpay Website Account created',
                'display_order' => 0,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 2,
                'name' => 'SITE_ROBOTS',
                'value' => '',
                'description' => 'Content for robots.txt; (search engine) robots specific instructions. Refer, http://www.robotstxt.org/ for syntax and usage.',
                'type' => 'textarea',
                'label' => 'robots.txt',
                'display_order' => 4,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SITE_REPLY_TO_EMAIL',
                'value' => '',
                'description' => "You can change this email address so that 'ReplyTo' email will be changed in all email communication.",
                'type' => 'text',
                'label' => 'Reply To Email Address',
                'display_order' => 2,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 8,
                'name' => 'WIDGET_FOOTER_SCRIPT',
                'value' => '',
                'description' => 'This is the footer page script, used for display banners on footer page',
                'type' => 'textarea',
                'label' => 'Code',
                'display_order' => 1,
                'options' => '',
                'plugin' => 'Restaurant/MultiRestaurant',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SITE_CONTACT_EMAIL',
                'value' => 'productdemo.admin@gmail.com',
                'description' => 'Contact email',
                'type' => 'text',
                'label' => 'Contact Email',
                'display_order' => 3,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 0,
                'name' => 'SITE_IS_ENABLE_SUDOPAY_PLUGIN',
                'value' => 1,
                'description' => 'When site purchased ZazPay plugin',
                'type' => 'checkbox',
                'label' => 'Enable ZazPay plugin',
                'display_order' => 0,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SITE_NAME',
                'value' => 'OFOS',
                'description' => 'This name will be used in all pages and emails.',
                'type' => 'text',
                'label' => 'Site name',
                'display_order' => 1,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 8,
                'name' => 'WIDGET_HOME_SCRIPT',
                'value' => '',
                'description' => 'This is the browse page script, used for display banners on browse page below ending soon',
                'type' => 'textarea',
                'label' => 'Code',
                'display_order' => 1,
                'options' => '',
                'plugin' => 'Restaurant/MultiRestaurant',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 8,
                'name' => 'WIDGET_USER_SCRIPT',
                'value' => '',
                'description' => 'This is the Header part script, used for display banners on Header',
                'type' => 'textarea',
                'label' => 'Code',
                'display_order' => 1,
                'options' => '',
                'plugin' => 'Restaurant/MultiRestaurant',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 8,
                'name' => 'WIDGET_VIEW_SCRIPT',
                'value' => '',
                'description' => 'Used for display banners on right side of restaurant view page',
                'type' => 'textarea',
                'label' => 'Restaurant View Widget',
                'display_order' => 1,
                'options' => '',
                'plugin' => 'Restaurant/MultiRestaurant',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 28,
                'name' => 'IPHONE_IS_LIVE',
                'value' => 1,
                'description' => 'iPhone Live Mode	',
                'type' => 'text',
                'label' => 'iPhone Live Mode',
                'display_order' => 1,
                'options' => '',
                'plugin' => 'Order/Mobile',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 28,
                'name' => 'PEM_FILE',
                'value' => 'agriyaTest.pem',
                'description' => 'Pem File name',
                'type' => 'text',
                'label' => 'Pem File name',
                'display_order' => 2,
                'options' => '',
                'plugin' => 'Order/Mobile',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 28,
                'name' => 'PEM_PASSWORD',
                'value' => 'ahsan123',
                'description' => 'Pem Password',
                'type' => 'text',
                'label' => 'Pem Password',
                'display_order' => 3,
                'options' => '',
                'plugin' => 'Order/Mobile',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 28,
                'name' => 'API_ACCESS_KEY',
                'value' => 'AIzaSyBZpIKn6rEsH52qll7fmu_fTY8jute52pA',
                'description' => 'Android Api Access Key',
                'type' => 'text',
                'label' => 'Android Api Access Key',
                'display_order' => 4,
                'options' => '',
                'plugin' => 'Order/Mobile',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 28,
                'name' => 'PUSH_NOTIFICATION_FOR_NEW_BOOKING',
                'value' => 'Your order ##ORDER_NO## of ##CURRENCY_SYMBOL## ##AMOUNT## has been placed. It is eligible for on-time guarantee and will be delivered with in ##ESTIMATED_TIME_TO_DELIVERY##.',
                'description' => 'We will send this sms to user for new order placed and the constants variables are ##SITE_NAME##, ##ORDER_NO##, ##CURRENCY_SYMBOL##, ##ESTIMATED_TIME_TO_DELIVERY##.',
                'type' => 'text',
                'label' => 'Push Notification For New Booking',
                'display_order' => 5,
                'options' => '',
                'plugin' => 'Order/Mobile',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 28,
                'name' => 'PUSH_NOTIFICATION_FOR_BOOKING_ASSIGN_TO_DELIVERY',
                'value' => 'Your order ##ORDER_NO## of ##CURRENCY_SYMBOL## ##AMOUNT## will be delivered shortly. Thanks for using ##SITE_NAME##.',
                'description' => 'We will send this sms to user for their order assigned to delivery and the constants variables are ##SITE_NAME##, ##ORDER_NO##, ##CURRENCY_SYMBOL##, ##AMOUNT##, ##TOTAL_PRICE##, ##DELIVERY_CHARGE##, ##SALES_TAX##.',
                'type' => 'text',
                'label' => 'Push Notification For Booking Assign To Delivery',
                'display_order' => 6,
                'options' => '',
                'plugin' => 'Order/Mobile',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 29,
                'name' => 'SMS_FOR_NEW_BOOKING',
                'value' => 'Your order ##ORDER_NO## of ##CURRENCY_SYMBOL## ##AMOUNT## has been placed. It is eligible for on-time guarantee and will be delivered with in ##ESTIMATED_TIME_TO_DELIVERY##.',
                'description' => 'we will send this sms to user for new order placed and the constants variables are ##SITE_NAME##, ##BOOKING_DATE##, ##RESTAURANT_NAME##, ##AMOUNT##, ##TOTAL_PRICE##, ##DELIVERY_CHARGE##, ##SALES_TAX##, ##ORDER_NO##, ##CURRENCY_SYMBOL##',
                'type' => 'text',
                'label' => 'SMS For New Booking',
                'display_order' => 1,
                'options' => '',
                'plugin' => 'Order/Sms',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 29,
                'name' => 'SMS_FOR_BOOKING_ASSIGN_TO_DELIVERY',
                'value' => 'your order ##ORDER_NO## of ##CURRENCY_SYMBOL## ##AMOUNT## will be delivered shortly. Thanks for using ##SITE_NAME##.',
                'description' => 'we will send this sms to user while order assigned to delivery and the constants variables are ##SITE_NAME##, ##BOOKING_DATE##, ##RESTAURANT_NAME##, ##AMOUNT##, ##TOTAL_PRICE##, ##DELIVERY_CHARGE##, ##SALES_TAX##, ##ORDER_NO##, ##CURRENCY_SYMBOL##',
                'type' => 'text',
                'label' => 'SMS For Booking Assign To Delivery',
                'display_order' => 2,
                'options' => '',
                'plugin' => 'Order/Sms',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 29,
                'name' => 'SMS_FOR_BOOKING_DELIVERED',
                'value' => 'Your order ##ORDER_NO## has been delivered! We hope you enjoyed the ##SITE_NAME## Assured Experience.',
                'description' => ' we will send this sms after booking delivered to user and the constants variables are ##SITE_NAME##, ##BOOKING_DATE##, ##RESTAURANT_NAME##, ##AMOUNT##, ##TOTAL_PRICE##, ##DELIVERY_CHARGE##, ##SALES_TAX##, ##ORDER_NO##, ##CURRENCY_SYMBOL##',
                'type' => 'text',
                'label' => 'SMS For Booking Delivered',
                'display_order' => 3,
                'options' => '',
                'plugin' => 'Order/Sms',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 28,
                'name' => 'PUSH_NOTIFICATION_FOR_BOOKING_DELIVERED',
                'value' => 'Your order ##ORDER_NO## has been delivered! We hope you enjoyed the ##SITE_NAME## Assured Experience.',
                'description' => 'We will send this sms to user after booking delivered and the constants variables are ##SITE_NAME##, ##BOOKING_DATE##, ##RESTAURANT_NAME##, ##AMOUNT##, ##TOTAL_PRICE##, ##DELIVERY_CHARGE##, ##SALES_TAX##, ##ORDER_NO##, ##CURRENCY_SYMBOL##',
                'type' => 'text',
                'label' => 'Push Notification For Booking Delivered',
                'display_order' => 7,
                'options' => '',
                'plugin' => 'Order/Mobile',
                'is_front_end_access' => 0,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_IS_EMAIL_VERIFICATION_FOR_REGISTER',
                'value' => 0,
                'description' => 'On enabling this feature, the users are required to verify their email address which will be provided by them during registration. (Users cannot login until the email address is verified)',
                'type' => 'checkbox',
                'label' => 'Enable Email Verification After Registration',
                'display_order' => 2,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_IS_ADMIN_ACTIVATE_AFTER_REGISTER',
                'value' => 0,
                'description' => 'On enabling this feature, the user will not be able to login until the Admin (that will be you) approves their registration.',
                'type' => 'checkbox',
                'label' => 'Enable Administrator Approval After Registration',
                'display_order' => 1,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_IS_LOGOUT_AFTER_CHANGE_PASSWORD',
                'value' => 0,
                'description' => 'By enabling this feature, When user changes the password, he will automatically log-out.',
                'type' => 'checkbox',
                'label' => 'Enable User to Logout after Password Change',
                'display_order' => 5,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_IS_AUTO_LOGIN_AFTER_REGISTER',
                'value' => 0,
                'description' => 'On enabling this feature, users will be automatically logged-in after registration. (Only when "Email Verification" & "Admin Approval" is disabled)',
                'type' => 'checkbox',
                'label' => 'Enable Auto Login After Registration',
                'display_order' => 3,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 3,
                'name' => 'CURRENCY_SYMBOL',
                'value' => '$',
                'description' => 'Site Currency symbol of PayPal Currency Code. eg. $ for USD',
                'type' => 'text',
                'label' => 'Site Currency Symbol',
                'display_order' => 1,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 3,
                'name' => 'CURRENCY_CODE',
                'value' => 'USD',
                'description' => 'PayPal doesnt support all currencies; refer, https://www.paypal.com/cgi-bin/webscr?cmd=p/sell/mc/mc_wa-outside for list of supported currencies in PayPal. The selected currency will be used as site default currency. (All payments, transaction will use this currency).',
                'type' => 'select',
                'label' => 'Currency Code',
                'display_order' => 2,
                'options' => 'AUD,BRL,CAD,CZK,DKK,EUR,HKD,HUF,ILS,JPY,MXN,NOK,NZD,PHP,PLN,GBP,SGD,SEK,CHF,TWD,THB,TRY,USD',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 2,
                'name' => 'META_DESCRIPTION',
                'value' => 'Online food ordering system',
                'description' => 'These are the short descriptions for your site which will be used by the search engines on the search result pages to display preview snippets for a given page.',
                'type' => 'textarea',
                'label' => 'Description',
                'display_order' => 2,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 3,
                'name' => 'SITE_LANGUAGE',
                'value' => 'en',
                'description' => 'The selected language will be used as default language all over the site.',
                'type' => 'select',
                'label' => 'Site Language ',
                'display_order' => 1,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_IS_ALLOW_SWITCH_LANGUAGE',
                'value' => 1,
                'description' => 'On enabling this feature, users can change site language to their choice.',
                'type' => 'checkbox',
                'label' => 'Enable User to Switch Language',
                'display_order' => 1,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_IS_ADMIN_MAIL_AFTER_REGISTER',
                'value' => 0,
                'description' => 'On enabling this feature, notification mail will be sent to administrator on each registration.',
                'type' => 'checkbox',
                'label' => 'Enable Notify Administrator on Each Registration',
                'display_order' => 7,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_IS_CAPTCHA_ENABLED_FORGOT_PASSWORD',
                'value' => 0,
                'description' => 'On enabling this feature, captcha will display forgot password page.',
                'type' => 'checkbox',
                'label' => 'Enable Captcha Forgot password',
                'display_order' => 8,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SITE_TWITTER_URL',
                'value' => 'https://twitter.com/agriya',
                'description' => '',
                'type' => 'text',
                'label' => 'Site Twitter URL',
                'display_order' => 4,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SITE_FACEBOOK_URL',
                'value' => 'https://www.facebook.com/agriya',
                'description' => '',
                'type' => 'text',
                'label' => 'Site Facebook URL',
                'display_order' => 4,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SITE_YOUTUBE_URL',
                'value' => 'https://www.youtube.com/channel/UCcxmjGrb-E8CKXFv2RKOG5A',
                'description' => '',
                'type' => 'text',
                'label' => 'Site Youtube URL',
                'display_order' => 4,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 6,
                'name' => 'USER_MINIMUM_WITHDRAW_AMOUNT',
                'value' => 2,
                'description' => 'This is the minimum amount a user can withdraw from their wallet.',
                'type' => 'text',
                'label' => 'Minimum Withdrawal Amount',
                'display_order' => 1,
                'options' => '',
                'plugin' => 'Common/Withdrawal',
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 6,
                'name' => 'USER_MAXIMUM_WITHDRAW_AMOUNT',
                'value' => 10000,
                'description' => 'This is the maximum amount a user can withdraw from their wallet.',
                'type' => 'text',
                'label' => 'Maximum Withdrawal Amount',
                'display_order' => 2,
                'options' => '',
                'plugin' => 'Common/Withdrawal',
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 9,
                'name' => 'SITE_COMMISSION',
                'value' => 10,
                'description' => 'Site commission percentage wise',
                'type' => 'text',
                'label' => 'Site commission',
                'display_order' => 1,
                'options' => '',
                'plugin' => 'Order/Order',
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 2,
                'name' => 'META_KEYWORDS',
                'value' => 'Agriya, OFOS, Online Food Ordering System',
                'description' => 'These are the keywords used for improving search engine results of your site. (Comma separated texts for multiple keywords.)',
                'type' => 'text',
                'label' => 'Keywords',
                'display_order' => 1,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SITE_ENABLED_PLUGINS',
                'value' => 'Common/Paypal,Order/Coupon,Common/Translation,Common/Wallet,Common/Withdrawal,Common/ZazPay,Order/Mobile,Order/Order,Order/OutsourcedDelivery,Order/OwnDelivery,Order/Sms,Order/Supervisor,Order/Review,Restaurant/MultiRestaurant',
                'description' => '',
                'type' => 'text',
                'label' => 'Site Plugin',
                'display_order' => 1,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 5,
                'name' => 'WALLET_MIN_WALLET_AMOUNT',
                'value' => 10,
                'description' => 'This is the minimum amount a user can add to his wallet.',
                'type' => 'text',
                'label' => 'Minimum wallet amount',
                'display_order' => 1,
                'options' => '',
                'plugin' => 'Common/Wallet',
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 5,
                'name' => 'WALLET_MAX_WALLET_AMOUNT',
                'value' => 20000,
                'description' => 'This is the maximum amount a user can add to his wallet. (If left empty, then, no maximum amount restrictions).',
                'type' => 'text',
                'label' => 'Maximum wallet amount',
                'display_order' => 2,
                'options' => '',
                'plugin' => 'Common/Wallet',
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 1,
                'name' => 'SITE_OFFLINE',
                'value' => 0,
                'description' => 'If Site offline is 1 then Site display as offline.',
                'type' => 'text',
                'label' => 'Site Offline?',
                'display_order' => 10,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 30,
                'name' => 'DISABLE_PRE_BOOK',
                'value' => 0,
                'description' => 'Overall site pre-book Will be disabled.',
                'type' => 'text',
                'label' => 'Disable pre-book?',
                'display_order' => 11,
                'options' => '',
                'plugin' => 'Order/Order',
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 4,
                'name' => 'USER_IS_CAPTCHA_ENABLED_REGISTER',
                'value' => 0,
                'description' => 'On enabling this feature, captcha will display registration page.',
                'type' => 'checkbox',
                'label' => 'Enable Captcha Registration',
                'display_order' => 10,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 7,
                'name' => 'CAPTCHA_SITE_KEY',
                'value' => '6LctcT8UAAAAAOKkmE0tPtOVd2vpgcoxIbBuQkj9',
                'description' => 'Captcha site key',
                'type' => 'text',
                'label' => 'Captcha Site Key',
                'display_order' => 11,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
            array(
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
                'setting_category_id' => 7,
                'name' => 'CAPTCHA_SECRET_KEY',
                'value' => '6LctcT8UAAAAAPyOY6a-SEnVRgmBDLeQwBXCITLd',
                'description' => 'Captcha Secret Key',
                'type' => '',
                'label' => 'Captcha Secret Key',
                'display_order' => 12,
                'options' => '',
                'plugin' => null,
                'is_front_end_access' => 1,
            ) ,
        );
        $setting_categories = $this->table('settings');
        $setting_categories->insert($data)
              ->save();
    }
}
