(ns zprint.comment-test
  (:require [expectations.clojure.test
             #?(:clj :refer
                :cljs :refer-macros) [defexpect expect]]
            [zprint.core :refer [zprint-file-str zprint-str set-options!]]
            [zprint.finish :refer [cvec-to-style-vec compress-style]]))

;; Keep some of the test from wrapping so they still work
;!zprint {:comment {:wrap? false}}

;
; Keep tests from configuring from any $HOME/.zprintrc or local .zprintrc
;

;
; Set :force-eol-blanks? true here to see if we are catching eol blanks
;

(set-options!
  {:configured? true, :force-eol-blanks? false, :test-for-eol-blanks? true})

(defexpect comment-tests

  ;;
  ;; # Comment
  ;;

  (def zc8
    "(defn accumulate-ll\n  [count-comment? [out cur-len just-eol? just-comment? :as in] s tag eol?]\n  (let [comment? (or (= tag :comment) (= tag :comment-inline))\n        count-s (if (and comment? (not count-comment?)) 0 (count s))]\n    (cond\n      ; if we are told to terminate the line or it is a comment, we\n      ; terminate the line with the size of the string added to it\n      (or (and eol? (not (and just-eol? (zero? count-s)))) comment?)\n        [(conj out (+ cur-len count-s)) 0 true comment?]\n      ; no reason to terminate the line, just accumulate\n      ; the size in cur-len\n      :else [out (+ cur-len count-s) nil comment?])))\n")

  (def zc3
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    ; If it is one-line? and force-nl? and there is more than one thing,\n    ; this can't work.\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            ; If the caller has flow? true, then justification is meaningless\n            justify? (if (:flow? (caller options)) nil justify?)\n            ; If we are justifying merge in a full options map,\n            ; which can contain anything!  Don't validate it since\n            ; it was already in the options map to start with.\n            [justify-options _] stuff\n            ; Some callers do not have lhs-narrow defined\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ; There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a narrower\n            ;    width.  Only helps if the lhs contains some collections.\n            ;    Also this is only done if the lhs-narrow factor is more than\n            ;    1.01.\n            ;\n            ; Each type of justification requires a different narrow-width.\n            ;\n            ; We will do both and compare them if they work.  They can fail\n            ; to work in two ways:\n            ;\n            ;  1. They can fail in fzprint-justify-width, because a good\n            ;     justify-width can't be found.\n            ;  2. They can fail in fzprint-two-up-pass, because the rhs had\n            ;     to flow, which will fail the justification.\n            ;\n            ; If only one of them works, we will use that.\n            ;\n            ; Do the fzprint-justify-width for any lhs-narrow\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            ; Do the fzprint-justify-width without lhs-narrow\n            ; If we are justifying, give that a try\n            result-narrow (when justify-narrow-width\n                            ;\n                            ; Pass 1: Justification, using a narrowed lhs\n                            ;         width, if any.\n                            ;\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))\n")

  (def zc9
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    ; If it is one-line? and force-nl? and there is more than one thing,\n    ; this can't work.\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            ; If the caller has flow? true, then justification is meaningless\n            justify? (if (:flow? (caller options)) nil justify?)\n            ; If we are justifying merge in a full options map,\n            ; which can contain anything!  Don't validate it since\n            ; it was already in the options map to start with.\n            [justify-options _] stuff\n            ; Some callers do not have lhs-narrow defined\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ; There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a narrower\n            ;    width.  Only helps if the lhs contains some collections.\n            ;    Also this is only done if the lhs-narrow factor is more than\n            ;    1.01.\n\t    ;\n\t    ;this is a test\n\t    ;this only a test of how we find\n\t    ;\n\t    ; this is a test\n\t    ; this only a test of how we find\n            ;\n            ; Each type of justification requires a different narrow-width.\n            ;\n            ; We will do both and compare them if they work.  They can fail\n            ; to work in two ways:\n            ;\n            ;  1. They can fail in fzprint-justify-width, because a good\n            ;     justify-width can't be found.\n            ;  2. They can fail in fzprint-two-up-pass, because the rhs had\n            ;     to flow, which will fail the justification.\n            ;\n            ; If only one of them works, we will use that.\n            ;\n            ; Do the fzprint-justify-width for any lhs-narrow\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            ; Do the fzprint-justify-width without lhs-narrow\n            ; If we are justifying, give that a try\n            result-narrow (when justify-narrow-width\n                            ;\n                            ; Pass 1: Justification, using a narrowed lhs\n                            ;         width, if any.\n                            ;\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))\n")

  (def zc11
    "(defn fzprint-list*\n  \"Print a list, which might be a list or an anon fn.  \n  Lots of work to make a list look good, as that is typically code. \n  Presently all of the callers of this are :list or :vector-fn.\"\n  [caller l-str r-str\n   {:keys [fn-map user-fn-map one-line? fn-style no-arg1? fn-force-nl quote?],\n    :as options} ind zloc]\n  (if (= (:format options) :off)\n    (fzprint-noformat l-str r-str options zloc)\n    (let [max-length (get-max-length options)\n          arg-1-coll? (not (or (zkeyword? arg-1-zloc) (zsymbol? arg-1-zloc)))\n          arg-1-indent-alt? (and arg-1-coll? fn-style)\n          fn-str (if-not arg-1-coll? (zstring arg-1-zloc))\n          ; If we don't have a fn-str, then we might have a fn-type.\n          ; NOTE WELL: a fn-style is a :arg1 or something like that.  This\n          ; is called a ::fn-type in the spec!\n          ; Here, a fn-type is a keyword of the \"type\" of the fn-str,\n          ; i.e. :list, :map, :vector or :set.\n          fn-type (when-not fn-str\n                    (cond (zlist? arg-1-zloc) :list\n                          (zmap? arg-1-zloc) :map\n                          (zvector? arg-1-zloc) :vector\n                          (zset? arg-1-zloc) :set\n                          :else nil))]\n   nil)))\n")

  (def zc11a
    "(defn fzprint-list*\n  \"Print a list, which might be a list or an anon fn.  \n  Lots of work to make a list look good, as that is typically code. \n  Presently all of the callers of this are :list or :vector-fn.\"\n  [caller l-str r-str\n   {:keys [fn-map user-fn-map one-line? fn-style no-arg1? fn-force-nl quote?],\n    :as options} ind zloc]\n  (if (= (:format options) :off)\n    (fzprint-noformat l-str r-str options zloc)\n    (let [max-length (get-max-length options)\n          arg-1-coll? (not (or (zkeyword? arg-1-zloc) (zsymbol? arg-1-zloc)))\n          arg-1-indent-alt? (and arg-1-coll? fn-style)\n          fn-str (if-not arg-1-coll? (zstring arg-1-zloc))\n          ; If we don't have a fn-str, then we might have a fn-type.\n          ; Note well  a fn-style is a :arg1 or something like that.  This\n          ; is called a ::fn-type in the spec!\n          ; Here, a fn-type is a keyword of the \"type\" of the fn-str,\n          ; i.e. :list, :map, :vector or :set.\n          fn-type (when-not fn-str\n                    (cond (zlist? arg-1-zloc) :list\n                          (zmap? arg-1-zloc) :map\n                          (zvector? arg-1-zloc) :vector\n                          (zset? arg-1-zloc) :set\n                          :else nil))]\n   nil)))\n")

  (def zc17
    "(defn line-lengths\n  [options ind style-vec]\n  (let [length-vec (first ; this final accumulate-ll is to terminate the\n                          ; last\n                          ; line, the one in progress\n                     (let [count-comment? (:count? (:comment options))\n                           [_ _ just-eol? just-comment? :as result]\n                             (reduce (partial generate-ll count-comment?)\n                               [[] (if (coll? ind) (first ind) ind) nil nil]\n                               style-vec)]\n                       (if (and just-eol? (not just-comment?))\n                         result\n                         (accumulate-ll count-comment?\n                                        (assoc result 2 nil)\n                                        \"\"\n                                        nil\n                                        true))))\n        ; Unspecified seq, might be a fn, might not.\n        ; If (first zloc) is a seq, we won't have an\n        ; arg-1-indent.  In that case, just flow it\n        ; out with remaining seq.  Since we already\n        ; know that it won't fit on one line.  If it\n        ; might be a fn, try hanging and flow and do\n        ; what we like better.  Note that default-indent\n        ; might be 1 here, which means that we are pretty\n        ; sure that the (zfirst zloc) isn't a function\n        ; and we aren't doing code.\n        ;\t\t\t\t\t\n\t\t\t\t\t\n\t\t\t\t\t]\n    (dbg-pr options\n            \"line-lengths: style-vec:\" style-vec\n            \"ind:\" ind\n            \"length-vec:\" length-vec)\n    length-vec))\n")

  (def zc21
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            ; This is necessary because f can be a symbol that\n            ; resolve will have a problem with.  The obvious ones\n            ; were (ns-name <some-namespace>), but there are almost\n            ; certainly others.\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f)\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))\n")

  (def zc5
    "(defn stuff\n  [a b c]\n  (this is a (test\n                 this \n\t\t is only\n\t\t a test  ; this is a very long inline comment so that we can see if it wrap\n\t\t )))\n")

  (def zc24
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this onewordthatistoolongfortheline \n\t\t\t                                          ; a second word\n\t\t\t\t\t\t\t\t  ; and a third too\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))\n")

  (def zc25
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this \n\t\t\t                                          ; onewordthatistoolongfortheline \n\t\t\t                                          ; a second word\n\t\t\t\t\t\t\t\t  ; and a third too\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))\n")

  (def zc26
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this \n\t\t\t                                          ; onewordthatistoolongfortheline a second\n\t\t\t                                          ; word\n\t\t\t\t\t\t\t\t  ; and a third too\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))\n")

  (def zc27
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this \n\t\t\t                                          ; onewordthatistoolongfortheline a second\n\t\t\t                                          ; word\n\t\t\t\t\t\t\t\t  ; and a third too\n\t\t\t\t\t\t\t\t  ; withafinalwordthatistoolong\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))\n")

  (def zc28
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this \n\t\t\t                                          ; onewordthatistoolongfortheline a second\n\t\t\t                                          ; wor\n\t\t\t\t\t\t\t\t  ; and a third too\n\t\t\t\t\t\t\t\t  ; withafinalwordthatistoolong\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))\n")

  (def zc29
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this \n\t\t\t                                          ; onewordthatistoolongfortheline a second.\n\t\t\t                                          ; wor\n\t\t\t\t\t\t\t\t  ; and a third too\n\t\t\t\t\t\t\t\t  ; withafinalwordthatistoolong\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))\n")

  (def zc31
    "(defn balance-two-comments\n  \"Take the index into the style-vec for two comments, and balance\n  the words in them. Note that usable-space is start-col based.\n  Returns a new style-vec in [new-style-vec changed?].\"\n  [start-col-vec style-vec semi-count space-count usable-space upper-idx\n   lower-idx comment-group]\n  (let [[us ucolor uwhat :as upper-element] (nth style-vec upper-idx)\n        [ls lcolor lwhat :as lower-element] (nth style-vec lower-idx)\n        ; All of the space measurement up to this point includes the\n        ; semis and spaces on the front of every line.\n        upper-space (count us)\n        lower-space (count ls)\n        front-matter (+ semi-count space-count)\n        ; Get upper and lower strings w/out semis or spaces\n        us-text (subs us front-matter)\n        ls-text (subs ls front-matter)]\n    #_(println \"balance-two-comments: usable-space:\" usable-space\n             \"upper-idx:\" upper-idx\n             \"lower-idx:\" lower-idx\n             \"\\nus:\" (pr-str us)\n             \"\\nls:\" (pr-str ls))\n    (cond\n      (> upper-space usable-space)\n        ; Move from upper to lower if we can.\n        ; It might be that there is one thing on the upper that simply\n        ; doesn't fit.\n        (let [[new-us new-start-ls] (split-str-at-space us-text usable-space)]\n          #_(println \"...upper->lower us:\" (pr-str us)\n                   \"\\n   ls:\" (pr-str ls)\n                   \"\\n   new-us:\" (pr-str new-us)\n                   \"\\n   new-start-ls:\" (pr-str new-start-ls))\n          (if (not (empty? new-start-ls))\n            (let [full-us (text-to-comment semi-count space-count new-us)]\n              (let [[separator new-ls-text] (figure-separator new-start-ls\n                                                              ls-text)\n                    full-ls (text-to-comment\n                              semi-count\n                              space-count\n                              (str new-start-ls separator new-ls-text))]\n                #_(println \".2.new-ls:\" (pr-str full-ls))\n                [(-> style-vec\n                     (insert-str-into-style-vec full-us upper-idx)\n                     (insert-str-into-style-vec full-ls lower-idx)) true]))\n            [style-vec nil]))\n      (and (do #_(println \"...(< upper-space usable-space)\" (< upper-space\n                                                             usable-space)\n                        \"lower-space:\" lower-space\n                        \"\\n   ls:\" (pr-str ls))\n               (< upper-space usable-space))\n           ; If the lower is shorter than the upper, and the lower\n           ; is the last line in the comment-group,\n           ; and the lower won't entirely fit onto the upper (and\n           ; thus allow us to remove a comment line), then don't\n           ; bother changing these lines\n           (do #_(println\n                 \"...(< lower-space upper-space)\" (< lower-space upper-space)\n                 \"(- usable-space upper-space)\" (- usable-space upper-space)\n                 \"(+ semi-count space-count)\" (+ semi-count space-count)\n                 \"(- lower-space (+ semi-count space-count))\"\n                   (- lower-space (+ semi-count space-count)))\n               true)\n           (not (and (< lower-space upper-space)\n                     (= (count comment-group) 2)\n                     (neg? (- (- usable-space upper-space)\n                              ; Include space between them\n                              (inc (- lower-space\n                                      (+ semi-count space-count))))))))\n        ; Move from lower to upper if possible\n        ; We need something from the lower string that is less than\n        ; the available space between the end of the upper string and\n        ; the end of the usable space.\n        ; Note that move-ls-to-us handles variable sized separators.\n        (let [available-space (- usable-space upper-space)\n              ; If new-ls is non-nil, that means that things changed.\n              ; However, new-ls might still be empty, indicating that\n              ; everything moved to the new-us!\n              [new-us new-ls] (move-ls-to-us us-text ls-text available-space)]\n         #_(println \"...move from lower to upper \\n   new-us:\" (pr-str new-us)\n                   \"\\n   new-ls:\" (pr-str new-ls))\n          ; If new-ls is non-nil, it might still be empty!\n          (if new-ls\n            (let [full-us (text-to-comment semi-count space-count new-us)]\n              (if (empty? new-ls)\n                [(-> style-vec\n                     (insert-str-into-style-vec full-us upper-idx)\n                     (delete-style-vec-element lower-idx)) true]\n                (let [full-ls (text-to-comment semi-count space-count new-ls)]\n                  [(-> style-vec\n                       (insert-str-into-style-vec full-us upper-idx)\n                       (insert-str-into-style-vec full-ls lower-idx)) true])))\n            ; We didn't make any changes, leave things as they are.\n            (do #_(println \"...no changes:\") [style-vec nil])))\n      :else [style-vec nil])))\n")

  (def zc33
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a narrower\n            ;    width.  Only helps if the lhs contains some collections.\n            ;    Also this is only done if the lhs-narrow factor is more than\n            ;    1.01.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))\n")

  (def zc34
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, \n\t    ;    where the lhs is squeezed by a narrower width.  Only \n\t    ;    helps if the lhs contains some collections.\n            ;    Also this is only done if the lhs-narrow factor is more than\n            ;    1.01.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))\n")

  (def zc35
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a nar\n            ;    width.  Only helps if the lhs contains some collections.\n            ;    Also this is only done if the lhs-narrow factor is more than\n            ;    1.01.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))\n")

  (def zc36
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a narr\n            ;    width.  Only helps if the lhs contains some collections.\n            ;    Also this is only done if the lhs-narrow factor is more than\n            ;    1.01.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))\n")
  (def zc37
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a narr\n            ;    width.  Only helps if the lhs contains some collections.\n\t    ;    Note:\n            ;    Also this is only done if the lhs-narrow factor is more than\n            ;    1.01.\n\t    ;\n\t    ;;   *   This is a test,\n\t    ;;       this is only a test.\n\t    ;;  -       This is also a test\n\t    ;;          along with this too.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))\n")

  (def zc39
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            zloc-seq-right-first (get-zloc-seq-right first-data)]\n            (concat-no-nil l-str-vec\n                           pre-arg-1-style-vec\n                           (fzprint* loptions (inc ind) arg-1-zloc)\n                           (prepend-nl options\n                                       (+ indent ind)\n                                       ; I think fzprint-pairs will sort out\n                                       ; which\n                                       ; is and isn't the rightmost because of\n                                       ; two-up\n                                       (fzprint-extend options\n                                                       (+ indent ind)\n                                                       zloc-seq-right-first))\n                           r-str-vec)))))\n")

  (def zc40
    "(defn interpose-either-nl-hf\n  \"Do very specialized interpose, but different seps depending on pred-fn\n  return and nl-separator? and nl-separator-all?. This assumes that \n  sep-* does one line, and sep-*-nl does two lines. coll is\n  a series of [[:flow [['\\n  ' :none :newline 2]]] \n               [:flow [['ZprintType' :black :element] ...]]] fragments from\n  fzprint-map-two-up.\"\n  [sep-comma sep-comma-nl sep sep-nl\n   {:keys [nl-separator? nl-separator-all?], :as suboptions} ;nl-separator?\n   comma? coll]\n  #_(prn \"ienf: sep:\" sep \"comma?\" comma? \"coll:\" coll)\n  (loop [coll coll\n         out (transient [])\n         previous-needs-comma? nil\n         add-nl? nil\n         first? true\n         newline-count 0]\n    (if (empty? coll)\n      (apply concat-no-nil\n        (persistent!\n          ; Handle final newlines, if any\n          (if (zero? newline-count)\n            out\n            (conj-it! out (repeat-element-nl newline-count (first sep))))))\n      (let [[hangflow style-vec] (first coll)\n            [_ _ what] (first style-vec)]\n        #_(prn \"====>>>>>>>> interpose-either-nl-hf: style-vec:\" style-vec)\n        (cond\n          (= what :newline)\n            ; We have one or more newlines.  We are going to keep\n            ; track of what we've seen and will actually output things\n            ; later, when we know what we actually have.\n            ; For now, just increase the count and don't do anything\n            ; else.  If we have anything in addition to newlines, we have a\n            ; problem because we will lose them as the style-vec\n            ; goes away, which is why count-newline-types will throw\n            ; an exception if it encounters this.\n            (do #_(prn \"interpose-either-nl-hf: hangflow: \" hangflow)\n                (recur (next coll)\n                       out\n                       previous-needs-comma?\n                       add-nl?\n                       first?\n                       (+ newline-count (count-newline-types style-vec))))\n          :else\n            ; We have a normal style-vec that we will process.  This one\n            ; may have plenty of newlines, but there isn't one first.\n            ; But we might have seen plenty of newlines\n            ; before this -- or not.\n            (let [[interpose-style-vec interpose-count]\n                    (if previous-needs-comma?\n                      (if add-nl? [sep-comma-nl 2] [sep-comma 1])\n                      (if add-nl? [sep-nl 2] [sep 1]))\n                  ; if first? we assume that we get one newline from caller\n                  interpose-count (if first? 1 interpose-count)\n                  addtl-nl-needed (max (- newline-count interpose-count) 0)]\n              ; Here is where we need to figure out if two newlines are\n              ; coming out in order, and ensure that the first ones don't\n              ; have any spaces after them.\n              #_(prn \"ienf: interpose-style-vec:\" interpose-style-vec)\n              (recur\n                (next coll)\n                (if first?\n                  (if (zero? addtl-nl-needed)\n                    (conj! out style-vec)\n                    (conj-it! out\n                              (repeat-element-nl addtl-nl-needed (first sep))\n                              style-vec))\n                  (if (zero? addtl-nl-needed)\n                    (conj-it! out interpose-style-vec style-vec)\n                    (conj-it! out\n                              (trimr-blanks-style-vec interpose-style-vec)\n                              (repeat-element-nl addtl-nl-needed (first sep))\n                              style-vec)))\n                (and comma?\n                     ; We got rid of newlines above\n                     (not= what :comment)\n                     (not= what :comment-inline)\n                     ; Is there a non comment or non newline/indent\n                     ; element left in coll, or is this the last one?\n                     ; This returns the [hangflow style-vec], but we\n                     ; are not using the data, just the existence of\n                     ; the thing here\n                     ; Fix for Issue #137.\n                     (next-non-comment-nl (next coll)))\n                ; should we put an extra new-line before the next\n                ; element?\n                ; Two styles here:\n                ;  o  always put one if the previous pair contained a\n                ;  new-line\n                ;     which could be (but is not) the default\n                ;     To do this you would do:\n                ;       (and nl-separator? (not (single-line?\n                ;       style-vec)))\n                ;  o  put one only if the previous right hand part of\n                ;  the\n                ;     pair did a flow (which is the current default)\n                ;     To do this, you look for whether or not the\n                ;     return\n                ;     from fzprint-map-two-up said it was a flow\n                (or (and nl-separator? (= hangflow :flow)) nl-separator-all?)\n                nil ;first?\n                0 ;newline-count\n              )))))))\n")

  (def zc41
    "(defn inline-test\n  [a b c]\n  (let [us test]\n    (some inline           ; comments\n          comments         ; some that are aligned\n\t  to\n\t  see                       ; a single line\n\t  if \n\t  aligned       ; and some\n\t  and           ; that are \n\t  consecutive                        ; not aligned\n\t  work))        ; at all\n\t  )\n")


  (def zc44
    "(defn fzprint-map-two-up\n  [caller options ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)]\n            (concat-no-nil l-str-vec\n                           (prepend-nl-and-move-it-right options\n                                       (+ indent ind)\n                                       ; I think that fzprint-extend will sort out \n\t\t\t\t       ; which is and isn't the rightmost because of two-up and even more stuff so that it can't fit at all\n                                       (fzprint-extend options))\n                           r-str-vec)))))\n")



  ;;
  ;; Basic smart wrap test
  ;;


  (expect
    "(defn accumulate-ll\n  [count-comment? [out cur-len just-eol? just-comment? :as in] s tag eol?]\n  (let [comment? (or (= tag :comment) (= tag :comment-inline))\n        count-s (if (and comment? (not count-comment?)) 0 (count s))]\n    (cond\n      ; if we are told to terminate the line or it is a comment, we\n      ; terminate the line with the size of the string added to it\n      (or (and eol? (not (and just-eol? (zero? count-s)))) comment?)\n        [(conj out (+ cur-len count-s)) 0 true comment?]\n      ; no reason to terminate the line, just accumulate the size in\n      ; cur-len\n      :else [out (+ cur-len count-s) nil comment?])))"
    (zprint-str zc8 {:parse-string? true}))

  ;;
  ;; A full featured test of smart wrap
  ;;


  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    ; If it is one-line? and force-nl? and there is more than one thing,\n    ; this can't work.\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            ; If the caller has flow? true, then justification is\n            ; meaningless\n            justify? (if (:flow? (caller options)) nil justify?)\n            ; If we are justifying merge in a full options map,\n            ; which can contain anything!  Don't validate it since\n            ; it was already in the options map to start with.\n            [justify-options _] stuff\n            ; Some callers do not have lhs-narrow defined\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ; There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a\n            ;    narrower width.  Only helps if the lhs contains some\n            ;    collections. Also this is only done if the lhs-narrow\n            ;    factor is more than 1.01.\n            ;\n            ; Each type of justification requires a different narrow-width.\n            ;\n            ; We will do both and compare them if they work.  They can fail\n            ; to work in two ways:\n            ;\n            ;  1. They can fail in fzprint-justify-width, because a good\n            ;     justify-width can't be found.\n            ;  2. They can fail in fzprint-two-up-pass, because the rhs had\n            ;     to flow, which will fail the justification.\n            ;\n            ; If only one of them works, we will use that.\n            ;\n            ; Do the fzprint-justify-width for any lhs-narrow\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            ; Do the fzprint-justify-width without lhs-narrow\n            ; If we are justifying, give that a try\n            result-narrow (when justify-narrow-width\n                            ;\n                            ; Pass 1: Justification, using a narrowed lhs\n                            ;         width, if any.\n                            ;\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))"
    (zprint-str zc3 {:parse-string? true}))

  ;;
  ;; Test for coments with no spaces after the semicolons

  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    ; If it is one-line? and force-nl? and there is more than one thing,\n    ; this can't work.\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            ; If the caller has flow? true, then justification is\n            ; meaningless\n            justify? (if (:flow? (caller options)) nil justify?)\n            ; If we are justifying merge in a full options map,\n            ; which can contain anything!  Don't validate it since\n            ; it was already in the options map to start with.\n            [justify-options _] stuff\n            ; Some callers do not have lhs-narrow defined\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ; There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a\n            ;    narrower width.  Only helps if the lhs contains some\n            ;    collections. Also this is only done if the lhs-narrow\n            ;    factor is more than 1.01.\n            ;\n            ;this is a test this only a test of how we find\n            ;\n            ; this is a test this only a test of how we find\n            ;\n            ; Each type of justification requires a different narrow-width.\n            ;\n            ; We will do both and compare them if they work.  They can fail\n            ; to work in two ways:\n            ;\n            ;  1. They can fail in fzprint-justify-width, because a good\n            ;     justify-width can't be found.\n            ;  2. They can fail in fzprint-two-up-pass, because the rhs had\n            ;     to flow, which will fail the justification.\n            ;\n            ; If only one of them works, we will use that.\n            ;\n            ; Do the fzprint-justify-width for any lhs-narrow\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            ; Do the fzprint-justify-width without lhs-narrow\n            ; If we are justifying, give that a try\n            result-narrow (when justify-narrow-width\n                            ;\n                            ; Pass 1: Justification, using a narrowed lhs\n                            ;         width, if any.\n                            ;\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))"
    (zprint-str zc9 {:parse-string? true}))

  ;;
  ;; Ensure that NOTE WELL: doesn't wrap up to the previous line, even
  ;; with :max-variance 0.

  (expect
    "(defn fzprint-list*\n  \"Print a list, which might be a list or an anon fn.  \n  Lots of work to make a list look good, as that is typically code. \n  Presently all of the callers of this are :list or :vector-fn.\"\n  [caller l-str r-str\n   {:keys [fn-map user-fn-map one-line? fn-style no-arg1? fn-force-nl quote?],\n    :as options} ind zloc]\n  (if (= (:format options) :off)\n    (fzprint-noformat l-str r-str options zloc)\n    (let [max-length (get-max-length options)\n          arg-1-coll? (not (or (zkeyword? arg-1-zloc) (zsymbol? arg-1-zloc)))\n          arg-1-indent-alt? (and arg-1-coll? fn-style)\n          fn-str (if-not arg-1-coll? (zstring arg-1-zloc))\n          ; If we don't have a fn-str, then we might have a fn-type.\n          ; NOTE WELL: a fn-style is a :arg1 or something like that.  This\n          ; is called a ::fn-type in the spec! Here, a fn-type is a keyword\n          ; of the \"type\" of the fn-str, i.e. :list, :map, :vector or\n          ; :set.\n          fn-type (when-not fn-str\n                    (cond (zlist? arg-1-zloc) :list\n                          (zmap? arg-1-zloc) :map\n                          (zvector? arg-1-zloc) :vector\n                          (zset? arg-1-zloc) :set\n                          :else nil))]\n      nil)))"
    (zprint-str zc11
                {:parse-string? true,
                 :comment {:smart-wrap {:max-variance 0}}}))

  ;;
  ;; A variation on the previous, where NOTE WELL: becomes Note well and it will
  ;; wrap up to the previous line.
  ;;

  (expect
    "(defn fzprint-list*\n  \"Print a list, which might be a list or an anon fn.  \n  Lots of work to make a list look good, as that is typically code. \n  Presently all of the callers of this are :list or :vector-fn.\"\n  [caller l-str r-str\n   {:keys [fn-map user-fn-map one-line? fn-style no-arg1? fn-force-nl quote?],\n    :as options} ind zloc]\n  (if (= (:format options) :off)\n    (fzprint-noformat l-str r-str options zloc)\n    (let [max-length (get-max-length options)\n          arg-1-coll? (not (or (zkeyword? arg-1-zloc) (zsymbol? arg-1-zloc)))\n          arg-1-indent-alt? (and arg-1-coll? fn-style)\n          fn-str (if-not arg-1-coll? (zstring arg-1-zloc))\n          ; If we don't have a fn-str, then we might have a fn-type. Note\n          ; well  a fn-style is a :arg1 or something like that.  This is\n          ; called a ::fn-type in the spec! Here, a fn-type is a keyword of\n          ; the \"type\" of the fn-str, i.e. :list, :map, :vector or :set.\n          fn-type (when-not fn-str\n                    (cond (zlist? arg-1-zloc) :list\n                          (zmap? arg-1-zloc) :map\n                          (zvector? arg-1-zloc) :vector\n                          (zset? arg-1-zloc) :set\n                          :else nil))]\n      nil)))"
    (zprint-str zc11a {:parse-string? true}))

  ;;
  ;; Will smart-wrap with :max-variance of 4, but not 5
  ;;

  (expect
    "(defn line-lengths\n  [options ind style-vec]\n  (let [length-vec (first ; this final accumulate-ll is to terminate the\n                          ; last line, the one in progress\n                     (let [count-comment? (:count? (:comment options))\n                           [_ _ just-eol? just-comment? :as result]\n                             (reduce (partial generate-ll count-comment?)\n                               [[] (if (coll? ind) (first ind) ind) nil nil]\n                               style-vec)]\n                       (if (and just-eol? (not just-comment?))\n                         result\n                         (accumulate-ll count-comment?\n                                        (assoc result 2 nil)\n                                        \"\"\n                                        nil\n                                        true))))\n        ; Unspecified seq, might be a fn, might not. If (first zloc) is a\n        ; seq, we won't have an arg-1-indent.  In that case, just flow it\n        ; out with remaining seq.  Since we already know that it won't fit\n        ; on one line.  If it might be a fn, try hanging and flow and do\n        ; what we like better.  Note that default-indent might be 1 here,\n        ; which means that we are pretty sure that the (zfirst zloc) isn't\n        ; a function and we aren't doing code.\n        ;\n       ]\n    (dbg-pr options\n            \"line-lengths: style-vec:\" style-vec\n            \"ind:\" ind\n            \"length-vec:\" length-vec)\n    length-vec))"
    (zprint-str zc17
                {:parse-string? true,
                 :comment {:smart-wrap {:max-variance 4}}}))

  (expect
    "(defn line-lengths\n  [options ind style-vec]\n  (let [length-vec (first ; this final accumulate-ll is to terminate the\n                          ; last line, the one in progress\n                     (let [count-comment? (:count? (:comment options))\n                           [_ _ just-eol? just-comment? :as result]\n                             (reduce (partial generate-ll count-comment?)\n                               [[] (if (coll? ind) (first ind) ind) nil nil]\n                               style-vec)]\n                       (if (and just-eol? (not just-comment?))\n                         result\n                         (accumulate-ll count-comment?\n                                        (assoc result 2 nil)\n                                        \"\"\n                                        nil\n                                        true))))\n        ; Unspecified seq, might be a fn, might not.\n        ; If (first zloc) is a seq, we won't have an\n        ; arg-1-indent.  In that case, just flow it\n        ; out with remaining seq.  Since we already\n        ; know that it won't fit on one line.  If it\n        ; might be a fn, try hanging and flow and do\n        ; what we like better.  Note that default-indent\n        ; might be 1 here, which means that we are pretty\n        ; sure that the (zfirst zloc) isn't a function\n        ; and we aren't doing code.\n        ;\n       ]\n    (dbg-pr options\n            \"line-lengths: style-vec:\" style-vec\n            \"ind:\" ind\n            \"length-vec:\" length-vec)\n    length-vec))"
    (zprint-str zc17
                {:parse-string? true,
                 :comment {:smart-wrap {:max-variance 5}}}))

  ;;
  ;; Shouldn't wrap by default
  ;;

  (expect
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            ; This is necessary because f can be a symbol that\n            ; resolve will have a problem with.  The obvious ones\n            ; were (ns-name <some-namespace>), but there are almost\n            ; certainly others.\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f)\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))"
    (zprint-str zc21 {:parse-string? true}))

  ;;
  ;; If we decrease the :max-variance to 0, it should wrap
  ;;

  (expect
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            ; This is necessary because f can be a symbol that resolve will\n            ; have a problem with.  The obvious ones were (ns-name\n            ; <some-namespace>), but there are almost certainly others.\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f)\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))"
    (zprint-str zc21
                {:parse-string? true,
                 :comment {:smart-wrap {:max-variance 0}}}))

  ;;
  ;; Wraps by default.  :border 3 leaves the if, :border 4 wraps it
  ;;

  (expect
    "(defn stuff\n  [a b c]\n  (this is\n        a\n        (test this\n              is\n              only\n              a\n              test ; this is a very long inline comment so that we can see if\n                   ; it wrap\n        )))"
    (zprint-str zc5 {:parse-string? true, :comment {:smart-wrap {:border 3}}}))

  (expect
    "(defn stuff\n  [a b c]\n  (this is\n        a\n        (test this\n              is\n              only\n              a\n              test ; this is a very long inline comment so that we can see\n                   ; if it wrap\n        )))"
    (zprint-str zc5 {:parse-string? true, :comment {:smart-wrap {:border 4}}}))

  ;;
  ;; What happens if there is a word that just doesn't fit at all.
  ;;
  ;; All three of these should end up the same, though different inputs
  ;;

  (expect
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this\n                                                                  ; onewordthatistoolongfortheline\n                                                                  ; a second\n                                                                  ; word and a\n                                                                  ; third too\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))"
    (zprint-str zc24 {:parse-string? true}))


  (expect
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this\n                                                                  ; onewordthatistoolongfortheline\n                                                                  ; a second\n                                                                  ; word and a\n                                                                  ; third too\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))"
    (zprint-str zc25 {:parse-string? true}))

  (expect
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this\n                                                                  ; onewordthatistoolongfortheline\n                                                                  ; a second\n                                                                  ; word and a\n                                                                  ; third too\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))"
    (zprint-str zc26 {:parse-string? true}))

  ;;
  ;; What if the big word is the last thing, and check whether the border
  ;; calculation is stable for internal lines as well as the last line
  ;;

  (expect
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this\n                                                                  ; onewordthatistoolongfortheline\n                                                                  ; a second\n                                                                  ; word and a\n                                                                  ; third too\n                                                                  ; withafinalwordthatistoolong\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))"
    (zprint-str zc27 {:parse-string? true}))

  ;;
  ;; What happens if the border is 0 with things that don't fit
  ;;

  (expect
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this\n                                                                  ; onewordthatistoolongfortheline\n                                                                  ; a second\n                                                                  ; wor and a\n                                                                  ; third too\n                                                                  ; withafinalwordthatistoolong\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))"
    (zprint-str zc28 {:parse-string? true}))

  (expect
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this\n                                                                  ; onewordthatistoolongfortheline\n                                                                  ; a second wor\n                                                                  ; and a third\n                                                                  ; too\n                                                                  ; withafinalwordthatistoolong\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))"
    (zprint-str zc28 {:parse-string? true, :comment {:smart-wrap {:border 0}}}))

  ;;
  ;; Oddly wor -> Wor, even though it ends up on a line by itself
  ;;

  (expect
    "(defn showfn?\n  \"Show this thing as a function?\"\n  [{:keys [fn-map color?], :as options} f]\n  (when (and color? (not (string? f)))\n    (let [f-str (str f)\n          fn-map (:fn-map options)]\n      (or (fn-map f-str)\n          (re-find #\"clojure\" f-str)\n          (if (symbol? f)\n            (try (or (re-find #\"clojure\"\n                              (str (:ns (meta #?(:clj (resolve f) ; this\n                                                                  ; onewordthatistoolongfortheline\n                                                                  ; a second.\n                                                                  ; Wor and a\n                                                                  ; third too\n                                                                  ; withafinalwordthatistoolong\n                                                 :cljs f)))))\n                     (fn-map (name f)))\n                 (catch #?(:clj Exception\n                           :cljs :default)\n                   e\n                   nil)))))))"
    (zprint-str zc29 {:parse-string? true}))

  ;;
  ;; Different :max-variance to see what does and does not smart-wrap
  ;;

  (expect
    "(defn balance-two-comments\n  \"Take the index into the style-vec for two comments, and balance\n  the words in them. Note that usable-space is start-col based.\n  Returns a new style-vec in [new-style-vec changed?].\"\n  [start-col-vec style-vec semi-count space-count usable-space upper-idx\n   lower-idx comment-group]\n  (let [[us ucolor uwhat :as upper-element] (nth style-vec upper-idx)\n        [ls lcolor lwhat :as lower-element] (nth style-vec lower-idx)\n        ; All of the space measurement up to this point includes the\n        ; semis and spaces on the front of every line.\n        upper-space (count us)\n        lower-space (count ls)\n        front-matter (+ semi-count space-count)\n        ; Get upper and lower strings w/out semis or spaces\n        us-text (subs us front-matter)\n        ls-text (subs ls front-matter)]\n    #_(println \"balance-two-comments: usable-space:\" usable-space\n               \"upper-idx:\" upper-idx\n               \"lower-idx:\" lower-idx\n               \"\\nus:\" (pr-str us)\n               \"\\nls:\" (pr-str ls))\n    (cond\n      (> upper-space usable-space)\n        ; Move from upper to lower if we can. It might be that there is one\n        ; thing on the upper that simply doesn't fit.\n        (let [[new-us new-start-ls] (split-str-at-space us-text usable-space)]\n          #_(println \"...upper->lower us:\" (pr-str us)\n                     \"\\n   ls:\" (pr-str ls)\n                     \"\\n   new-us:\" (pr-str new-us)\n                     \"\\n   new-start-ls:\" (pr-str new-start-ls))\n          (if (not (empty? new-start-ls))\n            (let [full-us (text-to-comment semi-count space-count new-us)]\n              (let [[separator new-ls-text] (figure-separator new-start-ls\n                                                              ls-text)\n                    full-ls (text-to-comment\n                              semi-count\n                              space-count\n                              (str new-start-ls separator new-ls-text))]\n                #_(println \".2.new-ls:\" (pr-str full-ls))\n                [(-> style-vec\n                     (insert-str-into-style-vec full-us upper-idx)\n                     (insert-str-into-style-vec full-ls lower-idx)) true]))\n            [style-vec nil]))\n      (and (do #_(println \"...(< upper-space usable-space)\" (< upper-space\n                                                               usable-space)\n                          \"lower-space:\" lower-space\n                          \"\\n   ls:\" (pr-str ls))\n               (< upper-space usable-space))\n           ; If the lower is shorter than the upper, and the lower\n           ; is the last line in the comment-group,\n           ; and the lower won't entirely fit onto the upper (and\n           ; thus allow us to remove a comment line), then don't\n           ; bother changing these lines\n           (do #_(println\n                   \"...(< lower-space upper-space)\" (< lower-space upper-space)\n                   \"(- usable-space upper-space)\" (- usable-space upper-space)\n                   \"(+ semi-count space-count)\" (+ semi-count space-count)\n                   \"(- lower-space (+ semi-count space-count))\"\n                     (- lower-space (+ semi-count space-count)))\n               true)\n           (not (and (< lower-space upper-space)\n                     (= (count comment-group) 2)\n                     (neg? (- (- usable-space upper-space)\n                              ; Include space between them\n                              (inc (- lower-space\n                                      (+ semi-count space-count))))))))\n        ; Move from lower to upper if possible. We need something from the\n        ; lower string that is less than the available space between the\n        ; end of the upper string and the end of the usable space. Note\n        ; that move-ls-to-us handles variable sized separators.\n        (let [available-space (- usable-space upper-space)\n              ; If new-ls is non-nil, that means that things changed.\n              ; However, new-ls might still be empty, indicating that\n              ; everything moved to the new-us!\n              [new-us new-ls] (move-ls-to-us us-text ls-text available-space)]\n          #_(println \"...move from lower to upper \\n   new-us:\" (pr-str new-us)\n                     \"\\n   new-ls:\" (pr-str new-ls))\n          ; If new-ls is non-nil, it might still be empty!\n          (if new-ls\n            (let [full-us (text-to-comment semi-count space-count new-us)]\n              (if (empty? new-ls)\n                [(-> style-vec\n                     (insert-str-into-style-vec full-us upper-idx)\n                     (delete-style-vec-element lower-idx)) true]\n                (let [full-ls (text-to-comment semi-count space-count new-ls)]\n                  [(-> style-vec\n                       (insert-str-into-style-vec full-us upper-idx)\n                       (insert-str-into-style-vec full-ls lower-idx)) true])))\n            ; We didn't make any changes, leave things as they are.\n            (do #_(println \"...no changes:\") [style-vec nil])))\n      :else [style-vec nil])))"
    (zprint-str zc31
                {:parse-string? true,
                 :comment {:smart-wrap {:max-variance 100}}}))

  (expect
    "(defn balance-two-comments\n  \"Take the index into the style-vec for two comments, and balance\n  the words in them. Note that usable-space is start-col based.\n  Returns a new style-vec in [new-style-vec changed?].\"\n  [start-col-vec style-vec semi-count space-count usable-space upper-idx\n   lower-idx comment-group]\n  (let [[us ucolor uwhat :as upper-element] (nth style-vec upper-idx)\n        [ls lcolor lwhat :as lower-element] (nth style-vec lower-idx)\n        ; All of the space measurement up to this point includes the\n        ; semis and spaces on the front of every line.\n        upper-space (count us)\n        lower-space (count ls)\n        front-matter (+ semi-count space-count)\n        ; Get upper and lower strings w/out semis or spaces\n        us-text (subs us front-matter)\n        ls-text (subs ls front-matter)]\n    #_(println \"balance-two-comments: usable-space:\" usable-space\n               \"upper-idx:\" upper-idx\n               \"lower-idx:\" lower-idx\n               \"\\nus:\" (pr-str us)\n               \"\\nls:\" (pr-str ls))\n    (cond\n      (> upper-space usable-space)\n        ; Move from upper to lower if we can. It might be that there is one\n        ; thing on the upper that simply doesn't fit.\n        (let [[new-us new-start-ls] (split-str-at-space us-text usable-space)]\n          #_(println \"...upper->lower us:\" (pr-str us)\n                     \"\\n   ls:\" (pr-str ls)\n                     \"\\n   new-us:\" (pr-str new-us)\n                     \"\\n   new-start-ls:\" (pr-str new-start-ls))\n          (if (not (empty? new-start-ls))\n            (let [full-us (text-to-comment semi-count space-count new-us)]\n              (let [[separator new-ls-text] (figure-separator new-start-ls\n                                                              ls-text)\n                    full-ls (text-to-comment\n                              semi-count\n                              space-count\n                              (str new-start-ls separator new-ls-text))]\n                #_(println \".2.new-ls:\" (pr-str full-ls))\n                [(-> style-vec\n                     (insert-str-into-style-vec full-us upper-idx)\n                     (insert-str-into-style-vec full-ls lower-idx)) true]))\n            [style-vec nil]))\n      (and (do #_(println \"...(< upper-space usable-space)\" (< upper-space\n                                                               usable-space)\n                          \"lower-space:\" lower-space\n                          \"\\n   ls:\" (pr-str ls))\n               (< upper-space usable-space))\n           ; If the lower is shorter than the upper, and the lower is the\n           ; last line in the comment-group, and the lower won't entirely\n           ; fit onto the upper (and thus allow us to remove a comment\n           ; line), then don't bother changing these lines\n           (do #_(println\n                   \"...(< lower-space upper-space)\" (< lower-space upper-space)\n                   \"(- usable-space upper-space)\" (- usable-space upper-space)\n                   \"(+ semi-count space-count)\" (+ semi-count space-count)\n                   \"(- lower-space (+ semi-count space-count))\"\n                     (- lower-space (+ semi-count space-count)))\n               true)\n           (not (and (< lower-space upper-space)\n                     (= (count comment-group) 2)\n                     (neg? (- (- usable-space upper-space)\n                              ; Include space between them\n                              (inc (- lower-space\n                                      (+ semi-count space-count))))))))\n        ; Move from lower to upper if possible. We need something from the\n        ; lower string that is less than the available space between the\n        ; end of the upper string and the end of the usable space. Note\n        ; that move-ls-to-us handles variable sized separators.\n        (let [available-space (- usable-space upper-space)\n              ; If new-ls is non-nil, that means that things changed.\n              ; However, new-ls might still be empty, indicating that\n              ; everything moved to the new-us!\n              [new-us new-ls] (move-ls-to-us us-text ls-text available-space)]\n          #_(println \"...move from lower to upper \\n   new-us:\" (pr-str new-us)\n                     \"\\n   new-ls:\" (pr-str new-ls))\n          ; If new-ls is non-nil, it might still be empty!\n          (if new-ls\n            (let [full-us (text-to-comment semi-count space-count new-us)]\n              (if (empty? new-ls)\n                [(-> style-vec\n                     (insert-str-into-style-vec full-us upper-idx)\n                     (delete-style-vec-element lower-idx)) true]\n                (let [full-ls (text-to-comment semi-count space-count new-ls)]\n                  [(-> style-vec\n                       (insert-str-into-style-vec full-us upper-idx)\n                       (insert-str-into-style-vec full-ls lower-idx)) true])))\n            ; We didn't make any changes, leave things as they are.\n            (do #_(println \"...no changes:\") [style-vec nil])))\n      :else [style-vec nil])))"
    (zprint-str zc31 {:parse-string? true}))

  ;;
  ;; Both are different on imput, produce the same output
  ;;

  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a\n            ;    narrower width.  Only helps if the lhs contains some\n            ;    collections. Also this is only done if the lhs-narrow\n            ;    factor is more than 1.01.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))"
    (zprint-str zc33 {:parse-string? true}))

  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a\n            ;    narrower width.  Only helps if the lhs contains some\n            ;    collections. Also this is only done if the lhs-narrow\n            ;    factor is more than 1.01.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))"
    (zprint-str zc34 {:parse-string? true}))

  ;;
  ;; zc35 should have "nar" at the end of the Narrowed justification line, and
  ;; zc36 should not have "narr" at the end of a line.
  ;;

  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a nar\n            ;    width.  Only helps if the lhs contains some collections.\n            ;    Also this is only done if the lhs-narrow factor is more\n            ;    than 1.01.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))"
    (zprint-str zc35 {:parse-string? true}))

  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a\n            ;    narr width.  Only helps if the lhs contains some\n            ;    collections. Also this is only done if the lhs-narrow\n            ;    factor is more than 1.01.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))"
    (zprint-str zc36 {:parse-string? true}))

  ;;
  ;; zc37 should have "*" and "-" handled correctly, only if :max-variance = 0,
  ;; since they are not done automatically because they are only two line things.
  ;;



  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a\n            ;    narr width.  Only helps if the lhs contains some\n            ;    collections.\n            ;    Note:\n            ;    Also this is only done if the lhs-narrow factor is more\n            ;    than 1.01.\n            ;\n            ;;   *   This is a test,\n            ;;       this is only a test.\n            ;;  -       This is also a test\n            ;;          along with this too.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))"
    (zprint-str zc37 {:parse-string? true}))


  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ;  There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a\n            ;    narr width.  Only helps if the lhs contains some\n            ;    collections.\n            ;    Note:\n            ;    Also this is only done if the lhs-narrow factor is more\n            ;    than 1.01.\n            ;\n            ;;   *   This is a test, this is only a test.\n            ;;  -       This is also a test along with this too.\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            result-narrow (when justify-narrow-width\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))"
    (zprint-str zc37
                {:parse-string? true,
                 :comment {:smart-wrap {:max-variance 0}}}))

  ;;
  ;; zc39 will smart wrap at :max-variance of 200, which is good because it is
  ;; fixing up something that zprint messed up in the past.
  ;;

  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            zloc-seq-right-first (get-zloc-seq-right first-data)]\n        (concat-no-nil l-str-vec\n                       pre-arg-1-style-vec\n                       (fzprint* loptions (inc ind) arg-1-zloc)\n                       (prepend-nl options\n                                   (+ indent ind)\n                                   ; I think fzprint-pairs will sort out\n                                   ; which is and isn't the rightmost\n                                   ; because of two-up\n                                   (fzprint-extend options\n                                                   (+ indent ind)\n                                                   zloc-seq-right-first))\n                       r-str-vec)))))"
    (zprint-str zc39
                {:parse-string? true,
                 :comment {:smart-wrap {:max-variance 200}}}))

  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            zloc-seq-right-first (get-zloc-seq-right first-data)]\n        (concat-no-nil l-str-vec\n                       pre-arg-1-style-vec\n                       (fzprint* loptions (inc ind) arg-1-zloc)\n                       (prepend-nl options\n                                   (+ indent ind)\n                                   ; I think fzprint-pairs will sort out\n                                   ; which\n                                   ; is and isn't the rightmost because of\n                                   ; two-up\n                                   (fzprint-extend options\n                                                   (+ indent ind)\n                                                   zloc-seq-right-first))\n                       r-str-vec)))))"
    (zprint-str zc39
                {:parse-string? true,
                 :comment {:smart-wrap {:max-variance 300}}}))

  ;;
  ;; Ensure that when moving code around, you don't get capital letters after
  ;; a ? (which looks like sentence terminator),
  ;;

  (expect
    "(defn interpose-either-nl-hf\n  \"Do very specialized interpose, but different seps depending on pred-fn\n  return and nl-separator? and nl-separator-all?. This assumes that \n  sep-* does one line, and sep-*-nl does two lines. coll is\n  a series of [[:flow [['\\n  ' :none :newline 2]]] \n               [:flow [['ZprintType' :black :element] ...]]] fragments from\n  fzprint-map-two-up.\"\n  [sep-comma sep-comma-nl sep sep-nl\n   {:keys [nl-separator? nl-separator-all?], :as suboptions} ;nl-separator?\n   comma? coll]\n  #_(prn \"ienf: sep:\" sep \"comma?\" comma? \"coll:\" coll)\n  (loop [coll coll\n         out (transient [])\n         previous-needs-comma? nil\n         add-nl? nil\n         first? true\n         newline-count 0]\n    (if (empty? coll)\n      (apply concat-no-nil\n        (persistent!\n          ; Handle final newlines, if any\n          (if (zero? newline-count)\n            out\n            (conj-it! out (repeat-element-nl newline-count (first sep))))))\n      (let [[hangflow style-vec] (first coll)\n            [_ _ what] (first style-vec)]\n        #_(prn \"====>>>>>>>> interpose-either-nl-hf: style-vec:\" style-vec)\n        (cond\n          (= what :newline)\n            ; We have one or more newlines.  We are going to keep\n            ; track of what we've seen and will actually output things\n            ; later, when we know what we actually have.\n            ; For now, just increase the count and don't do anything\n            ; else.  If we have anything in addition to newlines, we have a\n            ; problem because we will lose them as the style-vec\n            ; goes away, which is why count-newline-types will throw\n            ; an exception if it encounters this.\n            (do #_(prn \"interpose-either-nl-hf: hangflow: \" hangflow)\n                (recur (next coll)\n                       out\n                       previous-needs-comma?\n                       add-nl?\n                       first?\n                       (+ newline-count (count-newline-types style-vec))))\n          :else\n            ; We have a normal style-vec that we will process.  This one\n            ; may have plenty of newlines, but there isn't one first. But\n            ; we might have seen plenty of newlines before this -- or not.\n            (let [[interpose-style-vec interpose-count]\n                    (if previous-needs-comma?\n                      (if add-nl? [sep-comma-nl 2] [sep-comma 1])\n                      (if add-nl? [sep-nl 2] [sep 1]))\n                  ; if first? we assume that we get one newline from caller\n                  interpose-count (if first? 1 interpose-count)\n                  addtl-nl-needed (max (- newline-count interpose-count) 0)]\n              ; Here is where we need to figure out if two newlines are\n              ; coming out in order, and ensure that the first ones don't\n              ; have any spaces after them.\n              #_(prn \"ienf: interpose-style-vec:\" interpose-style-vec)\n              (recur\n                (next coll)\n                (if first?\n                  (if (zero? addtl-nl-needed)\n                    (conj! out style-vec)\n                    (conj-it! out\n                              (repeat-element-nl addtl-nl-needed (first sep))\n                              style-vec))\n                  (if (zero? addtl-nl-needed)\n                    (conj-it! out interpose-style-vec style-vec)\n                    (conj-it! out\n                              (trimr-blanks-style-vec interpose-style-vec)\n                              (repeat-element-nl addtl-nl-needed (first sep))\n                              style-vec)))\n                (and comma?\n                     ; We got rid of newlines above\n                     (not= what :comment)\n                     (not= what :comment-inline)\n                     ; Is there a non comment or non newline/indent element\n                     ; left in coll, or is this the last one? This returns\n                     ; the [hangflow style-vec], but we are not using the\n                     ; data, just the existence of the thing here\n                     ; Fix for Issue #137.\n                     (next-non-comment-nl (next coll)))\n                ; should we put an extra new-line before the next element?\n                ; Two styles here:\n                ;  o  always put one if the previous pair contained a\n                ;  new-line\n                ;     which could be (but is not) the default\n                ;     To do this you would do:\n                ;       (and nl-separator? (not (single-line?\n                ;       style-vec)))\n                ;  o  put one only if the previous right hand part of\n                ;  the\n                ;     pair did a flow (which is the current default)\n                ;     To do this, you look for whether or not the return\n                ;     from fzprint-map-two-up said it was a flow\n                (or (and nl-separator? (= hangflow :flow)) nl-separator-all?)\n                nil ;first?\n                0 ;newline-count\n              )))))))"
    #_"(defn interpose-either-nl-hf\n  \"Do very specialized interpose, but different seps depending on pred-fn\n  return and nl-separator? and nl-separator-all?. This assumes that \n  sep-* does one line, and sep-*-nl does two lines. coll is\n  a series of [[:flow [['\\n  ' :none :newline 2]]] \n               [:flow [['ZprintType' :black :element] ...]]] fragments from\n  fzprint-map-two-up.\"\n  [sep-comma sep-comma-nl sep sep-nl\n   {:keys [nl-separator? nl-separator-all?], :as suboptions} ;nl-separator?\n   comma? coll]\n  #_(prn \"ienf: sep:\" sep \"comma?\" comma? \"coll:\" coll)\n  (loop [coll coll\n         out (transient [])\n         previous-needs-comma? nil\n         add-nl? nil\n         first? true\n         newline-count 0]\n    (if (empty? coll)\n      (apply concat-no-nil\n        (persistent!\n          ; Handle final newlines, if any\n          (if (zero? newline-count)\n            out\n            (conj-it! out (repeat-element-nl newline-count (first sep))))))\n      (let [[hangflow style-vec] (first coll)\n            [_ _ what] (first style-vec)]\n        #_(prn \"====>>>>>>>> interpose-either-nl-hf: style-vec:\" style-vec)\n        (cond\n          (= what :newline)\n            ; We have one or more newlines.  We are going to keep\n            ; track of what we've seen and will actually output things\n            ; later, when we know what we actually have.\n            ; For now, just increase the count and don't do anything\n            ; else.  If we have anything in addition to newlines, we have a\n            ; problem because we will lose them as the style-vec\n            ; goes away, which is why count-newline-types will throw\n            ; an exception if it encounters this.\n            (do #_(prn \"interpose-either-nl-hf: hangflow: \" hangflow)\n                (recur (next coll)\n                       out\n                       previous-needs-comma?\n                       add-nl?\n                       first?\n                       (+ newline-count (count-newline-types style-vec))))\n          :else\n            ; We have a normal style-vec that we will process.  This one\n            ; may have plenty of newlines, but there isn't one first. But\n            ; we might have seen plenty of newlines before this -- or not.\n            (let [[interpose-style-vec interpose-count]\n                    (if previous-needs-comma?\n                      (if add-nl? [sep-comma-nl 2] [sep-comma 1])\n                      (if add-nl? [sep-nl 2] [sep 1]))\n                  ; if first? we assume that we get one newline from caller\n                  interpose-count (if first? 1 interpose-count)\n                  addtl-nl-needed (max (- newline-count interpose-count) 0)]\n              ; Here is where we need to figure out if two newlines are\n              ; coming out in order, and ensure that the first ones don't\n              ; have any spaces after them.\n              #_(prn \"ienf: interpose-style-vec:\" interpose-style-vec)\n              (recur\n                (next coll)\n                (if first?\n                  (if (zero? addtl-nl-needed)\n                    (conj! out style-vec)\n                    (conj-it! out\n                              (repeat-element-nl addtl-nl-needed (first sep))\n                              style-vec))\n                  (if (zero? addtl-nl-needed)\n                    (conj-it! out interpose-style-vec style-vec)\n                    (conj-it! out\n                              (trimr-blanks-style-vec interpose-style-vec)\n                              (repeat-element-nl addtl-nl-needed (first sep))\n                              style-vec)))\n                (and comma?\n                     ; We got rid of newlines above\n                     (not= what :comment)\n                     (not= what :comment-inline)\n                     ; Is there a non comment or non newline/indent element\n                     ; left in coll, or is this the last one? This returns\n                     ; the [hangflow style-vec], but we are not using the\n                     ; data, just the existence of the thing here\n                     ; Fix for Issue #137.\n                     (next-non-comment-nl (next coll)))\n                ; should we put an extra new-line before the next element?\n                ; Two styles here:\n                ;  o  always put one if the previous pair contained a\n                ;  new-line\n                ;     which could be (but is not) the default\n                ;     To do this you would do:\n                ;       (and nl-separator? (not (single-line? style-vec)))\n                ;  o  put one only if the previous right hand part of\n                ;  the\n                ;     pair did a flow (which is the current default) To do\n                ;     this, you look for whether or not the return\n                ;     from fzprint-map-two-up said it was a flow\n                (or (and nl-separator? (= hangflow :flow)) nl-separator-all?)\n                nil ;first?\n                0 ;newline-count\n              )))))))"
    (zprint-str zc40 {:parse-string? true}))

  ;;
  ;; See if consecutive and aligned both still work
  ;;

  (expect
    "(defn inline-test\n  [a b c]\n  (let [us test]\n    (some inline   ; comments\n          comments ; some that are aligned\n          to\n          see ; a single line\n          if\n          aligned ; and some\n          and     ; that are\n          consecutive ; not aligned\n          work)) ; at all\n)"
    (zprint-str zc41
                {:parse-string? true,
                 :comment {:inline-align-style :aligned, :smart-wrap? false}}))


  (expect
    "(defn inline-test\n  [a b c]\n  (let [us test]\n    (some inline   ; comments\n          comments ; some that are aligned\n          to\n          see ; a single line\n          if\n          aligned     ; and some\n          and         ; that are\n          consecutive ; not aligned\n          work))      ; at all\n)"
    (zprint-str zc41
                {:parse-string? true,
                 :comment {:inline-align-style :consecutive,
                           :smart-wrap? false}}))

  ;;
  ;; what happens if the last line is really big?
  ;;

  (expect
    "(defn fzprint-map-two-up\n  [caller options ind commas? coll]\n  (let [len (count coll)]\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)]\n        (concat-no-nil l-str-vec\n                       (prepend-nl-and-move-it-right options\n                                                     (+ indent ind)\n                                                     ; I think that\n                                                     ; fzprint-extend will\n                                                     ; sort out which is and\n                                                     ; isn't the rightmost\n                                                     ; because of two-up and\n                                                     ; even more stuff so\n                                                     ; that it can't fit at\n                                                     ; all\n                                                     (fzprint-extend options))\n                       r-str-vec)))))"
    (zprint-str zc44 {:parse-string? true}))

  ;;
  ;; Comments in vectors and sets
  ;;

  (def smwa
    "{:comment {:count? false,\n             :wrap? true,\n             :inline? true,\n             :inline-align-style :aligned,\n             :border 0,\n             :smart-wrap? true,\n             :smart-wrap {:border 5,\n                          :end+start-cg [; Line starts with single letter,\n                                         ; but\n                                         ; not a or I\n                                         #\"^(;+)(\\s*[b-zA-HJ-Z]\\s+)\"\n                                         ; Line starts with a * or -\n                                         #\"^(;+)(\\s*(?:\\*|\\-)\\s+)\"\n                                         ; Line starts with single letter\n                                         ; followed by .\n                                         #\"^(;+)(\\s*\\w\\.\\s+)\"\n                                         ; Line starts with one or two\n                                         ; digit\n                                         ; number\n                                         ; followed by period.\n                                         #\"^(;+)(\\s*[0-9]{1,2}\\.?\\s+)\"\n                                         ; Line starts with two upper case\n                                         ; chars\n                                         #\"^(;+)(\\s*)[A-Z][A-Z]\"],\n                          :end+skip-cg [; Blank line\n                                        #\"^;+\\s*$\"\n                                        ; Line where left paren is first\n                                        ; and\n                                        ; right paren last\n                                        ; character in line.\n                                        #\"^;+\\s*\\(.*\\)$\"\n                                        ; Line containing only capitalized\n                                        ; word\n                                        ; followed by colon\n                                        #\"^;+\\s*[A-Z]\\w+\\:$\"],\n                          :max-variance 30,\n                          :space-factor 3,\n                          :last-max 5}}}\n\n")

  (expect
    "{:comment {:border 0,\n           :count? false,\n           :inline-align-style :aligned,\n           :inline? true,\n           :smart-wrap {:border 5,\n                        :end+skip-cg [; Blank line\n                                      #\"^;+\\s*$\"\n                                      ; Line where left paren is first\n                                      ; and\n                                      ; right paren last\n                                      ; character in line.\n                                      #\"^;+\\s*\\(.*\\)$\"\n                                      ; Line containing only capitalized\n                                      ; word\n                                      ; followed by colon\n                                      #\"^;+\\s*[A-Z]\\w+\\:$\"],\n                        :end+start-cg [; Line starts with single letter,\n                                       ; but\n                                       ; not a or I\n                                       #\"^(;+)(\\s*[b-zA-HJ-Z]\\s+)\"\n                                       ; Line starts with a * or -\n                                       #\"^(;+)(\\s*(?:\\*|\\-)\\s+)\"\n                                       ; Line starts with single letter\n                                       ; followed by .\n                                       #\"^(;+)(\\s*\\w\\.\\s+)\"\n                                       ; Line starts with one or two\n                                       ; digit\n                                       ; number\n                                       ; followed by period.\n                                       #\"^(;+)(\\s*[0-9]{1,2}\\.?\\s+)\"\n                                       ; Line starts with two upper case\n                                       ; chars\n                                       #\"^(;+)(\\s*)[A-Z][A-Z]\"],\n                        :last-max 5,\n                        :max-variance 30,\n                        :space-factor 3},\n           :smart-wrap? true,\n           :wrap? true}}"
    (zprint-str smwa
                {:parse-string? true,
                 :comment {:smart-wrap? false},
                 :set {:indent-only? false, :respect-nl? false}}))

  (expect
    "{:comment {:border 0,\n           :count? false,\n           :inline-align-style :aligned,\n           :inline? true,\n           :smart-wrap {:border 5,\n                        :end+skip-cg [; Blank line\n                                      #\"^;+\\s*$\"\n                                      ; Line where left paren is first and\n                                      ; right paren last character in\n                                      ; line.\n                                      #\"^;+\\s*\\(.*\\)$\"\n                                      ; Line containing only capitalized\n                                      ; word followed by colon\n                                      #\"^;+\\s*[A-Z]\\w+\\:$\"],\n                        :end+start-cg [; Line starts with single letter,\n                                       ; but not a or I\n                                       #\"^(;+)(\\s*[b-zA-HJ-Z]\\s+)\"\n                                       ; Line starts with a * or -\n                                       #\"^(;+)(\\s*(?:\\*|\\-)\\s+)\"\n                                       ; Line starts with single letter\n                                       ; followed by .\n                                       #\"^(;+)(\\s*\\w\\.\\s+)\"\n                                       ; Line starts with one or two digit\n                                       ; number followed by period.\n                                       #\"^(;+)(\\s*[0-9]{1,2}\\.?\\s+)\"\n                                       ; Line starts with two upper case\n                                       ; chars\n                                       #\"^(;+)(\\s*)[A-Z][A-Z]\"],\n                        :last-max 5,\n                        :max-variance 30,\n                        :space-factor 3},\n           :smart-wrap? true,\n           :wrap? true}}"
    (zprint-str smwa {:parse-string? true, :comment {:smart-wrap? true}}))

  (expect
    "{:comment {:border 0,\n           :count? false,\n           :inline-align-style :aligned,\n           :inline? true,\n           :smart-wrap {:border 5,\n                        :end+skip-cg [; Blank line\n                                      #\"^;+\\s*$\"\n                                      ; Line where left paren is first and\n                                      ; right paren last character in\n                                      ; line.\n                                      #\"^;+\\s*\\(.*\\)$\"\n                                      ; Line containing only capitalized\n                                      ; word followed by colon\n                                      #\"^;+\\s*[A-Z]\\w+\\:$\"],\n                        :end+start-cg [; Line starts with single letter,\n                                       ; but not a or I\n                                       #\"^(;+)(\\s*[b-zA-HJ-Z]\\s+)\"\n                                       ; Line starts with a * or -\n                                       #\"^(;+)(\\s*(?:\\*|\\-)\\s+)\"\n                                       ; Line starts with single letter\n                                       ; followed by .\n                                       #\"^(;+)(\\s*\\w\\.\\s+)\"\n                                       ; Line starts with one or two digit\n                                       ; number followed by period.\n                                       #\"^(;+)(\\s*[0-9]{1,2}\\.?\\s+)\"\n                                       ; Line starts with two upper case\n                                       ; chars\n                                       #\"^(;+)(\\s*)[A-Z][A-Z]\"],\n                        :last-max 5,\n                        :max-variance 30,\n                        :space-factor 3},\n           :smart-wrap? true,\n           :wrap? true}}"
    (zprint-str smwa
                {:parse-string? true,
                 :comment {:smart-wrap? true},
                 :vector {:indent-only? true}}))

  (def smwc
    "{ :end+start-cg #{; Line starts with single letter,\n                                         ; but\n                                         ; not a or I\n                                         #\"^(;+)(\\s*[b-zA-HJ-Z]\\s+)\"}}\n")

  (expect
    "{:end+start-cg #{; Line starts with single letter,\n                 ; but\n                 ; not a or I\n                 #\"^(;+)(\\s*[b-zA-HJ-Z]\\s+)\"}}"
    (zprint-str smwc {:parse-string? true, :comment {:smart-wrap? false}}))

  (expect
    "{:end+start-cg #{; Line starts with single letter, but not a or I\n                 #\"^(;+)(\\s*[b-zA-HJ-Z]\\s+)\"}}"
    (zprint-str smwc {:parse-string? true, :comment {:smart-wrap? true}}))

  (expect
    "{:end+start-cg #{; Line starts with single letter, but not a or I\n                 #\"^(;+)(\\s*[b-zA-HJ-Z]\\s+)\"}}"
    (zprint-str smwc
                {:parse-string? true,
                 :comment {:smart-wrap? true},
                 :set {:indent-only? true}}))

  ;;
  ;; Issue 297 -- separate complete thoughts that end in a period as the
  ;; last thing on the line.
  ;;

  (def i297n
    "(test-comment\n  ;; so changes made within abcd-abcde-abcdefg.txt will be reflected upon\n  ;; deployment.\n  ;; I felt comfortable downloading from the abcdefghij abcde\n  )\n")
  (expect
    "(test-comment\n ;; so changes made within abcd-abcde-abcdefg.txt will be reflected upon\n ;; deployment.\n ;; I felt comfortable downloading from the abcdefghij abcde\n)"
    (zprint-str i297n {:parse-string? true, :style :minimal-smart-wrap}))

  (expect
    "(test-comment\n ;; so changes made within abcd-abcde-abcdefg.txt will be reflected upon\n ;; deployment. I felt comfortable downloading from the abcdefghij abcde\n)"
    (zprint-str i297n {:parse-string? true}))

  ;; But noticed from Issue #297 -- top level comments wrap with smart border.

  (def i297o
    "; This is a top level comment that is just a little bit longer than 80 c h a r a c t e r s\n")
  (expect
    "; This is a top level comment that is just a little bit longer than 80 c h a r a\n; c t e r s"
    (zprint-str i297o {:parse-string? true}))

  (expect
    "; This is a top level comment that is just a little bit longer than 80 c h a r a\n; c t e r s\n"
    (zprint-file-str i297o "x" {}))

  ;; A minimal smart wrap test

  (expect
    "(defn fzprint-map-two-up\n  [caller\n   {{:keys [justify? force-nl? multi-lhs-hang? justify]} caller,\n    :keys [width rightcnt one-line? parallel?],\n    :as options} ind commas? coll]\n  (let [len (count coll)]\n    ; If it is one-line? and force-nl? and there is more than one thing,\n    ; this can't work.\n    (when (not (and one-line? force-nl? (> len 1)))\n      (let [caller-options (options caller)\n            ; If the caller has flow? true, then justification is meaningless\n            justify? (if (:flow? (caller options)) nil justify?)\n            ; If we are justifying merge in a full options map,\n            ; which can contain anything!  Don't validate it since\n            ; it was already in the options map to start with.\n            [justify-options _] stuff\n            ; Some callers do not have lhs-narrow defined\n            lhs-narrow (or (:lhs-narrow justify) 1)\n            ;\n            ; There are two possibilties for justification:\n            ;  o Regular justification, with the lhs as big as it is\n            ;  o Narrowed justification, where the lhs is squeezed by a narrower\n            ;    width.  Only helps if the lhs contains some collections.\n            ;    Also this is only done if the lhs-narrow factor is more than\n            ;    1.01.\n            ;\n            ; Each type of justification requires a different narrow-width.\n            ;\n            ; We will do both and compare them if they work.  They can fail\n            ; to work in two ways:\n            ;\n            ;  1. They can fail in fzprint-justify-width, because a good\n            ;     justify-width can't be found.\n            ;  2. They can fail in fzprint-two-up-pass, because the rhs had\n            ;     to flow, which will fail the justification.\n            ;\n            ; If only one of them works, we will use that.\n            ;\n            ; Do the fzprint-justify-width for any lhs-narrow\n            use-narrow? (and (> (- lhs-narrow 1) 0.01) justify? multi-lhs-hang?)\n            narrow-width (when use-narrow?\n                           (int (+ (/ (- (:width options) ind) lhs-narrow)\n                                   ind)))\n            justify-narrow-width\n              (when (and justify? narrow-width (not one-line?))\n                (fzprint-justify-width caller coll))\n            ; Do the fzprint-justify-width without lhs-narrow\n            ; If we are justifying, give that a try\n            result-narrow (when justify-narrow-width\n                            ;\n                            ; Pass 1: Justification, using a narrowed lhs\n                            ;         width, if any.\n                            ;\n                            (fzprint-two-up-pass caller))\n            result (when justify-width)]))))"
    (zprint-str zc3 {:parse-string? true, :style :minimal-smart-wrap}))

  (def i297ka
    ";; We stash the original value of a function so we can monkey patch it and\n;; restore from tests. As the feature is temporary, we have simply made\n;; changes severly local like this so we can remove the code with the least\n;; possible chance of introducing a regression\n")

  (expect
    ";; We stash the original value of a function so we can monkey patch it and\n;; restore from tests. As the feature is temporary, we have simply made\n;; changes severly local like this so we can remove the code with the least\n;; possible chance of introducing a regression\n"
    (zprint-file-str i297ka "" {}))

  (expect
    ";; We stash the original value of a function so we can monkey patch it and\n;; restore from tests. As the feature is temporary, we have simply made\n;; changes severly local like this so we can remove the code with the\n;; least\n;; possible chance of introducing a regression\n"
    (zprint-file-str i297ka "" {:comment {:border 5}}))

  ;;
  ;; Don't mess with lines starting with ( [ { or ending with } ] )
  ;;

  (def i297f
    "(test-comment\n; {:org-id 123 :name \"Abcde\"} ->\n; [{:externalId 'external_org-id' :value \"123\"},\n;  {:externalId 'external_name' :value \\\"Sabre\\\"}]\n)\n")

  (expect
    "(test-comment\n ; {:org-id 123 :name \"Abcde\"} ->\n ; [{:externalId 'external_org-id' :value \"123\"},\n ;  {:externalId 'external_name' :value \\\"Sabre\\\"}]\n)"
    (zprint-str i297f {:parse-string? true}))




  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;
  ;; End of defexpect
  ;;
  ;; All tests MUST come before this!!!
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
)
