﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using Client.MirGraphics;
using Client.MirScenes;
using S = ServerPackets;

namespace Client.MirObjects
{
    class DecoObject : MapObject
    {
        public override ObjectType Race
        {
            get { return ObjectType.Deco; }
        }

        public override bool Blocking
        {
            get { return false; }
        }

        public ushort Image;

        public DecoObject(uint objectID)
            : base(objectID)
        {
        }

        public void Load(S.ObjectDeco info)
        {
            CurrentLocation = info.Location;
            MapLocation = info.Location;
            GameScene.Scene.MapControl.AddObject(this);
            Image = info.Image;

            BodyLibrary = Libraries.Deco;
        }
        public override void Process()
        {
            DrawLocation = new Point((CurrentLocation.X - User.Movement.X + MapControl.OffSetX) * MapControl.CellWidth, (CurrentLocation.Y - User.Movement.Y + MapControl.OffSetY) * MapControl.CellHeight);

            DrawLocation.Offset(User.OffSetMove);
        }

        public override void Draw()
        {
            BodyLibrary.Draw(Image, DrawLocation, DrawColour, true);
        }

        public override bool MouseOver(Point p)
        {
            return false;
        }

        public override void DrawBehindEffects()
        {
        }

        public override void DrawEffects()
        {
        }
    }
}
