SpelllistSettings = {
  ['Default'] = { 
    iconFile = 'icons.png',
    iconSize = {width = 32, height = 32},
    spellListWidth = 210,
    spellWindowWidth = 550,
    spellIcons = {[39] = 'Strong Haste', [131] = 'Charge', [91] = 'Poison Bomb', [22] = 'Energy Beam', [142] = 'Envenom', [48] = 'Conjure Poisoned Arrow', [49] = 'Conjure Explosive Arrow', [114] = 'Icicle', [130] = 'Holy Missile', [56] = 'Wrath of Nature', [112] = 'Ice Strike', [87] = 'Death Strike', [10] = 'Light', [24] = 'Hells Core', [75] = 'Ultimate Light', [151] = 'Strong Energy Strike', [42] = 'Food', [117] = 'Thunderstorm', [156] = 'Ultimate Ice Strike', [18] = 'Explosion', [116] = 'Stone Shower', [59] = 'Front Sweep', [11] = 'Great Light', [155] = 'Ultimate Energy Strike', [115] = 'Avalanche', [118] = 'Eternal Winter', [82] = 'Mass Healing', [139] = 'Curser', [54] = 'Paralyze', [15] = 'Fireball', [157] = 'Ultimate Terra Strike', [83] = 'Animate Dead', [9] = 'Summon Creature', [13] = 'Energy Wave', [5] = 'Ultimate Healing Rune', [88] = 'Energy Strike', [86] = 'Magic Wall', [19] = 'Fire Wave', [149] = 'Lightning', [14] = 'Chameleon', [29] = 'Cure Poison', [78] = 'Desintegrate', [105] = 'Fierce Berserk', [108] = 'Conjure Sniper Arrow', [30] = 'Destroy Field', [12] = 'Convince Creature', [4] = 'Intense Healing Rune', [31] = 'Cure Poison Rune', [152] = 'Strong Ice Strike', [21] = 'Sudden Death', [27] = 'Energy Field', [80] = 'Berserk', [55] = 'Energybomb', [28] = 'Fire Wall', [43] = 'Strong Ice Wave', [50] = 'Soulfire', [57] = 'Strong Ethereal Spear', [26] = 'Poison Field', [61] = 'Brutal Strike', [17] = 'Firebomb', [45] = 'Invisibility', [20] = 'Find Person', [146] = 'Cure Electrification', [7] = 'Light Magic Missile', [16] = 'Great Fireball', [92] = 'Enchant Staff', [148] = 'Physical Strike', [132] = 'Protector', [111] = 'Ethereal Spear', [143] = 'Holy Flash', [77] = 'Stalagmite', [33] = 'Energy Wall', [107] = 'Whirlwind Throw', [38] = 'Creature Illusion', [158] = 'Intense Wound Cleansing', [124] = 'Divine Caldera', [84] = 'Heal Friend', [8] = 'Heavy Magic Missile', [25] = 'Fire Field', [125] = 'Divine Healing', [140] = 'Electrify', [95] = 'Conjure Power Bolt', [36] = 'Salvation', [134] = 'Swift Foot', [109] = 'Conjure Piercing Bolt', [79] = 'Conjure Bolt', [141] = 'Inflict Wound', [153] = 'Strong Terra Strike', [1] = 'Light Healing', [51] = 'Conjure Arrow', [123] = 'Wound Cleansing', [129] = 'Enchant Party', [128] = 'Heal Party', [127] = 'Protect Party', [126] = 'Train Party', [23] = 'Great Energy Beam', [2] = 'Intense Healing', [133] = 'Blood Rage', [160] = 'Intense Recovery', [94] = 'Wild Growth', [89] = 'Flame Strike', [147] = 'Cure Curse', [93] = 'Challenge', [90] = 'Cancel Invisibility', [110] = 'Enchant Spear', [6] = 'Haste', [44] = 'Magic Shield', [81] = 'Levitate', [145] = 'Cure Burning', [76] = 'Magic Rope', [3] = 'Ultimate Healing', [159] = 'Recovery', [122] = 'Divine Missile', [120] = 'Terra Wave', [144] = 'Cure Bleeding', [150] = 'Strong Flame Strike', [113] = 'Terra Strike', [62] = 'Annihilation', [121] = 'Ice Wave', [135] = 'Sharpshooter', [138] = 'Ignite', [32] = 'Poison Wall', [119] = 'Rage of the Skies', [154] = 'Ultimate Flame Strike', [106] = 'Groundshaker'},
    spellOrder = {'Animate Dead', 'Annihilation', 'Avalanche', 'Berserk', 'Blood Rage', 'Brutal Strike', 'Cancel Invisibility', 'Challenge', 'Chameleon', 'Charge', 'Conjure Arrow', 'Conjure Bolt', 'Conjure Explosive Arrow', 'Conjure Piercing Bolt', 'Conjure Poisoned Arrow', 'Conjure Power Bolt', 'Conjure Sniper Arrow', 'Convince Creature', 'Creature Illusion', 'Cure Bleeding', 'Cure Burning', 'Cure Curse', 'Cure Electrification', 'Cure Poison', 'Cure Poison Rune', 'Curser', 'Death Strike', 'Desintegrate', 'Destroy Field', 'Divine Caldera', 'Divine Healing', 'Divine Missile', 'Electrify', 'Enchant Party', 'Enchant Spear', 'Enchant Staff', 'Energy Beam', 'Energy Field', 'Energy Strike', 'Energy Wall', 'Energy Wave', 'Energybomb', 'Envenom', 'Eternal Winter', 'Ethereal Spear', 'Explosion', 'Fierce Berserk', 'Find Person', 'Fire Field', 'Fire Wall', 'Fire Wave', 'Fireball', 'Firebomb', 'Flame Strike', 'Food', 'Front Sweep', 'Great Energy Beam', 'Great Fireball', 'Great Light', 'Groundshaker', 'Haste', 'Heal Friend', 'Heal Party', 'Heavy Magic Missile', 'Hells Core', 'Holy Flash', 'Holy Missile', 'Ice Strike', 'Ice Wave', 'Icicle', 'Ignite', 'Inflict Wound', 'Intense Healing', 'Intense Healing Rune', 'Intense Recovery', 'Intense Wound Cleansing', 'Invisibility', 'Levitate', 'Light', 'Light Healing', 'Light Magic Missile', 'Lightning', 'Magic Rope', 'Magic Shield', 'Magic Wall', 'Mass Healing', 'Paralyze', 'Physical Strike', 'Poison Bomb', 'Poison Field', 'Poison Wall', 'Protect Party', 'Protector', 'Rage of the Skies', 'Recovery', 'Salvation', 'Sharpshooter', 'Soulfire', 'Stalagmite', 'Stone Shower', 'Strong Energy Strike', 'Strong Ethereal Spear', 'Strong Flame Strike', 'Strong Haste', 'Strong Ice Strike', 'Strong Ice Wave', 'Strong Terra Strike', 'Sudden Death', 'Summon Creature', 'Swift Foot', 'Terra Strike', 'Terra Wave', 'Thunderstorm', 'Train Party', 'Ultimate Energy Strike', 'Ultimate Flame Strike', 'Ultimate Healing', 'Ultimate Healing Rune', 'Ultimate Ice Strike', 'Ultimate Light', 'Ultimate Terra Strike', 'Whirlwind Throw', 'Wild Growth', 'Wound Cleansing', 'Wrath of Nature'}
  },
  
  ['Sample'] =  { 
    iconFile = 'sample.png', 
    iconSize = {width = 64, height = 64},
    spellIcons = {[1] = 'Wind Walk', [2] = 'Fire Breath', [3] = 'Moonglaives', [5] = 'Firefly', [4] = 'Critical Strike'},
    spellOrder = {'Critical Strike', 'Firefly', 'Fire Breath', 'Moonglaives', 'Wind Walk'}
  }
}

-- ['Spell Name'] = {words = '', exhaustion = spellCooldown, premium = true/false, type = 'Instant'/'Conjure', icon = iconName, mana = manaCost, level = levelRequirement, soul = soulCost, group = {[groupId] = groupCooldown}, vocation = {vocationIds}}
SpellInfo = {
  ['Default'] = {
    ['Death Strike'] =             {words = 'exori mort',          exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'deathstrike',            mana = 20,     level = 16, soul = 0, group = {[1] = 2000},               vocations = {1, 5}},
    ['Flame Strike'] =             {words = 'exori flam',          exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'flamestrike',            mana = 20,     level = 14, soul = 0, group = {[1] = 2000},               vocations = {1, 2, 5, 6}},
    ['Strong Flame Strike'] =      {words = 'exori gran flam',     exhaustion = 8000,  premium = true,  type = 'Instant', icon = 'strongflamestrike',      mana = 60,     level = 70, soul = 0, group = {[1] = 2000, [4] = 8000},   vocations = {1, 5}},
    ['Ultimate Flame Strike'] =    {words = 'exori max flam',      exhaustion = 30000, premium = true,  type = 'Instant', icon = 'ultimateflamestrike',    mana = 100,    level = 90, soul = 0, group = {[1] = 4000},               vocations = {1, 5}},
    ['Energy Strike'] =            {words = 'exori vis',           exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'energystrike',           mana = 20,     level = 12, soul = 0, group = {[1] = 2000},               vocations = {1, 2, 5, 6}},
    ['Strong Energy Strike'] =     {words = 'exori gran vis',      exhaustion = 8000,  premium = true,  type = 'Instant', icon = 'strongenergystrike',     mana = 60,     level = 80, soul = 0, group = {[1] = 2000, [4] = 8000},   vocations = {1, 5}},
    ['Ultimate Energy Strike'] =   {words = 'exori max vis',       exhaustion = 30000, premium = true,  type = 'Instant', icon = 'ultimateenergystrike',   mana = 100,    level = 100,soul = 0, group = {[1] = 4000},               vocations = {1, 5}},
    ['Whirlwind Throw'] =          {words = 'exori hur',           exhaustion = 6000,  premium = true,  type = 'Instant', icon = 'whirlwindthrow',         mana = 40,     level = 28, soul = 0, group = {[1] = 2000},               vocations = {4, 8}},
    ['Fire Wave'] =                {words = 'exevo flam hur',      exhaustion = 4000,  premium = false, type = 'Instant', icon = 'firewave',               mana = 25,     level = 18, soul = 0, group = {[1] = 2000},               vocations = {1, 5}},
    ['Ethereal Spear'] =           {words = 'exori con',           exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'eterealspear',           mana = 25,     level = 23, soul = 0, group = {[1] = 2000},               vocations = {3, 7}},
    ['Strong Ethereal Spear'] =    {words = 'exori gran con',      exhaustion = 8000,  premium = true,  type = 'Instant', icon = 'strongetherealspear',    mana = 55,     level = 90, soul = 0, group = {[1] = 2000},               vocations = {3, 7}},
    ['Energy Beam'] =              {words = 'exevo vis lux',       exhaustion = 4000,  premium = false, type = 'Instant', icon = 'energybeam',             mana = 40,     level = 23, soul = 0, group = {[1] = 2000},               vocations = {1, 5}},
    ['Great Energy Beam'] =        {words = 'exevo gran vis lux',  exhaustion = 6000,  premium = false, type = 'Instant', icon = 'greatenergybeam',        mana = 110,    level = 29, soul = 0, group = {[1] = 2000},               vocations = {1, 5}},
    ['Groundshaker'] =             {words = 'exori mas',           exhaustion = 8000,  premium = true,  type = 'Instant', icon = 'groundshaker',           mana = 160,    level = 33, soul = 0, group = {[1] = 2000},               vocations = {4, 8}},
    ['Berserk'] =                  {words = 'exori',               exhaustion = 4000,  premium = true,  type = 'Instant', icon = 'berserk',                mana = 115,    level = 35, soul = 0, group = {[1] = 2000},               vocations = {4, 8}},
    ['Annihilation'] =             {words = 'exori gran ico',      exhaustion = 30000, premium = true,  type = 'Instant', icon = 'annihilation',           mana = 300,    level = 110,soul = 0, group = {[1] = 4000},               vocations = {4, 8}},
    ['Brutal Strike'] =            {words = 'exori ico',           exhaustion = 6000,  premium = true,  type = 'Instant', icon = 'brutalstrike',           mana = 30,     level = 16, soul = 0, group = {[1] = 2000},               vocations = {4, 8}},
    ['Front Sweep'] =              {words = 'exori min',           exhaustion = 6000,  premium = true,  type = 'Instant', icon = 'frontsweep',             mana = 200,    level = 70, soul = 0, group = {[1] = 2000},               vocations = {4, 8}},
    ['Inflict Wound'] =            {words = 'utori kor',           exhaustion = 30000, premium = true,  type = 'Instant', icon = 'inflictwound',           mana = 30,     level = 40, soul = 0, group = {[1] = 2000},               vocations = {4, 8}},
    ['Ignite'] =                   {words = 'utori flam',          exhaustion = 30000, premium = true,  type = 'Instant', icon = 'ignite',                 mana = 30,     level = 26, soul = 0, group = {[1] = 2000},               vocations = {1, 5}},
    ['Lightning'] =                {words = 'exori amp vis',       exhaustion = 8000,  premium = true,  type = 'Instant', icon = 'lightning',              mana = 60,     level = 55, soul = 0, group = {[1] = 2000, [4] = 8000},   vocations = {1, 5}},
    ['Curser'] =                   {words = 'utori mort',          exhaustion = 50000, premium = true,  type = 'Instant', icon = 'curse',                  mana = 30,     level = 75, soul = 0, group = {[1] = 2000},               vocations = {1, 5}},
    ['Electrify'] =                {words = 'utori vis',           exhaustion = 30000, premium = true,  type = 'Instant', icon = 'electrify',              mana = 30,     level = 34, soul = 0, group = {[1] = 2000},               vocations = {1, 5}},
    ['Energy Wave'] =              {words = 'exevo vis hur',       exhaustion = 8000,  premium = false, type = 'Instant', icon = 'energywave',             mana = 170,    level = 38, soul = 0, group = {[1] = 2000},               vocations = {1, 5}},
    ['Rage of the Skies'] =        {words = 'exevo gran mas vis',  exhaustion = 40000, premium = true,  type = 'Instant', icon = 'rageoftheskies',         mana = 600,    level = 55, soul = 0, group = {[1] = 4000},               vocations = {1, 5}},
    ['Fierce Berserk'] =           {words = 'exori gran',          exhaustion = 6000,  premium = true,  type = 'Instant', icon = 'fierceberserk',          mana = 340,    level = 90, soul = 0, group = {[1] = 2000},               vocations = {4, 8}},
    ['Hells Core'] =               {words = 'exevo gran mas flam', exhaustion = 40000, premium = true,  type = 'Instant', icon = 'hellscore',              mana = 1100,   level = 60, soul = 0, group = {[1] = 4000},               vocations = {1, 5}},
    ['Holy Flash'] =               {words = 'utori san',           exhaustion = 40000, premium = true,  type = 'Instant', icon = 'holyflash',              mana = 30,     level = 70, soul = 0, group = {[1] = 2000},               vocations = {3, 7}},
    ['Divine Missile'] =           {words = 'exori san',           exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'divinemissile',          mana = 20,     level = 40, soul = 0, group = {[1] = 2000},               vocations = {3, 7}},
    ['Divine Caldera'] =           {words = 'exevo mas san',       exhaustion = 4000,  premium = true,  type = 'Instant', icon = 'divinecaldera',          mana = 160,    level = 50, soul = 0, group = {[1] = 2000},               vocations = {3, 7}},
    ['Physical Strike'] =          {words = 'exori moe ico',       exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'physicalstrike',         mana = 20,     level = 16, soul = 0, group = {[1] = 2000},               vocations = {2, 6}},
    ['Eternal Winter'] =           {words = 'exevo gran mas frigo',exhaustion = 40000, premium = true,  type = 'Instant', icon = 'eternalwinter',          mana = 1050,   level = 60, soul = 0, group = {[1] = 4000},               vocations = {2, 6}},
    ['Ice Strike'] =               {words = 'exori frigo',         exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'icestrike',              mana = 20,     level = 15, soul = 0, group = {[1] = 2000},               vocations = {1, 5, 2, 6}},
    ['Strong Ice Strike'] =        {words = 'exori gran frigo',    exhaustion = 8000,  premium = true,  type = 'Instant', icon = 'strongicestrike',        mana = 60,     level = 80, soul = 0, group = {[1] = 2000, [4] = 8000},   vocations = {2, 6}},
    ['Ultimate Ice Strike'] =      {words = 'exori max frigo',     exhaustion = 30000, premium = true,  type = 'Instant', icon = 'ultimateicestrike',      mana = 100,    level = 100,soul = 0, group = {[1] = 4000},               vocations = {2, 6}},
    ['Ice Wave'] =                 {words = 'exevo frigo hur',     exhaustion = 4000,  premium = false, type = 'Instant', icon = 'icewave',                mana = 25,     level = 18, soul = 0, group = {[1] = 2000},               vocations = {2, 6}},
    ['Strong Ice Wave'] =          {words = 'exevo gran frigo hur',exhaustion = 8000,  premium = true,  type = 'Instant', icon = 'strongicewave',          mana = 170,    level = 40, soul = 0, group = {[1] = 2000},               vocations = {2, 6}},
    ['Envenom'] =                  {words = 'utori pox',           exhaustion = 40000, premium = true,  type = 'Instant', icon = 'envenom',                mana = 30,     level = 50, soul = 0, group = {[1] = 2000},               vocations = {2, 6}},
    ['Terra Strike'] =             {words = 'exori tera',          exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'terrastrike',            mana = 20,     level = 13, soul = 0, group = {[1] = 2000},               vocations = {1, 5, 2, 6}},
    ['Strong Terra Strike'] =      {words = 'exori gran tera',     exhaustion = 8000,  premium = true,  type = 'Instant', icon = 'strongterrastrike',      mana = 60,     level = 70, soul = 0, group = {[1] = 2000, [4] = 8000},   vocations = {2, 6}},
    ['Ultimate Terra Strike'] =    {words = 'exori max tera',      exhaustion = 30000, premium = true,  type = 'Instant', icon = 'ultimateterrastrike',    mana = 100,    level = 90, soul = 0, group = {[1] = 4000},               vocations = {2, 6}},
    ['Terra Wave'] =               {words = 'exevo tera hur',      exhaustion = 4000,  premium = false, type = 'Instant', icon = 'terrawave',              mana = 210,    level = 38, soul = 0, group = {[1] = 2000},               vocations = {2, 6}},
    ['Wrath of Nature'] =          {words = 'exevo gran mas tera', exhaustion = 40000, premium = true,  type = 'Instant', icon = 'wrathofnature',          mana = 700,    level = 55, soul = 0, group = {[1] = 4000},               vocations = {2, 6}},
    ['Light Healing'] =            {words = 'exura',               exhaustion = 1000,  premium = false, type = 'Instant', icon = 'lighthealing',           mana = 20,     level = 9,  soul = 0, group = {[2] = 1000},               vocations = {1, 2, 3, 5, 6, 7}},
    ['Wound Cleansing'] =          {words = 'exura ico',           exhaustion = 1000,  premium = false, type = 'Instant', icon = 'woundcleansing',         mana = 40,     level = 10, soul = 0, group = {[2] = 1000},               vocations = {4, 8}},
    ['Intense Wound Cleansing'] =  {words = 'exura gran ico',      exhaustion = 600000,premium = true,  type = 'Instant', icon = 'intensewoundcleansing',  mana = 200,    level = 80, soul = 0, group = {[2] = 1000},               vocations = {4, 8}},
    ['Cure Bleeding'] =            {words = 'exana kor',           exhaustion = 6000,  premium = true,  type = 'Instant', icon = 'curebleeding',           mana = 30,     level = 30, soul = 0, group = {[2] = 1000},               vocations = {4, 8}},
    ['Cure Electrification'] =     {words = 'exana vis',           exhaustion = 6000,  premium = true,  type = 'Instant', icon = 'curseelectrification',   mana = 30,     level = 22, soul = 0, group = {[2] = 1000},               vocations = {2, 6}},
    ['Cure Poison'] =              {words = 'exana pox',           exhaustion = 6000,  premium = false, type = 'Instant', icon = 'curepoison',             mana = 30,     level = 10, soul = 0, group = {[2] = 1000},               vocations = {1, 2, 3, 4, 5, 6, 7, 8}},
    ['Cure Burning'] =             {words = 'exana flam',          exhaustion = 6000,  premium = true,  type = 'Instant', icon = 'cureburning',            mana = 30,     level = 30, soul = 0, group = {[2] = 1000},               vocations = {2, 6}},
    ['Cure Curse'] =               {words = 'exana mort',          exhaustion = 6000,  premium = true,  type = 'Instant', icon = 'curecurse',              mana = 40,     level = 80, soul = 0, group = {[2] = 1000},               vocations = {3, 7}},
    ['Recovery'] =                 {words = 'utura',               exhaustion = 60000, premium = true,  type = 'Instant', icon = 'recovery',               mana = 75,     level = 50, soul = 0, group = {[2] = 1000},               vocations = {4, 8, 3, 7}},
    ['Intense Recovery'] =         {words = 'utura gran',          exhaustion = 60000, premium = true,  type = 'Instant', icon = 'intenserecovery',        mana = 165,    level = 100,soul = 0, group = {[2] = 1000},               vocations = {4, 8, 3, 7}},
    ['Salvation'] =                {words = 'exura gran san',      exhaustion = 1000,  premium = true,  type = 'Instant', icon = 'salvation',              mana = 210,    level = 60, soul = 0, group = {[2] = 1000},               vocations = {3, 7}},
    ['Intense Healing'] =          {words = 'exura gran',          exhaustion = 1000,  premium = false, type = 'Instant', icon = 'intensehealing',         mana = 70,     level = 20, soul = 0, group = {[2] = 1000},               vocations = {1, 2, 3, 5, 6, 7}},
    ['Heal Friend'] =              {words = 'exura sio',           exhaustion = 1000,  premium = true,  type = 'Instant', icon = 'healfriend',             mana = 140,    level = 18, soul = 0, group = {[2] = 1000},               vocations = {2, 6}},
    ['Ultimate Healing'] =         {words = 'exura vita',          exhaustion = 1000,  premium = false, type = 'Instant', icon = 'ultimatehealing',        mana = 160,    level = 30, soul = 0, group = {[2] = 1000},               vocations = {1, 2, 5, 6}},
    ['Mass Healing'] =             {words = 'exura gran mas res',  exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'masshealing',            mana = 150,    level = 36, soul = 0, group = {[2] = 1000},               vocations = {2, 6}},
    ['Divine Healing'] =           {words = 'exura san',           exhaustion = 1000,  premium = false, type = 'Instant', icon = 'divinehealing',          mana = 160,    level = 35, soul = 0, group = {[2] = 1000},               vocations = {3, 7}},
    ['Light'] =                    {words = 'utevo lux',           exhaustion = 2000,  premium = false, type = 'Instant', icon = 'light',                  mana = 20,     level = 8,  soul = 0, group = {[3] = 2000},               vocations = {1, 2, 3, 4, 5, 6, 7, 8}},
    ['Find Person'] =              {words = 'exiva',               exhaustion = 2000,  premium = false, type = 'Instant', icon = 'findperson',             mana = 20,     level = 8,  soul = 0, group = {[3] = 2000},               vocations = {1, 2, 3, 4, 5, 6, 7, 8}},
    ['Magic Rope'] =               {words = 'exani tera',          exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'magicrope',              mana = 20,     level = 9,  soul = 0, group = {[3] = 2000},               vocations = {1, 2, 3, 4, 5, 6, 7, 8}},
    ['Levitate'] =                 {words = 'exani hur',           exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'levitate',               mana = 50,     level = 12, soul = 0, group = {[3] = 2000},               vocations = {1, 2, 3, 4, 5, 6, 7, 8}},
    ['Great Light'] =              {words = 'utevo gran lux',      exhaustion = 2000,  premium = false, type = 'Instant', icon = 'greatlight',             mana = 60,     level = 13, soul = 0, group = {[3] = 2000},               vocations = {1, 2, 3, 4, 5, 6, 7, 8}},
    ['Magic Shield'] =             {words = 'utamo vita',          exhaustion = 2000,  premium = false, type = 'Instant', icon = 'magicshield',            mana = 50,     level = 14, soul = 0, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Haste'] =                    {words = 'utani hur',           exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'haste',                  mana = 60,     level = 14, soul = 0, group = {[3] = 2000},               vocations = {1, 2, 3, 4, 5, 6, 7, 8}},
    ['Charge'] =                   {words = 'utani tempo hur',     exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'charge',                 mana = 100,    level = 25, soul = 0, group = {[3] = 2000},               vocations = {4, 8}},
    ['Swift Foot'] =               {words = 'utamo tempo san',     exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'swiftfoot',              mana = 400,    level = 55, soul = 0, group = {[1] = 10000, [3] = 2000},  vocations = {3, 7}},
    ['Challenge'] =                {words = 'exeta res',           exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'challenge',              mana = 30,     level = 20, soul = 0, group = {[3] = 2000},               vocations = {8}},
    ['Strong Haste'] =             {words = 'utani gran hur',      exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'stronghaste',            mana = 100,    level = 20, soul = 0, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Creature Illusion'] =        {words = 'utevo res ina',       exhaustion = 2000,  premium = false, type = 'Instant', icon = 'creatureillusion',       mana = 100,    level = 23, soul = 0, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Ultimate Light'] =           {words = 'utevo vis lux',       exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'ultimatelight',          mana = 140,    level = 26, soul = 0, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Cancel Invisibility'] =      {words = 'exana ina',           exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'cancelinvisibility',     mana = 200,    level = 26, soul = 0, group = {[3] = 2000},               vocations = {3, 7}},
    ['Invisibility'] =             {words = 'utana vid',           exhaustion = 2000,  premium = false, type = 'Instant', icon = 'invisible',              mana = 440,    level = 35, soul = 0, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Sharpshooter'] =             {words = 'utito tempo san',     exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'sharpshooter',           mana = 450,    level = 60, soul = 0, group = {[2] = 10000, [3] = 10000}, vocations = {3, 7}},
    ['Protector'] =                {words = 'utamo tempo',         exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'protector',              mana = 200,    level = 55, soul = 0, group = {[1] = 10000, [3] = 2000},  vocations = {4, 8}},
    ['Blood Rage'] =               {words = 'utito tempo',         exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'bloodrage',              mana = 290,    level = 60, soul = 0, group = {[3] = 2000},               vocations = {4, 8}},
    ['Train Party'] =              {words = 'utito mas sio',       exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'trainparty',             mana = 'Var.', level = 32, soul = 0, group = {[3] = 2000},               vocations = {8}},
    ['Protect Party'] =            {words = 'utamo mas sio',       exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'protectparty',           mana = 'Var.', level = 32, soul = 0, group = {[3] = 2000},               vocations = {7}},
    ['Heal Party'] =               {words = 'utura mas sio',       exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'healparty',              mana = 'Var.', level = 32, soul = 0, group = {[3] = 2000},               vocations = {6}},
    ['Enchant Party'] =            {words = 'utori mas sio',       exhaustion = 2000,  premium = true,  type = 'Instant', icon = 'enchantparty',           mana = 'Var.', level = 32, soul = 0, group = {[3] = 2000},               vocations = {5}},
    ['Summon Creature'] =          {words = 'utevo res',           exhaustion = 2000,  premium = false, type = 'Instant', icon = 'summoncreature',         mana = 'Var.', level = 25, soul = 0, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Conjure Arrow'] =            {words = 'exevo con',           exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'conjurearrow',           mana = 100,    level = 13, soul = 1, group = {[3] = 2000},               vocations = {3, 7}},
    ['Food'] =                     {words = 'exevo pan',           exhaustion = 2000,  premium = false, type = 'Instant', icon = 'food',                   mana = 120,    level = 14, soul = 1, group = {[3] = 2000},               vocations = {2, 6}},
    ['Conjure Poisoned Arrow'] =   {words = 'exevo con pox',       exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'poisonedarrow',          mana = 130,    level = 16, soul = 2, group = {[3] = 2000},               vocations = {3, 7}},
    ['Conjure Bolt'] =             {words = 'exevo con mort',      exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'conjurebolt',            mana = 140,    level = 17, soul = 2, group = {[3] = 2000},               vocations = {3, 7}},
    ['Conjure Sniper Arrow'] =     {words = 'exevo con hur',       exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'sniperarrow',            mana = 160,    level = 24, soul = 3, group = {[3] = 2000},               vocations = {3, 7}},
    ['Conjure Explosive Arrow'] =  {words = 'exevo con flam',      exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'explosivearrow',         mana = 290,    level = 25, soul = 3, group = {[3] = 2000},               vocations = {3, 7}},
    ['Conjure Piercing Bolt'] =    {words = 'exevo con grav',      exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'piercingbolt',           mana = 180,    level = 33, soul = 3, group = {[3] = 2000},               vocations = {3, 7}},
    ['Enchant Staff'] =            {words = 'exeta vis',           exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'enchantstaff',           mana = 80,     level = 41, soul = 0, group = {[3] = 2000},               vocations = {5}},
    ['Enchant Spear'] =            {words = 'exeta con',           exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'enchantspear',           mana = 350,    level = 45, soul = 3, group = {[3] = 2000},               vocations = {3, 7}},
    ['Conjure Power Bolt'] =       {words = 'exevo con vis',       exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'powerbolt',              mana = 800,    level = 59, soul = 3, group = {[3] = 2000},               vocations = {7}},
    ['Poison Field'] =             {words = 'adevo grav pox',      exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'poisonfield',            mana = 200,    level = 14, soul = 1, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Light Magic Missile'] =      {words = 'adori min vis',       exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'lightmagicmissile',      mana = 120,    level = 15, soul = 1, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Fire Field'] =               {words = 'adevo grav flam',     exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'firefield',              mana = 240,    level = 15, soul = 1, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Fireball'] =                 {words = 'adori flam',          exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'fireball',               mana = 460,    level = 27, soul = 3, group = {[3] = 2000},               vocations = {1, 5}},
    ['Energy Field'] =             {words = 'adevo grav vis',      exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'energyfield',            mana = 320,    level = 18, soul = 2, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Stalagmite'] =               {words = 'adori tera',          exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'stalagmite',             mana = 400,    level = 24, soul = 2, group = {[3] = 2000},               vocations = {1, 5, 2, 6}},
    ['Great Fireball'] =           {words = 'adori mas flam',      exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'greatfireball',          mana = 530,    level = 30, soul = 3, group = {[3] = 2000},               vocations = {1, 5}},
    ['Heavy Magic Missile'] =      {words = 'adori vis',           exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'heavymagicmissile',      mana = 350,    level = 25, soul = 2, group = {[3] = 2000},               vocations = {1, 5, 2, 6}},
    ['Poison Bomb'] =              {words = 'adevo mas pox',       exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'poisonbomb',             mana = 520,    level = 25, soul = 2, group = {[3] = 2000},               vocations = {2, 6}},
    ['Firebomb'] =                 {words = 'adevo mas flam',      exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'firebomb',               mana = 600,    level = 27, soul = 3, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Soulfire'] =                 {words = 'adevo res flam',      exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'soulfire',               mana = 600,    level = 27, soul = 3, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Poison Wall'] =              {words = 'adevo mas grav pox',  exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'poisonwall',             mana = 640,    level = 29, soul = 3, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Explosion'] =                {words = 'adevo mas hur',       exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'explosion',              mana = 570,    level = 31, soul = 3, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Fire Wall'] =                {words = 'adevo mas grav flam', exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'firewall',               mana = 780,    level = 33, soul = 3, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Energybomb'] =               {words = 'adevo mas vis',       exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'energybomb',             mana = 880,    level = 37, soul = 5, group = {[3] = 2000},               vocations = {1, 5}},
    ['Energy Wall'] =              {words = 'adevo mas grav vis',  exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'energywall',             mana = 1000,   level = 41, soul = 5, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Sudden Death'] =             {words = 'adori gran mort',     exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'suddendeath',            mana = 985,    level = 45, soul = 5, group = {[3] = 2000},               vocations = {1, 5}},
    ['Cure Poison Rune'] =         {words = 'adana pox',           exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'antidote',               mana = 200,    level = 15, soul = 1, group = {[3] = 2000},               vocations = {2, 6}},
    ['Intense Healing Rune'] =     {words = 'adura gran',          exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'intensehealingrune',     mana = 240,    level = 15, soul = 2, group = {[3] = 2000},               vocations = {2, 6}},
    ['Ultimate Healing Rune'] =    {words = 'adura vita',          exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'ultimatehealingrune',    mana = 400,    level = 24, soul = 3, group = {[3] = 2000},               vocations = {2, 6}},
    ['Convince Creature'] =        {words = 'adeta sio',           exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'convincecreature',       mana = 200,    level = 16, soul = 3, group = {[3] = 2000},               vocations = {2, 6}},
    ['Animate Dead'] =             {words = 'adana mort',          exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'animatedead',            mana = 600,    level = 27, soul = 5, group = {[3] = 2000},               vocations = {1, 2, 5, 6}},
    ['Chameleon'] =                {words = 'adevo ina',           exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'chameleon',              mana = 600,    level = 27, soul = 2, group = {[3] = 2000},               vocations = {2, 6}},
    ['Destroy Field'] =            {words = 'adito grav',          exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'destroyfield',           mana = 120,    level = 17, soul = 2, group = {[3] = 2000},               vocations = {1, 2, 3, 5, 6, 7}},
    ['Desintegrate'] =             {words = 'adito tera',          exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'desintegrate',           mana = 200,    level = 21, soul = 3, group = {[3] = 2000},               vocations = {1, 2, 3, 5, 6, 7}},
    ['Magic Wall'] =               {words = 'adevo grav tera',     exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'magicwall',              mana = 750,    level = 32, soul = 5, group = {[3] = 2000},               vocations = {1, 5}},
    ['Wild Growth'] =              {words = 'adevo grav vita',     exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'wildgrowth',             mana = 600,    level = 27, soul = 5, group = {[3] = 2000},               vocations = {2, 6}},
    ['Paralyze'] =                 {words = 'adana ani',           exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'paralyze',               mana = 1400,   level = 54, soul = 3, group = {[3] = 2000},               vocations = {2, 6}},
    ['Icicle'] =                   {words = 'adori frigo',         exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'icicle',                 mana = 460,    level = 28, soul = 3, group = {[3] = 2000},               vocations = {2, 6}},
    ['Avalanche'] =                {words = 'adori mas frigo',     exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'avalanche',              mana = 530,    level = 30, soul = 3, group = {[3] = 2000},               vocations = {2, 6}},
    ['Stone Shower'] =             {words = 'adori mas tera',      exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'stoneshower',            mana = 430,    level = 28, soul = 3, group = {[3] = 2000},               vocations = {2, 6}},
    ['Thunderstorm'] =             {words = 'adori mas vis',       exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'thunderstorm',           mana = 430,    level = 28, soul = 3, group = {[3] = 2000},               vocations = {1, 5}},
    ['Holy Missile'] =             {words = 'adori san',           exhaustion = 2000,  premium = false, type = 'Conjure', icon = 'holymissile',            mana = 350,    level = 27, soul = 3, group = {[3] = 2000},               vocations = {3, 7}}
  },
  
  ['Sample'] = {
    ['Wind Walk'] =                {words = 'windwalk',        description = 'Run at enormous speed.',          exhaustion = 2000,  premium = false, type = 'Instant', icon = 1,  mana = 50,     level = 10, soul = 0, group = {[3] = 2000}, vocations = {1, 2}},
    ['Fire Breath'] =              {words = 'firebreath',      description = 'A strong firewave.',              exhaustion = 2000,  premium = false, type = 'Instant', icon = 2,  mana = 350,    level = 27, soul = 0, group = {[1] = 2000}, vocations = {4, 8}},
    ['Moonglaives'] =              {words = 'moonglaives',     description = 'Throw moonglaives around you.',   exhaustion = 2000,  premium = false, type = 'Instant', icon = 3,  mana = 90,     level = 55, soul = 0, group = {[1] = 2000}, vocations = {3, 7}},
    ['Critical Strike'] =          {words = 'criticalstrike',  description = 'Land a critical strike.',         exhaustion = 2000,  premium = false, type = 'Instant', icon = 4,  mana = 350,    level = 27, soul = 0, group = {[1] = 2000}, vocations = {3, 4, 7, 8}},
    ['Firefly'] =                  {words = 'firefly',         description = 'Summon a angry firefly',          exhaustion = 2000,  premium = false, type = 'Instant', icon = 5,  mana = 350,    level = 27, soul = 0, group = {[1] = 2000}, vocations = {1, 2, 5, 6}}
  }
}

-- ['const_name'] =       {client_id, TFS_id}
-- Conversion from TFS icon id to the id used by client (icons.png order)
SpellIcons = {
  ['intenserecovery']           = {16, 160},
  ['recovery']                  = {15, 159},
  ['intensewoundcleansing']     = {4, 158},
  ['ultimateterrastrike']       = {37, 157},
  ['ultimateicestrike']         = {34, 156},
  ['ultimateenergystrike']      = {31, 155},
  ['ultimateflamestrike']       = {28, 154},
  ['strongterrastrike']         = {36, 153},
  ['strongicestrike']           = {33, 152},
  ['strongenergystrike']        = {30, 151},
  ['strongflamestrike']         = {27, 150},
  ['lightning']                 = {51, 149},
  ['physicalstrike']            = {17, 148},
  ['curecurse']                 = {11, 147},
  ['curseelectrification']      = {14, 146},
  ['cureburning']               = {13, 145},
  ['curebleeding']              = {12, 144},
  ['holyflash']                 = {53, 143},
  ['envenom']                   = {58, 142},
  ['inflictwound']              = {57, 141},
  ['electrify']                 = {56, 140},
  ['curse']                     = {54, 139},
  ['ignite']                    = {55, 138},
  -- [[ 136 / 137 Unknown ]]
  ['sharpshooter']              = {121, 135},
  ['swiftfoot']                 = {119, 134},
  ['bloodrage']                 = {96, 133},
  ['protector']                 = {122, 132},
  ['charge']                    = {98, 131},
  ['holymissile']               = {76, 130},
  ['enchantparty']              = {113, 129},
  ['healparty']                 = {126, 128},
  ['protectparty']              = {123, 127},
  ['trainparty']                = {120, 126},
  ['divinehealing']             = {2, 125},
  ['divinecaldera']             = {40, 124},
  ['woundcleansing']            = {3, 123},
  ['divinemissile']             = {39, 122},
  ['icewave']                   = {45, 121},
  ['terrawave']                 = {47, 120},
  ['rageoftheskies']            = {52, 119},
  ['eternalwinter']             = {50, 118},
  ['thunderstorm']              = {63, 117},
  ['stoneshower']               = {65, 116},
  ['avalanche']                 = {92, 115},
  ['icicle']                    = {75, 114},
  ['terrastrike']               = {35, 113},
  ['icestrike']                 = {32, 112},
  ['eterealspear']              = {18, 111},
  ['enchantspear']              = {104, 110},
  ['piercingbolt']              = {110, 109},
  ['sniperarrow']               = {112, 108},
  ['whirlwindthrow']            = {19, 107},
  ['groundshaker']              = {25, 106},
  ['fierceberserk']             = {22, 105},  
  -- [[ 96 - 104 Unknown ]]
  ['powerbolt']                 = {108, 95},  
  ['wildgrowth']                = {61, 94},  
  ['challenge']                 = {97, 93},  
  ['enchantstaff']              = {103, 92},  
  ['poisonbomb']                = {70, 91},  
  ['cancelinvisibility']        = {95, 90},  
  ['flamestrike']               = {26, 89},  
  ['energystrike']              = {29, 88},  
  ['deathstrike']               = {38, 87},  
  ['magicwall']                 = {72, 86},  
  ['healfriend']                = {8, 84},  
  ['animatedead']               = {93, 83},  
  ['masshealing']               = {9, 82},  
  ['levitate']                  = {125, 81},  
  ['berserk']                   = {21, 80},  
  ['conjurebolt']               = {107, 79},  
  ['desintegrate']              = {88, 78},  
  ['stalagmite']                = {66, 77},  
  ['magicrope']                 = {105, 76},  
  ['ultimatelight']             = {115, 75},  
  -- [[ 71 - 64 TFS House Commands ]]
  -- [[ 63 - 70 Unknown ]]
  ['annihilation']              = {24, 62},  
  ['brutalstrike']              = {23, 61},  
  -- [[ 60 Unknown ]]
  ['frontsweep']                = {20, 59},
  -- [[ 58 Unknown ]]
  ['strongetherealspear']       = {59, 57},  
  ['wrathofnature']             = {48, 56},  
  ['energybomb']                = {86, 55},  
  ['paralyze']                  = {71, 54},  
  --  [[ 53 Unknown ]]
  --  [[ 52 TFS Retrieve Friend ]]
  ['conjurearrow']              = {106, 51},  
  ['soulfire']                  = {67, 50},  
  ['explosivearrow']            = {109, 49},  
  ['poisonedarrow']             = {111, 48},  
  -- [[ 46 / 47 Unknown ]]
  ['invisible']                 = {94, 45},  
  ['magicshield']               = {124, 44},  
  ['strongicewave']             = {46, 43},  
  ['food']                      = {99, 42},  
  -- [[ 40 / 41 Unknown ]]
  ['stronghaste']               = {102, 39},    
  ['creatureillusion']          = {100, 38},    
  -- [[ 37 TFS Move ]]
  ['salvation']                 = {60, 36},    
  -- [[ 34 / 35 Unknown ]]  
  ['energywall']                = {84, 33},    
  ['poisonwall']                = {68, 32},    
  ['antidote']                  = {10, 31},  
  ['destroyfield']              = {87, 30},    
  ['curepoison']                = {10, 29},    
  ['firewall']                  = {80, 28},    
  ['energyfield']               = {85, 27},    
  ['poisonfield']               = {69, 26},    
  ['firefield']                 = {81, 25},    
  ['hellscore']                 = {49, 24},    
  ['greatenergybeam']           = {42, 23},    
  ['energybeam']                = {41, 22},    
  ['suddendeath']               = {64, 21},    
  ['findperson']                = {114, 20},    
  ['firewave']                  = {44, 19},    
  ['explosion']                 = {83, 18},    
  ['firebomb']                  = {82, 17},    
  ['greatfireball']             = {78, 16},    
  ['fireball']                  = {79, 15},    
  ['chameleon']                 = {91, 14},    
  ['energywave']                = {43, 13},    
  ['convincecreature']          = {90, 12},    
  ['greatlight']                = {116, 11},    
  ['light']                     = {117, 10},    
  ['summoncreature']            = {118, 9},    
  ['heavymagicmissile']         = {77, 8},    
  ['lightmagicmissile']         = {73, 7},    
  ['haste']                     = {101, 6},    
  ['ultimatehealingrune']       = {62, 5},    
  ['intensehealingrune']        = {74, 4},    
  ['ultimatehealing']           = {1, 3},    
  ['intensehealing']            = {7, 2},    
  ['lighthealing']              = {6, 1}  
}

VocationNames = {
  [1] = 'Sorcerer',
  [2] = 'Druid',
  [3] = 'Paladin',
  [4] = 'Knight',
  [5] = 'Master Sorcerer',
  [6] = 'Elder Druid',
  [7] = 'Royal Paladin',
  [8] = 'Elite Knight'
}

SpellGroups = {
  [1] = 'Attack',
  [2] = 'Healing',
  [3] = 'Support',
  [4] = 'Special'
}
