# Try to find the GMP library
#  GMP_FOUND - system has GMP
#  GMP_INCLUDE_DIR - the GMP include directory
#  GMP_LIBRARY - the GMP library

FIND_PATH(GMP_INCLUDE_DIR NAMES gmp.h)
SET(_GMP_STATIC_LIBS libgmp.a)
SET(_GMP_SHARED_LIBS libgmp.dll.a gmp)
IF(USE_STATIC_LIBS)
    FIND_LIBRARY(GMP_LIBRARY NAMES ${_GMP_STATIC_LIBS} ${_GMP_SHARED_LIBS})
ELSE()
    FIND_LIBRARY(GMP_LIBRARY NAMES ${_GMP_SHARED_LIBS} ${_GMP_STATIC_LIBS})
ENDIF()
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(GMP DEFAULT_MSG GMP_LIBRARY GMP_INCLUDE_DIR)
MARK_AS_ADVANCED(GMP_LIBRARY GMP_INCLUDE_DIR)