# Try to find the libgit2 library
#  GIT2_FOUND - system has libgit2
#  GIT2_INCLUDE_DIR - the libgit2 include directory
#  GIT2_LIBRARY - the libgit2 library

FIND_PATH(GIT2_INCLUDE_DIR NAMES git2.h)
SET(_GIT2_STATIC_LIBS libgit2.a)
SET(_GIT2_SHARED_LIBS libgit2.dll.a git2)
IF(USE_STATIC_LIBS)
    FIND_LIBRARY(GIT2_LIBRARY NAMES ${_GIT2_STATIC_LIBS} ${_GIT2_SHARED_LIBS})
ELSE()
    FIND_LIBRARY(GIT2_LIBRARY NAMES ${_GIT2_SHARED_LIBS} ${_GIT2_STATIC_LIBS})
ENDIF()
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(GIT2 DEFAULT_MSG GIT2_LIBRARY GIT2_INCLUDE_DIR)
MARK_AS_ADVANCED(GIT2_LIBRARY GIT2_INCLUDE_DIR)
