/*
 * Copyright (c) 2010-2012 OTClient <https://github.com/edubart/otclient>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef PARTICLEEFFECT_H
#define PARTICLEEFFECT_H

#include "declarations.h"
#include "particlesystem.h"
#include <framework/luaengine/luaobject.h>
#include <framework/otml/otml.h>

class ParticleEffectType : public LuaObject
{
public:
    ParticleEffectType();

    bool load(const OTMLNodePtr& node);

    void setName(const std::string& name) { m_name = name; }
    void setFile(const std::string& file) { m_file = file; }
    void setDescription(const std::string& description) { m_description = description; }

    std::string getName() { return m_name; }
    std::string getFile() { return m_file; }
    std::string getDescription() { return m_description; }
    OTMLNodePtr getNode() { return m_node; }

private:
    std::string m_name;
    std::string m_file;
    std::string m_description;
    OTMLNodePtr m_node;
};

class ParticleEffect : public LuaObject
{
public:
    ParticleEffect() {}

    bool load(const ParticleEffectTypePtr& effectType);
    bool hasFinished() { return m_systems.size() == 0; }
    void render();
    void update();

private:
    std::vector<ParticleSystemPtr> m_systems;
};

#endif
