var console = {
    log: function(msg) {
        postMessage({type: "log", data: msg});
    }
};
var window = {
    console: console
};

var require = function(id) {
    var module = require.modules[id];
    if (module) {
        if (!module.initialized) {
            module.exports = module.factory().exports;
            module.initialized = true;
        }
        return module.exports;
    }
    
    var chunks = id.split("/");
    chunks[0] = require.tlns[chunks[0]] || chunks[0];
    path = require.baseUrl + "/" + chunks.join("/") + ".js"
    
    require.id = id;
    importScripts(path);
    return require(id);    
};

require.modules = {};
require.tlns = {};
require.baseUrl;

var define = function(id, factory) {
    if (!factory) {
        factory = id;
        id = require.id;
    }
    if (id.indexOf("text!") == 0) 
        return;
    
    require.modules[id] = {
        factory: function() {
            var module = {
                exports: {}
            };
            var returnExports = factory(require, module.exports, module);
            if (returnExports)
                module.exports = exports;
            return module;
        }
    };
};

function initBaseUrls(baseUrl, topLevelNamespaces) {
    require.baseUrl = baseUrl;
    require.tlns = topLevelNamespaces;
}

function initSender() {

    var EventEmitter = require("pilot/event_emitter").EventEmitter;
    var oop = require("pilot/oop");
    
    var Sender = function() {};
    
    (function() {
        
        oop.implement(this, EventEmitter);
                
        this.callback = function(data, callbackId) {
            postMessage({
                type: "call",
                id: callbackId,
                data: data
            });
        },
    
        this.emit = function(name, data) {
            postMessage({
                type: "event",
                name: name,
                data: data
            });
        }
    }).call(Sender.prototype);
    
    return new Sender();
}

var main;
var sender;

onmessage = function(e) {
    var msg = e.data;
    if (msg.command)
        main[msg.command].apply(main, msg.args);
    else if (msg.init) {        
        initBaseUrls(msg.base, msg.tlns);
        require("pilot/fixoldbrowsers");
        sender = initSender();
        var clazz = require(msg.module)[msg.classname];
        main = new clazz(sender);
    } else if (msg.event) {
        sender._dispatchEvent(msg.event, msg.data);
    }
};