/*
 * Decompiled with CFR 0.152.
 */
package org.jsdoc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.ast.ArrayComprehension;
import org.mozilla.javascript.ast.ArrayComprehensionLoop;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.CatchClause;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.EmptyStatement;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForInLoop;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.LetNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.RegExpLiteral;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;
import org.mozilla.javascript.ast.WithStatement;
import org.mozilla.javascript.ast.Yield;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstBuilder {
    private static final String NODE_ID = HiddenProperties.NODE_ID.getPropertyName();
    private static final String TYPE = Properties.TYPE.getPropertyName();
    private static Context cx;
    private static ScriptableObject scope;
    private Parser parser;
    private NativeObject ast;
    private Map<String, AstNode> rhinoNodes;
    private AstRoot root;
    private Map<Comment, NativeObject> comments;
    private List<NativeObject> nativeComments;
    private Set<Comment> seenComments;

    public AstBuilder() {
        cx = Context.getCurrentContext();
        scope = cx.initStandardObjects();
        this.reset();
    }

    public void reset() {
        this.parser = null;
        this.ast = null;
        this.rhinoNodes = new HashMap<String, AstNode>();
        this.root = null;
        this.comments = new HashMap<Comment, NativeObject>();
        this.nativeComments = new ArrayList<NativeObject>();
        this.seenComments = new HashSet<Comment>();
    }

    public NativeObject getAst() {
        return this.ast;
    }

    public Map<String, AstNode> getRhinoNodes() {
        return this.rhinoNodes;
    }

    public NativeObject build(String sourceCode, String sourceName) {
        if (this.ast != null) {
            this.reset();
        }
        this.parser = AstBuilder.getParser();
        this.root = this.parser.parse(sourceCode, sourceName, 1);
        this.processAllComments(this.root);
        this.ast = this.processNode(this.root);
        if (this.ast == null) {
            this.ast = AstBuilder.newObject();
        }
        this.ast.defineProperty("comments", AstBuilder.newArray(this.nativeComments), 0);
        this.attachRemainingComments();
        return this.ast;
    }

    protected static Context getCurrentContext() {
        return cx;
    }

    protected static ScriptableObject getCurrentScope() {
        return scope;
    }

    protected static NativeObject newObject() {
        return (NativeObject)cx.newObject(scope);
    }

    protected static NativeArray newArray(List<?> list) {
        return (NativeArray)cx.newArray((Scriptable)scope, list.toArray());
    }

    protected static NativeArray newArray(int capacity) {
        return (NativeArray)cx.newArray((Scriptable)scope, capacity);
    }

    private static Parser getParser() {
        CompilerEnvirons ce = new CompilerEnvirons();
        ce.setRecordingComments(true);
        ce.setRecordingLocalJsDocComments(true);
        ce.setLanguageVersion(180);
        ce.initFromContext(cx);
        return new Parser(ce, ce.getErrorReporter());
    }

    private NativeArray getRange(AstNode rhinoNode) {
        ArrayList<Integer> range = new ArrayList<Integer>();
        Integer start = rhinoNode.getAbsolutePosition();
        Integer end = start + rhinoNode.getLength();
        range.add(start);
        range.add(end);
        return AstBuilder.newArray(range);
    }

    private NativeObject getLocation(AstNode rhinoNode) {
        NativeObject loc = AstBuilder.newObject();
        NativeObject start = AstBuilder.newObject();
        start.put("line", (Scriptable)start, (Object)rhinoNode.getLineno());
        loc.put("start", (Scriptable)loc, (Object)start);
        loc.put("end", (Scriptable)loc, (Object)AstBuilder.newObject());
        return loc;
    }

    private Integer getSyntaxStart() {
        AstNode node = (AstNode)this.root.getFirstChild();
        while (node instanceof Comment) {
            node = (AstNode)node.getNext();
        }
        if (node != null) {
            return node.getAbsolutePosition();
        }
        return null;
    }

    private boolean isJsDocComment(Comment comment) {
        return comment.getCommentType() == Token.CommentType.JSDOC;
    }

    private void attachLeadingComments(AstNode rhinoNode, Entry info) {
        ArrayList<NativeObject> leadingComments = new ArrayList<NativeObject>();
        Comment comment = rhinoNode.getJsDocNode();
        if (comment != null) {
            this.seenComments.add(comment);
            leadingComments.add(this.comments.get(comment));
            info.put("leadingComments", AstBuilder.newArray(leadingComments));
        }
    }

    private void attachRemainingComments() {
        Integer syntaxStart = this.getSyntaxStart();
        ArrayList<NativeObject> leadingComments = new ArrayList<NativeObject>();
        ArrayList<NativeObject> trailingComments = new ArrayList<NativeObject>();
        SortedSet<Comment> allComments = this.root.getComments();
        if (allComments == null) {
            return;
        }
        for (Comment commentNode : allComments) {
            if (this.seenComments.contains(commentNode) || !this.isJsDocComment(commentNode)) continue;
            NativeObject nativeComment = this.comments.get(commentNode);
            List range = (List)nativeComment.get("range", (Scriptable)nativeComment);
            Integer start = (Integer)range.get(0);
            if (syntaxStart != null && start < syntaxStart) {
                leadingComments.add(nativeComment);
                continue;
            }
            trailingComments.add(nativeComment);
        }
        if (leadingComments.size() > 0) {
            this.ast.put("leadingComments", (Scriptable)this.ast, (Object)AstBuilder.newArray(leadingComments));
        }
        if (trailingComments.size() > 0) {
            this.ast.put("trailingComments", (Scriptable)this.ast, (Object)AstBuilder.newArray(trailingComments));
        }
    }

    private NativeObject createNode(Entry info) {
        String nodeId = (String)info.get("nodeId");
        AstNode rhinoNode = this.rhinoNodes.get(nodeId);
        NativeArray range = this.getRange(rhinoNode);
        info.put("range", range);
        info.put("loc", this.getLocation(rhinoNode));
        this.attachLeadingComments(rhinoNode, info);
        JsDocNode node = new JsDocNode(info);
        return node.getNativeObject();
    }

    private void processAllComments(AstRoot ast) {
        NodeVisitor visitor = new NodeVisitor(){

            public boolean visit(AstNode node) {
                NativeObject nativeComment = AstBuilder.this.processNode(node);
                AstBuilder.this.comments.put((Comment)node, nativeComment);
                AstBuilder.this.nativeComments.add(nativeComment);
                return true;
            }
        };
        ast.visitComments(visitor);
    }

    private String getRhinoNodeId(Node rhinoNode) {
        return "astnode" + rhinoNode.hashCode();
    }

    private NativeArray processNodeList(List<? extends AstNode> nodes) {
        ArrayList<NativeObject> newNodes = new ArrayList<NativeObject>();
        for (AstNode astNode : nodes) {
            newNodes.add(this.processNode(astNode));
        }
        return AstBuilder.newArray(newNodes);
    }

    private NativeArray processNodeChildren(AstNode rhinoNode) {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        for (Node current = rhinoNode.getFirstChild(); current != null; current = current.getNext()) {
            kids.add((AstNode)current);
        }
        return this.processNodeList(kids);
    }

    private NativeObject processNode(AstNode rhinoNode) {
        NativeObject node = null;
        String nodeId = this.getRhinoNodeId(rhinoNode);
        Entry info = new Entry();
        NodeTypes type = NodeTypes.valueOf(rhinoNode.shortName());
        info.put(NODE_ID, nodeId);
        this.rhinoNodes.put(nodeId, rhinoNode);
        switch (type) {
            case ArrayComprehension: {
                this.processArrayComprehension((ArrayComprehension)rhinoNode, info);
                break;
            }
            case ArrayComprehensionLoop: {
                this.processArrayComprehensionLoop((ArrayComprehensionLoop)rhinoNode, info);
                break;
            }
            case ArrayLiteral: {
                this.processArrayLiteral((ArrayLiteral)rhinoNode, info);
                break;
            }
            case Assignment: {
                this.processAssignment((Assignment)rhinoNode, info);
                break;
            }
            case AstRoot: {
                this.processAstRoot((AstRoot)rhinoNode, info);
                break;
            }
            case Block: {
                this.processBlock((Block)rhinoNode, info);
                break;
            }
            case BreakStatement: {
                this.processBreakStatement((BreakStatement)rhinoNode, info);
                break;
            }
            case CatchClause: {
                this.processCatchClause((CatchClause)rhinoNode, info);
                break;
            }
            case Comment: {
                NativeObject nativeComment = this.comments.get(rhinoNode);
                if (nativeComment != null) {
                    node = nativeComment;
                    break;
                }
                this.processComment((Comment)rhinoNode, info);
                break;
            }
            case ConditionalExpression: {
                this.processConditionalExpression((ConditionalExpression)rhinoNode, info);
                break;
            }
            case ContinueStatement: {
                this.processContinueStatement((ContinueStatement)rhinoNode, info);
                break;
            }
            case DoLoop: {
                this.processDoLoop((DoLoop)rhinoNode, info);
                break;
            }
            case ElementGet: {
                this.processElementGet((ElementGet)rhinoNode, info);
                break;
            }
            case EmptyExpression: {
                this.processEmptyExpression((EmptyExpression)rhinoNode, info);
                break;
            }
            case EmptyStatement: {
                this.processEmptyStatement((EmptyStatement)rhinoNode, info);
                break;
            }
            case ExpressionStatement: {
                this.processExpressionStatement((ExpressionStatement)rhinoNode, info);
                break;
            }
            case ForInLoop: {
                this.processForInLoop((ForInLoop)rhinoNode, info);
                break;
            }
            case ForLoop: {
                this.processForLoop((ForLoop)rhinoNode, info);
                break;
            }
            case FunctionCall: {
                this.processFunctionCall((FunctionCall)rhinoNode, info);
                break;
            }
            case FunctionNode: {
                this.processFunctionNode((FunctionNode)rhinoNode, info);
                break;
            }
            case IfStatement: {
                this.processIfStatement((IfStatement)rhinoNode, info);
                break;
            }
            case InfixExpression: {
                this.processInfixExpression((InfixExpression)rhinoNode, info);
                break;
            }
            case KeywordLiteral: {
                this.processKeywordLiteral((KeywordLiteral)rhinoNode, info);
                break;
            }
            case Label: {
                this.processLabel((Label)rhinoNode, info);
                break;
            }
            case LabeledStatement: {
                this.processLabeledStatement((LabeledStatement)rhinoNode, info);
                break;
            }
            case LetNode: {
                this.processLetNode((LetNode)rhinoNode, info);
                break;
            }
            case Name: {
                this.processName((Name)rhinoNode, info);
                break;
            }
            case NewExpression: {
                this.processNewExpression((NewExpression)rhinoNode, info);
                break;
            }
            case NumberLiteral: {
                this.processNumberLiteral((NumberLiteral)rhinoNode, info);
                break;
            }
            case ObjectLiteral: {
                this.processObjectLiteral((ObjectLiteral)rhinoNode, info);
                break;
            }
            case ObjectProperty: {
                this.processObjectProperty((ObjectProperty)rhinoNode, info);
                break;
            }
            case ParenthesizedExpression: {
                ParenthesizedExpression expr = (ParenthesizedExpression)rhinoNode;
                node = this.processNode(expr.getExpression());
                break;
            }
            case PropertyGet: {
                this.processPropertyGet((PropertyGet)rhinoNode, info);
                break;
            }
            case RegExpLiteral: {
                this.processRegExpLiteral((RegExpLiteral)rhinoNode, info);
                break;
            }
            case ReturnStatement: {
                this.processReturnStatement((ReturnStatement)rhinoNode, info);
                break;
            }
            case Scope: {
                this.processScope((Scope)rhinoNode, info);
                break;
            }
            case StringLiteral: {
                this.processStringLiteral((StringLiteral)rhinoNode, info);
                break;
            }
            case SwitchCase: {
                this.processSwitchCase((SwitchCase)rhinoNode, info);
                break;
            }
            case SwitchStatement: {
                this.processSwitchStatement((SwitchStatement)rhinoNode, info);
                break;
            }
            case ThrowStatement: {
                this.processThrowStatement((ThrowStatement)rhinoNode, info);
                break;
            }
            case TryStatement: {
                this.processTryStatement((TryStatement)rhinoNode, info);
                break;
            }
            case UnaryExpression: {
                this.processUnaryExpression((UnaryExpression)rhinoNode, info);
                break;
            }
            case VariableDeclaration: {
                this.processVariableDeclaration((VariableDeclaration)rhinoNode, info);
                break;
            }
            case VariableInitializer: {
                this.processVariableInitializer((VariableInitializer)rhinoNode, info);
                break;
            }
            case WhileLoop: {
                this.processWhileLoop((WhileLoop)rhinoNode, info);
                break;
            }
            case WithStatement: {
                this.processWithStatement((WithStatement)rhinoNode, info);
                break;
            }
            case Yield: {
                this.processYield((Yield)rhinoNode, info);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized node type " + rhinoNode.shortName() + " with source: " + rhinoNode.toSource());
            }
        }
        if (node == null) {
            node = this.createNode(info);
        }
        return node;
    }

    private void processArrayComprehension(ArrayComprehension rhinoNode, Entry info) {
        AstNode filter = rhinoNode.getFilter();
        info.put(TYPE, "ComprehensionExpression");
        info.put("body", this.processNode(rhinoNode.getResult()));
        info.put("blocks", this.processNodeList(rhinoNode.getLoops()));
        info.put("filter", filter == null ? filter : this.processNode(filter));
    }

    private void processArrayComprehensionLoop(ArrayComprehensionLoop rhinoNode, Entry info) {
        info.put(TYPE, "ComprehensionBlock");
        info.put("left", this.processNode(rhinoNode.getIterator()));
        info.put("right", this.processNode(rhinoNode.getIteratedObject()));
        info.put("each", rhinoNode.isForEach());
    }

    private void processArrayLiteral(ArrayLiteral rhinoNode, Entry info) {
        if (rhinoNode.isDestructuring()) {
            info.put(TYPE, "ArrayPattern");
        } else {
            info.put(TYPE, "ArrayExpression");
        }
        info.put("elements", this.processNodeList(rhinoNode.getElements()));
    }

    private void processAssignment(Assignment rhinoNode, Entry info) {
        info.put(TYPE, "AssignmentExpression");
        info.put("operator", AstNode.operatorToString(rhinoNode.getOperator()));
        info.put("left", this.processNode(rhinoNode.getLeft()));
        info.put("right", this.processNode(rhinoNode.getRight()));
    }

    private void processAstRoot(AstRoot rhinoNode, Entry info) {
        info.put(TYPE, "Program");
        info.put("body", this.processNodeChildren(rhinoNode));
    }

    private void processBlock(Block rhinoNode, Entry info) {
        info.put(TYPE, "BlockStatement");
        info.put("body", this.processNodeChildren(rhinoNode));
    }

    private void processBreakStatement(BreakStatement rhinoNode, Entry info) {
        Name label = rhinoNode.getBreakLabel();
        info.put(TYPE, "BreakStatement");
        info.put("label", label == null ? label : this.processNode(label));
    }

    private void processCatchClause(CatchClause rhinoNode, Entry info) {
        info.put(TYPE, "CatchClause");
        info.put("param", this.processNode(rhinoNode.getVarName()));
        info.put("body", this.processNode(rhinoNode.getBody()));
    }

    private void processComment(Comment rhinoNode, Entry info) {
        String comment = rhinoNode.getValue();
        info.put(TYPE, "Block");
        info.put("value", comment.length() > 2 ? comment.substring(2) : "");
        info.put("raw", rhinoNode.getValue());
    }

    private void processConditionalExpression(ConditionalExpression rhinoNode, Entry info) {
        info.put(TYPE, "ConditionalExpression");
        info.put("test", this.processNode(rhinoNode.getTestExpression()));
        info.put("consequent", this.processNode(rhinoNode.getTrueExpression()));
        info.put("alternate", this.processNode(rhinoNode.getFalseExpression()));
    }

    private void processContinueStatement(ContinueStatement rhinoNode, Entry info) {
        Name label = rhinoNode.getLabel();
        info.put(TYPE, "ContinueStatement");
        info.put("label", label == null ? label : this.processNode(label));
    }

    private void processDoLoop(DoLoop rhinoNode, Entry info) {
        info.put(TYPE, "DoWhileStatement");
        info.put("body", this.processNode(rhinoNode.getBody()));
        info.put("test", this.processNode(rhinoNode.getCondition()));
    }

    private void processElementGet(ElementGet rhinoNode, Entry info) {
        info.put(TYPE, "MemberExpression");
        info.put("computed", true);
        info.put("object", this.processNode(rhinoNode.getTarget()));
        info.put("property", this.processNode(rhinoNode.getElement()));
    }

    private void processEmptyExpression(EmptyExpression rhinoNode, Entry info) {
        info.put(TYPE, "EmptyStatement");
    }

    private void processEmptyStatement(EmptyStatement rhinoNode, Entry info) {
        info.put(TYPE, "EmptyStatement");
    }

    private void processExpressionStatement(ExpressionStatement rhinoNode, Entry info) {
        info.put(TYPE, "ExpressionStatement");
        info.put("expression", this.processNode(rhinoNode.getExpression()));
    }

    private void processForInLoop(ForInLoop rhinoNode, Entry info) {
        info.put(TYPE, "ForInStatement");
        info.put("left", this.processNode(rhinoNode.getIterator()));
        info.put("right", this.processNode(rhinoNode.getIteratedObject()));
        info.put("body", this.processNode(rhinoNode.getBody()));
        info.put("each", rhinoNode.isForEach());
    }

    private void processForLoop(ForLoop rhinoNode, Entry info) {
        info.put(TYPE, "ForStatement");
        info.put("init", this.processNode(rhinoNode.getInitializer()));
        info.put("test", this.processNode(rhinoNode.getCondition()));
        info.put("update", this.processNode(rhinoNode.getIncrement()));
        info.put("body", this.processNode(rhinoNode.getBody()));
    }

    private void processFunctionCall(FunctionCall rhinoNode, Entry info) {
        info.put(TYPE, "CallExpression");
        info.put("callee", this.processNode(rhinoNode.getTarget()));
        info.put("arguments", this.processNodeList(rhinoNode.getArguments()));
    }

    private void processFunctionNode(FunctionNode rhinoNode, Entry info) {
        Name id = rhinoNode.getFunctionName();
        info.put(TYPE, rhinoNode.getFunctionType() == 2 ? "FunctionExpression" : "FunctionDeclaration");
        info.put("id", id == null ? id : this.processNode(id));
        info.put("params", this.processNodeList(rhinoNode.getParams()));
        info.put("defaults", AstBuilder.newArray(0));
        info.put("body", this.processNode(rhinoNode.getBody()));
        info.put("rest", null);
        info.put("generator", rhinoNode.isGenerator());
        info.put("expression", rhinoNode.isExpressionClosure());
    }

    private void processIfStatement(IfStatement rhinoNode, Entry info) {
        AstNode alternate = rhinoNode.getElsePart();
        info.put(TYPE, "IfStatement");
        info.put("test", this.processNode(rhinoNode.getCondition()));
        info.put("consequent", this.processNode(rhinoNode.getThenPart()));
        info.put("alternate", alternate == null ? alternate : this.processNode(alternate));
    }

    private void processInfixExpression(InfixExpression rhinoNode, Entry info) {
        info.put(TYPE, "BinaryExpression");
        info.put("operator", AstNode.operatorToString(rhinoNode.getOperator()));
        info.put("left", this.processNode(rhinoNode.getLeft()));
        info.put("right", this.processNode(rhinoNode.getRight()));
    }

    private void processKeywordLiteral(KeywordLiteral rhinoNode, Entry info) {
        int tokenType = rhinoNode.getType();
        String type = null;
        switch (tokenType) {
            case 45: {
                info.put("value", true);
                info.put("raw", "true");
                break;
            }
            case 44: {
                info.put("value", false);
                info.put("raw", "false");
                break;
            }
            case 42: {
                info.put("value", null);
                info.put("raw", "null");
                break;
            }
            case 160: {
                type = "DebuggerStatement";
                break;
            }
            case 43: {
                type = "ThisExpression";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized KeywordLiteral: " + rhinoNode.toSource() + " (token type: Token." + Token.typeToName(tokenType) + ")");
            }
        }
        if (type == null) {
            type = "Literal";
        }
        info.put(TYPE, type);
    }

    private void processLabel(Label rhinoNode, Entry info) {
        info.put(TYPE, "Identifier");
        info.put("name", rhinoNode.getName());
    }

    private void processLabeledStatement(LabeledStatement rhinoNode, Entry info) {
        info.put(TYPE, "LabeledStatement");
        List<Label> labels = rhinoNode.getLabels();
        info.put("label", this.processNode(labels.get(labels.size() - 1)));
        info.put("body", this.processNode(rhinoNode.getStatement()));
    }

    private void processLetNode(LetNode rhinoNode, Entry info) {
        info.put(TYPE, "LetStatement");
        info.put("head", this.processNode(rhinoNode.getVariables()));
        info.put("body", this.processNode(rhinoNode.getBody()));
    }

    private void processName(Name rhinoNode, Entry info) {
        info.put(TYPE, "Identifier");
        info.put("name", rhinoNode.getIdentifier());
    }

    private void processNewExpression(NewExpression rhinoNode, Entry info) {
        info.put(TYPE, "NewExpression");
        info.put("callee", this.processNode(rhinoNode.getTarget()));
        info.put("arguments", this.processNodeList(rhinoNode.getArguments()));
    }

    private void processNumberLiteral(NumberLiteral rhinoNode, Entry info) {
        info.put(TYPE, "Literal");
        info.put("value", rhinoNode.getNumber());
        info.put("raw", rhinoNode.getValue());
    }

    private void processObjectLiteral(ObjectLiteral rhinoNode, Entry info) {
        if (rhinoNode.isDestructuring()) {
            info.put(TYPE, "ObjectPattern");
        } else {
            info.put(TYPE, "ObjectExpression");
        }
        info.put("properties", this.processNodeList(rhinoNode.getElements()));
    }

    private void processObjectProperty(ObjectProperty rhinoNode, Entry info) {
        info.put(TYPE, "Property");
        info.put("key", this.processNode(rhinoNode.getLeft()));
        info.put("value", this.processNode(rhinoNode.getRight()));
        info.put("kind", rhinoNode.isGetter() ? "get" : (rhinoNode.isSetter() ? "set" : "init"));
    }

    private void processPropertyGet(PropertyGet rhinoNode, Entry info) {
        info.put(TYPE, "MemberExpression");
        info.put("computed", false);
        info.put("object", this.processNode(rhinoNode.getTarget()));
        info.put("property", this.processNode(rhinoNode.getProperty()));
    }

    private void processRegExpLiteral(RegExpLiteral rhinoNode, Entry info) {
        info.put(TYPE, "Literal");
        String value = rhinoNode.toSource(0);
        info.put("value", value);
        info.put("raw", value);
    }

    private void processReturnStatement(ReturnStatement rhinoNode, Entry info) {
        AstNode argument = rhinoNode.getReturnValue();
        info.put(TYPE, "ReturnStatement");
        info.put("argument", argument == null ? argument : this.processNode(argument));
    }

    private void processScope(Scope rhinoNode, Entry info) {
        info.put(TYPE, "BlockStatement");
        info.put("body", this.processNodeChildren(rhinoNode));
    }

    private void processStringLiteral(StringLiteral rhinoNode, Entry info) {
        info.put(TYPE, "Literal");
        info.put("value", rhinoNode.getValue(false));
        info.put("raw", rhinoNode.getValue(true));
    }

    private void processSwitchCase(SwitchCase rhinoNode, Entry info) {
        AstNode test = rhinoNode.getExpression();
        List<AstNode> statements = rhinoNode.getStatements();
        NativeArray consequent = statements == null ? AstBuilder.newArray(0) : this.processNodeList(statements);
        info.put(TYPE, "SwitchCase");
        info.put("test", test == null ? test : this.processNode(test));
        info.put("consequent", consequent);
    }

    private void processSwitchStatement(SwitchStatement rhinoNode, Entry info) {
        info.put(TYPE, "SwitchStatement");
        info.put("discriminant", this.processNode(rhinoNode.getExpression()));
        info.put("cases", this.processNodeList(rhinoNode.getCases()));
    }

    private void processThrowStatement(ThrowStatement rhinoNode, Entry info) {
        info.put(TYPE, "ThrowStatement");
        info.put("argument", this.processNode(rhinoNode.getExpression()));
    }

    private void processTryStatement(TryStatement rhinoNode, Entry info) {
        AstNode finalizer = rhinoNode.getFinallyBlock();
        CatchClause handler = null;
        List<CatchClause> catchClauses = rhinoNode.getCatchClauses();
        ArrayList<CatchClause> guardedHandlers = new ArrayList<CatchClause>();
        Iterator<CatchClause> iterator = catchClauses.iterator();
        while (iterator.hasNext()) {
            CatchClause current = iterator.next();
            if (current.getIfPosition() == -1) {
                handler = current;
                iterator.remove();
                continue;
            }
            guardedHandlers.add(current);
        }
        info.put(TYPE, "TryStatement");
        info.put("block", this.processNode(rhinoNode.getTryBlock()));
        info.put("handler", handler == null ? handler : this.processNode(handler));
        info.put("guardedHandlers", this.processNodeList(guardedHandlers));
        info.put("finalizer", finalizer == null ? finalizer : this.processNode(finalizer));
    }

    private void processUnaryExpression(UnaryExpression rhinoNode, Entry info) {
        int op = rhinoNode.getOperator();
        String opString = null;
        if (op == 106 || op == 107) {
            info.put(TYPE, "UpdateExpression");
        } else {
            info.put(TYPE, "UnaryExpression");
        }
        info.put("prefix", rhinoNode.isPrefix());
        opString = op == 126 ? "void" : AstNode.operatorToString(op);
        info.put("operator", opString);
        info.put("argument", this.processNode(rhinoNode.getOperand()));
    }

    private void processVariableDeclaration(VariableDeclaration rhinoNode, Entry info) {
        info.put(TYPE, "VariableDeclaration");
        info.put("declarations", this.processNodeList(rhinoNode.getVariables()));
        info.put("kind", Token.typeToName(rhinoNode.getType()).toLowerCase());
    }

    private void processVariableInitializer(VariableInitializer rhinoNode, Entry info) {
        AstNode initializer = rhinoNode.getInitializer();
        info.put(TYPE, "VariableDeclarator");
        info.put("id", this.processNode(rhinoNode.getTarget()));
        info.put("init", initializer == null ? initializer : this.processNode(initializer));
    }

    private void processWhileLoop(WhileLoop rhinoNode, Entry info) {
        info.put(TYPE, "WhileStatement");
        info.put("test", this.processNode(rhinoNode.getCondition()));
        info.put("body", this.processNode(rhinoNode.getBody()));
    }

    private void processWithStatement(WithStatement rhinoNode, Entry info) {
        info.put(TYPE, "WithStatement");
        info.put("object", this.processNode(rhinoNode.getExpression()));
        info.put("body", this.processNode(rhinoNode.getStatement()));
    }

    private void processYield(Yield rhinoNode, Entry info) {
        AstNode argument = rhinoNode.getValue();
        info.put(TYPE, "YieldExpression");
        info.put("argument", argument == null ? argument : this.processNode(argument));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry
    extends HashMap<Object, Object> {
        private static final long serialVersionUID = -2407765489150389060L;

        Entry() {
        }
    }

    class JsDocNode {
        public static final String ARRAY_EXPRESSION = "ArrayExpression";
        public static final String ARRAY_PATTERN = "ArrayPattern";
        public static final String ASSIGNMENT_EXPRESSION = "AssignmentExpression";
        public static final String BINARY_EXPRESSION = "BinaryExpression";
        public static final String BLOCK = "Block";
        public static final String BLOCK_STATEMENT = "BlockStatement";
        public static final String BREAK_STATEMENT = "BreakStatement";
        public static final String CALL_EXPRESSION = "CallExpression";
        public static final String CATCH_CLAUSE = "CatchClause";
        public static final String COMPREHENSION_BLOCK = "ComprehensionBlock";
        public static final String COMPREHENSION_EXPRESSION = "ComprehensionExpression";
        public static final String CONDITIONAL_EXPRESSION = "ConditionalExpression";
        public static final String CONTINUE_STATEMENT = "ContinueStatement";
        public static final String DEBUGGER_STATEMENT = "DebuggerStatement";
        public static final String DO_WHILE_STATEMENT = "DoWhileStatement";
        public static final String EMPTY_STATEMENT = "EmptyStatement";
        public static final String EXPRESSION_STATEMENT = "ExpressionStatement";
        public static final String FOR_IN_STATEMENT = "ForInStatement";
        public static final String FOR_OF_STATEMENT = "ForOfStatement";
        public static final String FOR_STATEMENT = "ForStatement";
        public static final String FUNCTION_DECLARATION = "FunctionDeclaration";
        public static final String FUNCTION_EXPRESSION = "FunctionExpression";
        public static final String IDENTIFIER = "Identifier";
        public static final String IF_STATEMENT = "IfStatement";
        public static final String LABELED_STATEMENT = "LabeledStatement";
        public static final String LET_STATEMENT = "LetStatement";
        public static final String LITERAL = "Literal";
        public static final String LOGICAL_EXPRESSION = "LogicalExpression";
        public static final String MEMBER_EXPRESSION = "MemberExpression";
        public static final String NEW_EXPRESSION = "NewExpression";
        public static final String OBJECT_EXPRESSION = "ObjectExpression";
        public static final String OBJECT_PATTERN = "ObjectPattern";
        public static final String PROGRAM = "Program";
        public static final String PROPERTY = "Property";
        public static final String RETURN_STATEMENT = "ReturnStatement";
        public static final String SEQUENCE_EXPRESSION = "SequenceExpression";
        public static final String SWITCH_CASE = "SwitchCase";
        public static final String SWITCH_STATEMENT = "SwitchStatement";
        public static final String THIS_EXPRESSION = "ThisExpression";
        public static final String THROW_STATEMENT = "ThrowStatement";
        public static final String TRY_STATEMENT = "TryStatement";
        public static final String UNARY_EXPRESSION = "UnaryExpression";
        public static final String UPDATE_EXPRESSION = "UpdateExpression";
        public static final String VARIABLE_DECLARATION = "VariableDeclaration";
        public static final String VARIABLE_DECLARATOR = "VariableDeclarator";
        public static final String WHILE_STATEMENT = "WhileStatement";
        public static final String WITH_STATEMENT = "WithStatement";
        public static final String YIELD_EXPRESSION = "YieldExpression";
        private static final int DONTENUM = 2;
        private static final int EMPTY = 0;
        private final Object UNDEFINED = Undefined.instance;
        private NativeObject node = AstBuilder.newObject();

        public JsDocNode() {
            for (Properties properties : Properties.values()) {
                this.node.defineProperty(properties.getPropertyName(), this.UNDEFINED, 0);
            }
            for (Enum enum_ : HiddenProperties.values()) {
                this.node.defineProperty(((HiddenProperties)enum_).getPropertyName(), this.UNDEFINED, 2);
            }
        }

        public JsDocNode(Entry info) {
            this();
            Set entrySet = info.entrySet();
            for (Map.Entry item : entrySet) {
                this.node.put((String)item.getKey(), (Scriptable)this.node, item.getValue());
            }
        }

        public final Object get(String key) {
            return this.node.get(key, (Scriptable)this.node);
        }

        public final void put(String key, Object value) {
            this.node.put(key, (Scriptable)this.node, value);
        }

        public final NativeObject getNativeObject() {
            return this.node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HiddenProperties {
        NODE_ID("nodeId");

        private String propertyName;

        private HiddenProperties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Properties {
        TYPE("type");

        private String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeTypes {
        ArrayComprehension,
        ArrayComprehensionLoop,
        ArrayLiteral,
        Assignment,
        AstRoot,
        Block,
        BreakStatement,
        CatchClause,
        Comment,
        ConditionalExpression,
        ContinueStatement,
        DoLoop,
        ElementGet,
        EmptyExpression,
        EmptyStatement,
        ExpressionStatement,
        ForInLoop,
        ForLoop,
        FunctionCall,
        FunctionNode,
        IfStatement,
        InfixExpression,
        KeywordLiteral,
        Label,
        LabeledStatement,
        LetNode,
        Name,
        NewExpression,
        NumberLiteral,
        ObjectLiteral,
        ObjectProperty,
        ParenthesizedExpression,
        PropertyGet,
        RegExpLiteral,
        ReturnStatement,
        Scope,
        StringLiteral,
        SwitchCase,
        SwitchStatement,
        ThrowStatement,
        TryStatement,
        UnaryExpression,
        VariableDeclaration,
        VariableInitializer,
        WhileLoop,
        WithStatement,
        Yield;

    }
}

