#title: 如何创建 DataSource
#author:zozoh(zozohtnt@gmail.com)
#author:wendal(wendal1985@gmail.com)
#index:0,1
--------------------------------------------------------------------------------------
Apache DBCP
	dbcp: 直接书写 Java 代码
		{{{<Java>
		import org.apache.commons.dbcp.BasicDataSource;
		
		...
		
		BasicDataSource ds = new BasicDataSource();
		ds.setDriverClassName("org.postgresql.Driver");
		ds.setUrl("jdbc:postgresql://localhost:5432/mydatabase");
		ds.setUsername("demo");
		ds.setPassword("123456");
		...
		ds.close();  // 关闭池内所有连接
		}}}
	dbcp: 通过 Nutz.Ioc 的 JSON 配置文件
		{{{<IOC-JSON 配置>
		{
			dataSource : {
				type : "org.apache.commons.dbcp.BasicDataSource",
				events : {
					depose : 'close'
				},
				fields : {
					driverClassName : 'org.postgresql.Driver',
					url : 'jdbc:postgresql://localhost:5432/mydatabase',
					username : 'demo',
					password : '123456'
				}
			}
		}
		}}}
	dbcp: 通过 Nutz.Ioc 的 XML 配置文件
		{{{<IOC-XML 配置>
			<ioc xsi:noNamespaceSchemaLocation="nutz-ioc-0.1.xsd">
				<obj name="dataSource" type="org.apache.commons.dbcp.BasicDataSource">
					<events>
						<depose>close</depose>
					</events>
					<field name="driverClassName"><str>org.postgresql.Driver</str></field>
					<field name="url"><str>jdbc:postgresql://localhost:5432/mydatabase</str></field>
					<field name="username"><str>demo</str></field>
					<field name="password"><str>123456</str></field>
				</obj>
			</ioc>
		}}}
		 * 注册了 depose 事件，当整个 Ioc 容器注销时，将 {*真正 }  关闭所有池内连接
		 * 关于 depose 事件，更多详情请参看 [../ioc/events.man 事件监听]
--------------------------------------------------------------------------------------
C3P0
	c3p0: 直接书写 Java 代码
		{{{<Java>
		import com.mchange.v2.c3p0.ComboPooledDataSource;
		
		...
		
		ComboPooledDataSource ds = new ComboPooledDataSource();
		ds.setDriverClass("org.postgresql.Driver");
		ds.setJdbcUrl("jdbc:postgresql://localhost:5432/mydatabase");
		ds.setUser("demo");
		ds.setPassword("123456");
		...
		ds.close();  // 关闭池内所有连接
		}}}
	c3p0: 通过 Nutz.Ioc 的 JSON 配置文件
		{{{<IOC-JSON 配置>
		{
			dataSource : {
				type : "com.mchange.v2.c3p0.ComboPooledDataSource",
				events : {
					depose : 'close'
				},
				fields : {
					driverClass : 'org.postgresql.Driver',
					jdbcUrl : 'jdbc:postgresql://localhost:5432/mydatabase',
					user : 'demo',
					password : '123456'
				}
			}
		}
		}}}
	c3p0: 通过 Nutz.Ioc 的 XML 配置文件
		{{{<IOC-XML 配置>
			<ioc xsi:noNamespaceSchemaLocation="nutz-ioc-0.1.xsd">
				<obj name="dataSource" type="com.mchange.v2.c3p0.ComboPooledDataSource">
					<events>
						<depose>close</depose>
					</events>
					<field name="driverClass"><str>org.postgresql.Driver</str></field>
					<field name="jdbcUrl"><str>jdbc:postgresql://localhost:5432/mydatabase</str></field>
					<field name="user"><str>demo</str></field>
					<field name="password"><str>123456</str></field>
				</obj>
			</ioc>
		}}}
		 * 注册了 depose 事件，当整个 Ioc 容器注销时，将 {*真正 }  关闭所有池内连接
--------------------------------------------------------------------------------------
Proxool
	proxool: 直接书写 Java 代码
		{{{<Java>
		import org.logicalcobwebs.proxool.ProxoolDataSource;
		
		...
		
		ProxoolDataSource ds = new ProxoolDataSource();
		ds.setDriver("org.postgresql.Driver");
		ds.setDriverUrl("jdbc:postgresql://localhost:5432/mydatabase");
		ds.setUser("demo");
		ds.setPassword("123456");
		...
		}}}
	proxool: 通过 Nutz.Ioc 的 JSON 配置文件
		{{{<IOC-JSON 配置>
		{
			dataSource : {
				type : "org.logicalcobwebs.proxool.ProxoolDataSource",
				fields : {
					driver : 'org.postgresql.Driver',
					driverUrl : 'jdbc:postgresql://localhost:5432/mydatabase',
					user : 'demo',
					password : '123456'
				}
			}
		}
		}}}
	proxool: 通过 Nutz.Ioc 的 XML 配置文件
		{{{<IOC-XML 配置>
			<ioc xsi:noNamespaceSchemaLocation="nutz-ioc-0.1.xsd">
				<obj name="dataSource" type="org.logicalcobwebs.proxool.ProxoolDataSource">
					<field name="driver"><str>org.postgresql.Driver</str></field>
					<field name="driverUrl"><str>jdbc:postgresql://localhost:5432/mydatabase</str></field>
					<field name="user"><str>demo</str></field>
					<field name="password"><str>123456</str></field>
				</obj>
			</ioc>
		}}}
		 * Proxool 没有提供关闭所有连接的函数，不过你可以参看它的官方文档，自己写一个释放所有连接的类，配置在 Ioc 容器的 depose 事件中
		 * 关于 depose 事件，更多详情请参看 [../ioc/events.man 事件监听] - {*通过实现一个触发器}
--------------------------------------------------------------------------------------
BoneCP
	bonecp: 直接书写 Java 代码
		{{{<Java>
		import com.jolbox.bonecp.BoneCPDataSource;
		
		...
		
		BoneCPDataSource ds = new BoneCPDataSource();
		ds.setDriver("org.postgresql.Driver");
		ds.setJdbcUrl("jdbc:postgresql://localhost:5432/mydatabase");
		ds.setUsername("demo");
		ds.setPassword("123456");
		...
		
		}}}
	bonecp: 通过 Nutz.Ioc 的 JSON 配置文件
		{{{<IOC-JSON 配置>
		{
			dataSource : {
				type : "com.jolbox.bonecp.BoneCPDataSource",
				events : {
					depose : 'close'
				},
				fields : {
					driverClass : 'org.postgresql.Driver',
					jdbcUrl : 'jdbc:postgresql://localhost:5432/mydatabase',
					username : 'demo',
					password : '123456'
				}
			}
		}
		}}}
	bonecp: 通过 Nutz.Ioc 的 XML 配置文件
		{{{<IOC-XML 配置>
			<ioc xsi:noNamespaceSchemaLocation="nutz-ioc-0.1.xsd">
				<obj name="dataSource" type="com.jolbox.bonecp.BoneCPDataSource">
					<events>
						<depose>close</depose>
					</events>
					<field name="driverClass"><str>org.postgresql.Driver</str></field>
					<field name="url"><str>jdbc:postgresql://localhost:5432/mydatabase</str></field>
					<field name="username"><str>demo</str></field>
					<field name="password"><str>123456</str></field>
				</obj>
			</ioc>
		}}}
		 * 注册了 depose 事件，当整个 Ioc 容器注销时，将 {*真正 }  关闭所有池内连接