#title: 本地化字符串
#index:0,1
------------------------------------------------------------------------------------------
基本策略
	每个 Mvc 框架都有自己的本地化字符串的解决方案， Nutz.Mvc 的这个是相当简陋的。
	我只是个人觉得足够用了。下面我把它简单介绍一下：
	
	 * 假定所有的本地化字符串文件都会存放在某一目录下
		 * 这个目录下所有的 .properties 文件，将作为默认的本地字符串文件。
		 * 每一种语言都会是一个目录，目录名称对应一个 Locale 的 toString()，请参看 java.util.Locale 的 JDoc
			 * 比如简体中文，就是 zh_CN
			 * 比如美式英语，就是 en_US
		 * 目录下所有的 .properties 文件存放着该地区的字符串信息
		 *  .properties 文件需要按照 UTF-8 方式编码
	 * 目录，通过 @Localization("全路径") 声明在主模块上
	 * 当应用启动时，一次读入所有的字符串，并存入 ServletContext，属性名称为：“org.nutz.mvc.annotation.Localization”
	 * 应用可以自行设置当前 Session 是哪一个国家和地区
		 * Mvcs.setLocaleName(String localeName)
	 * 每次请求时，会根据 Session 中的 localeName，从 ServletContext 中将对应 Locale 的字符串取出，设入 Request 对象
		 * 属性名为 "msg"
		 * 如果当前会话没有被设置 Locale，则将 "msg" 设置成默认本地化字符串
------------------------------------------------------------------------------------------
使用方式
	在主模块上声明
		比如：
		{{{
		...
		@Localization("mymsg")
		public class MyMainClass {
			...
		}}}
		 * 在主模块上声明 `@Localization` 注解，指向一个目录
		 * 在目录下建立文件夹，比如 {*zh_CN}，每个目录下所有 {* .properties} 文件都会被当作字符串文件
		 * {* .properties} 文件 一定要是 UTF-8 编码的
		 * 比如 `@Locallization("mymsg")` 会指向 CLASSPATH 下的 {*mymsg} 目录
	
	在 JSP 里使用
		{*直接 Scriptlet}
		{{{
		...
		<h1><%=((Map<String,String>)request.getObject("msg")).get("my.msg.key")%></h1>
		...
		}}}
		
		{*采用 JSTL}
		{{{
		...
		<h1>${msg['my.msg.key']}</h1>
		...
		}}}
		 
	我到底支持哪些语言
		
		请参看 {*org.nutz.mvc.Mvcs} 的 JavaDoc，这里我列几个常用的方法:
		
		|| Mvcs.getLocaleName(HttpSession session)					|| 获取当前会话的 Locale 名称 ||
		|| Mvcs.setLocaleName(HttpSession session, String name)		|| 为当前会话设置 Locale 的名称 ||
		|| Mvcs.getLocaleNames(ServletContext context)			 	|| 获取整个应用可用的 Locale 名称集合 ||
		|| Mvcs.hasLocaleName(HttpSession session)					|| 判断当前会话是够设置了特殊的 Locale 的名称 ||
		|| Mvcs.hasLocale(HttpSession session)						|| 判断当前会话是否已经设置了本地字符串表 ||
		
		
------------------------------------------------------------------------------------------
使用过滤器
	有些是由，你想让你的 JSP 文件 (不是通过 Nutz.Mvc 入口函数访问的)也可以使用"{*本地化字符串}"
	功能，那么你需要在 web.xml 这么配置:
	{{{
	<!--
		Nutz.Mvc 还提供了一个过滤器，你可以用这个过滤器为所有的直接访问的 jsp 设置必要的 Request 属性。 比如 ${base}
		以及 ${msg}
	-->
	<filter>
		<filter-name>msgs</filter-name>
		<filter-class>org.nutz.mvc.NutFilter</filter-class>
	</filter>

	<filter-mapping>
		<filter-name>msgs</filter-name>
		<url-pattern>*.jsp</url-pattern>
	</filter-mapping>

	<filter-mapping>
		<filter-name>msgs</filter-name>
		<url-pattern>*.jspx</url-pattern>
	</filter-mapping>
	}}}
	
------------------------------------------------------------------------------------------
定制自己的本地化字符串方式
	很简单是吗？ 你想将 Message 字符串存在 XML 里，或者你想换一种 Message 字符串的存储方式。
	那么实现一个新的 {*org.nutz.mvc.MessageLoader}，并在 @Localization 注解的 type 属性中注明就是了。
	不过你的实现类必须有一个接受一个 String 类型参数的构造函数，以便 Nutz.Mvc 为你传入 @Localization 里面声明
	的值。